A constant value failed to get evaluated.

Erroneous code example:

```compile_fail,E0080
enum Enum {
    X = (1 << 500),
    Y = (1 / 0),
}
```

This error indicates that the compiler was unable to sensibly evaluate a
constant expression that had to be evaluated. Attempting to divide by 0
or causing an integer overflow are two ways to induce this error.

Ensure that the expressions given can be evaluated as the desired integer type.
See the FFI section of the Reference for more information about using a custom
integer type:

https://doc.rust-lang.org/reference.html#ffi-attributes
