/* PrismFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;
import org.grinvin.graphs.Annotation;
import org.grinvin.graphs.Embedding;
import org.grinvin.graphs.Graph;
import org.grinvin.graphs.Vertex;

/**
 * Factory that creates prism graphs with a given base cycle length.
 */
public class PrismFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding, Annotation annotation) {
        int length = ((Integer)values[0]).intValue();
        Vertex[] vertices = createCycle(graph, embedding, length);
        Vertex[] newVertices = new Vertex[length];
        
        for(int i=0; i<length; i++) {
            double coord[] = embedding.getCoordinates(vertices[i]);
            newVertices[i] = graph.addNewVertex();
            embedding.setCoordinates(newVertices[i], new double[] { coord[0] / 2, coord[1] / 2 });
            graph.addNewEdge(vertices[i], newVertices[i]);
        }
        
        for(int i=1; i<length; i++) {
            graph.addNewEdge(vertices[i-1], vertices[i]);
            graph.addNewEdge(newVertices[i-1], newVertices[i]);
        }
        graph.addNewEdge(vertices[length-1], vertices[0]);
        graph.addNewEdge(newVertices[length-1], newVertices[0]);
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        if (((Integer)values[0]).intValue() < 3)
            throw new FactoryParameterException("The length of the base cycle should be at least 3");
    }
    
}
