// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-iteration-statements
es6id: 13.7
description: >
  The token sequence `let [`is interpreted as the beginning of a destructuring
  binding pattern
info: |
  Syntax

  IterationStatement[Yield, Return]:

    for ( [lookahead ∉ { let [ } ] LeftHandSideExpression[?Yield] in
      Expression[+In, ?Yield] ) Statement[?Yield, ?Return]

    for ( ForDeclaration[?Yield] in Expression[+In, ?Yield] )
      Statement[?Yield, ?Return]
---*/

var obj = Object.create(null);
var value;

obj.key = 1;

for ( let[x] in obj ) {
  value = x;
}

assert.sameValue(typeof x, 'undefined', 'binding is block-scoped');
assert.sameValue(value, 'k');

reportCompare(0, 0);
