# How to utilize multiple DNS API keys

As for now, the dns api key/secret is saved in the global `account.conf` file, so that it can be reused for any of the domains in your account.

So, what if you have multiple dns api keys.  The key point is to use multiple `account.conf` file.

You can use either of the following ways:

## 1. Use muitlple linux users to install and use acme.sh

It's the easiest way to use.  You can just create multiple Linux users, and install and use acme.sh for each users:

```
su  acmeuser1

curl https://get.acme.sh | sh -s email=my@example.com

source ~/.acme.sh/acme.sh.env

export MYDNS_APIKey1=xxxxxxx

acme.sh --issue -d domain1.com --dns ........
```

And then switch to another user:

```
su  acmeuser2

curl https://get.acme.sh | sh -s email=my@example.com

source ~/.acme.sh/acme.sh.env

export MYDNS_APIKey2=xxxxxxx

acme.sh --issue -d domain1.com --dns ........
```


## 2.  Use multiple `--config-home`

The global `account.conf` file is saved in the `--config-home` by default.  So, you can use different `--config-home`.


```
curl https://get.acme.sh | sh -s email=my@example.com

```

The default config home is at `~/.acme.sh`.

You can specify a custom config home on any of the acme.sh commands:

```

export MY_DNS_key2=xxxxxxx
acme.sh  --config-home ~/.myacme   --issue  -d example.com ......

```

Every time you want to use the `MY_DNS_key2` to issue certs,  you need to use the `--config-home` parameter:

```
acme.sh  --config-home ~/.myacme   --issue .....

acme.sh  --config-home ~/.myacme   --renew ......

acme.sh  --config-home ~/.myacme   --revoke .....


```


You will also need to add a new crontab entry to make it renew automatically:

```
30 0 * * * "/root/.acme.sh"/acme.sh --cron --home "/root/.acme.sh"  --config-home "/root/.myacme"    > /dev/null
```






