/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.JiapiRuntimeException;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.reflect.BasicBlock;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionFactory;
import net.sf.jiapi.reflect.JiapiMethod;
import net.sf.jiapi.reflect.SwitchInstruction;
import net.sf.jiapi.reflect.instruction.CPInstruction;

public class InstructionList {
    private JiapiMethod declaringMethod;
    ConstantPool constantPool;
    List<Instruction> instructions;

    public InstructionList() {
        this.constantPool = new ConstantPool();
        this.instructions = new LinkedList<Instruction>();
    }

    InstructionList(byte[] byteCode, ConstantPool cp) {
        this.constantPool = cp;
        InstructionFactory factory = new InstructionFactory(cp);
        this.instructions = factory.createInstructionList(byteCode);
    }

    private InstructionList(ConstantPool cp, List<Instruction> instructions) {
        this.constantPool = cp;
        this.instructions = instructions;
    }

    InstructionList(ConstantPool cp) {
        this.constantPool = cp;
        this.instructions = new LinkedList<Instruction>();
    }

    public InstructionList createEmptyList() {
        return new InstructionList(this.constantPool);
    }

    public byte[] getBytes() {
        int bSize = 0;
        for (Instruction i : this.instructions) {
            bSize += i.length();
        }
        byte[] bytes = new byte[bSize];
        int bIdx = 0;
        for (Instruction ins : this.instructions) {
            byte[] iBytes = ins.getBytes();
            for (int j = 0; j < iBytes.length; ++j) {
                bytes[bIdx] = iBytes[j];
                ++bIdx;
            }
        }
        return bytes;
    }

    public void add(Instruction i) {
        CPInstruction cpIns;
        ConstantPool cp;
        i.setAttribute("synthetic");
        if (i instanceof CPInstruction && !this.constantPool.equals(cp = (cpIns = (CPInstruction)i).getConstantPool())) {
            cpIns.replaceConstantPool(this.constantPool);
        }
        this.instructions.add(i);
    }

    public void add(InstructionList il) {
        if (il.size() == 0) {
            return;
        }
        for (int i = 0; i < il.size(); ++i) {
            BranchInstruction bIns;
            int idx;
            Instruction ins = il.get(i);
            if (!(ins instanceof BranchInstruction) || (idx = il.indexOf((bIns = (BranchInstruction)ins).getTarget())) == -1) {
                // empty if block
            }
            this.add(ins);
        }
    }

    public boolean insert(int idx, Instruction i) {
        CPInstruction cpIns;
        ConstantPool cp;
        i.setAttribute("synthetic");
        if (i instanceof CPInstruction && !this.constantPool.equals(cp = (cpIns = (CPInstruction)i).getConstantPool())) {
            cpIns.replaceConstantPool(this.constantPool);
        }
        return this.instructions.subList(0, idx).add(i);
    }

    public boolean insert(int idx, InstructionList il) {
        if (il.size() == 0) {
            return true;
        }
        for (int i = 0; i < il.size(); ++i) {
            int __idx;
            Instruction ins = il.get(i);
            if (!(ins instanceof BranchInstruction) || (__idx = il.indexOf(((BranchInstruction)ins).getTarget())) == -1) {
                // empty if block
            }
            this.insert(idx + i, il.get(i));
        }
        return true;
    }

    public Instruction get(int i) {
        Instruction ins = this.instructions.get(i);
        return ins;
    }

    public void replace(int idx, Instruction i) {
        if (i == null) {
            throw new NullPointerException("Instruction may not be null");
        }
        this.instructions.set(idx, i);
    }

    public void replace(InstructionList il) {
        this.replace(0, this.size(), il);
    }

    public void replace(int start, int end, InstructionList il) {
        int su2;
        InstructionList __il = this.createView(start, end);
        int su1 = __il.stackUsage();
        if (su1 != (su2 = il.stackUsage())) {
            System.out.println("Replacing ");
            this.print(__il);
            System.out.println("with");
            this.print(il);
            throw new IllegalArgumentException("Cannot replace instruction list; stack usages differ: " + su1 + "(this list), " + su2 + " (other list)");
        }
        Instruction first = __il.instructions.get(0);
        List<BranchInstruction> l = this.findBranchesForTarget(first);
        for (BranchInstruction bIns : l) {
            bIns.setTarget(il.get(0));
        }
        __il.clear();
        __il.add(il);
    }

    public int stackUsage() {
        int su = 0;
        for (int i = 0; i < this.size(); ++i) {
            su += this.get(i).stackUsage();
        }
        return su;
    }

    public int size() {
        return this.instructions.size();
    }

    public int indexOf(Instruction ins) {
        return this.instructions.indexOf(ins);
    }

    public int indexOf(byte opcode) {
        return this.indexOf(new byte[]{opcode}, 0);
    }

    public int indexOf(byte opcode, int fromIndex) {
        return this.indexOf(new byte[]{opcode}, fromIndex);
    }

    public int indexOf(byte[] opcodes, int fromIndex) {
        for (int i = fromIndex; i < this.instructions.size(); ++i) {
            Instruction ins = this.instructions.get(i);
            short opCode = ins.getOpcode();
            for (int j = 0; j < opcodes.length; ++j) {
                if (opcodes[j] != opCode) continue;
                return i;
            }
        }
        return -1;
    }

    int offset(Instruction i) {
        return this.offset(0, i);
    }

    int offset(int start, Instruction ins) {
        int offset = 0;
        for (int i = start; i < this.instructions.size(); ++i) {
            if (this.instructions.get(i).equals(ins)) {
                return offset;
            }
            offset += this.instructions.get(i).length();
        }
        throw new JiapiRuntimeException("Isntruction not found; " + ins);
    }

    Instruction instructionAtOffset(short offset) {
        for (Instruction ins : this.instructions) {
            if (ins.getOffset() >= offset) {
                return ins;
            }
            if (ins.getOffset() <= offset) continue;
            break;
        }
        return null;
    }

    public String toString() {
        if (this.instructions.size() == 0) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer();
        int offset = 0;
        int count = 0;
        Iterator<Instruction> i = this.instructions.iterator();
        while (i.hasNext()) {
            Instruction ins = i.next();
            sb.append("  #");
            sb.append(count);
            if (count < 10) {
                sb.append(' ');
            }
            if (count < 100 && this.size() >= 100) {
                sb.append(' ');
            }
            sb.append(" (");
            sb.append(offset);
            sb.append(")  ");
            sb.append(ins.toString());
            if (i.hasNext()) {
                sb.append('\n');
            }
            ++count;
            offset += ins.length();
        }
        return sb.toString();
    }

    public void clear() {
        this.instructions.clear();
    }

    public InstructionFactory getInstructionFactory() {
        return new InstructionFactory(this.constantPool);
    }

    public JiapiMethod getDeclaringMethod() {
        return this.declaringMethod;
    }

    void setDeclaringMethod(JiapiMethod jm) {
        this.declaringMethod = jm;
    }

    public InstructionList createView(int start) {
        return this.createView(0, this.instructions.size());
    }

    public InstructionList createView(int start, int end) {
        InstructionList il = new InstructionList(this.constantPool, this.instructions.subList(start, end));
        il.setDeclaringMethod(this.declaringMethod);
        return il;
    }

    void updateOffsets() {
        short offset = 0;
        for (Instruction ins : this.instructions) {
            ins.setOffset(offset);
            offset = (short)(offset + ins.length());
        }
    }

    private void print(InstructionList il) {
        for (int i = 0; i < il.size(); ++i) {
            Instruction ins = il.get(i);
            System.out.println("  #" + i + " " + ins + ", stack-usage: " + ins.stackUsage());
        }
    }

    public List<BasicBlock> getBasicBlocks() {
        LinkedList<BasicBlock> bbList = new LinkedList<BasicBlock>();
        int startIdx = 0;
        for (int i = 0; i < this.size(); ++i) {
            Instruction ins = this.get(i);
            if (ins.isBranchTarget() && startIdx != i) {
                bbList.add(new BasicBlock(this, startIdx, i - 1));
                startIdx = i;
            }
            if (ins.getOpcode() == -79 || ins.getOpcode() == -84 || ins.getOpcode() == -83 || ins.getOpcode() == -82 || ins.getOpcode() == -81 || ins.getOpcode() == -80) {
                bbList.add(new BasicBlock(this, startIdx, i));
                startIdx = i + 1;
                continue;
            }
            if (ins instanceof BranchInstruction) {
                bbList.add(new BasicBlock(this, startIdx, i));
                startIdx = i + 1;
                continue;
            }
            if (!(ins instanceof SwitchInstruction)) continue;
            System.out.println("SWITCH instructions not implemented");
        }
        if (bbList.size() > 0) {
            ((BasicBlock)bbList.get(0)).markAsFirstBasicBlock();
        }
        return bbList;
    }

    public List<BranchInstruction> findBranchesForTarget(Instruction target) {
        LinkedList<BranchInstruction> bList = new LinkedList<BranchInstruction>();
        for (Instruction ins : this.instructions) {
            BranchInstruction bIns;
            if (!(ins instanceof BranchInstruction) || (bIns = (BranchInstruction)ins).getTarget() != target) continue;
            bList.add(bIns);
        }
        return bList;
    }
}

