/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect.util;

import java.util.ArrayList;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionList;
import net.sf.jiapi.reflect.util.HotSpot;

public class HotSpotLocator {
    private InstructionList il;

    public HotSpotLocator(InstructionList il) {
        this.il = il;
    }

    public HotSpot[] getHotSpots(byte[] opCodes) {
        return this.getHotSpots(opCodes, "*");
    }

    public HotSpot[] getHotSpots(byte[] opCodes, String resolution) {
        ArrayList<HotSpot> al = new ArrayList<HotSpot>();
        for (int i = 0; i < this.il.size(); ++i) {
            Instruction ins = this.il.get(i);
            short opCode = ins.getOpcode();
            for (int j = 0; j < opCodes.length; ++j) {
                if (opCode != opCodes[j]) continue;
                HotSpot hs = this.createHotSpot(i);
                al.add(hs);
            }
        }
        return al.toArray(new HotSpot[0]);
    }

    private HotSpot createHotSpot(int idx) {
        Instruction end;
        Instruction start = end = this.il.get(idx);
        int stackConsumption = end.stackConsumption();
        while (stackConsumption > 0) {
            start = this.il.get(idx - 1);
            stackConsumption -= start.stackUsage();
            --idx;
        }
        return new HotSpot(this.il, start, end);
    }
}

