/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.tool.re.Loop;
import net.sf.jiapi.tool.re.Node;
import net.sf.jiapi.tool.re.SimpleStatement;
import net.sf.jiapi.tool.re.SimpleStatementBuilder;
import net.sf.jiapi.tool.re.Statement;

public class LoopStatement
extends Statement {
    private Loop loop;
    private List<Statement> body = new LinkedList<Statement>();

    LoopStatement(Loop l) {
        super(l.getHeader());
        this.loop = l;
    }

    @Override
    Node getNextNode() {
        return this.loop.getPostDominator();
    }

    public void addStatement(Statement s) {
        this.body.add(s);
    }

    public String toString() {
        Node hdr = this.loop.getHeader();
        SimpleStatementBuilder ssb = new SimpleStatementBuilder();
        List<SimpleStatement> ssList = ssb.createSimpleStatements(hdr.getBasicBlock().getInstructionList());
        StringBuffer sb = new StringBuffer("LoopStatement(" + hdr.getId() + ")" + ssList + "\n");
        this.indentMore();
        Iterator<Statement> iter = this.body.iterator();
        while (iter.hasNext()) {
            sb.append(indentationString);
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append('\n');
        }
        this.indentLess();
        return sb.toString();
    }

    public Loop getLoop() {
        return this.getLoop();
    }
}

