/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class LightweightHttpWagon
extends StreamWagon {
    private String previousProxyExclusions;
    private String previousProxyHost;
    private String previousProxyPort;
    private HttpURLConnection putConnection;
    private boolean useCache;

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        Repository repository = this.getRepository();
        String repositoryUrl = repository.getUrl();
        Resource resource = inputData.getResource();
        try {
            URL url = repositoryUrl.endsWith("/") ? new URL(repositoryUrl + resource.getName()) : new URL(repositoryUrl + "/" + resource.getName());
            URLConnection urlConnection = url.openConnection();
            if (!this.useCache) {
                urlConnection.setRequestProperty("Pragma", "no-cache");
            }
            inputData.setInputStream(urlConnection.getInputStream());
            resource.setLastModified(urlConnection.getLastModified());
            resource.setContentLength(urlConnection.getContentLength());
        }
        catch (MalformedURLException e) {
            throw new ResourceDoesNotExistException("Invalid repository URL", e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Unable to locate resource in repository", e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Repository repository = this.getRepository();
        String repositoryUrl = repository.getUrl();
        Resource resource = outputData.getResource();
        try {
            URL url = repositoryUrl.endsWith("/") ? new URL(repositoryUrl + resource.getName()) : new URL(repositoryUrl + "/" + resource.getName());
            this.putConnection = (HttpURLConnection)url.openConnection();
            this.putConnection.setRequestMethod("PUT");
            this.putConnection.setDoOutput(true);
            outputData.setOutputStream(this.putConnection.getOutputStream());
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        super.put(source, resourceName);
        try {
            if (this.putConnection.getResponseCode() != 200) {
                throw new TransferFailedException("Unable to transfer file. HttpURLConnection returned the response code: " + this.putConnection.getResponseCode());
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", e);
        }
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        boolean hasAuthentication;
        this.previousProxyHost = System.getProperty("http.proxyHost");
        this.previousProxyPort = System.getProperty("http.proxyPort");
        this.previousProxyExclusions = System.getProperty("http.nonProxyHosts");
        final ProxyInfo proxyInfo = this.proxyInfo;
        if (proxyInfo != null) {
            System.setProperty("http.proxyHost", proxyInfo.getHost());
            System.setProperty("http.proxyPort", String.valueOf(proxyInfo.getPort()));
            if (proxyInfo.getNonProxyHosts() != null) {
                System.setProperty("http.nonProxyHosts", proxyInfo.getNonProxyHosts());
            }
        }
        final boolean hasProxy = proxyInfo != null && proxyInfo.getUserName() != null;
        boolean bl = hasAuthentication = this.authenticationInfo != null && this.authenticationInfo.getUserName() != null;
        if (hasProxy || hasAuthentication) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyInfo.getHost()) && this.getRequestingPort() == proxyInfo.getPort()) {
                        String password = "";
                        if (proxyInfo.getPassword() != null) {
                            password = proxyInfo.getPassword();
                        }
                        return new PasswordAuthentication(proxyInfo.getUserName(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        String password = "";
                        if (LightweightHttpWagon.this.authenticationInfo.getPassword() != null) {
                            password = LightweightHttpWagon.this.authenticationInfo.getPassword();
                        }
                        return new PasswordAuthentication(LightweightHttpWagon.this.authenticationInfo.getUserName(), password.toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        }
    }

    public void closeConnection() throws ConnectionException {
        if (this.putConnection != null) {
            this.putConnection.disconnect();
        }
        if (this.previousProxyHost != null) {
            System.setProperty("http.proxyHost", this.previousProxyHost);
        }
        if (this.previousProxyPort != null) {
            System.setProperty("http.proxyPort", this.previousProxyPort);
        }
        if (this.previousProxyExclusions != null) {
            System.setProperty("http.nonProxyHosts", this.previousProxyExclusions);
        }
    }
}

