/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SimpleContentOutputter;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trace.SaxonEventMulticaster;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer {
    private Configuration config;
    private DocumentInfo principalSourceDocument;
    private Bindery bindery;
    private NamePool namePool;
    private DecimalFormatManager decimalFormatManager;
    private Emitter messageEmitter;
    private RuleManager ruleManager;
    private Properties outputProperties;
    private SequenceReceiver currentOutputter;
    private ParameterSet parameters;
    private PreparedStyleSheet preparedStyleSheet;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Result principalResult;
    private String principalResultURI;
    private OutputURIResolver outputURIResolver;
    private ErrorListener errorListener;
    private Executable executable;
    private int recoveryPolicy = 1;
    private int temporaryDestinationDepth = 0;
    private int treeModel = 1;
    private boolean disableStripping = false;
    private Template initialTemplate = null;
    private DocumentPool sourceDocumentPool;
    private HashMap userDataTable;
    private boolean lineNumbering;
    private GregorianCalendar currentDateTime;
    private int initialMode = -1;
    private SequenceIterator currentIterator = null;
    private Mode currentMode = null;
    private Template currentTemplate = null;
    private GroupIterator currentGroupIterator = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private RegexIterator currentRegexIterator = null;

    public Controller(Configuration configuration) {
        this.config = configuration;
        this.init();
    }

    private void init() {
        Object object;
        this.bindery = new Bindery();
        this.namePool = NamePool.getDefaultNamePool();
        this.standardURIResolver = new StandardURIResolver(this.config);
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            object = ((StandardErrorListener)this.errorListener).getErrorOutput();
            this.errorListener = new StandardErrorListener();
            ((StandardErrorListener)this.errorListener).setErrorOutput((PrintStream)object);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.config.getRecoveryPolicy());
        }
        this.sourceDocumentPool = new DocumentPool();
        this.userDataTable = new HashMap();
        object = this.config.getTraceListener();
        if (object != null) {
            this.addTraceListener((TraceListener)object);
        }
        if (this.config.isLineNumbering()) {
            this.setLineNumbering(true);
        }
        this.setTreeModel(this.config.getTreeModel());
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        this.initialMode = this.namePool.allocateClarkName(string);
    }

    public void run(NodeInfo nodeInfo) throws TransformerException {
        this.principalSourceDocument = nodeInfo.getDocumentRoot();
        if (this.principalSourceDocument == null) {
            throw new TransformerException("Source tree must be rooted at a document node");
        }
        this.makeContext(nodeInfo);
        TailCall tailCall = this.applyTemplates(SingletonIterator.makeIterator(nodeInfo), this.getRuleManager().getMode(this.initialMode), null, null);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(this.newXPathContext());
        }
    }

    public DocumentInfo getPrincipalSourceDocument() {
        return this.principalSourceDocument;
    }

    public TailCall applyTemplates(SequenceIterator sequenceIterator, Mode mode, ParameterSet parameterSet, ParameterSet parameterSet2) throws TransformerException {
        SequenceIterator sequenceIterator2 = this.getCurrentIterator();
        Mode mode2 = this.getCurrentMode();
        TailCall tailCall = null;
        if (this.isTracing()) {
            this.setCurrentIterator(sequenceIterator);
            this.setCurrentMode(mode);
            while (true) {
                if (tailCall != null) {
                    tailCall = tailCall.processLeavingTail(this.newXPathContext());
                    continue;
                }
                NodeInfo nodeInfo = (NodeInfo)sequenceIterator.next();
                if (nodeInfo == null) break;
                Template template = this.ruleManager.getTemplateRule(nodeInfo, mode, this);
                if (template == null) {
                    this.defaultAction(nodeInfo, parameterSet, parameterSet2);
                    continue;
                }
                if (parameterSet2 != null || template.needsStackFrame()) {
                    this.bindery.openStackFrame(parameterSet, parameterSet2);
                    this.traceListener.startCurrentItem(nodeInfo);
                    tailCall = template.processLeavingTail(this.newXPathContext());
                    this.traceListener.endCurrentItem(nodeInfo);
                    this.bindery.closeStackFrame();
                    continue;
                }
                this.traceListener.startCurrentItem(nodeInfo);
                tailCall = template.processLeavingTail(this.newXPathContext());
                this.traceListener.endCurrentItem(nodeInfo);
            }
            this.setCurrentMode(mode2);
            this.setCurrentIterator(sequenceIterator2);
        } else {
            this.setCurrentIterator(sequenceIterator);
            this.setCurrentMode(mode);
            while (true) {
                if (tailCall != null) {
                    tailCall = tailCall.processLeavingTail(this.newXPathContext());
                    continue;
                }
                NodeInfo nodeInfo = (NodeInfo)sequenceIterator.next();
                if (nodeInfo == null) break;
                Template template = this.ruleManager.getTemplateRule(nodeInfo, mode, this);
                if (template == null) {
                    this.defaultAction(nodeInfo, parameterSet, parameterSet2);
                    continue;
                }
                if (parameterSet2 != null || template.needsStackFrame()) {
                    this.bindery.openStackFrame(parameterSet, parameterSet2);
                    tailCall = template.processLeavingTail(this.newXPathContext());
                    this.bindery.closeStackFrame();
                    continue;
                }
                tailCall = template.processLeavingTail(this.newXPathContext());
            }
            this.setCurrentMode(mode2);
            this.setCurrentIterator(sequenceIterator2);
        }
        return tailCall;
    }

    private void defaultAction(NodeInfo nodeInfo, ParameterSet parameterSet, ParameterSet parameterSet2) throws TransformerException {
        switch (nodeInfo.getNodeKind()) {
            case 1: 
            case 9: {
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3);
                TailCall tailCall = this.applyTemplates(axisIterator, this.getCurrentMode(), parameterSet, parameterSet2);
                while (tailCall != null) {
                    tailCall = tailCall.processLeavingTail(this.newXPathContext());
                }
                return;
            }
            case 2: 
            case 3: {
                this.getReceiver().characters(nodeInfo.getStringValue(), 0);
                return;
            }
            case 7: 
            case 8: 
            case 13: {
                return;
            }
        }
    }

    public void applyImports(int n, int n2, ParameterSet parameterSet, ParameterSet parameterSet2) throws TransformerException {
        Mode mode = this.getCurrentMode();
        if (this.getCurrentIterator() == null) {
            throw new TransformerException("There is no context item");
        }
        Item item = this.getCurrentIterator().current();
        if (!(item instanceof NodeInfo)) {
            throw new TransformerException("Cannot call xsl:apply-imports when context item is not a node");
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        Template template = this.ruleManager.getTemplateRule(nodeInfo, mode, n, n2, this);
        if (template == null) {
            this.defaultAction(nodeInfo, parameterSet, parameterSet2);
        } else {
            this.bindery.openStackFrame(parameterSet, parameterSet2);
            template.process(this.newXPathContext());
            this.bindery.closeStackFrame();
        }
    }

    public void nextMatch(ParameterSet parameterSet, ParameterSet parameterSet2) throws TransformerException {
        Template template = this.getCurrentTemplate();
        if (template == null) {
            throw new TransformerException("There is no current template rule");
        }
        Mode mode = this.getCurrentMode();
        if (this.getCurrentIterator() == null) {
            throw new TransformerException("There is no context item");
        }
        Item item = this.getCurrentIterator().current();
        if (!(item instanceof NodeInfo)) {
            throw new TransformerException("Cannot call xsl:next-match when context item is not a node");
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        Template template2 = this.ruleManager.getNextMatchHandler(nodeInfo, mode, template, this);
        if (template2 == null) {
            this.defaultAction(nodeInfo, parameterSet, parameterSet2);
        } else {
            this.bindery.openStackFrame(parameterSet, parameterSet2);
            template2.process(this.newXPathContext());
            this.bindery.closeStackFrame();
        }
    }

    public void setOutputProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setOutputProperty(string, properties.getProperty(string));
        }
    }

    public Properties getOutputProperties() {
        if (this.outputProperties == null) {
            if (this.executable == null) {
                return new Properties();
            }
            this.outputProperties = this.executable.getDefaultOutputProperties();
        }
        Properties properties = new Properties();
        Enumeration<?> enumeration = this.outputProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, this.outputProperties.getProperty(string));
        }
        return properties;
    }

    public void setOutputProperty(String string, String string2) {
        if (this.outputProperties == null) {
            this.outputProperties = this.getOutputProperties();
        }
        if (!SaxonOutputKeys.isValidOutputKey(string)) {
            throw new IllegalArgumentException(string);
        }
        this.outputProperties.put(string, string2);
    }

    public String getOutputProperty(String string) {
        if (!SaxonOutputKeys.isValidOutputKey(string)) {
            throw new IllegalArgumentException(string);
        }
        if (this.outputProperties == null) {
            if (this.executable == null) {
                return null;
            }
            this.outputProperties = this.executable.getDefaultOutputProperties();
        }
        return this.outputProperties.getProperty(string);
    }

    public String getPrincipalResultURI() {
        return this.principalResultURI;
    }

    public Result getPrincipalResult() {
        return this.principalResult;
    }

    public void changeOutputDestination(Properties properties, Result result, boolean bl, int n, SchemaType schemaType) throws TransformerException {
        if (bl && this.temporaryDestinationDepth > 0) {
            throw new TransformerException("Cannot switch to a final result destination while writing a temporary tree");
        }
        if (!bl) {
            ++this.temporaryDestinationDepth;
        }
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setNamePool(this.namePool);
        if (properties == null) {
            properties = new Properties();
        }
        this.setOutputProperties(properties);
        Receiver receiver = ResultWrapper.getReceiver(result, this.namePool, properties, this.executable.getCharacterMapIndex());
        if (schemaType != null) {
            System.err.println("Type attribute for result document is currently ignored");
        }
        receiver = this.getConfiguration().getDocumentValidator(receiver, receiver.getSystemId(), this.getNamePool(), n);
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        namespaceReducer.setNamePool(this.namePool);
        complexContentOutputter.setReceiver(namespaceReducer);
        complexContentOutputter.startDocument();
        this.currentOutputter = complexContentOutputter;
    }

    public void changeToSequenceOutputDestination(SequenceReceiver sequenceReceiver) throws TransformerException {
        ++this.temporaryDestinationDepth;
        this.currentOutputter = sequenceReceiver;
    }

    public void changeToTextOutputDestination(StringBuffer stringBuffer) {
        ++this.temporaryDestinationDepth;
        this.currentOutputter = new SimpleContentOutputter(stringBuffer);
    }

    public void setReceiver(SequenceReceiver sequenceReceiver) {
        this.currentOutputter = sequenceReceiver;
    }

    public SequenceReceiver getReceiver() {
        return this.currentOutputter;
    }

    public void resetOutputDestination(SequenceReceiver sequenceReceiver) throws TransformerException {
        if (this.currentOutputter == null) {
            throw new IllegalStateException("No outputter has been allocated");
        }
        if (this.temporaryDestinationDepth > 0) {
            --this.temporaryDestinationDepth;
        }
        this.currentOutputter.endDocument();
        this.currentOutputter = sequenceReceiver;
    }

    public void setInitialTemplate(String string) throws TransformerException {
        int n = this.namePool.allocateClarkName(string);
        HashMap hashMap = this.getExecutable().getNamedTemplateTable();
        Template template = (Template)hashMap.get(new Integer(n));
        if (template == null) {
            throw new TransformerException("There is no named template with expanded name " + string);
        }
        this.initialTemplate = template;
    }

    public Emitter makeMessageEmitter() throws TransformerException {
        String string = this.config.getMessageEmitterClass();
        Object object = Loader.getInstance(string);
        if (!(object instanceof Emitter)) {
            throw new TransformerException(string + " is not an Emitter");
        }
        this.messageEmitter = (Emitter)object;
        this.messageEmitter.setNamePool(this.getNamePool());
        return this.messageEmitter;
    }

    public Emitter getMessageEmitter() {
        return this.messageEmitter;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(String string, SourceLocator sourceLocator) throws TransformerException {
        if (sourceLocator == null) {
            this.errorListener.warning(new TransformerException(string));
        } else {
            TransformerException transformerException = new TransformerException(string, sourceLocator);
            this.errorListener.warning(transformerException);
        }
    }

    public void recoverableError(TransformerException transformerException) throws TransformerException {
        this.errorListener.warning(transformerException);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void makeContext(Item item) {
        this.setCurrentIterator(SingletonIterator.makeIterator(item));
    }

    public void setPrincipalSourceDocument(DocumentInfo documentInfo) {
        this.principalSourceDocument = documentInfo;
    }

    public Object[] saveContext() {
        Object[] objectArray = new Object[]{this.currentIterator, this.currentMode, this.currentTemplate, this.currentGroupIterator, null, null, this.currentRegexIterator};
        return objectArray;
    }

    public void restoreContext(Object[] objectArray) {
        this.currentIterator = (SequenceIterator)objectArray[0];
        this.currentMode = (Mode)objectArray[1];
        this.currentTemplate = (Template)objectArray[2];
        this.currentGroupIterator = (GroupIterator)objectArray[3];
        this.currentRegexIterator = (RegexIterator)objectArray[6];
    }

    public void setGlobalContext() {
        this.currentIterator = SingletonIterator.makeIterator(this.principalSourceDocument);
        this.currentMode = null;
        this.currentTemplate = null;
        this.currentGroupIterator = null;
        this.currentRegexIterator = null;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userURIResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver == null ? StandardOutputResolver.getInstance() : outputURIResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public Builder makeBuilder() {
        Builder builder = this.treeModel == 1 ? new TinyBuilder() : new TreeBuilder();
        builder.setTiming(this.config.isTiming());
        builder.setNamePool(this.namePool);
        builder.setLineNumbering(this.lineNumbering);
        return builder;
    }

    public Stripper makeStripper(Builder builder) {
        if (this.config.isStripsAllWhiteSpace()) {
            return AllElementStripper.getInstance();
        }
        Stripper stripper = this.executable == null ? new Stripper(new Mode()) : this.executable.newStripper();
        stripper.setController(this);
        if (builder != null) {
            stripper.setUnderlyingReceiver(builder);
        }
        return stripper;
    }

    public void registerDocument(DocumentInfo documentInfo, String string) {
        this.sourceDocumentPool.add(documentInfo, string);
        this.namePool.allocateDocumentNumber(documentInfo);
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean bl) {
        this.tracingPaused = bl;
    }

    public void addTraceListener(TraceListener traceListener) {
        this.traceListener = SaxonEventMulticaster.add(this.traceListener, traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = SaxonEventMulticaster.remove(this.traceListener, traceListener);
    }

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.preparedStyleSheet = preparedStyleSheet;
        this.executable = preparedStyleSheet.getExecutable();
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    private void initializeController() {
        this.setRuleManager(this.executable.getRuleManager());
        this.setDecimalFormatManager(this.executable.getDecimalFormatManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        this.bindery = new Bindery();
        this.executable.initialiseBindery(this.bindery);
        this.bindery.openStackFrame();
        this.defineGlobalParameters(this.bindery);
    }

    public void defineGlobalParameters(Bindery bindery) {
        bindery.defineGlobalParameters(this.parameters);
    }

    public Object getUserData(Object object, String string) {
        String string2 = object.hashCode() + " " + string;
        return this.userDataTable.get(string2);
    }

    public void setUserData(Object object, String string, Object object2) {
        String string2 = object.hashCode() + " " + string;
        if (object2 == null) {
            this.userDataTable.remove(string2);
        } else {
            this.userDataTable.put(string2, object2);
        }
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (this.preparedStyleSheet == null) {
            throw new TransformerException("Stylesheet has not been prepared");
        }
        this.currentDateTime = null;
        this.principalResultURI = result.getSystemId();
        try {
            NodeInfo nodeInfo = null;
            if (source instanceof NodeInfo || source instanceof DOMSource) {
                nodeInfo = this.prepareInputTree(source);
                this.registerDocument(nodeInfo.getDocumentRoot(), source.getSystemId());
            } else if (source == null) {
                if (this.initialTemplate == null) {
                    throw new TransformerException("Either a source document or an initial template must be specified");
                }
            } else {
                Builder builder = this.makeBuilder();
                Sender sender = new Sender(this.config);
                sender.send(source, this.makeStripper(builder), this.namePool, false);
                DocumentInfo documentInfo = builder.getCurrentDocument();
                this.registerDocument(documentInfo, source.getSystemId());
                nodeInfo = documentInfo;
            }
            this.transformDocument(nodeInfo, result);
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if ((throwable = sAXParseException.getException()) instanceof RuntimeException) {
                    this.errorListener.fatalError(transformerException);
                }
            } else {
                this.errorListener.fatalError(transformerException);
            }
            throw transformerException;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        Object object;
        NodeInfo nodeInfo;
        Object object2;
        if (source instanceof DOMSource) {
            object2 = ((DOMSource)source).getNode();
            if (object2 instanceof NodeInfo) {
                nodeInfo = (NodeInfo)object2;
            } else {
                object = object2 instanceof Document ? (Document)object2 : object2.getOwnerDocument();
                DocumentWrapper documentWrapper = new DocumentWrapper((Document)object, source.getSystemId());
                nodeInfo = documentWrapper.wrap((Node)object2);
            }
        } else {
            nodeInfo = (NodeInfo)source;
        }
        if (this.executable.stripsWhitespace() && !this.disableStripping) {
            object2 = nodeInfo.getDocumentRoot();
            object = new StrippedDocument((DocumentInfo)object2, this.makeStripper(null));
            nodeInfo = ((StrippedDocument)object).wrap(nodeInfo);
        }
        return nodeInfo;
    }

    public void transformDocument(NodeInfo nodeInfo, Result result) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        if (this.executable == null) {
            throw new TransformerException("Stylesheet has not been compiled");
        }
        boolean bl = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        this.principalResultURI = result.getSystemId();
        if (nodeInfo != null) {
            if (nodeInfo instanceof DocumentInfo) {
                object3 = (DocumentInfo)nodeInfo;
            } else {
                object3 = nodeInfo.getDocumentRoot();
                if (object3 == null) {
                    throw new TransformerException("Source tree must have a document node as its root");
                }
            }
            this.principalSourceDocument = object3;
            if (object3.getNamePool() == null) {
                object3.setNamePool(this.preparedStyleSheet.getTargetNamePool());
            }
            if (object3.getNamePool() != this.preparedStyleSheet.getTargetNamePool()) {
                throw new TransformerException("Source document and stylesheet must use the same name pool");
            }
            this.makeContext((Item)object3);
        }
        this.initializeController();
        object3 = this.executable.getDefaultOutputProperties();
        if (this.outputProperties != null) {
            object2 = this.outputProperties.propertyNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string = this.outputProperties.getProperty((String)object);
                ((Properties)object3).put(object, string);
            }
        }
        if ((object2 = ((Properties)object3).getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            object = ((Properties)object3).getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            result = this.prepareNextStylesheet((String)object2, (String)object, result);
        }
        this.changeOutputDestination((Properties)object3, result, true, 3, null);
        if (this.initialTemplate == null) {
            this.run(nodeInfo);
        } else {
            this.initialTemplate.process(new XPathContext(this));
        }
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        this.resetOutputDestination(null);
        if (bl && result instanceof StreamResult && (object = ((StreamResult)result).getOutputStream()) != null) {
            try {
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
    }

    public Result prepareNextStylesheet(String string, String string2, Result result) throws TransformerException {
        Source source = this.getURIResolver().resolve(string, string2);
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        transformerFactoryImpl.setConfiguration(this.config);
        Templates templates = transformerFactoryImpl.newTemplates(source);
        TransformerReceiver transformerReceiver = new TransformerReceiver((Controller)templates.newTransformer());
        transformerReceiver.setSystemId(this.principalResultURI);
        transformerReceiver.setNamePool(this.getNamePool());
        transformerReceiver.setResult(result);
        return transformerReceiver;
    }

    public void setParameter(String string, Object object) {
        Value value;
        if (this.parameters == null) {
            this.parameters = new ParameterSet();
        }
        try {
            value = FunctionProxy.convertJavaObjectToXPath(object, this);
            if (value == null) {
                value = EmptySequence.getInstance();
            }
        }
        catch (TransformerException transformerException) {
            value = new StringValue(object.toString());
        }
        int n = this.namePool.allocateClarkName(string);
        this.parameters.put(n, value);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        int n = this.namePool.allocateClarkName(string);
        return this.parameters.get(n);
    }

    public GregorianCalendar getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new GregorianCalendar();
        }
        return this.currentDateTime;
    }

    public void setCurrentMode(Mode mode) {
        this.currentMode = mode;
    }

    public Mode getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentIterator(SequenceIterator sequenceIterator) {
        this.currentIterator = sequenceIterator;
    }

    public SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public Item getCurrentItem() throws XPathException {
        if (this.currentIterator == null) {
            throw new XPathException.Dynamic("There is no current item");
        }
        return this.currentIterator.current();
    }

    public void setCurrentTemplate(Template template) {
        this.currentTemplate = template;
    }

    public Template getCurrentTemplate() {
        return this.currentTemplate;
    }

    public void setCurrentGroupIterator(GroupIterator groupIterator) {
        this.currentGroupIterator = groupIterator;
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.currentGroupIterator;
    }

    public void setCurrentRegexIterator(RegexIterator regexIterator) {
        this.currentRegexIterator = regexIterator;
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.currentRegexIterator;
    }

    public XPathContext newXPathContext() {
        return new XPathContext(this);
    }

    public void setRememberedNumber(NodeInfo nodeInfo, int n) {
        this.lastRememberedNode = nodeInfo;
        this.lastRememberedNumber = n;
    }

    public int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.lastRememberedNode == nodeInfo) {
            return this.lastRememberedNumber;
        }
        return -1;
    }
}

