/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public class Doc
extends SystemFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        this.expressionBaseURI = staticContext.getBaseURI();
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        String string = atomicValue.getStringValue();
        NodeInfo nodeInfo = Document.makeDoc(string, this.expressionBaseURI, xPathContext);
        if (nodeInfo == null) {
            this.dynamicError("Failed to load document " + string);
            return null;
        }
        return nodeInfo;
    }
}

