/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;

final class AncestorEnumeration
extends AxisIteratorImpl {
    private TinyNodeImpl next;
    private TinyDocumentImpl document;
    private TinyNodeImpl startNode;
    private NodeTest test;
    private TinyNodeImpl first = null;
    private boolean includeSelf;

    public AncestorEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.includeSelf = bl;
        if (bl && nodeTest.matches(tinyNodeImpl.getNodeKind(), tinyNodeImpl.getFingerprint(), tinyNodeImpl.getTypeAnnotation())) {
            this.first = tinyNodeImpl;
        }
        this.next = (TinyNodeImpl)tinyNodeImpl.getParent();
        if (this.next != null && !nodeTest.matches(this.next.getNodeKind(), this.next.getFingerprint(), this.next.getTypeAnnotation())) {
            this.advance();
        }
    }

    public Item next() {
        if (this.first == null && this.next == null) {
            return null;
        }
        ++this.position;
        if (this.first != null) {
            this.current = this.first;
            this.first = null;
            return this.current;
        }
        this.current = this.next;
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            this.next = (TinyNodeImpl)this.next.getParent();
        } while (this.next != null && !this.test.matches(this.next.getNodeKind(), this.next.getFingerprint(), this.next.getTypeAnnotation()));
    }

    public SequenceIterator getAnother() {
        return new AncestorEnumeration(this.document, this.startNode, this.test, this.includeSelf);
    }
}

