/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class PaddedInstruction
extends AbstractInstruction {
    public PaddedInstruction(int n) {
        super(n);
    }

    public int getPaddedSize(int n) {
        return this.getSize() + this.paddingBytes(n + 1);
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        int n = this.paddingBytes(byteCodeInput.getBytesRead());
        for (int i = 0; i < n; ++i) {
            byteCodeInput.readByte();
        }
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        int n = this.paddingBytes(byteCodeOutput.getBytesWritten());
        for (int i = 0; i < n; ++i) {
            byteCodeOutput.writeByte(0);
        }
    }

    private int paddingBytes(int n) {
        int n2 = 4 - n % 4;
        return n2 == 4 ? 0 : n2;
    }
}

