/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cojen.util.CacheEvictor;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCanonicalSet<T>
extends AbstractSet<T> {
    private final float LOAD_FACTOR = 0.75f;
    private Entry<T>[] mEntries;
    private int mSize;
    private int mThreshold;

    public WeakCanonicalSet() {
        int initialCapacity = 17;
        this.mEntries = new Entry[17];
        this.mThreshold = 12;
    }

    public synchronized <U extends T> U put(U obj) {
        if (obj == null) {
            return null;
        }
        Entry<T>[] entries = this.mEntries;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % entries.length;
        Entry<T> e = entries[index];
        Entry<T> prev = null;
        while (e != null) {
            Object iobj = e.get();
            if (iobj == null) {
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
            } else {
                if (e.mHash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                    return (U)iobj;
                }
                prev = e;
            }
            e = e.mNext;
        }
        if (this.mSize >= this.mThreshold) {
            this.cleanup();
            if (this.mSize >= this.mThreshold) {
                this.rehash();
                entries = this.mEntries;
                index = (hash & Integer.MAX_VALUE) % entries.length;
            }
        }
        entries[index] = new Entry<U>(this, obj, hash, entries[index]);
        ++this.mSize;
        return obj;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return new SetIterator(this.mEntries);
    }

    @Override
    public synchronized int size() {
        return this.mSize;
    }

    @Override
    public synchronized boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        Entry<T>[] entries = this.mEntries;
        int hash = this.hashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % entries.length;
        Entry<T> e = entries[index];
        while (e != null) {
            Object iobj = e.get();
            if (iobj != null && e.mHash == hash && obj.getClass() == iobj.getClass() && this.equals(obj, iobj)) {
                return true;
            }
            e = e.mNext;
        }
        return false;
    }

    @Override
    public synchronized String toString() {
        return WeakIdentityMap.toString(this);
    }

    protected int hashCode(Object obj) {
        return obj.hashCode();
    }

    protected boolean equals(Object a, Object b) {
        return a.equals(b);
    }

    synchronized void removeCleared(Entry<T> cleared) {
        Entry<T>[] entries = this.mEntries;
        int index = (cleared.mHash & Integer.MAX_VALUE) % entries.length;
        Entry<T> e = entries[index];
        Entry<T> prev = null;
        while (e != null) {
            if (e == cleared) {
                if (prev == null) {
                    entries[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
                return;
            }
            prev = e;
            e = e.mNext;
        }
    }

    private void cleanup() {
        Entry<T>[] entries = this.mEntries;
        int size = 0;
        int i = entries.length;
        while (--i >= 0) {
            Entry<T> e = entries[i];
            Entry<T> prev = null;
            while (e != null) {
                if (e.get() == null) {
                    if (prev == null) {
                        entries[i] = e.mNext;
                    } else {
                        prev.mNext = e.mNext;
                    }
                } else {
                    ++size;
                    prev = e;
                }
                e = e.mNext;
            }
        }
        this.mSize = size;
    }

    private void rehash() {
        Entry<T>[] oldEntries = this.mEntries;
        int newCapacity = oldEntries.length * 2 + 1;
        Entry[] newEntries = new Entry[newCapacity];
        int size = 0;
        int i = oldEntries.length;
        while (--i >= 0) {
            Entry<T> old = oldEntries[i];
            while (old != null) {
                Entry<T> e = old;
                old = old.mNext;
                if (e.get() == null) continue;
                ++size;
                int index = (e.mHash & Integer.MAX_VALUE) % newCapacity;
                e.mNext = newEntries[index];
                newEntries[index] = e;
            }
        }
        this.mEntries = newEntries;
        this.mSize = size;
        this.mThreshold = (int)((float)newCapacity * 0.75f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetIterator
    implements Iterator<T> {
        private final Entry<T>[] mEntries;
        private int mIndex;
        private T mEntryCanonical;
        private Entry<T> mEntry;

        SetIterator(Entry<T>[] entries) {
            this.mEntries = entries;
            this.mIndex = this.mEntries.length;
        }

        @Override
        public boolean hasNext() {
            while (this.mEntry == null || (this.mEntryCanonical = this.mEntry.get()) == null) {
                if (this.mEntry != null) {
                    this.mEntry = this.mEntry.mNext;
                    continue;
                }
                if (this.mIndex <= 0) {
                    return false;
                }
                this.mEntry = this.mEntries[--this.mIndex];
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mEntry = this.mEntry.mNext;
            return this.mEntryCanonical;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T>
    extends WeakReference<T>
    implements CacheEvictor.Ref {
        final WeakCanonicalSet mSet;
        final int mHash;
        Entry<T> mNext;

        Entry(WeakCanonicalSet<T> set, T canonical, int hash, Entry<T> next) {
            super(canonical, CacheEvictor.queue());
            this.mSet = set;
            this.mHash = hash;
            this.mNext = next;
        }

        @Override
        public void remove() {
            this.mSet.removeCleared(this);
        }
    }
}

