/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    public static final String STRIP_ATTRIBUTES = "net.sf.jiapi.strip-attributes";
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private String resource = "/jiapi.properties";

    public boolean getBoolean(String key, boolean deflt) {
        if (key == null) {
            return deflt;
        }
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        boolean b = deflt;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public int getInt(String key, int deflt) {
        if (key == null) {
            return deflt;
        }
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        int i = deflt;
        try {
            i = Integer.valueOf(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public boolean stripAttribute(String attrName) {
        Set<String> aSet = this.getSet(STRIP_ATTRIBUTES);
        return aSet.contains(attrName);
    }

    public Set<String> getSet(String key) {
        HashSet<String> aSet = new HashSet<String>();
        Properties p = this.getProperties(this.resource);
        String s = p.getProperty(key);
        if (s != null) {
            String[] split = s.split(",");
            for (int i = 0; i < split.length; ++i) {
                aSet.add(split[i].trim());
            }
        }
        return aSet;
    }

    private Properties getProperties(String name) {
        Properties properties = new Properties();
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                properties.load(is);
            } else {
                log.warn("Could not find resource: " + name);
            }
        }
        catch (Exception e) {
            log.error("Failed to get property file " + name + ", " + e);
        }
        return properties;
    }
}

