/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.javancss;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ASCII_UCodeESC_CharStream {
    public static final boolean staticFlag = false;
    private int bufpos = -1;
    private int bufsize;
    private int available;
    private int tokenBegin;
    private int[] bufline;
    private int[] bufcolumn;
    private int column = 0;
    private int line = 1;
    private Reader inputStream;
    private boolean prevCharIsCR = false;
    private boolean prevCharIsLF = false;
    private char[] nextCharBuf;
    private char[] buffer;
    private int maxNextCharInd = 0;
    private int nextCharInd = -1;
    private int inBuf = 0;

    private static final int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException();
    }

    private final void expandBuff(boolean wrapAround) {
        char[] newbuffer = new char[this.bufsize + 2048];
        int[] newbufline = new int[this.bufsize + 2048];
        int[] newbufcolumn = new int[this.bufsize + 2048];
        try {
            if (wrapAround) {
                System.arraycopy(this.buffer, this.tokenBegin, newbuffer, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, newbuffer, this.bufsize - this.tokenBegin, this.bufpos);
                this.buffer = newbuffer;
                System.arraycopy(this.bufline, this.tokenBegin, newbufline, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufline, 0, newbufline, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufline = newbufline;
                System.arraycopy(this.bufcolumn, this.tokenBegin, newbufcolumn, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufcolumn, 0, newbufcolumn, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufcolumn = newbufcolumn;
                this.bufpos += this.bufsize - this.tokenBegin;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, newbuffer, 0, this.bufsize - this.tokenBegin);
                this.buffer = newbuffer;
                System.arraycopy(this.bufline, this.tokenBegin, newbufline, 0, this.bufsize - this.tokenBegin);
                this.bufline = newbufline;
                System.arraycopy(this.bufcolumn, this.tokenBegin, newbufcolumn, 0, this.bufsize - this.tokenBegin);
                this.bufcolumn = newbufcolumn;
                this.bufpos -= this.tokenBegin;
            }
        }
        catch (Throwable t) {
            throw new Error(t.getMessage());
        }
        this.available = this.bufsize += 2048;
        this.tokenBegin = 0;
    }

    private final void fillBuff() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        try {
            int i = this.inputStream.read(this.nextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (i == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += i;
            return;
        }
        catch (IOException e) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            throw e;
        }
    }

    private final char readByte() throws IOException {
        if (++this.nextCharInd >= this.maxNextCharInd) {
            this.fillBuff();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    public final char beginToken() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            this.tokenBegin = this.bufpos == this.bufsize - 1 ? (this.bufpos = 0) : (this.bufpos = this.bufpos + 1);
            return this.buffer[this.tokenBegin];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    private final void adjustBuffSize() {
        if (this.available == this.bufsize) {
            if (this.tokenBegin > 2048) {
                this.bufpos = 0;
                this.available = this.tokenBegin;
            } else {
                this.expandBuff(false);
            }
        } else if (this.available > this.tokenBegin) {
            this.available = this.bufsize;
        } else if (this.tokenBegin - this.available < 2048) {
            this.expandBuff(true);
        } else {
            this.available = this.tokenBegin;
        }
    }

    private final void updateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += 8 - (this.column & 7);
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    public final char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            return this.buffer[this.bufpos == this.bufsize - 1 ? (this.bufpos = 0) : (this.bufpos = this.bufpos + 1)];
        }
        if (++this.bufpos == this.available) {
            this.adjustBuffSize();
        }
        this.buffer[this.bufpos] = c = (char)(0xFF & this.readByte());
        if (c == '\\') {
            this.updateLineColumn(c);
            int backSlashCnt = 1;
            while (true) {
                if (++this.bufpos == this.available) {
                    this.adjustBuffSize();
                }
                try {
                    this.buffer[this.bufpos] = c = (char)(0xFF & this.readByte());
                    if (c != '\\') {
                        this.updateLineColumn(c);
                        if (c == 'u' && (backSlashCnt & 1) == 1) {
                            if (--this.bufpos >= 0) break;
                            this.bufpos = this.bufsize - 1;
                            break;
                        }
                        this.backup(backSlashCnt);
                        return '\\';
                    }
                }
                catch (IOException e) {
                    if (backSlashCnt > 1) {
                        this.backup(backSlashCnt);
                    }
                    return '\\';
                }
                this.updateLineColumn(c);
                ++backSlashCnt;
            }
            try {
                while ((c = (char)(0xFF & this.readByte())) == 'u') {
                    ++this.column;
                }
                this.buffer[this.bufpos] = c = (char)(ASCII_UCodeESC_CharStream.hexval(c) << 12 | ASCII_UCodeESC_CharStream.hexval((char)(0xFF & this.readByte())) << 8 | ASCII_UCodeESC_CharStream.hexval((char)(0xFF & this.readByte())) << 4 | ASCII_UCodeESC_CharStream.hexval((char)(0xFF & this.readByte())));
                this.column += 4;
            }
            catch (IOException e) {
                throw new Error("Invalid escape character at line " + this.line + " column " + this.column + ".");
            }
            if (backSlashCnt == 1) {
                return c;
            }
            this.backup(backSlashCnt - 1);
            return '\\';
        }
        this.updateLineColumn(c);
        return c;
    }

    public final int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public final int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    public final int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    public final void backup(int amount) {
        this.inBuf += amount;
        if ((this.bufpos -= amount) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    private ASCII_UCodeESC_CharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
        this.inputStream = dstream;
        this.line = startline;
        this.column = startcolumn - 1;
        this.available = this.bufsize = buffersize;
        this.buffer = new char[buffersize];
        this.bufline = new int[buffersize];
        this.bufcolumn = new int[buffersize];
        this.nextCharBuf = new char[4096];
    }

    public ASCII_UCodeESC_CharStream(InputStream dstream, int startline, int startcolumn) {
        this(new InputStreamReader(dstream), startline, startcolumn, 4096);
    }

    public final String getImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin) + new String(this.buffer, 0, this.bufpos + 1);
    }

    public final char[] getSuffix(int len) {
        char[] ret = new char[len];
        if (this.bufpos + 1 >= len) {
            System.arraycopy(this.buffer, this.bufpos - len + 1, ret, 0, len);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (len - this.bufpos - 1), ret, 0, len - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, ret, len - this.bufpos - 1, this.bufpos + 1);
        }
        return ret;
    }
}

