# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a route server.

    :example: Create a route server.
        az network routeserver create --resource-group myresourcegroup --name myrouteserver --hosted-subnet my_subnet_id --public-ip-address my_public_ip
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/virtualhubs/{}", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the Route Server.",
            required=True,
            id_part="name",
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location. Values from: `az account list-locations`. You can configure the default location using `az configure --defaults location=<location>`.",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.sku = AAZStrArg(
            options=["--sku"],
            help="The sku of this VirtualHub.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...].",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"

        # define Arg Group "VirtualHubParameters"
        return cls._args_schema

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        _schema.id = cls._args_sub_resource_create.id

    def _execute_operations(self):
        self.pre_operations()
        yield self.VirtualHubsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualHubsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualHubName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("sku", AAZStrType, ".sku")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.kind = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.address_prefix = AAZStrType(
                serialized_name="addressPrefix",
            )
            properties.allow_branch_to_branch_traffic = AAZBoolType(
                serialized_name="allowBranchToBranchTraffic",
            )
            properties.azure_firewall = AAZObjectType(
                serialized_name="azureFirewall",
            )
            _build_schema_sub_resource_read(properties.azure_firewall)
            properties.bgp_connections = AAZListType(
                serialized_name="bgpConnections",
                flags={"read_only": True},
            )
            properties.express_route_gateway = AAZObjectType(
                serialized_name="expressRouteGateway",
            )
            _build_schema_sub_resource_read(properties.express_route_gateway)
            properties.hub_routing_preference = AAZStrType(
                serialized_name="hubRoutingPreference",
            )
            properties.ip_configurations = AAZListType(
                serialized_name="ipConfigurations",
                flags={"read_only": True},
            )
            properties.p2_s_vpn_gateway = AAZObjectType(
                serialized_name="p2SVpnGateway",
            )
            _build_schema_sub_resource_read(properties.p2_s_vpn_gateway)
            properties.preferred_routing_gateway = AAZStrType(
                serialized_name="preferredRoutingGateway",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.route_table = AAZObjectType(
                serialized_name="routeTable",
            )
            properties.routing_state = AAZStrType(
                serialized_name="routingState",
                flags={"read_only": True},
            )
            properties.security_partner_provider = AAZObjectType(
                serialized_name="securityPartnerProvider",
            )
            _build_schema_sub_resource_read(properties.security_partner_provider)
            properties.security_provider_name = AAZStrType(
                serialized_name="securityProviderName",
            )
            properties.sku = AAZStrType()
            properties.virtual_hub_route_table_v2s = AAZListType(
                serialized_name="virtualHubRouteTableV2s",
            )
            properties.virtual_router_asn = AAZIntType(
                serialized_name="virtualRouterAsn",
            )
            properties.virtual_router_auto_scale_configuration = AAZObjectType(
                serialized_name="virtualRouterAutoScaleConfiguration",
            )
            properties.virtual_router_ips = AAZListType(
                serialized_name="virtualRouterIps",
            )
            properties.virtual_wan = AAZObjectType(
                serialized_name="virtualWan",
            )
            _build_schema_sub_resource_read(properties.virtual_wan)
            properties.vpn_gateway = AAZObjectType(
                serialized_name="vpnGateway",
            )
            _build_schema_sub_resource_read(properties.vpn_gateway)

            bgp_connections = cls._schema_on_200_201.properties.bgp_connections
            bgp_connections.Element = AAZObjectType()
            _build_schema_sub_resource_read(bgp_connections.Element)

            ip_configurations = cls._schema_on_200_201.properties.ip_configurations
            ip_configurations.Element = AAZObjectType()
            _build_schema_sub_resource_read(ip_configurations.Element)

            route_table = cls._schema_on_200_201.properties.route_table
            route_table.routes = AAZListType()

            routes = cls._schema_on_200_201.properties.route_table.routes
            routes.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.route_table.routes.Element
            _element.address_prefixes = AAZListType(
                serialized_name="addressPrefixes",
            )
            _element.next_hop_ip_address = AAZStrType(
                serialized_name="nextHopIpAddress",
            )

            address_prefixes = cls._schema_on_200_201.properties.route_table.routes.Element.address_prefixes
            address_prefixes.Element = AAZStrType()

            virtual_hub_route_table_v2s = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s
            virtual_hub_route_table_v2s.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element.properties
            properties.attached_connections = AAZListType(
                serialized_name="attachedConnections",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.routes = AAZListType()

            attached_connections = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element.properties.attached_connections
            attached_connections.Element = AAZStrType()

            routes = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element.properties.routes
            routes.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element.properties.routes.Element
            _element.destination_type = AAZStrType(
                serialized_name="destinationType",
            )
            _element.destinations = AAZListType()
            _element.next_hop_type = AAZStrType(
                serialized_name="nextHopType",
            )
            _element.next_hops = AAZListType(
                serialized_name="nextHops",
            )

            destinations = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element.properties.routes.Element.destinations
            destinations.Element = AAZStrType()

            next_hops = cls._schema_on_200_201.properties.virtual_hub_route_table_v2s.Element.properties.routes.Element.next_hops
            next_hops.Element = AAZStrType()

            virtual_router_auto_scale_configuration = cls._schema_on_200_201.properties.virtual_router_auto_scale_configuration
            virtual_router_auto_scale_configuration.min_capacity = AAZIntType(
                serialized_name="minCapacity",
            )

            virtual_router_ips = cls._schema_on_200_201.properties.virtual_router_ips
            virtual_router_ips.Element = AAZStrType()

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


def _build_schema_sub_resource_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("id", AAZStrType, ".id")


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType()

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType()

    _schema.id = _schema_sub_resource_read.id


__all__ = ["Create"]
