### 1009 - Parameter Property Removed

**Description**: Checks whether an existing property is removed from a cmd's parameter. 

**Analysis**: Not all configured properties removed from a cmd's parameter are considered breaking changes. The properties listed in PARA_PROPERTY_REMOVE_BREAK_LIST below are thought to influence or interrupt current workflow and be breaking changes. 
* PARA_PROPERTY_REMOVE_BREAK_LIST = ["options", "id_part", "nargs"]

**Example**: In new cli version, configuration `nargs` is being removed from `--categories` of cmd `az monitor log-profiles create` which caused incompatibility with current cmd's script input.

#### Before
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor log-profiles": {
                  "name": "monitor log-profiles",
                  "commands": {
                      "monitor log-profiles create": {
                          "name": "monitor log-profiles create",
                          "is_aaz": true,
                          "parameters": [
                              {
                                  "name": "categories",
                                  "options": ["--categories"],
                                  "required": true,
                                  "nargs": "+",
                                  "aaz_type": "AAZListArg",
                                  "type": "List<String>"
                              }
                              ...
                              ...
                          ]
                      }
                  }
              }
          }
      },
    ...
  }
}
```

#### After
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor log-profiles": {
                  "name": "monitor log-profiles",
                  "commands": {
                      "monitor log-profiles create": {
                          "name": "monitor log-profiles create",
                          "is_aaz": true,
                          "parameters": [
                              {
                                  "name": "categories",
                                  "options": ["--categories"],
                                  "required": true,
                                  "aaz_type": "AAZListArg",
                                  "type": "List<String>"
                              }
                              ...
                              ...
                          ]
                      }
                  }
              }
          }
      },
    ...
  }
}
```
