# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "security security-connector update",
    is_preview=True,
)
class Update(AAZCommand):
    """Update a security connector.
    """

    _aaz_info = {
        "version": "2023-10-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.security/securityconnectors/{}", "2023-10-01-preview"],
        ]
    }

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.security_connector_name = AAZStrArg(
            options=["-n", "--name", "--security-connector-name"],
            help="The security connector name.",
            required=True,
            id_part="name",
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.environment_data = AAZObjectArg(
            options=["--environment-data"],
            arg_group="Properties",
            help="The security connector environment data.",
            nullable=True,
        )
        _args_schema.environment_name = AAZStrArg(
            options=["--environment-name"],
            arg_group="Properties",
            help="The multi cloud resource's cloud name.",
            nullable=True,
            enum={"AWS": "AWS", "Azure": "Azure", "AzureDevOps": "AzureDevOps", "GCP": "GCP", "GitLab": "GitLab", "Github": "Github"},
        )
        _args_schema.offerings = AAZListArg(
            options=["--offerings"],
            arg_group="Properties",
            help="A collection of offerings for the security connector.",
            nullable=True,
        )

        environment_data = cls._args_schema.environment_data
        environment_data.aws_account = AAZObjectArg(
            options=["aws-account"],
            help="AWS Account",
        )
        environment_data.azuredevops_scope = AAZObjectArg(
            options=["azuredevops-scope"],
            help="AzureDevOps Scope",
            blank={},
        )
        environment_data.gcp_project = AAZObjectArg(
            options=["gcp-project"],
            help="GCP Project",
        )
        environment_data.github_scope = AAZObjectArg(
            options=["github-scope"],
            help="GitHub Scope",
            blank={},
        )
        environment_data.gitlab_scope = AAZObjectArg(
            options=["gitlab-scope"],
            help="GitLab Scope",
            blank={},
        )

        aws_account = cls._args_schema.environment_data.aws_account
        aws_account.organizational_data = AAZObjectArg(
            options=["organizational-data"],
            help="The AWS account's organizational data",
            nullable=True,
        )
        aws_account.regions = AAZListArg(
            options=["regions"],
            help="list of regions to scan",
            nullable=True,
        )
        aws_account.scan_interval = AAZIntArg(
            options=["scan-interval"],
            help="Scan interval in hours (value should be between 1-hour to 24-hours)",
            nullable=True,
        )

        organizational_data = cls._args_schema.environment_data.aws_account.organizational_data
        organizational_data.member = AAZObjectArg(
            options=["member"],
        )
        organizational_data.organization = AAZObjectArg(
            options=["organization"],
        )

        member = cls._args_schema.environment_data.aws_account.organizational_data.member
        member.parent_hierarchy_id = AAZStrArg(
            options=["parent-hierarchy-id"],
            help="If the multi cloud account is not of membership type organization, this will be the ID of the account's parent",
            nullable=True,
        )

        organization = cls._args_schema.environment_data.aws_account.organizational_data.organization
        organization.excluded_account_ids = AAZListArg(
            options=["excluded-account-ids"],
            help="If the multi cloud account is of membership type organization, list of accounts excluded from offering",
            nullable=True,
        )
        organization.stackset_name = AAZStrArg(
            options=["stackset-name"],
            help="If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset",
            nullable=True,
        )

        excluded_account_ids = cls._args_schema.environment_data.aws_account.organizational_data.organization.excluded_account_ids
        excluded_account_ids.Element = AAZStrArg(
            nullable=True,
        )

        regions = cls._args_schema.environment_data.aws_account.regions
        regions.Element = AAZStrArg(
            nullable=True,
        )

        gcp_project = cls._args_schema.environment_data.gcp_project
        gcp_project.organizational_data = AAZObjectArg(
            options=["organizational-data"],
            help="The Gcp project's organizational data",
            nullable=True,
        )
        gcp_project.project_details = AAZObjectArg(
            options=["project-details"],
            help="The Gcp project's details",
            nullable=True,
        )
        gcp_project.scan_interval = AAZIntArg(
            options=["scan-interval"],
            help="Scan interval in hours (value should be between 1-hour to 24-hours)",
            nullable=True,
        )

        organizational_data = cls._args_schema.environment_data.gcp_project.organizational_data
        organizational_data.member = AAZObjectArg(
            options=["member"],
        )
        organizational_data.organization = AAZObjectArg(
            options=["organization"],
        )

        member = cls._args_schema.environment_data.gcp_project.organizational_data.member
        member.management_project_number = AAZStrArg(
            options=["management-project-number"],
            help="The GCP management project number from organizational onboarding",
            nullable=True,
        )
        member.parent_hierarchy_id = AAZStrArg(
            options=["parent-hierarchy-id"],
            help="If the multi cloud account is not of membership type organization, this will be the ID of the project's parent",
            nullable=True,
        )

        organization = cls._args_schema.environment_data.gcp_project.organizational_data.organization
        organization.excluded_project_numbers = AAZListArg(
            options=["excluded-project-numbers"],
            help="If the multi cloud account is of membership type organization, list of accounts excluded from offering",
            nullable=True,
        )
        organization.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address which represents the organization level permissions container.",
            nullable=True,
        )
        organization.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The GCP workload identity provider id which represents the permissions required to auto provision security connectors",
            nullable=True,
        )

        excluded_project_numbers = cls._args_schema.environment_data.gcp_project.organizational_data.organization.excluded_project_numbers
        excluded_project_numbers.Element = AAZStrArg(
            nullable=True,
        )

        project_details = cls._args_schema.environment_data.gcp_project.project_details
        project_details.project_id = AAZStrArg(
            options=["project-id"],
            help="The GCP Project id",
            nullable=True,
        )
        project_details.project_number = AAZStrArg(
            options=["project-number"],
            help="The unique GCP Project number",
            nullable=True,
        )

        offerings = cls._args_schema.offerings
        offerings.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.offerings.Element
        _element.cspm_monitor_aws = AAZObjectArg(
            options=["cspm-monitor-aws"],
            help="CspmMonitorAWS Offering",
        )
        _element.cspm_monitor_azuredevops = AAZObjectArg(
            options=["cspm-monitor-azuredevops"],
            help="CspmMonitorAzureDevOps Offering",
            blank={},
        )
        _element.cspm_monitor_gcp = AAZObjectArg(
            options=["cspm-monitor-gcp"],
            help="CspmMonitorGCP Offering",
        )
        _element.cspm_monitor_gitlab = AAZObjectArg(
            options=["cspm-monitor-gitlab"],
            help="CspmMonitorGitLab Offering",
            blank={},
        )
        _element.cspm_monitor_github = AAZObjectArg(
            options=["cspm-monitor-github"],
            help="CspmMonitorGitHub Offering",
            blank={},
        )
        _element.defender_cspm_aws = AAZObjectArg(
            options=["defender-cspm-aws"],
            help="DefenderCspmAWS Offering",
        )
        _element.defender_cspm_gcp = AAZObjectArg(
            options=["defender-cspm-gcp"],
            help="DefenderCspmGCP Offering",
        )
        _element.defender_for_containers_aws = AAZObjectArg(
            options=["defender-for-containers-aws"],
        )
        _element.defender_for_containers_gcp = AAZObjectArg(
            options=["defender-for-containers-gcp"],
        )
        _element.defender_for_databases_aws = AAZObjectArg(
            options=["defender-for-databases-aws"],
        )
        _element.defender_for_databases_gcp = AAZObjectArg(
            options=["defender-for-databases-gcp"],
        )
        _element.defender_for_servers_aws = AAZObjectArg(
            options=["defender-for-servers-aws"],
        )
        _element.defender_for_servers_gcp = AAZObjectArg(
            options=["defender-for-servers-gcp"],
        )
        _element.information_protection_aws = AAZObjectArg(
            options=["information-protection-aws"],
        )

        cspm_monitor_aws = cls._args_schema.offerings.Element.cspm_monitor_aws
        cspm_monitor_aws.native_cloud_connection = AAZObjectArg(
            options=["native-cloud-connection"],
            help="The native cloud connection configuration",
            nullable=True,
        )

        native_cloud_connection = cls._args_schema.offerings.Element.cspm_monitor_aws.native_cloud_connection
        native_cloud_connection.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )

        cspm_monitor_gcp = cls._args_schema.offerings.Element.cspm_monitor_gcp
        cspm_monitor_gcp.native_cloud_connection = AAZObjectArg(
            options=["native-cloud-connection"],
            help="The native cloud connection configuration",
            nullable=True,
        )

        native_cloud_connection = cls._args_schema.offerings.Element.cspm_monitor_gcp.native_cloud_connection
        native_cloud_connection.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this offering",
            nullable=True,
        )
        native_cloud_connection.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The GCP workload identity provider id for the offering",
            nullable=True,
        )

        defender_cspm_aws = cls._args_schema.offerings.Element.defender_cspm_aws
        defender_cspm_aws.ciem = AAZObjectArg(
            options=["ciem"],
            help="Defenders CSPM Cloud infrastructure entitlement management (CIEM) offering configurations",
            nullable=True,
        )
        defender_cspm_aws.data_sensitivity_discovery = AAZObjectArg(
            options=["data-sensitivity-discovery"],
            help="The Microsoft Defender Data Sensitivity discovery configuration",
            nullable=True,
        )
        defender_cspm_aws.databases_dspm = AAZObjectArg(
            options=["databases-dspm"],
            help="The databases DSPM configuration",
            nullable=True,
        )
        defender_cspm_aws.mdc_containers_agentless_discovery_k8s = AAZObjectArg(
            options=["mdc-containers-agentless-discovery-k8s"],
            help="The Microsoft Defender container agentless discovery K8s configuration",
            nullable=True,
        )
        defender_cspm_aws.mdc_containers_image_assessment = AAZObjectArg(
            options=["mdc-containers-image-assessment"],
            help="The Microsoft Defender container image assessment configuration",
            nullable=True,
        )
        defender_cspm_aws.vm_scanners = AAZObjectArg(
            options=["vm-scanners"],
            help="The Microsoft Defender for Server VM scanning configuration",
            nullable=True,
        )

        ciem = cls._args_schema.offerings.Element.defender_cspm_aws.ciem
        ciem.ciem_discovery = AAZObjectArg(
            options=["ciem-discovery"],
            help="Defender CSPM CIEM discovery configuration",
            nullable=True,
        )
        ciem.ciem_oidc = AAZObjectArg(
            options=["ciem-oidc"],
            help="Defender CSPM CIEM AWS OIDC (open id connect) configuration",
            nullable=True,
        )

        ciem_discovery = cls._args_schema.offerings.Element.defender_cspm_aws.ciem.ciem_discovery
        ciem_discovery.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for CIEM discovery",
            nullable=True,
        )

        ciem_oidc = cls._args_schema.offerings.Element.defender_cspm_aws.ciem.ciem_oidc
        ciem_oidc.azure_active_directory_app_name = AAZStrArg(
            options=["azure-active-directory-app-name"],
            help="the azure active directory app name used of authenticating against AWS",
            nullable=True,
        )
        ciem_oidc.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for CIEM oidc connection",
            nullable=True,
        )

        data_sensitivity_discovery = cls._args_schema.offerings.Element.defender_cspm_aws.data_sensitivity_discovery
        data_sensitivity_discovery.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        data_sensitivity_discovery.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender Data Sensitivity discovery enabled",
            nullable=True,
        )

        databases_dspm = cls._args_schema.offerings.Element.defender_cspm_aws.databases_dspm
        databases_dspm.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        databases_dspm.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is databases DSPM protection enabled",
            nullable=True,
        )

        mdc_containers_agentless_discovery_k8s = cls._args_schema.offerings.Element.defender_cspm_aws.mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container agentless discovery K8s enabled",
            nullable=True,
        )

        mdc_containers_image_assessment = cls._args_schema.offerings.Element.defender_cspm_aws.mdc_containers_image_assessment
        mdc_containers_image_assessment.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        mdc_containers_image_assessment.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container image assessment enabled",
            nullable=True,
        )

        vm_scanners = cls._args_schema.offerings.Element.defender_cspm_aws.vm_scanners
        vm_scanners.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Microsoft Defender for Server VM scanning",
            nullable=True,
        )
        vm_scanners.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender for Server VM scanning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_cspm_aws.vm_scanners.configuration
        configuration.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        configuration.exclusion_tags = AAZDictArg(
            options=["exclusion-tags"],
            help="VM tags that indicates that VM should not be scanned",
            nullable=True,
        )
        configuration.scanning_mode = AAZStrArg(
            options=["scanning-mode"],
            help="The scanning mode for the VM scan.",
            nullable=True,
            enum={"Default": "Default"},
        )

        exclusion_tags = cls._args_schema.offerings.Element.defender_cspm_aws.vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrArg(
            nullable=True,
        )

        defender_cspm_gcp = cls._args_schema.offerings.Element.defender_cspm_gcp
        defender_cspm_gcp.ciem_discovery = AAZObjectArg(
            options=["ciem-discovery"],
            help="GCP Defenders CSPM Cloud infrastructure entitlement management (CIEM) discovery offering configurations",
            nullable=True,
        )
        defender_cspm_gcp.data_sensitivity_discovery = AAZObjectArg(
            options=["data-sensitivity-discovery"],
            help="The Microsoft Defender Data Sensitivity discovery configuration",
            nullable=True,
        )
        defender_cspm_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectArg(
            options=["mdc-containers-agentless-discovery-k8s"],
            help="The Microsoft Defender Container agentless discovery configuration",
            nullable=True,
        )
        defender_cspm_gcp.mdc_containers_image_assessment = AAZObjectArg(
            options=["mdc-containers-image-assessment"],
            help="The Microsoft Defender Container image assessment configuration",
            nullable=True,
        )
        defender_cspm_gcp.vm_scanners = AAZObjectArg(
            options=["vm-scanners"],
            help="The Microsoft Defender for Server VM scanning configuration",
            nullable=True,
        )

        ciem_discovery = cls._args_schema.offerings.Element.defender_cspm_gcp.ciem_discovery
        ciem_discovery.azure_active_directory_app_name = AAZStrArg(
            options=["azure-active-directory-app-name"],
            help="the azure active directory app name used of authenticating against GCP workload identity federation",
            nullable=True,
        )
        ciem_discovery.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for CIEM discovery offering",
            nullable=True,
        )
        ciem_discovery.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The GCP workload identity provider id for CIEM discovery offering",
            nullable=True,
        )

        data_sensitivity_discovery = cls._args_schema.offerings.Element.defender_cspm_gcp.data_sensitivity_discovery
        data_sensitivity_discovery.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender Data Sensitivity discovery enabled",
            nullable=True,
        )
        data_sensitivity_discovery.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this feature",
            nullable=True,
        )
        data_sensitivity_discovery.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The workload identity provider id in GCP for this feature",
            nullable=True,
        )

        mdc_containers_agentless_discovery_k8s = cls._args_schema.offerings.Element.defender_cspm_gcp.mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container agentless discovery enabled",
            nullable=True,
        )
        mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this feature",
            nullable=True,
        )
        mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The workload identity provider id in GCP for this feature",
            nullable=True,
        )

        mdc_containers_image_assessment = cls._args_schema.offerings.Element.defender_cspm_gcp.mdc_containers_image_assessment
        mdc_containers_image_assessment.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container image assessment enabled",
            nullable=True,
        )
        mdc_containers_image_assessment.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this feature",
            nullable=True,
        )
        mdc_containers_image_assessment.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The workload identity provider id in GCP for this feature",
            nullable=True,
        )

        vm_scanners = cls._args_schema.offerings.Element.defender_cspm_gcp.vm_scanners
        vm_scanners.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Microsoft Defender for Server VM scanning",
            nullable=True,
        )
        vm_scanners.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender for Server VM scanning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_cspm_gcp.vm_scanners.configuration
        configuration.exclusion_tags = AAZDictArg(
            options=["exclusion-tags"],
            help="VM tags that indicates that VM should not be scanned",
            nullable=True,
        )
        configuration.scanning_mode = AAZStrArg(
            options=["scanning-mode"],
            help="The scanning mode for the VM scan.",
            nullable=True,
            enum={"Default": "Default"},
        )

        exclusion_tags = cls._args_schema.offerings.Element.defender_cspm_gcp.vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrArg(
            nullable=True,
        )

        defender_for_containers_aws = cls._args_schema.offerings.Element.defender_for_containers_aws
        defender_for_containers_aws.auto_provisioning = AAZBoolArg(
            options=["auto-provisioning"],
            help="Is audit logs pipeline auto provisioning enabled",
            nullable=True,
        )
        defender_for_containers_aws.cloud_watch_to_kinesis = AAZObjectArg(
            options=["cloud-watch-to-kinesis"],
            help="The cloudwatch to kinesis connection configuration",
            nullable=True,
        )
        defender_for_containers_aws.container_vulnerability_assessment = AAZObjectArg(
            options=["container-vulnerability-assessment"],
            help="The container vulnerability assessment configuration",
            nullable=True,
        )
        defender_for_containers_aws.container_vulnerability_assessment_task = AAZObjectArg(
            options=["container-vulnerability-assessment-task"],
            help="The container vulnerability assessment task configuration",
            nullable=True,
        )
        defender_for_containers_aws.enable_container_vulnerability_assessment = AAZBoolArg(
            options=["enable-container-vulnerability-assessment"],
            help="Enable container vulnerability assessment feature",
            nullable=True,
        )
        defender_for_containers_aws.kinesis_to_s3 = AAZObjectArg(
            options=["kinesis-to-s3"],
            help="The kinesis to s3 connection configuration",
            nullable=True,
        )
        defender_for_containers_aws.kube_audit_retention_time = AAZIntArg(
            options=["kube-audit-retention-time"],
            help="The retention time in days of kube audit logs set on the CloudWatch log group",
            nullable=True,
        )
        defender_for_containers_aws.kubernetes_scuba_reader = AAZObjectArg(
            options=["kubernetes-scuba-reader"],
            help="The kubernetes to scuba connection configuration",
            nullable=True,
        )
        defender_for_containers_aws.kubernetes_service = AAZObjectArg(
            options=["kubernetes-service"],
            help="The kubernetes service connection configuration",
            nullable=True,
        )
        defender_for_containers_aws.mdc_containers_agentless_discovery_k8s = AAZObjectArg(
            options=["mdc-containers-agentless-discovery-k8s"],
            help="The Microsoft Defender container agentless discovery K8s configuration",
            nullable=True,
        )
        defender_for_containers_aws.mdc_containers_image_assessment = AAZObjectArg(
            options=["mdc-containers-image-assessment"],
            help="The Microsoft Defender container image assessment configuration",
            nullable=True,
        )
        defender_for_containers_aws.scuba_external_id = AAZStrArg(
            options=["scuba-external-id"],
            help="The externalId used by the data reader to prevent the confused deputy attack",
            nullable=True,
        )

        cloud_watch_to_kinesis = cls._args_schema.offerings.Element.defender_for_containers_aws.cloud_watch_to_kinesis
        cloud_watch_to_kinesis.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis",
            nullable=True,
        )

        container_vulnerability_assessment = cls._args_schema.offerings.Element.defender_for_containers_aws.container_vulnerability_assessment
        container_vulnerability_assessment.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )

        container_vulnerability_assessment_task = cls._args_schema.offerings.Element.defender_for_containers_aws.container_vulnerability_assessment_task
        container_vulnerability_assessment_task.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )

        kinesis_to_s3 = cls._args_schema.offerings.Element.defender_for_containers_aws.kinesis_to_s3
        kinesis_to_s3.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS used by Kinesis to transfer data into S3",
            nullable=True,
        )

        kubernetes_scuba_reader = cls._args_schema.offerings.Element.defender_for_containers_aws.kubernetes_scuba_reader
        kubernetes_scuba_reader.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature used for reading data",
            nullable=True,
        )

        kubernetes_service = cls._args_schema.offerings.Element.defender_for_containers_aws.kubernetes_service
        kubernetes_service.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature used for provisioning resources",
            nullable=True,
        )

        mdc_containers_agentless_discovery_k8s = cls._args_schema.offerings.Element.defender_for_containers_aws.mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container agentless discovery K8s enabled",
            nullable=True,
        )

        mdc_containers_image_assessment = cls._args_schema.offerings.Element.defender_for_containers_aws.mdc_containers_image_assessment
        mdc_containers_image_assessment.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        mdc_containers_image_assessment.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container image assessment enabled",
            nullable=True,
        )

        defender_for_containers_gcp = cls._args_schema.offerings.Element.defender_for_containers_gcp
        defender_for_containers_gcp.audit_logs_auto_provisioning_flag = AAZBoolArg(
            options=["audit-logs-auto-provisioning-flag"],
            help="Is audit logs data collection enabled",
            nullable=True,
        )
        defender_for_containers_gcp.data_pipeline_native_cloud_connection = AAZObjectArg(
            options=["data-pipeline-native-cloud-connection"],
            help="The native cloud connection configuration",
            nullable=True,
        )
        defender_for_containers_gcp.defender_agent_auto_provisioning_flag = AAZBoolArg(
            options=["defender-agent-auto-provisioning-flag"],
            help="Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled",
            nullable=True,
        )
        defender_for_containers_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectArg(
            options=["mdc-containers-agentless-discovery-k8s"],
            help="The Microsoft Defender Container agentless discovery configuration",
            nullable=True,
        )
        defender_for_containers_gcp.mdc_containers_image_assessment = AAZObjectArg(
            options=["mdc-containers-image-assessment"],
            help="The Microsoft Defender Container image assessment configuration",
            nullable=True,
        )
        defender_for_containers_gcp.native_cloud_connection = AAZObjectArg(
            options=["native-cloud-connection"],
            help="The native cloud connection configuration",
            nullable=True,
        )
        defender_for_containers_gcp.policy_agent_auto_provisioning_flag = AAZBoolArg(
            options=["policy-agent-auto-provisioning-flag"],
            help="Is Policy Kubernetes agent auto provisioning enabled",
            nullable=True,
        )

        data_pipeline_native_cloud_connection = cls._args_schema.offerings.Element.defender_for_containers_gcp.data_pipeline_native_cloud_connection
        data_pipeline_native_cloud_connection.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The data collection service account email address in GCP for this offering",
            nullable=True,
        )
        data_pipeline_native_cloud_connection.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The data collection GCP workload identity provider id for this offering",
            nullable=True,
        )

        mdc_containers_agentless_discovery_k8s = cls._args_schema.offerings.Element.defender_for_containers_gcp.mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container agentless discovery enabled",
            nullable=True,
        )
        mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this feature",
            nullable=True,
        )
        mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The workload identity provider id in GCP for this feature",
            nullable=True,
        )

        mdc_containers_image_assessment = cls._args_schema.offerings.Element.defender_for_containers_gcp.mdc_containers_image_assessment
        mdc_containers_image_assessment.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender container image assessment enabled",
            nullable=True,
        )
        mdc_containers_image_assessment.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this feature",
            nullable=True,
        )
        mdc_containers_image_assessment.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The workload identity provider id in GCP for this feature",
            nullable=True,
        )

        native_cloud_connection = cls._args_schema.offerings.Element.defender_for_containers_gcp.native_cloud_connection
        native_cloud_connection.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this offering",
            nullable=True,
        )
        native_cloud_connection.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The GCP workload identity provider id for this offering",
            nullable=True,
        )

        defender_for_databases_aws = cls._args_schema.offerings.Element.defender_for_databases_aws
        defender_for_databases_aws.arc_auto_provisioning = AAZObjectArg(
            options=["arc-auto-provisioning"],
            help="The ARC autoprovisioning configuration",
            nullable=True,
        )
        defender_for_databases_aws.databases_dspm = AAZObjectArg(
            options=["databases-dspm"],
            help="The databases data security posture management (DSPM) configuration",
            nullable=True,
        )
        defender_for_databases_aws.rds = AAZObjectArg(
            options=["rds"],
            help="The RDS configuration",
            nullable=True,
        )

        arc_auto_provisioning = cls._args_schema.offerings.Element.defender_for_databases_aws.arc_auto_provisioning
        arc_auto_provisioning.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        arc_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="Configuration for servers Arc auto provisioning",
            nullable=True,
        )
        arc_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is arc auto provisioning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_databases_aws.arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrArg(
            options=["private-link-scope"],
            help="Optional Arc private link scope resource id to link the Arc agent",
            nullable=True,
        )
        configuration.proxy = AAZStrArg(
            options=["proxy"],
            help="Optional http proxy endpoint to use for the Arc agent",
            nullable=True,
        )

        databases_dspm = cls._args_schema.offerings.Element.defender_for_databases_aws.databases_dspm
        databases_dspm.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        databases_dspm.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is databases data security posture management (DSPM) protection enabled",
            nullable=True,
        )

        rds = cls._args_schema.offerings.Element.defender_for_databases_aws.rds
        rds.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        rds.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is RDS protection enabled",
            nullable=True,
        )

        defender_for_databases_gcp = cls._args_schema.offerings.Element.defender_for_databases_gcp
        defender_for_databases_gcp.arc_auto_provisioning = AAZObjectArg(
            options=["arc-auto-provisioning"],
            help="The ARC autoprovisioning configuration",
            nullable=True,
        )
        defender_for_databases_gcp.defender_for_databases_arc_auto_provisioning = AAZObjectArg(
            options=["defender-for-databases-arc-auto-provisioning"],
            help="The native cloud connection configuration",
            nullable=True,
        )

        arc_auto_provisioning = cls._args_schema.offerings.Element.defender_for_databases_gcp.arc_auto_provisioning
        arc_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="Configuration for servers Arc auto provisioning",
            nullable=True,
        )
        arc_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is arc auto provisioning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_databases_gcp.arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrArg(
            options=["private-link-scope"],
            help="Optional Arc private link scope resource id to link the Arc agent",
            nullable=True,
        )
        configuration.proxy = AAZStrArg(
            options=["proxy"],
            help="Optional http proxy endpoint to use for the Arc agent",
            nullable=True,
        )

        defender_for_databases_arc_auto_provisioning = cls._args_schema.offerings.Element.defender_for_databases_gcp.defender_for_databases_arc_auto_provisioning
        defender_for_databases_arc_auto_provisioning.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this offering",
            nullable=True,
        )
        defender_for_databases_arc_auto_provisioning.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The GCP workload identity provider id for this offering",
            nullable=True,
        )

        defender_for_servers_aws = cls._args_schema.offerings.Element.defender_for_servers_aws
        defender_for_servers_aws.arc_auto_provisioning = AAZObjectArg(
            options=["arc-auto-provisioning"],
            help="The ARC autoprovisioning configuration",
            nullable=True,
        )
        defender_for_servers_aws.defender_for_servers = AAZObjectArg(
            options=["defender-for-servers"],
            help="The Defender for servers connection configuration",
            nullable=True,
        )
        defender_for_servers_aws.mde_auto_provisioning = AAZObjectArg(
            options=["mde-auto-provisioning"],
            help="The Microsoft Defender for Endpoint autoprovisioning configuration",
            nullable=True,
        )
        defender_for_servers_aws.sub_plan = AAZObjectArg(
            options=["sub-plan"],
            help="configuration for the servers offering subPlan",
            nullable=True,
        )
        defender_for_servers_aws.va_auto_provisioning = AAZObjectArg(
            options=["va-auto-provisioning"],
            help="The Vulnerability Assessment autoprovisioning configuration",
            nullable=True,
        )
        defender_for_servers_aws.vm_scanners = AAZObjectArg(
            options=["vm-scanners"],
            help="The Microsoft Defender for Server VM scanning configuration",
            nullable=True,
        )

        arc_auto_provisioning = cls._args_schema.offerings.Element.defender_for_servers_aws.arc_auto_provisioning
        arc_auto_provisioning.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        arc_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="Configuration for servers Arc auto provisioning",
            nullable=True,
        )
        arc_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is arc auto provisioning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_servers_aws.arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrArg(
            options=["private-link-scope"],
            help="Optional Arc private link scope resource id to link the Arc agent",
            nullable=True,
        )
        configuration.proxy = AAZStrArg(
            options=["proxy"],
            help="Optional HTTP proxy endpoint to use for the Arc agent",
            nullable=True,
        )

        defender_for_servers = cls._args_schema.offerings.Element.defender_for_servers_aws.defender_for_servers
        defender_for_servers.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )

        mde_auto_provisioning = cls._args_schema.offerings.Element.defender_for_servers_aws.mde_auto_provisioning
        mde_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Microsoft Defender for Endpoint autoprovisioning",
            nullable=True,
            blank={},
        )
        mde_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender for Endpoint auto provisioning enabled",
            nullable=True,
        )

        sub_plan = cls._args_schema.offerings.Element.defender_for_servers_aws.sub_plan
        sub_plan.type = AAZStrArg(
            options=["type"],
            help="The available sub plans",
            nullable=True,
            enum={"P1": "P1", "P2": "P2"},
        )

        va_auto_provisioning = cls._args_schema.offerings.Element.defender_for_servers_aws.va_auto_provisioning
        va_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Vulnerability Assessment autoprovisioning",
            nullable=True,
        )
        va_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Vulnerability Assessment auto provisioning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_servers_aws.va_auto_provisioning.configuration
        configuration.type = AAZStrArg(
            options=["type"],
            help="The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'",
            nullable=True,
            enum={"Qualys": "Qualys", "TVM": "TVM"},
        )

        vm_scanners = cls._args_schema.offerings.Element.defender_for_servers_aws.vm_scanners
        vm_scanners.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Microsoft Defender for Server VM scanning",
            nullable=True,
        )
        vm_scanners.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender for Server VM scanning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_servers_aws.vm_scanners.configuration
        configuration.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )
        configuration.exclusion_tags = AAZDictArg(
            options=["exclusion-tags"],
            help="VM tags that indicates that VM should not be scanned",
            nullable=True,
        )
        configuration.scanning_mode = AAZStrArg(
            options=["scanning-mode"],
            help="The scanning mode for the VM scan.",
            nullable=True,
            enum={"Default": "Default"},
        )

        exclusion_tags = cls._args_schema.offerings.Element.defender_for_servers_aws.vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrArg(
            nullable=True,
        )

        defender_for_servers_gcp = cls._args_schema.offerings.Element.defender_for_servers_gcp
        defender_for_servers_gcp.arc_auto_provisioning = AAZObjectArg(
            options=["arc-auto-provisioning"],
            help="The ARC autoprovisioning configuration",
            nullable=True,
        )
        defender_for_servers_gcp.defender_for_servers = AAZObjectArg(
            options=["defender-for-servers"],
            help="The Defender for servers connection configuration",
            nullable=True,
        )
        defender_for_servers_gcp.mde_auto_provisioning = AAZObjectArg(
            options=["mde-auto-provisioning"],
            help="The Microsoft Defender for Endpoint autoprovisioning configuration",
            nullable=True,
        )
        defender_for_servers_gcp.sub_plan = AAZObjectArg(
            options=["sub-plan"],
            help="configuration for the servers offering subPlan",
            nullable=True,
        )
        defender_for_servers_gcp.va_auto_provisioning = AAZObjectArg(
            options=["va-auto-provisioning"],
            help="The Vulnerability Assessment autoprovisioning configuration",
            nullable=True,
        )
        defender_for_servers_gcp.vm_scanners = AAZObjectArg(
            options=["vm-scanners"],
            help="The Microsoft Defender for Server VM scanning configuration",
            nullable=True,
        )

        arc_auto_provisioning = cls._args_schema.offerings.Element.defender_for_servers_gcp.arc_auto_provisioning
        arc_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="Configuration for servers Arc auto provisioning",
            nullable=True,
        )
        arc_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is arc auto provisioning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_servers_gcp.arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrArg(
            options=["private-link-scope"],
            help="Optional Arc private link scope resource id to link the Arc agent",
            nullable=True,
        )
        configuration.proxy = AAZStrArg(
            options=["proxy"],
            help="Optional HTTP proxy endpoint to use for the Arc agent",
            nullable=True,
        )

        defender_for_servers = cls._args_schema.offerings.Element.defender_for_servers_gcp.defender_for_servers
        defender_for_servers.service_account_email_address = AAZStrArg(
            options=["service-account-email-address"],
            help="The service account email address in GCP for this feature",
            nullable=True,
        )
        defender_for_servers.workload_identity_provider_id = AAZStrArg(
            options=["workload-identity-provider-id"],
            help="The workload identity provider id in GCP for this feature",
            nullable=True,
        )

        mde_auto_provisioning = cls._args_schema.offerings.Element.defender_for_servers_gcp.mde_auto_provisioning
        mde_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Microsoft Defender for Endpoint autoprovisioning",
            nullable=True,
            blank={},
        )
        mde_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender for Endpoint auto provisioning enabled",
            nullable=True,
        )

        sub_plan = cls._args_schema.offerings.Element.defender_for_servers_gcp.sub_plan
        sub_plan.type = AAZStrArg(
            options=["type"],
            help="The available sub plans",
            nullable=True,
            enum={"P1": "P1", "P2": "P2"},
        )

        va_auto_provisioning = cls._args_schema.offerings.Element.defender_for_servers_gcp.va_auto_provisioning
        va_auto_provisioning.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Vulnerability Assessment autoprovisioning",
            nullable=True,
        )
        va_auto_provisioning.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Vulnerability Assessment auto provisioning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_servers_gcp.va_auto_provisioning.configuration
        configuration.type = AAZStrArg(
            options=["type"],
            help="The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'",
            nullable=True,
            enum={"Qualys": "Qualys", "TVM": "TVM"},
        )

        vm_scanners = cls._args_schema.offerings.Element.defender_for_servers_gcp.vm_scanners
        vm_scanners.configuration = AAZObjectArg(
            options=["configuration"],
            help="configuration for Microsoft Defender for Server VM scanning",
            nullable=True,
        )
        vm_scanners.enabled = AAZBoolArg(
            options=["enabled"],
            help="Is Microsoft Defender for Server VM scanning enabled",
            nullable=True,
        )

        configuration = cls._args_schema.offerings.Element.defender_for_servers_gcp.vm_scanners.configuration
        configuration.exclusion_tags = AAZDictArg(
            options=["exclusion-tags"],
            help="VM tags that indicate that VM should not be scanned",
            nullable=True,
        )
        configuration.scanning_mode = AAZStrArg(
            options=["scanning-mode"],
            help="The scanning mode for the VM scan.",
            nullable=True,
            enum={"Default": "Default"},
        )

        exclusion_tags = cls._args_schema.offerings.Element.defender_for_servers_gcp.vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrArg(
            nullable=True,
        )

        information_protection_aws = cls._args_schema.offerings.Element.information_protection_aws
        information_protection_aws.information_protection = AAZObjectArg(
            options=["information-protection"],
            help="The native cloud connection configuration",
            nullable=True,
        )

        information_protection = cls._args_schema.offerings.Element.information_protection_aws.information_protection
        information_protection.cloud_role_arn = AAZStrArg(
            options=["cloud-role-arn"],
            help="The cloud role ARN in AWS for this feature",
            nullable=True,
        )

        # define Arg Group "SecurityConnector"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="SecurityConnector",
            help="Location where the resource is stored",
            nullable=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="SecurityConnector",
            help="A list of key value pairs that describe the resource.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SecurityConnectorsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        self.SecurityConnectorsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SecurityConnectorsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "securityConnectorName", self.ctx.args.security_connector_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_security_connector_read(cls._schema_on_200)

            return cls._schema_on_200

    class SecurityConnectorsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200, 201]:
                return self.on_200_201(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "securityConnectorName", self.ctx.args.security_connector_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-10-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_security_connector_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("environmentData", AAZObjectType, ".environment_data")
                properties.set_prop("environmentName", AAZStrType, ".environment_name")
                properties.set_prop("offerings", AAZListType, ".offerings")

            environment_data = _builder.get(".properties.environmentData")
            if environment_data is not None:
                environment_data.set_const("environmentType", "AwsAccount", AAZStrType, ".aws_account", typ_kwargs={"flags": {"required": True}})
                environment_data.set_const("environmentType", "AzureDevOpsScope", AAZStrType, ".azuredevops_scope", typ_kwargs={"flags": {"required": True}})
                environment_data.set_const("environmentType", "GcpProject", AAZStrType, ".gcp_project", typ_kwargs={"flags": {"required": True}})
                environment_data.set_const("environmentType", "GithubScope", AAZStrType, ".github_scope", typ_kwargs={"flags": {"required": True}})
                environment_data.set_const("environmentType", "GitlabScope", AAZStrType, ".gitlab_scope", typ_kwargs={"flags": {"required": True}})
                environment_data.discriminate_by("environmentType", "AwsAccount")
                environment_data.discriminate_by("environmentType", "AzureDevOpsScope")
                environment_data.discriminate_by("environmentType", "GcpProject")
                environment_data.discriminate_by("environmentType", "GithubScope")
                environment_data.discriminate_by("environmentType", "GitlabScope")

            disc_aws_account = _builder.get(".properties.environmentData{environmentType:AwsAccount}")
            if disc_aws_account is not None:
                disc_aws_account.set_prop("organizationalData", AAZObjectType, ".aws_account.organizational_data")
                disc_aws_account.set_prop("regions", AAZListType, ".aws_account.regions")
                disc_aws_account.set_prop("scanInterval", AAZIntType, ".aws_account.scan_interval")

            organizational_data = _builder.get(".properties.environmentData{environmentType:AwsAccount}.organizationalData")
            if organizational_data is not None:
                organizational_data.set_const("organizationMembershipType", "Member", AAZStrType, ".member", typ_kwargs={"flags": {"required": True}})
                organizational_data.set_const("organizationMembershipType", "Organization", AAZStrType, ".organization", typ_kwargs={"flags": {"required": True}})
                organizational_data.discriminate_by("organizationMembershipType", "Member")
                organizational_data.discriminate_by("organizationMembershipType", "Organization")

            disc_member = _builder.get(".properties.environmentData{environmentType:AwsAccount}.organizationalData{organizationMembershipType:Member}")
            if disc_member is not None:
                disc_member.set_prop("parentHierarchyId", AAZStrType, ".member.parent_hierarchy_id")

            disc_organization = _builder.get(".properties.environmentData{environmentType:AwsAccount}.organizationalData{organizationMembershipType:Organization}")
            if disc_organization is not None:
                disc_organization.set_prop("excludedAccountIds", AAZListType, ".organization.excluded_account_ids")
                disc_organization.set_prop("stacksetName", AAZStrType, ".organization.stackset_name")

            excluded_account_ids = _builder.get(".properties.environmentData{environmentType:AwsAccount}.organizationalData{organizationMembershipType:Organization}.excludedAccountIds")
            if excluded_account_ids is not None:
                excluded_account_ids.set_elements(AAZStrType, ".")

            regions = _builder.get(".properties.environmentData{environmentType:AwsAccount}.regions")
            if regions is not None:
                regions.set_elements(AAZStrType, ".")

            disc_gcp_project = _builder.get(".properties.environmentData{environmentType:GcpProject}")
            if disc_gcp_project is not None:
                disc_gcp_project.set_prop("organizationalData", AAZObjectType, ".gcp_project.organizational_data")
                disc_gcp_project.set_prop("projectDetails", AAZObjectType, ".gcp_project.project_details")
                disc_gcp_project.set_prop("scanInterval", AAZIntType, ".gcp_project.scan_interval")

            organizational_data = _builder.get(".properties.environmentData{environmentType:GcpProject}.organizationalData")
            if organizational_data is not None:
                organizational_data.set_const("organizationMembershipType", "Member", AAZStrType, ".member", typ_kwargs={"flags": {"required": True}})
                organizational_data.set_const("organizationMembershipType", "Organization", AAZStrType, ".organization", typ_kwargs={"flags": {"required": True}})
                organizational_data.discriminate_by("organizationMembershipType", "Member")
                organizational_data.discriminate_by("organizationMembershipType", "Organization")

            disc_member = _builder.get(".properties.environmentData{environmentType:GcpProject}.organizationalData{organizationMembershipType:Member}")
            if disc_member is not None:
                disc_member.set_prop("managementProjectNumber", AAZStrType, ".member.management_project_number")
                disc_member.set_prop("parentHierarchyId", AAZStrType, ".member.parent_hierarchy_id")

            disc_organization = _builder.get(".properties.environmentData{environmentType:GcpProject}.organizationalData{organizationMembershipType:Organization}")
            if disc_organization is not None:
                disc_organization.set_prop("excludedProjectNumbers", AAZListType, ".organization.excluded_project_numbers")
                disc_organization.set_prop("serviceAccountEmailAddress", AAZStrType, ".organization.service_account_email_address")
                disc_organization.set_prop("workloadIdentityProviderId", AAZStrType, ".organization.workload_identity_provider_id")

            excluded_project_numbers = _builder.get(".properties.environmentData{environmentType:GcpProject}.organizationalData{organizationMembershipType:Organization}.excludedProjectNumbers")
            if excluded_project_numbers is not None:
                excluded_project_numbers.set_elements(AAZStrType, ".")

            project_details = _builder.get(".properties.environmentData{environmentType:GcpProject}.projectDetails")
            if project_details is not None:
                project_details.set_prop("projectId", AAZStrType, ".project_id")
                project_details.set_prop("projectNumber", AAZStrType, ".project_number")

            offerings = _builder.get(".properties.offerings")
            if offerings is not None:
                offerings.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.offerings[]")
            if _elements is not None:
                _elements.set_const("offeringType", "CspmMonitorAws", AAZStrType, ".cspm_monitor_aws", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "CspmMonitorAzureDevOps", AAZStrType, ".cspm_monitor_azuredevops", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "CspmMonitorGcp", AAZStrType, ".cspm_monitor_gcp", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "CspmMonitorGitLab", AAZStrType, ".cspm_monitor_gitlab", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "CspmMonitorGithub", AAZStrType, ".cspm_monitor_github", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderCspmAws", AAZStrType, ".defender_cspm_aws", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderCspmGcp", AAZStrType, ".defender_cspm_gcp", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderForContainersAws", AAZStrType, ".defender_for_containers_aws", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderForContainersGcp", AAZStrType, ".defender_for_containers_gcp", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderForDatabasesAws", AAZStrType, ".defender_for_databases_aws", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderForDatabasesGcp", AAZStrType, ".defender_for_databases_gcp", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderForServersAws", AAZStrType, ".defender_for_servers_aws", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "DefenderForServersGcp", AAZStrType, ".defender_for_servers_gcp", typ_kwargs={"flags": {"required": True}})
                _elements.set_const("offeringType", "InformationProtectionAws", AAZStrType, ".information_protection_aws", typ_kwargs={"flags": {"required": True}})
                _elements.discriminate_by("offeringType", "CspmMonitorAws")
                _elements.discriminate_by("offeringType", "CspmMonitorAzureDevOps")
                _elements.discriminate_by("offeringType", "CspmMonitorGcp")
                _elements.discriminate_by("offeringType", "CspmMonitorGitLab")
                _elements.discriminate_by("offeringType", "CspmMonitorGithub")
                _elements.discriminate_by("offeringType", "DefenderCspmAws")
                _elements.discriminate_by("offeringType", "DefenderCspmGcp")
                _elements.discriminate_by("offeringType", "DefenderForContainersAws")
                _elements.discriminate_by("offeringType", "DefenderForContainersGcp")
                _elements.discriminate_by("offeringType", "DefenderForDatabasesAws")
                _elements.discriminate_by("offeringType", "DefenderForDatabasesGcp")
                _elements.discriminate_by("offeringType", "DefenderForDevOpsAzureDevOps")
                _elements.discriminate_by("offeringType", "DefenderForDevOpsGitLab")
                _elements.discriminate_by("offeringType", "DefenderForDevOpsGithub")
                _elements.discriminate_by("offeringType", "DefenderForServersAws")
                _elements.discriminate_by("offeringType", "DefenderForServersGcp")
                _elements.discriminate_by("offeringType", "InformationProtectionAws")

            disc_cspm_monitor_aws = _builder.get(".properties.offerings[]{offeringType:CspmMonitorAws}")
            if disc_cspm_monitor_aws is not None:
                disc_cspm_monitor_aws.set_prop("nativeCloudConnection", AAZObjectType, ".cspm_monitor_aws.native_cloud_connection")

            native_cloud_connection = _builder.get(".properties.offerings[]{offeringType:CspmMonitorAws}.nativeCloudConnection")
            if native_cloud_connection is not None:
                native_cloud_connection.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            disc_cspm_monitor_gcp = _builder.get(".properties.offerings[]{offeringType:CspmMonitorGcp}")
            if disc_cspm_monitor_gcp is not None:
                disc_cspm_monitor_gcp.set_prop("nativeCloudConnection", AAZObjectType, ".cspm_monitor_gcp.native_cloud_connection")

            native_cloud_connection = _builder.get(".properties.offerings[]{offeringType:CspmMonitorGcp}.nativeCloudConnection")
            if native_cloud_connection is not None:
                native_cloud_connection.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                native_cloud_connection.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            disc_defender_cspm_aws = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}")
            if disc_defender_cspm_aws is not None:
                disc_defender_cspm_aws.set_prop("ciem", AAZObjectType, ".defender_cspm_aws.ciem")
                disc_defender_cspm_aws.set_prop("dataSensitivityDiscovery", AAZObjectType, ".defender_cspm_aws.data_sensitivity_discovery")
                disc_defender_cspm_aws.set_prop("databasesDspm", AAZObjectType, ".defender_cspm_aws.databases_dspm")
                disc_defender_cspm_aws.set_prop("mdcContainersAgentlessDiscoveryK8s", AAZObjectType, ".defender_cspm_aws.mdc_containers_agentless_discovery_k8s")
                disc_defender_cspm_aws.set_prop("mdcContainersImageAssessment", AAZObjectType, ".defender_cspm_aws.mdc_containers_image_assessment")
                disc_defender_cspm_aws.set_prop("vmScanners", AAZObjectType, ".defender_cspm_aws.vm_scanners")

            ciem = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.ciem")
            if ciem is not None:
                ciem.set_prop("ciemDiscovery", AAZObjectType, ".ciem_discovery")
                ciem.set_prop("ciemOidc", AAZObjectType, ".ciem_oidc")

            ciem_discovery = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.ciem.ciemDiscovery")
            if ciem_discovery is not None:
                ciem_discovery.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            ciem_oidc = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.ciem.ciemOidc")
            if ciem_oidc is not None:
                ciem_oidc.set_prop("azureActiveDirectoryAppName", AAZStrType, ".azure_active_directory_app_name")
                ciem_oidc.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            data_sensitivity_discovery = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.dataSensitivityDiscovery")
            if data_sensitivity_discovery is not None:
                data_sensitivity_discovery.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                data_sensitivity_discovery.set_prop("enabled", AAZBoolType, ".enabled")

            databases_dspm = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.databasesDspm")
            if databases_dspm is not None:
                databases_dspm.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                databases_dspm.set_prop("enabled", AAZBoolType, ".enabled")

            mdc_containers_agentless_discovery_k8s = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.mdcContainersAgentlessDiscoveryK8s")
            if mdc_containers_agentless_discovery_k8s is not None:
                mdc_containers_agentless_discovery_k8s.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                mdc_containers_agentless_discovery_k8s.set_prop("enabled", AAZBoolType, ".enabled")

            mdc_containers_image_assessment = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.mdcContainersImageAssessment")
            if mdc_containers_image_assessment is not None:
                mdc_containers_image_assessment.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                mdc_containers_image_assessment.set_prop("enabled", AAZBoolType, ".enabled")

            vm_scanners = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.vmScanners")
            if vm_scanners is not None:
                vm_scanners.set_prop("configuration", AAZObjectType, ".configuration")
                vm_scanners.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.vmScanners.configuration")
            if configuration is not None:
                configuration.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                configuration.set_prop("exclusionTags", AAZDictType, ".exclusion_tags")
                configuration.set_prop("scanningMode", AAZStrType, ".scanning_mode")

            exclusion_tags = _builder.get(".properties.offerings[]{offeringType:DefenderCspmAws}.vmScanners.configuration.exclusionTags")
            if exclusion_tags is not None:
                exclusion_tags.set_elements(AAZStrType, ".")

            disc_defender_cspm_gcp = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}")
            if disc_defender_cspm_gcp is not None:
                disc_defender_cspm_gcp.set_prop("ciemDiscovery", AAZObjectType, ".defender_cspm_gcp.ciem_discovery")
                disc_defender_cspm_gcp.set_prop("dataSensitivityDiscovery", AAZObjectType, ".defender_cspm_gcp.data_sensitivity_discovery")
                disc_defender_cspm_gcp.set_prop("mdcContainersAgentlessDiscoveryK8s", AAZObjectType, ".defender_cspm_gcp.mdc_containers_agentless_discovery_k8s")
                disc_defender_cspm_gcp.set_prop("mdcContainersImageAssessment", AAZObjectType, ".defender_cspm_gcp.mdc_containers_image_assessment")
                disc_defender_cspm_gcp.set_prop("vmScanners", AAZObjectType, ".defender_cspm_gcp.vm_scanners")

            ciem_discovery = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.ciemDiscovery")
            if ciem_discovery is not None:
                ciem_discovery.set_prop("azureActiveDirectoryAppName", AAZStrType, ".azure_active_directory_app_name")
                ciem_discovery.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                ciem_discovery.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            data_sensitivity_discovery = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.dataSensitivityDiscovery")
            if data_sensitivity_discovery is not None:
                data_sensitivity_discovery.set_prop("enabled", AAZBoolType, ".enabled")
                data_sensitivity_discovery.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                data_sensitivity_discovery.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            mdc_containers_agentless_discovery_k8s = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.mdcContainersAgentlessDiscoveryK8s")
            if mdc_containers_agentless_discovery_k8s is not None:
                mdc_containers_agentless_discovery_k8s.set_prop("enabled", AAZBoolType, ".enabled")
                mdc_containers_agentless_discovery_k8s.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                mdc_containers_agentless_discovery_k8s.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            mdc_containers_image_assessment = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.mdcContainersImageAssessment")
            if mdc_containers_image_assessment is not None:
                mdc_containers_image_assessment.set_prop("enabled", AAZBoolType, ".enabled")
                mdc_containers_image_assessment.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                mdc_containers_image_assessment.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            vm_scanners = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.vmScanners")
            if vm_scanners is not None:
                vm_scanners.set_prop("configuration", AAZObjectType, ".configuration")
                vm_scanners.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.vmScanners.configuration")
            if configuration is not None:
                configuration.set_prop("exclusionTags", AAZDictType, ".exclusion_tags")
                configuration.set_prop("scanningMode", AAZStrType, ".scanning_mode")

            exclusion_tags = _builder.get(".properties.offerings[]{offeringType:DefenderCspmGcp}.vmScanners.configuration.exclusionTags")
            if exclusion_tags is not None:
                exclusion_tags.set_elements(AAZStrType, ".")

            disc_defender_for_containers_aws = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}")
            if disc_defender_for_containers_aws is not None:
                disc_defender_for_containers_aws.set_prop("autoProvisioning", AAZBoolType, ".defender_for_containers_aws.auto_provisioning")
                disc_defender_for_containers_aws.set_prop("cloudWatchToKinesis", AAZObjectType, ".defender_for_containers_aws.cloud_watch_to_kinesis")
                disc_defender_for_containers_aws.set_prop("containerVulnerabilityAssessment", AAZObjectType, ".defender_for_containers_aws.container_vulnerability_assessment")
                disc_defender_for_containers_aws.set_prop("containerVulnerabilityAssessmentTask", AAZObjectType, ".defender_for_containers_aws.container_vulnerability_assessment_task")
                disc_defender_for_containers_aws.set_prop("enableContainerVulnerabilityAssessment", AAZBoolType, ".defender_for_containers_aws.enable_container_vulnerability_assessment")
                disc_defender_for_containers_aws.set_prop("kinesisToS3", AAZObjectType, ".defender_for_containers_aws.kinesis_to_s3")
                disc_defender_for_containers_aws.set_prop("kubeAuditRetentionTime", AAZIntType, ".defender_for_containers_aws.kube_audit_retention_time")
                disc_defender_for_containers_aws.set_prop("kubernetesScubaReader", AAZObjectType, ".defender_for_containers_aws.kubernetes_scuba_reader")
                disc_defender_for_containers_aws.set_prop("kubernetesService", AAZObjectType, ".defender_for_containers_aws.kubernetes_service")
                disc_defender_for_containers_aws.set_prop("mdcContainersAgentlessDiscoveryK8s", AAZObjectType, ".defender_for_containers_aws.mdc_containers_agentless_discovery_k8s")
                disc_defender_for_containers_aws.set_prop("mdcContainersImageAssessment", AAZObjectType, ".defender_for_containers_aws.mdc_containers_image_assessment")
                disc_defender_for_containers_aws.set_prop("scubaExternalId", AAZStrType, ".defender_for_containers_aws.scuba_external_id")

            cloud_watch_to_kinesis = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.cloudWatchToKinesis")
            if cloud_watch_to_kinesis is not None:
                cloud_watch_to_kinesis.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            container_vulnerability_assessment = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.containerVulnerabilityAssessment")
            if container_vulnerability_assessment is not None:
                container_vulnerability_assessment.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            container_vulnerability_assessment_task = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.containerVulnerabilityAssessmentTask")
            if container_vulnerability_assessment_task is not None:
                container_vulnerability_assessment_task.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            kinesis_to_s3 = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.kinesisToS3")
            if kinesis_to_s3 is not None:
                kinesis_to_s3.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            kubernetes_scuba_reader = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.kubernetesScubaReader")
            if kubernetes_scuba_reader is not None:
                kubernetes_scuba_reader.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            kubernetes_service = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.kubernetesService")
            if kubernetes_service is not None:
                kubernetes_service.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            mdc_containers_agentless_discovery_k8s = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.mdcContainersAgentlessDiscoveryK8s")
            if mdc_containers_agentless_discovery_k8s is not None:
                mdc_containers_agentless_discovery_k8s.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                mdc_containers_agentless_discovery_k8s.set_prop("enabled", AAZBoolType, ".enabled")

            mdc_containers_image_assessment = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersAws}.mdcContainersImageAssessment")
            if mdc_containers_image_assessment is not None:
                mdc_containers_image_assessment.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                mdc_containers_image_assessment.set_prop("enabled", AAZBoolType, ".enabled")

            disc_defender_for_containers_gcp = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersGcp}")
            if disc_defender_for_containers_gcp is not None:
                disc_defender_for_containers_gcp.set_prop("auditLogsAutoProvisioningFlag", AAZBoolType, ".defender_for_containers_gcp.audit_logs_auto_provisioning_flag")
                disc_defender_for_containers_gcp.set_prop("dataPipelineNativeCloudConnection", AAZObjectType, ".defender_for_containers_gcp.data_pipeline_native_cloud_connection")
                disc_defender_for_containers_gcp.set_prop("defenderAgentAutoProvisioningFlag", AAZBoolType, ".defender_for_containers_gcp.defender_agent_auto_provisioning_flag")
                disc_defender_for_containers_gcp.set_prop("mdcContainersAgentlessDiscoveryK8s", AAZObjectType, ".defender_for_containers_gcp.mdc_containers_agentless_discovery_k8s")
                disc_defender_for_containers_gcp.set_prop("mdcContainersImageAssessment", AAZObjectType, ".defender_for_containers_gcp.mdc_containers_image_assessment")
                disc_defender_for_containers_gcp.set_prop("nativeCloudConnection", AAZObjectType, ".defender_for_containers_gcp.native_cloud_connection")
                disc_defender_for_containers_gcp.set_prop("policyAgentAutoProvisioningFlag", AAZBoolType, ".defender_for_containers_gcp.policy_agent_auto_provisioning_flag")

            data_pipeline_native_cloud_connection = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersGcp}.dataPipelineNativeCloudConnection")
            if data_pipeline_native_cloud_connection is not None:
                data_pipeline_native_cloud_connection.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                data_pipeline_native_cloud_connection.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            mdc_containers_agentless_discovery_k8s = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersGcp}.mdcContainersAgentlessDiscoveryK8s")
            if mdc_containers_agentless_discovery_k8s is not None:
                mdc_containers_agentless_discovery_k8s.set_prop("enabled", AAZBoolType, ".enabled")
                mdc_containers_agentless_discovery_k8s.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                mdc_containers_agentless_discovery_k8s.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            mdc_containers_image_assessment = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersGcp}.mdcContainersImageAssessment")
            if mdc_containers_image_assessment is not None:
                mdc_containers_image_assessment.set_prop("enabled", AAZBoolType, ".enabled")
                mdc_containers_image_assessment.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                mdc_containers_image_assessment.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            native_cloud_connection = _builder.get(".properties.offerings[]{offeringType:DefenderForContainersGcp}.nativeCloudConnection")
            if native_cloud_connection is not None:
                native_cloud_connection.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                native_cloud_connection.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            disc_defender_for_databases_aws = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesAws}")
            if disc_defender_for_databases_aws is not None:
                disc_defender_for_databases_aws.set_prop("arcAutoProvisioning", AAZObjectType, ".defender_for_databases_aws.arc_auto_provisioning")
                disc_defender_for_databases_aws.set_prop("databasesDspm", AAZObjectType, ".defender_for_databases_aws.databases_dspm")
                disc_defender_for_databases_aws.set_prop("rds", AAZObjectType, ".defender_for_databases_aws.rds")

            arc_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesAws}.arcAutoProvisioning")
            if arc_auto_provisioning is not None:
                arc_auto_provisioning.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                arc_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                arc_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesAws}.arcAutoProvisioning.configuration")
            if configuration is not None:
                configuration.set_prop("privateLinkScope", AAZStrType, ".private_link_scope")
                configuration.set_prop("proxy", AAZStrType, ".proxy")

            databases_dspm = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesAws}.databasesDspm")
            if databases_dspm is not None:
                databases_dspm.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                databases_dspm.set_prop("enabled", AAZBoolType, ".enabled")

            rds = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesAws}.rds")
            if rds is not None:
                rds.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                rds.set_prop("enabled", AAZBoolType, ".enabled")

            disc_defender_for_databases_gcp = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesGcp}")
            if disc_defender_for_databases_gcp is not None:
                disc_defender_for_databases_gcp.set_prop("arcAutoProvisioning", AAZObjectType, ".defender_for_databases_gcp.arc_auto_provisioning")
                disc_defender_for_databases_gcp.set_prop("defenderForDatabasesArcAutoProvisioning", AAZObjectType, ".defender_for_databases_gcp.defender_for_databases_arc_auto_provisioning")

            arc_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesGcp}.arcAutoProvisioning")
            if arc_auto_provisioning is not None:
                arc_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                arc_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesGcp}.arcAutoProvisioning.configuration")
            if configuration is not None:
                configuration.set_prop("privateLinkScope", AAZStrType, ".private_link_scope")
                configuration.set_prop("proxy", AAZStrType, ".proxy")

            defender_for_databases_arc_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForDatabasesGcp}.defenderForDatabasesArcAutoProvisioning")
            if defender_for_databases_arc_auto_provisioning is not None:
                defender_for_databases_arc_auto_provisioning.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                defender_for_databases_arc_auto_provisioning.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            disc_defender_for_servers_aws = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}")
            if disc_defender_for_servers_aws is not None:
                disc_defender_for_servers_aws.set_prop("arcAutoProvisioning", AAZObjectType, ".defender_for_servers_aws.arc_auto_provisioning")
                disc_defender_for_servers_aws.set_prop("defenderForServers", AAZObjectType, ".defender_for_servers_aws.defender_for_servers")
                disc_defender_for_servers_aws.set_prop("mdeAutoProvisioning", AAZObjectType, ".defender_for_servers_aws.mde_auto_provisioning")
                disc_defender_for_servers_aws.set_prop("subPlan", AAZObjectType, ".defender_for_servers_aws.sub_plan")
                disc_defender_for_servers_aws.set_prop("vaAutoProvisioning", AAZObjectType, ".defender_for_servers_aws.va_auto_provisioning")
                disc_defender_for_servers_aws.set_prop("vmScanners", AAZObjectType, ".defender_for_servers_aws.vm_scanners")

            arc_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.arcAutoProvisioning")
            if arc_auto_provisioning is not None:
                arc_auto_provisioning.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                arc_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                arc_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.arcAutoProvisioning.configuration")
            if configuration is not None:
                configuration.set_prop("privateLinkScope", AAZStrType, ".private_link_scope")
                configuration.set_prop("proxy", AAZStrType, ".proxy")

            defender_for_servers = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.defenderForServers")
            if defender_for_servers is not None:
                defender_for_servers.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            mde_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.mdeAutoProvisioning")
            if mde_auto_provisioning is not None:
                mde_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                mde_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            sub_plan = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.subPlan")
            if sub_plan is not None:
                sub_plan.set_prop("type", AAZStrType, ".type")

            va_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.vaAutoProvisioning")
            if va_auto_provisioning is not None:
                va_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                va_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.vaAutoProvisioning.configuration")
            if configuration is not None:
                configuration.set_prop("type", AAZStrType, ".type")

            vm_scanners = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.vmScanners")
            if vm_scanners is not None:
                vm_scanners.set_prop("configuration", AAZObjectType, ".configuration")
                vm_scanners.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.vmScanners.configuration")
            if configuration is not None:
                configuration.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")
                configuration.set_prop("exclusionTags", AAZDictType, ".exclusion_tags")
                configuration.set_prop("scanningMode", AAZStrType, ".scanning_mode")

            exclusion_tags = _builder.get(".properties.offerings[]{offeringType:DefenderForServersAws}.vmScanners.configuration.exclusionTags")
            if exclusion_tags is not None:
                exclusion_tags.set_elements(AAZStrType, ".")

            disc_defender_for_servers_gcp = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}")
            if disc_defender_for_servers_gcp is not None:
                disc_defender_for_servers_gcp.set_prop("arcAutoProvisioning", AAZObjectType, ".defender_for_servers_gcp.arc_auto_provisioning")
                disc_defender_for_servers_gcp.set_prop("defenderForServers", AAZObjectType, ".defender_for_servers_gcp.defender_for_servers")
                disc_defender_for_servers_gcp.set_prop("mdeAutoProvisioning", AAZObjectType, ".defender_for_servers_gcp.mde_auto_provisioning")
                disc_defender_for_servers_gcp.set_prop("subPlan", AAZObjectType, ".defender_for_servers_gcp.sub_plan")
                disc_defender_for_servers_gcp.set_prop("vaAutoProvisioning", AAZObjectType, ".defender_for_servers_gcp.va_auto_provisioning")
                disc_defender_for_servers_gcp.set_prop("vmScanners", AAZObjectType, ".defender_for_servers_gcp.vm_scanners")

            arc_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.arcAutoProvisioning")
            if arc_auto_provisioning is not None:
                arc_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                arc_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.arcAutoProvisioning.configuration")
            if configuration is not None:
                configuration.set_prop("privateLinkScope", AAZStrType, ".private_link_scope")
                configuration.set_prop("proxy", AAZStrType, ".proxy")

            defender_for_servers = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.defenderForServers")
            if defender_for_servers is not None:
                defender_for_servers.set_prop("serviceAccountEmailAddress", AAZStrType, ".service_account_email_address")
                defender_for_servers.set_prop("workloadIdentityProviderId", AAZStrType, ".workload_identity_provider_id")

            mde_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.mdeAutoProvisioning")
            if mde_auto_provisioning is not None:
                mde_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                mde_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            sub_plan = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.subPlan")
            if sub_plan is not None:
                sub_plan.set_prop("type", AAZStrType, ".type")

            va_auto_provisioning = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.vaAutoProvisioning")
            if va_auto_provisioning is not None:
                va_auto_provisioning.set_prop("configuration", AAZObjectType, ".configuration")
                va_auto_provisioning.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.vaAutoProvisioning.configuration")
            if configuration is not None:
                configuration.set_prop("type", AAZStrType, ".type")

            vm_scanners = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.vmScanners")
            if vm_scanners is not None:
                vm_scanners.set_prop("configuration", AAZObjectType, ".configuration")
                vm_scanners.set_prop("enabled", AAZBoolType, ".enabled")

            configuration = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.vmScanners.configuration")
            if configuration is not None:
                configuration.set_prop("exclusionTags", AAZDictType, ".exclusion_tags")
                configuration.set_prop("scanningMode", AAZStrType, ".scanning_mode")

            exclusion_tags = _builder.get(".properties.offerings[]{offeringType:DefenderForServersGcp}.vmScanners.configuration.exclusionTags")
            if exclusion_tags is not None:
                exclusion_tags.set_elements(AAZStrType, ".")

            disc_information_protection_aws = _builder.get(".properties.offerings[]{offeringType:InformationProtectionAws}")
            if disc_information_protection_aws is not None:
                disc_information_protection_aws.set_prop("informationProtection", AAZObjectType, ".information_protection_aws.information_protection")

            information_protection = _builder.get(".properties.offerings[]{offeringType:InformationProtectionAws}.informationProtection")
            if information_protection is not None:
                information_protection.set_prop("cloudRoleArn", AAZStrType, ".cloud_role_arn")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_security_connector_read = None

    @classmethod
    def _build_schema_security_connector_read(cls, _schema):
        if cls._schema_security_connector_read is not None:
            _schema.etag = cls._schema_security_connector_read.etag
            _schema.id = cls._schema_security_connector_read.id
            _schema.kind = cls._schema_security_connector_read.kind
            _schema.location = cls._schema_security_connector_read.location
            _schema.name = cls._schema_security_connector_read.name
            _schema.properties = cls._schema_security_connector_read.properties
            _schema.system_data = cls._schema_security_connector_read.system_data
            _schema.tags = cls._schema_security_connector_read.tags
            _schema.type = cls._schema_security_connector_read.type
            return

        cls._schema_security_connector_read = _schema_security_connector_read = AAZObjectType()

        security_connector_read = _schema_security_connector_read
        security_connector_read.etag = AAZStrType()
        security_connector_read.id = AAZStrType(
            flags={"read_only": True},
        )
        security_connector_read.kind = AAZStrType()
        security_connector_read.location = AAZStrType()
        security_connector_read.name = AAZStrType(
            flags={"read_only": True},
        )
        security_connector_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        security_connector_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        security_connector_read.tags = AAZDictType()
        security_connector_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_security_connector_read.properties
        properties.environment_data = AAZObjectType(
            serialized_name="environmentData",
        )
        properties.environment_name = AAZStrType(
            serialized_name="environmentName",
        )
        properties.hierarchy_identifier = AAZStrType(
            serialized_name="hierarchyIdentifier",
        )
        properties.hierarchy_identifier_trial_end_date = AAZStrType(
            serialized_name="hierarchyIdentifierTrialEndDate",
            flags={"read_only": True},
        )
        properties.offerings = AAZListType()

        environment_data = _schema_security_connector_read.properties.environment_data
        environment_data.environment_type = AAZStrType(
            serialized_name="environmentType",
            flags={"required": True},
        )

        disc_aws_account = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "AwsAccount")
        disc_aws_account.account_name = AAZStrType(
            serialized_name="accountName",
            flags={"read_only": True},
        )
        disc_aws_account.organizational_data = AAZObjectType(
            serialized_name="organizationalData",
        )
        disc_aws_account.regions = AAZListType()
        disc_aws_account.scan_interval = AAZIntType(
            serialized_name="scanInterval",
        )

        organizational_data = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data
        organizational_data.organization_membership_type = AAZStrType(
            serialized_name="organizationMembershipType",
            flags={"required": True},
        )

        disc_member = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Member")
        disc_member.parent_hierarchy_id = AAZStrType(
            serialized_name="parentHierarchyId",
        )

        disc_organization = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Organization")
        disc_organization.excluded_account_ids = AAZListType(
            serialized_name="excludedAccountIds",
        )
        disc_organization.stackset_name = AAZStrType(
            serialized_name="stacksetName",
        )

        excluded_account_ids = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "AwsAccount").organizational_data.discriminate_by("organization_membership_type", "Organization").excluded_account_ids
        excluded_account_ids.Element = AAZStrType()

        regions = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "AwsAccount").regions
        regions.Element = AAZStrType()

        disc_gcp_project = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "GcpProject")
        disc_gcp_project.organizational_data = AAZObjectType(
            serialized_name="organizationalData",
        )
        disc_gcp_project.project_details = AAZObjectType(
            serialized_name="projectDetails",
        )
        disc_gcp_project.scan_interval = AAZIntType(
            serialized_name="scanInterval",
        )

        organizational_data = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data
        organizational_data.organization_membership_type = AAZStrType(
            serialized_name="organizationMembershipType",
            flags={"required": True},
        )

        disc_member = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Member")
        disc_member.management_project_number = AAZStrType(
            serialized_name="managementProjectNumber",
        )
        disc_member.parent_hierarchy_id = AAZStrType(
            serialized_name="parentHierarchyId",
        )

        disc_organization = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Organization")
        disc_organization.excluded_project_numbers = AAZListType(
            serialized_name="excludedProjectNumbers",
        )
        disc_organization.organization_name = AAZStrType(
            serialized_name="organizationName",
            flags={"read_only": True},
        )
        disc_organization.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        disc_organization.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        excluded_project_numbers = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "GcpProject").organizational_data.discriminate_by("organization_membership_type", "Organization").excluded_project_numbers
        excluded_project_numbers.Element = AAZStrType()

        project_details = _schema_security_connector_read.properties.environment_data.discriminate_by("environment_type", "GcpProject").project_details
        project_details.project_id = AAZStrType(
            serialized_name="projectId",
        )
        project_details.project_name = AAZStrType(
            serialized_name="projectName",
            flags={"read_only": True},
        )
        project_details.project_number = AAZStrType(
            serialized_name="projectNumber",
        )
        project_details.workload_identity_pool_id = AAZStrType(
            serialized_name="workloadIdentityPoolId",
            flags={"read_only": True},
        )

        offerings = _schema_security_connector_read.properties.offerings
        offerings.Element = AAZObjectType()

        _element = _schema_security_connector_read.properties.offerings.Element
        _element.description = AAZStrType(
            flags={"read_only": True},
        )
        _element.offering_type = AAZStrType(
            serialized_name="offeringType",
            flags={"required": True},
        )

        disc_cspm_monitor_aws = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorAws")
        disc_cspm_monitor_aws.native_cloud_connection = AAZObjectType(
            serialized_name="nativeCloudConnection",
        )

        native_cloud_connection = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorAws").native_cloud_connection
        native_cloud_connection.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        disc_cspm_monitor_gcp = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorGcp")
        disc_cspm_monitor_gcp.native_cloud_connection = AAZObjectType(
            serialized_name="nativeCloudConnection",
        )

        native_cloud_connection = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "CspmMonitorGcp").native_cloud_connection
        native_cloud_connection.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        native_cloud_connection.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        disc_defender_cspm_aws = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws")
        disc_defender_cspm_aws.ciem = AAZObjectType()
        disc_defender_cspm_aws.data_sensitivity_discovery = AAZObjectType(
            serialized_name="dataSensitivityDiscovery",
        )
        disc_defender_cspm_aws.databases_dspm = AAZObjectType(
            serialized_name="databasesDspm",
        )
        disc_defender_cspm_aws.mdc_containers_agentless_discovery_k8s = AAZObjectType(
            serialized_name="mdcContainersAgentlessDiscoveryK8s",
        )
        disc_defender_cspm_aws.mdc_containers_image_assessment = AAZObjectType(
            serialized_name="mdcContainersImageAssessment",
        )
        disc_defender_cspm_aws.vm_scanners = AAZObjectType(
            serialized_name="vmScanners",
        )

        ciem = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem
        ciem.ciem_discovery = AAZObjectType(
            serialized_name="ciemDiscovery",
        )
        ciem.ciem_oidc = AAZObjectType(
            serialized_name="ciemOidc",
        )

        ciem_discovery = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem.ciem_discovery
        ciem_discovery.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        ciem_oidc = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").ciem.ciem_oidc
        ciem_oidc.azure_active_directory_app_name = AAZStrType(
            serialized_name="azureActiveDirectoryAppName",
        )
        ciem_oidc.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        data_sensitivity_discovery = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").data_sensitivity_discovery
        data_sensitivity_discovery.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        data_sensitivity_discovery.enabled = AAZBoolType()

        databases_dspm = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").databases_dspm
        databases_dspm.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        databases_dspm.enabled = AAZBoolType()

        mdc_containers_agentless_discovery_k8s = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()

        mdc_containers_image_assessment = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").mdc_containers_image_assessment
        mdc_containers_image_assessment.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        mdc_containers_image_assessment.enabled = AAZBoolType()

        vm_scanners = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners
        vm_scanners.configuration = AAZObjectType()
        vm_scanners.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners.configuration
        configuration.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        configuration.exclusion_tags = AAZDictType(
            serialized_name="exclusionTags",
        )
        configuration.scanning_mode = AAZStrType(
            serialized_name="scanningMode",
        )

        exclusion_tags = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmAws").vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrType()

        disc_defender_cspm_gcp = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp")
        disc_defender_cspm_gcp.ciem_discovery = AAZObjectType(
            serialized_name="ciemDiscovery",
        )
        disc_defender_cspm_gcp.data_sensitivity_discovery = AAZObjectType(
            serialized_name="dataSensitivityDiscovery",
        )
        disc_defender_cspm_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectType(
            serialized_name="mdcContainersAgentlessDiscoveryK8s",
        )
        disc_defender_cspm_gcp.mdc_containers_image_assessment = AAZObjectType(
            serialized_name="mdcContainersImageAssessment",
        )
        disc_defender_cspm_gcp.vm_scanners = AAZObjectType(
            serialized_name="vmScanners",
        )

        ciem_discovery = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").ciem_discovery
        ciem_discovery.azure_active_directory_app_name = AAZStrType(
            serialized_name="azureActiveDirectoryAppName",
        )
        ciem_discovery.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        ciem_discovery.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        data_sensitivity_discovery = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").data_sensitivity_discovery
        data_sensitivity_discovery.enabled = AAZBoolType()
        data_sensitivity_discovery.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        data_sensitivity_discovery.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        mdc_containers_agentless_discovery_k8s = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()
        mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        mdc_containers_image_assessment = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").mdc_containers_image_assessment
        mdc_containers_image_assessment.enabled = AAZBoolType()
        mdc_containers_image_assessment.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        mdc_containers_image_assessment.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        vm_scanners = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners
        vm_scanners.configuration = AAZObjectType()
        vm_scanners.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners.configuration
        configuration.exclusion_tags = AAZDictType(
            serialized_name="exclusionTags",
        )
        configuration.scanning_mode = AAZStrType(
            serialized_name="scanningMode",
        )

        exclusion_tags = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderCspmGcp").vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrType()

        disc_defender_for_containers_aws = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws")
        disc_defender_for_containers_aws.auto_provisioning = AAZBoolType(
            serialized_name="autoProvisioning",
        )
        disc_defender_for_containers_aws.cloud_watch_to_kinesis = AAZObjectType(
            serialized_name="cloudWatchToKinesis",
        )
        disc_defender_for_containers_aws.container_vulnerability_assessment = AAZObjectType(
            serialized_name="containerVulnerabilityAssessment",
        )
        disc_defender_for_containers_aws.container_vulnerability_assessment_task = AAZObjectType(
            serialized_name="containerVulnerabilityAssessmentTask",
        )
        disc_defender_for_containers_aws.enable_container_vulnerability_assessment = AAZBoolType(
            serialized_name="enableContainerVulnerabilityAssessment",
        )
        disc_defender_for_containers_aws.kinesis_to_s3 = AAZObjectType(
            serialized_name="kinesisToS3",
        )
        disc_defender_for_containers_aws.kube_audit_retention_time = AAZIntType(
            serialized_name="kubeAuditRetentionTime",
        )
        disc_defender_for_containers_aws.kubernetes_scuba_reader = AAZObjectType(
            serialized_name="kubernetesScubaReader",
        )
        disc_defender_for_containers_aws.kubernetes_service = AAZObjectType(
            serialized_name="kubernetesService",
        )
        disc_defender_for_containers_aws.mdc_containers_agentless_discovery_k8s = AAZObjectType(
            serialized_name="mdcContainersAgentlessDiscoveryK8s",
        )
        disc_defender_for_containers_aws.mdc_containers_image_assessment = AAZObjectType(
            serialized_name="mdcContainersImageAssessment",
        )
        disc_defender_for_containers_aws.scuba_external_id = AAZStrType(
            serialized_name="scubaExternalId",
        )

        cloud_watch_to_kinesis = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").cloud_watch_to_kinesis
        cloud_watch_to_kinesis.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        container_vulnerability_assessment = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").container_vulnerability_assessment
        container_vulnerability_assessment.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        container_vulnerability_assessment_task = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").container_vulnerability_assessment_task
        container_vulnerability_assessment_task.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        kinesis_to_s3 = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kinesis_to_s3
        kinesis_to_s3.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        kubernetes_scuba_reader = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kubernetes_scuba_reader
        kubernetes_scuba_reader.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        kubernetes_service = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").kubernetes_service
        kubernetes_service.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        mdc_containers_agentless_discovery_k8s = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()

        mdc_containers_image_assessment = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersAws").mdc_containers_image_assessment
        mdc_containers_image_assessment.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        mdc_containers_image_assessment.enabled = AAZBoolType()

        disc_defender_for_containers_gcp = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp")
        disc_defender_for_containers_gcp.audit_logs_auto_provisioning_flag = AAZBoolType(
            serialized_name="auditLogsAutoProvisioningFlag",
        )
        disc_defender_for_containers_gcp.data_pipeline_native_cloud_connection = AAZObjectType(
            serialized_name="dataPipelineNativeCloudConnection",
        )
        disc_defender_for_containers_gcp.defender_agent_auto_provisioning_flag = AAZBoolType(
            serialized_name="defenderAgentAutoProvisioningFlag",
        )
        disc_defender_for_containers_gcp.mdc_containers_agentless_discovery_k8s = AAZObjectType(
            serialized_name="mdcContainersAgentlessDiscoveryK8s",
        )
        disc_defender_for_containers_gcp.mdc_containers_image_assessment = AAZObjectType(
            serialized_name="mdcContainersImageAssessment",
        )
        disc_defender_for_containers_gcp.native_cloud_connection = AAZObjectType(
            serialized_name="nativeCloudConnection",
        )
        disc_defender_for_containers_gcp.policy_agent_auto_provisioning_flag = AAZBoolType(
            serialized_name="policyAgentAutoProvisioningFlag",
        )

        data_pipeline_native_cloud_connection = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").data_pipeline_native_cloud_connection
        data_pipeline_native_cloud_connection.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        data_pipeline_native_cloud_connection.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        mdc_containers_agentless_discovery_k8s = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").mdc_containers_agentless_discovery_k8s
        mdc_containers_agentless_discovery_k8s.enabled = AAZBoolType()
        mdc_containers_agentless_discovery_k8s.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        mdc_containers_agentless_discovery_k8s.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        mdc_containers_image_assessment = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").mdc_containers_image_assessment
        mdc_containers_image_assessment.enabled = AAZBoolType()
        mdc_containers_image_assessment.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        mdc_containers_image_assessment.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        native_cloud_connection = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForContainersGcp").native_cloud_connection
        native_cloud_connection.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        native_cloud_connection.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        disc_defender_for_databases_aws = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws")
        disc_defender_for_databases_aws.arc_auto_provisioning = AAZObjectType(
            serialized_name="arcAutoProvisioning",
        )
        disc_defender_for_databases_aws.databases_dspm = AAZObjectType(
            serialized_name="databasesDspm",
        )
        disc_defender_for_databases_aws.rds = AAZObjectType()

        arc_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").arc_auto_provisioning
        arc_auto_provisioning.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        arc_auto_provisioning.configuration = AAZObjectType()
        arc_auto_provisioning.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrType(
            serialized_name="privateLinkScope",
        )
        configuration.proxy = AAZStrType()

        databases_dspm = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").databases_dspm
        databases_dspm.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        databases_dspm.enabled = AAZBoolType()

        rds = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesAws").rds
        rds.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        rds.enabled = AAZBoolType()

        disc_defender_for_databases_gcp = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp")
        disc_defender_for_databases_gcp.arc_auto_provisioning = AAZObjectType(
            serialized_name="arcAutoProvisioning",
        )
        disc_defender_for_databases_gcp.defender_for_databases_arc_auto_provisioning = AAZObjectType(
            serialized_name="defenderForDatabasesArcAutoProvisioning",
        )

        arc_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").arc_auto_provisioning
        arc_auto_provisioning.configuration = AAZObjectType()
        arc_auto_provisioning.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrType(
            serialized_name="privateLinkScope",
        )
        configuration.proxy = AAZStrType()

        defender_for_databases_arc_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForDatabasesGcp").defender_for_databases_arc_auto_provisioning
        defender_for_databases_arc_auto_provisioning.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        defender_for_databases_arc_auto_provisioning.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        disc_defender_for_servers_aws = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws")
        disc_defender_for_servers_aws.arc_auto_provisioning = AAZObjectType(
            serialized_name="arcAutoProvisioning",
        )
        disc_defender_for_servers_aws.defender_for_servers = AAZObjectType(
            serialized_name="defenderForServers",
        )
        disc_defender_for_servers_aws.mde_auto_provisioning = AAZObjectType(
            serialized_name="mdeAutoProvisioning",
        )
        disc_defender_for_servers_aws.sub_plan = AAZObjectType(
            serialized_name="subPlan",
        )
        disc_defender_for_servers_aws.va_auto_provisioning = AAZObjectType(
            serialized_name="vaAutoProvisioning",
        )
        disc_defender_for_servers_aws.vm_scanners = AAZObjectType(
            serialized_name="vmScanners",
        )

        arc_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").arc_auto_provisioning
        arc_auto_provisioning.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        arc_auto_provisioning.configuration = AAZObjectType()
        arc_auto_provisioning.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrType(
            serialized_name="privateLinkScope",
        )
        configuration.proxy = AAZStrType()

        defender_for_servers = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").defender_for_servers
        defender_for_servers.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        mde_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").mde_auto_provisioning
        mde_auto_provisioning.configuration = AAZObjectType()
        mde_auto_provisioning.enabled = AAZBoolType()

        sub_plan = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").sub_plan
        sub_plan.type = AAZStrType()

        va_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").va_auto_provisioning
        va_auto_provisioning.configuration = AAZObjectType()
        va_auto_provisioning.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").va_auto_provisioning.configuration
        configuration.type = AAZStrType()

        vm_scanners = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners
        vm_scanners.configuration = AAZObjectType()
        vm_scanners.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners.configuration
        configuration.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )
        configuration.exclusion_tags = AAZDictType(
            serialized_name="exclusionTags",
        )
        configuration.scanning_mode = AAZStrType(
            serialized_name="scanningMode",
        )

        exclusion_tags = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersAws").vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrType()

        disc_defender_for_servers_gcp = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp")
        disc_defender_for_servers_gcp.arc_auto_provisioning = AAZObjectType(
            serialized_name="arcAutoProvisioning",
        )
        disc_defender_for_servers_gcp.defender_for_servers = AAZObjectType(
            serialized_name="defenderForServers",
        )
        disc_defender_for_servers_gcp.mde_auto_provisioning = AAZObjectType(
            serialized_name="mdeAutoProvisioning",
        )
        disc_defender_for_servers_gcp.sub_plan = AAZObjectType(
            serialized_name="subPlan",
        )
        disc_defender_for_servers_gcp.va_auto_provisioning = AAZObjectType(
            serialized_name="vaAutoProvisioning",
        )
        disc_defender_for_servers_gcp.vm_scanners = AAZObjectType(
            serialized_name="vmScanners",
        )

        arc_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").arc_auto_provisioning
        arc_auto_provisioning.configuration = AAZObjectType()
        arc_auto_provisioning.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").arc_auto_provisioning.configuration
        configuration.private_link_scope = AAZStrType(
            serialized_name="privateLinkScope",
        )
        configuration.proxy = AAZStrType()

        defender_for_servers = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").defender_for_servers
        defender_for_servers.service_account_email_address = AAZStrType(
            serialized_name="serviceAccountEmailAddress",
        )
        defender_for_servers.workload_identity_provider_id = AAZStrType(
            serialized_name="workloadIdentityProviderId",
        )

        mde_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").mde_auto_provisioning
        mde_auto_provisioning.configuration = AAZObjectType()
        mde_auto_provisioning.enabled = AAZBoolType()

        sub_plan = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").sub_plan
        sub_plan.type = AAZStrType()

        va_auto_provisioning = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").va_auto_provisioning
        va_auto_provisioning.configuration = AAZObjectType()
        va_auto_provisioning.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").va_auto_provisioning.configuration
        configuration.type = AAZStrType()

        vm_scanners = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners
        vm_scanners.configuration = AAZObjectType()
        vm_scanners.enabled = AAZBoolType()

        configuration = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners.configuration
        configuration.exclusion_tags = AAZDictType(
            serialized_name="exclusionTags",
        )
        configuration.scanning_mode = AAZStrType(
            serialized_name="scanningMode",
        )

        exclusion_tags = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "DefenderForServersGcp").vm_scanners.configuration.exclusion_tags
        exclusion_tags.Element = AAZStrType()

        disc_information_protection_aws = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "InformationProtectionAws")
        disc_information_protection_aws.information_protection = AAZObjectType(
            serialized_name="informationProtection",
        )

        information_protection = _schema_security_connector_read.properties.offerings.Element.discriminate_by("offering_type", "InformationProtectionAws").information_protection
        information_protection.cloud_role_arn = AAZStrType(
            serialized_name="cloudRoleArn",
        )

        system_data = _schema_security_connector_read.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        tags = _schema_security_connector_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_security_connector_read.etag
        _schema.id = cls._schema_security_connector_read.id
        _schema.kind = cls._schema_security_connector_read.kind
        _schema.location = cls._schema_security_connector_read.location
        _schema.name = cls._schema_security_connector_read.name
        _schema.properties = cls._schema_security_connector_read.properties
        _schema.system_data = cls._schema_security_connector_read.system_data
        _schema.tags = cls._schema_security_connector_read.tags
        _schema.type = cls._schema_security_connector_read.type


__all__ = ["Update"]
