# CiviCRM 5.38.0

Released June 2, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Civi::log()->debug() should only log if debugging is enabled
  ([community/feature-request#12](https://lab.civicrm.org/community/feature-request/-/issues/12):
  [20079](https://github.com/civicrm/civicrm-core/pull/20079))**

  Makes it easier to route log messages based on their topic (e.g.
  CiviContribute-related logs vs CiviMail-related logs).

- **We should not be auto-generating 5.xx.beta1.mysql.tpl files
  ([dev/release#16](https://lab.civicrm.org/dev/release/-/issues/16):
  [19744](https://github.com/civicrm/civicrm-core/pull/19744))**

  Streamlines the upgrader by removing a number of empty upgrade steps.

- **SearchBuilder: contact search for tags with child-tags broken when using '='
  operator ([dev/core#2502](https://lab.civicrm.org/dev/core/-/issues/2502):
  [20016](https://github.com/civicrm/civicrm-core/pull/20016))**

  Adds unit test for SearchBuilder fix.

- **Import the base upgrader
  ([dev/core#2547](https://lab.civicrm.org/dev/core/-/issues/2547):
  [20090](https://github.com/civicrm/civicrm-core/pull/20090))**

  Moves the extension upgrader, base upgrader class to core.

- **Add contact source column in some Reports
  ([20112](https://github.com/civicrm/civicrm-core/pull/20112))**

  Improves reports by adding a contact source column option.

- **SearchKit - Make contribution tasks available as actions
  ([20004](https://github.com/civicrm/civicrm-core/pull/20004))**

  Improves the SearchKit UI by making contribution tasks available as actions.

- **Move reCAPTCHA to core extension (Work Towards
  [dev/core#2571](https://lab.civicrm.org/dev/core/-/issues/2571):
  [20166](https://github.com/civicrm/civicrm-core/pull/20166),
  [20193](https://github.com/civicrm/civicrm-core/pull/20193) and
  [20199](https://github.com/civicrm/civicrm-core/pull/20199))**

  Code cleanup in preparation of moving reCAPTCHA to its own extension.

- **Api4 Services - Lazy-load subscriber-objects
  ([20221](https://github.com/civicrm/civicrm-core/pull/20221))**

  Improves loading of APIv4 subscriber objects.

- **Authx - Retain authentication outcome/metadata
  ([20026](https://github.com/civicrm/civicrm-core/pull/20026))**

  Improves the internal APIs for Authx. Authx supports additional ways to
  authenticate requests (e.g. passwords, API keys, JWTs). With this patchset, we
  have an internal way to see how the user was authenticated, e.g.

- **Increase civicrm_queue_item.data field size
  ([20107](https://github.com/civicrm/civicrm-core/pull/20107))**

  Changes the data type for the `data` column on the `civicrm_queue_item` table
  from TEXT to LONGTEXT.

- **Include more data in error message
  ([20110](https://github.com/civicrm/civicrm-core/pull/20110))**

  More explicit error messaging.

- **Add 'contact-actions-ribbon' region
  ([20108](https://github.com/civicrm/civicrm-core/pull/20108))**

  Adds a region to the top of the contact summary screen where action buttons
  go.

### CiviContribute

- **Add pager to bottom of Manage Contribution Pages
  ([20061](https://github.com/civicrm/civicrm-core/pull/20061))**

  Improves the UI by adding a pager to the Manage Contribution Pages form.

- **Add installments to propertyBag
  ([20023](https://github.com/civicrm/civicrm-core/pull/20023))**

  Adds installments property to propertyBag.

- **Define return parameters for doPayment (Work Towards
  [dev/financial#141](https://lab.civicrm.org/dev/financial/-/issues/141):
  [20021](https://github.com/civicrm/civicrm-core/pull/20021))**

  Ensures the core doPayment function returns payment_status.

- **Add support for receipt task outside the search process
  ([19848](https://github.com/civicrm/civicrm-core/pull/19848))**

  Adds support for url-based receipt sending.

### CiviMail

- **Make it possible to make a copy of a draft mailing
  ([dev/mail#90](https://lab.civicrm.org/dev/mail/-/issues/90):
  [20058](https://github.com/civicrm/civicrm-core/pull/20058))**

  Allow re-use mailing of draft mailings and adhoc mailings.

### Drupal Integration

- **In Drupal8, CMS intergration don't show table mapping
  ([dev/core#2490](https://lab.civicrm.org/dev/core/-/issues/2490):
  [19989](https://github.com/civicrm/civicrm-core/pull/19989))**

  Hides table mapping for Drupal8 integrations because it is not necessary.

- **Consider joining the GitHub Sponsors program (Work Towards
  [community/sustainability#20](https://lab.civicrm.org/community/sustainability/-/issues/20):
  [644](https://github.com/civicrm/civicrm-drupal/pull/644) and
  [63](https://github.com/civicrm/civicrm-drupal-8/pull/63))**

  Add FUNDING.yml to display a SPONSOR link that directs to c.o.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Create User Record now hides the Password field and uses the check
  isUserRegistrationPermitted - which prevents Administrators from setting
  passwords for new Users
  ([dev/core#2605](https://lab.civicrm.org/dev/core/-/issues/2605):
  [20274](https://github.com/civicrm/civicrm-core/pull/20274))**

  This restores the ability for administrators to set passwords for new users on
  the Create User Record form.

- **Activity Type and Case Type not being combined correctly in Advanced Search
  ([dev/report#53](https://lab.civicrm.org/dev/report/-/issues/53):
  [20002](https://github.com/civicrm/civicrm-core/pull/20002))**

  Ensures when running an advanced search that displays related contacts with case
  parameters set, only contacts related to the relevant cases are displayed.

- **Upgrade CKEditor to be 4.16.1
  ([20428](https://github.com/civicrm/civicrm-core/pull/20428))**

  Change log is here https://github.com/ckeditor/ckeditor4/blob/major/CHANGES.md

- **Fix invalidate cache for smart groups
  ([dev/core#2516](https://lab.civicrm.org/dev/core/-/issues/2516):
  [19986](https://github.com/civicrm/civicrm-core/pull/19986))**

  Method CRM_Contact_BAO_GroupContactCache::invalidateGroupContactCache() is
  described as touching smart groups but there is no condition for smart groups.

- **APIv4 - Fix unserialize settings
  ([20048](https://github.com/civicrm/civicrm-core/pull/20048))**

  Fixes a bug in the APIv4 "Setting" entity where serialized values were not
  getting returned properly.

- **Globally reset angular hashPrefix
  ([20152](https://github.com/civicrm/civicrm-core/pull/20152))**

  Globally reset the AngularJS hash prefix for consistency across all modules
  and pages in CiviCRM.

- **PayPal fails to create contribution following duplicate merge when
  membership record has been deleted
  ([dev/core#2593](https://lab.civicrm.org/dev/core/-/issues/2593):
  [20244](https://github.com/civicrm/civicrm-core/pull/20244))**

  Stop passing membership id into recur notify.

- **Afform - Set default position for contact layout editor
  ([20228](https://github.com/civicrm/civicrm-core/pull/20228))**

  Makes Afform blocks appear in their default positions in the "System Default"
  layout in Contact Summary Editor 2.0+.

- **Search Kit links improvements
  ([20134](https://github.com/civicrm/civicrm-core/pull/20134))**

  Fixes some problems with creating links in Search Kit and improves the UX
  around editing links.

- **Uninstall for `org.civicrm.search` extension fails
  ([dev/core#2556](https://lab.civicrm.org/dev/core/-/issues/2556):
   [20124](https://github.com/civicrm/civicrm-core/pull/20124))**

  Renames the extension org.civicrm.search to org.civicrm.search_kit.

- **Redundant indexes (Work Towards
  [dev/core#2575](https://lab.civicrm.org/dev/core/-/issues/2575):
  [20245](https://github.com/civicrm/civicrm-core/pull/20245))**

  Removes a couple of indexes on the id field as they are duplicates.

- **system workflow template uses backend URL
  ([dev/core#2582](https://lab.civicrm.org/dev/core/-/issues/2582):
  [20203](https://github.com/civicrm/civicrm-core/pull/20203))**

- **Unable to send transactional email to more than 2 recipients if there is an
  attachment ([dev/core#2588](https://lab.civicrm.org/dev/core/-/issues/2588):
  [20222](https://github.com/civicrm/civicrm-core/pull/20222) and
  [20227](https://github.com/civicrm/civicrm-core/pull/20227))**

- **Afform - Fix saving joined entities (email, address, phone, etc)
  ([20264](https://github.com/civicrm/civicrm-core/pull/20264))**

- **Afform - Fix loading entities from url args
  ([20145](https://github.com/civicrm/civicrm-core/pull/20145))**

- **Afform - Improve integration with ContactLayout editor
  ([20042](https://github.com/civicrm/civicrm-core/pull/20042))**

- **Afform - include Generic.html by default
  ([dev/core#2533](https://lab.civicrm.org/dev/core/-/issues/2533):
  [20141](https://github.com/civicrm/civicrm-core/pull/20141))**

- **SearchKit - Fix updating Entity Ref fields
  ([20125](https://github.com/civicrm/civicrm-core/pull/20125))**

- **SearchKit - Exclude serialized fields from implicit join selection
  ([20156](https://github.com/civicrm/civicrm-core/pull/20156))**

- **SearchKit - Fix display of contact reference fields (single-value)
  ([20117](https://github.com/civicrm/civicrm-core/pull/20117))**

- **APIv4 - Setting api misc fixes & tests
  ([20191](https://github.com/civicrm/civicrm-core/pull/20191))**

- **Save entities created by api v4 to managed
  ([20105](https://github.com/civicrm/civicrm-core/pull/20105))**

- **APIv4 - Fix Setting api to work with index param
  ([20072](https://github.com/civicrm/civicrm-core/pull/20072))**

- **Fix enotice when Log service is swapped out
  ([20146](https://github.com/civicrm/civicrm-core/pull/20146))**

- **Fix PayPal IPN URL and WordPress URLs when Permalinks are set to "Plain"
  ([20063](https://github.com/civicrm/civicrm-core/pull/20063))**

- **fix capitalization to allow proper access to 'access AJAX API' perm.
  ([20200](https://github.com/civicrm/civicrm-core/pull/20200))**

- **Fix a copy-and-paste error in the field definitions for OAuthSysToken
  ([20157](https://github.com/civicrm/civicrm-core/pull/20157))**

- **Fixes issue with state/province & country not translating values
  ([20169](https://github.com/civicrm/civicrm-core/pull/20169))**

- **Enotice fix ([20122](https://github.com/civicrm/civicrm-core/pull/20122))**

- **Extensions - Setup `<classloader>` during installation
  ([20091](https://github.com/civicrm/civicrm-core/pull/20091))**

- **Extensions - Setup <classloader> during "enable" and "uninstall"
  ([20116](https://github.com/civicrm/civicrm-core/pull/20116))**

- **Fix for importing preferred language (and other fields) by label
  ([19886](https://github.com/civicrm/civicrm-core/pull/19886))**

- **Fix AuthX Setting Labels
  ([20055](https://github.com/civicrm/civicrm-core/pull/20055))**

- **Removed limit of 25 groups and past mailings
  ([20069](https://github.com/civicrm/civicrm-core/pull/20069))**

- **When generating boilerplate code from xml, make error text more helpful and
  spelt correctly
  ([20054](https://github.com/civicrm/civicrm-core/pull/20054))**

- **File CustomField: avoid renaming an empty file
  ([19890](https://github.com/civicrm/civicrm-core/pull/19890))**

- **Calling UFGroup.create to update a profile without specifying is_active=1
  disables the profile
  ([dev/core#2501](https://lab.civicrm.org/dev/core/-/issues/2501):
  [19995](https://github.com/civicrm/civicrm-core/pull/19995))**

- **CiviReport does not localize custom fields of type Number
  ([dev/core#2505](https://lab.civicrm.org/dev/core/-/issues/2505):
  [20123](https://github.com/civicrm/civicrm-core/pull/20123) and
  [20053](https://github.com/civicrm/civicrm-core/pull/20053))**

- **Autocomplete-select custom field (Multi-Select=true) values with checked are
  reset in case of form rule errors
  ([dev/core#2506](https://lab.civicrm.org/dev/core/-/issues/2506):
  [20137](https://github.com/civicrm/civicrm-core/pull/20137))**

- **Search kit: Links to case (and other) activities go to the wrong form
  ([dev/core#2509](https://lab.civicrm.org/dev/core/-/issues/2509):
  [20118](https://github.com/civicrm/civicrm-core/pull/20118),
  [20114](https://github.com/civicrm/civicrm-core/pull/20114)
  [20060](https://github.com/civicrm/civicrm-core/pull/20060) and
  [20106](https://github.com/civicrm/civicrm-core/pull/20106))**

- **Empty extension requires tag misevaluated
  ([dev/core#2536](https://lab.civicrm.org/dev/core/-/issues/2536):
  [20064](https://github.com/civicrm/civicrm-core/pull/20064))**

- **Clarify scheduled reminder options: Event Start Date -> Event Start, etc
  ([dev/core#2541](https://lab.civicrm.org/dev/core/-/issues/2541):
  [20070](https://github.com/civicrm/civicrm-core/pull/20070))**

- **Errors on merging contacts with websites
  ([dev/core#2549](https://lab.civicrm.org/dev/core/-/issues/2549):
  [20101](https://github.com/civicrm/civicrm-core/pull/20101))**

### CiviCampaign

- **Set html type of campaign fields
  ([20215](https://github.com/civicrm/civicrm-core/pull/20215))**

  Cleanup metadata for the campaign_id field.

- **Petition confirmation email places space at end of confirmation URL
  ([dev/core#403](https://lab.civicrm.org/dev/core/-/issues/403):
  [20080](https://github.com/civicrm/civicrm-core/pull/20080))**

  Remove trailing white space in url.

- **APIv4 - Don't show campaign_id in getFields if campaign component disabled
  ([20219](https://github.com/civicrm/civicrm-core/pull/20219))**

### CiviContribute

- **Undefined index: contribution in
  CRM_Contribute_BAO_Contribution::getContributionTokenValues()
  ([dev/core#2568](https://lab.civicrm.org/dev/core/-/issues/2568):
  [20188](https://github.com/civicrm/civicrm-core/pull/20188))**

  Fixes an undefined index error after sending thank-you emails/letters for
  contributions.

- **CiviCRM 5.35.1, truncation of money values where $1,000 donation is recorded
  as $1 which appears to be truncating at the thousand separator when using the
  Australian (AU) and US Locale
  ([dev/core#2493](https://lab.civicrm.org/dev/core/-/issues/2493):
  [19991](https://github.com/civicrm/civicrm-core/pull/19991))**

  Default to not cleaning money for order.create api.

- **Recurring contributions label on contribution pages is unstylable text,
  leading to problems with themes
  ([dev/core#1452](https://lab.civicrm.org/dev/core/-/issues/1452):
  [20092](https://github.com/civicrm/civicrm-core/pull/20092))**

- **Fix money formatting opps
  ([20277](https://github.com/civicrm/civicrm-core/pull/20277))**

- **Make reCAPTCHA not conditional on paymentprocessor on contribution page
  ([20180](https://github.com/civicrm/civicrm-core/pull/20180))**

- **Contribution.sendconfirmation API3 function should return
  ([20182](https://github.com/civicrm/civicrm-core/pull/20182))**

- **Suppress legacy warnings by default in propertyBag to allow transition to
  propertyBag without hitting legacy warnings on unconverted payment processors
  ([20038](https://github.com/civicrm/civicrm-core/pull/20038))**

- **Make it clear that doDirectPayment/doTransferCheckout are deprecated and
  should not be used
  ([20020](https://github.com/civicrm/civicrm-core/pull/20020))**

- **Fix Payment.create to update (recalculate) contribution fee_amount
  ([20008](https://github.com/civicrm/civicrm-core/pull/20008))**

### CiviEvent

- **Cannot "Transfer or Cancel" event participant as admin user
  ([dev/event#54](https://lab.civicrm.org/dev/event/-/issues/54):
  [20150](https://github.com/civicrm/civicrm-core/pull/20150))**

### CiviMember

- **Set the smarty variables for mem_status and mem_join_date for back-end
  membership renewals
  ([20224](https://github.com/civicrm/civicrm-core/pull/20224))**

- **Membership form Remove check for installments as not on the form (copied
  from shared code)
  ([19964](https://github.com/civicrm/civicrm-core/pull/19964))**

### Drupal integration

- **Make APIv4 Subscribers Public to fix D9 install
  ([20254](https://github.com/civicrm/civicrm-core/pull/20254))**

  Fixes a "The "Civi_Api4_Event_Subscriber_PermissionCheckSubscriber" service or
  alias has been removed..." failure on the D9 demo install.

- **Fix Drupal8 CiviCRM menu translation on multilingual (and ajax calls)
  ([20085](https://github.com/civicrm/civicrm-core/pull/20085))**

### Joomla integration

- **Cannot edit CiviCRM Joomla permissions (access control) in 5.37.0
  ([dev/core#2601](https://lab.civicrm.org/dev/core/-/issues/2601):
  [20256](https://github.com/civicrm/civicrm-core/pull/20256))**

### Wordpress Integration

- **WordPress - redirect after login from event registration or contribution
  page ([dev/core#2436](https://lab.civicrm.org/dev/core/-/issues/2436):
  [19718](https://github.com/civicrm/civicrm-core/pull/19718))**

- **Update WP permission page for new string array keys
  ([20045](https://github.com/civicrm/civicrm-core/pull/20045))**

## <a name="misc"></a>Miscellany

- **Add amount as standard property to PaymentPropertyBag
  ([20037](https://github.com/civicrm/civicrm-core/pull/20037))**

- **Use propertyBag in doPayment
  ([20022](https://github.com/civicrm/civicrm-core/pull/20022))**

- **Move tpl assignment to email function
  ([20013](https://github.com/civicrm/civicrm-core/pull/20013))**

- **Initial refactor of PayPal core processor to stop using
  doDirectPayment/doTransferCheckout
  ([20030](https://github.com/civicrm/civicrm-core/pull/20030))**

- **Convert Dummy payment processor to use doPayment function
  ([20029](https://github.com/civicrm/civicrm-core/pull/20029))**

- **Switch to Call contribution api
  ([20041](https://github.com/civicrm/civicrm-core/pull/20041))**

- **Alter dedupe code to call api rather than bao->save()
  ([20036](https://github.com/civicrm/civicrm-core/pull/20036))**

- **Fix the MOST out-of-date parts of the afform readme
  ([20100](https://github.com/civicrm/civicrm-core/pull/20100))**

- **oauth-client - Add test for existing Auth Code flow behavior
  ([20162](https://github.com/civicrm/civicrm-core/pull/20162))**

- **add me ([20183](https://github.com/civicrm/civicrm-core/pull/20183))**

- **Make send letter function available to searchkit, individual contributions
  ([20187](https://github.com/civicrm/civicrm-core/pull/20187))**

- **Extract sales tax test config to a trait
  ([20233](https://github.com/civicrm/civicrm-core/pull/20233))**

- **APIv4 - Remove unnecessary custom getActions class
  ([20181](https://github.com/civicrm/civicrm-core/pull/20181))**

- **APIv4 - Remove unnecessary class override (handled by generic)
  ([20173](https://github.com/civicrm/civicrm-core/pull/20173))**

- **APIv4 - Improve entity name lookup
  ([20056](https://github.com/civicrm/civicrm-core/pull/20056))**

- **APIv4 - Deprecate nonstandard syntax for implicit joins
  ([20130](https://github.com/civicrm/civicrm-core/pull/20130))**

- **Extract out getReceiveDate
  ([20007](https://github.com/civicrm/civicrm-core/pull/20007))**

- **Simplify mailing check
  ([20076](https://github.com/civicrm/civicrm-core/pull/20076))**

- **Remove unused functions
  ([20099](https://github.com/civicrm/civicrm-core/pull/20099))**

- **Replace string org.civicrm.search -> org.civicrm.search_kit
  ([20132](https://github.com/civicrm/civicrm-core/pull/20132))**

- **Move more functions to the pdfLetter class
  ([20143](https://github.com/civicrm/civicrm-core/pull/20143))**

- **Remove apparent copy & paste from Contribution pdf letter function
  ([20161](https://github.com/civicrm/civicrm-core/pull/20161))**

- **Remove reference to trxn_id, not on form, from previously shared code
  ([19965](https://github.com/civicrm/civicrm-core/pull/19965))**

- **Add deprected warning to apparently unused functions
  ([20192](https://github.com/civicrm/civicrm-core/pull/20192))**

- **[REF] Add strict types to Utils_Mail::Send
  ([20171](https://github.com/civicrm/civicrm-core/pull/20171))**

- **REF Cleanup ReCAPTCHA code
  ([20167](https://github.com/civicrm/civicrm-core/pull/20167))**

- **[REF] Post move cleanup - switch from $form to $this
  ([20160](https://github.com/civicrm/civicrm-core/pull/20160))**

- **REF reCAPTCHA Simplify buildCustom function on Registration form
  ([20164](https://github.com/civicrm/civicrm-core/pull/20164))**

- **REF reCAPTCHA Simplify buildCustom function on Signature form
  ([20165](https://github.com/civicrm/civicrm-core/pull/20165))**

- **[REF] Minor tidy up - use writeRecord
  ([20159](https://github.com/civicrm/civicrm-core/pull/20159))**

- **[REF] Move more functions back to pdfLetter class
  ([20155](https://github.com/civicrm/civicrm-core/pull/20155))**

- **[REF] Fix Security status check urls to work on WordPress
  ([20111](https://github.com/civicrm/civicrm-core/pull/20111))**

- **[REF] Move functions back to class that uses it
  ([20136](https://github.com/civicrm/civicrm-core/pull/20136))**

- **[Ref] Simplify getMembershipParameters
  ([20014](https://github.com/civicrm/civicrm-core/pull/20014))**

- **(REF) Payflow Pro - Migrate code into a core extension
  ([20043](https://github.com/civicrm/civicrm-core/pull/20043))**

- **[REF] Minor code cleanup
  ([20175](https://github.com/civicrm/civicrm-core/pull/20175))**

- **[REF] Complete decommissioning of
  CRM/Contribute/Form/Task/PDFLetterCommon.php
  ([20172](https://github.com/civicrm/civicrm-core/pull/20172))**

- **[REF] Cleanup interaction with membership & membership id
  ([20153](https://github.com/civicrm/civicrm-core/pull/20153))**

- **[REF] Fix error where entryURL does not contain id of the contributio…
  ([19917](https://github.com/civicrm/civicrm-core/pull/19917))**

- **[REF] Simplify interaction with contributionRecur
  ([20017](https://github.com/civicrm/civicrm-core/pull/20017))**

- **[REF] Minor tidy up
  ([20194](https://github.com/civicrm/civicrm-core/pull/20194))**

- **[REF] Remove redundant code
  ([20138](https://github.com/civicrm/civicrm-core/pull/20138))**

- **[REF] [ipn] Simplification around contributionRecur ID
  ([19903](https://github.com/civicrm/civicrm-core/pull/19903))**

- **REF Update Pear/log to fix issues with install CiviCRM on Drupal 9.2
  ([20218](https://github.com/civicrm/civicrm-core/pull/20218))**

- **[REF] [Towards membership api] extract getContributionSource
  ([19966](https://github.com/civicrm/civicrm-core/pull/19966))**

- **[REF] [Towards membership api] Simplify determination on contribution recur
  contact id ([19902](https://github.com/civicrm/civicrm-core/pull/19902))**

- **[Ref] One more place to use total fn
  ([20010](https://github.com/civicrm/civicrm-core/pull/20010))**

- **[NFC] Consistency fix when defining CIVICRM_TEST
  ([64](https://github.com/civicrm/civicrm-drupal-8/pull/64))**

- **[NFC] [Test] Minor preliminary cleanup
  ([20006](https://github.com/civicrm/civicrm-core/pull/20006))**

- **[NFC] [Test] Preliminary cleanup
  ([20012](https://github.com/civicrm/civicrm-core/pull/20012))**

- **[NFC] Code cleanup, docblocks, strict comparison, type hints
  ([20240](https://github.com/civicrm/civicrm-core/pull/20240))**

- **[NFC] code cleanups in test class
  ([20237](https://github.com/civicrm/civicrm-core/pull/20237))**

- **[NFC] Regenerate Grant DAO
  ([20104](https://github.com/civicrm/civicrm-core/pull/20104))**

- **[NFC/Unit Test] - Help avoid problems when using assertApproxEquals with
  integers instead of fractions
  ([20089](https://github.com/civicrm/civicrm-core/pull/20089))**

- **(NFC) Fix possible flacky tests by splitting the parts of the checksum
  ([20088](https://github.com/civicrm/civicrm-core/pull/20088))**

- **Add unit test for core#19628
  ([19972](https://github.com/civicrm/civicrm-core/pull/19972))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Francis Whittle, Justin
Freeman; Benjamin W; Caltha - Tomasz Pietrzkowski; Christian Wach; CiviCoop -
Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CompuCorp - Ahed Eid, Omar Abu
Hussein; Coop SymbioTIC - Mathieu Lutfy; Dave D; Francesc Bassas i Bullich;
Fuzion - Jitendra Purohit; iXiam - Vangelis Pantazis; JMA Consulting - Monish
Deb, Seamus Lee; John Kingsnorth; Kartik Kathuria; Wildsight - Lars SG;
Lemniscus - Noah Miller; Megaphone Technology Consulting - Jon Goldberg; MJCO -
Mikey O'Toole; MJW Consulting - Matthew Wire; Olivier Hertrich; Progressive
Technology Project - Jamie McClelland; Squiffle Consulting - Aidan Saunders;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Australian Greens - John Twyman; Caltha - Tomasz
Pietrzkowski; Christian Wach; CiviCoop - Jaap Jansma; CiviDesk - Yashodha Chaku;
JMA Consulting - Edsel Lopez, Joe Murray; Richard van Oosterhout; Semper IT -
Karin Gerritsen; SYSTOPIA Organisationsberatung - Björn Endres; Tadpole
Collective - Kevin Cristiano; Web Access - Kurund Jalmi

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
