/* DBCS (double-byte) charset to unicode. 0x0000 means no mapping */
/* hi = (code >> 6) */
/* lo = code & 0x3F */
/* rawoff = cp949_to_unicode_hitbl[hi] */
/* if (rawoff != 0xFFFF) ucode = _raw[rawoff+lo] */
const uint16_t cp949_to_unicode_raw[20288] = {
	/* codebase=0x0000 rawbase=0x0000 */
	0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007, /* 0x0000-0x0007 */
	0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f, /* 0x0008-0x000F */
	0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017, /* 0x0010-0x0017 */
	0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f, /* 0x0018-0x001F */
	0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027, /* 0x0020-0x0027 */
	0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f, /* 0x0028-0x002F */
	0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037, /* 0x0030-0x0037 */
	0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f, /* 0x0038-0x003F */
	/* codebase=0x0040 rawbase=0x0040 */
	0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047, /* 0x0040-0x0047 */
	0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f, /* 0x0048-0x004F */
	0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057, /* 0x0050-0x0057 */
	0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f, /* 0x0058-0x005F */
	0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067, /* 0x0060-0x0067 */
	0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f, /* 0x0068-0x006F */
	0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077, /* 0x0070-0x0077 */
	0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f, /* 0x0078-0x007F */
	/* codebase=0x8140 rawbase=0x0080 */
	0x0000,0xac02,0xac03,0xac05,0xac06,0xac0b,0xac0c,0xac0d, /* 0x8140-0x8147 */
	0xac0e,0xac0f,0xac18,0xac1e,0xac1f,0xac21,0xac22,0xac23, /* 0x8148-0x814F */
	0xac25,0xac26,0xac27,0xac28,0xac29,0xac2a,0xac2b,0xac2e, /* 0x8150-0x8157 */
	0xac32,0xac33,0xac34,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8158-0x815F */
	0x0000,0xac35,0xac36,0xac37,0xac3a,0xac3b,0xac3d,0xac3e, /* 0x8160-0x8167 */
	0xac3f,0xac41,0xac42,0xac43,0xac44,0xac45,0xac46,0xac47, /* 0x8168-0x816F */
	0xac48,0xac49,0xac4a,0xac4c,0xac4e,0xac4f,0xac50,0xac51, /* 0x8170-0x8177 */
	0xac52,0xac53,0xac55,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8178-0x817F */
	/* codebase=0x8180 rawbase=0x00c0 */
	0x0000,0xac56,0xac57,0xac59,0xac5a,0xac5b,0xac5d,0xac5e, /* 0x8180-0x8187 */
	0xac5f,0xac60,0xac61,0xac62,0xac63,0xac64,0xac65,0xac66, /* 0x8188-0x818F */
	0xac67,0xac68,0xac69,0xac6a,0xac6b,0xac6c,0xac6d,0xac6e, /* 0x8190-0x8197 */
	0xac6f,0xac72,0xac73,0xac75,0xac76,0xac79,0xac7b,0xac7c, /* 0x8198-0x819F */
	0xac7d,0xac7e,0xac7f,0xac82,0xac87,0xac88,0xac8d,0xac8e, /* 0x81A0-0x81A7 */
	0xac8f,0xac91,0xac92,0xac93,0xac95,0xac96,0xac97,0xac98, /* 0x81A8-0x81AF */
	0xac99,0xac9a,0xac9b,0xac9e,0xaca2,0xaca3,0xaca4,0xaca5, /* 0x81B0-0x81B7 */
	0xaca6,0xaca7,0xacab,0xacad,0xacae,0xacb1,0xacb2,0xacb3, /* 0x81B8-0x81BF */
	/* codebase=0x81c0 rawbase=0x0100 */
	0xacb4,0xacb5,0xacb6,0xacb7,0xacba,0xacbe,0xacbf,0xacc0, /* 0x81C0-0x81C7 */
	0xacc2,0xacc3,0xacc5,0xacc6,0xacc7,0xacc9,0xacca,0xaccb, /* 0x81C8-0x81CF */
	0xaccd,0xacce,0xaccf,0xacd0,0xacd1,0xacd2,0xacd3,0xacd4, /* 0x81D0-0x81D7 */
	0xacd6,0xacd8,0xacd9,0xacda,0xacdb,0xacdc,0xacdd,0xacde, /* 0x81D8-0x81DF */
	0xacdf,0xace2,0xace3,0xace5,0xace6,0xace9,0xaceb,0xaced, /* 0x81E0-0x81E7 */
	0xacee,0xacf2,0xacf4,0xacf7,0xacf8,0xacf9,0xacfa,0xacfb, /* 0x81E8-0x81EF */
	0xacfe,0xacff,0xad01,0xad02,0xad03,0xad05,0xad07,0xad08, /* 0x81F0-0x81F7 */
	0xad09,0xad0a,0xad0b,0xad0e,0xad10,0xad12,0xad13,0x0000, /* 0x81F8-0x81FF */
	/* codebase=0x8240 rawbase=0x0140 */
	0x0000,0xad14,0xad15,0xad16,0xad17,0xad19,0xad1a,0xad1b, /* 0x8240-0x8247 */
	0xad1d,0xad1e,0xad1f,0xad21,0xad22,0xad23,0xad24,0xad25, /* 0x8248-0x824F */
	0xad26,0xad27,0xad28,0xad2a,0xad2b,0xad2e,0xad2f,0xad30, /* 0x8250-0x8257 */
	0xad31,0xad32,0xad33,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8258-0x825F */
	0x0000,0xad36,0xad37,0xad39,0xad3a,0xad3b,0xad3d,0xad3e, /* 0x8260-0x8267 */
	0xad3f,0xad40,0xad41,0xad42,0xad43,0xad46,0xad48,0xad4a, /* 0x8268-0x826F */
	0xad4b,0xad4c,0xad4d,0xad4e,0xad4f,0xad51,0xad52,0xad53, /* 0x8270-0x8277 */
	0xad55,0xad56,0xad57,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8278-0x827F */
	/* codebase=0x8280 rawbase=0x0180 */
	0x0000,0xad59,0xad5a,0xad5b,0xad5c,0xad5d,0xad5e,0xad5f, /* 0x8280-0x8287 */
	0xad60,0xad62,0xad64,0xad65,0xad66,0xad67,0xad68,0xad69, /* 0x8288-0x828F */
	0xad6a,0xad6b,0xad6e,0xad6f,0xad71,0xad72,0xad77,0xad78, /* 0x8290-0x8297 */
	0xad79,0xad7a,0xad7e,0xad80,0xad83,0xad84,0xad85,0xad86, /* 0x8298-0x829F */
	0xad87,0xad8a,0xad8b,0xad8d,0xad8e,0xad8f,0xad91,0xad92, /* 0x82A0-0x82A7 */
	0xad93,0xad94,0xad95,0xad96,0xad97,0xad98,0xad99,0xad9a, /* 0x82A8-0x82AF */
	0xad9b,0xad9e,0xad9f,0xada0,0xada1,0xada2,0xada3,0xada5, /* 0x82B0-0x82B7 */
	0xada6,0xada7,0xada8,0xada9,0xadaa,0xadab,0xadac,0xadad, /* 0x82B8-0x82BF */
	/* codebase=0x82c0 rawbase=0x01c0 */
	0xadae,0xadaf,0xadb0,0xadb1,0xadb2,0xadb3,0xadb4,0xadb5, /* 0x82C0-0x82C7 */
	0xadb6,0xadb8,0xadb9,0xadba,0xadbb,0xadbc,0xadbd,0xadbe, /* 0x82C8-0x82CF */
	0xadbf,0xadc2,0xadc3,0xadc5,0xadc6,0xadc7,0xadc9,0xadca, /* 0x82D0-0x82D7 */
	0xadcb,0xadcc,0xadcd,0xadce,0xadcf,0xadd2,0xadd4,0xadd5, /* 0x82D8-0x82DF */
	0xadd6,0xadd7,0xadd8,0xadd9,0xadda,0xaddb,0xaddd,0xadde, /* 0x82E0-0x82E7 */
	0xaddf,0xade1,0xade2,0xade3,0xade5,0xade6,0xade7,0xade8, /* 0x82E8-0x82EF */
	0xade9,0xadea,0xadeb,0xadec,0xaded,0xadee,0xadef,0xadf0, /* 0x82F0-0x82F7 */
	0xadf1,0xadf2,0xadf3,0xadf4,0xadf5,0xadf6,0xadf7,0x0000, /* 0x82F8-0x82FF */
	/* codebase=0x8340 rawbase=0x0200 */
	0x0000,0xadfa,0xadfb,0xadfd,0xadfe,0xae02,0xae03,0xae04, /* 0x8340-0x8347 */
	0xae05,0xae06,0xae07,0xae0a,0xae0c,0xae0e,0xae0f,0xae10, /* 0x8348-0x834F */
	0xae11,0xae12,0xae13,0xae15,0xae16,0xae17,0xae18,0xae19, /* 0x8350-0x8357 */
	0xae1a,0xae1b,0xae1c,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8358-0x835F */
	0x0000,0xae1d,0xae1e,0xae1f,0xae20,0xae21,0xae22,0xae23, /* 0x8360-0x8367 */
	0xae24,0xae25,0xae26,0xae27,0xae28,0xae29,0xae2a,0xae2b, /* 0x8368-0x836F */
	0xae2c,0xae2d,0xae2e,0xae2f,0xae32,0xae33,0xae35,0xae36, /* 0x8370-0x8377 */
	0xae39,0xae3b,0xae3c,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8378-0x837F */
	/* codebase=0x8380 rawbase=0x0240 */
	0x0000,0xae3d,0xae3e,0xae3f,0xae42,0xae44,0xae47,0xae48, /* 0x8380-0x8387 */
	0xae49,0xae4b,0xae4f,0xae51,0xae52,0xae53,0xae55,0xae57, /* 0x8388-0x838F */
	0xae58,0xae59,0xae5a,0xae5b,0xae5e,0xae62,0xae63,0xae64, /* 0x8390-0x8397 */
	0xae66,0xae67,0xae6a,0xae6b,0xae6d,0xae6e,0xae6f,0xae71, /* 0x8398-0x839F */
	0xae72,0xae73,0xae74,0xae75,0xae76,0xae77,0xae7a,0xae7e, /* 0x83A0-0x83A7 */
	0xae7f,0xae80,0xae81,0xae82,0xae83,0xae86,0xae87,0xae88, /* 0x83A8-0x83AF */
	0xae89,0xae8a,0xae8b,0xae8d,0xae8e,0xae8f,0xae90,0xae91, /* 0x83B0-0x83B7 */
	0xae92,0xae93,0xae94,0xae95,0xae96,0xae97,0xae98,0xae99, /* 0x83B8-0x83BF */
	/* codebase=0x83c0 rawbase=0x0280 */
	0xae9a,0xae9b,0xae9c,0xae9d,0xae9e,0xae9f,0xaea0,0xaea1, /* 0x83C0-0x83C7 */
	0xaea2,0xaea3,0xaea4,0xaea5,0xaea6,0xaea7,0xaea8,0xaea9, /* 0x83C8-0x83CF */
	0xaeaa,0xaeab,0xaeac,0xaead,0xaeae,0xaeaf,0xaeb0,0xaeb1, /* 0x83D0-0x83D7 */
	0xaeb2,0xaeb3,0xaeb4,0xaeb5,0xaeb6,0xaeb7,0xaeb8,0xaeb9, /* 0x83D8-0x83DF */
	0xaeba,0xaebb,0xaebf,0xaec1,0xaec2,0xaec3,0xaec5,0xaec6, /* 0x83E0-0x83E7 */
	0xaec7,0xaec8,0xaec9,0xaeca,0xaecb,0xaece,0xaed2,0xaed3, /* 0x83E8-0x83EF */
	0xaed4,0xaed5,0xaed6,0xaed7,0xaeda,0xaedb,0xaedd,0xaede, /* 0x83F0-0x83F7 */
	0xaedf,0xaee0,0xaee1,0xaee2,0xaee3,0xaee4,0xaee5,0x0000, /* 0x83F8-0x83FF */
	/* codebase=0x8440 rawbase=0x02c0 */
	0x0000,0xaee6,0xaee7,0xaee9,0xaeea,0xaeec,0xaeee,0xaeef, /* 0x8440-0x8447 */
	0xaef0,0xaef1,0xaef2,0xaef3,0xaef5,0xaef6,0xaef7,0xaef9, /* 0x8448-0x844F */
	0xaefa,0xaefb,0xaefd,0xaefe,0xaeff,0xaf00,0xaf01,0xaf02, /* 0x8450-0x8457 */
	0xaf03,0xaf04,0xaf05,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8458-0x845F */
	0x0000,0xaf06,0xaf09,0xaf0a,0xaf0b,0xaf0c,0xaf0e,0xaf0f, /* 0x8460-0x8467 */
	0xaf11,0xaf12,0xaf13,0xaf14,0xaf15,0xaf16,0xaf17,0xaf18, /* 0x8468-0x846F */
	0xaf19,0xaf1a,0xaf1b,0xaf1c,0xaf1d,0xaf1e,0xaf1f,0xaf20, /* 0x8470-0x8477 */
	0xaf21,0xaf22,0xaf23,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8478-0x847F */
	/* codebase=0x8480 rawbase=0x0300 */
	0x0000,0xaf24,0xaf25,0xaf26,0xaf27,0xaf28,0xaf29,0xaf2a, /* 0x8480-0x8487 */
	0xaf2b,0xaf2e,0xaf2f,0xaf31,0xaf33,0xaf35,0xaf36,0xaf37, /* 0x8488-0x848F */
	0xaf38,0xaf39,0xaf3a,0xaf3b,0xaf3e,0xaf40,0xaf44,0xaf45, /* 0x8490-0x8497 */
	0xaf46,0xaf47,0xaf4a,0xaf4b,0xaf4c,0xaf4d,0xaf4e,0xaf4f, /* 0x8498-0x849F */
	0xaf51,0xaf52,0xaf53,0xaf54,0xaf55,0xaf56,0xaf57,0xaf58, /* 0x84A0-0x84A7 */
	0xaf59,0xaf5a,0xaf5b,0xaf5e,0xaf5f,0xaf60,0xaf61,0xaf62, /* 0x84A8-0x84AF */
	0xaf63,0xaf66,0xaf67,0xaf68,0xaf69,0xaf6a,0xaf6b,0xaf6c, /* 0x84B0-0x84B7 */
	0xaf6d,0xaf6e,0xaf6f,0xaf70,0xaf71,0xaf72,0xaf73,0xaf74, /* 0x84B8-0x84BF */
	/* codebase=0x84c0 rawbase=0x0340 */
	0xaf75,0xaf76,0xaf77,0xaf78,0xaf7a,0xaf7b,0xaf7c,0xaf7d, /* 0x84C0-0x84C7 */
	0xaf7e,0xaf7f,0xaf81,0xaf82,0xaf83,0xaf85,0xaf86,0xaf87, /* 0x84C8-0x84CF */
	0xaf89,0xaf8a,0xaf8b,0xaf8c,0xaf8d,0xaf8e,0xaf8f,0xaf92, /* 0x84D0-0x84D7 */
	0xaf93,0xaf94,0xaf96,0xaf97,0xaf98,0xaf99,0xaf9a,0xaf9b, /* 0x84D8-0x84DF */
	0xaf9d,0xaf9e,0xaf9f,0xafa0,0xafa1,0xafa2,0xafa3,0xafa4, /* 0x84E0-0x84E7 */
	0xafa5,0xafa6,0xafa7,0xafa8,0xafa9,0xafaa,0xafab,0xafac, /* 0x84E8-0x84EF */
	0xafad,0xafae,0xafaf,0xafb0,0xafb1,0xafb2,0xafb3,0xafb4, /* 0x84F0-0x84F7 */
	0xafb5,0xafb6,0xafb7,0xafba,0xafbb,0xafbd,0xafbe,0x0000, /* 0x84F8-0x84FF */
	/* codebase=0x8540 rawbase=0x0380 */
	0x0000,0xafbf,0xafc1,0xafc2,0xafc3,0xafc4,0xafc5,0xafc6, /* 0x8540-0x8547 */
	0xafca,0xafcc,0xafcf,0xafd0,0xafd1,0xafd2,0xafd3,0xafd5, /* 0x8548-0x854F */
	0xafd6,0xafd7,0xafd8,0xafd9,0xafda,0xafdb,0xafdd,0xafde, /* 0x8550-0x8557 */
	0xafdf,0xafe0,0xafe1,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8558-0x855F */
	0x0000,0xafe2,0xafe3,0xafe4,0xafe5,0xafe6,0xafe7,0xafea, /* 0x8560-0x8567 */
	0xafeb,0xafec,0xafed,0xafee,0xafef,0xaff2,0xaff3,0xaff5, /* 0x8568-0x856F */
	0xaff6,0xaff7,0xaff9,0xaffa,0xaffb,0xaffc,0xaffd,0xaffe, /* 0x8570-0x8577 */
	0xafff,0xb002,0xb003,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8578-0x857F */
	/* codebase=0x8580 rawbase=0x03c0 */
	0x0000,0xb005,0xb006,0xb007,0xb008,0xb009,0xb00a,0xb00b, /* 0x8580-0x8587 */
	0xb00d,0xb00e,0xb00f,0xb011,0xb012,0xb013,0xb015,0xb016, /* 0x8588-0x858F */
	0xb017,0xb018,0xb019,0xb01a,0xb01b,0xb01e,0xb01f,0xb020, /* 0x8590-0x8597 */
	0xb021,0xb022,0xb023,0xb024,0xb025,0xb026,0xb027,0xb029, /* 0x8598-0x859F */
	0xb02a,0xb02b,0xb02c,0xb02d,0xb02e,0xb02f,0xb030,0xb031, /* 0x85A0-0x85A7 */
	0xb032,0xb033,0xb034,0xb035,0xb036,0xb037,0xb038,0xb039, /* 0x85A8-0x85AF */
	0xb03a,0xb03b,0xb03c,0xb03d,0xb03e,0xb03f,0xb040,0xb041, /* 0x85B0-0x85B7 */
	0xb042,0xb043,0xb046,0xb047,0xb049,0xb04b,0xb04d,0xb04f, /* 0x85B8-0x85BF */
	/* codebase=0x85c0 rawbase=0x0400 */
	0xb050,0xb051,0xb052,0xb056,0xb058,0xb05a,0xb05b,0xb05c, /* 0x85C0-0x85C7 */
	0xb05e,0xb05f,0xb060,0xb061,0xb062,0xb063,0xb064,0xb065, /* 0x85C8-0x85CF */
	0xb066,0xb067,0xb068,0xb069,0xb06a,0xb06b,0xb06c,0xb06d, /* 0x85D0-0x85D7 */
	0xb06e,0xb06f,0xb070,0xb071,0xb072,0xb073,0xb074,0xb075, /* 0x85D8-0x85DF */
	0xb076,0xb077,0xb078,0xb079,0xb07a,0xb07b,0xb07e,0xb07f, /* 0x85E0-0x85E7 */
	0xb081,0xb082,0xb083,0xb085,0xb086,0xb087,0xb088,0xb089, /* 0x85E8-0x85EF */
	0xb08a,0xb08b,0xb08e,0xb090,0xb092,0xb093,0xb094,0xb095, /* 0x85F0-0x85F7 */
	0xb096,0xb097,0xb09b,0xb09d,0xb09e,0xb0a3,0xb0a4,0x0000, /* 0x85F8-0x85FF */
	/* codebase=0x8640 rawbase=0x0440 */
	0x0000,0xb0a5,0xb0a6,0xb0a7,0xb0aa,0xb0b0,0xb0b2,0xb0b6, /* 0x8640-0x8647 */
	0xb0b7,0xb0b9,0xb0ba,0xb0bb,0xb0bd,0xb0be,0xb0bf,0xb0c0, /* 0x8648-0x864F */
	0xb0c1,0xb0c2,0xb0c3,0xb0c6,0xb0ca,0xb0cb,0xb0cc,0xb0cd, /* 0x8650-0x8657 */
	0xb0ce,0xb0cf,0xb0d2,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8658-0x865F */
	0x0000,0xb0d3,0xb0d5,0xb0d6,0xb0d7,0xb0d9,0xb0da,0xb0db, /* 0x8660-0x8667 */
	0xb0dc,0xb0dd,0xb0de,0xb0df,0xb0e1,0xb0e2,0xb0e3,0xb0e4, /* 0x8668-0x866F */
	0xb0e6,0xb0e7,0xb0e8,0xb0e9,0xb0ea,0xb0eb,0xb0ec,0xb0ed, /* 0x8670-0x8677 */
	0xb0ee,0xb0ef,0xb0f0,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8678-0x867F */
	/* codebase=0x8680 rawbase=0x0480 */
	0x0000,0xb0f1,0xb0f2,0xb0f3,0xb0f4,0xb0f5,0xb0f6,0xb0f7, /* 0x8680-0x8687 */
	0xb0f8,0xb0f9,0xb0fa,0xb0fb,0xb0fc,0xb0fd,0xb0fe,0xb0ff, /* 0x8688-0x868F */
	0xb100,0xb101,0xb102,0xb103,0xb104,0xb105,0xb106,0xb107, /* 0x8690-0x8697 */
	0xb10a,0xb10d,0xb10e,0xb10f,0xb111,0xb114,0xb115,0xb116, /* 0x8698-0x869F */
	0xb117,0xb11a,0xb11e,0xb11f,0xb120,0xb121,0xb122,0xb126, /* 0x86A0-0x86A7 */
	0xb127,0xb129,0xb12a,0xb12b,0xb12d,0xb12e,0xb12f,0xb130, /* 0x86A8-0x86AF */
	0xb131,0xb132,0xb133,0xb136,0xb13a,0xb13b,0xb13c,0xb13d, /* 0x86B0-0x86B7 */
	0xb13e,0xb13f,0xb142,0xb143,0xb145,0xb146,0xb147,0xb149, /* 0x86B8-0x86BF */
	/* codebase=0x86c0 rawbase=0x04c0 */
	0xb14a,0xb14b,0xb14c,0xb14d,0xb14e,0xb14f,0xb152,0xb153, /* 0x86C0-0x86C7 */
	0xb156,0xb157,0xb159,0xb15a,0xb15b,0xb15d,0xb15e,0xb15f, /* 0x86C8-0x86CF */
	0xb161,0xb162,0xb163,0xb164,0xb165,0xb166,0xb167,0xb168, /* 0x86D0-0x86D7 */
	0xb169,0xb16a,0xb16b,0xb16c,0xb16d,0xb16e,0xb16f,0xb170, /* 0x86D8-0x86DF */
	0xb171,0xb172,0xb173,0xb174,0xb175,0xb176,0xb177,0xb17a, /* 0x86E0-0x86E7 */
	0xb17b,0xb17d,0xb17e,0xb17f,0xb181,0xb183,0xb184,0xb185, /* 0x86E8-0x86EF */
	0xb186,0xb187,0xb18a,0xb18c,0xb18e,0xb18f,0xb190,0xb191, /* 0x86F0-0x86F7 */
	0xb195,0xb196,0xb197,0xb199,0xb19a,0xb19b,0xb19d,0x0000, /* 0x86F8-0x86FF */
	/* codebase=0x8740 rawbase=0x0500 */
	0x0000,0xb19e,0xb19f,0xb1a0,0xb1a1,0xb1a2,0xb1a3,0xb1a4, /* 0x8740-0x8747 */
	0xb1a5,0xb1a6,0xb1a7,0xb1a9,0xb1aa,0xb1ab,0xb1ac,0xb1ad, /* 0x8748-0x874F */
	0xb1ae,0xb1af,0xb1b0,0xb1b1,0xb1b2,0xb1b3,0xb1b4,0xb1b5, /* 0x8750-0x8757 */
	0xb1b6,0xb1b7,0xb1b8,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8758-0x875F */
	0x0000,0xb1b9,0xb1ba,0xb1bb,0xb1bc,0xb1bd,0xb1be,0xb1bf, /* 0x8760-0x8767 */
	0xb1c0,0xb1c1,0xb1c2,0xb1c3,0xb1c4,0xb1c5,0xb1c6,0xb1c7, /* 0x8768-0x876F */
	0xb1c8,0xb1c9,0xb1ca,0xb1cb,0xb1cd,0xb1ce,0xb1cf,0xb1d1, /* 0x8770-0x8777 */
	0xb1d2,0xb1d3,0xb1d5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8778-0x877F */
	/* codebase=0x8780 rawbase=0x0540 */
	0x0000,0xb1d6,0xb1d7,0xb1d8,0xb1d9,0xb1da,0xb1db,0xb1de, /* 0x8780-0x8787 */
	0xb1e0,0xb1e1,0xb1e2,0xb1e3,0xb1e4,0xb1e5,0xb1e6,0xb1e7, /* 0x8788-0x878F */
	0xb1ea,0xb1eb,0xb1ed,0xb1ee,0xb1ef,0xb1f1,0xb1f2,0xb1f3, /* 0x8790-0x8797 */
	0xb1f4,0xb1f5,0xb1f6,0xb1f7,0xb1f8,0xb1fa,0xb1fc,0xb1fe, /* 0x8798-0x879F */
	0xb1ff,0xb200,0xb201,0xb202,0xb203,0xb206,0xb207,0xb209, /* 0x87A0-0x87A7 */
	0xb20a,0xb20d,0xb20e,0xb20f,0xb210,0xb211,0xb212,0xb213, /* 0x87A8-0x87AF */
	0xb216,0xb218,0xb21a,0xb21b,0xb21c,0xb21d,0xb21e,0xb21f, /* 0x87B0-0x87B7 */
	0xb221,0xb222,0xb223,0xb224,0xb225,0xb226,0xb227,0xb228, /* 0x87B8-0x87BF */
	/* codebase=0x87c0 rawbase=0x0580 */
	0xb229,0xb22a,0xb22b,0xb22c,0xb22d,0xb22e,0xb22f,0xb230, /* 0x87C0-0x87C7 */
	0xb231,0xb232,0xb233,0xb235,0xb236,0xb237,0xb238,0xb239, /* 0x87C8-0x87CF */
	0xb23a,0xb23b,0xb23d,0xb23e,0xb23f,0xb240,0xb241,0xb242, /* 0x87D0-0x87D7 */
	0xb243,0xb244,0xb245,0xb246,0xb247,0xb248,0xb249,0xb24a, /* 0x87D8-0x87DF */
	0xb24b,0xb24c,0xb24d,0xb24e,0xb24f,0xb250,0xb251,0xb252, /* 0x87E0-0x87E7 */
	0xb253,0xb254,0xb255,0xb256,0xb257,0xb259,0xb25a,0xb25b, /* 0x87E8-0x87EF */
	0xb25d,0xb25e,0xb25f,0xb261,0xb262,0xb263,0xb264,0xb265, /* 0x87F0-0x87F7 */
	0xb266,0xb267,0xb26a,0xb26b,0xb26c,0xb26d,0xb26e,0x0000, /* 0x87F8-0x87FF */
	/* codebase=0x8840 rawbase=0x05c0 */
	0x0000,0xb26f,0xb270,0xb271,0xb272,0xb273,0xb276,0xb277, /* 0x8840-0x8847 */
	0xb278,0xb279,0xb27a,0xb27b,0xb27d,0xb27e,0xb27f,0xb280, /* 0x8848-0x884F */
	0xb281,0xb282,0xb283,0xb286,0xb287,0xb288,0xb28a,0xb28b, /* 0x8850-0x8857 */
	0xb28c,0xb28d,0xb28e,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8858-0x885F */
	0x0000,0xb28f,0xb292,0xb293,0xb295,0xb296,0xb297,0xb29b, /* 0x8860-0x8867 */
	0xb29c,0xb29d,0xb29e,0xb29f,0xb2a2,0xb2a4,0xb2a7,0xb2a8, /* 0x8868-0x886F */
	0xb2a9,0xb2ab,0xb2ad,0xb2ae,0xb2af,0xb2b1,0xb2b2,0xb2b3, /* 0x8870-0x8877 */
	0xb2b5,0xb2b6,0xb2b7,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8878-0x887F */
	/* codebase=0x8880 rawbase=0x0600 */
	0x0000,0xb2b8,0xb2b9,0xb2ba,0xb2bb,0xb2bc,0xb2bd,0xb2be, /* 0x8880-0x8887 */
	0xb2bf,0xb2c0,0xb2c1,0xb2c2,0xb2c3,0xb2c4,0xb2c5,0xb2c6, /* 0x8888-0x888F */
	0xb2c7,0xb2ca,0xb2cb,0xb2cd,0xb2ce,0xb2cf,0xb2d1,0xb2d3, /* 0x8890-0x8897 */
	0xb2d4,0xb2d5,0xb2d6,0xb2d7,0xb2da,0xb2dc,0xb2de,0xb2df, /* 0x8898-0x889F */
	0xb2e0,0xb2e1,0xb2e3,0xb2e7,0xb2e9,0xb2ea,0xb2f0,0xb2f1, /* 0x88A0-0x88A7 */
	0xb2f2,0xb2f6,0xb2fc,0xb2fd,0xb2fe,0xb302,0xb303,0xb305, /* 0x88A8-0x88AF */
	0xb306,0xb307,0xb309,0xb30a,0xb30b,0xb30c,0xb30d,0xb30e, /* 0x88B0-0x88B7 */
	0xb30f,0xb312,0xb316,0xb317,0xb318,0xb319,0xb31a,0xb31b, /* 0x88B8-0x88BF */
	/* codebase=0x88c0 rawbase=0x0640 */
	0xb31d,0xb31e,0xb31f,0xb320,0xb321,0xb322,0xb323,0xb324, /* 0x88C0-0x88C7 */
	0xb325,0xb326,0xb327,0xb328,0xb329,0xb32a,0xb32b,0xb32c, /* 0x88C8-0x88CF */
	0xb32d,0xb32e,0xb32f,0xb330,0xb331,0xb332,0xb333,0xb334, /* 0x88D0-0x88D7 */
	0xb335,0xb336,0xb337,0xb338,0xb339,0xb33a,0xb33b,0xb33c, /* 0x88D8-0x88DF */
	0xb33d,0xb33e,0xb33f,0xb340,0xb341,0xb342,0xb343,0xb344, /* 0x88E0-0x88E7 */
	0xb345,0xb346,0xb347,0xb348,0xb349,0xb34a,0xb34b,0xb34c, /* 0x88E8-0x88EF */
	0xb34d,0xb34e,0xb34f,0xb350,0xb351,0xb352,0xb353,0xb357, /* 0x88F0-0x88F7 */
	0xb359,0xb35a,0xb35d,0xb360,0xb361,0xb362,0xb363,0x0000, /* 0x88F8-0x88FF */
	/* codebase=0x8940 rawbase=0x0680 */
	0x0000,0xb366,0xb368,0xb36a,0xb36c,0xb36d,0xb36f,0xb372, /* 0x8940-0x8947 */
	0xb373,0xb375,0xb376,0xb377,0xb379,0xb37a,0xb37b,0xb37c, /* 0x8948-0x894F */
	0xb37d,0xb37e,0xb37f,0xb382,0xb386,0xb387,0xb388,0xb389, /* 0x8950-0x8957 */
	0xb38a,0xb38b,0xb38d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8958-0x895F */
	0x0000,0xb38e,0xb38f,0xb391,0xb392,0xb393,0xb395,0xb396, /* 0x8960-0x8967 */
	0xb397,0xb398,0xb399,0xb39a,0xb39b,0xb39c,0xb39d,0xb39e, /* 0x8968-0x896F */
	0xb39f,0xb3a2,0xb3a3,0xb3a4,0xb3a5,0xb3a6,0xb3a7,0xb3a9, /* 0x8970-0x8977 */
	0xb3aa,0xb3ab,0xb3ad,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8978-0x897F */
	/* codebase=0x8980 rawbase=0x06c0 */
	0x0000,0xb3ae,0xb3af,0xb3b0,0xb3b1,0xb3b2,0xb3b3,0xb3b4, /* 0x8980-0x8987 */
	0xb3b5,0xb3b6,0xb3b7,0xb3b8,0xb3b9,0xb3ba,0xb3bb,0xb3bc, /* 0x8988-0x898F */
	0xb3bd,0xb3be,0xb3bf,0xb3c0,0xb3c1,0xb3c2,0xb3c3,0xb3c6, /* 0x8990-0x8997 */
	0xb3c7,0xb3c9,0xb3ca,0xb3cd,0xb3cf,0xb3d1,0xb3d2,0xb3d3, /* 0x8998-0x899F */
	0xb3d6,0xb3d8,0xb3da,0xb3dc,0xb3de,0xb3df,0xb3e1,0xb3e2, /* 0x89A0-0x89A7 */
	0xb3e3,0xb3e5,0xb3e6,0xb3e7,0xb3e9,0xb3ea,0xb3eb,0xb3ec, /* 0x89A8-0x89AF */
	0xb3ed,0xb3ee,0xb3ef,0xb3f0,0xb3f1,0xb3f2,0xb3f3,0xb3f4, /* 0x89B0-0x89B7 */
	0xb3f5,0xb3f6,0xb3f7,0xb3f8,0xb3f9,0xb3fa,0xb3fb,0xb3fd, /* 0x89B8-0x89BF */
	/* codebase=0x89c0 rawbase=0x0700 */
	0xb3fe,0xb3ff,0xb400,0xb401,0xb402,0xb403,0xb404,0xb405, /* 0x89C0-0x89C7 */
	0xb406,0xb407,0xb408,0xb409,0xb40a,0xb40b,0xb40c,0xb40d, /* 0x89C8-0x89CF */
	0xb40e,0xb40f,0xb411,0xb412,0xb413,0xb414,0xb415,0xb416, /* 0x89D0-0x89D7 */
	0xb417,0xb419,0xb41a,0xb41b,0xb41d,0xb41e,0xb41f,0xb421, /* 0x89D8-0x89DF */
	0xb422,0xb423,0xb424,0xb425,0xb426,0xb427,0xb42a,0xb42c, /* 0x89E0-0x89E7 */
	0xb42d,0xb42e,0xb42f,0xb430,0xb431,0xb432,0xb433,0xb435, /* 0x89E8-0x89EF */
	0xb436,0xb437,0xb438,0xb439,0xb43a,0xb43b,0xb43c,0xb43d, /* 0x89F0-0x89F7 */
	0xb43e,0xb43f,0xb440,0xb441,0xb442,0xb443,0xb444,0x0000, /* 0x89F8-0x89FF */
	/* codebase=0x8a40 rawbase=0x0740 */
	0x0000,0xb445,0xb446,0xb447,0xb448,0xb449,0xb44a,0xb44b, /* 0x8A40-0x8A47 */
	0xb44c,0xb44d,0xb44e,0xb44f,0xb452,0xb453,0xb455,0xb456, /* 0x8A48-0x8A4F */
	0xb457,0xb459,0xb45a,0xb45b,0xb45c,0xb45d,0xb45e,0xb45f, /* 0x8A50-0x8A57 */
	0xb462,0xb464,0xb466,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8A58-0x8A5F */
	0x0000,0xb467,0xb468,0xb469,0xb46a,0xb46b,0xb46d,0xb46e, /* 0x8A60-0x8A67 */
	0xb46f,0xb470,0xb471,0xb472,0xb473,0xb474,0xb475,0xb476, /* 0x8A68-0x8A6F */
	0xb477,0xb478,0xb479,0xb47a,0xb47b,0xb47c,0xb47d,0xb47e, /* 0x8A70-0x8A77 */
	0xb47f,0xb481,0xb482,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8A78-0x8A7F */
	/* codebase=0x8a80 rawbase=0x0780 */
	0x0000,0xb483,0xb484,0xb485,0xb486,0xb487,0xb489,0xb48a, /* 0x8A80-0x8A87 */
	0xb48b,0xb48c,0xb48d,0xb48e,0xb48f,0xb490,0xb491,0xb492, /* 0x8A88-0x8A8F */
	0xb493,0xb494,0xb495,0xb496,0xb497,0xb498,0xb499,0xb49a, /* 0x8A90-0x8A97 */
	0xb49b,0xb49c,0xb49e,0xb49f,0xb4a0,0xb4a1,0xb4a2,0xb4a3, /* 0x8A98-0x8A9F */
	0xb4a5,0xb4a6,0xb4a7,0xb4a9,0xb4aa,0xb4ab,0xb4ad,0xb4ae, /* 0x8AA0-0x8AA7 */
	0xb4af,0xb4b0,0xb4b1,0xb4b2,0xb4b3,0xb4b4,0xb4b6,0xb4b8, /* 0x8AA8-0x8AAF */
	0xb4ba,0xb4bb,0xb4bc,0xb4bd,0xb4be,0xb4bf,0xb4c1,0xb4c2, /* 0x8AB0-0x8AB7 */
	0xb4c3,0xb4c5,0xb4c6,0xb4c7,0xb4c9,0xb4ca,0xb4cb,0xb4cc, /* 0x8AB8-0x8ABF */
	/* codebase=0x8ac0 rawbase=0x07c0 */
	0xb4cd,0xb4ce,0xb4cf,0xb4d1,0xb4d2,0xb4d3,0xb4d4,0xb4d6, /* 0x8AC0-0x8AC7 */
	0xb4d7,0xb4d8,0xb4d9,0xb4da,0xb4db,0xb4de,0xb4df,0xb4e1, /* 0x8AC8-0x8ACF */
	0xb4e2,0xb4e5,0xb4e7,0xb4e8,0xb4e9,0xb4ea,0xb4eb,0xb4ee, /* 0x8AD0-0x8AD7 */
	0xb4f0,0xb4f2,0xb4f3,0xb4f4,0xb4f5,0xb4f6,0xb4f7,0xb4f9, /* 0x8AD8-0x8ADF */
	0xb4fa,0xb4fb,0xb4fc,0xb4fd,0xb4fe,0xb4ff,0xb500,0xb501, /* 0x8AE0-0x8AE7 */
	0xb502,0xb503,0xb504,0xb505,0xb506,0xb507,0xb508,0xb509, /* 0x8AE8-0x8AEF */
	0xb50a,0xb50b,0xb50c,0xb50d,0xb50e,0xb50f,0xb510,0xb511, /* 0x8AF0-0x8AF7 */
	0xb512,0xb513,0xb516,0xb517,0xb519,0xb51a,0xb51d,0x0000, /* 0x8AF8-0x8AFF */
	/* codebase=0x8b40 rawbase=0x0800 */
	0x0000,0xb51e,0xb51f,0xb520,0xb521,0xb522,0xb523,0xb526, /* 0x8B40-0x8B47 */
	0xb52b,0xb52c,0xb52d,0xb52e,0xb52f,0xb532,0xb533,0xb535, /* 0x8B48-0x8B4F */
	0xb536,0xb537,0xb539,0xb53a,0xb53b,0xb53c,0xb53d,0xb53e, /* 0x8B50-0x8B57 */
	0xb53f,0xb542,0xb546,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8B58-0x8B5F */
	0x0000,0xb547,0xb548,0xb549,0xb54a,0xb54e,0xb54f,0xb551, /* 0x8B60-0x8B67 */
	0xb552,0xb553,0xb555,0xb556,0xb557,0xb558,0xb559,0xb55a, /* 0x8B68-0x8B6F */
	0xb55b,0xb55e,0xb562,0xb563,0xb564,0xb565,0xb566,0xb567, /* 0x8B70-0x8B77 */
	0xb568,0xb569,0xb56a,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8B78-0x8B7F */
	/* codebase=0x8b80 rawbase=0x0840 */
	0x0000,0xb56b,0xb56c,0xb56d,0xb56e,0xb56f,0xb570,0xb571, /* 0x8B80-0x8B87 */
	0xb572,0xb573,0xb574,0xb575,0xb576,0xb577,0xb578,0xb579, /* 0x8B88-0x8B8F */
	0xb57a,0xb57b,0xb57c,0xb57d,0xb57e,0xb57f,0xb580,0xb581, /* 0x8B90-0x8B97 */
	0xb582,0xb583,0xb584,0xb585,0xb586,0xb587,0xb588,0xb589, /* 0x8B98-0x8B9F */
	0xb58a,0xb58b,0xb58c,0xb58d,0xb58e,0xb58f,0xb590,0xb591, /* 0x8BA0-0x8BA7 */
	0xb592,0xb593,0xb594,0xb595,0xb596,0xb597,0xb598,0xb599, /* 0x8BA8-0x8BAF */
	0xb59a,0xb59b,0xb59c,0xb59d,0xb59e,0xb59f,0xb5a2,0xb5a3, /* 0x8BB0-0x8BB7 */
	0xb5a5,0xb5a6,0xb5a7,0xb5a9,0xb5ac,0xb5ad,0xb5ae,0xb5af, /* 0x8BB8-0x8BBF */
	/* codebase=0x8bc0 rawbase=0x0880 */
	0xb5b2,0xb5b6,0xb5b7,0xb5b8,0xb5b9,0xb5ba,0xb5be,0xb5bf, /* 0x8BC0-0x8BC7 */
	0xb5c1,0xb5c2,0xb5c3,0xb5c5,0xb5c6,0xb5c7,0xb5c8,0xb5c9, /* 0x8BC8-0x8BCF */
	0xb5ca,0xb5cb,0xb5ce,0xb5d2,0xb5d3,0xb5d4,0xb5d5,0xb5d6, /* 0x8BD0-0x8BD7 */
	0xb5d7,0xb5d9,0xb5da,0xb5db,0xb5dc,0xb5dd,0xb5de,0xb5df, /* 0x8BD8-0x8BDF */
	0xb5e0,0xb5e1,0xb5e2,0xb5e3,0xb5e4,0xb5e5,0xb5e6,0xb5e7, /* 0x8BE0-0x8BE7 */
	0xb5e8,0xb5e9,0xb5ea,0xb5eb,0xb5ed,0xb5ee,0xb5ef,0xb5f0, /* 0x8BE8-0x8BEF */
	0xb5f1,0xb5f2,0xb5f3,0xb5f4,0xb5f5,0xb5f6,0xb5f7,0xb5f8, /* 0x8BF0-0x8BF7 */
	0xb5f9,0xb5fa,0xb5fb,0xb5fc,0xb5fd,0xb5fe,0xb5ff,0x0000, /* 0x8BF8-0x8BFF */
	/* codebase=0x8c40 rawbase=0x08c0 */
	0x0000,0xb600,0xb601,0xb602,0xb603,0xb604,0xb605,0xb606, /* 0x8C40-0x8C47 */
	0xb607,0xb608,0xb609,0xb60a,0xb60b,0xb60c,0xb60d,0xb60e, /* 0x8C48-0x8C4F */
	0xb60f,0xb612,0xb613,0xb615,0xb616,0xb617,0xb619,0xb61a, /* 0x8C50-0x8C57 */
	0xb61b,0xb61c,0xb61d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8C58-0x8C5F */
	0x0000,0xb61e,0xb61f,0xb620,0xb621,0xb622,0xb623,0xb624, /* 0x8C60-0x8C67 */
	0xb626,0xb627,0xb628,0xb629,0xb62a,0xb62b,0xb62d,0xb62e, /* 0x8C68-0x8C6F */
	0xb62f,0xb630,0xb631,0xb632,0xb633,0xb635,0xb636,0xb637, /* 0x8C70-0x8C77 */
	0xb638,0xb639,0xb63a,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8C78-0x8C7F */
	/* codebase=0x8c80 rawbase=0x0900 */
	0x0000,0xb63b,0xb63c,0xb63d,0xb63e,0xb63f,0xb640,0xb641, /* 0x8C80-0x8C87 */
	0xb642,0xb643,0xb644,0xb645,0xb646,0xb647,0xb649,0xb64a, /* 0x8C88-0x8C8F */
	0xb64b,0xb64c,0xb64d,0xb64e,0xb64f,0xb650,0xb651,0xb652, /* 0x8C90-0x8C97 */
	0xb653,0xb654,0xb655,0xb656,0xb657,0xb658,0xb659,0xb65a, /* 0x8C98-0x8C9F */
	0xb65b,0xb65c,0xb65d,0xb65e,0xb65f,0xb660,0xb661,0xb662, /* 0x8CA0-0x8CA7 */
	0xb663,0xb665,0xb666,0xb667,0xb669,0xb66a,0xb66b,0xb66c, /* 0x8CA8-0x8CAF */
	0xb66d,0xb66e,0xb66f,0xb670,0xb671,0xb672,0xb673,0xb674, /* 0x8CB0-0x8CB7 */
	0xb675,0xb676,0xb677,0xb678,0xb679,0xb67a,0xb67b,0xb67c, /* 0x8CB8-0x8CBF */
	/* codebase=0x8cc0 rawbase=0x0940 */
	0xb67d,0xb67e,0xb67f,0xb680,0xb681,0xb682,0xb683,0xb684, /* 0x8CC0-0x8CC7 */
	0xb685,0xb686,0xb687,0xb688,0xb689,0xb68a,0xb68b,0xb68c, /* 0x8CC8-0x8CCF */
	0xb68d,0xb68e,0xb68f,0xb690,0xb691,0xb692,0xb693,0xb694, /* 0x8CD0-0x8CD7 */
	0xb695,0xb696,0xb697,0xb698,0xb699,0xb69a,0xb69b,0xb69e, /* 0x8CD8-0x8CDF */
	0xb69f,0xb6a1,0xb6a2,0xb6a3,0xb6a5,0xb6a6,0xb6a7,0xb6a8, /* 0x8CE0-0x8CE7 */
	0xb6a9,0xb6aa,0xb6ad,0xb6ae,0xb6af,0xb6b0,0xb6b2,0xb6b3, /* 0x8CE8-0x8CEF */
	0xb6b4,0xb6b5,0xb6b6,0xb6b7,0xb6b8,0xb6b9,0xb6ba,0xb6bb, /* 0x8CF0-0x8CF7 */
	0xb6bc,0xb6bd,0xb6be,0xb6bf,0xb6c0,0xb6c1,0xb6c2,0x0000, /* 0x8CF8-0x8CFF */
	/* codebase=0x8d40 rawbase=0x0980 */
	0x0000,0xb6c3,0xb6c4,0xb6c5,0xb6c6,0xb6c7,0xb6c8,0xb6c9, /* 0x8D40-0x8D47 */
	0xb6ca,0xb6cb,0xb6cc,0xb6cd,0xb6ce,0xb6cf,0xb6d0,0xb6d1, /* 0x8D48-0x8D4F */
	0xb6d2,0xb6d3,0xb6d5,0xb6d6,0xb6d7,0xb6d8,0xb6d9,0xb6da, /* 0x8D50-0x8D57 */
	0xb6db,0xb6dc,0xb6dd,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8D58-0x8D5F */
	0x0000,0xb6de,0xb6df,0xb6e0,0xb6e1,0xb6e2,0xb6e3,0xb6e4, /* 0x8D60-0x8D67 */
	0xb6e5,0xb6e6,0xb6e7,0xb6e8,0xb6e9,0xb6ea,0xb6eb,0xb6ec, /* 0x8D68-0x8D6F */
	0xb6ed,0xb6ee,0xb6ef,0xb6f1,0xb6f2,0xb6f3,0xb6f5,0xb6f6, /* 0x8D70-0x8D77 */
	0xb6f7,0xb6f9,0xb6fa,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8D78-0x8D7F */
	/* codebase=0x8d80 rawbase=0x09c0 */
	0x0000,0xb6fb,0xb6fc,0xb6fd,0xb6fe,0xb6ff,0xb702,0xb703, /* 0x8D80-0x8D87 */
	0xb704,0xb706,0xb707,0xb708,0xb709,0xb70a,0xb70b,0xb70c, /* 0x8D88-0x8D8F */
	0xb70d,0xb70e,0xb70f,0xb710,0xb711,0xb712,0xb713,0xb714, /* 0x8D90-0x8D97 */
	0xb715,0xb716,0xb717,0xb718,0xb719,0xb71a,0xb71b,0xb71c, /* 0x8D98-0x8D9F */
	0xb71d,0xb71e,0xb71f,0xb720,0xb721,0xb722,0xb723,0xb724, /* 0x8DA0-0x8DA7 */
	0xb725,0xb726,0xb727,0xb72a,0xb72b,0xb72d,0xb72e,0xb731, /* 0x8DA8-0x8DAF */
	0xb732,0xb733,0xb734,0xb735,0xb736,0xb737,0xb73a,0xb73c, /* 0x8DB0-0x8DB7 */
	0xb73d,0xb73e,0xb73f,0xb740,0xb741,0xb742,0xb743,0xb745, /* 0x8DB8-0x8DBF */
	/* codebase=0x8dc0 rawbase=0x0a00 */
	0xb746,0xb747,0xb749,0xb74a,0xb74b,0xb74d,0xb74e,0xb74f, /* 0x8DC0-0x8DC7 */
	0xb750,0xb751,0xb752,0xb753,0xb756,0xb757,0xb758,0xb759, /* 0x8DC8-0x8DCF */
	0xb75a,0xb75b,0xb75c,0xb75d,0xb75e,0xb75f,0xb761,0xb762, /* 0x8DD0-0x8DD7 */
	0xb763,0xb765,0xb766,0xb767,0xb769,0xb76a,0xb76b,0xb76c, /* 0x8DD8-0x8DDF */
	0xb76d,0xb76e,0xb76f,0xb772,0xb774,0xb776,0xb777,0xb778, /* 0x8DE0-0x8DE7 */
	0xb779,0xb77a,0xb77b,0xb77e,0xb77f,0xb781,0xb782,0xb783, /* 0x8DE8-0x8DEF */
	0xb785,0xb786,0xb787,0xb788,0xb789,0xb78a,0xb78b,0xb78e, /* 0x8DF0-0x8DF7 */
	0xb793,0xb794,0xb795,0xb79a,0xb79b,0xb79d,0xb79e,0x0000, /* 0x8DF8-0x8DFF */
	/* codebase=0x8e40 rawbase=0x0a40 */
	0x0000,0xb79f,0xb7a1,0xb7a2,0xb7a3,0xb7a4,0xb7a5,0xb7a6, /* 0x8E40-0x8E47 */
	0xb7a7,0xb7aa,0xb7ae,0xb7af,0xb7b0,0xb7b1,0xb7b2,0xb7b3, /* 0x8E48-0x8E4F */
	0xb7b6,0xb7b7,0xb7b9,0xb7ba,0xb7bb,0xb7bc,0xb7bd,0xb7be, /* 0x8E50-0x8E57 */
	0xb7bf,0xb7c0,0xb7c1,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8E58-0x8E5F */
	0x0000,0xb7c2,0xb7c3,0xb7c4,0xb7c5,0xb7c6,0xb7c8,0xb7ca, /* 0x8E60-0x8E67 */
	0xb7cb,0xb7cc,0xb7cd,0xb7ce,0xb7cf,0xb7d0,0xb7d1,0xb7d2, /* 0x8E68-0x8E6F */
	0xb7d3,0xb7d4,0xb7d5,0xb7d6,0xb7d7,0xb7d8,0xb7d9,0xb7da, /* 0x8E70-0x8E77 */
	0xb7db,0xb7dc,0xb7dd,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8E78-0x8E7F */
	/* codebase=0x8e80 rawbase=0x0a80 */
	0x0000,0xb7de,0xb7df,0xb7e0,0xb7e1,0xb7e2,0xb7e3,0xb7e4, /* 0x8E80-0x8E87 */
	0xb7e5,0xb7e6,0xb7e7,0xb7e8,0xb7e9,0xb7ea,0xb7eb,0xb7ee, /* 0x8E88-0x8E8F */
	0xb7ef,0xb7f1,0xb7f2,0xb7f3,0xb7f5,0xb7f6,0xb7f7,0xb7f8, /* 0x8E90-0x8E97 */
	0xb7f9,0xb7fa,0xb7fb,0xb7fe,0xb802,0xb803,0xb804,0xb805, /* 0x8E98-0x8E9F */
	0xb806,0xb80a,0xb80b,0xb80d,0xb80e,0xb80f,0xb811,0xb812, /* 0x8EA0-0x8EA7 */
	0xb813,0xb814,0xb815,0xb816,0xb817,0xb81a,0xb81c,0xb81e, /* 0x8EA8-0x8EAF */
	0xb81f,0xb820,0xb821,0xb822,0xb823,0xb826,0xb827,0xb829, /* 0x8EB0-0x8EB7 */
	0xb82a,0xb82b,0xb82d,0xb82e,0xb82f,0xb830,0xb831,0xb832, /* 0x8EB8-0x8EBF */
	/* codebase=0x8ec0 rawbase=0x0ac0 */
	0xb833,0xb836,0xb83a,0xb83b,0xb83c,0xb83d,0xb83e,0xb83f, /* 0x8EC0-0x8EC7 */
	0xb841,0xb842,0xb843,0xb845,0xb846,0xb847,0xb848,0xb849, /* 0x8EC8-0x8ECF */
	0xb84a,0xb84b,0xb84c,0xb84d,0xb84e,0xb84f,0xb850,0xb852, /* 0x8ED0-0x8ED7 */
	0xb854,0xb855,0xb856,0xb857,0xb858,0xb859,0xb85a,0xb85b, /* 0x8ED8-0x8EDF */
	0xb85e,0xb85f,0xb861,0xb862,0xb863,0xb865,0xb866,0xb867, /* 0x8EE0-0x8EE7 */
	0xb868,0xb869,0xb86a,0xb86b,0xb86e,0xb870,0xb872,0xb873, /* 0x8EE8-0x8EEF */
	0xb874,0xb875,0xb876,0xb877,0xb879,0xb87a,0xb87b,0xb87d, /* 0x8EF0-0x8EF7 */
	0xb87e,0xb87f,0xb880,0xb881,0xb882,0xb883,0xb884,0x0000, /* 0x8EF8-0x8EFF */
	/* codebase=0x8f40 rawbase=0x0b00 */
	0x0000,0xb885,0xb886,0xb887,0xb888,0xb889,0xb88a,0xb88b, /* 0x8F40-0x8F47 */
	0xb88c,0xb88e,0xb88f,0xb890,0xb891,0xb892,0xb893,0xb894, /* 0x8F48-0x8F4F */
	0xb895,0xb896,0xb897,0xb898,0xb899,0xb89a,0xb89b,0xb89c, /* 0x8F50-0x8F57 */
	0xb89d,0xb89e,0xb89f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8F58-0x8F5F */
	0x0000,0xb8a0,0xb8a1,0xb8a2,0xb8a3,0xb8a4,0xb8a5,0xb8a6, /* 0x8F60-0x8F67 */
	0xb8a7,0xb8a9,0xb8aa,0xb8ab,0xb8ac,0xb8ad,0xb8ae,0xb8af, /* 0x8F68-0x8F6F */
	0xb8b1,0xb8b2,0xb8b3,0xb8b5,0xb8b6,0xb8b7,0xb8b9,0xb8ba, /* 0x8F70-0x8F77 */
	0xb8bb,0xb8bc,0xb8bd,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x8F78-0x8F7F */
	/* codebase=0x8f80 rawbase=0x0b40 */
	0x0000,0xb8be,0xb8bf,0xb8c2,0xb8c4,0xb8c6,0xb8c7,0xb8c8, /* 0x8F80-0x8F87 */
	0xb8c9,0xb8ca,0xb8cb,0xb8cd,0xb8ce,0xb8cf,0xb8d1,0xb8d2, /* 0x8F88-0x8F8F */
	0xb8d3,0xb8d5,0xb8d6,0xb8d7,0xb8d8,0xb8d9,0xb8da,0xb8db, /* 0x8F90-0x8F97 */
	0xb8dc,0xb8de,0xb8e0,0xb8e2,0xb8e3,0xb8e4,0xb8e5,0xb8e6, /* 0x8F98-0x8F9F */
	0xb8e7,0xb8ea,0xb8eb,0xb8ed,0xb8ee,0xb8ef,0xb8f1,0xb8f2, /* 0x8FA0-0x8FA7 */
	0xb8f3,0xb8f4,0xb8f5,0xb8f6,0xb8f7,0xb8fa,0xb8fc,0xb8fe, /* 0x8FA8-0x8FAF */
	0xb8ff,0xb900,0xb901,0xb902,0xb903,0xb905,0xb906,0xb907, /* 0x8FB0-0x8FB7 */
	0xb908,0xb909,0xb90a,0xb90b,0xb90c,0xb90d,0xb90e,0xb90f, /* 0x8FB8-0x8FBF */
	/* codebase=0x8fc0 rawbase=0x0b80 */
	0xb910,0xb911,0xb912,0xb913,0xb914,0xb915,0xb916,0xb917, /* 0x8FC0-0x8FC7 */
	0xb919,0xb91a,0xb91b,0xb91c,0xb91d,0xb91e,0xb91f,0xb921, /* 0x8FC8-0x8FCF */
	0xb922,0xb923,0xb924,0xb925,0xb926,0xb927,0xb928,0xb929, /* 0x8FD0-0x8FD7 */
	0xb92a,0xb92b,0xb92c,0xb92d,0xb92e,0xb92f,0xb930,0xb931, /* 0x8FD8-0x8FDF */
	0xb932,0xb933,0xb934,0xb935,0xb936,0xb937,0xb938,0xb939, /* 0x8FE0-0x8FE7 */
	0xb93a,0xb93b,0xb93e,0xb93f,0xb941,0xb942,0xb943,0xb945, /* 0x8FE8-0x8FEF */
	0xb946,0xb947,0xb948,0xb949,0xb94a,0xb94b,0xb94d,0xb94e, /* 0x8FF0-0x8FF7 */
	0xb950,0xb952,0xb953,0xb954,0xb955,0xb956,0xb957,0x0000, /* 0x8FF8-0x8FFF */
	/* codebase=0x9040 rawbase=0x0bc0 */
	0x0000,0xb95a,0xb95b,0xb95d,0xb95e,0xb95f,0xb961,0xb962, /* 0x9040-0x9047 */
	0xb963,0xb964,0xb965,0xb966,0xb967,0xb96a,0xb96c,0xb96e, /* 0x9048-0x904F */
	0xb96f,0xb970,0xb971,0xb972,0xb973,0xb976,0xb977,0xb979, /* 0x9050-0x9057 */
	0xb97a,0xb97b,0xb97d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9058-0x905F */
	0x0000,0xb97e,0xb97f,0xb980,0xb981,0xb982,0xb983,0xb986, /* 0x9060-0x9067 */
	0xb988,0xb98b,0xb98c,0xb98f,0xb990,0xb991,0xb992,0xb993, /* 0x9068-0x906F */
	0xb994,0xb995,0xb996,0xb997,0xb998,0xb999,0xb99a,0xb99b, /* 0x9070-0x9077 */
	0xb99c,0xb99d,0xb99e,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9078-0x907F */
	/* codebase=0x9080 rawbase=0x0c00 */
	0x0000,0xb99f,0xb9a0,0xb9a1,0xb9a2,0xb9a3,0xb9a4,0xb9a5, /* 0x9080-0x9087 */
	0xb9a6,0xb9a7,0xb9a8,0xb9a9,0xb9aa,0xb9ab,0xb9ae,0xb9af, /* 0x9088-0x908F */
	0xb9b1,0xb9b2,0xb9b3,0xb9b5,0xb9b6,0xb9b7,0xb9b8,0xb9b9, /* 0x9090-0x9097 */
	0xb9ba,0xb9bb,0xb9be,0xb9c0,0xb9c2,0xb9c3,0xb9c4,0xb9c5, /* 0x9098-0x909F */
	0xb9c6,0xb9c7,0xb9ca,0xb9cb,0xb9cd,0xb9d3,0xb9d4,0xb9d5, /* 0x90A0-0x90A7 */
	0xb9d6,0xb9d7,0xb9da,0xb9dc,0xb9df,0xb9e0,0xb9e2,0xb9e6, /* 0x90A8-0x90AF */
	0xb9e7,0xb9e9,0xb9ea,0xb9eb,0xb9ed,0xb9ee,0xb9ef,0xb9f0, /* 0x90B0-0x90B7 */
	0xb9f1,0xb9f2,0xb9f3,0xb9f6,0xb9fb,0xb9fc,0xb9fd,0xb9fe, /* 0x90B8-0x90BF */
	/* codebase=0x90c0 rawbase=0x0c40 */
	0xb9ff,0xba02,0xba03,0xba04,0xba05,0xba06,0xba07,0xba09, /* 0x90C0-0x90C7 */
	0xba0a,0xba0b,0xba0c,0xba0d,0xba0e,0xba0f,0xba10,0xba11, /* 0x90C8-0x90CF */
	0xba12,0xba13,0xba14,0xba16,0xba17,0xba18,0xba19,0xba1a, /* 0x90D0-0x90D7 */
	0xba1b,0xba1c,0xba1d,0xba1e,0xba1f,0xba20,0xba21,0xba22, /* 0x90D8-0x90DF */
	0xba23,0xba24,0xba25,0xba26,0xba27,0xba28,0xba29,0xba2a, /* 0x90E0-0x90E7 */
	0xba2b,0xba2c,0xba2d,0xba2e,0xba2f,0xba30,0xba31,0xba32, /* 0x90E8-0x90EF */
	0xba33,0xba34,0xba35,0xba36,0xba37,0xba3a,0xba3b,0xba3d, /* 0x90F0-0x90F7 */
	0xba3e,0xba3f,0xba41,0xba43,0xba44,0xba45,0xba46,0x0000, /* 0x90F8-0x90FF */
	/* codebase=0x9140 rawbase=0x0c80 */
	0x0000,0xba47,0xba4a,0xba4c,0xba4f,0xba50,0xba51,0xba52, /* 0x9140-0x9147 */
	0xba56,0xba57,0xba59,0xba5a,0xba5b,0xba5d,0xba5e,0xba5f, /* 0x9148-0x914F */
	0xba60,0xba61,0xba62,0xba63,0xba66,0xba6a,0xba6b,0xba6c, /* 0x9150-0x9157 */
	0xba6d,0xba6e,0xba6f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9158-0x915F */
	0x0000,0xba72,0xba73,0xba75,0xba76,0xba77,0xba79,0xba7a, /* 0x9160-0x9167 */
	0xba7b,0xba7c,0xba7d,0xba7e,0xba7f,0xba80,0xba81,0xba82, /* 0x9168-0x916F */
	0xba86,0xba88,0xba89,0xba8a,0xba8b,0xba8d,0xba8e,0xba8f, /* 0x9170-0x9177 */
	0xba90,0xba91,0xba92,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9178-0x917F */
	/* codebase=0x9180 rawbase=0x0cc0 */
	0x0000,0xba93,0xba94,0xba95,0xba96,0xba97,0xba98,0xba99, /* 0x9180-0x9187 */
	0xba9a,0xba9b,0xba9c,0xba9d,0xba9e,0xba9f,0xbaa0,0xbaa1, /* 0x9188-0x918F */
	0xbaa2,0xbaa3,0xbaa4,0xbaa5,0xbaa6,0xbaa7,0xbaaa,0xbaad, /* 0x9190-0x9197 */
	0xbaae,0xbaaf,0xbab1,0xbab3,0xbab4,0xbab5,0xbab6,0xbab7, /* 0x9198-0x919F */
	0xbaba,0xbabc,0xbabe,0xbabf,0xbac0,0xbac1,0xbac2,0xbac3, /* 0x91A0-0x91A7 */
	0xbac5,0xbac6,0xbac7,0xbac9,0xbaca,0xbacb,0xbacc,0xbacd, /* 0x91A8-0x91AF */
	0xbace,0xbacf,0xbad0,0xbad1,0xbad2,0xbad3,0xbad4,0xbad5, /* 0x91B0-0x91B7 */
	0xbad6,0xbad7,0xbada,0xbadb,0xbadc,0xbadd,0xbade,0xbadf, /* 0x91B8-0x91BF */
	/* codebase=0x91c0 rawbase=0x0d00 */
	0xbae0,0xbae1,0xbae2,0xbae3,0xbae4,0xbae5,0xbae6,0xbae7, /* 0x91C0-0x91C7 */
	0xbae8,0xbae9,0xbaea,0xbaeb,0xbaec,0xbaed,0xbaee,0xbaef, /* 0x91C8-0x91CF */
	0xbaf0,0xbaf1,0xbaf2,0xbaf3,0xbaf4,0xbaf5,0xbaf6,0xbaf7, /* 0x91D0-0x91D7 */
	0xbaf8,0xbaf9,0xbafa,0xbafb,0xbafd,0xbafe,0xbaff,0xbb01, /* 0x91D8-0x91DF */
	0xbb02,0xbb03,0xbb05,0xbb06,0xbb07,0xbb08,0xbb09,0xbb0a, /* 0x91E0-0x91E7 */
	0xbb0b,0xbb0c,0xbb0e,0xbb10,0xbb12,0xbb13,0xbb14,0xbb15, /* 0x91E8-0x91EF */
	0xbb16,0xbb17,0xbb19,0xbb1a,0xbb1b,0xbb1d,0xbb1e,0xbb1f, /* 0x91F0-0x91F7 */
	0xbb21,0xbb22,0xbb23,0xbb24,0xbb25,0xbb26,0xbb27,0x0000, /* 0x91F8-0x91FF */
	/* codebase=0x9240 rawbase=0x0d40 */
	0x0000,0xbb28,0xbb2a,0xbb2c,0xbb2d,0xbb2e,0xbb2f,0xbb30, /* 0x9240-0x9247 */
	0xbb31,0xbb32,0xbb33,0xbb37,0xbb39,0xbb3a,0xbb3f,0xbb40, /* 0x9248-0x924F */
	0xbb41,0xbb42,0xbb43,0xbb46,0xbb48,0xbb4a,0xbb4b,0xbb4c, /* 0x9250-0x9257 */
	0xbb4e,0xbb51,0xbb52,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9258-0x925F */
	0x0000,0xbb53,0xbb55,0xbb56,0xbb57,0xbb59,0xbb5a,0xbb5b, /* 0x9260-0x9267 */
	0xbb5c,0xbb5d,0xbb5e,0xbb5f,0xbb60,0xbb62,0xbb64,0xbb65, /* 0x9268-0x926F */
	0xbb66,0xbb67,0xbb68,0xbb69,0xbb6a,0xbb6b,0xbb6d,0xbb6e, /* 0x9270-0x9277 */
	0xbb6f,0xbb70,0xbb71,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9278-0x927F */
	/* codebase=0x9280 rawbase=0x0d80 */
	0x0000,0xbb72,0xbb73,0xbb74,0xbb75,0xbb76,0xbb77,0xbb78, /* 0x9280-0x9287 */
	0xbb79,0xbb7a,0xbb7b,0xbb7c,0xbb7d,0xbb7e,0xbb7f,0xbb80, /* 0x9288-0x928F */
	0xbb81,0xbb82,0xbb83,0xbb84,0xbb85,0xbb86,0xbb87,0xbb89, /* 0x9290-0x9297 */
	0xbb8a,0xbb8b,0xbb8d,0xbb8e,0xbb8f,0xbb91,0xbb92,0xbb93, /* 0x9298-0x929F */
	0xbb94,0xbb95,0xbb96,0xbb97,0xbb98,0xbb99,0xbb9a,0xbb9b, /* 0x92A0-0x92A7 */
	0xbb9c,0xbb9d,0xbb9e,0xbb9f,0xbba0,0xbba1,0xbba2,0xbba3, /* 0x92A8-0x92AF */
	0xbba5,0xbba6,0xbba7,0xbba9,0xbbaa,0xbbab,0xbbad,0xbbae, /* 0x92B0-0x92B7 */
	0xbbaf,0xbbb0,0xbbb1,0xbbb2,0xbbb3,0xbbb5,0xbbb6,0xbbb8, /* 0x92B8-0x92BF */
	/* codebase=0x92c0 rawbase=0x0dc0 */
	0xbbb9,0xbbba,0xbbbb,0xbbbc,0xbbbd,0xbbbe,0xbbbf,0xbbc1, /* 0x92C0-0x92C7 */
	0xbbc2,0xbbc3,0xbbc5,0xbbc6,0xbbc7,0xbbc9,0xbbca,0xbbcb, /* 0x92C8-0x92CF */
	0xbbcc,0xbbcd,0xbbce,0xbbcf,0xbbd1,0xbbd2,0xbbd4,0xbbd5, /* 0x92D0-0x92D7 */
	0xbbd6,0xbbd7,0xbbd8,0xbbd9,0xbbda,0xbbdb,0xbbdc,0xbbdd, /* 0x92D8-0x92DF */
	0xbbde,0xbbdf,0xbbe0,0xbbe1,0xbbe2,0xbbe3,0xbbe4,0xbbe5, /* 0x92E0-0x92E7 */
	0xbbe6,0xbbe7,0xbbe8,0xbbe9,0xbbea,0xbbeb,0xbbec,0xbbed, /* 0x92E8-0x92EF */
	0xbbee,0xbbef,0xbbf0,0xbbf1,0xbbf2,0xbbf3,0xbbf4,0xbbf5, /* 0x92F0-0x92F7 */
	0xbbf6,0xbbf7,0xbbfa,0xbbfb,0xbbfd,0xbbfe,0xbc01,0x0000, /* 0x92F8-0x92FF */
	/* codebase=0x9340 rawbase=0x0e00 */
	0x0000,0xbc03,0xbc04,0xbc05,0xbc06,0xbc07,0xbc0a,0xbc0e, /* 0x9340-0x9347 */
	0xbc10,0xbc12,0xbc13,0xbc19,0xbc1a,0xbc20,0xbc21,0xbc22, /* 0x9348-0x934F */
	0xbc23,0xbc26,0xbc28,0xbc2a,0xbc2b,0xbc2c,0xbc2e,0xbc2f, /* 0x9350-0x9357 */
	0xbc32,0xbc33,0xbc35,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9358-0x935F */
	0x0000,0xbc36,0xbc37,0xbc39,0xbc3a,0xbc3b,0xbc3c,0xbc3d, /* 0x9360-0x9367 */
	0xbc3e,0xbc3f,0xbc42,0xbc46,0xbc47,0xbc48,0xbc4a,0xbc4b, /* 0x9368-0x936F */
	0xbc4e,0xbc4f,0xbc51,0xbc52,0xbc53,0xbc54,0xbc55,0xbc56, /* 0x9370-0x9377 */
	0xbc57,0xbc58,0xbc59,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9378-0x937F */
	/* codebase=0x9380 rawbase=0x0e40 */
	0x0000,0xbc5a,0xbc5b,0xbc5c,0xbc5e,0xbc5f,0xbc60,0xbc61, /* 0x9380-0x9387 */
	0xbc62,0xbc63,0xbc64,0xbc65,0xbc66,0xbc67,0xbc68,0xbc69, /* 0x9388-0x938F */
	0xbc6a,0xbc6b,0xbc6c,0xbc6d,0xbc6e,0xbc6f,0xbc70,0xbc71, /* 0x9390-0x9397 */
	0xbc72,0xbc73,0xbc74,0xbc75,0xbc76,0xbc77,0xbc78,0xbc79, /* 0x9398-0x939F */
	0xbc7a,0xbc7b,0xbc7c,0xbc7d,0xbc7e,0xbc7f,0xbc80,0xbc81, /* 0x93A0-0x93A7 */
	0xbc82,0xbc83,0xbc86,0xbc87,0xbc89,0xbc8a,0xbc8d,0xbc8f, /* 0x93A8-0x93AF */
	0xbc90,0xbc91,0xbc92,0xbc93,0xbc96,0xbc98,0xbc9b,0xbc9c, /* 0x93B0-0x93B7 */
	0xbc9d,0xbc9e,0xbc9f,0xbca2,0xbca3,0xbca5,0xbca6,0xbca9, /* 0x93B8-0x93BF */
	/* codebase=0x93c0 rawbase=0x0e80 */
	0xbcaa,0xbcab,0xbcac,0xbcad,0xbcae,0xbcaf,0xbcb2,0xbcb6, /* 0x93C0-0x93C7 */
	0xbcb7,0xbcb8,0xbcb9,0xbcba,0xbcbb,0xbcbe,0xbcbf,0xbcc1, /* 0x93C8-0x93CF */
	0xbcc2,0xbcc3,0xbcc5,0xbcc6,0xbcc7,0xbcc8,0xbcc9,0xbcca, /* 0x93D0-0x93D7 */
	0xbccb,0xbccc,0xbcce,0xbcd2,0xbcd3,0xbcd4,0xbcd6,0xbcd7, /* 0x93D8-0x93DF */
	0xbcd9,0xbcda,0xbcdb,0xbcdd,0xbcde,0xbcdf,0xbce0,0xbce1, /* 0x93E0-0x93E7 */
	0xbce2,0xbce3,0xbce4,0xbce5,0xbce6,0xbce7,0xbce8,0xbce9, /* 0x93E8-0x93EF */
	0xbcea,0xbceb,0xbcec,0xbced,0xbcee,0xbcef,0xbcf0,0xbcf1, /* 0x93F0-0x93F7 */
	0xbcf2,0xbcf3,0xbcf7,0xbcf9,0xbcfa,0xbcfb,0xbcfd,0x0000, /* 0x93F8-0x93FF */
	/* codebase=0x9440 rawbase=0x0ec0 */
	0x0000,0xbcfe,0xbcff,0xbd00,0xbd01,0xbd02,0xbd03,0xbd06, /* 0x9440-0x9447 */
	0xbd08,0xbd0a,0xbd0b,0xbd0c,0xbd0d,0xbd0e,0xbd0f,0xbd11, /* 0x9448-0x944F */
	0xbd12,0xbd13,0xbd15,0xbd16,0xbd17,0xbd18,0xbd19,0xbd1a, /* 0x9450-0x9457 */
	0xbd1b,0xbd1c,0xbd1d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9458-0x945F */
	0x0000,0xbd1e,0xbd1f,0xbd20,0xbd21,0xbd22,0xbd23,0xbd25, /* 0x9460-0x9467 */
	0xbd26,0xbd27,0xbd28,0xbd29,0xbd2a,0xbd2b,0xbd2d,0xbd2e, /* 0x9468-0x946F */
	0xbd2f,0xbd30,0xbd31,0xbd32,0xbd33,0xbd34,0xbd35,0xbd36, /* 0x9470-0x9477 */
	0xbd37,0xbd38,0xbd39,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9478-0x947F */
	/* codebase=0x9480 rawbase=0x0f00 */
	0x0000,0xbd3a,0xbd3b,0xbd3c,0xbd3d,0xbd3e,0xbd3f,0xbd41, /* 0x9480-0x9487 */
	0xbd42,0xbd43,0xbd44,0xbd45,0xbd46,0xbd47,0xbd4a,0xbd4b, /* 0x9488-0x948F */
	0xbd4d,0xbd4e,0xbd4f,0xbd51,0xbd52,0xbd53,0xbd54,0xbd55, /* 0x9490-0x9497 */
	0xbd56,0xbd57,0xbd5a,0xbd5b,0xbd5c,0xbd5d,0xbd5e,0xbd5f, /* 0x9498-0x949F */
	0xbd60,0xbd61,0xbd62,0xbd63,0xbd65,0xbd66,0xbd67,0xbd69, /* 0x94A0-0x94A7 */
	0xbd6a,0xbd6b,0xbd6c,0xbd6d,0xbd6e,0xbd6f,0xbd70,0xbd71, /* 0x94A8-0x94AF */
	0xbd72,0xbd73,0xbd74,0xbd75,0xbd76,0xbd77,0xbd78,0xbd79, /* 0x94B0-0x94B7 */
	0xbd7a,0xbd7b,0xbd7c,0xbd7d,0xbd7e,0xbd7f,0xbd82,0xbd83, /* 0x94B8-0x94BF */
	/* codebase=0x94c0 rawbase=0x0f40 */
	0xbd85,0xbd86,0xbd8b,0xbd8c,0xbd8d,0xbd8e,0xbd8f,0xbd92, /* 0x94C0-0x94C7 */
	0xbd94,0xbd96,0xbd97,0xbd98,0xbd9b,0xbd9d,0xbd9e,0xbd9f, /* 0x94C8-0x94CF */
	0xbda0,0xbda1,0xbda2,0xbda3,0xbda5,0xbda6,0xbda7,0xbda8, /* 0x94D0-0x94D7 */
	0xbda9,0xbdaa,0xbdab,0xbdac,0xbdad,0xbdae,0xbdaf,0xbdb1, /* 0x94D8-0x94DF */
	0xbdb2,0xbdb3,0xbdb4,0xbdb5,0xbdb6,0xbdb7,0xbdb9,0xbdba, /* 0x94E0-0x94E7 */
	0xbdbb,0xbdbc,0xbdbd,0xbdbe,0xbdbf,0xbdc0,0xbdc1,0xbdc2, /* 0x94E8-0x94EF */
	0xbdc3,0xbdc4,0xbdc5,0xbdc6,0xbdc7,0xbdc8,0xbdc9,0xbdca, /* 0x94F0-0x94F7 */
	0xbdcb,0xbdcc,0xbdcd,0xbdce,0xbdcf,0xbdd0,0xbdd1,0x0000, /* 0x94F8-0x94FF */
	/* codebase=0x9540 rawbase=0x0f80 */
	0x0000,0xbdd2,0xbdd3,0xbdd6,0xbdd7,0xbdd9,0xbdda,0xbddb, /* 0x9540-0x9547 */
	0xbddd,0xbdde,0xbddf,0xbde0,0xbde1,0xbde2,0xbde3,0xbde4, /* 0x9548-0x954F */
	0xbde5,0xbde6,0xbde7,0xbde8,0xbdea,0xbdeb,0xbdec,0xbded, /* 0x9550-0x9557 */
	0xbdee,0xbdef,0xbdf1,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9558-0x955F */
	0x0000,0xbdf2,0xbdf3,0xbdf5,0xbdf6,0xbdf7,0xbdf9,0xbdfa, /* 0x9560-0x9567 */
	0xbdfb,0xbdfc,0xbdfd,0xbdfe,0xbdff,0xbe01,0xbe02,0xbe04, /* 0x9568-0x956F */
	0xbe06,0xbe07,0xbe08,0xbe09,0xbe0a,0xbe0b,0xbe0e,0xbe0f, /* 0x9570-0x9577 */
	0xbe11,0xbe12,0xbe13,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9578-0x957F */
	/* codebase=0x9580 rawbase=0x0fc0 */
	0x0000,0xbe15,0xbe16,0xbe17,0xbe18,0xbe19,0xbe1a,0xbe1b, /* 0x9580-0x9587 */
	0xbe1e,0xbe20,0xbe21,0xbe22,0xbe23,0xbe24,0xbe25,0xbe26, /* 0x9588-0x958F */
	0xbe27,0xbe28,0xbe29,0xbe2a,0xbe2b,0xbe2c,0xbe2d,0xbe2e, /* 0x9590-0x9597 */
	0xbe2f,0xbe30,0xbe31,0xbe32,0xbe33,0xbe34,0xbe35,0xbe36, /* 0x9598-0x959F */
	0xbe37,0xbe38,0xbe39,0xbe3a,0xbe3b,0xbe3c,0xbe3d,0xbe3e, /* 0x95A0-0x95A7 */
	0xbe3f,0xbe40,0xbe41,0xbe42,0xbe43,0xbe46,0xbe47,0xbe49, /* 0x95A8-0x95AF */
	0xbe4a,0xbe4b,0xbe4d,0xbe4f,0xbe50,0xbe51,0xbe52,0xbe53, /* 0x95B0-0x95B7 */
	0xbe56,0xbe58,0xbe5c,0xbe5d,0xbe5e,0xbe5f,0xbe62,0xbe63, /* 0x95B8-0x95BF */
	/* codebase=0x95c0 rawbase=0x1000 */
	0xbe65,0xbe66,0xbe67,0xbe69,0xbe6b,0xbe6c,0xbe6d,0xbe6e, /* 0x95C0-0x95C7 */
	0xbe6f,0xbe72,0xbe76,0xbe77,0xbe78,0xbe79,0xbe7a,0xbe7e, /* 0x95C8-0x95CF */
	0xbe7f,0xbe81,0xbe82,0xbe83,0xbe85,0xbe86,0xbe87,0xbe88, /* 0x95D0-0x95D7 */
	0xbe89,0xbe8a,0xbe8b,0xbe8e,0xbe92,0xbe93,0xbe94,0xbe95, /* 0x95D8-0x95DF */
	0xbe96,0xbe97,0xbe9a,0xbe9b,0xbe9c,0xbe9d,0xbe9e,0xbe9f, /* 0x95E0-0x95E7 */
	0xbea0,0xbea1,0xbea2,0xbea3,0xbea4,0xbea5,0xbea6,0xbea7, /* 0x95E8-0x95EF */
	0xbea9,0xbeaa,0xbeab,0xbeac,0xbead,0xbeae,0xbeaf,0xbeb0, /* 0x95F0-0x95F7 */
	0xbeb1,0xbeb2,0xbeb3,0xbeb4,0xbeb5,0xbeb6,0xbeb7,0x0000, /* 0x95F8-0x95FF */
	/* codebase=0x9640 rawbase=0x1040 */
	0x0000,0xbeb8,0xbeb9,0xbeba,0xbebb,0xbebc,0xbebd,0xbebe, /* 0x9640-0x9647 */
	0xbebf,0xbec0,0xbec1,0xbec2,0xbec3,0xbec4,0xbec5,0xbec6, /* 0x9648-0x964F */
	0xbec7,0xbec8,0xbec9,0xbeca,0xbecb,0xbecc,0xbecd,0xbece, /* 0x9650-0x9657 */
	0xbecf,0xbed2,0xbed3,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9658-0x965F */
	0x0000,0xbed5,0xbed6,0xbed9,0xbeda,0xbedb,0xbedc,0xbedd, /* 0x9660-0x9667 */
	0xbede,0xbedf,0xbee1,0xbee2,0xbee6,0xbee7,0xbee8,0xbee9, /* 0x9668-0x966F */
	0xbeea,0xbeeb,0xbeed,0xbeee,0xbeef,0xbef0,0xbef1,0xbef2, /* 0x9670-0x9677 */
	0xbef3,0xbef4,0xbef5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9678-0x967F */
	/* codebase=0x9680 rawbase=0x1080 */
	0x0000,0xbef6,0xbef7,0xbef8,0xbef9,0xbefa,0xbefb,0xbefc, /* 0x9680-0x9687 */
	0xbefd,0xbefe,0xbeff,0xbf00,0xbf02,0xbf03,0xbf04,0xbf05, /* 0x9688-0x968F */
	0xbf06,0xbf07,0xbf0a,0xbf0b,0xbf0c,0xbf0d,0xbf0e,0xbf0f, /* 0x9690-0x9697 */
	0xbf10,0xbf11,0xbf12,0xbf13,0xbf14,0xbf15,0xbf16,0xbf17, /* 0x9698-0x969F */
	0xbf1a,0xbf1e,0xbf1f,0xbf20,0xbf21,0xbf22,0xbf23,0xbf24, /* 0x96A0-0x96A7 */
	0xbf25,0xbf26,0xbf27,0xbf28,0xbf29,0xbf2a,0xbf2b,0xbf2c, /* 0x96A8-0x96AF */
	0xbf2d,0xbf2e,0xbf2f,0xbf30,0xbf31,0xbf32,0xbf33,0xbf34, /* 0x96B0-0x96B7 */
	0xbf35,0xbf36,0xbf37,0xbf38,0xbf39,0xbf3a,0xbf3b,0xbf3c, /* 0x96B8-0x96BF */
	/* codebase=0x96c0 rawbase=0x10c0 */
	0xbf3d,0xbf3e,0xbf3f,0xbf42,0xbf43,0xbf45,0xbf46,0xbf47, /* 0x96C0-0x96C7 */
	0xbf49,0xbf4a,0xbf4b,0xbf4c,0xbf4d,0xbf4e,0xbf4f,0xbf52, /* 0x96C8-0x96CF */
	0xbf53,0xbf54,0xbf56,0xbf57,0xbf58,0xbf59,0xbf5a,0xbf5b, /* 0x96D0-0x96D7 */
	0xbf5c,0xbf5d,0xbf5e,0xbf5f,0xbf60,0xbf61,0xbf62,0xbf63, /* 0x96D8-0x96DF */
	0xbf64,0xbf65,0xbf66,0xbf67,0xbf68,0xbf69,0xbf6a,0xbf6b, /* 0x96E0-0x96E7 */
	0xbf6c,0xbf6d,0xbf6e,0xbf6f,0xbf70,0xbf71,0xbf72,0xbf73, /* 0x96E8-0x96EF */
	0xbf74,0xbf75,0xbf76,0xbf77,0xbf78,0xbf79,0xbf7a,0xbf7b, /* 0x96F0-0x96F7 */
	0xbf7c,0xbf7d,0xbf7e,0xbf7f,0xbf80,0xbf81,0xbf82,0x0000, /* 0x96F8-0x96FF */
	/* codebase=0x9740 rawbase=0x1100 */
	0x0000,0xbf83,0xbf84,0xbf85,0xbf86,0xbf87,0xbf88,0xbf89, /* 0x9740-0x9747 */
	0xbf8a,0xbf8b,0xbf8c,0xbf8d,0xbf8e,0xbf8f,0xbf90,0xbf91, /* 0x9748-0x974F */
	0xbf92,0xbf93,0xbf95,0xbf96,0xbf97,0xbf98,0xbf99,0xbf9a, /* 0x9750-0x9757 */
	0xbf9b,0xbf9c,0xbf9d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9758-0x975F */
	0x0000,0xbf9e,0xbf9f,0xbfa0,0xbfa1,0xbfa2,0xbfa3,0xbfa4, /* 0x9760-0x9767 */
	0xbfa5,0xbfa6,0xbfa7,0xbfa8,0xbfa9,0xbfaa,0xbfab,0xbfac, /* 0x9768-0x976F */
	0xbfad,0xbfae,0xbfaf,0xbfb1,0xbfb2,0xbfb3,0xbfb4,0xbfb5, /* 0x9770-0x9777 */
	0xbfb6,0xbfb7,0xbfb8,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9778-0x977F */
	/* codebase=0x9780 rawbase=0x1140 */
	0x0000,0xbfb9,0xbfba,0xbfbb,0xbfbc,0xbfbd,0xbfbe,0xbfbf, /* 0x9780-0x9787 */
	0xbfc0,0xbfc1,0xbfc2,0xbfc3,0xbfc4,0xbfc6,0xbfc7,0xbfc8, /* 0x9788-0x978F */
	0xbfc9,0xbfca,0xbfcb,0xbfce,0xbfcf,0xbfd1,0xbfd2,0xbfd3, /* 0x9790-0x9797 */
	0xbfd5,0xbfd6,0xbfd7,0xbfd8,0xbfd9,0xbfda,0xbfdb,0xbfdd, /* 0x9798-0x979F */
	0xbfde,0xbfe0,0xbfe2,0xbfe3,0xbfe4,0xbfe5,0xbfe6,0xbfe7, /* 0x97A0-0x97A7 */
	0xbfe8,0xbfe9,0xbfea,0xbfeb,0xbfec,0xbfed,0xbfee,0xbfef, /* 0x97A8-0x97AF */
	0xbff0,0xbff1,0xbff2,0xbff3,0xbff4,0xbff5,0xbff6,0xbff7, /* 0x97B0-0x97B7 */
	0xbff8,0xbff9,0xbffa,0xbffb,0xbffc,0xbffd,0xbffe,0xbfff, /* 0x97B8-0x97BF */
	/* codebase=0x97c0 rawbase=0x1180 */
	0xc000,0xc001,0xc002,0xc003,0xc004,0xc005,0xc006,0xc007, /* 0x97C0-0x97C7 */
	0xc008,0xc009,0xc00a,0xc00b,0xc00c,0xc00d,0xc00e,0xc00f, /* 0x97C8-0x97CF */
	0xc010,0xc011,0xc012,0xc013,0xc014,0xc015,0xc016,0xc017, /* 0x97D0-0x97D7 */
	0xc018,0xc019,0xc01a,0xc01b,0xc01c,0xc01d,0xc01e,0xc01f, /* 0x97D8-0x97DF */
	0xc020,0xc021,0xc022,0xc023,0xc024,0xc025,0xc026,0xc027, /* 0x97E0-0x97E7 */
	0xc028,0xc029,0xc02a,0xc02b,0xc02c,0xc02d,0xc02e,0xc02f, /* 0x97E8-0x97EF */
	0xc030,0xc031,0xc032,0xc033,0xc034,0xc035,0xc036,0xc037, /* 0x97F0-0x97F7 */
	0xc038,0xc039,0xc03a,0xc03b,0xc03d,0xc03e,0xc03f,0x0000, /* 0x97F8-0x97FF */
	/* codebase=0x9840 rawbase=0x11c0 */
	0x0000,0xc040,0xc041,0xc042,0xc043,0xc044,0xc045,0xc046, /* 0x9840-0x9847 */
	0xc047,0xc048,0xc049,0xc04a,0xc04b,0xc04c,0xc04d,0xc04e, /* 0x9848-0x984F */
	0xc04f,0xc050,0xc052,0xc053,0xc054,0xc055,0xc056,0xc057, /* 0x9850-0x9857 */
	0xc059,0xc05a,0xc05b,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9858-0x985F */
	0x0000,0xc05d,0xc05e,0xc05f,0xc061,0xc062,0xc063,0xc064, /* 0x9860-0x9867 */
	0xc065,0xc066,0xc067,0xc06a,0xc06b,0xc06c,0xc06d,0xc06e, /* 0x9868-0x986F */
	0xc06f,0xc070,0xc071,0xc072,0xc073,0xc074,0xc075,0xc076, /* 0x9870-0x9877 */
	0xc077,0xc078,0xc079,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9878-0x987F */
	/* codebase=0x9880 rawbase=0x1200 */
	0x0000,0xc07a,0xc07b,0xc07c,0xc07d,0xc07e,0xc07f,0xc080, /* 0x9880-0x9887 */
	0xc081,0xc082,0xc083,0xc084,0xc085,0xc086,0xc087,0xc088, /* 0x9888-0x988F */
	0xc089,0xc08a,0xc08b,0xc08c,0xc08d,0xc08e,0xc08f,0xc092, /* 0x9890-0x9897 */
	0xc093,0xc095,0xc096,0xc097,0xc099,0xc09a,0xc09b,0xc09c, /* 0x9898-0x989F */
	0xc09d,0xc09e,0xc09f,0xc0a2,0xc0a4,0xc0a6,0xc0a7,0xc0a8, /* 0x98A0-0x98A7 */
	0xc0a9,0xc0aa,0xc0ab,0xc0ae,0xc0b1,0xc0b2,0xc0b7,0xc0b8, /* 0x98A8-0x98AF */
	0xc0b9,0xc0ba,0xc0bb,0xc0be,0xc0c2,0xc0c3,0xc0c4,0xc0c6, /* 0x98B0-0x98B7 */
	0xc0c7,0xc0ca,0xc0cb,0xc0cd,0xc0ce,0xc0cf,0xc0d1,0xc0d2, /* 0x98B8-0x98BF */
	/* codebase=0x98c0 rawbase=0x1240 */
	0xc0d3,0xc0d4,0xc0d5,0xc0d6,0xc0d7,0xc0da,0xc0de,0xc0df, /* 0x98C0-0x98C7 */
	0xc0e0,0xc0e1,0xc0e2,0xc0e3,0xc0e6,0xc0e7,0xc0e9,0xc0ea, /* 0x98C8-0x98CF */
	0xc0eb,0xc0ed,0xc0ee,0xc0ef,0xc0f0,0xc0f1,0xc0f2,0xc0f3, /* 0x98D0-0x98D7 */
	0xc0f6,0xc0f8,0xc0fa,0xc0fb,0xc0fc,0xc0fd,0xc0fe,0xc0ff, /* 0x98D8-0x98DF */
	0xc101,0xc102,0xc103,0xc105,0xc106,0xc107,0xc109,0xc10a, /* 0x98E0-0x98E7 */
	0xc10b,0xc10c,0xc10d,0xc10e,0xc10f,0xc111,0xc112,0xc113, /* 0x98E8-0x98EF */
	0xc114,0xc116,0xc117,0xc118,0xc119,0xc11a,0xc11b,0xc121, /* 0x98F0-0x98F7 */
	0xc122,0xc125,0xc128,0xc129,0xc12a,0xc12b,0xc12e,0x0000, /* 0x98F8-0x98FF */
	/* codebase=0x9940 rawbase=0x1280 */
	0x0000,0xc132,0xc133,0xc134,0xc135,0xc137,0xc13a,0xc13b, /* 0x9940-0x9947 */
	0xc13d,0xc13e,0xc13f,0xc141,0xc142,0xc143,0xc144,0xc145, /* 0x9948-0x994F */
	0xc146,0xc147,0xc14a,0xc14e,0xc14f,0xc150,0xc151,0xc152, /* 0x9950-0x9957 */
	0xc153,0xc156,0xc157,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9958-0x995F */
	0x0000,0xc159,0xc15a,0xc15b,0xc15d,0xc15e,0xc15f,0xc160, /* 0x9960-0x9967 */
	0xc161,0xc162,0xc163,0xc166,0xc16a,0xc16b,0xc16c,0xc16d, /* 0x9968-0x996F */
	0xc16e,0xc16f,0xc171,0xc172,0xc173,0xc175,0xc176,0xc177, /* 0x9970-0x9977 */
	0xc179,0xc17a,0xc17b,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9978-0x997F */
	/* codebase=0x9980 rawbase=0x12c0 */
	0x0000,0xc17c,0xc17d,0xc17e,0xc17f,0xc180,0xc181,0xc182, /* 0x9980-0x9987 */
	0xc183,0xc184,0xc186,0xc187,0xc188,0xc189,0xc18a,0xc18b, /* 0x9988-0x998F */
	0xc18f,0xc191,0xc192,0xc193,0xc195,0xc197,0xc198,0xc199, /* 0x9990-0x9997 */
	0xc19a,0xc19b,0xc19e,0xc1a0,0xc1a2,0xc1a3,0xc1a4,0xc1a6, /* 0x9998-0x999F */
	0xc1a7,0xc1aa,0xc1ab,0xc1ad,0xc1ae,0xc1af,0xc1b1,0xc1b2, /* 0x99A0-0x99A7 */
	0xc1b3,0xc1b4,0xc1b5,0xc1b6,0xc1b7,0xc1b8,0xc1b9,0xc1ba, /* 0x99A8-0x99AF */
	0xc1bb,0xc1bc,0xc1be,0xc1bf,0xc1c0,0xc1c1,0xc1c2,0xc1c3, /* 0x99B0-0x99B7 */
	0xc1c5,0xc1c6,0xc1c7,0xc1c9,0xc1ca,0xc1cb,0xc1cd,0xc1ce, /* 0x99B8-0x99BF */
	/* codebase=0x99c0 rawbase=0x1300 */
	0xc1cf,0xc1d0,0xc1d1,0xc1d2,0xc1d3,0xc1d5,0xc1d6,0xc1d9, /* 0x99C0-0x99C7 */
	0xc1da,0xc1db,0xc1dc,0xc1dd,0xc1de,0xc1df,0xc1e1,0xc1e2, /* 0x99C8-0x99CF */
	0xc1e3,0xc1e5,0xc1e6,0xc1e7,0xc1e9,0xc1ea,0xc1eb,0xc1ec, /* 0x99D0-0x99D7 */
	0xc1ed,0xc1ee,0xc1ef,0xc1f2,0xc1f4,0xc1f5,0xc1f6,0xc1f7, /* 0x99D8-0x99DF */
	0xc1f8,0xc1f9,0xc1fa,0xc1fb,0xc1fe,0xc1ff,0xc201,0xc202, /* 0x99E0-0x99E7 */
	0xc203,0xc205,0xc206,0xc207,0xc208,0xc209,0xc20a,0xc20b, /* 0x99E8-0x99EF */
	0xc20e,0xc210,0xc212,0xc213,0xc214,0xc215,0xc216,0xc217, /* 0x99F0-0x99F7 */
	0xc21a,0xc21b,0xc21d,0xc21e,0xc221,0xc222,0xc223,0x0000, /* 0x99F8-0x99FF */
	/* codebase=0x9a40 rawbase=0x1340 */
	0x0000,0xc224,0xc225,0xc226,0xc227,0xc22a,0xc22c,0xc22e, /* 0x9A40-0x9A47 */
	0xc230,0xc233,0xc235,0xc236,0xc237,0xc238,0xc239,0xc23a, /* 0x9A48-0x9A4F */
	0xc23b,0xc23c,0xc23d,0xc23e,0xc23f,0xc240,0xc241,0xc242, /* 0x9A50-0x9A57 */
	0xc243,0xc244,0xc245,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9A58-0x9A5F */
	0x0000,0xc246,0xc247,0xc249,0xc24a,0xc24b,0xc24c,0xc24d, /* 0x9A60-0x9A67 */
	0xc24e,0xc24f,0xc252,0xc253,0xc255,0xc256,0xc257,0xc259, /* 0x9A68-0x9A6F */
	0xc25a,0xc25b,0xc25c,0xc25d,0xc25e,0xc25f,0xc261,0xc262, /* 0x9A70-0x9A77 */
	0xc263,0xc264,0xc266,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9A78-0x9A7F */
	/* codebase=0x9a80 rawbase=0x1380 */
	0x0000,0xc267,0xc268,0xc269,0xc26a,0xc26b,0xc26e,0xc26f, /* 0x9A80-0x9A87 */
	0xc271,0xc272,0xc273,0xc275,0xc276,0xc277,0xc278,0xc279, /* 0x9A88-0x9A8F */
	0xc27a,0xc27b,0xc27e,0xc280,0xc282,0xc283,0xc284,0xc285, /* 0x9A90-0x9A97 */
	0xc286,0xc287,0xc28a,0xc28b,0xc28c,0xc28d,0xc28e,0xc28f, /* 0x9A98-0x9A9F */
	0xc291,0xc292,0xc293,0xc294,0xc295,0xc296,0xc297,0xc299, /* 0x9AA0-0x9AA7 */
	0xc29a,0xc29c,0xc29e,0xc29f,0xc2a0,0xc2a1,0xc2a2,0xc2a3, /* 0x9AA8-0x9AAF */
	0xc2a6,0xc2a7,0xc2a9,0xc2aa,0xc2ab,0xc2ae,0xc2af,0xc2b0, /* 0x9AB0-0x9AB7 */
	0xc2b1,0xc2b2,0xc2b3,0xc2b6,0xc2b8,0xc2ba,0xc2bb,0xc2bc, /* 0x9AB8-0x9ABF */
	/* codebase=0x9ac0 rawbase=0x13c0 */
	0xc2bd,0xc2be,0xc2bf,0xc2c0,0xc2c1,0xc2c2,0xc2c3,0xc2c4, /* 0x9AC0-0x9AC7 */
	0xc2c5,0xc2c6,0xc2c7,0xc2c8,0xc2c9,0xc2ca,0xc2cb,0xc2cc, /* 0x9AC8-0x9ACF */
	0xc2cd,0xc2ce,0xc2cf,0xc2d0,0xc2d1,0xc2d2,0xc2d3,0xc2d4, /* 0x9AD0-0x9AD7 */
	0xc2d5,0xc2d6,0xc2d7,0xc2d8,0xc2d9,0xc2da,0xc2db,0xc2de, /* 0x9AD8-0x9ADF */
	0xc2df,0xc2e1,0xc2e2,0xc2e5,0xc2e6,0xc2e7,0xc2e8,0xc2e9, /* 0x9AE0-0x9AE7 */
	0xc2ea,0xc2ee,0xc2f0,0xc2f2,0xc2f3,0xc2f4,0xc2f5,0xc2f7, /* 0x9AE8-0x9AEF */
	0xc2fa,0xc2fd,0xc2fe,0xc2ff,0xc301,0xc302,0xc303,0xc304, /* 0x9AF0-0x9AF7 */
	0xc305,0xc306,0xc307,0xc30a,0xc30b,0xc30e,0xc30f,0x0000, /* 0x9AF8-0x9AFF */
	/* codebase=0x9b40 rawbase=0x1400 */
	0x0000,0xc310,0xc311,0xc312,0xc316,0xc317,0xc319,0xc31a, /* 0x9B40-0x9B47 */
	0xc31b,0xc31d,0xc31e,0xc31f,0xc320,0xc321,0xc322,0xc323, /* 0x9B48-0x9B4F */
	0xc326,0xc327,0xc32a,0xc32b,0xc32c,0xc32d,0xc32e,0xc32f, /* 0x9B50-0x9B57 */
	0xc330,0xc331,0xc332,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9B58-0x9B5F */
	0x0000,0xc333,0xc334,0xc335,0xc336,0xc337,0xc338,0xc339, /* 0x9B60-0x9B67 */
	0xc33a,0xc33b,0xc33c,0xc33d,0xc33e,0xc33f,0xc340,0xc341, /* 0x9B68-0x9B6F */
	0xc342,0xc343,0xc344,0xc346,0xc347,0xc348,0xc349,0xc34a, /* 0x9B70-0x9B77 */
	0xc34b,0xc34c,0xc34d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9B78-0x9B7F */
	/* codebase=0x9b80 rawbase=0x1440 */
	0x0000,0xc34e,0xc34f,0xc350,0xc351,0xc352,0xc353,0xc354, /* 0x9B80-0x9B87 */
	0xc355,0xc356,0xc357,0xc358,0xc359,0xc35a,0xc35b,0xc35c, /* 0x9B88-0x9B8F */
	0xc35d,0xc35e,0xc35f,0xc360,0xc361,0xc362,0xc363,0xc364, /* 0x9B90-0x9B97 */
	0xc365,0xc366,0xc367,0xc36a,0xc36b,0xc36d,0xc36e,0xc36f, /* 0x9B98-0x9B9F */
	0xc371,0xc373,0xc374,0xc375,0xc376,0xc377,0xc37a,0xc37b, /* 0x9BA0-0x9BA7 */
	0xc37e,0xc37f,0xc380,0xc381,0xc382,0xc383,0xc385,0xc386, /* 0x9BA8-0x9BAF */
	0xc387,0xc389,0xc38a,0xc38b,0xc38d,0xc38e,0xc38f,0xc390, /* 0x9BB0-0x9BB7 */
	0xc391,0xc392,0xc393,0xc394,0xc395,0xc396,0xc397,0xc398, /* 0x9BB8-0x9BBF */
	/* codebase=0x9bc0 rawbase=0x1480 */
	0xc399,0xc39a,0xc39b,0xc39c,0xc39d,0xc39e,0xc39f,0xc3a0, /* 0x9BC0-0x9BC7 */
	0xc3a1,0xc3a2,0xc3a3,0xc3a4,0xc3a5,0xc3a6,0xc3a7,0xc3a8, /* 0x9BC8-0x9BCF */
	0xc3a9,0xc3aa,0xc3ab,0xc3ac,0xc3ad,0xc3ae,0xc3af,0xc3b0, /* 0x9BD0-0x9BD7 */
	0xc3b1,0xc3b2,0xc3b3,0xc3b4,0xc3b5,0xc3b6,0xc3b7,0xc3b8, /* 0x9BD8-0x9BDF */
	0xc3b9,0xc3ba,0xc3bb,0xc3bc,0xc3bd,0xc3be,0xc3bf,0xc3c1, /* 0x9BE0-0x9BE7 */
	0xc3c2,0xc3c3,0xc3c4,0xc3c5,0xc3c6,0xc3c7,0xc3c8,0xc3c9, /* 0x9BE8-0x9BEF */
	0xc3ca,0xc3cb,0xc3cc,0xc3cd,0xc3ce,0xc3cf,0xc3d0,0xc3d1, /* 0x9BF0-0x9BF7 */
	0xc3d2,0xc3d3,0xc3d4,0xc3d5,0xc3d6,0xc3d7,0xc3da,0x0000, /* 0x9BF8-0x9BFF */
	/* codebase=0x9c40 rawbase=0x14c0 */
	0x0000,0xc3db,0xc3dd,0xc3de,0xc3e1,0xc3e3,0xc3e4,0xc3e5, /* 0x9C40-0x9C47 */
	0xc3e6,0xc3e7,0xc3ea,0xc3eb,0xc3ec,0xc3ee,0xc3ef,0xc3f0, /* 0x9C48-0x9C4F */
	0xc3f1,0xc3f2,0xc3f3,0xc3f6,0xc3f7,0xc3f9,0xc3fa,0xc3fb, /* 0x9C50-0x9C57 */
	0xc3fc,0xc3fd,0xc3fe,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9C58-0x9C5F */
	0x0000,0xc3ff,0xc400,0xc401,0xc402,0xc403,0xc404,0xc405, /* 0x9C60-0x9C67 */
	0xc406,0xc407,0xc409,0xc40a,0xc40b,0xc40c,0xc40d,0xc40e, /* 0x9C68-0x9C6F */
	0xc40f,0xc411,0xc412,0xc413,0xc414,0xc415,0xc416,0xc417, /* 0x9C70-0x9C77 */
	0xc418,0xc419,0xc41a,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9C78-0x9C7F */
	/* codebase=0x9c80 rawbase=0x1500 */
	0x0000,0xc41b,0xc41c,0xc41d,0xc41e,0xc41f,0xc420,0xc421, /* 0x9C80-0x9C87 */
	0xc422,0xc423,0xc425,0xc426,0xc427,0xc428,0xc429,0xc42a, /* 0x9C88-0x9C8F */
	0xc42b,0xc42d,0xc42e,0xc42f,0xc431,0xc432,0xc433,0xc435, /* 0x9C90-0x9C97 */
	0xc436,0xc437,0xc438,0xc439,0xc43a,0xc43b,0xc43e,0xc43f, /* 0x9C98-0x9C9F */
	0xc440,0xc441,0xc442,0xc443,0xc444,0xc445,0xc446,0xc447, /* 0x9CA0-0x9CA7 */
	0xc449,0xc44a,0xc44b,0xc44c,0xc44d,0xc44e,0xc44f,0xc450, /* 0x9CA8-0x9CAF */
	0xc451,0xc452,0xc453,0xc454,0xc455,0xc456,0xc457,0xc458, /* 0x9CB0-0x9CB7 */
	0xc459,0xc45a,0xc45b,0xc45c,0xc45d,0xc45e,0xc45f,0xc460, /* 0x9CB8-0x9CBF */
	/* codebase=0x9cc0 rawbase=0x1540 */
	0xc461,0xc462,0xc463,0xc466,0xc467,0xc469,0xc46a,0xc46b, /* 0x9CC0-0x9CC7 */
	0xc46d,0xc46e,0xc46f,0xc470,0xc471,0xc472,0xc473,0xc476, /* 0x9CC8-0x9CCF */
	0xc477,0xc478,0xc47a,0xc47b,0xc47c,0xc47d,0xc47e,0xc47f, /* 0x9CD0-0x9CD7 */
	0xc481,0xc482,0xc483,0xc484,0xc485,0xc486,0xc487,0xc488, /* 0x9CD8-0x9CDF */
	0xc489,0xc48a,0xc48b,0xc48c,0xc48d,0xc48e,0xc48f,0xc490, /* 0x9CE0-0x9CE7 */
	0xc491,0xc492,0xc493,0xc495,0xc496,0xc497,0xc498,0xc499, /* 0x9CE8-0x9CEF */
	0xc49a,0xc49b,0xc49d,0xc49e,0xc49f,0xc4a0,0xc4a1,0xc4a2, /* 0x9CF0-0x9CF7 */
	0xc4a3,0xc4a4,0xc4a5,0xc4a6,0xc4a7,0xc4a8,0xc4a9,0x0000, /* 0x9CF8-0x9CFF */
	/* codebase=0x9d40 rawbase=0x1580 */
	0x0000,0xc4aa,0xc4ab,0xc4ac,0xc4ad,0xc4ae,0xc4af,0xc4b0, /* 0x9D40-0x9D47 */
	0xc4b1,0xc4b2,0xc4b3,0xc4b4,0xc4b5,0xc4b6,0xc4b7,0xc4b9, /* 0x9D48-0x9D4F */
	0xc4ba,0xc4bb,0xc4bd,0xc4be,0xc4bf,0xc4c0,0xc4c1,0xc4c2, /* 0x9D50-0x9D57 */
	0xc4c3,0xc4c4,0xc4c5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9D58-0x9D5F */
	0x0000,0xc4c6,0xc4c7,0xc4c8,0xc4c9,0xc4ca,0xc4cb,0xc4cc, /* 0x9D60-0x9D67 */
	0xc4cd,0xc4ce,0xc4cf,0xc4d0,0xc4d1,0xc4d2,0xc4d3,0xc4d4, /* 0x9D68-0x9D6F */
	0xc4d5,0xc4d6,0xc4d7,0xc4d8,0xc4d9,0xc4da,0xc4db,0xc4dc, /* 0x9D70-0x9D77 */
	0xc4dd,0xc4de,0xc4df,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9D78-0x9D7F */
	/* codebase=0x9d80 rawbase=0x15c0 */
	0x0000,0xc4e0,0xc4e1,0xc4e2,0xc4e3,0xc4e4,0xc4e5,0xc4e6, /* 0x9D80-0x9D87 */
	0xc4e7,0xc4e8,0xc4ea,0xc4eb,0xc4ec,0xc4ed,0xc4ee,0xc4ef, /* 0x9D88-0x9D8F */
	0xc4f2,0xc4f3,0xc4f5,0xc4f6,0xc4f7,0xc4f9,0xc4fb,0xc4fc, /* 0x9D90-0x9D97 */
	0xc4fd,0xc4fe,0xc502,0xc503,0xc504,0xc505,0xc506,0xc507, /* 0x9D98-0x9D9F */
	0xc508,0xc509,0xc50a,0xc50b,0xc50d,0xc50e,0xc50f,0xc511, /* 0x9DA0-0x9DA7 */
	0xc512,0xc513,0xc515,0xc516,0xc517,0xc518,0xc519,0xc51a, /* 0x9DA8-0x9DAF */
	0xc51b,0xc51d,0xc51e,0xc51f,0xc520,0xc521,0xc522,0xc523, /* 0x9DB0-0x9DB7 */
	0xc524,0xc525,0xc526,0xc527,0xc52a,0xc52b,0xc52d,0xc52e, /* 0x9DB8-0x9DBF */
	/* codebase=0x9dc0 rawbase=0x1600 */
	0xc52f,0xc531,0xc532,0xc533,0xc534,0xc535,0xc536,0xc537, /* 0x9DC0-0x9DC7 */
	0xc53a,0xc53c,0xc53e,0xc53f,0xc540,0xc541,0xc542,0xc543, /* 0x9DC8-0x9DCF */
	0xc546,0xc547,0xc54b,0xc54f,0xc550,0xc551,0xc552,0xc556, /* 0x9DD0-0x9DD7 */
	0xc55a,0xc55b,0xc55c,0xc55f,0xc562,0xc563,0xc565,0xc566, /* 0x9DD8-0x9DDF */
	0xc567,0xc569,0xc56a,0xc56b,0xc56c,0xc56d,0xc56e,0xc56f, /* 0x9DE0-0x9DE7 */
	0xc572,0xc576,0xc577,0xc578,0xc579,0xc57a,0xc57b,0xc57e, /* 0x9DE8-0x9DEF */
	0xc57f,0xc581,0xc582,0xc583,0xc585,0xc586,0xc588,0xc589, /* 0x9DF0-0x9DF7 */
	0xc58a,0xc58b,0xc58e,0xc590,0xc592,0xc593,0xc594,0x0000, /* 0x9DF8-0x9DFF */
	/* codebase=0x9e40 rawbase=0x1640 */
	0x0000,0xc596,0xc599,0xc59a,0xc59b,0xc59d,0xc59e,0xc59f, /* 0x9E40-0x9E47 */
	0xc5a1,0xc5a2,0xc5a3,0xc5a4,0xc5a5,0xc5a6,0xc5a7,0xc5a8, /* 0x9E48-0x9E4F */
	0xc5aa,0xc5ab,0xc5ac,0xc5ad,0xc5ae,0xc5af,0xc5b0,0xc5b1, /* 0x9E50-0x9E57 */
	0xc5b2,0xc5b3,0xc5b6,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9E58-0x9E5F */
	0x0000,0xc5b7,0xc5ba,0xc5bf,0xc5c0,0xc5c1,0xc5c2,0xc5c3, /* 0x9E60-0x9E67 */
	0xc5cb,0xc5cd,0xc5cf,0xc5d2,0xc5d3,0xc5d5,0xc5d6,0xc5d7, /* 0x9E68-0x9E6F */
	0xc5d9,0xc5da,0xc5db,0xc5dc,0xc5dd,0xc5de,0xc5df,0xc5e2, /* 0x9E70-0x9E77 */
	0xc5e4,0xc5e6,0xc5e7,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9E78-0x9E7F */
	/* codebase=0x9e80 rawbase=0x1680 */
	0x0000,0xc5e8,0xc5e9,0xc5ea,0xc5eb,0xc5ef,0xc5f1,0xc5f2, /* 0x9E80-0x9E87 */
	0xc5f3,0xc5f5,0xc5f8,0xc5f9,0xc5fa,0xc5fb,0xc602,0xc603, /* 0x9E88-0x9E8F */
	0xc604,0xc609,0xc60a,0xc60b,0xc60d,0xc60e,0xc60f,0xc611, /* 0x9E90-0x9E97 */
	0xc612,0xc613,0xc614,0xc615,0xc616,0xc617,0xc61a,0xc61d, /* 0x9E98-0x9E9F */
	0xc61e,0xc61f,0xc620,0xc621,0xc622,0xc623,0xc626,0xc627, /* 0x9EA0-0x9EA7 */
	0xc629,0xc62a,0xc62b,0xc62f,0xc631,0xc632,0xc636,0xc638, /* 0x9EA8-0x9EAF */
	0xc63a,0xc63c,0xc63d,0xc63e,0xc63f,0xc642,0xc643,0xc645, /* 0x9EB0-0x9EB7 */
	0xc646,0xc647,0xc649,0xc64a,0xc64b,0xc64c,0xc64d,0xc64e, /* 0x9EB8-0x9EBF */
	/* codebase=0x9ec0 rawbase=0x16c0 */
	0xc64f,0xc652,0xc656,0xc657,0xc658,0xc659,0xc65a,0xc65b, /* 0x9EC0-0x9EC7 */
	0xc65e,0xc65f,0xc661,0xc662,0xc663,0xc664,0xc665,0xc666, /* 0x9EC8-0x9ECF */
	0xc667,0xc668,0xc669,0xc66a,0xc66b,0xc66d,0xc66e,0xc670, /* 0x9ED0-0x9ED7 */
	0xc672,0xc673,0xc674,0xc675,0xc676,0xc677,0xc67a,0xc67b, /* 0x9ED8-0x9EDF */
	0xc67d,0xc67e,0xc67f,0xc681,0xc682,0xc683,0xc684,0xc685, /* 0x9EE0-0x9EE7 */
	0xc686,0xc687,0xc68a,0xc68c,0xc68e,0xc68f,0xc690,0xc691, /* 0x9EE8-0x9EEF */
	0xc692,0xc693,0xc696,0xc697,0xc699,0xc69a,0xc69b,0xc69d, /* 0x9EF0-0x9EF7 */
	0xc69e,0xc69f,0xc6a0,0xc6a1,0xc6a2,0xc6a3,0xc6a6,0x0000, /* 0x9EF8-0x9EFF */
	/* codebase=0x9f40 rawbase=0x1700 */
	0x0000,0xc6a8,0xc6aa,0xc6ab,0xc6ac,0xc6ad,0xc6ae,0xc6af, /* 0x9F40-0x9F47 */
	0xc6b2,0xc6b3,0xc6b5,0xc6b6,0xc6b7,0xc6bb,0xc6bc,0xc6bd, /* 0x9F48-0x9F4F */
	0xc6be,0xc6bf,0xc6c2,0xc6c4,0xc6c6,0xc6c7,0xc6c8,0xc6c9, /* 0x9F50-0x9F57 */
	0xc6ca,0xc6cb,0xc6ce,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9F58-0x9F5F */
	0x0000,0xc6cf,0xc6d1,0xc6d2,0xc6d3,0xc6d5,0xc6d6,0xc6d7, /* 0x9F60-0x9F67 */
	0xc6d8,0xc6d9,0xc6da,0xc6db,0xc6de,0xc6df,0xc6e2,0xc6e3, /* 0x9F68-0x9F6F */
	0xc6e4,0xc6e5,0xc6e6,0xc6e7,0xc6ea,0xc6eb,0xc6ed,0xc6ee, /* 0x9F70-0x9F77 */
	0xc6ef,0xc6f1,0xc6f2,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0x9F78-0x9F7F */
	/* codebase=0x9f80 rawbase=0x1740 */
	0x0000,0xc6f3,0xc6f4,0xc6f5,0xc6f6,0xc6f7,0xc6fa,0xc6fb, /* 0x9F80-0x9F87 */
	0xc6fc,0xc6fe,0xc6ff,0xc700,0xc701,0xc702,0xc703,0xc706, /* 0x9F88-0x9F8F */
	0xc707,0xc709,0xc70a,0xc70b,0xc70d,0xc70e,0xc70f,0xc710, /* 0x9F90-0x9F97 */
	0xc711,0xc712,0xc713,0xc716,0xc718,0xc71a,0xc71b,0xc71c, /* 0x9F98-0x9F9F */
	0xc71d,0xc71e,0xc71f,0xc722,0xc723,0xc725,0xc726,0xc727, /* 0x9FA0-0x9FA7 */
	0xc729,0xc72a,0xc72b,0xc72c,0xc72d,0xc72e,0xc72f,0xc732, /* 0x9FA8-0x9FAF */
	0xc734,0xc736,0xc738,0xc739,0xc73a,0xc73b,0xc73e,0xc73f, /* 0x9FB0-0x9FB7 */
	0xc741,0xc742,0xc743,0xc745,0xc746,0xc747,0xc748,0xc749, /* 0x9FB8-0x9FBF */
	/* codebase=0x9fc0 rawbase=0x1780 */
	0xc74b,0xc74e,0xc750,0xc759,0xc75a,0xc75b,0xc75d,0xc75e, /* 0x9FC0-0x9FC7 */
	0xc75f,0xc761,0xc762,0xc763,0xc764,0xc765,0xc766,0xc767, /* 0x9FC8-0x9FCF */
	0xc769,0xc76a,0xc76c,0xc76d,0xc76e,0xc76f,0xc770,0xc771, /* 0x9FD0-0x9FD7 */
	0xc772,0xc773,0xc776,0xc777,0xc779,0xc77a,0xc77b,0xc77f, /* 0x9FD8-0x9FDF */
	0xc780,0xc781,0xc782,0xc786,0xc78b,0xc78c,0xc78d,0xc78f, /* 0x9FE0-0x9FE7 */
	0xc792,0xc793,0xc795,0xc799,0xc79b,0xc79c,0xc79d,0xc79e, /* 0x9FE8-0x9FEF */
	0xc79f,0xc7a2,0xc7a7,0xc7a8,0xc7a9,0xc7aa,0xc7ab,0xc7ae, /* 0x9FF0-0x9FF7 */
	0xc7af,0xc7b1,0xc7b2,0xc7b3,0xc7b5,0xc7b6,0xc7b7,0x0000, /* 0x9FF8-0x9FFF */
	/* codebase=0xa040 rawbase=0x17c0 */
	0x0000,0xc7b8,0xc7b9,0xc7ba,0xc7bb,0xc7be,0xc7c2,0xc7c3, /* 0xA040-0xA047 */
	0xc7c4,0xc7c5,0xc7c6,0xc7c7,0xc7ca,0xc7cb,0xc7cd,0xc7cf, /* 0xA048-0xA04F */
	0xc7d1,0xc7d2,0xc7d3,0xc7d4,0xc7d5,0xc7d6,0xc7d7,0xc7d9, /* 0xA050-0xA057 */
	0xc7da,0xc7db,0xc7dc,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA058-0xA05F */
	0x0000,0xc7de,0xc7df,0xc7e0,0xc7e1,0xc7e2,0xc7e3,0xc7e5, /* 0xA060-0xA067 */
	0xc7e6,0xc7e7,0xc7e9,0xc7ea,0xc7eb,0xc7ed,0xc7ee,0xc7ef, /* 0xA068-0xA06F */
	0xc7f0,0xc7f1,0xc7f2,0xc7f3,0xc7f4,0xc7f5,0xc7f6,0xc7f7, /* 0xA070-0xA077 */
	0xc7f8,0xc7f9,0xc7fa,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA078-0xA07F */
	/* codebase=0xa080 rawbase=0x1800 */
	0x0000,0xc7fb,0xc7fc,0xc7fd,0xc7fe,0xc7ff,0xc802,0xc803, /* 0xA080-0xA087 */
	0xc805,0xc806,0xc807,0xc809,0xc80b,0xc80c,0xc80d,0xc80e, /* 0xA088-0xA08F */
	0xc80f,0xc812,0xc814,0xc817,0xc818,0xc819,0xc81a,0xc81b, /* 0xA090-0xA097 */
	0xc81e,0xc81f,0xc821,0xc822,0xc823,0xc825,0xc826,0xc827, /* 0xA098-0xA09F */
	0xc828,0xc829,0xc82a,0xc82b,0xc82e,0xc830,0xc832,0xc833, /* 0xA0A0-0xA0A7 */
	0xc834,0xc835,0xc836,0xc837,0xc839,0xc83a,0xc83b,0xc83d, /* 0xA0A8-0xA0AF */
	0xc83e,0xc83f,0xc841,0xc842,0xc843,0xc844,0xc845,0xc846, /* 0xA0B0-0xA0B7 */
	0xc847,0xc84a,0xc84b,0xc84e,0xc84f,0xc850,0xc851,0xc852, /* 0xA0B8-0xA0BF */
	/* codebase=0xa0c0 rawbase=0x1840 */
	0xc853,0xc855,0xc856,0xc857,0xc858,0xc859,0xc85a,0xc85b, /* 0xA0C0-0xA0C7 */
	0xc85c,0xc85d,0xc85e,0xc85f,0xc860,0xc861,0xc862,0xc863, /* 0xA0C8-0xA0CF */
	0xc864,0xc865,0xc866,0xc867,0xc868,0xc869,0xc86a,0xc86b, /* 0xA0D0-0xA0D7 */
	0xc86c,0xc86d,0xc86e,0xc86f,0xc872,0xc873,0xc875,0xc876, /* 0xA0D8-0xA0DF */
	0xc877,0xc879,0xc87b,0xc87c,0xc87d,0xc87e,0xc87f,0xc882, /* 0xA0E0-0xA0E7 */
	0xc884,0xc888,0xc889,0xc88a,0xc88e,0xc88f,0xc890,0xc891, /* 0xA0E8-0xA0EF */
	0xc892,0xc893,0xc895,0xc896,0xc897,0xc898,0xc899,0xc89a, /* 0xA0F0-0xA0F7 */
	0xc89b,0xc89c,0xc89e,0xc8a0,0xc8a2,0xc8a3,0xc8a4,0x0000, /* 0xA0F8-0xA0FF */
	/* codebase=0xa140 rawbase=0x1880 */
	0x0000,0xc8a5,0xc8a6,0xc8a7,0xc8a9,0xc8aa,0xc8ab,0xc8ac, /* 0xA140-0xA147 */
	0xc8ad,0xc8ae,0xc8af,0xc8b0,0xc8b1,0xc8b2,0xc8b3,0xc8b4, /* 0xA148-0xA14F */
	0xc8b5,0xc8b6,0xc8b7,0xc8b8,0xc8b9,0xc8ba,0xc8bb,0xc8be, /* 0xA150-0xA157 */
	0xc8bf,0xc8c0,0xc8c1,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA158-0xA15F */
	0x0000,0xc8c2,0xc8c3,0xc8c5,0xc8c6,0xc8c7,0xc8c9,0xc8ca, /* 0xA160-0xA167 */
	0xc8cb,0xc8cd,0xc8ce,0xc8cf,0xc8d0,0xc8d1,0xc8d2,0xc8d3, /* 0xA168-0xA16F */
	0xc8d6,0xc8d8,0xc8da,0xc8db,0xc8dc,0xc8dd,0xc8de,0xc8df, /* 0xA170-0xA177 */
	0xc8e2,0xc8e3,0xc8e5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA178-0xA17F */
	/* codebase=0xa180 rawbase=0x18c0 */
	0x0000,0xc8e6,0xc8e7,0xc8e8,0xc8e9,0xc8ea,0xc8eb,0xc8ec, /* 0xA180-0xA187 */
	0xc8ed,0xc8ee,0xc8ef,0xc8f0,0xc8f1,0xc8f2,0xc8f3,0xc8f4, /* 0xA188-0xA18F */
	0xc8f6,0xc8f7,0xc8f8,0xc8f9,0xc8fa,0xc8fb,0xc8fe,0xc8ff, /* 0xA190-0xA197 */
	0xc901,0xc902,0xc903,0xc907,0xc908,0xc909,0xc90a,0xc90b, /* 0xA198-0xA19F */
	0xc90e,0x3000,0x3001,0x3002,0x00b7,0x2025,0x2026,0x00a8, /* 0xA1A0-0xA1A7 */
	0x3003,0x00ad,0x2015,0x2225,0xff3c,0x223c,0x2018,0x2019, /* 0xA1A8-0xA1AF */
	0x201c,0x201d,0x3014,0x3015,0x3008,0x3009,0x300a,0x300b, /* 0xA1B0-0xA1B7 */
	0x300c,0x300d,0x300e,0x300f,0x3010,0x3011,0x00b1,0x00d7, /* 0xA1B8-0xA1BF */
	/* codebase=0xa1c0 rawbase=0x1900 */
	0x00f7,0x2260,0x2264,0x2265,0x221e,0x2234,0x00b0,0x2032, /* 0xA1C0-0xA1C7 */
	0x2033,0x2103,0x212b,0xffe0,0xffe1,0xffe5,0x2642,0x2640, /* 0xA1C8-0xA1CF */
	0x2220,0x22a5,0x2312,0x2202,0x2207,0x2261,0x2252,0x00a7, /* 0xA1D0-0xA1D7 */
	0x203b,0x2606,0x2605,0x25cb,0x25cf,0x25ce,0x25c7,0x25c6, /* 0xA1D8-0xA1DF */
	0x25a1,0x25a0,0x25b3,0x25b2,0x25bd,0x25bc,0x2192,0x2190, /* 0xA1E0-0xA1E7 */
	0x2191,0x2193,0x2194,0x3013,0x226a,0x226b,0x221a,0x223d, /* 0xA1E8-0xA1EF */
	0x221d,0x2235,0x222b,0x222c,0x2208,0x220b,0x2286,0x2287, /* 0xA1F0-0xA1F7 */
	0x2282,0x2283,0x222a,0x2229,0x2227,0x2228,0xffe2,0x0000, /* 0xA1F8-0xA1FF */
	/* codebase=0xa240 rawbase=0x1940 */
	0x0000,0xc910,0xc912,0xc913,0xc914,0xc915,0xc916,0xc917, /* 0xA240-0xA247 */
	0xc919,0xc91a,0xc91b,0xc91c,0xc91d,0xc91e,0xc91f,0xc920, /* 0xA248-0xA24F */
	0xc921,0xc922,0xc923,0xc924,0xc925,0xc926,0xc927,0xc928, /* 0xA250-0xA257 */
	0xc929,0xc92a,0xc92b,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA258-0xA25F */
	0x0000,0xc92d,0xc92e,0xc92f,0xc930,0xc931,0xc932,0xc933, /* 0xA260-0xA267 */
	0xc935,0xc936,0xc937,0xc938,0xc939,0xc93a,0xc93b,0xc93c, /* 0xA268-0xA26F */
	0xc93d,0xc93e,0xc93f,0xc940,0xc941,0xc942,0xc943,0xc944, /* 0xA270-0xA277 */
	0xc945,0xc946,0xc947,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA278-0xA27F */
	/* codebase=0xa280 rawbase=0x1980 */
	0x0000,0xc948,0xc949,0xc94a,0xc94b,0xc94c,0xc94d,0xc94e, /* 0xA280-0xA287 */
	0xc94f,0xc952,0xc953,0xc955,0xc956,0xc957,0xc959,0xc95a, /* 0xA288-0xA28F */
	0xc95b,0xc95c,0xc95d,0xc95e,0xc95f,0xc962,0xc964,0xc965, /* 0xA290-0xA297 */
	0xc966,0xc967,0xc968,0xc969,0xc96a,0xc96b,0xc96d,0xc96e, /* 0xA298-0xA29F */
	0xc96f,0x21d2,0x21d4,0x2200,0x2203,0x00b4,0xff5e,0x02c7, /* 0xA2A0-0xA2A7 */
	0x02d8,0x02dd,0x02da,0x02d9,0x00b8,0x02db,0x00a1,0x00bf, /* 0xA2A8-0xA2AF */
	0x02d0,0x222e,0x2211,0x220f,0x00a4,0x2109,0x2030,0x25c1, /* 0xA2B0-0xA2B7 */
	0x25c0,0x25b7,0x25b6,0x2664,0x2660,0x2661,0x2665,0x2667, /* 0xA2B8-0xA2BF */
	/* codebase=0xa2c0 rawbase=0x19c0 */
	0x2663,0x2299,0x25c8,0x25a3,0x25d0,0x25d1,0x2592,0x25a4, /* 0xA2C0-0xA2C7 */
	0x25a5,0x25a8,0x25a7,0x25a6,0x25a9,0x2668,0x260f,0x260e, /* 0xA2C8-0xA2CF */
	0x261c,0x261e,0x00b6,0x2020,0x2021,0x2195,0x2197,0x2199, /* 0xA2D0-0xA2D7 */
	0x2196,0x2198,0x266d,0x2669,0x266a,0x266c,0x327f,0x321c, /* 0xA2D8-0xA2DF */
	0x2116,0x33c7,0x2122,0x33c2,0x33d8,0x2121,0x20ac,0x00ae, /* 0xA2E0-0xA2E7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA2E8-0xA2EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA2F0-0xA2F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA2F8-0xA2FF */
	/* codebase=0xa340 rawbase=0x1a00 */
	0x0000,0xc971,0xc972,0xc973,0xc975,0xc976,0xc977,0xc978, /* 0xA340-0xA347 */
	0xc979,0xc97a,0xc97b,0xc97d,0xc97e,0xc97f,0xc980,0xc981, /* 0xA348-0xA34F */
	0xc982,0xc983,0xc984,0xc985,0xc986,0xc987,0xc98a,0xc98b, /* 0xA350-0xA357 */
	0xc98d,0xc98e,0xc98f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA358-0xA35F */
	0x0000,0xc991,0xc992,0xc993,0xc994,0xc995,0xc996,0xc997, /* 0xA360-0xA367 */
	0xc99a,0xc99c,0xc99e,0xc99f,0xc9a0,0xc9a1,0xc9a2,0xc9a3, /* 0xA368-0xA36F */
	0xc9a4,0xc9a5,0xc9a6,0xc9a7,0xc9a8,0xc9a9,0xc9aa,0xc9ab, /* 0xA370-0xA377 */
	0xc9ac,0xc9ad,0xc9ae,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA378-0xA37F */
	/* codebase=0xa380 rawbase=0x1a40 */
	0x0000,0xc9af,0xc9b0,0xc9b1,0xc9b2,0xc9b3,0xc9b4,0xc9b5, /* 0xA380-0xA387 */
	0xc9b6,0xc9b7,0xc9b8,0xc9b9,0xc9ba,0xc9bb,0xc9bc,0xc9bd, /* 0xA388-0xA38F */
	0xc9be,0xc9bf,0xc9c2,0xc9c3,0xc9c5,0xc9c6,0xc9c9,0xc9cb, /* 0xA390-0xA397 */
	0xc9cc,0xc9cd,0xc9ce,0xc9cf,0xc9d2,0xc9d4,0xc9d7,0xc9d8, /* 0xA398-0xA39F */
	0xc9db,0xff01,0xff02,0xff03,0xff04,0xff05,0xff06,0xff07, /* 0xA3A0-0xA3A7 */
	0xff08,0xff09,0xff0a,0xff0b,0xff0c,0xff0d,0xff0e,0xff0f, /* 0xA3A8-0xA3AF */
	0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17, /* 0xA3B0-0xA3B7 */
	0xff18,0xff19,0xff1a,0xff1b,0xff1c,0xff1d,0xff1e,0xff1f, /* 0xA3B8-0xA3BF */
	/* codebase=0xa3c0 rawbase=0x1a80 */
	0xff20,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27, /* 0xA3C0-0xA3C7 */
	0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f, /* 0xA3C8-0xA3CF */
	0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37, /* 0xA3D0-0xA3D7 */
	0xff38,0xff39,0xff3a,0xff3b,0xffe6,0xff3d,0xff3e,0xff3f, /* 0xA3D8-0xA3DF */
	0xff40,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47, /* 0xA3E0-0xA3E7 */
	0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f, /* 0xA3E8-0xA3EF */
	0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57, /* 0xA3F0-0xA3F7 */
	0xff58,0xff59,0xff5a,0xff5b,0xff5c,0xff5d,0xffe3,0x0000, /* 0xA3F8-0xA3FF */
	/* codebase=0xa440 rawbase=0x1ac0 */
	0x0000,0xc9de,0xc9df,0xc9e1,0xc9e3,0xc9e5,0xc9e6,0xc9e8, /* 0xA440-0xA447 */
	0xc9e9,0xc9ea,0xc9eb,0xc9ee,0xc9f2,0xc9f3,0xc9f4,0xc9f5, /* 0xA448-0xA44F */
	0xc9f6,0xc9f7,0xc9fa,0xc9fb,0xc9fd,0xc9fe,0xc9ff,0xca01, /* 0xA450-0xA457 */
	0xca02,0xca03,0xca04,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA458-0xA45F */
	0x0000,0xca05,0xca06,0xca07,0xca0a,0xca0e,0xca0f,0xca10, /* 0xA460-0xA467 */
	0xca11,0xca12,0xca13,0xca15,0xca16,0xca17,0xca19,0xca1a, /* 0xA468-0xA46F */
	0xca1b,0xca1c,0xca1d,0xca1e,0xca1f,0xca20,0xca21,0xca22, /* 0xA470-0xA477 */
	0xca23,0xca24,0xca25,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA478-0xA47F */
	/* codebase=0xa480 rawbase=0x1b00 */
	0x0000,0xca26,0xca27,0xca28,0xca2a,0xca2b,0xca2c,0xca2d, /* 0xA480-0xA487 */
	0xca2e,0xca2f,0xca30,0xca31,0xca32,0xca33,0xca34,0xca35, /* 0xA488-0xA48F */
	0xca36,0xca37,0xca38,0xca39,0xca3a,0xca3b,0xca3c,0xca3d, /* 0xA490-0xA497 */
	0xca3e,0xca3f,0xca40,0xca41,0xca42,0xca43,0xca44,0xca45, /* 0xA498-0xA49F */
	0xca46,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137, /* 0xA4A0-0xA4A7 */
	0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f, /* 0xA4A8-0xA4AF */
	0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147, /* 0xA4B0-0xA4B7 */
	0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0x314f, /* 0xA4B8-0xA4BF */
	/* codebase=0xa4c0 rawbase=0x1b40 */
	0x3150,0x3151,0x3152,0x3153,0x3154,0x3155,0x3156,0x3157, /* 0xA4C0-0xA4C7 */
	0x3158,0x3159,0x315a,0x315b,0x315c,0x315d,0x315e,0x315f, /* 0xA4C8-0xA4CF */
	0x3160,0x3161,0x3162,0x3163,0x3164,0x3165,0x3166,0x3167, /* 0xA4D0-0xA4D7 */
	0x3168,0x3169,0x316a,0x316b,0x316c,0x316d,0x316e,0x316f, /* 0xA4D8-0xA4DF */
	0x3170,0x3171,0x3172,0x3173,0x3174,0x3175,0x3176,0x3177, /* 0xA4E0-0xA4E7 */
	0x3178,0x3179,0x317a,0x317b,0x317c,0x317d,0x317e,0x317f, /* 0xA4E8-0xA4EF */
	0x3180,0x3181,0x3182,0x3183,0x3184,0x3185,0x3186,0x3187, /* 0xA4F0-0xA4F7 */
	0x3188,0x3189,0x318a,0x318b,0x318c,0x318d,0x318e,0x0000, /* 0xA4F8-0xA4FF */
	/* codebase=0xa540 rawbase=0x1b80 */
	0x0000,0xca47,0xca48,0xca49,0xca4a,0xca4b,0xca4e,0xca4f, /* 0xA540-0xA547 */
	0xca51,0xca52,0xca53,0xca55,0xca56,0xca57,0xca58,0xca59, /* 0xA548-0xA54F */
	0xca5a,0xca5b,0xca5e,0xca62,0xca63,0xca64,0xca65,0xca66, /* 0xA550-0xA557 */
	0xca67,0xca69,0xca6a,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA558-0xA55F */
	0x0000,0xca6b,0xca6c,0xca6d,0xca6e,0xca6f,0xca70,0xca71, /* 0xA560-0xA567 */
	0xca72,0xca73,0xca74,0xca75,0xca76,0xca77,0xca78,0xca79, /* 0xA568-0xA56F */
	0xca7a,0xca7b,0xca7c,0xca7e,0xca7f,0xca80,0xca81,0xca82, /* 0xA570-0xA577 */
	0xca83,0xca85,0xca86,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA578-0xA57F */
	/* codebase=0xa580 rawbase=0x1bc0 */
	0x0000,0xca87,0xca88,0xca89,0xca8a,0xca8b,0xca8c,0xca8d, /* 0xA580-0xA587 */
	0xca8e,0xca8f,0xca90,0xca91,0xca92,0xca93,0xca94,0xca95, /* 0xA588-0xA58F */
	0xca96,0xca97,0xca99,0xca9a,0xca9b,0xca9c,0xca9d,0xca9e, /* 0xA590-0xA597 */
	0xca9f,0xcaa0,0xcaa1,0xcaa2,0xcaa3,0xcaa4,0xcaa5,0xcaa6, /* 0xA598-0xA59F */
	0xcaa7,0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,0x2176, /* 0xA5A0-0xA5A7 */
	0x2177,0x2178,0x2179,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA5A8-0xA5AF */
	0x2160,0x2161,0x2162,0x2163,0x2164,0x2165,0x2166,0x2167, /* 0xA5B0-0xA5B7 */
	0x2168,0x2169,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA5B8-0xA5BF */
	/* codebase=0xa5c0 rawbase=0x1c00 */
	0x0000,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397, /* 0xA5C0-0xA5C7 */
	0x0398,0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f, /* 0xA5C8-0xA5CF */
	0x03a0,0x03a1,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8, /* 0xA5D0-0xA5D7 */
	0x03a9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA5D8-0xA5DF */
	0x0000,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7, /* 0xA5E0-0xA5E7 */
	0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf, /* 0xA5E8-0xA5EF */
	0x03c0,0x03c1,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8, /* 0xA5F0-0xA5F7 */
	0x03c9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA5F8-0xA5FF */
	/* codebase=0xa640 rawbase=0x1c40 */
	0x0000,0xcaa8,0xcaa9,0xcaaa,0xcaab,0xcaac,0xcaad,0xcaae, /* 0xA640-0xA647 */
	0xcaaf,0xcab0,0xcab1,0xcab2,0xcab3,0xcab4,0xcab5,0xcab6, /* 0xA648-0xA64F */
	0xcab7,0xcab8,0xcab9,0xcaba,0xcabb,0xcabe,0xcabf,0xcac1, /* 0xA650-0xA657 */
	0xcac2,0xcac3,0xcac5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA658-0xA65F */
	0x0000,0xcac6,0xcac7,0xcac8,0xcac9,0xcaca,0xcacb,0xcace, /* 0xA660-0xA667 */
	0xcad0,0xcad2,0xcad4,0xcad5,0xcad6,0xcad7,0xcada,0xcadb, /* 0xA668-0xA66F */
	0xcadc,0xcadd,0xcade,0xcadf,0xcae1,0xcae2,0xcae3,0xcae4, /* 0xA670-0xA677 */
	0xcae5,0xcae6,0xcae7,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA678-0xA67F */
	/* codebase=0xa680 rawbase=0x1c80 */
	0x0000,0xcae8,0xcae9,0xcaea,0xcaeb,0xcaed,0xcaee,0xcaef, /* 0xA680-0xA687 */
	0xcaf0,0xcaf1,0xcaf2,0xcaf3,0xcaf5,0xcaf6,0xcaf7,0xcaf8, /* 0xA688-0xA68F */
	0xcaf9,0xcafa,0xcafb,0xcafc,0xcafd,0xcafe,0xcaff,0xcb00, /* 0xA690-0xA697 */
	0xcb01,0xcb02,0xcb03,0xcb04,0xcb05,0xcb06,0xcb07,0xcb09, /* 0xA698-0xA69F */
	0xcb0a,0x2500,0x2502,0x250c,0x2510,0x2518,0x2514,0x251c, /* 0xA6A0-0xA6A7 */
	0x252c,0x2524,0x2534,0x253c,0x2501,0x2503,0x250f,0x2513, /* 0xA6A8-0xA6AF */
	0x251b,0x2517,0x2523,0x2533,0x252b,0x253b,0x254b,0x2520, /* 0xA6B0-0xA6B7 */
	0x252f,0x2528,0x2537,0x253f,0x251d,0x2530,0x2525,0x2538, /* 0xA6B8-0xA6BF */
	/* codebase=0xa6c0 rawbase=0x1cc0 */
	0x2542,0x2512,0x2511,0x251a,0x2519,0x2516,0x2515,0x250e, /* 0xA6C0-0xA6C7 */
	0x250d,0x251e,0x251f,0x2521,0x2522,0x2526,0x2527,0x2529, /* 0xA6C8-0xA6CF */
	0x252a,0x252d,0x252e,0x2531,0x2532,0x2535,0x2536,0x2539, /* 0xA6D0-0xA6D7 */
	0x253a,0x253d,0x253e,0x2540,0x2541,0x2543,0x2544,0x2545, /* 0xA6D8-0xA6DF */
	0x2546,0x2547,0x2548,0x2549,0x254a,0x0000,0x0000,0x0000, /* 0xA6E0-0xA6E7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA6E8-0xA6EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA6F0-0xA6F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA6F8-0xA6FF */
	/* codebase=0xa740 rawbase=0x1d00 */
	0x0000,0xcb0b,0xcb0c,0xcb0d,0xcb0e,0xcb0f,0xcb11,0xcb12, /* 0xA740-0xA747 */
	0xcb13,0xcb15,0xcb16,0xcb17,0xcb19,0xcb1a,0xcb1b,0xcb1c, /* 0xA748-0xA74F */
	0xcb1d,0xcb1e,0xcb1f,0xcb22,0xcb23,0xcb24,0xcb25,0xcb26, /* 0xA750-0xA757 */
	0xcb27,0xcb28,0xcb29,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA758-0xA75F */
	0x0000,0xcb2a,0xcb2b,0xcb2c,0xcb2d,0xcb2e,0xcb2f,0xcb30, /* 0xA760-0xA767 */
	0xcb31,0xcb32,0xcb33,0xcb34,0xcb35,0xcb36,0xcb37,0xcb38, /* 0xA768-0xA76F */
	0xcb39,0xcb3a,0xcb3b,0xcb3c,0xcb3d,0xcb3e,0xcb3f,0xcb40, /* 0xA770-0xA777 */
	0xcb42,0xcb43,0xcb44,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA778-0xA77F */
	/* codebase=0xa780 rawbase=0x1d40 */
	0x0000,0xcb45,0xcb46,0xcb47,0xcb4a,0xcb4b,0xcb4d,0xcb4e, /* 0xA780-0xA787 */
	0xcb4f,0xcb51,0xcb52,0xcb53,0xcb54,0xcb55,0xcb56,0xcb57, /* 0xA788-0xA78F */
	0xcb5a,0xcb5b,0xcb5c,0xcb5e,0xcb5f,0xcb60,0xcb61,0xcb62, /* 0xA790-0xA797 */
	0xcb63,0xcb65,0xcb66,0xcb67,0xcb68,0xcb69,0xcb6a,0xcb6b, /* 0xA798-0xA79F */
	0xcb6c,0x3395,0x3396,0x3397,0x2113,0x3398,0x33c4,0x33a3, /* 0xA7A0-0xA7A7 */
	0x33a4,0x33a5,0x33a6,0x3399,0x339a,0x339b,0x339c,0x339d, /* 0xA7A8-0xA7AF */
	0x339e,0x339f,0x33a0,0x33a1,0x33a2,0x33ca,0x338d,0x338e, /* 0xA7B0-0xA7B7 */
	0x338f,0x33cf,0x3388,0x3389,0x33c8,0x33a7,0x33a8,0x33b0, /* 0xA7B8-0xA7BF */
	/* codebase=0xa7c0 rawbase=0x1d80 */
	0x33b1,0x33b2,0x33b3,0x33b4,0x33b5,0x33b6,0x33b7,0x33b8, /* 0xA7C0-0xA7C7 */
	0x33b9,0x3380,0x3381,0x3382,0x3383,0x3384,0x33ba,0x33bb, /* 0xA7C8-0xA7CF */
	0x33bc,0x33bd,0x33be,0x33bf,0x3390,0x3391,0x3392,0x3393, /* 0xA7D0-0xA7D7 */
	0x3394,0x2126,0x33c0,0x33c1,0x338a,0x338b,0x338c,0x33d6, /* 0xA7D8-0xA7DF */
	0x33c5,0x33ad,0x33ae,0x33af,0x33db,0x33a9,0x33aa,0x33ab, /* 0xA7E0-0xA7E7 */
	0x33ac,0x33dd,0x33d0,0x33d3,0x33c3,0x33c9,0x33dc,0x33c6, /* 0xA7E8-0xA7EF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA7F0-0xA7F7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA7F8-0xA7FF */
	/* codebase=0xa840 rawbase=0x1dc0 */
	0x0000,0xcb6d,0xcb6e,0xcb6f,0xcb70,0xcb71,0xcb72,0xcb73, /* 0xA840-0xA847 */
	0xcb74,0xcb75,0xcb76,0xcb77,0xcb7a,0xcb7b,0xcb7c,0xcb7d, /* 0xA848-0xA84F */
	0xcb7e,0xcb7f,0xcb80,0xcb81,0xcb82,0xcb83,0xcb84,0xcb85, /* 0xA850-0xA857 */
	0xcb86,0xcb87,0xcb88,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA858-0xA85F */
	0x0000,0xcb89,0xcb8a,0xcb8b,0xcb8c,0xcb8d,0xcb8e,0xcb8f, /* 0xA860-0xA867 */
	0xcb90,0xcb91,0xcb92,0xcb93,0xcb94,0xcb95,0xcb96,0xcb97, /* 0xA868-0xA86F */
	0xcb98,0xcb99,0xcb9a,0xcb9b,0xcb9d,0xcb9e,0xcb9f,0xcba0, /* 0xA870-0xA877 */
	0xcba1,0xcba2,0xcba3,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA878-0xA87F */
	/* codebase=0xa880 rawbase=0x1e00 */
	0x0000,0xcba4,0xcba5,0xcba6,0xcba7,0xcba8,0xcba9,0xcbaa, /* 0xA880-0xA887 */
	0xcbab,0xcbac,0xcbad,0xcbae,0xcbaf,0xcbb0,0xcbb1,0xcbb2, /* 0xA888-0xA88F */
	0xcbb3,0xcbb4,0xcbb5,0xcbb6,0xcbb7,0xcbb9,0xcbba,0xcbbb, /* 0xA890-0xA897 */
	0xcbbc,0xcbbd,0xcbbe,0xcbbf,0xcbc0,0xcbc1,0xcbc2,0xcbc3, /* 0xA898-0xA89F */
	0xcbc4,0x00c6,0x00d0,0x00aa,0x0126,0x0000,0x0132,0x0000, /* 0xA8A0-0xA8A7 */
	0x013f,0x0141,0x00d8,0x0152,0x00ba,0x00de,0x0166,0x014a, /* 0xA8A8-0xA8AF */
	0x0000,0x3260,0x3261,0x3262,0x3263,0x3264,0x3265,0x3266, /* 0xA8B0-0xA8B7 */
	0x3267,0x3268,0x3269,0x326a,0x326b,0x326c,0x326d,0x326e, /* 0xA8B8-0xA8BF */
	/* codebase=0xa8c0 rawbase=0x1e40 */
	0x326f,0x3270,0x3271,0x3272,0x3273,0x3274,0x3275,0x3276, /* 0xA8C0-0xA8C7 */
	0x3277,0x3278,0x3279,0x327a,0x327b,0x24d0,0x24d1,0x24d2, /* 0xA8C8-0xA8CF */
	0x24d3,0x24d4,0x24d5,0x24d6,0x24d7,0x24d8,0x24d9,0x24da, /* 0xA8D0-0xA8D7 */
	0x24db,0x24dc,0x24dd,0x24de,0x24df,0x24e0,0x24e1,0x24e2, /* 0xA8D8-0xA8DF */
	0x24e3,0x24e4,0x24e5,0x24e6,0x24e7,0x24e8,0x24e9,0x2460, /* 0xA8E0-0xA8E7 */
	0x2461,0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,0x2468, /* 0xA8E8-0xA8EF */
	0x2469,0x246a,0x246b,0x246c,0x246d,0x246e,0x00bd,0x2153, /* 0xA8F0-0xA8F7 */
	0x2154,0x00bc,0x00be,0x215b,0x215c,0x215d,0x215e,0x0000, /* 0xA8F8-0xA8FF */
	/* codebase=0xa940 rawbase=0x1e80 */
	0x0000,0xcbc5,0xcbc6,0xcbc7,0xcbc8,0xcbc9,0xcbca,0xcbcb, /* 0xA940-0xA947 */
	0xcbcc,0xcbcd,0xcbce,0xcbcf,0xcbd0,0xcbd1,0xcbd2,0xcbd3, /* 0xA948-0xA94F */
	0xcbd5,0xcbd6,0xcbd7,0xcbd8,0xcbd9,0xcbda,0xcbdb,0xcbdc, /* 0xA950-0xA957 */
	0xcbdd,0xcbde,0xcbdf,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA958-0xA95F */
	0x0000,0xcbe0,0xcbe1,0xcbe2,0xcbe3,0xcbe5,0xcbe6,0xcbe8, /* 0xA960-0xA967 */
	0xcbea,0xcbeb,0xcbec,0xcbed,0xcbee,0xcbef,0xcbf0,0xcbf1, /* 0xA968-0xA96F */
	0xcbf2,0xcbf3,0xcbf4,0xcbf5,0xcbf6,0xcbf7,0xcbf8,0xcbf9, /* 0xA970-0xA977 */
	0xcbfa,0xcbfb,0xcbfc,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xA978-0xA97F */
	/* codebase=0xa980 rawbase=0x1ec0 */
	0x0000,0xcbfd,0xcbfe,0xcbff,0xcc00,0xcc01,0xcc02,0xcc03, /* 0xA980-0xA987 */
	0xcc04,0xcc05,0xcc06,0xcc07,0xcc08,0xcc09,0xcc0a,0xcc0b, /* 0xA988-0xA98F */
	0xcc0e,0xcc0f,0xcc11,0xcc12,0xcc13,0xcc15,0xcc16,0xcc17, /* 0xA990-0xA997 */
	0xcc18,0xcc19,0xcc1a,0xcc1b,0xcc1e,0xcc1f,0xcc20,0xcc23, /* 0xA998-0xA99F */
	0xcc24,0x00e6,0x0111,0x00f0,0x0127,0x0131,0x0133,0x0138, /* 0xA9A0-0xA9A7 */
	0x0140,0x0142,0x00f8,0x0153,0x00df,0x00fe,0x0167,0x014b, /* 0xA9A8-0xA9AF */
	0x0149,0x3200,0x3201,0x3202,0x3203,0x3204,0x3205,0x3206, /* 0xA9B0-0xA9B7 */
	0x3207,0x3208,0x3209,0x320a,0x320b,0x320c,0x320d,0x320e, /* 0xA9B8-0xA9BF */
	/* codebase=0xa9c0 rawbase=0x1f00 */
	0x320f,0x3210,0x3211,0x3212,0x3213,0x3214,0x3215,0x3216, /* 0xA9C0-0xA9C7 */
	0x3217,0x3218,0x3219,0x321a,0x321b,0x249c,0x249d,0x249e, /* 0xA9C8-0xA9CF */
	0x249f,0x24a0,0x24a1,0x24a2,0x24a3,0x24a4,0x24a5,0x24a6, /* 0xA9D0-0xA9D7 */
	0x24a7,0x24a8,0x24a9,0x24aa,0x24ab,0x24ac,0x24ad,0x24ae, /* 0xA9D8-0xA9DF */
	0x24af,0x24b0,0x24b1,0x24b2,0x24b3,0x24b4,0x24b5,0x2474, /* 0xA9E0-0xA9E7 */
	0x2475,0x2476,0x2477,0x2478,0x2479,0x247a,0x247b,0x247c, /* 0xA9E8-0xA9EF */
	0x247d,0x247e,0x247f,0x2480,0x2481,0x2482,0x00b9,0x00b2, /* 0xA9F0-0xA9F7 */
	0x00b3,0x2074,0x207f,0x2081,0x2082,0x2083,0x2084,0x0000, /* 0xA9F8-0xA9FF */
	/* codebase=0xaa40 rawbase=0x1f40 */
	0x0000,0xcc25,0xcc26,0xcc2a,0xcc2b,0xcc2d,0xcc2f,0xcc31, /* 0xAA40-0xAA47 */
	0xcc32,0xcc33,0xcc34,0xcc35,0xcc36,0xcc37,0xcc3a,0xcc3f, /* 0xAA48-0xAA4F */
	0xcc40,0xcc41,0xcc42,0xcc43,0xcc46,0xcc47,0xcc49,0xcc4a, /* 0xAA50-0xAA57 */
	0xcc4b,0xcc4d,0xcc4e,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAA58-0xAA5F */
	0x0000,0xcc4f,0xcc50,0xcc51,0xcc52,0xcc53,0xcc56,0xcc5a, /* 0xAA60-0xAA67 */
	0xcc5b,0xcc5c,0xcc5d,0xcc5e,0xcc5f,0xcc61,0xcc62,0xcc63, /* 0xAA68-0xAA6F */
	0xcc65,0xcc67,0xcc69,0xcc6a,0xcc6b,0xcc6c,0xcc6d,0xcc6e, /* 0xAA70-0xAA77 */
	0xcc6f,0xcc71,0xcc72,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAA78-0xAA7F */
	/* codebase=0xaa80 rawbase=0x1f80 */
	0x0000,0xcc73,0xcc74,0xcc76,0xcc77,0xcc78,0xcc79,0xcc7a, /* 0xAA80-0xAA87 */
	0xcc7b,0xcc7c,0xcc7d,0xcc7e,0xcc7f,0xcc80,0xcc81,0xcc82, /* 0xAA88-0xAA8F */
	0xcc83,0xcc84,0xcc85,0xcc86,0xcc87,0xcc88,0xcc89,0xcc8a, /* 0xAA90-0xAA97 */
	0xcc8b,0xcc8c,0xcc8d,0xcc8e,0xcc8f,0xcc90,0xcc91,0xcc92, /* 0xAA98-0xAA9F */
	0xcc93,0x3041,0x3042,0x3043,0x3044,0x3045,0x3046,0x3047, /* 0xAAA0-0xAAA7 */
	0x3048,0x3049,0x304a,0x304b,0x304c,0x304d,0x304e,0x304f, /* 0xAAA8-0xAAAF */
	0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057, /* 0xAAB0-0xAAB7 */
	0x3058,0x3059,0x305a,0x305b,0x305c,0x305d,0x305e,0x305f, /* 0xAAB8-0xAABF */
	/* codebase=0xaac0 rawbase=0x1fc0 */
	0x3060,0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067, /* 0xAAC0-0xAAC7 */
	0x3068,0x3069,0x306a,0x306b,0x306c,0x306d,0x306e,0x306f, /* 0xAAC8-0xAACF */
	0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077, /* 0xAAD0-0xAAD7 */
	0x3078,0x3079,0x307a,0x307b,0x307c,0x307d,0x307e,0x307f, /* 0xAAD8-0xAADF */
	0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087, /* 0xAAE0-0xAAE7 */
	0x3088,0x3089,0x308a,0x308b,0x308c,0x308d,0x308e,0x308f, /* 0xAAE8-0xAAEF */
	0x3090,0x3091,0x3092,0x3093,0x0000,0x0000,0x0000,0x0000, /* 0xAAF0-0xAAF7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAAF8-0xAAFF */
	/* codebase=0xab40 rawbase=0x2000 */
	0x0000,0xcc94,0xcc95,0xcc96,0xcc97,0xcc9a,0xcc9b,0xcc9d, /* 0xAB40-0xAB47 */
	0xcc9e,0xcc9f,0xcca1,0xcca2,0xcca3,0xcca4,0xcca5,0xcca6, /* 0xAB48-0xAB4F */
	0xcca7,0xccaa,0xccae,0xccaf,0xccb0,0xccb1,0xccb2,0xccb3, /* 0xAB50-0xAB57 */
	0xccb6,0xccb7,0xccb9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAB58-0xAB5F */
	0x0000,0xccba,0xccbb,0xccbd,0xccbe,0xccbf,0xccc0,0xccc1, /* 0xAB60-0xAB67 */
	0xccc2,0xccc3,0xccc6,0xccc8,0xccca,0xcccb,0xcccc,0xcccd, /* 0xAB68-0xAB6F */
	0xccce,0xcccf,0xccd1,0xccd2,0xccd3,0xccd5,0xccd6,0xccd7, /* 0xAB70-0xAB77 */
	0xccd8,0xccd9,0xccda,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAB78-0xAB7F */
	/* codebase=0xab80 rawbase=0x2040 */
	0x0000,0xccdb,0xccdc,0xccdd,0xccde,0xccdf,0xcce0,0xcce1, /* 0xAB80-0xAB87 */
	0xcce2,0xcce3,0xcce5,0xcce6,0xcce7,0xcce8,0xcce9,0xccea, /* 0xAB88-0xAB8F */
	0xcceb,0xcced,0xccee,0xccef,0xccf1,0xccf2,0xccf3,0xccf4, /* 0xAB90-0xAB97 */
	0xccf5,0xccf6,0xccf7,0xccf8,0xccf9,0xccfa,0xccfb,0xccfc, /* 0xAB98-0xAB9F */
	0xccfd,0x30a1,0x30a2,0x30a3,0x30a4,0x30a5,0x30a6,0x30a7, /* 0xABA0-0xABA7 */
	0x30a8,0x30a9,0x30aa,0x30ab,0x30ac,0x30ad,0x30ae,0x30af, /* 0xABA8-0xABAF */
	0x30b0,0x30b1,0x30b2,0x30b3,0x30b4,0x30b5,0x30b6,0x30b7, /* 0xABB0-0xABB7 */
	0x30b8,0x30b9,0x30ba,0x30bb,0x30bc,0x30bd,0x30be,0x30bf, /* 0xABB8-0xABBF */
	/* codebase=0xabc0 rawbase=0x2080 */
	0x30c0,0x30c1,0x30c2,0x30c3,0x30c4,0x30c5,0x30c6,0x30c7, /* 0xABC0-0xABC7 */
	0x30c8,0x30c9,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf, /* 0xABC8-0xABCF */
	0x30d0,0x30d1,0x30d2,0x30d3,0x30d4,0x30d5,0x30d6,0x30d7, /* 0xABD0-0xABD7 */
	0x30d8,0x30d9,0x30da,0x30db,0x30dc,0x30dd,0x30de,0x30df, /* 0xABD8-0xABDF */
	0x30e0,0x30e1,0x30e2,0x30e3,0x30e4,0x30e5,0x30e6,0x30e7, /* 0xABE0-0xABE7 */
	0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ee,0x30ef, /* 0xABE8-0xABEF */
	0x30f0,0x30f1,0x30f2,0x30f3,0x30f4,0x30f5,0x30f6,0x0000, /* 0xABF0-0xABF7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xABF8-0xABFF */
	/* codebase=0xac40 rawbase=0x20c0 */
	0x0000,0xccfe,0xccff,0xcd00,0xcd02,0xcd03,0xcd04,0xcd05, /* 0xAC40-0xAC47 */
	0xcd06,0xcd07,0xcd0a,0xcd0b,0xcd0d,0xcd0e,0xcd0f,0xcd11, /* 0xAC48-0xAC4F */
	0xcd12,0xcd13,0xcd14,0xcd15,0xcd16,0xcd17,0xcd1a,0xcd1c, /* 0xAC50-0xAC57 */
	0xcd1e,0xcd1f,0xcd20,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAC58-0xAC5F */
	0x0000,0xcd21,0xcd22,0xcd23,0xcd25,0xcd26,0xcd27,0xcd29, /* 0xAC60-0xAC67 */
	0xcd2a,0xcd2b,0xcd2d,0xcd2e,0xcd2f,0xcd30,0xcd31,0xcd32, /* 0xAC68-0xAC6F */
	0xcd33,0xcd34,0xcd35,0xcd36,0xcd37,0xcd38,0xcd3a,0xcd3b, /* 0xAC70-0xAC77 */
	0xcd3c,0xcd3d,0xcd3e,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAC78-0xAC7F */
	/* codebase=0xac80 rawbase=0x2100 */
	0x0000,0xcd3f,0xcd40,0xcd41,0xcd42,0xcd43,0xcd44,0xcd45, /* 0xAC80-0xAC87 */
	0xcd46,0xcd47,0xcd48,0xcd49,0xcd4a,0xcd4b,0xcd4c,0xcd4d, /* 0xAC88-0xAC8F */
	0xcd4e,0xcd4f,0xcd50,0xcd51,0xcd52,0xcd53,0xcd54,0xcd55, /* 0xAC90-0xAC97 */
	0xcd56,0xcd57,0xcd58,0xcd59,0xcd5a,0xcd5b,0xcd5d,0xcd5e, /* 0xAC98-0xAC9F */
	0xcd5f,0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,0x0401, /* 0xACA0-0xACA7 */
	0x0416,0x0417,0x0418,0x0419,0x041a,0x041b,0x041c,0x041d, /* 0xACA8-0xACAF */
	0x041e,0x041f,0x0420,0x0421,0x0422,0x0423,0x0424,0x0425, /* 0xACB0-0xACB7 */
	0x0426,0x0427,0x0428,0x0429,0x042a,0x042b,0x042c,0x042d, /* 0xACB8-0xACBF */
	/* codebase=0xacc0 rawbase=0x2140 */
	0x042e,0x042f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACC0-0xACC7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACC8-0xACCF */
	0x0000,0x0430,0x0431,0x0432,0x0433,0x0434,0x0435,0x0451, /* 0xACD0-0xACD7 */
	0x0436,0x0437,0x0438,0x0439,0x043a,0x043b,0x043c,0x043d, /* 0xACD8-0xACDF */
	0x043e,0x043f,0x0440,0x0441,0x0442,0x0443,0x0444,0x0445, /* 0xACE0-0xACE7 */
	0x0446,0x0447,0x0448,0x0449,0x044a,0x044b,0x044c,0x044d, /* 0xACE8-0xACEF */
	0x044e,0x044f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACF0-0xACF7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xACF8-0xACFF */
	/* codebase=0xad40 rawbase=0x2180 */
	0x0000,0xcd61,0xcd62,0xcd63,0xcd65,0xcd66,0xcd67,0xcd68, /* 0xAD40-0xAD47 */
	0xcd69,0xcd6a,0xcd6b,0xcd6e,0xcd70,0xcd72,0xcd73,0xcd74, /* 0xAD48-0xAD4F */
	0xcd75,0xcd76,0xcd77,0xcd79,0xcd7a,0xcd7b,0xcd7c,0xcd7d, /* 0xAD50-0xAD57 */
	0xcd7e,0xcd7f,0xcd80,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAD58-0xAD5F */
	0x0000,0xcd81,0xcd82,0xcd83,0xcd84,0xcd85,0xcd86,0xcd87, /* 0xAD60-0xAD67 */
	0xcd89,0xcd8a,0xcd8b,0xcd8c,0xcd8d,0xcd8e,0xcd8f,0xcd90, /* 0xAD68-0xAD6F */
	0xcd91,0xcd92,0xcd93,0xcd96,0xcd97,0xcd99,0xcd9a,0xcd9b, /* 0xAD70-0xAD77 */
	0xcd9d,0xcd9e,0xcd9f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAD78-0xAD7F */
	/* codebase=0xad80 rawbase=0x21c0 */
	0x0000,0xcda0,0xcda1,0xcda2,0xcda3,0xcda6,0xcda8,0xcdaa, /* 0xAD80-0xAD87 */
	0xcdab,0xcdac,0xcdad,0xcdae,0xcdaf,0xcdb1,0xcdb2,0xcdb3, /* 0xAD88-0xAD8F */
	0xcdb4,0xcdb5,0xcdb6,0xcdb7,0xcdb8,0xcdb9,0xcdba,0xcdbb, /* 0xAD90-0xAD97 */
	0xcdbc,0xcdbd,0xcdbe,0xcdbf,0xcdc0,0xcdc1,0xcdc2,0xcdc3, /* 0xAD98-0xAD9F */
	0xcdc5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADA0-0xADA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADA8-0xADAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADB0-0xADB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xADB8-0xADBF */
	/* codebase=0xae40 rawbase=0x2200 */
	0x0000,0xcdc6,0xcdc7,0xcdc8,0xcdc9,0xcdca,0xcdcb,0xcdcd, /* 0xAE40-0xAE47 */
	0xcdce,0xcdcf,0xcdd1,0xcdd2,0xcdd3,0xcdd4,0xcdd5,0xcdd6, /* 0xAE48-0xAE4F */
	0xcdd7,0xcdd8,0xcdd9,0xcdda,0xcddb,0xcddc,0xcddd,0xcdde, /* 0xAE50-0xAE57 */
	0xcddf,0xcde0,0xcde1,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAE58-0xAE5F */
	0x0000,0xcde2,0xcde3,0xcde4,0xcde5,0xcde6,0xcde7,0xcde9, /* 0xAE60-0xAE67 */
	0xcdea,0xcdeb,0xcded,0xcdee,0xcdef,0xcdf1,0xcdf2,0xcdf3, /* 0xAE68-0xAE6F */
	0xcdf4,0xcdf5,0xcdf6,0xcdf7,0xcdfa,0xcdfc,0xcdfe,0xcdff, /* 0xAE70-0xAE77 */
	0xce00,0xce01,0xce02,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAE78-0xAE7F */
	/* codebase=0xae80 rawbase=0x2240 */
	0x0000,0xce03,0xce05,0xce06,0xce07,0xce09,0xce0a,0xce0b, /* 0xAE80-0xAE87 */
	0xce0d,0xce0e,0xce0f,0xce10,0xce11,0xce12,0xce13,0xce15, /* 0xAE88-0xAE8F */
	0xce16,0xce17,0xce18,0xce1a,0xce1b,0xce1c,0xce1d,0xce1e, /* 0xAE90-0xAE97 */
	0xce1f,0xce22,0xce23,0xce25,0xce26,0xce27,0xce29,0xce2a, /* 0xAE98-0xAE9F */
	0xce2b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEA0-0xAEA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEA8-0xAEAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEB0-0xAEB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAEB8-0xAEBF */
	/* codebase=0xaf40 rawbase=0x2280 */
	0x0000,0xce2c,0xce2d,0xce2e,0xce2f,0xce32,0xce34,0xce36, /* 0xAF40-0xAF47 */
	0xce37,0xce38,0xce39,0xce3a,0xce3b,0xce3c,0xce3d,0xce3e, /* 0xAF48-0xAF4F */
	0xce3f,0xce40,0xce41,0xce42,0xce43,0xce44,0xce45,0xce46, /* 0xAF50-0xAF57 */
	0xce47,0xce48,0xce49,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAF58-0xAF5F */
	0x0000,0xce4a,0xce4b,0xce4c,0xce4d,0xce4e,0xce4f,0xce50, /* 0xAF60-0xAF67 */
	0xce51,0xce52,0xce53,0xce54,0xce55,0xce56,0xce57,0xce5a, /* 0xAF68-0xAF6F */
	0xce5b,0xce5d,0xce5e,0xce62,0xce63,0xce64,0xce65,0xce66, /* 0xAF70-0xAF77 */
	0xce67,0xce6a,0xce6c,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAF78-0xAF7F */
	/* codebase=0xaf80 rawbase=0x22c0 */
	0x0000,0xce6e,0xce6f,0xce70,0xce71,0xce72,0xce73,0xce76, /* 0xAF80-0xAF87 */
	0xce77,0xce79,0xce7a,0xce7b,0xce7d,0xce7e,0xce7f,0xce80, /* 0xAF88-0xAF8F */
	0xce81,0xce82,0xce83,0xce86,0xce88,0xce8a,0xce8b,0xce8c, /* 0xAF90-0xAF97 */
	0xce8d,0xce8e,0xce8f,0xce92,0xce93,0xce95,0xce96,0xce97, /* 0xAF98-0xAF9F */
	0xce99,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFA0-0xAFA7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFA8-0xAFAF */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFB0-0xAFB7 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xAFB8-0xAFBF */
	/* codebase=0xb040 rawbase=0x2300 */
	0x0000,0xce9a,0xce9b,0xce9c,0xce9d,0xce9e,0xce9f,0xcea2, /* 0xB040-0xB047 */
	0xcea6,0xcea7,0xcea8,0xcea9,0xceaa,0xceab,0xceae,0xceaf, /* 0xB048-0xB04F */
	0xceb0,0xceb1,0xceb2,0xceb3,0xceb4,0xceb5,0xceb6,0xceb7, /* 0xB050-0xB057 */
	0xceb8,0xceb9,0xceba,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB058-0xB05F */
	0x0000,0xcebb,0xcebc,0xcebd,0xcebe,0xcebf,0xcec0,0xcec2, /* 0xB060-0xB067 */
	0xcec3,0xcec4,0xcec5,0xcec6,0xcec7,0xcec8,0xcec9,0xceca, /* 0xB068-0xB06F */
	0xcecb,0xcecc,0xcecd,0xcece,0xcecf,0xced0,0xced1,0xced2, /* 0xB070-0xB077 */
	0xced3,0xced4,0xced5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB078-0xB07F */
	/* codebase=0xb080 rawbase=0x2340 */
	0x0000,0xced6,0xced7,0xced8,0xced9,0xceda,0xcedb,0xcedc, /* 0xB080-0xB087 */
	0xcedd,0xcede,0xcedf,0xcee0,0xcee1,0xcee2,0xcee3,0xcee6, /* 0xB088-0xB08F */
	0xcee7,0xcee9,0xceea,0xceed,0xceee,0xceef,0xcef0,0xcef1, /* 0xB090-0xB097 */
	0xcef2,0xcef3,0xcef6,0xcefa,0xcefb,0xcefc,0xcefd,0xcefe, /* 0xB098-0xB09F */
	0xceff,0xac00,0xac01,0xac04,0xac07,0xac08,0xac09,0xac0a, /* 0xB0A0-0xB0A7 */
	0xac10,0xac11,0xac12,0xac13,0xac14,0xac15,0xac16,0xac17, /* 0xB0A8-0xB0AF */
	0xac19,0xac1a,0xac1b,0xac1c,0xac1d,0xac20,0xac24,0xac2c, /* 0xB0B0-0xB0B7 */
	0xac2d,0xac2f,0xac30,0xac31,0xac38,0xac39,0xac3c,0xac40, /* 0xB0B8-0xB0BF */
	/* codebase=0xb0c0 rawbase=0x2380 */
	0xac4b,0xac4d,0xac54,0xac58,0xac5c,0xac70,0xac71,0xac74, /* 0xB0C0-0xB0C7 */
	0xac77,0xac78,0xac7a,0xac80,0xac81,0xac83,0xac84,0xac85, /* 0xB0C8-0xB0CF */
	0xac86,0xac89,0xac8a,0xac8b,0xac8c,0xac90,0xac94,0xac9c, /* 0xB0D0-0xB0D7 */
	0xac9d,0xac9f,0xaca0,0xaca1,0xaca8,0xaca9,0xacaa,0xacac, /* 0xB0D8-0xB0DF */
	0xacaf,0xacb0,0xacb8,0xacb9,0xacbb,0xacbc,0xacbd,0xacc1, /* 0xB0E0-0xB0E7 */
	0xacc4,0xacc8,0xaccc,0xacd5,0xacd7,0xace0,0xace1,0xace4, /* 0xB0E8-0xB0EF */
	0xace7,0xace8,0xacea,0xacec,0xacef,0xacf0,0xacf1,0xacf3, /* 0xB0F0-0xB0F7 */
	0xacf5,0xacf6,0xacfc,0xacfd,0xad00,0xad04,0xad06,0x0000, /* 0xB0F8-0xB0FF */
	/* codebase=0xb140 rawbase=0x23c0 */
	0x0000,0xcf02,0xcf03,0xcf05,0xcf06,0xcf07,0xcf09,0xcf0a, /* 0xB140-0xB147 */
	0xcf0b,0xcf0c,0xcf0d,0xcf0e,0xcf0f,0xcf12,0xcf14,0xcf16, /* 0xB148-0xB14F */
	0xcf17,0xcf18,0xcf19,0xcf1a,0xcf1b,0xcf1d,0xcf1e,0xcf1f, /* 0xB150-0xB157 */
	0xcf21,0xcf22,0xcf23,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB158-0xB15F */
	0x0000,0xcf25,0xcf26,0xcf27,0xcf28,0xcf29,0xcf2a,0xcf2b, /* 0xB160-0xB167 */
	0xcf2e,0xcf32,0xcf33,0xcf34,0xcf35,0xcf36,0xcf37,0xcf39, /* 0xB168-0xB16F */
	0xcf3a,0xcf3b,0xcf3c,0xcf3d,0xcf3e,0xcf3f,0xcf40,0xcf41, /* 0xB170-0xB177 */
	0xcf42,0xcf43,0xcf44,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB178-0xB17F */
	/* codebase=0xb180 rawbase=0x2400 */
	0x0000,0xcf45,0xcf46,0xcf47,0xcf48,0xcf49,0xcf4a,0xcf4b, /* 0xB180-0xB187 */
	0xcf4c,0xcf4d,0xcf4e,0xcf4f,0xcf50,0xcf51,0xcf52,0xcf53, /* 0xB188-0xB18F */
	0xcf56,0xcf57,0xcf59,0xcf5a,0xcf5b,0xcf5d,0xcf5e,0xcf5f, /* 0xB190-0xB197 */
	0xcf60,0xcf61,0xcf62,0xcf63,0xcf66,0xcf68,0xcf6a,0xcf6b, /* 0xB198-0xB19F */
	0xcf6c,0xad0c,0xad0d,0xad0f,0xad11,0xad18,0xad1c,0xad20, /* 0xB1A0-0xB1A7 */
	0xad29,0xad2c,0xad2d,0xad34,0xad35,0xad38,0xad3c,0xad44, /* 0xB1A8-0xB1AF */
	0xad45,0xad47,0xad49,0xad50,0xad54,0xad58,0xad61,0xad63, /* 0xB1B0-0xB1B7 */
	0xad6c,0xad6d,0xad70,0xad73,0xad74,0xad75,0xad76,0xad7b, /* 0xB1B8-0xB1BF */
	/* codebase=0xb1c0 rawbase=0x2440 */
	0xad7c,0xad7d,0xad7f,0xad81,0xad82,0xad88,0xad89,0xad8c, /* 0xB1C0-0xB1C7 */
	0xad90,0xad9c,0xad9d,0xada4,0xadb7,0xadc0,0xadc1,0xadc4, /* 0xB1C8-0xB1CF */
	0xadc8,0xadd0,0xadd1,0xadd3,0xaddc,0xade0,0xade4,0xadf8, /* 0xB1D0-0xB1D7 */
	0xadf9,0xadfc,0xadff,0xae00,0xae01,0xae08,0xae09,0xae0b, /* 0xB1D8-0xB1DF */
	0xae0d,0xae14,0xae30,0xae31,0xae34,0xae37,0xae38,0xae3a, /* 0xB1E0-0xB1E7 */
	0xae40,0xae41,0xae43,0xae45,0xae46,0xae4a,0xae4c,0xae4d, /* 0xB1E8-0xB1EF */
	0xae4e,0xae50,0xae54,0xae56,0xae5c,0xae5d,0xae5f,0xae60, /* 0xB1F0-0xB1F7 */
	0xae61,0xae65,0xae68,0xae69,0xae6c,0xae70,0xae78,0x0000, /* 0xB1F8-0xB1FF */
	/* codebase=0xb240 rawbase=0x2480 */
	0x0000,0xcf6d,0xcf6e,0xcf6f,0xcf72,0xcf73,0xcf75,0xcf76, /* 0xB240-0xB247 */
	0xcf77,0xcf79,0xcf7a,0xcf7b,0xcf7c,0xcf7d,0xcf7e,0xcf7f, /* 0xB248-0xB24F */
	0xcf81,0xcf82,0xcf83,0xcf84,0xcf86,0xcf87,0xcf88,0xcf89, /* 0xB250-0xB257 */
	0xcf8a,0xcf8b,0xcf8d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB258-0xB25F */
	0x0000,0xcf8e,0xcf8f,0xcf90,0xcf91,0xcf92,0xcf93,0xcf94, /* 0xB260-0xB267 */
	0xcf95,0xcf96,0xcf97,0xcf98,0xcf99,0xcf9a,0xcf9b,0xcf9c, /* 0xB268-0xB26F */
	0xcf9d,0xcf9e,0xcf9f,0xcfa0,0xcfa2,0xcfa3,0xcfa4,0xcfa5, /* 0xB270-0xB277 */
	0xcfa6,0xcfa7,0xcfa9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB278-0xB27F */
	/* codebase=0xb280 rawbase=0x24c0 */
	0x0000,0xcfaa,0xcfab,0xcfac,0xcfad,0xcfae,0xcfaf,0xcfb1, /* 0xB280-0xB287 */
	0xcfb2,0xcfb3,0xcfb4,0xcfb5,0xcfb6,0xcfb7,0xcfb8,0xcfb9, /* 0xB288-0xB28F */
	0xcfba,0xcfbb,0xcfbc,0xcfbd,0xcfbe,0xcfbf,0xcfc0,0xcfc1, /* 0xB290-0xB297 */
	0xcfc2,0xcfc3,0xcfc5,0xcfc6,0xcfc7,0xcfc8,0xcfc9,0xcfca, /* 0xB298-0xB29F */
	0xcfcb,0xae79,0xae7b,0xae7c,0xae7d,0xae84,0xae85,0xae8c, /* 0xB2A0-0xB2A7 */
	0xaebc,0xaebd,0xaebe,0xaec0,0xaec4,0xaecc,0xaecd,0xaecf, /* 0xB2A8-0xB2AF */
	0xaed0,0xaed1,0xaed8,0xaed9,0xaedc,0xaee8,0xaeeb,0xaeed, /* 0xB2B0-0xB2B7 */
	0xaef4,0xaef8,0xaefc,0xaf07,0xaf08,0xaf0d,0xaf10,0xaf2c, /* 0xB2B8-0xB2BF */
	/* codebase=0xb2c0 rawbase=0x2500 */
	0xaf2d,0xaf30,0xaf32,0xaf34,0xaf3c,0xaf3d,0xaf3f,0xaf41, /* 0xB2C0-0xB2C7 */
	0xaf42,0xaf43,0xaf48,0xaf49,0xaf50,0xaf5c,0xaf5d,0xaf64, /* 0xB2C8-0xB2CF */
	0xaf65,0xaf79,0xaf80,0xaf84,0xaf88,0xaf90,0xaf91,0xaf95, /* 0xB2D0-0xB2D7 */
	0xaf9c,0xafb8,0xafb9,0xafbc,0xafc0,0xafc7,0xafc8,0xafc9, /* 0xB2D8-0xB2DF */
	0xafcb,0xafcd,0xafce,0xafd4,0xafdc,0xafe8,0xafe9,0xaff0, /* 0xB2E0-0xB2E7 */
	0xaff1,0xaff4,0xaff8,0xb000,0xb001,0xb004,0xb00c,0xb010, /* 0xB2E8-0xB2EF */
	0xb014,0xb01c,0xb01d,0xb028,0xb044,0xb045,0xb048,0xb04a, /* 0xB2F0-0xB2F7 */
	0xb04c,0xb04e,0xb053,0xb054,0xb055,0xb057,0xb059,0x0000, /* 0xB2F8-0xB2FF */
	/* codebase=0xb340 rawbase=0x2540 */
	0x0000,0xcfcc,0xcfcd,0xcfce,0xcfcf,0xcfd0,0xcfd1,0xcfd2, /* 0xB340-0xB347 */
	0xcfd3,0xcfd4,0xcfd5,0xcfd6,0xcfd7,0xcfd8,0xcfd9,0xcfda, /* 0xB348-0xB34F */
	0xcfdb,0xcfdc,0xcfdd,0xcfde,0xcfdf,0xcfe2,0xcfe3,0xcfe5, /* 0xB350-0xB357 */
	0xcfe6,0xcfe7,0xcfe9,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB358-0xB35F */
	0x0000,0xcfea,0xcfeb,0xcfec,0xcfed,0xcfee,0xcfef,0xcff2, /* 0xB360-0xB367 */
	0xcff4,0xcff6,0xcff7,0xcff8,0xcff9,0xcffa,0xcffb,0xcffd, /* 0xB368-0xB36F */
	0xcffe,0xcfff,0xd001,0xd002,0xd003,0xd005,0xd006,0xd007, /* 0xB370-0xB377 */
	0xd008,0xd009,0xd00a,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB378-0xB37F */
	/* codebase=0xb380 rawbase=0x2580 */
	0x0000,0xd00b,0xd00c,0xd00d,0xd00e,0xd00f,0xd010,0xd012, /* 0xB380-0xB387 */
	0xd013,0xd014,0xd015,0xd016,0xd017,0xd019,0xd01a,0xd01b, /* 0xB388-0xB38F */
	0xd01c,0xd01d,0xd01e,0xd01f,0xd020,0xd021,0xd022,0xd023, /* 0xB390-0xB397 */
	0xd024,0xd025,0xd026,0xd027,0xd028,0xd029,0xd02a,0xd02b, /* 0xB398-0xB39F */
	0xd02c,0xb05d,0xb07c,0xb07d,0xb080,0xb084,0xb08c,0xb08d, /* 0xB3A0-0xB3A7 */
	0xb08f,0xb091,0xb098,0xb099,0xb09a,0xb09c,0xb09f,0xb0a0, /* 0xB3A8-0xB3AF */
	0xb0a1,0xb0a2,0xb0a8,0xb0a9,0xb0ab,0xb0ac,0xb0ad,0xb0ae, /* 0xB3B0-0xB3B7 */
	0xb0af,0xb0b1,0xb0b3,0xb0b4,0xb0b5,0xb0b8,0xb0bc,0xb0c4, /* 0xB3B8-0xB3BF */
	/* codebase=0xb3c0 rawbase=0x25c0 */
	0xb0c5,0xb0c7,0xb0c8,0xb0c9,0xb0d0,0xb0d1,0xb0d4,0xb0d8, /* 0xB3C0-0xB3C7 */
	0xb0e0,0xb0e5,0xb108,0xb109,0xb10b,0xb10c,0xb110,0xb112, /* 0xB3C8-0xB3CF */
	0xb113,0xb118,0xb119,0xb11b,0xb11c,0xb11d,0xb123,0xb124, /* 0xB3D0-0xB3D7 */
	0xb125,0xb128,0xb12c,0xb134,0xb135,0xb137,0xb138,0xb139, /* 0xB3D8-0xB3DF */
	0xb140,0xb141,0xb144,0xb148,0xb150,0xb151,0xb154,0xb155, /* 0xB3E0-0xB3E7 */
	0xb158,0xb15c,0xb160,0xb178,0xb179,0xb17c,0xb180,0xb182, /* 0xB3E8-0xB3EF */
	0xb188,0xb189,0xb18b,0xb18d,0xb192,0xb193,0xb194,0xb198, /* 0xB3F0-0xB3F7 */
	0xb19c,0xb1a8,0xb1cc,0xb1d0,0xb1d4,0xb1dc,0xb1dd,0x0000, /* 0xB3F8-0xB3FF */
	/* codebase=0xb440 rawbase=0x2600 */
	0x0000,0xd02e,0xd02f,0xd030,0xd031,0xd032,0xd033,0xd036, /* 0xB440-0xB447 */
	0xd037,0xd039,0xd03a,0xd03b,0xd03d,0xd03e,0xd03f,0xd040, /* 0xB448-0xB44F */
	0xd041,0xd042,0xd043,0xd046,0xd048,0xd04a,0xd04b,0xd04c, /* 0xB450-0xB457 */
	0xd04d,0xd04e,0xd04f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB458-0xB45F */
	0x0000,0xd051,0xd052,0xd053,0xd055,0xd056,0xd057,0xd059, /* 0xB460-0xB467 */
	0xd05a,0xd05b,0xd05c,0xd05d,0xd05e,0xd05f,0xd061,0xd062, /* 0xB468-0xB46F */
	0xd063,0xd064,0xd065,0xd066,0xd067,0xd068,0xd069,0xd06a, /* 0xB470-0xB477 */
	0xd06b,0xd06e,0xd06f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB478-0xB47F */
	/* codebase=0xb480 rawbase=0x2640 */
	0x0000,0xd071,0xd072,0xd073,0xd075,0xd076,0xd077,0xd078, /* 0xB480-0xB487 */
	0xd079,0xd07a,0xd07b,0xd07e,0xd07f,0xd080,0xd082,0xd083, /* 0xB488-0xB48F */
	0xd084,0xd085,0xd086,0xd087,0xd088,0xd089,0xd08a,0xd08b, /* 0xB490-0xB497 */
	0xd08c,0xd08d,0xd08e,0xd08f,0xd090,0xd091,0xd092,0xd093, /* 0xB498-0xB49F */
	0xd094,0xb1df,0xb1e8,0xb1e9,0xb1ec,0xb1f0,0xb1f9,0xb1fb, /* 0xB4A0-0xB4A7 */
	0xb1fd,0xb204,0xb205,0xb208,0xb20b,0xb20c,0xb214,0xb215, /* 0xB4A8-0xB4AF */
	0xb217,0xb219,0xb220,0xb234,0xb23c,0xb258,0xb25c,0xb260, /* 0xB4B0-0xB4B7 */
	0xb268,0xb269,0xb274,0xb275,0xb27c,0xb284,0xb285,0xb289, /* 0xB4B8-0xB4BF */
	/* codebase=0xb4c0 rawbase=0x2680 */
	0xb290,0xb291,0xb294,0xb298,0xb299,0xb29a,0xb2a0,0xb2a1, /* 0xB4C0-0xB4C7 */
	0xb2a3,0xb2a5,0xb2a6,0xb2aa,0xb2ac,0xb2b0,0xb2b4,0xb2c8, /* 0xB4C8-0xB4CF */
	0xb2c9,0xb2cc,0xb2d0,0xb2d2,0xb2d8,0xb2d9,0xb2db,0xb2dd, /* 0xB4D0-0xB4D7 */
	0xb2e2,0xb2e4,0xb2e5,0xb2e6,0xb2e8,0xb2eb,0xb2ec,0xb2ed, /* 0xB4D8-0xB4DF */
	0xb2ee,0xb2ef,0xb2f3,0xb2f4,0xb2f5,0xb2f7,0xb2f8,0xb2f9, /* 0xB4E0-0xB4E7 */
	0xb2fa,0xb2fb,0xb2ff,0xb300,0xb301,0xb304,0xb308,0xb310, /* 0xB4E8-0xB4EF */
	0xb311,0xb313,0xb314,0xb315,0xb31c,0xb354,0xb355,0xb356, /* 0xB4F0-0xB4F7 */
	0xb358,0xb35b,0xb35c,0xb35e,0xb35f,0xb364,0xb365,0x0000, /* 0xB4F8-0xB4FF */
	/* codebase=0xb540 rawbase=0x26c0 */
	0x0000,0xd095,0xd096,0xd097,0xd098,0xd099,0xd09a,0xd09b, /* 0xB540-0xB547 */
	0xd09c,0xd09d,0xd09e,0xd09f,0xd0a0,0xd0a1,0xd0a2,0xd0a3, /* 0xB548-0xB54F */
	0xd0a6,0xd0a7,0xd0a9,0xd0aa,0xd0ab,0xd0ad,0xd0ae,0xd0af, /* 0xB550-0xB557 */
	0xd0b0,0xd0b1,0xd0b2,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB558-0xB55F */
	0x0000,0xd0b3,0xd0b6,0xd0b8,0xd0ba,0xd0bb,0xd0bc,0xd0bd, /* 0xB560-0xB567 */
	0xd0be,0xd0bf,0xd0c2,0xd0c3,0xd0c5,0xd0c6,0xd0c7,0xd0ca, /* 0xB568-0xB56F */
	0xd0cb,0xd0cc,0xd0cd,0xd0ce,0xd0cf,0xd0d2,0xd0d6,0xd0d7, /* 0xB570-0xB577 */
	0xd0d8,0xd0d9,0xd0da,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB578-0xB57F */
	/* codebase=0xb580 rawbase=0x2700 */
	0x0000,0xd0db,0xd0de,0xd0df,0xd0e1,0xd0e2,0xd0e3,0xd0e5, /* 0xB580-0xB587 */
	0xd0e6,0xd0e7,0xd0e8,0xd0e9,0xd0ea,0xd0eb,0xd0ee,0xd0f2, /* 0xB588-0xB58F */
	0xd0f3,0xd0f4,0xd0f5,0xd0f6,0xd0f7,0xd0f9,0xd0fa,0xd0fb, /* 0xB590-0xB597 */
	0xd0fc,0xd0fd,0xd0fe,0xd0ff,0xd100,0xd101,0xd102,0xd103, /* 0xB598-0xB59F */
	0xd104,0xb367,0xb369,0xb36b,0xb36e,0xb370,0xb371,0xb374, /* 0xB5A0-0xB5A7 */
	0xb378,0xb380,0xb381,0xb383,0xb384,0xb385,0xb38c,0xb390, /* 0xB5A8-0xB5AF */
	0xb394,0xb3a0,0xb3a1,0xb3a8,0xb3ac,0xb3c4,0xb3c5,0xb3c8, /* 0xB5B0-0xB5B7 */
	0xb3cb,0xb3cc,0xb3ce,0xb3d0,0xb3d4,0xb3d5,0xb3d7,0xb3d9, /* 0xB5B8-0xB5BF */
	/* codebase=0xb5c0 rawbase=0x2740 */
	0xb3db,0xb3dd,0xb3e0,0xb3e4,0xb3e8,0xb3fc,0xb410,0xb418, /* 0xB5C0-0xB5C7 */
	0xb41c,0xb420,0xb428,0xb429,0xb42b,0xb434,0xb450,0xb451, /* 0xB5C8-0xB5CF */
	0xb454,0xb458,0xb460,0xb461,0xb463,0xb465,0xb46c,0xb480, /* 0xB5D0-0xB5D7 */
	0xb488,0xb49d,0xb4a4,0xb4a8,0xb4ac,0xb4b5,0xb4b7,0xb4b9, /* 0xB5D8-0xB5DF */
	0xb4c0,0xb4c4,0xb4c8,0xb4d0,0xb4d5,0xb4dc,0xb4dd,0xb4e0, /* 0xB5E0-0xB5E7 */
	0xb4e3,0xb4e4,0xb4e6,0xb4ec,0xb4ed,0xb4ef,0xb4f1,0xb4f8, /* 0xB5E8-0xB5EF */
	0xb514,0xb515,0xb518,0xb51b,0xb51c,0xb524,0xb525,0xb527, /* 0xB5F0-0xB5F7 */
	0xb528,0xb529,0xb52a,0xb530,0xb531,0xb534,0xb538,0x0000, /* 0xB5F8-0xB5FF */
	/* codebase=0xb640 rawbase=0x2780 */
	0x0000,0xd105,0xd106,0xd107,0xd108,0xd109,0xd10a,0xd10b, /* 0xB640-0xB647 */
	0xd10c,0xd10e,0xd10f,0xd110,0xd111,0xd112,0xd113,0xd114, /* 0xB648-0xB64F */
	0xd115,0xd116,0xd117,0xd118,0xd119,0xd11a,0xd11b,0xd11c, /* 0xB650-0xB657 */
	0xd11d,0xd11e,0xd11f,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB658-0xB65F */
	0x0000,0xd120,0xd121,0xd122,0xd123,0xd124,0xd125,0xd126, /* 0xB660-0xB667 */
	0xd127,0xd128,0xd129,0xd12a,0xd12b,0xd12c,0xd12d,0xd12e, /* 0xB668-0xB66F */
	0xd12f,0xd132,0xd133,0xd135,0xd136,0xd137,0xd139,0xd13b, /* 0xB670-0xB677 */
	0xd13c,0xd13d,0xd13e,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB678-0xB67F */
	/* codebase=0xb680 rawbase=0x27c0 */
	0x0000,0xd13f,0xd142,0xd146,0xd147,0xd148,0xd149,0xd14a, /* 0xB680-0xB687 */
	0xd14b,0xd14e,0xd14f,0xd151,0xd152,0xd153,0xd155,0xd156, /* 0xB688-0xB68F */
	0xd157,0xd158,0xd159,0xd15a,0xd15b,0xd15e,0xd160,0xd162, /* 0xB690-0xB697 */
	0xd163,0xd164,0xd165,0xd166,0xd167,0xd169,0xd16a,0xd16b, /* 0xB698-0xB69F */
	0xd16d,0xb540,0xb541,0xb543,0xb544,0xb545,0xb54b,0xb54c, /* 0xB6A0-0xB6A7 */
	0xb54d,0xb550,0xb554,0xb55c,0xb55d,0xb55f,0xb560,0xb561, /* 0xB6A8-0xB6AF */
	0xb5a0,0xb5a1,0xb5a4,0xb5a8,0xb5aa,0xb5ab,0xb5b0,0xb5b1, /* 0xB6B0-0xB6B7 */
	0xb5b3,0xb5b4,0xb5b5,0xb5bb,0xb5bc,0xb5bd,0xb5c0,0xb5c4, /* 0xB6B8-0xB6BF */
	/* codebase=0xb6c0 rawbase=0x2800 */
	0xb5cc,0xb5cd,0xb5cf,0xb5d0,0xb5d1,0xb5d8,0xb5ec,0xb610, /* 0xB6C0-0xB6C7 */
	0xb611,0xb614,0xb618,0xb625,0xb62c,0xb634,0xb648,0xb664, /* 0xB6C8-0xB6CF */
	0xb668,0xb69c,0xb69d,0xb6a0,0xb6a4,0xb6ab,0xb6ac,0xb6b1, /* 0xB6D0-0xB6D7 */
	0xb6d4,0xb6f0,0xb6f4,0xb6f8,0xb700,0xb701,0xb705,0xb728, /* 0xB6D8-0xB6DF */
	0xb729,0xb72c,0xb72f,0xb730,0xb738,0xb739,0xb73b,0xb744, /* 0xB6E0-0xB6E7 */
	0xb748,0xb74c,0xb754,0xb755,0xb760,0xb764,0xb768,0xb770, /* 0xB6E8-0xB6EF */
	0xb771,0xb773,0xb775,0xb77c,0xb77d,0xb780,0xb784,0xb78c, /* 0xB6F0-0xB6F7 */
	0xb78d,0xb78f,0xb790,0xb791,0xb792,0xb796,0xb797,0x0000, /* 0xB6F8-0xB6FF */
	/* codebase=0xb740 rawbase=0x2840 */
	0x0000,0xd16e,0xd16f,0xd170,0xd171,0xd172,0xd173,0xd174, /* 0xB740-0xB747 */
	0xd175,0xd176,0xd177,0xd178,0xd179,0xd17a,0xd17b,0xd17d, /* 0xB748-0xB74F */
	0xd17e,0xd17f,0xd180,0xd181,0xd182,0xd183,0xd185,0xd186, /* 0xB750-0xB757 */
	0xd187,0xd189,0xd18a,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB758-0xB75F */
	0x0000,0xd18b,0xd18c,0xd18d,0xd18e,0xd18f,0xd190,0xd191, /* 0xB760-0xB767 */
	0xd192,0xd193,0xd194,0xd195,0xd196,0xd197,0xd198,0xd199, /* 0xB768-0xB76F */
	0xd19a,0xd19b,0xd19c,0xd19d,0xd19e,0xd19f,0xd1a2,0xd1a3, /* 0xB770-0xB777 */
	0xd1a5,0xd1a6,0xd1a7,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB778-0xB77F */
	/* codebase=0xb780 rawbase=0x2880 */
	0x0000,0xd1a9,0xd1aa,0xd1ab,0xd1ac,0xd1ad,0xd1ae,0xd1af, /* 0xB780-0xB787 */
	0xd1b2,0xd1b4,0xd1b6,0xd1b7,0xd1b8,0xd1b9,0xd1bb,0xd1bd, /* 0xB788-0xB78F */
	0xd1be,0xd1bf,0xd1c1,0xd1c2,0xd1c3,0xd1c4,0xd1c5,0xd1c6, /* 0xB790-0xB797 */
	0xd1c7,0xd1c8,0xd1c9,0xd1ca,0xd1cb,0xd1cc,0xd1cd,0xd1ce, /* 0xB798-0xB79F */
	0xd1cf,0xb798,0xb799,0xb79c,0xb7a0,0xb7a8,0xb7a9,0xb7ab, /* 0xB7A0-0xB7A7 */
	0xb7ac,0xb7ad,0xb7b4,0xb7b5,0xb7b8,0xb7c7,0xb7c9,0xb7ec, /* 0xB7A8-0xB7AF */
	0xb7ed,0xb7f0,0xb7f4,0xb7fc,0xb7fd,0xb7ff,0xb800,0xb801, /* 0xB7B0-0xB7B7 */
	0xb807,0xb808,0xb809,0xb80c,0xb810,0xb818,0xb819,0xb81b, /* 0xB7B8-0xB7BF */
	/* codebase=0xb7c0 rawbase=0x28c0 */
	0xb81d,0xb824,0xb825,0xb828,0xb82c,0xb834,0xb835,0xb837, /* 0xB7C0-0xB7C7 */
	0xb838,0xb839,0xb840,0xb844,0xb851,0xb853,0xb85c,0xb85d, /* 0xB7C8-0xB7CF */
	0xb860,0xb864,0xb86c,0xb86d,0xb86f,0xb871,0xb878,0xb87c, /* 0xB7D0-0xB7D7 */
	0xb88d,0xb8a8,0xb8b0,0xb8b4,0xb8b8,0xb8c0,0xb8c1,0xb8c3, /* 0xB7D8-0xB7DF */
	0xb8c5,0xb8cc,0xb8d0,0xb8d4,0xb8dd,0xb8df,0xb8e1,0xb8e8, /* 0xB7E0-0xB7E7 */
	0xb8e9,0xb8ec,0xb8f0,0xb8f8,0xb8f9,0xb8fb,0xb8fd,0xb904, /* 0xB7E8-0xB7EF */
	0xb918,0xb920,0xb93c,0xb93d,0xb940,0xb944,0xb94c,0xb94f, /* 0xB7F0-0xB7F7 */
	0xb951,0xb958,0xb959,0xb95c,0xb960,0xb968,0xb969,0x0000, /* 0xB7F8-0xB7FF */
	/* codebase=0xb840 rawbase=0x2900 */
	0x0000,0xd1d0,0xd1d1,0xd1d2,0xd1d3,0xd1d4,0xd1d5,0xd1d6, /* 0xB840-0xB847 */
	0xd1d7,0xd1d9,0xd1da,0xd1db,0xd1dc,0xd1dd,0xd1de,0xd1df, /* 0xB848-0xB84F */
	0xd1e0,0xd1e1,0xd1e2,0xd1e3,0xd1e4,0xd1e5,0xd1e6,0xd1e7, /* 0xB850-0xB857 */
	0xd1e8,0xd1e9,0xd1ea,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB858-0xB85F */
	0x0000,0xd1eb,0xd1ec,0xd1ed,0xd1ee,0xd1ef,0xd1f0,0xd1f1, /* 0xB860-0xB867 */
	0xd1f2,0xd1f3,0xd1f5,0xd1f6,0xd1f7,0xd1f9,0xd1fa,0xd1fb, /* 0xB868-0xB86F */
	0xd1fc,0xd1fd,0xd1fe,0xd1ff,0xd200,0xd201,0xd202,0xd203, /* 0xB870-0xB877 */
	0xd204,0xd205,0xd206,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB878-0xB87F */
	/* codebase=0xb880 rawbase=0x2940 */
	0x0000,0xd208,0xd20a,0xd20b,0xd20c,0xd20d,0xd20e,0xd20f, /* 0xB880-0xB887 */
	0xd211,0xd212,0xd213,0xd214,0xd215,0xd216,0xd217,0xd218, /* 0xB888-0xB88F */
	0xd219,0xd21a,0xd21b,0xd21c,0xd21d,0xd21e,0xd21f,0xd220, /* 0xB890-0xB897 */
	0xd221,0xd222,0xd223,0xd224,0xd225,0xd226,0xd227,0xd228, /* 0xB898-0xB89F */
	0xd229,0xb96b,0xb96d,0xb974,0xb975,0xb978,0xb97c,0xb984, /* 0xB8A0-0xB8A7 */
	0xb985,0xb987,0xb989,0xb98a,0xb98d,0xb98e,0xb9ac,0xb9ad, /* 0xB8A8-0xB8AF */
	0xb9b0,0xb9b4,0xb9bc,0xb9bd,0xb9bf,0xb9c1,0xb9c8,0xb9c9, /* 0xB8B0-0xB8B7 */
	0xb9cc,0xb9ce,0xb9cf,0xb9d0,0xb9d1,0xb9d2,0xb9d8,0xb9d9, /* 0xB8B8-0xB8BF */
	/* codebase=0xb8c0 rawbase=0x2980 */
	0xb9db,0xb9dd,0xb9de,0xb9e1,0xb9e3,0xb9e4,0xb9e5,0xb9e8, /* 0xB8C0-0xB8C7 */
	0xb9ec,0xb9f4,0xb9f5,0xb9f7,0xb9f8,0xb9f9,0xb9fa,0xba00, /* 0xB8C8-0xB8CF */
	0xba01,0xba08,0xba15,0xba38,0xba39,0xba3c,0xba40,0xba42, /* 0xB8D0-0xB8D7 */
	0xba48,0xba49,0xba4b,0xba4d,0xba4e,0xba53,0xba54,0xba55, /* 0xB8D8-0xB8DF */
	0xba58,0xba5c,0xba64,0xba65,0xba67,0xba68,0xba69,0xba70, /* 0xB8E0-0xB8E7 */
	0xba71,0xba74,0xba78,0xba83,0xba84,0xba85,0xba87,0xba8c, /* 0xB8E8-0xB8EF */
	0xbaa8,0xbaa9,0xbaab,0xbaac,0xbab0,0xbab2,0xbab8,0xbab9, /* 0xB8F0-0xB8F7 */
	0xbabb,0xbabd,0xbac4,0xbac8,0xbad8,0xbad9,0xbafc,0x0000, /* 0xB8F8-0xB8FF */
	/* codebase=0xb940 rawbase=0x29c0 */
	0x0000,0xd22a,0xd22b,0xd22e,0xd22f,0xd231,0xd232,0xd233, /* 0xB940-0xB947 */
	0xd235,0xd236,0xd237,0xd238,0xd239,0xd23a,0xd23b,0xd23e, /* 0xB948-0xB94F */
	0xd240,0xd242,0xd243,0xd244,0xd245,0xd246,0xd247,0xd249, /* 0xB950-0xB957 */
	0xd24a,0xd24b,0xd24c,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB958-0xB95F */
	0x0000,0xd24d,0xd24e,0xd24f,0xd250,0xd251,0xd252,0xd253, /* 0xB960-0xB967 */
	0xd254,0xd255,0xd256,0xd257,0xd258,0xd259,0xd25a,0xd25b, /* 0xB968-0xB96F */
	0xd25d,0xd25e,0xd25f,0xd260,0xd261,0xd262,0xd263,0xd265, /* 0xB970-0xB977 */
	0xd266,0xd267,0xd268,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xB978-0xB97F */
	/* codebase=0xb980 rawbase=0x2a00 */
	0x0000,0xd269,0xd26a,0xd26b,0xd26c,0xd26d,0xd26e,0xd26f, /* 0xB980-0xB987 */
	0xd270,0xd271,0xd272,0xd273,0xd274,0xd275,0xd276,0xd277, /* 0xB988-0xB98F */
	0xd278,0xd279,0xd27a,0xd27b,0xd27c,0xd27d,0xd27e,0xd27f, /* 0xB990-0xB997 */
	0xd282,0xd283,0xd285,0xd286,0xd287,0xd289,0xd28a,0xd28b, /* 0xB998-0xB99F */
	0xd28c,0xbb00,0xbb04,0xbb0d,0xbb0f,0xbb11,0xbb18,0xbb1c, /* 0xB9A0-0xB9A7 */
	0xbb20,0xbb29,0xbb2b,0xbb34,0xbb35,0xbb36,0xbb38,0xbb3b, /* 0xB9A8-0xB9AF */
	0xbb3c,0xbb3d,0xbb3e,0xbb44,0xbb45,0xbb47,0xbb49,0xbb4d, /* 0xB9B0-0xB9B7 */
	0xbb4f,0xbb50,0xbb54,0xbb58,0xbb61,0xbb63,0xbb6c,0xbb88, /* 0xB9B8-0xB9BF */
	/* codebase=0xb9c0 rawbase=0x2a40 */
	0xbb8c,0xbb90,0xbba4,0xbba8,0xbbac,0xbbb4,0xbbb7,0xbbc0, /* 0xB9C0-0xB9C7 */
	0xbbc4,0xbbc8,0xbbd0,0xbbd3,0xbbf8,0xbbf9,0xbbfc,0xbbff, /* 0xB9C8-0xB9CF */
	0xbc00,0xbc02,0xbc08,0xbc09,0xbc0b,0xbc0c,0xbc0d,0xbc0f, /* 0xB9D0-0xB9D7 */
	0xbc11,0xbc14,0xbc15,0xbc16,0xbc17,0xbc18,0xbc1b,0xbc1c, /* 0xB9D8-0xB9DF */
	0xbc1d,0xbc1e,0xbc1f,0xbc24,0xbc25,0xbc27,0xbc29,0xbc2d, /* 0xB9E0-0xB9E7 */
	0xbc30,0xbc31,0xbc34,0xbc38,0xbc40,0xbc41,0xbc43,0xbc44, /* 0xB9E8-0xB9EF */
	0xbc45,0xbc49,0xbc4c,0xbc4d,0xbc50,0xbc5d,0xbc84,0xbc85, /* 0xB9F0-0xB9F7 */
	0xbc88,0xbc8b,0xbc8c,0xbc8e,0xbc94,0xbc95,0xbc97,0x0000, /* 0xB9F8-0xB9FF */
	/* codebase=0xba40 rawbase=0x2a80 */
	0x0000,0xd28d,0xd28e,0xd28f,0xd292,0xd293,0xd294,0xd296, /* 0xBA40-0xBA47 */
	0xd297,0xd298,0xd299,0xd29a,0xd29b,0xd29d,0xd29e,0xd29f, /* 0xBA48-0xBA4F */
	0xd2a1,0xd2a2,0xd2a3,0xd2a5,0xd2a6,0xd2a7,0xd2a8,0xd2a9, /* 0xBA50-0xBA57 */
	0xd2aa,0xd2ab,0xd2ad,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBA58-0xBA5F */
	0x0000,0xd2ae,0xd2af,0xd2b0,0xd2b2,0xd2b3,0xd2b4,0xd2b5, /* 0xBA60-0xBA67 */
	0xd2b6,0xd2b7,0xd2ba,0xd2bb,0xd2bd,0xd2be,0xd2c1,0xd2c3, /* 0xBA68-0xBA6F */
	0xd2c4,0xd2c5,0xd2c6,0xd2c7,0xd2ca,0xd2cc,0xd2cd,0xd2ce, /* 0xBA70-0xBA77 */
	0xd2cf,0xd2d0,0xd2d1,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBA78-0xBA7F */
	/* codebase=0xba80 rawbase=0x2ac0 */
	0x0000,0xd2d2,0xd2d3,0xd2d5,0xd2d6,0xd2d7,0xd2d9,0xd2da, /* 0xBA80-0xBA87 */
	0xd2db,0xd2dd,0xd2de,0xd2df,0xd2e0,0xd2e1,0xd2e2,0xd2e3, /* 0xBA88-0xBA8F */
	0xd2e6,0xd2e7,0xd2e8,0xd2e9,0xd2ea,0xd2eb,0xd2ec,0xd2ed, /* 0xBA90-0xBA97 */
	0xd2ee,0xd2ef,0xd2f2,0xd2f3,0xd2f5,0xd2f6,0xd2f7,0xd2f9, /* 0xBA98-0xBA9F */
	0xd2fa,0xbc99,0xbc9a,0xbca0,0xbca1,0xbca4,0xbca7,0xbca8, /* 0xBAA0-0xBAA7 */
	0xbcb0,0xbcb1,0xbcb3,0xbcb4,0xbcb5,0xbcbc,0xbcbd,0xbcc0, /* 0xBAA8-0xBAAF */
	0xbcc4,0xbccd,0xbccf,0xbcd0,0xbcd1,0xbcd5,0xbcd8,0xbcdc, /* 0xBAB0-0xBAB7 */
	0xbcf4,0xbcf5,0xbcf6,0xbcf8,0xbcfc,0xbd04,0xbd05,0xbd07, /* 0xBAB8-0xBABF */
	/* codebase=0xbac0 rawbase=0x2b00 */
	0xbd09,0xbd10,0xbd14,0xbd24,0xbd2c,0xbd40,0xbd48,0xbd49, /* 0xBAC0-0xBAC7 */
	0xbd4c,0xbd50,0xbd58,0xbd59,0xbd64,0xbd68,0xbd80,0xbd81, /* 0xBAC8-0xBACF */
	0xbd84,0xbd87,0xbd88,0xbd89,0xbd8a,0xbd90,0xbd91,0xbd93, /* 0xBAD0-0xBAD7 */
	0xbd95,0xbd99,0xbd9a,0xbd9c,0xbda4,0xbdb0,0xbdb8,0xbdd4, /* 0xBAD8-0xBADF */
	0xbdd5,0xbdd8,0xbddc,0xbde9,0xbdf0,0xbdf4,0xbdf8,0xbe00, /* 0xBAE0-0xBAE7 */
	0xbe03,0xbe05,0xbe0c,0xbe0d,0xbe10,0xbe14,0xbe1c,0xbe1d, /* 0xBAE8-0xBAEF */
	0xbe1f,0xbe44,0xbe45,0xbe48,0xbe4c,0xbe4e,0xbe54,0xbe55, /* 0xBAF0-0xBAF7 */
	0xbe57,0xbe59,0xbe5a,0xbe5b,0xbe60,0xbe61,0xbe64,0x0000, /* 0xBAF8-0xBAFF */
	/* codebase=0xbb40 rawbase=0x2b40 */
	0x0000,0xd2fb,0xd2fc,0xd2fd,0xd2fe,0xd2ff,0xd302,0xd304, /* 0xBB40-0xBB47 */
	0xd306,0xd307,0xd308,0xd309,0xd30a,0xd30b,0xd30f,0xd311, /* 0xBB48-0xBB4F */
	0xd312,0xd313,0xd315,0xd317,0xd318,0xd319,0xd31a,0xd31b, /* 0xBB50-0xBB57 */
	0xd31e,0xd322,0xd323,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBB58-0xBB5F */
	0x0000,0xd324,0xd326,0xd327,0xd32a,0xd32b,0xd32d,0xd32e, /* 0xBB60-0xBB67 */
	0xd32f,0xd331,0xd332,0xd333,0xd334,0xd335,0xd336,0xd337, /* 0xBB68-0xBB6F */
	0xd33a,0xd33e,0xd33f,0xd340,0xd341,0xd342,0xd343,0xd346, /* 0xBB70-0xBB77 */
	0xd347,0xd348,0xd349,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBB78-0xBB7F */
	/* codebase=0xbb80 rawbase=0x2b80 */
	0x0000,0xd34a,0xd34b,0xd34c,0xd34d,0xd34e,0xd34f,0xd350, /* 0xBB80-0xBB87 */
	0xd351,0xd352,0xd353,0xd354,0xd355,0xd356,0xd357,0xd358, /* 0xBB88-0xBB8F */
	0xd359,0xd35a,0xd35b,0xd35c,0xd35d,0xd35e,0xd35f,0xd360, /* 0xBB90-0xBB97 */
	0xd361,0xd362,0xd363,0xd364,0xd365,0xd366,0xd367,0xd368, /* 0xBB98-0xBB9F */
	0xd369,0xbe68,0xbe6a,0xbe70,0xbe71,0xbe73,0xbe74,0xbe75, /* 0xBBA0-0xBBA7 */
	0xbe7b,0xbe7c,0xbe7d,0xbe80,0xbe84,0xbe8c,0xbe8d,0xbe8f, /* 0xBBA8-0xBBAF */
	0xbe90,0xbe91,0xbe98,0xbe99,0xbea8,0xbed0,0xbed1,0xbed4, /* 0xBBB0-0xBBB7 */
	0xbed7,0xbed8,0xbee0,0xbee3,0xbee4,0xbee5,0xbeec,0xbf01, /* 0xBBB8-0xBBBF */
	/* codebase=0xbbc0 rawbase=0x2bc0 */
	0xbf08,0xbf09,0xbf18,0xbf19,0xbf1b,0xbf1c,0xbf1d,0xbf40, /* 0xBBC0-0xBBC7 */
	0xbf41,0xbf44,0xbf48,0xbf50,0xbf51,0xbf55,0xbf94,0xbfb0, /* 0xBBC8-0xBBCF */
	0xbfc5,0xbfcc,0xbfcd,0xbfd0,0xbfd4,0xbfdc,0xbfdf,0xbfe1, /* 0xBBD0-0xBBD7 */
	0xc03c,0xc051,0xc058,0xc05c,0xc060,0xc068,0xc069,0xc090, /* 0xBBD8-0xBBDF */
	0xc091,0xc094,0xc098,0xc0a0,0xc0a1,0xc0a3,0xc0a5,0xc0ac, /* 0xBBE0-0xBBE7 */
	0xc0ad,0xc0af,0xc0b0,0xc0b3,0xc0b4,0xc0b5,0xc0b6,0xc0bc, /* 0xBBE8-0xBBEF */
	0xc0bd,0xc0bf,0xc0c0,0xc0c1,0xc0c5,0xc0c8,0xc0c9,0xc0cc, /* 0xBBF0-0xBBF7 */
	0xc0d0,0xc0d8,0xc0d9,0xc0db,0xc0dc,0xc0dd,0xc0e4,0x0000, /* 0xBBF8-0xBBFF */
	/* codebase=0xbc40 rawbase=0x2c00 */
	0x0000,0xd36a,0xd36b,0xd36c,0xd36d,0xd36e,0xd36f,0xd370, /* 0xBC40-0xBC47 */
	0xd371,0xd372,0xd373,0xd374,0xd375,0xd376,0xd377,0xd378, /* 0xBC48-0xBC4F */
	0xd379,0xd37a,0xd37b,0xd37e,0xd37f,0xd381,0xd382,0xd383, /* 0xBC50-0xBC57 */
	0xd385,0xd386,0xd387,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBC58-0xBC5F */
	0x0000,0xd388,0xd389,0xd38a,0xd38b,0xd38e,0xd392,0xd393, /* 0xBC60-0xBC67 */
	0xd394,0xd395,0xd396,0xd397,0xd39a,0xd39b,0xd39d,0xd39e, /* 0xBC68-0xBC6F */
	0xd39f,0xd3a1,0xd3a2,0xd3a3,0xd3a4,0xd3a5,0xd3a6,0xd3a7, /* 0xBC70-0xBC77 */
	0xd3aa,0xd3ac,0xd3ae,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBC78-0xBC7F */
	/* codebase=0xbc80 rawbase=0x2c40 */
	0x0000,0xd3af,0xd3b0,0xd3b1,0xd3b2,0xd3b3,0xd3b5,0xd3b6, /* 0xBC80-0xBC87 */
	0xd3b7,0xd3b9,0xd3ba,0xd3bb,0xd3bd,0xd3be,0xd3bf,0xd3c0, /* 0xBC88-0xBC8F */
	0xd3c1,0xd3c2,0xd3c3,0xd3c6,0xd3c7,0xd3ca,0xd3cb,0xd3cc, /* 0xBC90-0xBC97 */
	0xd3cd,0xd3ce,0xd3cf,0xd3d1,0xd3d2,0xd3d3,0xd3d4,0xd3d5, /* 0xBC98-0xBC9F */
	0xd3d6,0xc0e5,0xc0e8,0xc0ec,0xc0f4,0xc0f5,0xc0f7,0xc0f9, /* 0xBCA0-0xBCA7 */
	0xc100,0xc104,0xc108,0xc110,0xc115,0xc11c,0xc11d,0xc11e, /* 0xBCA8-0xBCAF */
	0xc11f,0xc120,0xc123,0xc124,0xc126,0xc127,0xc12c,0xc12d, /* 0xBCB0-0xBCB7 */
	0xc12f,0xc130,0xc131,0xc136,0xc138,0xc139,0xc13c,0xc140, /* 0xBCB8-0xBCBF */
	/* codebase=0xbcc0 rawbase=0x2c80 */
	0xc148,0xc149,0xc14b,0xc14c,0xc14d,0xc154,0xc155,0xc158, /* 0xBCC0-0xBCC7 */
	0xc15c,0xc164,0xc165,0xc167,0xc168,0xc169,0xc170,0xc174, /* 0xBCC8-0xBCCF */
	0xc178,0xc185,0xc18c,0xc18d,0xc18e,0xc190,0xc194,0xc196, /* 0xBCD0-0xBCD7 */
	0xc19c,0xc19d,0xc19f,0xc1a1,0xc1a5,0xc1a8,0xc1a9,0xc1ac, /* 0xBCD8-0xBCDF */
	0xc1b0,0xc1bd,0xc1c4,0xc1c8,0xc1cc,0xc1d4,0xc1d7,0xc1d8, /* 0xBCE0-0xBCE7 */
	0xc1e0,0xc1e4,0xc1e8,0xc1f0,0xc1f1,0xc1f3,0xc1fc,0xc1fd, /* 0xBCE8-0xBCEF */
	0xc200,0xc204,0xc20c,0xc20d,0xc20f,0xc211,0xc218,0xc219, /* 0xBCF0-0xBCF7 */
	0xc21c,0xc21f,0xc220,0xc228,0xc229,0xc22b,0xc22d,0x0000, /* 0xBCF8-0xBCFF */
	/* codebase=0xbd40 rawbase=0x2cc0 */
	0x0000,0xd3d7,0xd3d9,0xd3da,0xd3db,0xd3dc,0xd3dd,0xd3de, /* 0xBD40-0xBD47 */
	0xd3df,0xd3e0,0xd3e2,0xd3e4,0xd3e5,0xd3e6,0xd3e7,0xd3e8, /* 0xBD48-0xBD4F */
	0xd3e9,0xd3ea,0xd3eb,0xd3ee,0xd3ef,0xd3f1,0xd3f2,0xd3f3, /* 0xBD50-0xBD57 */
	0xd3f5,0xd3f6,0xd3f7,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBD58-0xBD5F */
	0x0000,0xd3f8,0xd3f9,0xd3fa,0xd3fb,0xd3fe,0xd400,0xd402, /* 0xBD60-0xBD67 */
	0xd403,0xd404,0xd405,0xd406,0xd407,0xd409,0xd40a,0xd40b, /* 0xBD68-0xBD6F */
	0xd40c,0xd40d,0xd40e,0xd40f,0xd410,0xd411,0xd412,0xd413, /* 0xBD70-0xBD77 */
	0xd414,0xd415,0xd416,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBD78-0xBD7F */
	/* codebase=0xbd80 rawbase=0x2d00 */
	0x0000,0xd417,0xd418,0xd419,0xd41a,0xd41b,0xd41c,0xd41e, /* 0xBD80-0xBD87 */
	0xd41f,0xd420,0xd421,0xd422,0xd423,0xd424,0xd425,0xd426, /* 0xBD88-0xBD8F */
	0xd427,0xd428,0xd429,0xd42a,0xd42b,0xd42c,0xd42d,0xd42e, /* 0xBD90-0xBD97 */
	0xd42f,0xd430,0xd431,0xd432,0xd433,0xd434,0xd435,0xd436, /* 0xBD98-0xBD9F */
	0xd437,0xc22f,0xc231,0xc232,0xc234,0xc248,0xc250,0xc251, /* 0xBDA0-0xBDA7 */
	0xc254,0xc258,0xc260,0xc265,0xc26c,0xc26d,0xc270,0xc274, /* 0xBDA8-0xBDAF */
	0xc27c,0xc27d,0xc27f,0xc281,0xc288,0xc289,0xc290,0xc298, /* 0xBDB0-0xBDB7 */
	0xc29b,0xc29d,0xc2a4,0xc2a5,0xc2a8,0xc2ac,0xc2ad,0xc2b4, /* 0xBDB8-0xBDBF */
	/* codebase=0xbdc0 rawbase=0x2d40 */
	0xc2b5,0xc2b7,0xc2b9,0xc2dc,0xc2dd,0xc2e0,0xc2e3,0xc2e4, /* 0xBDC0-0xBDC7 */
	0xc2eb,0xc2ec,0xc2ed,0xc2ef,0xc2f1,0xc2f6,0xc2f8,0xc2f9, /* 0xBDC8-0xBDCF */
	0xc2fb,0xc2fc,0xc300,0xc308,0xc309,0xc30c,0xc30d,0xc313, /* 0xBDD0-0xBDD7 */
	0xc314,0xc315,0xc318,0xc31c,0xc324,0xc325,0xc328,0xc329, /* 0xBDD8-0xBDDF */
	0xc345,0xc368,0xc369,0xc36c,0xc370,0xc372,0xc378,0xc379, /* 0xBDE0-0xBDE7 */
	0xc37c,0xc37d,0xc384,0xc388,0xc38c,0xc3c0,0xc3d8,0xc3d9, /* 0xBDE8-0xBDEF */
	0xc3dc,0xc3df,0xc3e0,0xc3e2,0xc3e8,0xc3e9,0xc3ed,0xc3f4, /* 0xBDF0-0xBDF7 */
	0xc3f5,0xc3f8,0xc408,0xc410,0xc424,0xc42c,0xc430,0x0000, /* 0xBDF8-0xBDFF */
	/* codebase=0xbe40 rawbase=0x2d80 */
	0x0000,0xd438,0xd439,0xd43a,0xd43b,0xd43c,0xd43d,0xd43e, /* 0xBE40-0xBE47 */
	0xd43f,0xd441,0xd442,0xd443,0xd445,0xd446,0xd447,0xd448, /* 0xBE48-0xBE4F */
	0xd449,0xd44a,0xd44b,0xd44c,0xd44d,0xd44e,0xd44f,0xd450, /* 0xBE50-0xBE57 */
	0xd451,0xd452,0xd453,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBE58-0xBE5F */
	0x0000,0xd454,0xd455,0xd456,0xd457,0xd458,0xd459,0xd45a, /* 0xBE60-0xBE67 */
	0xd45b,0xd45d,0xd45e,0xd45f,0xd461,0xd462,0xd463,0xd465, /* 0xBE68-0xBE6F */
	0xd466,0xd467,0xd468,0xd469,0xd46a,0xd46b,0xd46c,0xd46e, /* 0xBE70-0xBE77 */
	0xd470,0xd471,0xd472,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBE78-0xBE7F */
	/* codebase=0xbe80 rawbase=0x2dc0 */
	0x0000,0xd473,0xd474,0xd475,0xd476,0xd477,0xd47a,0xd47b, /* 0xBE80-0xBE87 */
	0xd47d,0xd47e,0xd481,0xd483,0xd484,0xd485,0xd486,0xd487, /* 0xBE88-0xBE8F */
	0xd48a,0xd48c,0xd48e,0xd48f,0xd490,0xd491,0xd492,0xd493, /* 0xBE90-0xBE97 */
	0xd495,0xd496,0xd497,0xd498,0xd499,0xd49a,0xd49b,0xd49c, /* 0xBE98-0xBE9F */
	0xd49d,0xc434,0xc43c,0xc43d,0xc448,0xc464,0xc465,0xc468, /* 0xBEA0-0xBEA7 */
	0xc46c,0xc474,0xc475,0xc479,0xc480,0xc494,0xc49c,0xc4b8, /* 0xBEA8-0xBEAF */
	0xc4bc,0xc4e9,0xc4f0,0xc4f1,0xc4f4,0xc4f8,0xc4fa,0xc4ff, /* 0xBEB0-0xBEB7 */
	0xc500,0xc501,0xc50c,0xc510,0xc514,0xc51c,0xc528,0xc529, /* 0xBEB8-0xBEBF */
	/* codebase=0xbec0 rawbase=0x2e00 */
	0xc52c,0xc530,0xc538,0xc539,0xc53b,0xc53d,0xc544,0xc545, /* 0xBEC0-0xBEC7 */
	0xc548,0xc549,0xc54a,0xc54c,0xc54d,0xc54e,0xc553,0xc554, /* 0xBEC8-0xBECF */
	0xc555,0xc557,0xc558,0xc559,0xc55d,0xc55e,0xc560,0xc561, /* 0xBED0-0xBED7 */
	0xc564,0xc568,0xc570,0xc571,0xc573,0xc574,0xc575,0xc57c, /* 0xBED8-0xBEDF */
	0xc57d,0xc580,0xc584,0xc587,0xc58c,0xc58d,0xc58f,0xc591, /* 0xBEE0-0xBEE7 */
	0xc595,0xc597,0xc598,0xc59c,0xc5a0,0xc5a9,0xc5b4,0xc5b5, /* 0xBEE8-0xBEEF */
	0xc5b8,0xc5b9,0xc5bb,0xc5bc,0xc5bd,0xc5be,0xc5c4,0xc5c5, /* 0xBEF0-0xBEF7 */
	0xc5c6,0xc5c7,0xc5c8,0xc5c9,0xc5ca,0xc5cc,0xc5ce,0x0000, /* 0xBEF8-0xBEFF */
	/* codebase=0xbf40 rawbase=0x2e40 */
	0x0000,0xd49e,0xd49f,0xd4a0,0xd4a1,0xd4a2,0xd4a3,0xd4a4, /* 0xBF40-0xBF47 */
	0xd4a5,0xd4a6,0xd4a7,0xd4a8,0xd4aa,0xd4ab,0xd4ac,0xd4ad, /* 0xBF48-0xBF4F */
	0xd4ae,0xd4af,0xd4b0,0xd4b1,0xd4b2,0xd4b3,0xd4b4,0xd4b5, /* 0xBF50-0xBF57 */
	0xd4b6,0xd4b7,0xd4b8,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBF58-0xBF5F */
	0x0000,0xd4b9,0xd4ba,0xd4bb,0xd4bc,0xd4bd,0xd4be,0xd4bf, /* 0xBF60-0xBF67 */
	0xd4c0,0xd4c1,0xd4c2,0xd4c3,0xd4c4,0xd4c5,0xd4c6,0xd4c7, /* 0xBF68-0xBF6F */
	0xd4c8,0xd4c9,0xd4ca,0xd4cb,0xd4cd,0xd4ce,0xd4cf,0xd4d1, /* 0xBF70-0xBF77 */
	0xd4d2,0xd4d3,0xd4d5,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xBF78-0xBF7F */
	/* codebase=0xbf80 rawbase=0x2e80 */
	0x0000,0xd4d6,0xd4d7,0xd4d8,0xd4d9,0xd4da,0xd4db,0xd4dd, /* 0xBF80-0xBF87 */
	0xd4de,0xd4e0,0xd4e1,0xd4e2,0xd4e3,0xd4e4,0xd4e5,0xd4e6, /* 0xBF88-0xBF8F */
	0xd4e7,0xd4e9,0xd4ea,0xd4eb,0xd4ed,0xd4ee,0xd4ef,0xd4f1, /* 0xBF90-0xBF97 */
	0xd4f2,0xd4f3,0xd4f4,0xd4f5,0xd4f6,0xd4f7,0xd4f9,0xd4fa, /* 0xBF98-0xBF9F */
	0xd4fc,0xc5d0,0xc5d1,0xc5d4,0xc5d8,0xc5e0,0xc5e1,0xc5e3, /* 0xBFA0-0xBFA7 */
	0xc5e5,0xc5ec,0xc5ed,0xc5ee,0xc5f0,0xc5f4,0xc5f6,0xc5f7, /* 0xBFA8-0xBFAF */
	0xc5fc,0xc5fd,0xc5fe,0xc5ff,0xc600,0xc601,0xc605,0xc606, /* 0xBFB0-0xBFB7 */
	0xc607,0xc608,0xc60c,0xc610,0xc618,0xc619,0xc61b,0xc61c, /* 0xBFB8-0xBFBF */
	/* codebase=0xbfc0 rawbase=0x2ec0 */
	0xc624,0xc625,0xc628,0xc62c,0xc62d,0xc62e,0xc630,0xc633, /* 0xBFC0-0xBFC7 */
	0xc634,0xc635,0xc637,0xc639,0xc63b,0xc640,0xc641,0xc644, /* 0xBFC8-0xBFCF */
	0xc648,0xc650,0xc651,0xc653,0xc654,0xc655,0xc65c,0xc65d, /* 0xBFD0-0xBFD7 */
	0xc660,0xc66c,0xc66f,0xc671,0xc678,0xc679,0xc67c,0xc680, /* 0xBFD8-0xBFDF */
	0xc688,0xc689,0xc68b,0xc68d,0xc694,0xc695,0xc698,0xc69c, /* 0xBFE0-0xBFE7 */
	0xc6a4,0xc6a5,0xc6a7,0xc6a9,0xc6b0,0xc6b1,0xc6b4,0xc6b8, /* 0xBFE8-0xBFEF */
	0xc6b9,0xc6ba,0xc6c0,0xc6c1,0xc6c3,0xc6c5,0xc6cc,0xc6cd, /* 0xBFF0-0xBFF7 */
	0xc6d0,0xc6d4,0xc6dc,0xc6dd,0xc6e0,0xc6e1,0xc6e8,0x0000, /* 0xBFF8-0xBFFF */
	/* codebase=0xc040 rawbase=0x2f00 */
	0x0000,0xd4fe,0xd4ff,0xd500,0xd501,0xd502,0xd503,0xd505, /* 0xC040-0xC047 */
	0xd506,0xd507,0xd509,0xd50a,0xd50b,0xd50d,0xd50e,0xd50f, /* 0xC048-0xC04F */
	0xd510,0xd511,0xd512,0xd513,0xd516,0xd518,0xd519,0xd51a, /* 0xC050-0xC057 */
	0xd51b,0xd51c,0xd51d,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC058-0xC05F */
	0x0000,0xd51e,0xd51f,0xd520,0xd521,0xd522,0xd523,0xd524, /* 0xC060-0xC067 */
	0xd525,0xd526,0xd527,0xd528,0xd529,0xd52a,0xd52b,0xd52c, /* 0xC068-0xC06F */
	0xd52d,0xd52e,0xd52f,0xd530,0xd531,0xd532,0xd533,0xd534, /* 0xC070-0xC077 */
	0xd535,0xd536,0xd537,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC078-0xC07F */
	/* codebase=0xc080 rawbase=0x2f40 */
	0x0000,0xd538,0xd539,0xd53a,0xd53b,0xd53e,0xd53f,0xd541, /* 0xC080-0xC087 */
	0xd542,0xd543,0xd545,0xd546,0xd547,0xd548,0xd549,0xd54a, /* 0xC088-0xC08F */
	0xd54b,0xd54e,0xd550,0xd552,0xd553,0xd554,0xd555,0xd556, /* 0xC090-0xC097 */
	0xd557,0xd55a,0xd55b,0xd55d,0xd55e,0xd55f,0xd561,0xd562, /* 0xC098-0xC09F */
	0xd563,0xc6e9,0xc6ec,0xc6f0,0xc6f8,0xc6f9,0xc6fd,0xc704, /* 0xC0A0-0xC0A7 */
	0xc705,0xc708,0xc70c,0xc714,0xc715,0xc717,0xc719,0xc720, /* 0xC0A8-0xC0AF */
	0xc721,0xc724,0xc728,0xc730,0xc731,0xc733,0xc735,0xc737, /* 0xC0B0-0xC0B7 */
	0xc73c,0xc73d,0xc740,0xc744,0xc74a,0xc74c,0xc74d,0xc74f, /* 0xC0B8-0xC0BF */
	/* codebase=0xc0c0 rawbase=0x2f80 */
	0xc751,0xc752,0xc753,0xc754,0xc755,0xc756,0xc757,0xc758, /* 0xC0C0-0xC0C7 */
	0xc75c,0xc760,0xc768,0xc76b,0xc774,0xc775,0xc778,0xc77c, /* 0xC0C8-0xC0CF */
	0xc77d,0xc77e,0xc783,0xc784,0xc785,0xc787,0xc788,0xc789, /* 0xC0D0-0xC0D7 */
	0xc78a,0xc78e,0xc790,0xc791,0xc794,0xc796,0xc797,0xc798, /* 0xC0D8-0xC0DF */
	0xc79a,0xc7a0,0xc7a1,0xc7a3,0xc7a4,0xc7a5,0xc7a6,0xc7ac, /* 0xC0E0-0xC0E7 */
	0xc7ad,0xc7b0,0xc7b4,0xc7bc,0xc7bd,0xc7bf,0xc7c0,0xc7c1, /* 0xC0E8-0xC0EF */
	0xc7c8,0xc7c9,0xc7cc,0xc7ce,0xc7d0,0xc7d8,0xc7dd,0xc7e4, /* 0xC0F0-0xC0F7 */
	0xc7e8,0xc7ec,0xc800,0xc801,0xc804,0xc808,0xc80a,0x0000, /* 0xC0F8-0xC0FF */
	/* codebase=0xc140 rawbase=0x2fc0 */
	0x0000,0xd564,0xd566,0xd567,0xd56a,0xd56c,0xd56e,0xd56f, /* 0xC140-0xC147 */
	0xd570,0xd571,0xd572,0xd573,0xd576,0xd577,0xd579,0xd57a, /* 0xC148-0xC14F */
	0xd57b,0xd57d,0xd57e,0xd57f,0xd580,0xd581,0xd582,0xd583, /* 0xC150-0xC157 */
	0xd586,0xd58a,0xd58b,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC158-0xC15F */
	0x0000,0xd58c,0xd58d,0xd58e,0xd58f,0xd591,0xd592,0xd593, /* 0xC160-0xC167 */
	0xd594,0xd595,0xd596,0xd597,0xd598,0xd599,0xd59a,0xd59b, /* 0xC168-0xC16F */
	0xd59c,0xd59d,0xd59e,0xd59f,0xd5a0,0xd5a1,0xd5a2,0xd5a3, /* 0xC170-0xC177 */
	0xd5a4,0xd5a6,0xd5a7,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC178-0xC17F */
	/* codebase=0xc180 rawbase=0x3000 */
	0x0000,0xd5a8,0xd5a9,0xd5aa,0xd5ab,0xd5ac,0xd5ad,0xd5ae, /* 0xC180-0xC187 */
	0xd5af,0xd5b0,0xd5b1,0xd5b2,0xd5b3,0xd5b4,0xd5b5,0xd5b6, /* 0xC188-0xC18F */
	0xd5b7,0xd5b8,0xd5b9,0xd5ba,0xd5bb,0xd5bc,0xd5bd,0xd5be, /* 0xC190-0xC197 */
	0xd5bf,0xd5c0,0xd5c1,0xd5c2,0xd5c3,0xd5c4,0xd5c5,0xd5c6, /* 0xC198-0xC19F */
	0xd5c7,0xc810,0xc811,0xc813,0xc815,0xc816,0xc81c,0xc81d, /* 0xC1A0-0xC1A7 */
	0xc820,0xc824,0xc82c,0xc82d,0xc82f,0xc831,0xc838,0xc83c, /* 0xC1A8-0xC1AF */
	0xc840,0xc848,0xc849,0xc84c,0xc84d,0xc854,0xc870,0xc871, /* 0xC1B0-0xC1B7 */
	0xc874,0xc878,0xc87a,0xc880,0xc881,0xc883,0xc885,0xc886, /* 0xC1B8-0xC1BF */
	/* codebase=0xc1c0 rawbase=0x3040 */
	0xc887,0xc88b,0xc88c,0xc88d,0xc894,0xc89d,0xc89f,0xc8a1, /* 0xC1C0-0xC1C7 */
	0xc8a8,0xc8bc,0xc8bd,0xc8c4,0xc8c8,0xc8cc,0xc8d4,0xc8d5, /* 0xC1C8-0xC1CF */
	0xc8d7,0xc8d9,0xc8e0,0xc8e1,0xc8e4,0xc8f5,0xc8fc,0xc8fd, /* 0xC1D0-0xC1D7 */
	0xc900,0xc904,0xc905,0xc906,0xc90c,0xc90d,0xc90f,0xc911, /* 0xC1D8-0xC1DF */
	0xc918,0xc92c,0xc934,0xc950,0xc951,0xc954,0xc958,0xc960, /* 0xC1E0-0xC1E7 */
	0xc961,0xc963,0xc96c,0xc970,0xc974,0xc97c,0xc988,0xc989, /* 0xC1E8-0xC1EF */
	0xc98c,0xc990,0xc998,0xc999,0xc99b,0xc99d,0xc9c0,0xc9c1, /* 0xC1F0-0xC1F7 */
	0xc9c4,0xc9c7,0xc9c8,0xc9ca,0xc9d0,0xc9d1,0xc9d3,0x0000, /* 0xC1F8-0xC1FF */
	/* codebase=0xc240 rawbase=0x3080 */
	0x0000,0xd5ca,0xd5cb,0xd5cd,0xd5ce,0xd5cf,0xd5d1,0xd5d3, /* 0xC240-0xC247 */
	0xd5d4,0xd5d5,0xd5d6,0xd5d7,0xd5da,0xd5dc,0xd5de,0xd5df, /* 0xC248-0xC24F */
	0xd5e0,0xd5e1,0xd5e2,0xd5e3,0xd5e6,0xd5e7,0xd5e9,0xd5ea, /* 0xC250-0xC257 */
	0xd5eb,0xd5ed,0xd5ee,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC258-0xC25F */
	0x0000,0xd5ef,0xd5f0,0xd5f1,0xd5f2,0xd5f3,0xd5f6,0xd5f8, /* 0xC260-0xC267 */
	0xd5fa,0xd5fb,0xd5fc,0xd5fd,0xd5fe,0xd5ff,0xd602,0xd603, /* 0xC268-0xC26F */
	0xd605,0xd606,0xd607,0xd609,0xd60a,0xd60b,0xd60c,0xd60d, /* 0xC270-0xC277 */
	0xd60e,0xd60f,0xd612,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC278-0xC27F */
	/* codebase=0xc280 rawbase=0x30c0 */
	0x0000,0xd616,0xd617,0xd618,0xd619,0xd61a,0xd61b,0xd61d, /* 0xC280-0xC287 */
	0xd61e,0xd61f,0xd621,0xd622,0xd623,0xd625,0xd626,0xd627, /* 0xC288-0xC28F */
	0xd628,0xd629,0xd62a,0xd62b,0xd62c,0xd62e,0xd62f,0xd630, /* 0xC290-0xC297 */
	0xd631,0xd632,0xd633,0xd634,0xd635,0xd636,0xd637,0xd63a, /* 0xC298-0xC29F */
	0xd63b,0xc9d5,0xc9d6,0xc9d9,0xc9da,0xc9dc,0xc9dd,0xc9e0, /* 0xC2A0-0xC2A7 */
	0xc9e2,0xc9e4,0xc9e7,0xc9ec,0xc9ed,0xc9ef,0xc9f0,0xc9f1, /* 0xC2A8-0xC2AF */
	0xc9f8,0xc9f9,0xc9fc,0xca00,0xca08,0xca09,0xca0b,0xca0c, /* 0xC2B0-0xC2B7 */
	0xca0d,0xca14,0xca18,0xca29,0xca4c,0xca4d,0xca50,0xca54, /* 0xC2B8-0xC2BF */
	/* codebase=0xc2c0 rawbase=0x3100 */
	0xca5c,0xca5d,0xca5f,0xca60,0xca61,0xca68,0xca7d,0xca84, /* 0xC2C0-0xC2C7 */
	0xca98,0xcabc,0xcabd,0xcac0,0xcac4,0xcacc,0xcacd,0xcacf, /* 0xC2C8-0xC2CF */
	0xcad1,0xcad3,0xcad8,0xcad9,0xcae0,0xcaec,0xcaf4,0xcb08, /* 0xC2D0-0xC2D7 */
	0xcb10,0xcb14,0xcb18,0xcb20,0xcb21,0xcb41,0xcb48,0xcb49, /* 0xC2D8-0xC2DF */
	0xcb4c,0xcb50,0xcb58,0xcb59,0xcb5d,0xcb64,0xcb78,0xcb79, /* 0xC2E0-0xC2E7 */
	0xcb9c,0xcbb8,0xcbd4,0xcbe4,0xcbe7,0xcbe9,0xcc0c,0xcc0d, /* 0xC2E8-0xC2EF */
	0xcc10,0xcc14,0xcc1c,0xcc1d,0xcc21,0xcc22,0xcc27,0xcc28, /* 0xC2F0-0xC2F7 */
	0xcc29,0xcc2c,0xcc2e,0xcc30,0xcc38,0xcc39,0xcc3b,0x0000, /* 0xC2F8-0xC2FF */
	/* codebase=0xc340 rawbase=0x3140 */
	0x0000,0xd63d,0xd63e,0xd63f,0xd641,0xd642,0xd643,0xd644, /* 0xC340-0xC347 */
	0xd646,0xd647,0xd64a,0xd64c,0xd64e,0xd64f,0xd650,0xd652, /* 0xC348-0xC34F */
	0xd653,0xd656,0xd657,0xd659,0xd65a,0xd65b,0xd65d,0xd65e, /* 0xC350-0xC357 */
	0xd65f,0xd660,0xd661,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC358-0xC35F */
	0x0000,0xd662,0xd663,0xd664,0xd665,0xd666,0xd668,0xd66a, /* 0xC360-0xC367 */
	0xd66b,0xd66c,0xd66d,0xd66e,0xd66f,0xd672,0xd673,0xd675, /* 0xC368-0xC36F */
	0xd676,0xd677,0xd678,0xd679,0xd67a,0xd67b,0xd67c,0xd67d, /* 0xC370-0xC377 */
	0xd67e,0xd67f,0xd680,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC378-0xC37F */
	/* codebase=0xc380 rawbase=0x3180 */
	0x0000,0xd681,0xd682,0xd684,0xd686,0xd687,0xd688,0xd689, /* 0xC380-0xC387 */
	0xd68a,0xd68b,0xd68e,0xd68f,0xd691,0xd692,0xd693,0xd695, /* 0xC388-0xC38F */
	0xd696,0xd697,0xd698,0xd699,0xd69a,0xd69b,0xd69c,0xd69e, /* 0xC390-0xC397 */
	0xd6a0,0xd6a2,0xd6a3,0xd6a4,0xd6a5,0xd6a6,0xd6a7,0xd6a9, /* 0xC398-0xC39F */
	0xd6aa,0xcc3c,0xcc3d,0xcc3e,0xcc44,0xcc45,0xcc48,0xcc4c, /* 0xC3A0-0xC3A7 */
	0xcc54,0xcc55,0xcc57,0xcc58,0xcc59,0xcc60,0xcc64,0xcc66, /* 0xC3A8-0xC3AF */
	0xcc68,0xcc70,0xcc75,0xcc98,0xcc99,0xcc9c,0xcca0,0xcca8, /* 0xC3B0-0xC3B7 */
	0xcca9,0xccab,0xccac,0xccad,0xccb4,0xccb5,0xccb8,0xccbc, /* 0xC3B8-0xC3BF */
	/* codebase=0xc3c0 rawbase=0x31c0 */
	0xccc4,0xccc5,0xccc7,0xccc9,0xccd0,0xccd4,0xcce4,0xccec, /* 0xC3C0-0xC3C7 */
	0xccf0,0xcd01,0xcd08,0xcd09,0xcd0c,0xcd10,0xcd18,0xcd19, /* 0xC3C8-0xC3CF */
	0xcd1b,0xcd1d,0xcd24,0xcd28,0xcd2c,0xcd39,0xcd5c,0xcd60, /* 0xC3D0-0xC3D7 */
	0xcd64,0xcd6c,0xcd6d,0xcd6f,0xcd71,0xcd78,0xcd88,0xcd94, /* 0xC3D8-0xC3DF */
	0xcd95,0xcd98,0xcd9c,0xcda4,0xcda5,0xcda7,0xcda9,0xcdb0, /* 0xC3E0-0xC3E7 */
	0xcdc4,0xcdcc,0xcdd0,0xcde8,0xcdec,0xcdf0,0xcdf8,0xcdf9, /* 0xC3E8-0xC3EF */
	0xcdfb,0xcdfd,0xce04,0xce08,0xce0c,0xce14,0xce19,0xce20, /* 0xC3F0-0xC3F7 */
	0xce21,0xce24,0xce28,0xce30,0xce31,0xce33,0xce35,0x0000, /* 0xC3F8-0xC3FF */
	/* codebase=0xc440 rawbase=0x3200 */
	0x0000,0xd6ab,0xd6ad,0xd6ae,0xd6af,0xd6b1,0xd6b2,0xd6b3, /* 0xC440-0xC447 */
	0xd6b4,0xd6b5,0xd6b6,0xd6b7,0xd6b8,0xd6ba,0xd6bc,0xd6bd, /* 0xC448-0xC44F */
	0xd6be,0xd6bf,0xd6c0,0xd6c1,0xd6c2,0xd6c3,0xd6c6,0xd6c7, /* 0xC450-0xC457 */
	0xd6c9,0xd6ca,0xd6cb,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC458-0xC45F */
	0x0000,0xd6cd,0xd6ce,0xd6cf,0xd6d0,0xd6d2,0xd6d3,0xd6d5, /* 0xC460-0xC467 */
	0xd6d6,0xd6d8,0xd6da,0xd6db,0xd6dc,0xd6dd,0xd6de,0xd6df, /* 0xC468-0xC46F */
	0xd6e1,0xd6e2,0xd6e3,0xd6e5,0xd6e6,0xd6e7,0xd6e9,0xd6ea, /* 0xC470-0xC477 */
	0xd6eb,0xd6ec,0xd6ed,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC478-0xC47F */
	/* codebase=0xc480 rawbase=0x3240 */
	0x0000,0xd6ee,0xd6ef,0xd6f1,0xd6f2,0xd6f3,0xd6f4,0xd6f6, /* 0xC480-0xC487 */
	0xd6f7,0xd6f8,0xd6f9,0xd6fa,0xd6fb,0xd6fe,0xd6ff,0xd701, /* 0xC488-0xC48F */
	0xd702,0xd703,0xd705,0xd706,0xd707,0xd708,0xd709,0xd70a, /* 0xC490-0xC497 */
	0xd70b,0xd70c,0xd70d,0xd70e,0xd70f,0xd710,0xd712,0xd713, /* 0xC498-0xC49F */
	0xd714,0xce58,0xce59,0xce5c,0xce5f,0xce60,0xce61,0xce68, /* 0xC4A0-0xC4A7 */
	0xce69,0xce6b,0xce6d,0xce74,0xce75,0xce78,0xce7c,0xce84, /* 0xC4A8-0xC4AF */
	0xce85,0xce87,0xce89,0xce90,0xce91,0xce94,0xce98,0xcea0, /* 0xC4B0-0xC4B7 */
	0xcea1,0xcea3,0xcea4,0xcea5,0xceac,0xcead,0xcec1,0xcee4, /* 0xC4B8-0xC4BF */
	/* codebase=0xc4c0 rawbase=0x3280 */
	0xcee5,0xcee8,0xceeb,0xceec,0xcef4,0xcef5,0xcef7,0xcef8, /* 0xC4C0-0xC4C7 */
	0xcef9,0xcf00,0xcf01,0xcf04,0xcf08,0xcf10,0xcf11,0xcf13, /* 0xC4C8-0xC4CF */
	0xcf15,0xcf1c,0xcf20,0xcf24,0xcf2c,0xcf2d,0xcf2f,0xcf30, /* 0xC4D0-0xC4D7 */
	0xcf31,0xcf38,0xcf54,0xcf55,0xcf58,0xcf5c,0xcf64,0xcf65, /* 0xC4D8-0xC4DF */
	0xcf67,0xcf69,0xcf70,0xcf71,0xcf74,0xcf78,0xcf80,0xcf85, /* 0xC4E0-0xC4E7 */
	0xcf8c,0xcfa1,0xcfa8,0xcfb0,0xcfc4,0xcfe0,0xcfe1,0xcfe4, /* 0xC4E8-0xC4EF */
	0xcfe8,0xcff0,0xcff1,0xcff3,0xcff5,0xcffc,0xd000,0xd004, /* 0xC4F0-0xC4F7 */
	0xd011,0xd018,0xd02d,0xd034,0xd035,0xd038,0xd03c,0x0000, /* 0xC4F8-0xC4FF */
	/* codebase=0xc540 rawbase=0x32c0 */
	0x0000,0xd715,0xd716,0xd717,0xd71a,0xd71b,0xd71d,0xd71e, /* 0xC540-0xC547 */
	0xd71f,0xd721,0xd722,0xd723,0xd724,0xd725,0xd726,0xd727, /* 0xC548-0xC54F */
	0xd72a,0xd72c,0xd72e,0xd72f,0xd730,0xd731,0xd732,0xd733, /* 0xC550-0xC557 */
	0xd736,0xd737,0xd739,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC558-0xC55F */
	0x0000,0xd73a,0xd73b,0xd73d,0xd73e,0xd73f,0xd740,0xd741, /* 0xC560-0xC567 */
	0xd742,0xd743,0xd745,0xd746,0xd748,0xd74a,0xd74b,0xd74c, /* 0xC568-0xC56F */
	0xd74d,0xd74e,0xd74f,0xd752,0xd753,0xd755,0xd75a,0xd75b, /* 0xC570-0xC577 */
	0xd75c,0xd75d,0xd75e,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC578-0xC57F */
	/* codebase=0xc580 rawbase=0x3300 */
	0x0000,0xd75f,0xd762,0xd764,0xd766,0xd767,0xd768,0xd76a, /* 0xC580-0xC587 */
	0xd76b,0xd76d,0xd76e,0xd76f,0xd771,0xd772,0xd773,0xd775, /* 0xC588-0xC58F */
	0xd776,0xd777,0xd778,0xd779,0xd77a,0xd77b,0xd77e,0xd77f, /* 0xC590-0xC597 */
	0xd780,0xd782,0xd783,0xd784,0xd785,0xd786,0xd787,0xd78a, /* 0xC598-0xC59F */
	0xd78b,0xd044,0xd045,0xd047,0xd049,0xd050,0xd054,0xd058, /* 0xC5A0-0xC5A7 */
	0xd060,0xd06c,0xd06d,0xd070,0xd074,0xd07c,0xd07d,0xd081, /* 0xC5A8-0xC5AF */
	0xd0a4,0xd0a5,0xd0a8,0xd0ac,0xd0b4,0xd0b5,0xd0b7,0xd0b9, /* 0xC5B0-0xC5B7 */
	0xd0c0,0xd0c1,0xd0c4,0xd0c8,0xd0c9,0xd0d0,0xd0d1,0xd0d3, /* 0xC5B8-0xC5BF */
	/* codebase=0xc5c0 rawbase=0x3340 */
	0xd0d4,0xd0d5,0xd0dc,0xd0dd,0xd0e0,0xd0e4,0xd0ec,0xd0ed, /* 0xC5C0-0xC5C7 */
	0xd0ef,0xd0f0,0xd0f1,0xd0f8,0xd10d,0xd130,0xd131,0xd134, /* 0xC5C8-0xC5CF */
	0xd138,0xd13a,0xd140,0xd141,0xd143,0xd144,0xd145,0xd14c, /* 0xC5D0-0xC5D7 */
	0xd14d,0xd150,0xd154,0xd15c,0xd15d,0xd15f,0xd161,0xd168, /* 0xC5D8-0xC5DF */
	0xd16c,0xd17c,0xd184,0xd188,0xd1a0,0xd1a1,0xd1a4,0xd1a8, /* 0xC5E0-0xC5E7 */
	0xd1b0,0xd1b1,0xd1b3,0xd1b5,0xd1ba,0xd1bc,0xd1c0,0xd1d8, /* 0xC5E8-0xC5EF */
	0xd1f4,0xd1f8,0xd207,0xd209,0xd210,0xd22c,0xd22d,0xd230, /* 0xC5F0-0xC5F7 */
	0xd234,0xd23c,0xd23d,0xd23f,0xd241,0xd248,0xd25c,0x0000, /* 0xC5F8-0xC5FF */
	/* codebase=0xc640 rawbase=0x3380 */
	0x0000,0xd78d,0xd78e,0xd78f,0xd791,0xd792,0xd793,0xd794, /* 0xC640-0xC647 */
	0xd795,0xd796,0xd797,0xd79a,0xd79c,0xd79e,0xd79f,0xd7a0, /* 0xC648-0xC64F */
	0xd7a1,0xd7a2,0xd7a3,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC650-0xC657 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC658-0xC65F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC660-0xC667 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC668-0xC66F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC670-0xC677 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC678-0xC67F */
	/* codebase=0xc680 rawbase=0x33c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC680-0xC687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC688-0xC68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC690-0xC697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC698-0xC69F */
	0x0000,0xd264,0xd280,0xd281,0xd284,0xd288,0xd290,0xd291, /* 0xC6A0-0xC6A7 */
	0xd295,0xd29c,0xd2a0,0xd2a4,0xd2ac,0xd2b1,0xd2b8,0xd2b9, /* 0xC6A8-0xC6AF */
	0xd2bc,0xd2bf,0xd2c0,0xd2c2,0xd2c8,0xd2c9,0xd2cb,0xd2d4, /* 0xC6B0-0xC6B7 */
	0xd2d8,0xd2dc,0xd2e4,0xd2e5,0xd2f0,0xd2f1,0xd2f4,0xd2f8, /* 0xC6B8-0xC6BF */
	/* codebase=0xc6c0 rawbase=0x3400 */
	0xd300,0xd301,0xd303,0xd305,0xd30c,0xd30d,0xd30e,0xd310, /* 0xC6C0-0xC6C7 */
	0xd314,0xd316,0xd31c,0xd31d,0xd31f,0xd320,0xd321,0xd325, /* 0xC6C8-0xC6CF */
	0xd328,0xd329,0xd32c,0xd330,0xd338,0xd339,0xd33b,0xd33c, /* 0xC6D0-0xC6D7 */
	0xd33d,0xd344,0xd345,0xd37c,0xd37d,0xd380,0xd384,0xd38c, /* 0xC6D8-0xC6DF */
	0xd38d,0xd38f,0xd390,0xd391,0xd398,0xd399,0xd39c,0xd3a0, /* 0xC6E0-0xC6E7 */
	0xd3a8,0xd3a9,0xd3ab,0xd3ad,0xd3b4,0xd3b8,0xd3bc,0xd3c4, /* 0xC6E8-0xC6EF */
	0xd3c5,0xd3c8,0xd3c9,0xd3d0,0xd3d8,0xd3e1,0xd3e3,0xd3ec, /* 0xC6F0-0xC6F7 */
	0xd3ed,0xd3f0,0xd3f4,0xd3fc,0xd3fd,0xd3ff,0xd401,0x0000, /* 0xC6F8-0xC6FF */
	/* codebase=0xc780 rawbase=0x3440 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC780-0xC787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC788-0xC78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC790-0xC797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC798-0xC79F */
	0x0000,0xd408,0xd41d,0xd440,0xd444,0xd45c,0xd460,0xd464, /* 0xC7A0-0xC7A7 */
	0xd46d,0xd46f,0xd478,0xd479,0xd47c,0xd47f,0xd480,0xd482, /* 0xC7A8-0xC7AF */
	0xd488,0xd489,0xd48b,0xd48d,0xd494,0xd4a9,0xd4cc,0xd4d0, /* 0xC7B0-0xC7B7 */
	0xd4d4,0xd4dc,0xd4df,0xd4e8,0xd4ec,0xd4f0,0xd4f8,0xd4fb, /* 0xC7B8-0xC7BF */
	/* codebase=0xc7c0 rawbase=0x3480 */
	0xd4fd,0xd504,0xd508,0xd50c,0xd514,0xd515,0xd517,0xd53c, /* 0xC7C0-0xC7C7 */
	0xd53d,0xd540,0xd544,0xd54c,0xd54d,0xd54f,0xd551,0xd558, /* 0xC7C8-0xC7CF */
	0xd559,0xd55c,0xd560,0xd565,0xd568,0xd569,0xd56b,0xd56d, /* 0xC7D0-0xC7D7 */
	0xd574,0xd575,0xd578,0xd57c,0xd584,0xd585,0xd587,0xd588, /* 0xC7D8-0xC7DF */
	0xd589,0xd590,0xd5a5,0xd5c8,0xd5c9,0xd5cc,0xd5d0,0xd5d2, /* 0xC7E0-0xC7E7 */
	0xd5d8,0xd5d9,0xd5db,0xd5dd,0xd5e4,0xd5e5,0xd5e8,0xd5ec, /* 0xC7E8-0xC7EF */
	0xd5f4,0xd5f5,0xd5f7,0xd5f9,0xd600,0xd601,0xd604,0xd608, /* 0xC7F0-0xC7F7 */
	0xd610,0xd611,0xd613,0xd614,0xd615,0xd61c,0xd620,0x0000, /* 0xC7F8-0xC7FF */
	/* codebase=0xc880 rawbase=0x34c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC880-0xC887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC888-0xC88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC890-0xC897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xC898-0xC89F */
	0x0000,0xd624,0xd62d,0xd638,0xd639,0xd63c,0xd640,0xd645, /* 0xC8A0-0xC8A7 */
	0xd648,0xd649,0xd64b,0xd64d,0xd651,0xd654,0xd655,0xd658, /* 0xC8A8-0xC8AF */
	0xd65c,0xd667,0xd669,0xd670,0xd671,0xd674,0xd683,0xd685, /* 0xC8B0-0xC8B7 */
	0xd68c,0xd68d,0xd690,0xd694,0xd69d,0xd69f,0xd6a1,0xd6a8, /* 0xC8B8-0xC8BF */
	/* codebase=0xc8c0 rawbase=0x3500 */
	0xd6ac,0xd6b0,0xd6b9,0xd6bb,0xd6c4,0xd6c5,0xd6c8,0xd6cc, /* 0xC8C0-0xC8C7 */
	0xd6d1,0xd6d4,0xd6d7,0xd6d9,0xd6e0,0xd6e4,0xd6e8,0xd6f0, /* 0xC8C8-0xC8CF */
	0xd6f5,0xd6fc,0xd6fd,0xd700,0xd704,0xd711,0xd718,0xd719, /* 0xC8D0-0xC8D7 */
	0xd71c,0xd720,0xd728,0xd729,0xd72b,0xd72d,0xd734,0xd735, /* 0xC8D8-0xC8DF */
	0xd738,0xd73c,0xd744,0xd747,0xd749,0xd750,0xd751,0xd754, /* 0xC8E0-0xC8E7 */
	0xd756,0xd757,0xd758,0xd759,0xd760,0xd761,0xd763,0xd765, /* 0xC8E8-0xC8EF */
	0xd769,0xd76c,0xd770,0xd774,0xd77c,0xd77d,0xd781,0xd788, /* 0xC8F0-0xC8F7 */
	0xd789,0xd78c,0xd790,0xd798,0xd799,0xd79b,0xd79d,0x0000, /* 0xC8F8-0xC8FF */
	/* codebase=0xca80 rawbase=0x3540 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA80-0xCA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA88-0xCA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA90-0xCA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCA98-0xCA9F */
	0x0000,0x4f3d,0x4f73,0x5047,0x50f9,0x52a0,0x53ef,0x5475, /* 0xCAA0-0xCAA7 */
	0x54e5,0x5609,0x5ac1,0x5bb6,0x6687,0x67b6,0x67b7,0x67ef, /* 0xCAA8-0xCAAF */
	0x6b4c,0x73c2,0x75c2,0x7a3c,0x82db,0x8304,0x8857,0x8888, /* 0xCAB0-0xCAB7 */
	0x8a36,0x8cc8,0x8dcf,0x8efb,0x8fe6,0x99d5,0x523b,0x5374, /* 0xCAB8-0xCABF */
	/* codebase=0xcac0 rawbase=0x3580 */
	0x5404,0x606a,0x6164,0x6bbc,0x73cf,0x811a,0x89ba,0x89d2, /* 0xCAC0-0xCAC7 */
	0x95a3,0x4f83,0x520a,0x58be,0x5978,0x59e6,0x5e72,0x5e79, /* 0xCAC8-0xCACF */
	0x61c7,0x63c0,0x6746,0x67ec,0x687f,0x6f97,0x764e,0x770b, /* 0xCAD0-0xCAD7 */
	0x78f5,0x7a08,0x7aff,0x7c21,0x809d,0x826e,0x8271,0x8aeb, /* 0xCAD8-0xCADF */
	0x9593,0x4e6b,0x559d,0x66f7,0x6e34,0x78a3,0x7aed,0x845b, /* 0xCAE0-0xCAE7 */
	0x8910,0x874e,0x97a8,0x52d8,0x574e,0x582a,0x5d4c,0x611f, /* 0xCAE8-0xCAEF */
	0x61be,0x6221,0x6562,0x67d1,0x6a44,0x6e1b,0x7518,0x75b3, /* 0xCAF0-0xCAF7 */
	0x76e3,0x77b0,0x7d3a,0x90af,0x9451,0x9452,0x9f95,0x0000, /* 0xCAF8-0xCAFF */
	/* codebase=0xcb80 rawbase=0x35c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB80-0xCB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB88-0xCB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB90-0xCB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCB98-0xCB9F */
	0x0000,0x5323,0x5cac,0x7532,0x80db,0x9240,0x9598,0x525b, /* 0xCBA0-0xCBA7 */
	0x5808,0x59dc,0x5ca1,0x5d17,0x5eb7,0x5f3a,0x5f4a,0x6177, /* 0xCBA8-0xCBAF */
	0x6c5f,0x757a,0x7586,0x7ce0,0x7d73,0x7db1,0x7f8c,0x8154, /* 0xCBB0-0xCBB7 */
	0x8221,0x8591,0x8941,0x8b1b,0x92fc,0x964d,0x9c47,0x4ecb, /* 0xCBB8-0xCBBF */
	/* codebase=0xcbc0 rawbase=0x3600 */
	0x4ef7,0x500b,0x51f1,0x584f,0x6137,0x613e,0x6168,0x6539, /* 0xCBC0-0xCBC7 */
	0x69ea,0x6f11,0x75a5,0x7686,0x76d6,0x7b87,0x82a5,0x84cb, /* 0xCBC8-0xCBCF */
	0xf900,0x93a7,0x958b,0x5580,0x5ba2,0x5751,0xf901,0x7cb3, /* 0xCBD0-0xCBD7 */
	0x7fb9,0x91b5,0x5028,0x53bb,0x5c45,0x5de8,0x62d2,0x636e, /* 0xCBD8-0xCBDF */
	0x64da,0x64e7,0x6e20,0x70ac,0x795b,0x8ddd,0x8e1e,0xf902, /* 0xCBE0-0xCBE7 */
	0x907d,0x9245,0x92f8,0x4e7e,0x4ef6,0x5065,0x5dfe,0x5efa, /* 0xCBE8-0xCBEF */
	0x6106,0x6957,0x8171,0x8654,0x8e47,0x9375,0x9a2b,0x4e5e, /* 0xCBF0-0xCBF7 */
	0x5091,0x6770,0x6840,0x5109,0x528d,0x5292,0x6aa2,0x0000, /* 0xCBF8-0xCBFF */
	/* codebase=0xcc80 rawbase=0x3640 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC80-0xCC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC88-0xCC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC90-0xCC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCC98-0xCC9F */
	0x0000,0x77bc,0x9210,0x9ed4,0x52ab,0x602f,0x8ff2,0x5048, /* 0xCCA0-0xCCA7 */
	0x61a9,0x63ed,0x64ca,0x683c,0x6a84,0x6fc0,0x8188,0x89a1, /* 0xCCA8-0xCCAF */
	0x9694,0x5805,0x727d,0x72ac,0x7504,0x7d79,0x7e6d,0x80a9, /* 0xCCB0-0xCCB7 */
	0x898b,0x8b74,0x9063,0x9d51,0x6289,0x6c7a,0x6f54,0x7d50, /* 0xCCB8-0xCCBF */
	/* codebase=0xccc0 rawbase=0x3680 */
	0x7f3a,0x8a23,0x517c,0x614a,0x7b9d,0x8b19,0x9257,0x938c, /* 0xCCC0-0xCCC7 */
	0x4eac,0x4fd3,0x501e,0x50be,0x5106,0x52c1,0x52cd,0x537f, /* 0xCCC8-0xCCCF */
	0x5770,0x5883,0x5e9a,0x5f91,0x6176,0x61ac,0x64ce,0x656c, /* 0xCCD0-0xCCD7 */
	0x666f,0x66bb,0x66f4,0x6897,0x6d87,0x7085,0x70f1,0x749f, /* 0xCCD8-0xCCDF */
	0x74a5,0x74ca,0x75d9,0x786c,0x78ec,0x7adf,0x7af6,0x7d45, /* 0xCCE0-0xCCE7 */
	0x7d93,0x8015,0x803f,0x811b,0x8396,0x8b66,0x8f15,0x9015, /* 0xCCE8-0xCCEF */
	0x93e1,0x9803,0x9838,0x9a5a,0x9be8,0x4fc2,0x5553,0x583a, /* 0xCCF0-0xCCF7 */
	0x5951,0x5b63,0x5c46,0x60b8,0x6212,0x6842,0x68b0,0x0000, /* 0xCCF8-0xCCFF */
	/* codebase=0xcd80 rawbase=0x36c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD80-0xCD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD88-0xCD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD90-0xCD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCD98-0xCD9F */
	0x0000,0x68e8,0x6eaa,0x754c,0x7678,0x78ce,0x7a3d,0x7cfb, /* 0xCDA0-0xCDA7 */
	0x7e6b,0x7e7c,0x8a08,0x8aa1,0x8c3f,0x968e,0x9dc4,0x53e4, /* 0xCDA8-0xCDAF */
	0x53e9,0x544a,0x5471,0x56fa,0x59d1,0x5b64,0x5c3b,0x5eab, /* 0xCDB0-0xCDB7 */
	0x62f7,0x6537,0x6545,0x6572,0x66a0,0x67af,0x69c1,0x6cbd, /* 0xCDB8-0xCDBF */
	/* codebase=0xcdc0 rawbase=0x3700 */
	0x75fc,0x7690,0x777e,0x7a3f,0x7f94,0x8003,0x80a1,0x818f, /* 0xCDC0-0xCDC7 */
	0x82e6,0x82fd,0x83f0,0x85c1,0x8831,0x88b4,0x8aa5,0xf903, /* 0xCDC8-0xCDCF */
	0x8f9c,0x932e,0x96c7,0x9867,0x9ad8,0x9f13,0x54ed,0x659b, /* 0xCDD0-0xCDD7 */
	0x66f2,0x688f,0x7a40,0x8c37,0x9d60,0x56f0,0x5764,0x5d11, /* 0xCDD8-0xCDDF */
	0x6606,0x68b1,0x68cd,0x6efe,0x7428,0x889e,0x9be4,0x6c68, /* 0xCDE0-0xCDE7 */
	0xf904,0x9aa8,0x4f9b,0x516c,0x5171,0x529f,0x5b54,0x5de5, /* 0xCDE8-0xCDEF */
	0x6050,0x606d,0x62f1,0x63a7,0x653b,0x73d9,0x7a7a,0x86a3, /* 0xCDF0-0xCDF7 */
	0x8ca2,0x978f,0x4e32,0x5be1,0x6208,0x679c,0x74dc,0x0000, /* 0xCDF8-0xCDFF */
	/* codebase=0xce80 rawbase=0x3740 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE80-0xCE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE88-0xCE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE90-0xCE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCE98-0xCE9F */
	0x0000,0x79d1,0x83d3,0x8a87,0x8ab2,0x8de8,0x904e,0x934b, /* 0xCEA0-0xCEA7 */
	0x9846,0x5ed3,0x69e8,0x85ff,0x90ed,0xf905,0x51a0,0x5b98, /* 0xCEA8-0xCEAF */
	0x5bec,0x6163,0x68fa,0x6b3e,0x704c,0x742f,0x74d8,0x7ba1, /* 0xCEB0-0xCEB7 */
	0x7f50,0x83c5,0x89c0,0x8cab,0x95dc,0x9928,0x522e,0x605d, /* 0xCEB8-0xCEBF */
	/* codebase=0xcec0 rawbase=0x3780 */
	0x62ec,0x9002,0x4f8a,0x5149,0x5321,0x58d9,0x5ee3,0x66e0, /* 0xCEC0-0xCEC7 */
	0x6d38,0x709a,0x72c2,0x73d6,0x7b50,0x80f1,0x945b,0x5366, /* 0xCEC8-0xCECF */
	0x639b,0x7f6b,0x4e56,0x5080,0x584a,0x58de,0x602a,0x6127, /* 0xCED0-0xCED7 */
	0x62d0,0x69d0,0x9b41,0x5b8f,0x7d18,0x80b1,0x8f5f,0x4ea4, /* 0xCED8-0xCEDF */
	0x50d1,0x54ac,0x55ac,0x5b0c,0x5da0,0x5de7,0x652a,0x654e, /* 0xCEE0-0xCEE7 */
	0x6821,0x6a4b,0x72e1,0x768e,0x77ef,0x7d5e,0x7ff9,0x81a0, /* 0xCEE8-0xCEEF */
	0x854e,0x86df,0x8f03,0x8f4e,0x90ca,0x9903,0x9a55,0x9bab, /* 0xCEF0-0xCEF7 */
	0x4e18,0x4e45,0x4e5d,0x4ec7,0x4ff1,0x5177,0x52fe,0x0000, /* 0xCEF8-0xCEFF */
	/* codebase=0xcf80 rawbase=0x37c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF80-0xCF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF88-0xCF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF90-0xCF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xCF98-0xCF9F */
	0x0000,0x5340,0x53e3,0x53e5,0x548e,0x5614,0x5775,0x57a2, /* 0xCFA0-0xCFA7 */
	0x5bc7,0x5d87,0x5ed0,0x61fc,0x62d8,0x6551,0x67b8,0x67e9, /* 0xCFA8-0xCFAF */
	0x69cb,0x6b50,0x6bc6,0x6bec,0x6c42,0x6e9d,0x7078,0x72d7, /* 0xCFB0-0xCFB7 */
	0x7396,0x7403,0x77bf,0x77e9,0x7a76,0x7d7f,0x8009,0x81fc, /* 0xCFB8-0xCFBF */
	/* codebase=0xcfc0 rawbase=0x3800 */
	0x8205,0x820a,0x82df,0x8862,0x8b33,0x8cfc,0x8ec0,0x9011, /* 0xCFC0-0xCFC7 */
	0x90b1,0x9264,0x92b6,0x99d2,0x9a45,0x9ce9,0x9dd7,0x9f9c, /* 0xCFC8-0xCFCF */
	0x570b,0x5c40,0x83ca,0x97a0,0x97ab,0x9eb4,0x541b,0x7a98, /* 0xCFD0-0xCFD7 */
	0x7fa4,0x88d9,0x8ecd,0x90e1,0x5800,0x5c48,0x6398,0x7a9f, /* 0xCFD8-0xCFDF */
	0x5bae,0x5f13,0x7a79,0x7aae,0x828e,0x8eac,0x5026,0x5238, /* 0xCFE0-0xCFE7 */
	0x52f8,0x5377,0x5708,0x62f3,0x6372,0x6b0a,0x6dc3,0x7737, /* 0xCFE8-0xCFEF */
	0x53a5,0x7357,0x8568,0x8e76,0x95d5,0x673a,0x6ac3,0x6f70, /* 0xCFF0-0xCFF7 */
	0x8a6d,0x8ecc,0x994b,0xf906,0x6677,0x6b78,0x8cb4,0x0000, /* 0xCFF8-0xCFFF */
	/* codebase=0xd080 rawbase=0x3840 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD080-0xD087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD088-0xD08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD090-0xD097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD098-0xD09F */
	0x0000,0x9b3c,0xf907,0x53eb,0x572d,0x594e,0x63c6,0x69fb, /* 0xD0A0-0xD0A7 */
	0x73ea,0x7845,0x7aba,0x7ac5,0x7cfe,0x8475,0x898f,0x8d73, /* 0xD0A8-0xD0AF */
	0x9035,0x95a8,0x52fb,0x5747,0x7547,0x7b60,0x83cc,0x921e, /* 0xD0B0-0xD0B7 */
	0xf908,0x6a58,0x514b,0x524b,0x5287,0x621f,0x68d8,0x6975, /* 0xD0B8-0xD0BF */
	/* codebase=0xd0c0 rawbase=0x3880 */
	0x9699,0x50c5,0x52a4,0x52e4,0x61c3,0x65a4,0x6839,0x69ff, /* 0xD0C0-0xD0C7 */
	0x747e,0x7b4b,0x82b9,0x83eb,0x89b2,0x8b39,0x8fd1,0x9949, /* 0xD0C8-0xD0CF */
	0xf909,0x4eca,0x5997,0x64d2,0x6611,0x6a8e,0x7434,0x7981, /* 0xD0D0-0xD0D7 */
	0x79bd,0x82a9,0x887e,0x887f,0x895f,0xf90a,0x9326,0x4f0b, /* 0xD0D8-0xD0DF */
	0x53ca,0x6025,0x6271,0x6c72,0x7d1a,0x7d66,0x4e98,0x5162, /* 0xD0E0-0xD0E7 */
	0x77dc,0x80af,0x4f01,0x4f0e,0x5176,0x5180,0x55dc,0x5668, /* 0xD0E8-0xD0EF */
	0x573b,0x57fa,0x57fc,0x5914,0x5947,0x5993,0x5bc4,0x5c90, /* 0xD0F0-0xD0F7 */
	0x5d0e,0x5df1,0x5e7e,0x5fcc,0x6280,0x65d7,0x65e3,0x0000, /* 0xD0F8-0xD0FF */
	/* codebase=0xd180 rawbase=0x38c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD180-0xD187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD188-0xD18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD190-0xD197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD198-0xD19F */
	0x0000,0x671e,0x671f,0x675e,0x68cb,0x68c4,0x6a5f,0x6b3a, /* 0xD1A0-0xD1A7 */
	0x6c23,0x6c7d,0x6c82,0x6dc7,0x7398,0x7426,0x742a,0x7482, /* 0xD1A8-0xD1AF */
	0x74a3,0x7578,0x757f,0x7881,0x78ef,0x7941,0x7947,0x7948, /* 0xD1B0-0xD1B7 */
	0x797a,0x7b95,0x7d00,0x7dba,0x7f88,0x8006,0x802d,0x808c, /* 0xD1B8-0xD1BF */
	/* codebase=0xd1c0 rawbase=0x3900 */
	0x8a18,0x8b4f,0x8c48,0x8d77,0x9321,0x9324,0x98e2,0x9951, /* 0xD1C0-0xD1C7 */
	0x9a0e,0x9a0f,0x9a65,0x9e92,0x7dca,0x4f76,0x5409,0x62ee, /* 0xD1C8-0xD1CF */
	0x6854,0x91d1,0x55ab,0x513a,0xf90b,0xf90c,0x5a1c,0x61e6, /* 0xD1D0-0xD1D7 */
	0xf90d,0x62cf,0x62ff,0xf90e,0xf90f,0xf910,0xf911,0xf912, /* 0xD1D8-0xD1DF */
	0xf913,0x90a3,0xf914,0xf915,0xf916,0xf917,0xf918,0x8afe, /* 0xD1E0-0xD1E7 */
	0xf919,0xf91a,0xf91b,0xf91c,0x6696,0xf91d,0x7156,0xf91e, /* 0xD1E8-0xD1EF */
	0xf91f,0x96e3,0xf920,0x634f,0x637a,0x5357,0xf921,0x678f, /* 0xD1F0-0xD1F7 */
	0x6960,0x6e73,0xf922,0x7537,0xf923,0xf924,0xf925,0x0000, /* 0xD1F8-0xD1FF */
	/* codebase=0xd280 rawbase=0x3940 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD280-0xD287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD288-0xD28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD290-0xD297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD298-0xD29F */
	0x0000,0x7d0d,0xf926,0xf927,0x8872,0x56ca,0x5a18,0xf928, /* 0xD2A0-0xD2A7 */
	0xf929,0xf92a,0xf92b,0xf92c,0x4e43,0xf92d,0x5167,0x5948, /* 0xD2A8-0xD2AF */
	0x67f0,0x8010,0xf92e,0x5973,0x5e74,0x649a,0x79ca,0x5ff5, /* 0xD2B0-0xD2B7 */
	0x606c,0x62c8,0x637b,0x5be7,0x5bd7,0x52aa,0xf92f,0x5974, /* 0xD2B8-0xD2BF */
	/* codebase=0xd2c0 rawbase=0x3980 */
	0x5f29,0x6012,0xf930,0xf931,0xf932,0x7459,0xf933,0xf934, /* 0xD2C0-0xD2C7 */
	0xf935,0xf936,0xf937,0xf938,0x99d1,0xf939,0xf93a,0xf93b, /* 0xD2C8-0xD2CF */
	0xf93c,0xf93d,0xf93e,0xf93f,0xf940,0xf941,0xf942,0xf943, /* 0xD2D0-0xD2D7 */
	0x6fc3,0xf944,0xf945,0x81bf,0x8fb2,0x60f1,0xf946,0xf947, /* 0xD2D8-0xD2DF */
	0x8166,0xf948,0xf949,0x5c3f,0xf94a,0xf94b,0xf94c,0xf94d, /* 0xD2E0-0xD2E7 */
	0xf94e,0xf94f,0xf950,0xf951,0x5ae9,0x8a25,0x677b,0x7d10, /* 0xD2E8-0xD2EF */
	0xf952,0xf953,0xf954,0xf955,0xf956,0xf957,0x80fd,0xf958, /* 0xD2F0-0xD2F7 */
	0xf959,0x5c3c,0x6ce5,0x533f,0x6eba,0x591a,0x8336,0x0000, /* 0xD2F8-0xD2FF */
	/* codebase=0xd380 rawbase=0x39c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD380-0xD387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD388-0xD38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD390-0xD397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD398-0xD39F */
	0x0000,0x4e39,0x4eb6,0x4f46,0x55ae,0x5718,0x58c7,0x5f56, /* 0xD3A0-0xD3A7 */
	0x65b7,0x65e6,0x6a80,0x6bb5,0x6e4d,0x77ed,0x7aef,0x7c1e, /* 0xD3A8-0xD3AF */
	0x7dde,0x86cb,0x8892,0x9132,0x935b,0x64bb,0x6fbe,0x737a, /* 0xD3B0-0xD3B7 */
	0x75b8,0x9054,0x5556,0x574d,0x61ba,0x64d4,0x66c7,0x6de1, /* 0xD3B8-0xD3BF */
	/* codebase=0xd3c0 rawbase=0x3a00 */
	0x6e5b,0x6f6d,0x6fb9,0x75f0,0x8043,0x81bd,0x8541,0x8983, /* 0xD3C0-0xD3C7 */
	0x8ac7,0x8b5a,0x931f,0x6c93,0x7553,0x7b54,0x8e0f,0x905d, /* 0xD3C8-0xD3CF */
	0x5510,0x5802,0x5858,0x5e62,0x6207,0x649e,0x68e0,0x7576, /* 0xD3D0-0xD3D7 */
	0x7cd6,0x87b3,0x9ee8,0x4ee3,0x5788,0x576e,0x5927,0x5c0d, /* 0xD3D8-0xD3DF */
	0x5cb1,0x5e36,0x5f85,0x6234,0x64e1,0x73b3,0x81fa,0x888b, /* 0xD3E0-0xD3E7 */
	0x8cb8,0x968a,0x9edb,0x5b85,0x5fb7,0x60b3,0x5012,0x5200, /* 0xD3E8-0xD3EF */
	0x5230,0x5716,0x5835,0x5857,0x5c0e,0x5c60,0x5cf6,0x5d8b, /* 0xD3F0-0xD3F7 */
	0x5ea6,0x5f92,0x60bc,0x6311,0x6389,0x6417,0x6843,0x0000, /* 0xD3F8-0xD3FF */
	/* codebase=0xd480 rawbase=0x3a40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD480-0xD487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD488-0xD48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD490-0xD497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD498-0xD49F */
	0x0000,0x68f9,0x6ac2,0x6dd8,0x6e21,0x6ed4,0x6fe4,0x71fe, /* 0xD4A0-0xD4A7 */
	0x76dc,0x7779,0x79b1,0x7a3b,0x8404,0x89a9,0x8ced,0x8df3, /* 0xD4A8-0xD4AF */
	0x8e48,0x9003,0x9014,0x9053,0x90fd,0x934d,0x9676,0x97dc, /* 0xD4B0-0xD4B7 */
	0x6bd2,0x7006,0x7258,0x72a2,0x7368,0x7763,0x79bf,0x7be4, /* 0xD4B8-0xD4BF */
	/* codebase=0xd4c0 rawbase=0x3a80 */
	0x7e9b,0x8b80,0x58a9,0x60c7,0x6566,0x65fd,0x66be,0x6c8c, /* 0xD4C0-0xD4C7 */
	0x711e,0x71c9,0x8c5a,0x9813,0x4e6d,0x7a81,0x4edd,0x51ac, /* 0xD4C8-0xD4CF */
	0x51cd,0x52d5,0x540c,0x61a7,0x6771,0x6850,0x68df,0x6d1e, /* 0xD4D0-0xD4D7 */
	0x6f7c,0x75bc,0x77b3,0x7ae5,0x80f4,0x8463,0x9285,0x515c, /* 0xD4D8-0xD4DF */
	0x6597,0x675c,0x6793,0x75d8,0x7ac7,0x8373,0xf95a,0x8c46, /* 0xD4E0-0xD4E7 */
	0x9017,0x982d,0x5c6f,0x81c0,0x829a,0x9041,0x906f,0x920d, /* 0xD4E8-0xD4EF */
	0x5f97,0x5d9d,0x6a59,0x71c8,0x767b,0x7b49,0x85e4,0x8b04, /* 0xD4F0-0xD4F7 */
	0x9127,0x9a30,0x5587,0x61f6,0xf95b,0x7669,0x7f85,0x0000, /* 0xD4F8-0xD4FF */
	/* codebase=0xd580 rawbase=0x3ac0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD580-0xD587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD588-0xD58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD590-0xD597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD598-0xD59F */
	0x0000,0x863f,0x87ba,0x88f8,0x908f,0xf95c,0x6d1b,0x70d9, /* 0xD5A0-0xD5A7 */
	0x73de,0x7d61,0x843d,0xf95d,0x916a,0x99f1,0xf95e,0x4e82, /* 0xD5A8-0xD5AF */
	0x5375,0x6b04,0x6b12,0x703e,0x721b,0x862d,0x9e1e,0x524c, /* 0xD5B0-0xD5B7 */
	0x8fa3,0x5d50,0x64e5,0x652c,0x6b16,0x6feb,0x7c43,0x7e9c, /* 0xD5B8-0xD5BF */
	/* codebase=0xd5c0 rawbase=0x3b00 */
	0x85cd,0x8964,0x89bd,0x62c9,0x81d8,0x881f,0x5eca,0x6717, /* 0xD5C0-0xD5C7 */
	0x6d6a,0x72fc,0x7405,0x746f,0x8782,0x90de,0x4f86,0x5d0d, /* 0xD5C8-0xD5CF */
	0x5fa0,0x840a,0x51b7,0x63a0,0x7565,0x4eae,0x5006,0x5169, /* 0xD5D0-0xD5D7 */
	0x51c9,0x6881,0x6a11,0x7cae,0x7cb1,0x7ce7,0x826f,0x8ad2, /* 0xD5D8-0xD5DF */
	0x8f1b,0x91cf,0x4fb6,0x5137,0x52f5,0x5442,0x5eec,0x616e, /* 0xD5E0-0xD5E7 */
	0x623e,0x65c5,0x6ada,0x6ffe,0x792a,0x85dc,0x8823,0x95ad, /* 0xD5E8-0xD5EF */
	0x9a62,0x9a6a,0x9e97,0x9ece,0x529b,0x66c6,0x6b77,0x701d, /* 0xD5F0-0xD5F7 */
	0x792b,0x8f62,0x9742,0x6190,0x6200,0x6523,0x6f23,0x0000, /* 0xD5F8-0xD5FF */
	/* codebase=0xd680 rawbase=0x3b40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD680-0xD687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD688-0xD68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD690-0xD697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD698-0xD69F */
	0x0000,0x7149,0x7489,0x7df4,0x806f,0x84ee,0x8f26,0x9023, /* 0xD6A0-0xD6A7 */
	0x934a,0x51bd,0x5217,0x52a3,0x6d0c,0x70c8,0x88c2,0x5ec9, /* 0xD6A8-0xD6AF */
	0x6582,0x6bae,0x6fc2,0x7c3e,0x7375,0x4ee4,0x4f36,0x56f9, /* 0xD6B0-0xD6B7 */
	0xf95f,0x5cba,0x5dba,0x601c,0x73b2,0x7b2d,0x7f9a,0x7fce, /* 0xD6B8-0xD6BF */
	/* codebase=0xd6c0 rawbase=0x3b80 */
	0x8046,0x901e,0x9234,0x96f6,0x9748,0x9818,0x9f61,0x4f8b, /* 0xD6C0-0xD6C7 */
	0x6fa7,0x79ae,0x91b4,0x96b7,0x52de,0xf960,0x6488,0x64c4, /* 0xD6C8-0xD6CF */
	0x6ad3,0x6f5e,0x7018,0x7210,0x76e7,0x8001,0x8606,0x865c, /* 0xD6D0-0xD6D7 */
	0x8def,0x8f05,0x9732,0x9b6f,0x9dfa,0x9e75,0x788c,0x797f, /* 0xD6D8-0xD6DF */
	0x7da0,0x83c9,0x9304,0x9e7f,0x9e93,0x8ad6,0x58df,0x5f04, /* 0xD6E0-0xD6E7 */
	0x6727,0x7027,0x74cf,0x7c60,0x807e,0x5121,0x7028,0x7262, /* 0xD6E8-0xD6EF */
	0x78ca,0x8cc2,0x8cda,0x8cf4,0x96f7,0x4e86,0x50da,0x5bee, /* 0xD6F0-0xD6F7 */
	0x5ed6,0x6599,0x71ce,0x7642,0x77ad,0x804a,0x84fc,0x0000, /* 0xD6F8-0xD6FF */
	/* codebase=0xd780 rawbase=0x3bc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD780-0xD787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD788-0xD78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD790-0xD797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD798-0xD79F */
	0x0000,0x907c,0x9b27,0x9f8d,0x58d8,0x5a41,0x5c62,0x6a13, /* 0xD7A0-0xD7A7 */
	0x6dda,0x6f0f,0x763b,0x7d2f,0x7e37,0x851e,0x8938,0x93e4, /* 0xD7A8-0xD7AF */
	0x964b,0x5289,0x65d2,0x67f3,0x69b4,0x6d41,0x6e9c,0x700f, /* 0xD7B0-0xD7B7 */
	0x7409,0x7460,0x7559,0x7624,0x786b,0x8b2c,0x985e,0x516d, /* 0xD7B8-0xD7BF */
	/* codebase=0xd7c0 rawbase=0x3c00 */
	0x622e,0x9678,0x4f96,0x502b,0x5d19,0x6dea,0x7db8,0x8f2a, /* 0xD7C0-0xD7C7 */
	0x5f8b,0x6144,0x6817,0xf961,0x9686,0x52d2,0x808b,0x51dc, /* 0xD7C8-0xD7CF */
	0x51cc,0x695e,0x7a1c,0x7dbe,0x83f1,0x9675,0x4fda,0x5229, /* 0xD7D0-0xD7D7 */
	0x5398,0x540f,0x550e,0x5c65,0x60a7,0x674e,0x68a8,0x6d6c, /* 0xD7D8-0xD7DF */
	0x7281,0x72f8,0x7406,0x7483,0xf962,0x75e2,0x7c6c,0x7f79, /* 0xD7E0-0xD7E7 */
	0x7fb8,0x8389,0x88cf,0x88e1,0x91cc,0x91d0,0x96e2,0x9bc9, /* 0xD7E8-0xD7EF */
	0x541d,0x6f7e,0x71d0,0x7498,0x85fa,0x8eaa,0x96a3,0x9c57, /* 0xD7F0-0xD7F7 */
	0x9e9f,0x6797,0x6dcb,0x7433,0x81e8,0x9716,0x782c,0x0000, /* 0xD7F8-0xD7FF */
	/* codebase=0xd880 rawbase=0x3c40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD880-0xD887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD888-0xD88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD890-0xD897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD898-0xD89F */
	0x0000,0x7acb,0x7b20,0x7c92,0x6469,0x746a,0x75f2,0x78bc, /* 0xD8A0-0xD8A7 */
	0x78e8,0x99ac,0x9b54,0x9ebb,0x5bde,0x5e55,0x6f20,0x819c, /* 0xD8A8-0xD8AF */
	0x83ab,0x9088,0x4e07,0x534d,0x5a29,0x5dd2,0x5f4e,0x6162, /* 0xD8B0-0xD8B7 */
	0x633d,0x6669,0x66fc,0x6eff,0x6f2b,0x7063,0x779e,0x842c, /* 0xD8B8-0xD8BF */
	/* codebase=0xd8c0 rawbase=0x3c80 */
	0x8513,0x883b,0x8f13,0x9945,0x9c3b,0x551c,0x62b9,0x672b, /* 0xD8C0-0xD8C7 */
	0x6cab,0x8309,0x896a,0x977a,0x4ea1,0x5984,0x5fd8,0x5fd9, /* 0xD8C8-0xD8CF */
	0x671b,0x7db2,0x7f54,0x8292,0x832b,0x83bd,0x8f1e,0x9099, /* 0xD8D0-0xD8D7 */
	0x57cb,0x59b9,0x5a92,0x5bd0,0x6627,0x679a,0x6885,0x6bcf, /* 0xD8D8-0xD8DF */
	0x7164,0x7f75,0x8cb7,0x8ce3,0x9081,0x9b45,0x8108,0x8c8a, /* 0xD8E0-0xD8E7 */
	0x964c,0x9a40,0x9ea5,0x5b5f,0x6c13,0x731b,0x76f2,0x76df, /* 0xD8E8-0xD8EF */
	0x840c,0x51aa,0x8993,0x514d,0x5195,0x52c9,0x68c9,0x6c94, /* 0xD8F0-0xD8F7 */
	0x7704,0x7720,0x7dbf,0x7dec,0x9762,0x9eb5,0x6ec5,0x0000, /* 0xD8F8-0xD8FF */
	/* codebase=0xd980 rawbase=0x3cc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD980-0xD987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD988-0xD98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD990-0xD997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xD998-0xD99F */
	0x0000,0x8511,0x51a5,0x540d,0x547d,0x660e,0x669d,0x6927, /* 0xD9A0-0xD9A7 */
	0x6e9f,0x76bf,0x7791,0x8317,0x84c2,0x879f,0x9169,0x9298, /* 0xD9A8-0xD9AF */
	0x9cf4,0x8882,0x4fae,0x5192,0x52df,0x59c6,0x5e3d,0x6155, /* 0xD9B0-0xD9B7 */
	0x6478,0x6479,0x66ae,0x67d0,0x6a21,0x6bcd,0x6bdb,0x725f, /* 0xD9B8-0xD9BF */
	/* codebase=0xd9c0 rawbase=0x3d00 */
	0x7261,0x7441,0x7738,0x77db,0x8017,0x82bc,0x8305,0x8b00, /* 0xD9C0-0xD9C7 */
	0x8b28,0x8c8c,0x6728,0x6c90,0x7267,0x76ee,0x7766,0x7a46, /* 0xD9C8-0xD9CF */
	0x9da9,0x6b7f,0x6c92,0x5922,0x6726,0x8499,0x536f,0x5893, /* 0xD9D0-0xD9D7 */
	0x5999,0x5edf,0x63cf,0x6634,0x6773,0x6e3a,0x732b,0x7ad7, /* 0xD9D8-0xD9DF */
	0x82d7,0x9328,0x52d9,0x5deb,0x61ae,0x61cb,0x620a,0x62c7, /* 0xD9E0-0xD9E7 */
	0x64ab,0x65e0,0x6959,0x6b66,0x6bcb,0x7121,0x73f7,0x755d, /* 0xD9E8-0xD9EF */
	0x7e46,0x821e,0x8302,0x856a,0x8aa3,0x8cbf,0x9727,0x9d61, /* 0xD9F0-0xD9F7 */
	0x58a8,0x9ed8,0x5011,0x520e,0x543b,0x554f,0x6587,0x0000, /* 0xD9F8-0xD9FF */
	/* codebase=0xda80 rawbase=0x3d40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA80-0xDA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA88-0xDA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA90-0xDA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDA98-0xDA9F */
	0x0000,0x6c76,0x7d0a,0x7d0b,0x805e,0x868a,0x9580,0x96ef, /* 0xDAA0-0xDAA7 */
	0x52ff,0x6c95,0x7269,0x5473,0x5a9a,0x5c3e,0x5d4b,0x5f4c, /* 0xDAA8-0xDAAF */
	0x5fae,0x672a,0x68b6,0x6963,0x6e3c,0x6e44,0x7709,0x7c73, /* 0xDAB0-0xDAB7 */
	0x7f8e,0x8587,0x8b0e,0x8ff7,0x9761,0x9ef4,0x5cb7,0x60b6, /* 0xDAB8-0xDABF */
	/* codebase=0xdac0 rawbase=0x3d80 */
	0x610d,0x61ab,0x654f,0x65fb,0x65fc,0x6c11,0x6cef,0x739f, /* 0xDAC0-0xDAC7 */
	0x73c9,0x7de1,0x9594,0x5bc6,0x871c,0x8b10,0x525d,0x535a, /* 0xDAC8-0xDACF */
	0x62cd,0x640f,0x64b2,0x6734,0x6a38,0x6cca,0x73c0,0x749e, /* 0xDAD0-0xDAD7 */
	0x7b94,0x7c95,0x7e1b,0x818a,0x8236,0x8584,0x8feb,0x96f9, /* 0xDAD8-0xDADF */
	0x99c1,0x4f34,0x534a,0x53cd,0x53db,0x62cc,0x642c,0x6500, /* 0xDAE0-0xDAE7 */
	0x6591,0x69c3,0x6cee,0x6f58,0x73ed,0x7554,0x7622,0x76e4, /* 0xDAE8-0xDAEF */
	0x76fc,0x78d0,0x78fb,0x792c,0x7d46,0x822c,0x87e0,0x8fd4, /* 0xDAF0-0xDAF7 */
	0x9812,0x98ef,0x52c3,0x62d4,0x64a5,0x6e24,0x6f51,0x0000, /* 0xDAF8-0xDAFF */
	/* codebase=0xdb80 rawbase=0x3dc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB80-0xDB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB88-0xDB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB90-0xDB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDB98-0xDB9F */
	0x0000,0x767c,0x8dcb,0x91b1,0x9262,0x9aee,0x9b43,0x5023, /* 0xDBA0-0xDBA7 */
	0x508d,0x574a,0x59a8,0x5c28,0x5e47,0x5f77,0x623f,0x653e, /* 0xDBA8-0xDBAF */
	0x65b9,0x65c1,0x6609,0x678b,0x699c,0x6ec2,0x78c5,0x7d21, /* 0xDBB0-0xDBB7 */
	0x80aa,0x8180,0x822b,0x82b3,0x84a1,0x868c,0x8a2a,0x8b17, /* 0xDBB8-0xDBBF */
	/* codebase=0xdbc0 rawbase=0x3e00 */
	0x90a6,0x9632,0x9f90,0x500d,0x4ff3,0xf963,0x57f9,0x5f98, /* 0xDBC0-0xDBC7 */
	0x62dc,0x6392,0x676f,0x6e43,0x7119,0x76c3,0x80cc,0x80da, /* 0xDBC8-0xDBCF */
	0x88f4,0x88f5,0x8919,0x8ce0,0x8f29,0x914d,0x966a,0x4f2f, /* 0xDBD0-0xDBD7 */
	0x4f70,0x5e1b,0x67cf,0x6822,0x767d,0x767e,0x9b44,0x5e61, /* 0xDBD8-0xDBDF */
	0x6a0a,0x7169,0x71d4,0x756a,0xf964,0x7e41,0x8543,0x85e9, /* 0xDBE0-0xDBE7 */
	0x98dc,0x4f10,0x7b4f,0x7f70,0x95a5,0x51e1,0x5e06,0x68b5, /* 0xDBE8-0xDBEF */
	0x6c3e,0x6c4e,0x6cdb,0x72af,0x7bc4,0x8303,0x6cd5,0x743a, /* 0xDBF0-0xDBF7 */
	0x50fb,0x5288,0x58c1,0x64d8,0x6a97,0x74a7,0x7656,0x0000, /* 0xDBF8-0xDBFF */
	/* codebase=0xdc80 rawbase=0x3e40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC80-0xDC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC88-0xDC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC90-0xDC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDC98-0xDC9F */
	0x0000,0x78a7,0x8617,0x95e2,0x9739,0xf965,0x535e,0x5f01, /* 0xDCA0-0xDCA7 */
	0x8b8a,0x8fa8,0x8faf,0x908a,0x5225,0x77a5,0x9c49,0x9f08, /* 0xDCA8-0xDCAF */
	0x4e19,0x5002,0x5175,0x5c5b,0x5e77,0x661e,0x663a,0x67c4, /* 0xDCB0-0xDCB7 */
	0x68c5,0x70b3,0x7501,0x75c5,0x79c9,0x7add,0x8f27,0x9920, /* 0xDCB8-0xDCBF */
	/* codebase=0xdcc0 rawbase=0x3e80 */
	0x9a08,0x4fdd,0x5821,0x5831,0x5bf6,0x666e,0x6b65,0x6d11, /* 0xDCC0-0xDCC7 */
	0x6e7a,0x6f7d,0x73e4,0x752b,0x83e9,0x88dc,0x8913,0x8b5c, /* 0xDCC8-0xDCCF */
	0x8f14,0x4f0f,0x50d5,0x5310,0x535c,0x5b93,0x5fa9,0x670d, /* 0xDCD0-0xDCD7 */
	0x798f,0x8179,0x832f,0x8514,0x8907,0x8986,0x8f39,0x8f3b, /* 0xDCD8-0xDCDF */
	0x99a5,0x9c12,0x672c,0x4e76,0x4ff8,0x5949,0x5c01,0x5cef, /* 0xDCE0-0xDCE7 */
	0x5cf0,0x6367,0x68d2,0x70fd,0x71a2,0x742b,0x7e2b,0x84ec, /* 0xDCE8-0xDCEF */
	0x8702,0x9022,0x92d2,0x9cf3,0x4e0d,0x4ed8,0x4fef,0x5085, /* 0xDCF0-0xDCF7 */
	0x5256,0x526f,0x5426,0x5490,0x57e0,0x592b,0x5a66,0x0000, /* 0xDCF8-0xDCFF */
	/* codebase=0xdd80 rawbase=0x3ec0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD80-0xDD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD88-0xDD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD90-0xDD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDD98-0xDD9F */
	0x0000,0x5b5a,0x5b75,0x5bcc,0x5e9c,0xf966,0x6276,0x6577, /* 0xDDA0-0xDDA7 */
	0x65a7,0x6d6e,0x6ea5,0x7236,0x7b26,0x7c3f,0x7f36,0x8150, /* 0xDDA8-0xDDAF */
	0x8151,0x819a,0x8240,0x8299,0x83a9,0x8a03,0x8ca0,0x8ce6, /* 0xDDB0-0xDDB7 */
	0x8cfb,0x8d74,0x8dba,0x90e8,0x91dc,0x961c,0x9644,0x99d9, /* 0xDDB8-0xDDBF */
	/* codebase=0xddc0 rawbase=0x3f00 */
	0x9ce7,0x5317,0x5206,0x5429,0x5674,0x58b3,0x5954,0x596e, /* 0xDDC0-0xDDC7 */
	0x5fff,0x61a4,0x626e,0x6610,0x6c7e,0x711a,0x76c6,0x7c89, /* 0xDDC8-0xDDCF */
	0x7cde,0x7d1b,0x82ac,0x8cc1,0x96f0,0xf967,0x4f5b,0x5f17, /* 0xDDD0-0xDDD7 */
	0x5f7f,0x62c2,0x5d29,0x670b,0x68da,0x787c,0x7e43,0x9d6c, /* 0xDDD8-0xDDDF */
	0x4e15,0x5099,0x5315,0x532a,0x5351,0x5983,0x5a62,0x5e87, /* 0xDDE0-0xDDE7 */
	0x60b2,0x618a,0x6249,0x6279,0x6590,0x6787,0x69a7,0x6bd4, /* 0xDDE8-0xDDEF */
	0x6bd6,0x6bd7,0x6bd8,0x6cb8,0xf968,0x7435,0x75fa,0x7812, /* 0xDDF0-0xDDF7 */
	0x7891,0x79d5,0x79d8,0x7c83,0x7dcb,0x7fe1,0x80a5,0x0000, /* 0xDDF8-0xDDFF */
	/* codebase=0xde80 rawbase=0x3f40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE80-0xDE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE88-0xDE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE90-0xDE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDE98-0xDE9F */
	0x0000,0x813e,0x81c2,0x83f2,0x871a,0x88e8,0x8ab9,0x8b6c, /* 0xDEA0-0xDEA7 */
	0x8cbb,0x9119,0x975e,0x98db,0x9f3b,0x56ac,0x5b2a,0x5f6c, /* 0xDEA8-0xDEAF */
	0x658c,0x6ab3,0x6baf,0x6d5c,0x6ff1,0x7015,0x725d,0x73ad, /* 0xDEB0-0xDEB7 */
	0x8ca7,0x8cd3,0x983b,0x6191,0x6c37,0x8058,0x9a01,0x4e4d, /* 0xDEB8-0xDEBF */
	/* codebase=0xdec0 rawbase=0x3f80 */
	0x4e8b,0x4e9b,0x4ed5,0x4f3a,0x4f3c,0x4f7f,0x4fdf,0x50ff, /* 0xDEC0-0xDEC7 */
	0x53f2,0x53f8,0x5506,0x55e3,0x56db,0x58eb,0x5962,0x5a11, /* 0xDEC8-0xDECF */
	0x5beb,0x5bfa,0x5c04,0x5df3,0x5e2b,0x5f99,0x601d,0x6368, /* 0xDED0-0xDED7 */
	0x659c,0x65af,0x67f6,0x67fb,0x68ad,0x6b7b,0x6c99,0x6cd7, /* 0xDED8-0xDEDF */
	0x6e23,0x7009,0x7345,0x7802,0x793e,0x7940,0x7960,0x79c1, /* 0xDEE0-0xDEE7 */
	0x7be9,0x7d17,0x7d72,0x8086,0x820d,0x838e,0x84d1,0x86c7, /* 0xDEE8-0xDEEF */
	0x88df,0x8a50,0x8a5e,0x8b1d,0x8cdc,0x8d66,0x8fad,0x90aa, /* 0xDEF0-0xDEF7 */
	0x98fc,0x99df,0x9e9d,0x524a,0xf969,0x6714,0xf96a,0x0000, /* 0xDEF8-0xDEFF */
	/* codebase=0xdf80 rawbase=0x3fc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF80-0xDF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF88-0xDF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF90-0xDF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xDF98-0xDF9F */
	0x0000,0x5098,0x522a,0x5c71,0x6563,0x6c55,0x73ca,0x7523, /* 0xDFA0-0xDFA7 */
	0x759d,0x7b97,0x849c,0x9178,0x9730,0x4e77,0x6492,0x6bba, /* 0xDFA8-0xDFAF */
	0x715e,0x85a9,0x4e09,0xf96b,0x6749,0x68ee,0x6e17,0x829f, /* 0xDFB0-0xDFB7 */
	0x8518,0x886b,0x63f7,0x6f81,0x9212,0x98af,0x4e0a,0x50b7, /* 0xDFB8-0xDFBF */
	/* codebase=0xdfc0 rawbase=0x4000 */
	0x50cf,0x511f,0x5546,0x55aa,0x5617,0x5b40,0x5c19,0x5ce0, /* 0xDFC0-0xDFC7 */
	0x5e38,0x5e8a,0x5ea0,0x5ec2,0x60f3,0x6851,0x6a61,0x6e58, /* 0xDFC8-0xDFCF */
	0x723d,0x7240,0x72c0,0x76f8,0x7965,0x7bb1,0x7fd4,0x88f3, /* 0xDFD0-0xDFD7 */
	0x89f4,0x8a73,0x8c61,0x8cde,0x971c,0x585e,0x74bd,0x8cfd, /* 0xDFD8-0xDFDF */
	0x55c7,0xf96c,0x7a61,0x7d22,0x8272,0x7272,0x751f,0x7525, /* 0xDFE0-0xDFE7 */
	0xf96d,0x7b19,0x5885,0x58fb,0x5dbc,0x5e8f,0x5eb6,0x5f90, /* 0xDFE8-0xDFEF */
	0x6055,0x6292,0x637f,0x654d,0x6691,0x66d9,0x66f8,0x6816, /* 0xDFF0-0xDFF7 */
	0x68f2,0x7280,0x745e,0x7b6e,0x7d6e,0x7dd6,0x7f72,0x0000, /* 0xDFF8-0xDFFF */
	/* codebase=0xe080 rawbase=0x4040 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE080-0xE087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE088-0xE08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE090-0xE097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE098-0xE09F */
	0x0000,0x80e5,0x8212,0x85af,0x897f,0x8a93,0x901d,0x92e4, /* 0xE0A0-0xE0A7 */
	0x9ecd,0x9f20,0x5915,0x596d,0x5e2d,0x60dc,0x6614,0x6673, /* 0xE0A8-0xE0AF */
	0x6790,0x6c50,0x6dc5,0x6f5f,0x77f3,0x78a9,0x84c6,0x91cb, /* 0xE0B0-0xE0B7 */
	0x932b,0x4ed9,0x50ca,0x5148,0x5584,0x5b0b,0x5ba3,0x6247, /* 0xE0B8-0xE0BF */
	/* codebase=0xe0c0 rawbase=0x4080 */
	0x657e,0x65cb,0x6e32,0x717d,0x7401,0x7444,0x7487,0x74bf, /* 0xE0C0-0xE0C7 */
	0x766c,0x79aa,0x7dda,0x7e55,0x7fa8,0x817a,0x81b3,0x8239, /* 0xE0C8-0xE0CF */
	0x861a,0x87ec,0x8a75,0x8de3,0x9078,0x9291,0x9425,0x994d, /* 0xE0D0-0xE0D7 */
	0x9bae,0x5368,0x5c51,0x6954,0x6cc4,0x6d29,0x6e2b,0x820c, /* 0xE0D8-0xE0DF */
	0x859b,0x893b,0x8a2d,0x8aaa,0x96ea,0x9f67,0x5261,0x66b9, /* 0xE0E0-0xE0E7 */
	0x6bb2,0x7e96,0x87fe,0x8d0d,0x9583,0x965d,0x651d,0x6d89, /* 0xE0E8-0xE0EF */
	0x71ee,0xf96e,0x57ce,0x59d3,0x5bac,0x6027,0x60fa,0x6210, /* 0xE0F0-0xE0F7 */
	0x661f,0x665f,0x7329,0x73f9,0x76db,0x7701,0x7b6c,0x0000, /* 0xE0F8-0xE0FF */
	/* codebase=0xe180 rawbase=0x40c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE180-0xE187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE188-0xE18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE190-0xE197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE198-0xE19F */
	0x0000,0x8056,0x8072,0x8165,0x8aa0,0x9192,0x4e16,0x52e2, /* 0xE1A0-0xE1A7 */
	0x6b72,0x6d17,0x7a05,0x7b39,0x7d30,0xf96f,0x8cb0,0x53ec, /* 0xE1A8-0xE1AF */
	0x562f,0x5851,0x5bb5,0x5c0f,0x5c11,0x5de2,0x6240,0x6383, /* 0xE1B0-0xE1B7 */
	0x6414,0x662d,0x68b3,0x6cbc,0x6d88,0x6eaf,0x701f,0x70a4, /* 0xE1B8-0xE1BF */
	/* codebase=0xe1c0 rawbase=0x4100 */
	0x71d2,0x7526,0x758f,0x758e,0x7619,0x7b11,0x7be0,0x7c2b, /* 0xE1C0-0xE1C7 */
	0x7d20,0x7d39,0x852c,0x856d,0x8607,0x8a34,0x900d,0x9061, /* 0xE1C8-0xE1CF */
	0x90b5,0x92b7,0x97f6,0x9a37,0x4fd7,0x5c6c,0x675f,0x6d91, /* 0xE1D0-0xE1D7 */
	0x7c9f,0x7e8c,0x8b16,0x8d16,0x901f,0x5b6b,0x5dfd,0x640d, /* 0xE1D8-0xE1DF */
	0x84c0,0x905c,0x98e1,0x7387,0x5b8b,0x609a,0x677e,0x6dde, /* 0xE1E0-0xE1E7 */
	0x8a1f,0x8aa6,0x9001,0x980c,0x5237,0xf970,0x7051,0x788e, /* 0xE1E8-0xE1EF */
	0x9396,0x8870,0x91d7,0x4fee,0x53d7,0x55fd,0x56da,0x5782, /* 0xE1F0-0xE1F7 */
	0x58fd,0x5ac2,0x5b88,0x5cab,0x5cc0,0x5e25,0x6101,0x0000, /* 0xE1F8-0xE1FF */
	/* codebase=0xe280 rawbase=0x4140 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE280-0xE287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE288-0xE28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE290-0xE297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE298-0xE29F */
	0x0000,0x620d,0x624b,0x6388,0x641c,0x6536,0x6578,0x6a39, /* 0xE2A0-0xE2A7 */
	0x6b8a,0x6c34,0x6d19,0x6f31,0x71e7,0x72e9,0x7378,0x7407, /* 0xE2A8-0xE2AF */
	0x74b2,0x7626,0x7761,0x79c0,0x7a57,0x7aea,0x7cb9,0x7d8f, /* 0xE2B0-0xE2B7 */
	0x7dac,0x7e61,0x7f9e,0x8129,0x8331,0x8490,0x84da,0x85ea, /* 0xE2B8-0xE2BF */
	/* codebase=0xe2c0 rawbase=0x4180 */
	0x8896,0x8ab0,0x8b90,0x8f38,0x9042,0x9083,0x916c,0x9296, /* 0xE2C0-0xE2C7 */
	0x92b9,0x968b,0x96a7,0x96a8,0x96d6,0x9700,0x9808,0x9996, /* 0xE2C8-0xE2CF */
	0x9ad3,0x9b1a,0x53d4,0x587e,0x5919,0x5b70,0x5bbf,0x6dd1, /* 0xE2D0-0xE2D7 */
	0x6f5a,0x719f,0x7421,0x74b9,0x8085,0x83fd,0x5de1,0x5f87, /* 0xE2D8-0xE2DF */
	0x5faa,0x6042,0x65ec,0x6812,0x696f,0x6a53,0x6b89,0x6d35, /* 0xE2E0-0xE2E7 */
	0x6df3,0x73e3,0x76fe,0x77ac,0x7b4d,0x7d14,0x8123,0x821c, /* 0xE2E8-0xE2EF */
	0x8340,0x84f4,0x8563,0x8a62,0x8ac4,0x9187,0x931e,0x9806, /* 0xE2F0-0xE2F7 */
	0x99b4,0x620c,0x8853,0x8ff0,0x9265,0x5d07,0x5d27,0x0000, /* 0xE2F8-0xE2FF */
	/* codebase=0xe380 rawbase=0x41c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE380-0xE387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE388-0xE38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE390-0xE397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE398-0xE39F */
	0x0000,0x5d69,0x745f,0x819d,0x8768,0x6fd5,0x62fe,0x7fd2, /* 0xE3A0-0xE3A7 */
	0x8936,0x8972,0x4e1e,0x4e58,0x50e7,0x52dd,0x5347,0x627f, /* 0xE3A8-0xE3AF */
	0x6607,0x7e69,0x8805,0x965e,0x4f8d,0x5319,0x5636,0x59cb, /* 0xE3B0-0xE3B7 */
	0x5aa4,0x5c38,0x5c4e,0x5c4d,0x5e02,0x5f11,0x6043,0x65bd, /* 0xE3B8-0xE3BF */
	/* codebase=0xe3c0 rawbase=0x4200 */
	0x662f,0x6642,0x67be,0x67f4,0x731c,0x77e2,0x793a,0x7fc5, /* 0xE3C0-0xE3C7 */
	0x8494,0x84cd,0x8996,0x8a66,0x8a69,0x8ae1,0x8c55,0x8c7a, /* 0xE3C8-0xE3CF */
	0x57f4,0x5bd4,0x5f0f,0x606f,0x62ed,0x690d,0x6b96,0x6e5c, /* 0xE3D0-0xE3D7 */
	0x7184,0x7bd2,0x8755,0x8b58,0x8efe,0x98df,0x98fe,0x4f38, /* 0xE3D8-0xE3DF */
	0x4f81,0x4fe1,0x547b,0x5a20,0x5bb8,0x613c,0x65b0,0x6668, /* 0xE3E0-0xE3E7 */
	0x71fc,0x7533,0x795e,0x7d33,0x814e,0x81e3,0x8398,0x85aa, /* 0xE3E8-0xE3EF */
	0x85ce,0x8703,0x8a0a,0x8eab,0x8f9b,0xf971,0x8fc5,0x5931, /* 0xE3F0-0xE3F7 */
	0x5ba4,0x5be6,0x6089,0x5be9,0x5c0b,0x5fc3,0x6c81,0x0000, /* 0xE3F8-0xE3FF */
	/* codebase=0xe480 rawbase=0x4240 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE480-0xE487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE488-0xE48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE490-0xE497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE498-0xE49F */
	0x0000,0xf972,0x6df1,0x700b,0x751a,0x82af,0x8af6,0x4ec0, /* 0xE4A0-0xE4A7 */
	0x5341,0xf973,0x96d9,0x6c0f,0x4e9e,0x4fc4,0x5152,0x555e, /* 0xE4A8-0xE4AF */
	0x5a25,0x5ce8,0x6211,0x7259,0x82bd,0x83aa,0x86fe,0x8859, /* 0xE4B0-0xE4B7 */
	0x8a1d,0x963f,0x96c5,0x9913,0x9d09,0x9d5d,0x580a,0x5cb3, /* 0xE4B8-0xE4BF */
	/* codebase=0xe4c0 rawbase=0x4280 */
	0x5dbd,0x5e44,0x60e1,0x6115,0x63e1,0x6a02,0x6e25,0x9102, /* 0xE4C0-0xE4C7 */
	0x9354,0x984e,0x9c10,0x9f77,0x5b89,0x5cb8,0x6309,0x664f, /* 0xE4C8-0xE4CF */
	0x6848,0x773c,0x96c1,0x978d,0x9854,0x9b9f,0x65a1,0x8b01, /* 0xE4D0-0xE4D7 */
	0x8ecb,0x95bc,0x5535,0x5ca9,0x5dd6,0x5eb5,0x6697,0x764c, /* 0xE4D8-0xE4DF */
	0x83f4,0x95c7,0x58d3,0x62bc,0x72ce,0x9d28,0x4ef0,0x592e, /* 0xE4E0-0xE4E7 */
	0x600f,0x663b,0x6b83,0x79e7,0x9d26,0x5393,0x54c0,0x57c3, /* 0xE4E8-0xE4EF */
	0x5d16,0x611b,0x66d6,0x6daf,0x788d,0x827e,0x9698,0x9744, /* 0xE4F0-0xE4F7 */
	0x5384,0x627c,0x6396,0x6db2,0x7e0a,0x814b,0x984d,0x0000, /* 0xE4F8-0xE4FF */
	/* codebase=0xe580 rawbase=0x42c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE580-0xE587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE588-0xE58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE590-0xE597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE598-0xE59F */
	0x0000,0x6afb,0x7f4c,0x9daf,0x9e1a,0x4e5f,0x503b,0x51b6, /* 0xE5A0-0xE5A7 */
	0x591c,0x60f9,0x63f6,0x6930,0x723a,0x8036,0xf974,0x91ce, /* 0xE5A8-0xE5AF */
	0x5f31,0xf975,0xf976,0x7d04,0x82e5,0x846f,0x84bb,0x85e5, /* 0xE5B0-0xE5B7 */
	0x8e8d,0xf977,0x4f6f,0xf978,0xf979,0x58e4,0x5b43,0x6059, /* 0xE5B8-0xE5BF */
	/* codebase=0xe5c0 rawbase=0x4300 */
	0x63da,0x6518,0x656d,0x6698,0xf97a,0x694a,0x6a23,0x6d0b, /* 0xE5C0-0xE5C7 */
	0x7001,0x716c,0x75d2,0x760d,0x79b3,0x7a70,0xf97b,0x7f8a, /* 0xE5C8-0xE5CF */
	0xf97c,0x8944,0xf97d,0x8b93,0x91c0,0x967d,0xf97e,0x990a, /* 0xE5D0-0xE5D7 */
	0x5704,0x5fa1,0x65bc,0x6f01,0x7600,0x79a6,0x8a9e,0x99ad, /* 0xE5D8-0xE5DF */
	0x9b5a,0x9f6c,0x5104,0x61b6,0x6291,0x6a8d,0x81c6,0x5043, /* 0xE5E0-0xE5E7 */
	0x5830,0x5f66,0x7109,0x8a00,0x8afa,0x5b7c,0x8616,0x4ffa, /* 0xE5E8-0xE5EF */
	0x513c,0x56b4,0x5944,0x63a9,0x6df9,0x5daa,0x696d,0x5186, /* 0xE5F0-0xE5F7 */
	0x4e88,0x4f59,0xf97f,0xf980,0xf981,0x5982,0xf982,0x0000, /* 0xE5F8-0xE5FF */
	/* codebase=0xe680 rawbase=0x4340 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE680-0xE687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE688-0xE68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE690-0xE697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE698-0xE69F */
	0x0000,0xf983,0x6b5f,0x6c5d,0xf984,0x74b5,0x7916,0xf985, /* 0xE6A0-0xE6A7 */
	0x8207,0x8245,0x8339,0x8f3f,0x8f5d,0xf986,0x9918,0xf987, /* 0xE6A8-0xE6AF */
	0xf988,0xf989,0x4ea6,0xf98a,0x57df,0x5f79,0x6613,0xf98b, /* 0xE6B0-0xE6B7 */
	0xf98c,0x75ab,0x7e79,0x8b6f,0xf98d,0x9006,0x9a5b,0x56a5, /* 0xE6B8-0xE6BF */
	/* codebase=0xe6c0 rawbase=0x4380 */
	0x5827,0x59f8,0x5a1f,0x5bb4,0xf98e,0x5ef6,0xf98f,0xf990, /* 0xE6C0-0xE6C7 */
	0x6350,0x633b,0xf991,0x693d,0x6c87,0x6cbf,0x6d8e,0x6d93, /* 0xE6C8-0xE6CF */
	0x6df5,0x6f14,0xf992,0x70df,0x7136,0x7159,0xf993,0x71c3, /* 0xE6D0-0xE6D7 */
	0x71d5,0xf994,0x784f,0x786f,0xf995,0x7b75,0x7de3,0xf996, /* 0xE6D8-0xE6DF */
	0x7e2f,0xf997,0x884d,0x8edf,0xf998,0xf999,0xf99a,0x925b, /* 0xE6E0-0xE6E7 */
	0xf99b,0x9cf6,0xf99c,0xf99d,0xf99e,0x6085,0x6d85,0xf99f, /* 0xE6E8-0xE6EF */
	0x71b1,0xf9a0,0xf9a1,0x95b1,0x53ad,0xf9a2,0xf9a3,0xf9a4, /* 0xE6F0-0xE6F7 */
	0x67d3,0xf9a5,0x708e,0x7130,0x7430,0x8276,0x82d2,0x0000, /* 0xE6F8-0xE6FF */
	/* codebase=0xe780 rawbase=0x43c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE780-0xE787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE788-0xE78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE790-0xE797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE798-0xE79F */
	0x0000,0xf9a6,0x95bb,0x9ae5,0x9e7d,0x66c4,0xf9a7,0x71c1, /* 0xE7A0-0xE7A7 */
	0x8449,0xf9a8,0xf9a9,0x584b,0xf9aa,0xf9ab,0x5db8,0x5f71, /* 0xE7A8-0xE7AF */
	0xf9ac,0x6620,0x668e,0x6979,0x69ae,0x6c38,0x6cf3,0x6e36, /* 0xE7B0-0xE7B7 */
	0x6f41,0x6fda,0x701b,0x702f,0x7150,0x71df,0x7370,0xf9ad, /* 0xE7B8-0xE7BF */
	/* codebase=0xe7c0 rawbase=0x4400 */
	0x745b,0xf9ae,0x74d4,0x76c8,0x7a4e,0x7e93,0xf9af,0xf9b0, /* 0xE7C0-0xE7C7 */
	0x82f1,0x8a60,0x8fce,0xf9b1,0x9348,0xf9b2,0x9719,0xf9b3, /* 0xE7C8-0xE7CF */
	0xf9b4,0x4e42,0x502a,0xf9b5,0x5208,0x53e1,0x66f3,0x6c6d, /* 0xE7D0-0xE7D7 */
	0x6fca,0x730a,0x777f,0x7a62,0x82ae,0x85dd,0x8602,0xf9b6, /* 0xE7D8-0xE7DF */
	0x88d4,0x8a63,0x8b7d,0x8c6b,0xf9b7,0x92b3,0xf9b8,0x9713, /* 0xE7E0-0xE7E7 */
	0x9810,0x4e94,0x4f0d,0x4fc9,0x50b2,0x5348,0x543e,0x5433, /* 0xE7E8-0xE7EF */
	0x55da,0x5862,0x58ba,0x5967,0x5a1b,0x5be4,0x609f,0xf9b9, /* 0xE7F0-0xE7F7 */
	0x61ca,0x6556,0x65ff,0x6664,0x68a7,0x6c5a,0x6fb3,0x0000, /* 0xE7F8-0xE7FF */
	/* codebase=0xe880 rawbase=0x4440 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE880-0xE887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE888-0xE88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE890-0xE897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE898-0xE89F */
	0x0000,0x70cf,0x71ac,0x7352,0x7b7d,0x8708,0x8aa4,0x9c32, /* 0xE8A0-0xE8A7 */
	0x9f07,0x5c4b,0x6c83,0x7344,0x7389,0x923a,0x6eab,0x7465, /* 0xE8A8-0xE8AF */
	0x761f,0x7a69,0x7e15,0x860a,0x5140,0x58c5,0x64c1,0x74ee, /* 0xE8B0-0xE8B7 */
	0x7515,0x7670,0x7fc1,0x9095,0x96cd,0x9954,0x6e26,0x74e6, /* 0xE8B8-0xE8BF */
	/* codebase=0xe8c0 rawbase=0x4480 */
	0x7aa9,0x7aaa,0x81e5,0x86d9,0x8778,0x8a1b,0x5a49,0x5b8c, /* 0xE8C0-0xE8C7 */
	0x5b9b,0x68a1,0x6900,0x6d63,0x73a9,0x7413,0x742c,0x7897, /* 0xE8C8-0xE8CF */
	0x7de9,0x7feb,0x8118,0x8155,0x839e,0x8c4c,0x962e,0x9811, /* 0xE8D0-0xE8D7 */
	0x66f0,0x5f80,0x65fa,0x6789,0x6c6a,0x738b,0x502d,0x5a03, /* 0xE8D8-0xE8DF */
	0x6b6a,0x77ee,0x5916,0x5d6c,0x5dcd,0x7325,0x754f,0xf9ba, /* 0xE8E0-0xE8E7 */
	0xf9bb,0x50e5,0x51f9,0x582f,0x592d,0x5996,0x59da,0x5be5, /* 0xE8E8-0xE8EF */
	0xf9bc,0xf9bd,0x5da2,0x62d7,0x6416,0x6493,0x64fe,0xf9be, /* 0xE8F0-0xE8F7 */
	0x66dc,0xf9bf,0x6a48,0xf9c0,0x71ff,0x7464,0xf9c1,0x0000, /* 0xE8F8-0xE8FF */
	/* codebase=0xe980 rawbase=0x44c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE980-0xE987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE988-0xE98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE990-0xE997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xE998-0xE99F */
	0x0000,0x7a88,0x7aaf,0x7e47,0x7e5e,0x8000,0x8170,0xf9c2, /* 0xE9A0-0xE9A7 */
	0x87ef,0x8981,0x8b20,0x9059,0xf9c3,0x9080,0x9952,0x617e, /* 0xE9A8-0xE9AF */
	0x6b32,0x6d74,0x7e1f,0x8925,0x8fb1,0x4fd1,0x50ad,0x5197, /* 0xE9B0-0xE9B7 */
	0x52c7,0x57c7,0x5889,0x5bb9,0x5eb8,0x6142,0x6995,0x6d8c, /* 0xE9B8-0xE9BF */
	/* codebase=0xe9c0 rawbase=0x4500 */
	0x6e67,0x6eb6,0x7194,0x7462,0x7528,0x752c,0x8073,0x8338, /* 0xE9C0-0xE9C7 */
	0x84c9,0x8e0a,0x9394,0x93de,0xf9c4,0x4e8e,0x4f51,0x5076, /* 0xE9C8-0xE9CF */
	0x512a,0x53c8,0x53cb,0x53f3,0x5b87,0x5bd3,0x5c24,0x611a, /* 0xE9D0-0xE9D7 */
	0x6182,0x65f4,0x725b,0x7397,0x7440,0x76c2,0x7950,0x7991, /* 0xE9D8-0xE9DF */
	0x79b9,0x7d06,0x7fbd,0x828b,0x85d5,0x865e,0x8fc2,0x9047, /* 0xE9E0-0xE9E7 */
	0x90f5,0x91ea,0x9685,0x96e8,0x96e9,0x52d6,0x5f67,0x65ed, /* 0xE9E8-0xE9EF */
	0x6631,0x682f,0x715c,0x7a36,0x90c1,0x980a,0x4e91,0xf9c5, /* 0xE9F0-0xE9F7 */
	0x6a52,0x6b9e,0x6f90,0x7189,0x8018,0x82b8,0x8553,0x0000, /* 0xE9F8-0xE9FF */
	/* codebase=0xea80 rawbase=0x4540 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA80-0xEA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA88-0xEA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA90-0xEA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEA98-0xEA9F */
	0x0000,0x904b,0x9695,0x96f2,0x97fb,0x851a,0x9b31,0x4e90, /* 0xEAA0-0xEAA7 */
	0x718a,0x96c4,0x5143,0x539f,0x54e1,0x5713,0x5712,0x57a3, /* 0xEAA8-0xEAAF */
	0x5a9b,0x5ac4,0x5bc3,0x6028,0x613f,0x63f4,0x6c85,0x6d39, /* 0xEAB0-0xEAB7 */
	0x6e72,0x6e90,0x7230,0x733f,0x7457,0x82d1,0x8881,0x8f45, /* 0xEAB8-0xEABF */
	/* codebase=0xeac0 rawbase=0x4580 */
	0x9060,0xf9c6,0x9662,0x9858,0x9d1b,0x6708,0x8d8a,0x925e, /* 0xEAC0-0xEAC7 */
	0x4f4d,0x5049,0x50de,0x5371,0x570d,0x59d4,0x5a01,0x5c09, /* 0xEAC8-0xEACF */
	0x6170,0x6690,0x6e2d,0x7232,0x744b,0x7def,0x80c3,0x840e, /* 0xEAD0-0xEAD7 */
	0x8466,0x853f,0x875f,0x885b,0x8918,0x8b02,0x9055,0x97cb, /* 0xEAD8-0xEADF */
	0x9b4f,0x4e73,0x4f91,0x5112,0x516a,0xf9c7,0x552f,0x55a9, /* 0xEAE0-0xEAE7 */
	0x5b7a,0x5ba5,0x5e7c,0x5e7d,0x5ebe,0x60a0,0x60df,0x6108, /* 0xEAE8-0xEAEF */
	0x6109,0x63c4,0x6538,0x6709,0xf9c8,0x67d4,0x67da,0xf9c9, /* 0xEAF0-0xEAF7 */
	0x6961,0x6962,0x6cb9,0x6d27,0xf9ca,0x6e38,0xf9cb,0x0000, /* 0xEAF8-0xEAFF */
	/* codebase=0xeb80 rawbase=0x45c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB80-0xEB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB88-0xEB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB90-0xEB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEB98-0xEB9F */
	0x0000,0x6fe1,0x7336,0x7337,0xf9cc,0x745c,0x7531,0xf9cd, /* 0xEBA0-0xEBA7 */
	0x7652,0xf9ce,0xf9cf,0x7dad,0x81fe,0x8438,0x88d5,0x8a98, /* 0xEBA8-0xEBAF */
	0x8adb,0x8aed,0x8e30,0x8e42,0x904a,0x903e,0x907a,0x9149, /* 0xEBB0-0xEBB7 */
	0x91c9,0x936e,0xf9d0,0xf9d1,0x5809,0xf9d2,0x6bd3,0x8089, /* 0xEBB8-0xEBBF */
	/* codebase=0xebc0 rawbase=0x4600 */
	0x80b2,0xf9d3,0xf9d4,0x5141,0x596b,0x5c39,0xf9d5,0xf9d6, /* 0xEBC0-0xEBC7 */
	0x6f64,0x73a7,0x80e4,0x8d07,0xf9d7,0x9217,0x958f,0xf9d8, /* 0xEBC8-0xEBCF */
	0xf9d9,0xf9da,0xf9db,0x807f,0x620e,0x701c,0x7d68,0x878d, /* 0xEBD0-0xEBD7 */
	0xf9dc,0x57a0,0x6069,0x6147,0x6bb7,0x8abe,0x9280,0x96b1, /* 0xEBD8-0xEBDF */
	0x4e59,0x541f,0x6deb,0x852d,0x9670,0x97f3,0x98ee,0x63d6, /* 0xEBE0-0xEBE7 */
	0x6ce3,0x9091,0x51dd,0x61c9,0x81ba,0x9df9,0x4f9d,0x501a, /* 0xEBE8-0xEBEF */
	0x5100,0x5b9c,0x610f,0x61ff,0x64ec,0x6905,0x6bc5,0x7591, /* 0xEBF0-0xEBF7 */
	0x77e3,0x7fa9,0x8264,0x858f,0x87fb,0x8863,0x8abc,0x0000, /* 0xEBF8-0xEBFF */
	/* codebase=0xec80 rawbase=0x4640 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC80-0xEC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC88-0xEC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC90-0xEC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEC98-0xEC9F */
	0x0000,0x8b70,0x91ab,0x4e8c,0x4ee5,0x4f0a,0xf9dd,0xf9de, /* 0xECA0-0xECA7 */
	0x5937,0x59e8,0xf9df,0x5df2,0x5f1b,0x5f5b,0x6021,0xf9e0, /* 0xECA8-0xECAF */
	0xf9e1,0xf9e2,0xf9e3,0x723e,0x73e5,0xf9e4,0x7570,0x75cd, /* 0xECB0-0xECB7 */
	0xf9e5,0x79fb,0xf9e6,0x800c,0x8033,0x8084,0x82e1,0x8351, /* 0xECB8-0xECBF */
	/* codebase=0xecc0 rawbase=0x4680 */
	0xf9e7,0xf9e8,0x8cbd,0x8cb3,0x9087,0xf9e9,0xf9ea,0x98f4, /* 0xECC0-0xECC7 */
	0x990c,0xf9eb,0xf9ec,0x7037,0x76ca,0x7fca,0x7fcc,0x7ffc, /* 0xECC8-0xECCF */
	0x8b1a,0x4eba,0x4ec1,0x5203,0x5370,0xf9ed,0x54bd,0x56e0, /* 0xECD0-0xECD7 */
	0x59fb,0x5bc5,0x5f15,0x5fcd,0x6e6e,0xf9ee,0xf9ef,0x7d6a, /* 0xECD8-0xECDF */
	0x8335,0xf9f0,0x8693,0x8a8d,0xf9f1,0x976d,0x9777,0xf9f2, /* 0xECE0-0xECE7 */
	0xf9f3,0x4e00,0x4f5a,0x4f7e,0x58f9,0x65e5,0x6ea2,0x9038, /* 0xECE8-0xECEF */
	0x93b0,0x99b9,0x4efb,0x58ec,0x598a,0x59d9,0x6041,0xf9f4, /* 0xECF0-0xECF7 */
	0xf9f5,0x7a14,0xf9f6,0x834f,0x8cc3,0x5165,0x5344,0x0000, /* 0xECF8-0xECFF */
	/* codebase=0xed80 rawbase=0x46c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED80-0xED87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED88-0xED8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED90-0xED97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xED98-0xED9F */
	0x0000,0xf9f7,0xf9f8,0xf9f9,0x4ecd,0x5269,0x5b55,0x82bf, /* 0xEDA0-0xEDA7 */
	0x4ed4,0x523a,0x54a8,0x59c9,0x59ff,0x5b50,0x5b57,0x5b5c, /* 0xEDA8-0xEDAF */
	0x6063,0x6148,0x6ecb,0x7099,0x716e,0x7386,0x74f7,0x75b5, /* 0xEDB0-0xEDB7 */
	0x78c1,0x7d2b,0x8005,0x81ea,0x8328,0x8517,0x85c9,0x8aee, /* 0xEDB8-0xEDBF */
	/* codebase=0xedc0 rawbase=0x4700 */
	0x8cc7,0x96cc,0x4f5c,0x52fa,0x56bc,0x65ab,0x6628,0x707c, /* 0xEDC0-0xEDC7 */
	0x70b8,0x7235,0x7dbd,0x828d,0x914c,0x96c0,0x9d72,0x5b71, /* 0xEDC8-0xEDCF */
	0x68e7,0x6b98,0x6f7a,0x76de,0x5c91,0x66ab,0x6f5b,0x7bb4, /* 0xEDD0-0xEDD7 */
	0x7c2a,0x8836,0x96dc,0x4e08,0x4ed7,0x5320,0x5834,0x58bb, /* 0xEDD8-0xEDDF */
	0x58ef,0x596c,0x5c07,0x5e33,0x5e84,0x5f35,0x638c,0x66b2, /* 0xEDE0-0xEDE7 */
	0x6756,0x6a1f,0x6aa3,0x6b0c,0x6f3f,0x7246,0xf9fa,0x7350, /* 0xEDE8-0xEDEF */
	0x748b,0x7ae0,0x7ca7,0x8178,0x81df,0x81e7,0x838a,0x846c, /* 0xEDF0-0xEDF7 */
	0x8523,0x8594,0x85cf,0x88dd,0x8d13,0x91ac,0x9577,0x0000, /* 0xEDF8-0xEDFF */
	/* codebase=0xee80 rawbase=0x4740 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE80-0xEE87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE88-0xEE8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE90-0xEE97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEE98-0xEE9F */
	0x0000,0x969c,0x518d,0x54c9,0x5728,0x5bb0,0x624d,0x6750, /* 0xEEA0-0xEEA7 */
	0x683d,0x6893,0x6e3d,0x6ed3,0x707d,0x7e21,0x88c1,0x8ca1, /* 0xEEA8-0xEEAF */
	0x8f09,0x9f4b,0x9f4e,0x722d,0x7b8f,0x8acd,0x931a,0x4f47, /* 0xEEB0-0xEEB7 */
	0x4f4e,0x5132,0x5480,0x59d0,0x5e95,0x62b5,0x6775,0x696e, /* 0xEEB8-0xEEBF */
	/* codebase=0xeec0 rawbase=0x4780 */
	0x6a17,0x6cae,0x6e1a,0x72d9,0x732a,0x75bd,0x7bb8,0x7d35, /* 0xEEC0-0xEEC7 */
	0x82e7,0x83f9,0x8457,0x85f7,0x8a5b,0x8caf,0x8e87,0x9019, /* 0xEEC8-0xEECF */
	0x90b8,0x96ce,0x9f5f,0x52e3,0x540a,0x5ae1,0x5bc2,0x6458, /* 0xEED0-0xEED7 */
	0x6575,0x6ef4,0x72c4,0xf9fb,0x7684,0x7a4d,0x7b1b,0x7c4d, /* 0xEED8-0xEEDF */
	0x7e3e,0x7fdf,0x837b,0x8b2b,0x8cca,0x8d64,0x8de1,0x8e5f, /* 0xEEE0-0xEEE7 */
	0x8fea,0x8ff9,0x9069,0x93d1,0x4f43,0x4f7a,0x50b3,0x5168, /* 0xEEE8-0xEEEF */
	0x5178,0x524d,0x526a,0x5861,0x587c,0x5960,0x5c08,0x5c55, /* 0xEEF0-0xEEF7 */
	0x5edb,0x609b,0x6230,0x6813,0x6bbf,0x6c08,0x6fb1,0x0000, /* 0xEEF8-0xEEFF */
	/* codebase=0xef80 rawbase=0x47c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF80-0xEF87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF88-0xEF8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF90-0xEF97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xEF98-0xEF9F */
	0x0000,0x714e,0x7420,0x7530,0x7538,0x7551,0x7672,0x7b4c, /* 0xEFA0-0xEFA7 */
	0x7b8b,0x7bad,0x7bc6,0x7e8f,0x8a6e,0x8f3e,0x8f49,0x923f, /* 0xEFA8-0xEFAF */
	0x9293,0x9322,0x942b,0x96fb,0x985a,0x986b,0x991e,0x5207, /* 0xEFB0-0xEFB7 */
	0x622a,0x6298,0x6d59,0x7664,0x7aca,0x7bc0,0x7d76,0x5360, /* 0xEFB8-0xEFBF */
	/* codebase=0xefc0 rawbase=0x4800 */
	0x5cbe,0x5e97,0x6f38,0x70b9,0x7c98,0x9711,0x9b8e,0x9ede, /* 0xEFC0-0xEFC7 */
	0x63a5,0x647a,0x8776,0x4e01,0x4e95,0x4ead,0x505c,0x5075, /* 0xEFC8-0xEFCF */
	0x5448,0x59c3,0x5b9a,0x5e40,0x5ead,0x5ef7,0x5f81,0x60c5, /* 0xEFD0-0xEFD7 */
	0x633a,0x653f,0x6574,0x65cc,0x6676,0x6678,0x67fe,0x6968, /* 0xEFD8-0xEFDF */
	0x6a89,0x6b63,0x6c40,0x6dc0,0x6de8,0x6e1f,0x6e5e,0x701e, /* 0xEFE0-0xEFE7 */
	0x70a1,0x738e,0x73fd,0x753a,0x775b,0x7887,0x798e,0x7a0b, /* 0xEFE8-0xEFEF */
	0x7a7d,0x7cbe,0x7d8e,0x8247,0x8a02,0x8aea,0x8c9e,0x912d, /* 0xEFF0-0xEFF7 */
	0x914a,0x91d8,0x9266,0x92cc,0x9320,0x9706,0x9756,0x0000, /* 0xEFF8-0xEFFF */
	/* codebase=0xf080 rawbase=0x4840 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF080-0xF087 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF088-0xF08F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF090-0xF097 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF098-0xF09F */
	0x0000,0x975c,0x9802,0x9f0e,0x5236,0x5291,0x557c,0x5824, /* 0xF0A0-0xF0A7 */
	0x5e1d,0x5f1f,0x608c,0x63d0,0x68af,0x6fdf,0x796d,0x7b2c, /* 0xF0A8-0xF0AF */
	0x81cd,0x85ba,0x88fd,0x8af8,0x8e44,0x918d,0x9664,0x969b, /* 0xF0B0-0xF0B7 */
	0x973d,0x984c,0x9f4a,0x4fce,0x5146,0x51cb,0x52a9,0x5632, /* 0xF0B8-0xF0BF */
	/* codebase=0xf0c0 rawbase=0x4880 */
	0x5f14,0x5f6b,0x63aa,0x64cd,0x65e9,0x6641,0x66fa,0x66f9, /* 0xF0C0-0xF0C7 */
	0x671d,0x689d,0x68d7,0x69fd,0x6f15,0x6f6e,0x7167,0x71e5, /* 0xF0C8-0xF0CF */
	0x722a,0x74aa,0x773a,0x7956,0x795a,0x79df,0x7a20,0x7a95, /* 0xF0D0-0xF0D7 */
	0x7c97,0x7cdf,0x7d44,0x7e70,0x8087,0x85fb,0x86a4,0x8a54, /* 0xF0D8-0xF0DF */
	0x8abf,0x8d99,0x8e81,0x9020,0x906d,0x91e3,0x963b,0x96d5, /* 0xF0E0-0xF0E7 */
	0x9ce5,0x65cf,0x7c07,0x8db3,0x93c3,0x5b58,0x5c0a,0x5352, /* 0xF0E8-0xF0EF */
	0x62d9,0x731d,0x5027,0x5b97,0x5f9e,0x60b0,0x616b,0x68d5, /* 0xF0F0-0xF0F7 */
	0x6dd9,0x742e,0x7a2e,0x7d42,0x7d9c,0x7e31,0x816b,0x0000, /* 0xF0F8-0xF0FF */
	/* codebase=0xf180 rawbase=0x48c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF180-0xF187 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF188-0xF18F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF190-0xF197 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF198-0xF19F */
	0x0000,0x8e2a,0x8e35,0x937e,0x9418,0x4f50,0x5750,0x5de6, /* 0xF1A0-0xF1A7 */
	0x5ea7,0x632b,0x7f6a,0x4e3b,0x4f4f,0x4f8f,0x505a,0x59dd, /* 0xF1A8-0xF1AF */
	0x80c4,0x546a,0x5468,0x55fe,0x594f,0x5b99,0x5dde,0x5eda, /* 0xF1B0-0xF1B7 */
	0x665d,0x6731,0x67f1,0x682a,0x6ce8,0x6d32,0x6e4a,0x6f8d, /* 0xF1B8-0xF1BF */
	/* codebase=0xf1c0 rawbase=0x4900 */
	0x70b7,0x73e0,0x7587,0x7c4c,0x7d02,0x7d2c,0x7da2,0x821f, /* 0xF1C0-0xF1C7 */
	0x86db,0x8a3b,0x8a85,0x8d70,0x8e8a,0x8f33,0x9031,0x914e, /* 0xF1C8-0xF1CF */
	0x9152,0x9444,0x99d0,0x7af9,0x7ca5,0x4fca,0x5101,0x51c6, /* 0xF1D0-0xF1D7 */
	0x57c8,0x5bef,0x5cfb,0x6659,0x6a3d,0x6d5a,0x6e96,0x6fec, /* 0xF1D8-0xF1DF */
	0x710c,0x756f,0x7ae3,0x8822,0x9021,0x9075,0x96cb,0x99ff, /* 0xF1E0-0xF1E7 */
	0x8301,0x4e2d,0x4ef2,0x8846,0x91cd,0x537d,0x6adb,0x696b, /* 0xF1E8-0xF1EF */
	0x6c41,0x847a,0x589e,0x618e,0x66fe,0x62ef,0x70dd,0x7511, /* 0xF1F0-0xF1F7 */
	0x75c7,0x7e52,0x84b8,0x8b49,0x8d08,0x4e4b,0x53ea,0x0000, /* 0xF1F8-0xF1FF */
	/* codebase=0xf280 rawbase=0x4940 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF280-0xF287 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF288-0xF28F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF290-0xF297 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF298-0xF29F */
	0x0000,0x54ab,0x5730,0x5740,0x5fd7,0x6301,0x6307,0x646f, /* 0xF2A0-0xF2A7 */
	0x652f,0x65e8,0x667a,0x679d,0x67b3,0x6b62,0x6c60,0x6c9a, /* 0xF2A8-0xF2AF */
	0x6f2c,0x77e5,0x7825,0x7949,0x7957,0x7d19,0x80a2,0x8102, /* 0xF2B0-0xF2B7 */
	0x81f3,0x829d,0x82b7,0x8718,0x8a8c,0xf9fc,0x8d04,0x8dbe, /* 0xF2B8-0xF2BF */
	/* codebase=0xf2c0 rawbase=0x4980 */
	0x9072,0x76f4,0x7a19,0x7a37,0x7e54,0x8077,0x5507,0x55d4, /* 0xF2C0-0xF2C7 */
	0x5875,0x632f,0x6422,0x6649,0x664b,0x686d,0x699b,0x6b84, /* 0xF2C8-0xF2CF */
	0x6d25,0x6eb1,0x73cd,0x7468,0x74a1,0x755b,0x75b9,0x76e1, /* 0xF2D0-0xF2D7 */
	0x771e,0x778b,0x79e6,0x7e09,0x7e1d,0x81fb,0x852f,0x8897, /* 0xF2D8-0xF2DF */
	0x8a3a,0x8cd1,0x8eeb,0x8fb0,0x9032,0x93ad,0x9663,0x9673, /* 0xF2E0-0xF2E7 */
	0x9707,0x4f84,0x53f1,0x59ea,0x5ac9,0x5e19,0x684e,0x74c6, /* 0xF2E8-0xF2EF */
	0x75be,0x79e9,0x7a92,0x81a3,0x86ed,0x8cea,0x8dcc,0x8fed, /* 0xF2F0-0xF2F7 */
	0x659f,0x6715,0xf9fd,0x57f7,0x6f57,0x7ddd,0x8f2f,0x0000, /* 0xF2F8-0xF2FF */
	/* codebase=0xf380 rawbase=0x49c0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF380-0xF387 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF388-0xF38F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF390-0xF397 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF398-0xF39F */
	0x0000,0x93f6,0x96c6,0x5fb5,0x61f2,0x6f84,0x4e14,0x4f98, /* 0xF3A0-0xF3A7 */
	0x501f,0x53c9,0x55df,0x5d6f,0x5dee,0x6b21,0x6b64,0x78cb, /* 0xF3A8-0xF3AF */
	0x7b9a,0xf9fe,0x8e49,0x8eca,0x906e,0x6349,0x643e,0x7740, /* 0xF3B0-0xF3B7 */
	0x7a84,0x932f,0x947f,0x9f6a,0x64b0,0x6faf,0x71e6,0x74a8, /* 0xF3B8-0xF3BF */
	/* codebase=0xf3c0 rawbase=0x4a00 */
	0x74da,0x7ac4,0x7c12,0x7e82,0x7cb2,0x7e98,0x8b9a,0x8d0a, /* 0xF3C0-0xF3C7 */
	0x947d,0x9910,0x994c,0x5239,0x5bdf,0x64e6,0x672d,0x7d2e, /* 0xF3C8-0xF3CF */
	0x50ed,0x53c3,0x5879,0x6158,0x6159,0x61fa,0x65ac,0x7ad9, /* 0xF3D0-0xF3D7 */
	0x8b92,0x8b96,0x5009,0x5021,0x5275,0x5531,0x5a3c,0x5ee0, /* 0xF3D8-0xF3DF */
	0x5f70,0x6134,0x655e,0x660c,0x6636,0x66a2,0x69cd,0x6ec4, /* 0xF3E0-0xF3E7 */
	0x6f32,0x7316,0x7621,0x7a93,0x8139,0x8259,0x83d6,0x84bc, /* 0xF3E8-0xF3EF */
	0x50b5,0x57f0,0x5bc0,0x5be8,0x5f69,0x63a1,0x7826,0x7db5, /* 0xF3F0-0xF3F7 */
	0x83dc,0x8521,0x91c7,0x91f5,0x518a,0x67f5,0x7b56,0x0000, /* 0xF3F8-0xF3FF */
	/* codebase=0xf480 rawbase=0x4a40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF480-0xF487 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF488-0xF48F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF490-0xF497 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF498-0xF49F */
	0x0000,0x8cac,0x51c4,0x59bb,0x60bd,0x8655,0x501c,0xf9ff, /* 0xF4A0-0xF4A7 */
	0x5254,0x5c3a,0x617d,0x621a,0x62d3,0x64f2,0x65a5,0x6ecc, /* 0xF4A8-0xF4AF */
	0x7620,0x810a,0x8e60,0x965f,0x96bb,0x4edf,0x5343,0x5598, /* 0xF4B0-0xF4B7 */
	0x5929,0x5ddd,0x64c5,0x6cc9,0x6dfa,0x7394,0x7a7f,0x821b, /* 0xF4B8-0xF4BF */
	/* codebase=0xf4c0 rawbase=0x4a80 */
	0x85a6,0x8ce4,0x8e10,0x9077,0x91e7,0x95e1,0x9621,0x97c6, /* 0xF4C0-0xF4C7 */
	0x51f8,0x54f2,0x5586,0x5fb9,0x64a4,0x6f88,0x7db4,0x8f1f, /* 0xF4C8-0xF4CF */
	0x8f4d,0x9435,0x50c9,0x5c16,0x6cbe,0x6dfb,0x751b,0x77bb, /* 0xF4D0-0xF4D7 */
	0x7c3d,0x7c64,0x8a79,0x8ac2,0x581e,0x59be,0x5e16,0x6377, /* 0xF4D8-0xF4DF */
	0x7252,0x758a,0x776b,0x8adc,0x8cbc,0x8f12,0x5ef3,0x6674, /* 0xF4E0-0xF4E7 */
	0x6df8,0x807d,0x83c1,0x8acb,0x9751,0x9bd6,0xfa00,0x5243, /* 0xF4E8-0xF4EF */
	0x66ff,0x6d95,0x6eef,0x7de0,0x8ae6,0x902e,0x905e,0x9ad4, /* 0xF4F0-0xF4F7 */
	0x521d,0x527f,0x54e8,0x6194,0x6284,0x62db,0x68a2,0x0000, /* 0xF4F8-0xF4FF */
	/* codebase=0xf580 rawbase=0x4ac0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF580-0xF587 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF588-0xF58F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF590-0xF597 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF598-0xF59F */
	0x0000,0x6912,0x695a,0x6a35,0x7092,0x7126,0x785d,0x7901, /* 0xF5A0-0xF5A7 */
	0x790e,0x79d2,0x7a0d,0x8096,0x8278,0x82d5,0x8349,0x8549, /* 0xF5A8-0xF5AF */
	0x8c82,0x8d85,0x9162,0x918b,0x91ae,0x4fc3,0x56d1,0x71ed, /* 0xF5B0-0xF5B7 */
	0x77d7,0x8700,0x89f8,0x5bf8,0x5fd6,0x6751,0x90a8,0x53e2, /* 0xF5B8-0xF5BF */
	/* codebase=0xf5c0 rawbase=0x4b00 */
	0x585a,0x5bf5,0x60a4,0x6181,0x6460,0x7e3d,0x8070,0x8525, /* 0xF5C0-0xF5C7 */
	0x9283,0x64ae,0x50ac,0x5d14,0x6700,0x589c,0x62bd,0x63a8, /* 0xF5C8-0xF5CF */
	0x690e,0x6978,0x6a1e,0x6e6b,0x76ba,0x79cb,0x82bb,0x8429, /* 0xF5D0-0xF5D7 */
	0x8acf,0x8da8,0x8ffd,0x9112,0x914b,0x919c,0x9310,0x9318, /* 0xF5D8-0xF5DF */
	0x939a,0x96db,0x9a36,0x9c0d,0x4e11,0x755c,0x795d,0x7afa, /* 0xF5E0-0xF5E7 */
	0x7b51,0x7bc9,0x7e2e,0x84c4,0x8e59,0x8e74,0x8ef8,0x9010, /* 0xF5E8-0xF5EF */
	0x6625,0x693f,0x7443,0x51fa,0x672e,0x9edc,0x5145,0x5fe0, /* 0xF5F0-0xF5F7 */
	0x6c96,0x87f2,0x885d,0x8877,0x60b4,0x81b5,0x8403,0x0000, /* 0xF5F8-0xF5FF */
	/* codebase=0xf680 rawbase=0x4b40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF680-0xF687 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF688-0xF68F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF690-0xF697 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF698-0xF69F */
	0x0000,0x8d05,0x53d6,0x5439,0x5634,0x5a36,0x5c31,0x708a, /* 0xF6A0-0xF6A7 */
	0x7fe0,0x805a,0x8106,0x81ed,0x8da3,0x9189,0x9a5f,0x9df2, /* 0xF6A8-0xF6AF */
	0x5074,0x4ec4,0x53a0,0x60fb,0x6e2c,0x5c64,0x4f88,0x5024, /* 0xF6B0-0xF6B7 */
	0x55e4,0x5cd9,0x5e5f,0x6065,0x6894,0x6cbb,0x6dc4,0x71be, /* 0xF6B8-0xF6BF */
	/* codebase=0xf6c0 rawbase=0x4b80 */
	0x75d4,0x75f4,0x7661,0x7a1a,0x7a49,0x7dc7,0x7dfb,0x7f6e, /* 0xF6C0-0xF6C7 */
	0x81f4,0x86a9,0x8f1c,0x96c9,0x99b3,0x9f52,0x5247,0x52c5, /* 0xF6C8-0xF6CF */
	0x98ed,0x89aa,0x4e03,0x67d2,0x6f06,0x4fb5,0x5be2,0x6795, /* 0xF6D0-0xF6D7 */
	0x6c88,0x6d78,0x741b,0x7827,0x91dd,0x937c,0x87c4,0x79e4, /* 0xF6D8-0xF6DF */
	0x7a31,0x5feb,0x4ed6,0x54a4,0x553e,0x58ae,0x59a5,0x60f0, /* 0xF6E0-0xF6E7 */
	0x6253,0x62d6,0x6736,0x6955,0x8235,0x9640,0x99b1,0x99dd, /* 0xF6E8-0xF6EF */
	0x502c,0x5353,0x5544,0x577c,0xfa01,0x6258,0xfa02,0x64e2, /* 0xF6F0-0xF6F7 */
	0x666b,0x67dd,0x6fc1,0x6fef,0x7422,0x7438,0x8a17,0x0000, /* 0xF6F8-0xF6FF */
	/* codebase=0xf780 rawbase=0x4bc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF780-0xF787 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF788-0xF78F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF790-0xF797 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF798-0xF79F */
	0x0000,0x9438,0x5451,0x5606,0x5766,0x5f48,0x619a,0x6b4e, /* 0xF7A0-0xF7A7 */
	0x7058,0x70ad,0x7dbb,0x8a95,0x596a,0x812b,0x63a2,0x7708, /* 0xF7A8-0xF7AF */
	0x803d,0x8caa,0x5854,0x642d,0x69bb,0x5b95,0x5e11,0x6e6f, /* 0xF7B0-0xF7B7 */
	0xfa03,0x8569,0x514c,0x53f0,0x592a,0x6020,0x614b,0x6b86, /* 0xF7B8-0xF7BF */
	/* codebase=0xf7c0 rawbase=0x4c00 */
	0x6c70,0x6cf0,0x7b1e,0x80ce,0x82d4,0x8dc6,0x90b0,0x98b1, /* 0xF7C0-0xF7C7 */
	0xfa04,0x64c7,0x6fa4,0x6491,0x6504,0x514e,0x5410,0x571f, /* 0xF7C8-0xF7CF */
	0x8a0e,0x615f,0x6876,0xfa05,0x75db,0x7b52,0x7d71,0x901a, /* 0xF7D0-0xF7D7 */
	0x5806,0x69cc,0x817f,0x892a,0x9000,0x9839,0x5078,0x5957, /* 0xF7D8-0xF7DF */
	0x59ac,0x6295,0x900f,0x9b2a,0x615d,0x7279,0x95d6,0x5761, /* 0xF7E0-0xF7E7 */
	0x5a46,0x5df4,0x628a,0x64ad,0x64fa,0x6777,0x6ce2,0x6d3e, /* 0xF7E8-0xF7EF */
	0x722c,0x7436,0x7834,0x7f77,0x82ad,0x8ddb,0x9817,0x5224, /* 0xF7F0-0xF7F7 */
	0x5742,0x677f,0x7248,0x74e3,0x8ca9,0x8fa6,0x9211,0x0000, /* 0xF7F8-0xF7FF */
	/* codebase=0xf880 rawbase=0x4c40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF880-0xF887 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF888-0xF88F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF890-0xF897 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF898-0xF89F */
	0x0000,0x962a,0x516b,0x53ed,0x634c,0x4f69,0x5504,0x6096, /* 0xF8A0-0xF8A7 */
	0x6557,0x6c9b,0x6d7f,0x724c,0x72fd,0x7a17,0x8987,0x8c9d, /* 0xF8A8-0xF8AF */
	0x5f6d,0x6f8e,0x70f9,0x81a8,0x610e,0x4fbf,0x504f,0x6241, /* 0xF8B0-0xF8B7 */
	0x7247,0x7bc7,0x7de8,0x7fe9,0x904d,0x97ad,0x9a19,0x8cb6, /* 0xF8B8-0xF8BF */
	/* codebase=0xf8c0 rawbase=0x4c80 */
	0x576a,0x5e73,0x67b0,0x840d,0x8a55,0x5420,0x5b16,0x5e63, /* 0xF8C0-0xF8C7 */
	0x5ee2,0x5f0a,0x6583,0x80ba,0x853d,0x9589,0x965b,0x4f48, /* 0xF8C8-0xF8CF */
	0x5305,0x530d,0x530f,0x5486,0x54fa,0x5703,0x5e03,0x6016, /* 0xF8D0-0xF8D7 */
	0x629b,0x62b1,0x6355,0xfa06,0x6ce1,0x6d66,0x75b1,0x7832, /* 0xF8D8-0xF8DF */
	0x80de,0x812f,0x82de,0x8461,0x84b2,0x888d,0x8912,0x900b, /* 0xF8E0-0xF8E7 */
	0x92ea,0x98fd,0x9b91,0x5e45,0x66b4,0x66dd,0x7011,0x7206, /* 0xF8E8-0xF8EF */
	0xfa07,0x4ff5,0x527d,0x5f6a,0x6153,0x6753,0x6a19,0x6f02, /* 0xF8F0-0xF8F7 */
	0x74e2,0x7968,0x8868,0x8c79,0x98c7,0x98c4,0x9a43,0x0000, /* 0xF8F8-0xF8FF */
	/* codebase=0xf980 rawbase=0x4cc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF980-0xF987 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF988-0xF98F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF990-0xF997 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xF998-0xF99F */
	0x0000,0x54c1,0x7a1f,0x6953,0x8af7,0x8c4a,0x98a8,0x99ae, /* 0xF9A0-0xF9A7 */
	0x5f7c,0x62ab,0x75b2,0x76ae,0x88ab,0x907f,0x9642,0x5339, /* 0xF9A8-0xF9AF */
	0x5f3c,0x5fc5,0x6ccc,0x73cc,0x7562,0x758b,0x7b46,0x82fe, /* 0xF9B0-0xF9B7 */
	0x999d,0x4e4f,0x903c,0x4e0b,0x4f55,0x53a6,0x590f,0x5ec8, /* 0xF9B8-0xF9BF */
	/* codebase=0xf9c0 rawbase=0x4d00 */
	0x6630,0x6cb3,0x7455,0x8377,0x8766,0x8cc0,0x9050,0x971e, /* 0xF9C0-0xF9C7 */
	0x9c15,0x58d1,0x5b78,0x8650,0x8b14,0x9db4,0x5bd2,0x6068, /* 0xF9C8-0xF9CF */
	0x608d,0x65f1,0x6c57,0x6f22,0x6fa3,0x701a,0x7f55,0x7ff0, /* 0xF9D0-0xF9D7 */
	0x9591,0x9592,0x9650,0x97d3,0x5272,0x8f44,0x51fd,0x542b, /* 0xF9D8-0xF9DF */
	0x54b8,0x5563,0x558a,0x6abb,0x6db5,0x7dd8,0x8266,0x929c, /* 0xF9E0-0xF9E7 */
	0x9677,0x9e79,0x5408,0x54c8,0x76d2,0x86e4,0x95a4,0x95d4, /* 0xF9E8-0xF9EF */
	0x965c,0x4ea2,0x4f09,0x59ee,0x5ae6,0x5df7,0x6052,0x6297, /* 0xF9F0-0xF9F7 */
	0x676d,0x6841,0x6c86,0x6e2f,0x7f38,0x809b,0x822a,0x0000, /* 0xF9F8-0xF9FF */
	/* codebase=0xfa80 rawbase=0x4d40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA80-0xFA87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA88-0xFA8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA90-0xFA97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFA98-0xFA9F */
	0x0000,0xfa08,0xfa09,0x9805,0x4ea5,0x5055,0x54b3,0x5793, /* 0xFAA0-0xFAA7 */
	0x595a,0x5b69,0x5bb3,0x61c8,0x6977,0x6d77,0x7023,0x87f9, /* 0xFAA8-0xFAAF */
	0x89e3,0x8a72,0x8ae7,0x9082,0x99ed,0x9ab8,0x52be,0x6838, /* 0xFAB0-0xFAB7 */
	0x5016,0x5e78,0x674f,0x8347,0x884c,0x4eab,0x5411,0x56ae, /* 0xFAB8-0xFABF */
	/* codebase=0xfac0 rawbase=0x4d80 */
	0x73e6,0x9115,0x97ff,0x9909,0x9957,0x9999,0x5653,0x589f, /* 0xFAC0-0xFAC7 */
	0x865b,0x8a31,0x61b2,0x6af6,0x737b,0x8ed2,0x6b47,0x96aa, /* 0xFAC8-0xFACF */
	0x9a57,0x5955,0x7200,0x8d6b,0x9769,0x4fd4,0x5cf4,0x5f26, /* 0xFAD0-0xFAD7 */
	0x61f8,0x665b,0x6ceb,0x70ab,0x7384,0x73b9,0x73fe,0x7729, /* 0xFAD8-0xFADF */
	0x774d,0x7d43,0x7d62,0x7e23,0x8237,0x8852,0xfa0a,0x8ce2, /* 0xFAE0-0xFAE7 */
	0x9249,0x986f,0x5b51,0x7a74,0x8840,0x9801,0x5acc,0x4fe0, /* 0xFAE8-0xFAEF */
	0x5354,0x593e,0x5cfd,0x633e,0x6d79,0x72f9,0x8105,0x8107, /* 0xFAF0-0xFAF7 */
	0x83a2,0x92cf,0x9830,0x4ea8,0x5144,0x5211,0x578b,0x0000, /* 0xFAF8-0xFAFF */
	/* codebase=0xfb80 rawbase=0x4dc0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB80-0xFB87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB88-0xFB8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB90-0xFB97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFB98-0xFB9F */
	0x0000,0x5f62,0x6cc2,0x6ece,0x7005,0x7050,0x70af,0x7192, /* 0xFBA0-0xFBA7 */
	0x73e9,0x7469,0x834a,0x87a2,0x8861,0x9008,0x90a2,0x93a3, /* 0xFBA8-0xFBAF */
	0x99a8,0x516e,0x5f57,0x60e0,0x6167,0x66b3,0x8559,0x8e4a, /* 0xFBB0-0xFBB7 */
	0x91af,0x978b,0x4e4e,0x4e92,0x547c,0x58d5,0x58fa,0x597d, /* 0xFBB8-0xFBBF */
	/* codebase=0xfbc0 rawbase=0x4e00 */
	0x5cb5,0x5f27,0x6236,0x6248,0x660a,0x6667,0x6beb,0x6d69, /* 0xFBC0-0xFBC7 */
	0x6dcf,0x6e56,0x6ef8,0x6f94,0x6fe0,0x6fe9,0x705d,0x72d0, /* 0xFBC8-0xFBCF */
	0x7425,0x745a,0x74e0,0x7693,0x795c,0x7cca,0x7e1e,0x80e1, /* 0xFBD0-0xFBD7 */
	0x82a6,0x846b,0x84bf,0x864e,0x865f,0x8774,0x8b77,0x8c6a, /* 0xFBD8-0xFBDF */
	0x93ac,0x9800,0x9865,0x60d1,0x6216,0x9177,0x5a5a,0x660f, /* 0xFBE0-0xFBE7 */
	0x6df7,0x6e3e,0x743f,0x9b42,0x5ffd,0x60da,0x7b0f,0x54c4, /* 0xFBE8-0xFBEF */
	0x5f18,0x6c5e,0x6cd3,0x6d2a,0x70d8,0x7d05,0x8679,0x8a0c, /* 0xFBF0-0xFBF7 */
	0x9d3b,0x5316,0x548c,0x5b05,0x6a3a,0x706b,0x7575,0x0000, /* 0xFBF8-0xFBFF */
	/* codebase=0xfc80 rawbase=0x4e40 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC80-0xFC87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC88-0xFC8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC90-0xFC97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFC98-0xFC9F */
	0x0000,0x798d,0x79be,0x82b1,0x83ef,0x8a71,0x8b41,0x8ca8, /* 0xFCA0-0xFCA7 */
	0x9774,0xfa0b,0x64f4,0x652b,0x78ba,0x78bb,0x7a6b,0x4e38, /* 0xFCA8-0xFCAF */
	0x559a,0x5950,0x5ba6,0x5e7b,0x60a3,0x63db,0x6b61,0x6665, /* 0xFCB0-0xFCB7 */
	0x6853,0x6e19,0x7165,0x74b0,0x7d08,0x9084,0x9a69,0x9c25, /* 0xFCB8-0xFCBF */
	/* codebase=0xfcc0 rawbase=0x4e80 */
	0x6d3b,0x6ed1,0x733e,0x8c41,0x95ca,0x51f0,0x5e4c,0x5fa8, /* 0xFCC0-0xFCC7 */
	0x604d,0x60f6,0x6130,0x614c,0x6643,0x6644,0x69a5,0x6cc1, /* 0xFCC8-0xFCCF */
	0x6e5f,0x6ec9,0x6f62,0x714c,0x749c,0x7687,0x7bc1,0x7c27, /* 0xFCD0-0xFCD7 */
	0x8352,0x8757,0x9051,0x968d,0x9ec3,0x532f,0x56de,0x5efb, /* 0xFCD8-0xFCDF */
	0x5f8a,0x6062,0x6094,0x61f7,0x6666,0x6703,0x6a9c,0x6dee, /* 0xFCE0-0xFCE7 */
	0x6fae,0x7070,0x736a,0x7e6a,0x81be,0x8334,0x86d4,0x8aa8, /* 0xFCE8-0xFCEF */
	0x8cc4,0x5283,0x7372,0x5b96,0x6a6b,0x9404,0x54ee,0x5686, /* 0xFCF0-0xFCF7 */
	0x5b5d,0x6548,0x6585,0x66c9,0x689f,0x6d8d,0x6dc6,0x0000, /* 0xFCF8-0xFCFF */
	/* codebase=0xfd80 rawbase=0x4ec0 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD80-0xFD87 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD88-0xFD8F */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD90-0xFD97 */
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, /* 0xFD98-0xFD9F */
	0x0000,0x723b,0x80b4,0x9175,0x9a4d,0x4faf,0x5019,0x539a, /* 0xFDA0-0xFDA7 */
	0x540e,0x543c,0x5589,0x55c5,0x5e3f,0x5f8c,0x673d,0x7166, /* 0xFDA8-0xFDAF */
	0x73dd,0x9005,0x52db,0x52f3,0x5864,0x58ce,0x7104,0x718f, /* 0xFDB0-0xFDB7 */
	0x71fb,0x85b0,0x8a13,0x6688,0x85a8,0x55a7,0x6684,0x714a, /* 0xFDB8-0xFDBF */
	/* codebase=0xfdc0 rawbase=0x4f00 */
	0x8431,0x5349,0x5599,0x6bc1,0x5f59,0x5fbd,0x63ee,0x6689, /* 0xFDC0-0xFDC7 */
	0x7147,0x8af1,0x8f1d,0x9ebe,0x4f11,0x643a,0x70cb,0x7566, /* 0xFDC8-0xFDCF */
	0x8667,0x6064,0x8b4e,0x9df8,0x5147,0x51f6,0x5308,0x6d36, /* 0xFDD0-0xFDD7 */
	0x80f8,0x9ed1,0x6615,0x6b23,0x7098,0x75d5,0x5403,0x5c79, /* 0xFDD8-0xFDDF */
	0x7d07,0x8a16,0x6b20,0x6b3d,0x6b46,0x5438,0x6070,0x6d3d, /* 0xFDE0-0xFDE7 */
	0x7fd5,0x8208,0x50d6,0x51de,0x559c,0x566b,0x56cd,0x59ec, /* 0xFDE8-0xFDEF */
	0x5b09,0x5e0c,0x6199,0x6198,0x6231,0x665e,0x66e6,0x7199, /* 0xFDF0-0xFDF7 */
	0x71b9,0x71ba,0x72a7,0x79a7,0x7a00,0x7fb2,0x8a70,0x0000, /* 0xFDF8-0xFDFF */
};
const uint16_t cp949_to_unicode_hitbl[1024] = {
	0x0000, /* 0x0000-0x003F */
	0x0040, /* 0x0040-0x007F */
	0xffff, /* 0x0080-0x00BF NOT PRESENT */
	0xffff, /* 0x00c0-0x00FF NOT PRESENT */
	0xffff, /* 0x0100-0x013F NOT PRESENT */
	0xffff, /* 0x0140-0x017F NOT PRESENT */
	0xffff, /* 0x0180-0x01BF NOT PRESENT */
	0xffff, /* 0x01c0-0x01FF NOT PRESENT */
	0xffff, /* 0x0200-0x023F NOT PRESENT */
	0xffff, /* 0x0240-0x027F NOT PRESENT */
	0xffff, /* 0x0280-0x02BF NOT PRESENT */
	0xffff, /* 0x02c0-0x02FF NOT PRESENT */
	0xffff, /* 0x0300-0x033F NOT PRESENT */
	0xffff, /* 0x0340-0x037F NOT PRESENT */
	0xffff, /* 0x0380-0x03BF NOT PRESENT */
	0xffff, /* 0x03c0-0x03FF NOT PRESENT */
	0xffff, /* 0x0400-0x043F NOT PRESENT */
	0xffff, /* 0x0440-0x047F NOT PRESENT */
	0xffff, /* 0x0480-0x04BF NOT PRESENT */
	0xffff, /* 0x04c0-0x04FF NOT PRESENT */
	0xffff, /* 0x0500-0x053F NOT PRESENT */
	0xffff, /* 0x0540-0x057F NOT PRESENT */
	0xffff, /* 0x0580-0x05BF NOT PRESENT */
	0xffff, /* 0x05c0-0x05FF NOT PRESENT */
	0xffff, /* 0x0600-0x063F NOT PRESENT */
	0xffff, /* 0x0640-0x067F NOT PRESENT */
	0xffff, /* 0x0680-0x06BF NOT PRESENT */
	0xffff, /* 0x06c0-0x06FF NOT PRESENT */
	0xffff, /* 0x0700-0x073F NOT PRESENT */
	0xffff, /* 0x0740-0x077F NOT PRESENT */
	0xffff, /* 0x0780-0x07BF NOT PRESENT */
	0xffff, /* 0x07c0-0x07FF NOT PRESENT */
	0xffff, /* 0x0800-0x083F NOT PRESENT */
	0xffff, /* 0x0840-0x087F NOT PRESENT */
	0xffff, /* 0x0880-0x08BF NOT PRESENT */
	0xffff, /* 0x08c0-0x08FF NOT PRESENT */
	0xffff, /* 0x0900-0x093F NOT PRESENT */
	0xffff, /* 0x0940-0x097F NOT PRESENT */
	0xffff, /* 0x0980-0x09BF NOT PRESENT */
	0xffff, /* 0x09c0-0x09FF NOT PRESENT */
	0xffff, /* 0x0a00-0x0A3F NOT PRESENT */
	0xffff, /* 0x0a40-0x0A7F NOT PRESENT */
	0xffff, /* 0x0a80-0x0ABF NOT PRESENT */
	0xffff, /* 0x0ac0-0x0AFF NOT PRESENT */
	0xffff, /* 0x0b00-0x0B3F NOT PRESENT */
	0xffff, /* 0x0b40-0x0B7F NOT PRESENT */
	0xffff, /* 0x0b80-0x0BBF NOT PRESENT */
	0xffff, /* 0x0bc0-0x0BFF NOT PRESENT */
	0xffff, /* 0x0c00-0x0C3F NOT PRESENT */
	0xffff, /* 0x0c40-0x0C7F NOT PRESENT */
	0xffff, /* 0x0c80-0x0CBF NOT PRESENT */
	0xffff, /* 0x0cc0-0x0CFF NOT PRESENT */
	0xffff, /* 0x0d00-0x0D3F NOT PRESENT */
	0xffff, /* 0x0d40-0x0D7F NOT PRESENT */
	0xffff, /* 0x0d80-0x0DBF NOT PRESENT */
	0xffff, /* 0x0dc0-0x0DFF NOT PRESENT */
	0xffff, /* 0x0e00-0x0E3F NOT PRESENT */
	0xffff, /* 0x0e40-0x0E7F NOT PRESENT */
	0xffff, /* 0x0e80-0x0EBF NOT PRESENT */
	0xffff, /* 0x0ec0-0x0EFF NOT PRESENT */
	0xffff, /* 0x0f00-0x0F3F NOT PRESENT */
	0xffff, /* 0x0f40-0x0F7F NOT PRESENT */
	0xffff, /* 0x0f80-0x0FBF NOT PRESENT */
	0xffff, /* 0x0fc0-0x0FFF NOT PRESENT */
	0xffff, /* 0x1000-0x103F NOT PRESENT */
	0xffff, /* 0x1040-0x107F NOT PRESENT */
	0xffff, /* 0x1080-0x10BF NOT PRESENT */
	0xffff, /* 0x10c0-0x10FF NOT PRESENT */
	0xffff, /* 0x1100-0x113F NOT PRESENT */
	0xffff, /* 0x1140-0x117F NOT PRESENT */
	0xffff, /* 0x1180-0x11BF NOT PRESENT */
	0xffff, /* 0x11c0-0x11FF NOT PRESENT */
	0xffff, /* 0x1200-0x123F NOT PRESENT */
	0xffff, /* 0x1240-0x127F NOT PRESENT */
	0xffff, /* 0x1280-0x12BF NOT PRESENT */
	0xffff, /* 0x12c0-0x12FF NOT PRESENT */
	0xffff, /* 0x1300-0x133F NOT PRESENT */
	0xffff, /* 0x1340-0x137F NOT PRESENT */
	0xffff, /* 0x1380-0x13BF NOT PRESENT */
	0xffff, /* 0x13c0-0x13FF NOT PRESENT */
	0xffff, /* 0x1400-0x143F NOT PRESENT */
	0xffff, /* 0x1440-0x147F NOT PRESENT */
	0xffff, /* 0x1480-0x14BF NOT PRESENT */
	0xffff, /* 0x14c0-0x14FF NOT PRESENT */
	0xffff, /* 0x1500-0x153F NOT PRESENT */
	0xffff, /* 0x1540-0x157F NOT PRESENT */
	0xffff, /* 0x1580-0x15BF NOT PRESENT */
	0xffff, /* 0x15c0-0x15FF NOT PRESENT */
	0xffff, /* 0x1600-0x163F NOT PRESENT */
	0xffff, /* 0x1640-0x167F NOT PRESENT */
	0xffff, /* 0x1680-0x16BF NOT PRESENT */
	0xffff, /* 0x16c0-0x16FF NOT PRESENT */
	0xffff, /* 0x1700-0x173F NOT PRESENT */
	0xffff, /* 0x1740-0x177F NOT PRESENT */
	0xffff, /* 0x1780-0x17BF NOT PRESENT */
	0xffff, /* 0x17c0-0x17FF NOT PRESENT */
	0xffff, /* 0x1800-0x183F NOT PRESENT */
	0xffff, /* 0x1840-0x187F NOT PRESENT */
	0xffff, /* 0x1880-0x18BF NOT PRESENT */
	0xffff, /* 0x18c0-0x18FF NOT PRESENT */
	0xffff, /* 0x1900-0x193F NOT PRESENT */
	0xffff, /* 0x1940-0x197F NOT PRESENT */
	0xffff, /* 0x1980-0x19BF NOT PRESENT */
	0xffff, /* 0x19c0-0x19FF NOT PRESENT */
	0xffff, /* 0x1a00-0x1A3F NOT PRESENT */
	0xffff, /* 0x1a40-0x1A7F NOT PRESENT */
	0xffff, /* 0x1a80-0x1ABF NOT PRESENT */
	0xffff, /* 0x1ac0-0x1AFF NOT PRESENT */
	0xffff, /* 0x1b00-0x1B3F NOT PRESENT */
	0xffff, /* 0x1b40-0x1B7F NOT PRESENT */
	0xffff, /* 0x1b80-0x1BBF NOT PRESENT */
	0xffff, /* 0x1bc0-0x1BFF NOT PRESENT */
	0xffff, /* 0x1c00-0x1C3F NOT PRESENT */
	0xffff, /* 0x1c40-0x1C7F NOT PRESENT */
	0xffff, /* 0x1c80-0x1CBF NOT PRESENT */
	0xffff, /* 0x1cc0-0x1CFF NOT PRESENT */
	0xffff, /* 0x1d00-0x1D3F NOT PRESENT */
	0xffff, /* 0x1d40-0x1D7F NOT PRESENT */
	0xffff, /* 0x1d80-0x1DBF NOT PRESENT */
	0xffff, /* 0x1dc0-0x1DFF NOT PRESENT */
	0xffff, /* 0x1e00-0x1E3F NOT PRESENT */
	0xffff, /* 0x1e40-0x1E7F NOT PRESENT */
	0xffff, /* 0x1e80-0x1EBF NOT PRESENT */
	0xffff, /* 0x1ec0-0x1EFF NOT PRESENT */
	0xffff, /* 0x1f00-0x1F3F NOT PRESENT */
	0xffff, /* 0x1f40-0x1F7F NOT PRESENT */
	0xffff, /* 0x1f80-0x1FBF NOT PRESENT */
	0xffff, /* 0x1fc0-0x1FFF NOT PRESENT */
	0xffff, /* 0x2000-0x203F NOT PRESENT */
	0xffff, /* 0x2040-0x207F NOT PRESENT */
	0xffff, /* 0x2080-0x20BF NOT PRESENT */
	0xffff, /* 0x20c0-0x20FF NOT PRESENT */
	0xffff, /* 0x2100-0x213F NOT PRESENT */
	0xffff, /* 0x2140-0x217F NOT PRESENT */
	0xffff, /* 0x2180-0x21BF NOT PRESENT */
	0xffff, /* 0x21c0-0x21FF NOT PRESENT */
	0xffff, /* 0x2200-0x223F NOT PRESENT */
	0xffff, /* 0x2240-0x227F NOT PRESENT */
	0xffff, /* 0x2280-0x22BF NOT PRESENT */
	0xffff, /* 0x22c0-0x22FF NOT PRESENT */
	0xffff, /* 0x2300-0x233F NOT PRESENT */
	0xffff, /* 0x2340-0x237F NOT PRESENT */
	0xffff, /* 0x2380-0x23BF NOT PRESENT */
	0xffff, /* 0x23c0-0x23FF NOT PRESENT */
	0xffff, /* 0x2400-0x243F NOT PRESENT */
	0xffff, /* 0x2440-0x247F NOT PRESENT */
	0xffff, /* 0x2480-0x24BF NOT PRESENT */
	0xffff, /* 0x24c0-0x24FF NOT PRESENT */
	0xffff, /* 0x2500-0x253F NOT PRESENT */
	0xffff, /* 0x2540-0x257F NOT PRESENT */
	0xffff, /* 0x2580-0x25BF NOT PRESENT */
	0xffff, /* 0x25c0-0x25FF NOT PRESENT */
	0xffff, /* 0x2600-0x263F NOT PRESENT */
	0xffff, /* 0x2640-0x267F NOT PRESENT */
	0xffff, /* 0x2680-0x26BF NOT PRESENT */
	0xffff, /* 0x26c0-0x26FF NOT PRESENT */
	0xffff, /* 0x2700-0x273F NOT PRESENT */
	0xffff, /* 0x2740-0x277F NOT PRESENT */
	0xffff, /* 0x2780-0x27BF NOT PRESENT */
	0xffff, /* 0x27c0-0x27FF NOT PRESENT */
	0xffff, /* 0x2800-0x283F NOT PRESENT */
	0xffff, /* 0x2840-0x287F NOT PRESENT */
	0xffff, /* 0x2880-0x28BF NOT PRESENT */
	0xffff, /* 0x28c0-0x28FF NOT PRESENT */
	0xffff, /* 0x2900-0x293F NOT PRESENT */
	0xffff, /* 0x2940-0x297F NOT PRESENT */
	0xffff, /* 0x2980-0x29BF NOT PRESENT */
	0xffff, /* 0x29c0-0x29FF NOT PRESENT */
	0xffff, /* 0x2a00-0x2A3F NOT PRESENT */
	0xffff, /* 0x2a40-0x2A7F NOT PRESENT */
	0xffff, /* 0x2a80-0x2ABF NOT PRESENT */
	0xffff, /* 0x2ac0-0x2AFF NOT PRESENT */
	0xffff, /* 0x2b00-0x2B3F NOT PRESENT */
	0xffff, /* 0x2b40-0x2B7F NOT PRESENT */
	0xffff, /* 0x2b80-0x2BBF NOT PRESENT */
	0xffff, /* 0x2bc0-0x2BFF NOT PRESENT */
	0xffff, /* 0x2c00-0x2C3F NOT PRESENT */
	0xffff, /* 0x2c40-0x2C7F NOT PRESENT */
	0xffff, /* 0x2c80-0x2CBF NOT PRESENT */
	0xffff, /* 0x2cc0-0x2CFF NOT PRESENT */
	0xffff, /* 0x2d00-0x2D3F NOT PRESENT */
	0xffff, /* 0x2d40-0x2D7F NOT PRESENT */
	0xffff, /* 0x2d80-0x2DBF NOT PRESENT */
	0xffff, /* 0x2dc0-0x2DFF NOT PRESENT */
	0xffff, /* 0x2e00-0x2E3F NOT PRESENT */
	0xffff, /* 0x2e40-0x2E7F NOT PRESENT */
	0xffff, /* 0x2e80-0x2EBF NOT PRESENT */
	0xffff, /* 0x2ec0-0x2EFF NOT PRESENT */
	0xffff, /* 0x2f00-0x2F3F NOT PRESENT */
	0xffff, /* 0x2f40-0x2F7F NOT PRESENT */
	0xffff, /* 0x2f80-0x2FBF NOT PRESENT */
	0xffff, /* 0x2fc0-0x2FFF NOT PRESENT */
	0xffff, /* 0x3000-0x303F NOT PRESENT */
	0xffff, /* 0x3040-0x307F NOT PRESENT */
	0xffff, /* 0x3080-0x30BF NOT PRESENT */
	0xffff, /* 0x30c0-0x30FF NOT PRESENT */
	0xffff, /* 0x3100-0x313F NOT PRESENT */
	0xffff, /* 0x3140-0x317F NOT PRESENT */
	0xffff, /* 0x3180-0x31BF NOT PRESENT */
	0xffff, /* 0x31c0-0x31FF NOT PRESENT */
	0xffff, /* 0x3200-0x323F NOT PRESENT */
	0xffff, /* 0x3240-0x327F NOT PRESENT */
	0xffff, /* 0x3280-0x32BF NOT PRESENT */
	0xffff, /* 0x32c0-0x32FF NOT PRESENT */
	0xffff, /* 0x3300-0x333F NOT PRESENT */
	0xffff, /* 0x3340-0x337F NOT PRESENT */
	0xffff, /* 0x3380-0x33BF NOT PRESENT */
	0xffff, /* 0x33c0-0x33FF NOT PRESENT */
	0xffff, /* 0x3400-0x343F NOT PRESENT */
	0xffff, /* 0x3440-0x347F NOT PRESENT */
	0xffff, /* 0x3480-0x34BF NOT PRESENT */
	0xffff, /* 0x34c0-0x34FF NOT PRESENT */
	0xffff, /* 0x3500-0x353F NOT PRESENT */
	0xffff, /* 0x3540-0x357F NOT PRESENT */
	0xffff, /* 0x3580-0x35BF NOT PRESENT */
	0xffff, /* 0x35c0-0x35FF NOT PRESENT */
	0xffff, /* 0x3600-0x363F NOT PRESENT */
	0xffff, /* 0x3640-0x367F NOT PRESENT */
	0xffff, /* 0x3680-0x36BF NOT PRESENT */
	0xffff, /* 0x36c0-0x36FF NOT PRESENT */
	0xffff, /* 0x3700-0x373F NOT PRESENT */
	0xffff, /* 0x3740-0x377F NOT PRESENT */
	0xffff, /* 0x3780-0x37BF NOT PRESENT */
	0xffff, /* 0x37c0-0x37FF NOT PRESENT */
	0xffff, /* 0x3800-0x383F NOT PRESENT */
	0xffff, /* 0x3840-0x387F NOT PRESENT */
	0xffff, /* 0x3880-0x38BF NOT PRESENT */
	0xffff, /* 0x38c0-0x38FF NOT PRESENT */
	0xffff, /* 0x3900-0x393F NOT PRESENT */
	0xffff, /* 0x3940-0x397F NOT PRESENT */
	0xffff, /* 0x3980-0x39BF NOT PRESENT */
	0xffff, /* 0x39c0-0x39FF NOT PRESENT */
	0xffff, /* 0x3a00-0x3A3F NOT PRESENT */
	0xffff, /* 0x3a40-0x3A7F NOT PRESENT */
	0xffff, /* 0x3a80-0x3ABF NOT PRESENT */
	0xffff, /* 0x3ac0-0x3AFF NOT PRESENT */
	0xffff, /* 0x3b00-0x3B3F NOT PRESENT */
	0xffff, /* 0x3b40-0x3B7F NOT PRESENT */
	0xffff, /* 0x3b80-0x3BBF NOT PRESENT */
	0xffff, /* 0x3bc0-0x3BFF NOT PRESENT */
	0xffff, /* 0x3c00-0x3C3F NOT PRESENT */
	0xffff, /* 0x3c40-0x3C7F NOT PRESENT */
	0xffff, /* 0x3c80-0x3CBF NOT PRESENT */
	0xffff, /* 0x3cc0-0x3CFF NOT PRESENT */
	0xffff, /* 0x3d00-0x3D3F NOT PRESENT */
	0xffff, /* 0x3d40-0x3D7F NOT PRESENT */
	0xffff, /* 0x3d80-0x3DBF NOT PRESENT */
	0xffff, /* 0x3dc0-0x3DFF NOT PRESENT */
	0xffff, /* 0x3e00-0x3E3F NOT PRESENT */
	0xffff, /* 0x3e40-0x3E7F NOT PRESENT */
	0xffff, /* 0x3e80-0x3EBF NOT PRESENT */
	0xffff, /* 0x3ec0-0x3EFF NOT PRESENT */
	0xffff, /* 0x3f00-0x3F3F NOT PRESENT */
	0xffff, /* 0x3f40-0x3F7F NOT PRESENT */
	0xffff, /* 0x3f80-0x3FBF NOT PRESENT */
	0xffff, /* 0x3fc0-0x3FFF NOT PRESENT */
	0xffff, /* 0x4000-0x403F NOT PRESENT */
	0xffff, /* 0x4040-0x407F NOT PRESENT */
	0xffff, /* 0x4080-0x40BF NOT PRESENT */
	0xffff, /* 0x40c0-0x40FF NOT PRESENT */
	0xffff, /* 0x4100-0x413F NOT PRESENT */
	0xffff, /* 0x4140-0x417F NOT PRESENT */
	0xffff, /* 0x4180-0x41BF NOT PRESENT */
	0xffff, /* 0x41c0-0x41FF NOT PRESENT */
	0xffff, /* 0x4200-0x423F NOT PRESENT */
	0xffff, /* 0x4240-0x427F NOT PRESENT */
	0xffff, /* 0x4280-0x42BF NOT PRESENT */
	0xffff, /* 0x42c0-0x42FF NOT PRESENT */
	0xffff, /* 0x4300-0x433F NOT PRESENT */
	0xffff, /* 0x4340-0x437F NOT PRESENT */
	0xffff, /* 0x4380-0x43BF NOT PRESENT */
	0xffff, /* 0x43c0-0x43FF NOT PRESENT */
	0xffff, /* 0x4400-0x443F NOT PRESENT */
	0xffff, /* 0x4440-0x447F NOT PRESENT */
	0xffff, /* 0x4480-0x44BF NOT PRESENT */
	0xffff, /* 0x44c0-0x44FF NOT PRESENT */
	0xffff, /* 0x4500-0x453F NOT PRESENT */
	0xffff, /* 0x4540-0x457F NOT PRESENT */
	0xffff, /* 0x4580-0x45BF NOT PRESENT */
	0xffff, /* 0x45c0-0x45FF NOT PRESENT */
	0xffff, /* 0x4600-0x463F NOT PRESENT */
	0xffff, /* 0x4640-0x467F NOT PRESENT */
	0xffff, /* 0x4680-0x46BF NOT PRESENT */
	0xffff, /* 0x46c0-0x46FF NOT PRESENT */
	0xffff, /* 0x4700-0x473F NOT PRESENT */
	0xffff, /* 0x4740-0x477F NOT PRESENT */
	0xffff, /* 0x4780-0x47BF NOT PRESENT */
	0xffff, /* 0x47c0-0x47FF NOT PRESENT */
	0xffff, /* 0x4800-0x483F NOT PRESENT */
	0xffff, /* 0x4840-0x487F NOT PRESENT */
	0xffff, /* 0x4880-0x48BF NOT PRESENT */
	0xffff, /* 0x48c0-0x48FF NOT PRESENT */
	0xffff, /* 0x4900-0x493F NOT PRESENT */
	0xffff, /* 0x4940-0x497F NOT PRESENT */
	0xffff, /* 0x4980-0x49BF NOT PRESENT */
	0xffff, /* 0x49c0-0x49FF NOT PRESENT */
	0xffff, /* 0x4a00-0x4A3F NOT PRESENT */
	0xffff, /* 0x4a40-0x4A7F NOT PRESENT */
	0xffff, /* 0x4a80-0x4ABF NOT PRESENT */
	0xffff, /* 0x4ac0-0x4AFF NOT PRESENT */
	0xffff, /* 0x4b00-0x4B3F NOT PRESENT */
	0xffff, /* 0x4b40-0x4B7F NOT PRESENT */
	0xffff, /* 0x4b80-0x4BBF NOT PRESENT */
	0xffff, /* 0x4bc0-0x4BFF NOT PRESENT */
	0xffff, /* 0x4c00-0x4C3F NOT PRESENT */
	0xffff, /* 0x4c40-0x4C7F NOT PRESENT */
	0xffff, /* 0x4c80-0x4CBF NOT PRESENT */
	0xffff, /* 0x4cc0-0x4CFF NOT PRESENT */
	0xffff, /* 0x4d00-0x4D3F NOT PRESENT */
	0xffff, /* 0x4d40-0x4D7F NOT PRESENT */
	0xffff, /* 0x4d80-0x4DBF NOT PRESENT */
	0xffff, /* 0x4dc0-0x4DFF NOT PRESENT */
	0xffff, /* 0x4e00-0x4E3F NOT PRESENT */
	0xffff, /* 0x4e40-0x4E7F NOT PRESENT */
	0xffff, /* 0x4e80-0x4EBF NOT PRESENT */
	0xffff, /* 0x4ec0-0x4EFF NOT PRESENT */
	0xffff, /* 0x4f00-0x4F3F NOT PRESENT */
	0xffff, /* 0x4f40-0x4F7F NOT PRESENT */
	0xffff, /* 0x4f80-0x4FBF NOT PRESENT */
	0xffff, /* 0x4fc0-0x4FFF NOT PRESENT */
	0xffff, /* 0x5000-0x503F NOT PRESENT */
	0xffff, /* 0x5040-0x507F NOT PRESENT */
	0xffff, /* 0x5080-0x50BF NOT PRESENT */
	0xffff, /* 0x50c0-0x50FF NOT PRESENT */
	0xffff, /* 0x5100-0x513F NOT PRESENT */
	0xffff, /* 0x5140-0x517F NOT PRESENT */
	0xffff, /* 0x5180-0x51BF NOT PRESENT */
	0xffff, /* 0x51c0-0x51FF NOT PRESENT */
	0xffff, /* 0x5200-0x523F NOT PRESENT */
	0xffff, /* 0x5240-0x527F NOT PRESENT */
	0xffff, /* 0x5280-0x52BF NOT PRESENT */
	0xffff, /* 0x52c0-0x52FF NOT PRESENT */
	0xffff, /* 0x5300-0x533F NOT PRESENT */
	0xffff, /* 0x5340-0x537F NOT PRESENT */
	0xffff, /* 0x5380-0x53BF NOT PRESENT */
	0xffff, /* 0x53c0-0x53FF NOT PRESENT */
	0xffff, /* 0x5400-0x543F NOT PRESENT */
	0xffff, /* 0x5440-0x547F NOT PRESENT */
	0xffff, /* 0x5480-0x54BF NOT PRESENT */
	0xffff, /* 0x54c0-0x54FF NOT PRESENT */
	0xffff, /* 0x5500-0x553F NOT PRESENT */
	0xffff, /* 0x5540-0x557F NOT PRESENT */
	0xffff, /* 0x5580-0x55BF NOT PRESENT */
	0xffff, /* 0x55c0-0x55FF NOT PRESENT */
	0xffff, /* 0x5600-0x563F NOT PRESENT */
	0xffff, /* 0x5640-0x567F NOT PRESENT */
	0xffff, /* 0x5680-0x56BF NOT PRESENT */
	0xffff, /* 0x56c0-0x56FF NOT PRESENT */
	0xffff, /* 0x5700-0x573F NOT PRESENT */
	0xffff, /* 0x5740-0x577F NOT PRESENT */
	0xffff, /* 0x5780-0x57BF NOT PRESENT */
	0xffff, /* 0x57c0-0x57FF NOT PRESENT */
	0xffff, /* 0x5800-0x583F NOT PRESENT */
	0xffff, /* 0x5840-0x587F NOT PRESENT */
	0xffff, /* 0x5880-0x58BF NOT PRESENT */
	0xffff, /* 0x58c0-0x58FF NOT PRESENT */
	0xffff, /* 0x5900-0x593F NOT PRESENT */
	0xffff, /* 0x5940-0x597F NOT PRESENT */
	0xffff, /* 0x5980-0x59BF NOT PRESENT */
	0xffff, /* 0x59c0-0x59FF NOT PRESENT */
	0xffff, /* 0x5a00-0x5A3F NOT PRESENT */
	0xffff, /* 0x5a40-0x5A7F NOT PRESENT */
	0xffff, /* 0x5a80-0x5ABF NOT PRESENT */
	0xffff, /* 0x5ac0-0x5AFF NOT PRESENT */
	0xffff, /* 0x5b00-0x5B3F NOT PRESENT */
	0xffff, /* 0x5b40-0x5B7F NOT PRESENT */
	0xffff, /* 0x5b80-0x5BBF NOT PRESENT */
	0xffff, /* 0x5bc0-0x5BFF NOT PRESENT */
	0xffff, /* 0x5c00-0x5C3F NOT PRESENT */
	0xffff, /* 0x5c40-0x5C7F NOT PRESENT */
	0xffff, /* 0x5c80-0x5CBF NOT PRESENT */
	0xffff, /* 0x5cc0-0x5CFF NOT PRESENT */
	0xffff, /* 0x5d00-0x5D3F NOT PRESENT */
	0xffff, /* 0x5d40-0x5D7F NOT PRESENT */
	0xffff, /* 0x5d80-0x5DBF NOT PRESENT */
	0xffff, /* 0x5dc0-0x5DFF NOT PRESENT */
	0xffff, /* 0x5e00-0x5E3F NOT PRESENT */
	0xffff, /* 0x5e40-0x5E7F NOT PRESENT */
	0xffff, /* 0x5e80-0x5EBF NOT PRESENT */
	0xffff, /* 0x5ec0-0x5EFF NOT PRESENT */
	0xffff, /* 0x5f00-0x5F3F NOT PRESENT */
	0xffff, /* 0x5f40-0x5F7F NOT PRESENT */
	0xffff, /* 0x5f80-0x5FBF NOT PRESENT */
	0xffff, /* 0x5fc0-0x5FFF NOT PRESENT */
	0xffff, /* 0x6000-0x603F NOT PRESENT */
	0xffff, /* 0x6040-0x607F NOT PRESENT */
	0xffff, /* 0x6080-0x60BF NOT PRESENT */
	0xffff, /* 0x60c0-0x60FF NOT PRESENT */
	0xffff, /* 0x6100-0x613F NOT PRESENT */
	0xffff, /* 0x6140-0x617F NOT PRESENT */
	0xffff, /* 0x6180-0x61BF NOT PRESENT */
	0xffff, /* 0x61c0-0x61FF NOT PRESENT */
	0xffff, /* 0x6200-0x623F NOT PRESENT */
	0xffff, /* 0x6240-0x627F NOT PRESENT */
	0xffff, /* 0x6280-0x62BF NOT PRESENT */
	0xffff, /* 0x62c0-0x62FF NOT PRESENT */
	0xffff, /* 0x6300-0x633F NOT PRESENT */
	0xffff, /* 0x6340-0x637F NOT PRESENT */
	0xffff, /* 0x6380-0x63BF NOT PRESENT */
	0xffff, /* 0x63c0-0x63FF NOT PRESENT */
	0xffff, /* 0x6400-0x643F NOT PRESENT */
	0xffff, /* 0x6440-0x647F NOT PRESENT */
	0xffff, /* 0x6480-0x64BF NOT PRESENT */
	0xffff, /* 0x64c0-0x64FF NOT PRESENT */
	0xffff, /* 0x6500-0x653F NOT PRESENT */
	0xffff, /* 0x6540-0x657F NOT PRESENT */
	0xffff, /* 0x6580-0x65BF NOT PRESENT */
	0xffff, /* 0x65c0-0x65FF NOT PRESENT */
	0xffff, /* 0x6600-0x663F NOT PRESENT */
	0xffff, /* 0x6640-0x667F NOT PRESENT */
	0xffff, /* 0x6680-0x66BF NOT PRESENT */
	0xffff, /* 0x66c0-0x66FF NOT PRESENT */
	0xffff, /* 0x6700-0x673F NOT PRESENT */
	0xffff, /* 0x6740-0x677F NOT PRESENT */
	0xffff, /* 0x6780-0x67BF NOT PRESENT */
	0xffff, /* 0x67c0-0x67FF NOT PRESENT */
	0xffff, /* 0x6800-0x683F NOT PRESENT */
	0xffff, /* 0x6840-0x687F NOT PRESENT */
	0xffff, /* 0x6880-0x68BF NOT PRESENT */
	0xffff, /* 0x68c0-0x68FF NOT PRESENT */
	0xffff, /* 0x6900-0x693F NOT PRESENT */
	0xffff, /* 0x6940-0x697F NOT PRESENT */
	0xffff, /* 0x6980-0x69BF NOT PRESENT */
	0xffff, /* 0x69c0-0x69FF NOT PRESENT */
	0xffff, /* 0x6a00-0x6A3F NOT PRESENT */
	0xffff, /* 0x6a40-0x6A7F NOT PRESENT */
	0xffff, /* 0x6a80-0x6ABF NOT PRESENT */
	0xffff, /* 0x6ac0-0x6AFF NOT PRESENT */
	0xffff, /* 0x6b00-0x6B3F NOT PRESENT */
	0xffff, /* 0x6b40-0x6B7F NOT PRESENT */
	0xffff, /* 0x6b80-0x6BBF NOT PRESENT */
	0xffff, /* 0x6bc0-0x6BFF NOT PRESENT */
	0xffff, /* 0x6c00-0x6C3F NOT PRESENT */
	0xffff, /* 0x6c40-0x6C7F NOT PRESENT */
	0xffff, /* 0x6c80-0x6CBF NOT PRESENT */
	0xffff, /* 0x6cc0-0x6CFF NOT PRESENT */
	0xffff, /* 0x6d00-0x6D3F NOT PRESENT */
	0xffff, /* 0x6d40-0x6D7F NOT PRESENT */
	0xffff, /* 0x6d80-0x6DBF NOT PRESENT */
	0xffff, /* 0x6dc0-0x6DFF NOT PRESENT */
	0xffff, /* 0x6e00-0x6E3F NOT PRESENT */
	0xffff, /* 0x6e40-0x6E7F NOT PRESENT */
	0xffff, /* 0x6e80-0x6EBF NOT PRESENT */
	0xffff, /* 0x6ec0-0x6EFF NOT PRESENT */
	0xffff, /* 0x6f00-0x6F3F NOT PRESENT */
	0xffff, /* 0x6f40-0x6F7F NOT PRESENT */
	0xffff, /* 0x6f80-0x6FBF NOT PRESENT */
	0xffff, /* 0x6fc0-0x6FFF NOT PRESENT */
	0xffff, /* 0x7000-0x703F NOT PRESENT */
	0xffff, /* 0x7040-0x707F NOT PRESENT */
	0xffff, /* 0x7080-0x70BF NOT PRESENT */
	0xffff, /* 0x70c0-0x70FF NOT PRESENT */
	0xffff, /* 0x7100-0x713F NOT PRESENT */
	0xffff, /* 0x7140-0x717F NOT PRESENT */
	0xffff, /* 0x7180-0x71BF NOT PRESENT */
	0xffff, /* 0x71c0-0x71FF NOT PRESENT */
	0xffff, /* 0x7200-0x723F NOT PRESENT */
	0xffff, /* 0x7240-0x727F NOT PRESENT */
	0xffff, /* 0x7280-0x72BF NOT PRESENT */
	0xffff, /* 0x72c0-0x72FF NOT PRESENT */
	0xffff, /* 0x7300-0x733F NOT PRESENT */
	0xffff, /* 0x7340-0x737F NOT PRESENT */
	0xffff, /* 0x7380-0x73BF NOT PRESENT */
	0xffff, /* 0x73c0-0x73FF NOT PRESENT */
	0xffff, /* 0x7400-0x743F NOT PRESENT */
	0xffff, /* 0x7440-0x747F NOT PRESENT */
	0xffff, /* 0x7480-0x74BF NOT PRESENT */
	0xffff, /* 0x74c0-0x74FF NOT PRESENT */
	0xffff, /* 0x7500-0x753F NOT PRESENT */
	0xffff, /* 0x7540-0x757F NOT PRESENT */
	0xffff, /* 0x7580-0x75BF NOT PRESENT */
	0xffff, /* 0x75c0-0x75FF NOT PRESENT */
	0xffff, /* 0x7600-0x763F NOT PRESENT */
	0xffff, /* 0x7640-0x767F NOT PRESENT */
	0xffff, /* 0x7680-0x76BF NOT PRESENT */
	0xffff, /* 0x76c0-0x76FF NOT PRESENT */
	0xffff, /* 0x7700-0x773F NOT PRESENT */
	0xffff, /* 0x7740-0x777F NOT PRESENT */
	0xffff, /* 0x7780-0x77BF NOT PRESENT */
	0xffff, /* 0x77c0-0x77FF NOT PRESENT */
	0xffff, /* 0x7800-0x783F NOT PRESENT */
	0xffff, /* 0x7840-0x787F NOT PRESENT */
	0xffff, /* 0x7880-0x78BF NOT PRESENT */
	0xffff, /* 0x78c0-0x78FF NOT PRESENT */
	0xffff, /* 0x7900-0x793F NOT PRESENT */
	0xffff, /* 0x7940-0x797F NOT PRESENT */
	0xffff, /* 0x7980-0x79BF NOT PRESENT */
	0xffff, /* 0x79c0-0x79FF NOT PRESENT */
	0xffff, /* 0x7a00-0x7A3F NOT PRESENT */
	0xffff, /* 0x7a40-0x7A7F NOT PRESENT */
	0xffff, /* 0x7a80-0x7ABF NOT PRESENT */
	0xffff, /* 0x7ac0-0x7AFF NOT PRESENT */
	0xffff, /* 0x7b00-0x7B3F NOT PRESENT */
	0xffff, /* 0x7b40-0x7B7F NOT PRESENT */
	0xffff, /* 0x7b80-0x7BBF NOT PRESENT */
	0xffff, /* 0x7bc0-0x7BFF NOT PRESENT */
	0xffff, /* 0x7c00-0x7C3F NOT PRESENT */
	0xffff, /* 0x7c40-0x7C7F NOT PRESENT */
	0xffff, /* 0x7c80-0x7CBF NOT PRESENT */
	0xffff, /* 0x7cc0-0x7CFF NOT PRESENT */
	0xffff, /* 0x7d00-0x7D3F NOT PRESENT */
	0xffff, /* 0x7d40-0x7D7F NOT PRESENT */
	0xffff, /* 0x7d80-0x7DBF NOT PRESENT */
	0xffff, /* 0x7dc0-0x7DFF NOT PRESENT */
	0xffff, /* 0x7e00-0x7E3F NOT PRESENT */
	0xffff, /* 0x7e40-0x7E7F NOT PRESENT */
	0xffff, /* 0x7e80-0x7EBF NOT PRESENT */
	0xffff, /* 0x7ec0-0x7EFF NOT PRESENT */
	0xffff, /* 0x7f00-0x7F3F NOT PRESENT */
	0xffff, /* 0x7f40-0x7F7F NOT PRESENT */
	0xffff, /* 0x7f80-0x7FBF NOT PRESENT */
	0xffff, /* 0x7fc0-0x7FFF NOT PRESENT */
	0xffff, /* 0x8000-0x803F NOT PRESENT */
	0xffff, /* 0x8040-0x807F NOT PRESENT */
	0xffff, /* 0x8080-0x80BF NOT PRESENT */
	0xffff, /* 0x80c0-0x80FF NOT PRESENT */
	0xffff, /* 0x8100-0x813F NOT PRESENT */
	0x0080, /* 0x8140-0x817F */
	0x00c0, /* 0x8180-0x81BF */
	0x0100, /* 0x81c0-0x81FF */
	0xffff, /* 0x8200-0x823F NOT PRESENT */
	0x0140, /* 0x8240-0x827F */
	0x0180, /* 0x8280-0x82BF */
	0x01c0, /* 0x82c0-0x82FF */
	0xffff, /* 0x8300-0x833F NOT PRESENT */
	0x0200, /* 0x8340-0x837F */
	0x0240, /* 0x8380-0x83BF */
	0x0280, /* 0x83c0-0x83FF */
	0xffff, /* 0x8400-0x843F NOT PRESENT */
	0x02c0, /* 0x8440-0x847F */
	0x0300, /* 0x8480-0x84BF */
	0x0340, /* 0x84c0-0x84FF */
	0xffff, /* 0x8500-0x853F NOT PRESENT */
	0x0380, /* 0x8540-0x857F */
	0x03c0, /* 0x8580-0x85BF */
	0x0400, /* 0x85c0-0x85FF */
	0xffff, /* 0x8600-0x863F NOT PRESENT */
	0x0440, /* 0x8640-0x867F */
	0x0480, /* 0x8680-0x86BF */
	0x04c0, /* 0x86c0-0x86FF */
	0xffff, /* 0x8700-0x873F NOT PRESENT */
	0x0500, /* 0x8740-0x877F */
	0x0540, /* 0x8780-0x87BF */
	0x0580, /* 0x87c0-0x87FF */
	0xffff, /* 0x8800-0x883F NOT PRESENT */
	0x05c0, /* 0x8840-0x887F */
	0x0600, /* 0x8880-0x88BF */
	0x0640, /* 0x88c0-0x88FF */
	0xffff, /* 0x8900-0x893F NOT PRESENT */
	0x0680, /* 0x8940-0x897F */
	0x06c0, /* 0x8980-0x89BF */
	0x0700, /* 0x89c0-0x89FF */
	0xffff, /* 0x8a00-0x8A3F NOT PRESENT */
	0x0740, /* 0x8a40-0x8A7F */
	0x0780, /* 0x8a80-0x8ABF */
	0x07c0, /* 0x8ac0-0x8AFF */
	0xffff, /* 0x8b00-0x8B3F NOT PRESENT */
	0x0800, /* 0x8b40-0x8B7F */
	0x0840, /* 0x8b80-0x8BBF */
	0x0880, /* 0x8bc0-0x8BFF */
	0xffff, /* 0x8c00-0x8C3F NOT PRESENT */
	0x08c0, /* 0x8c40-0x8C7F */
	0x0900, /* 0x8c80-0x8CBF */
	0x0940, /* 0x8cc0-0x8CFF */
	0xffff, /* 0x8d00-0x8D3F NOT PRESENT */
	0x0980, /* 0x8d40-0x8D7F */
	0x09c0, /* 0x8d80-0x8DBF */
	0x0a00, /* 0x8dc0-0x8DFF */
	0xffff, /* 0x8e00-0x8E3F NOT PRESENT */
	0x0a40, /* 0x8e40-0x8E7F */
	0x0a80, /* 0x8e80-0x8EBF */
	0x0ac0, /* 0x8ec0-0x8EFF */
	0xffff, /* 0x8f00-0x8F3F NOT PRESENT */
	0x0b00, /* 0x8f40-0x8F7F */
	0x0b40, /* 0x8f80-0x8FBF */
	0x0b80, /* 0x8fc0-0x8FFF */
	0xffff, /* 0x9000-0x903F NOT PRESENT */
	0x0bc0, /* 0x9040-0x907F */
	0x0c00, /* 0x9080-0x90BF */
	0x0c40, /* 0x90c0-0x90FF */
	0xffff, /* 0x9100-0x913F NOT PRESENT */
	0x0c80, /* 0x9140-0x917F */
	0x0cc0, /* 0x9180-0x91BF */
	0x0d00, /* 0x91c0-0x91FF */
	0xffff, /* 0x9200-0x923F NOT PRESENT */
	0x0d40, /* 0x9240-0x927F */
	0x0d80, /* 0x9280-0x92BF */
	0x0dc0, /* 0x92c0-0x92FF */
	0xffff, /* 0x9300-0x933F NOT PRESENT */
	0x0e00, /* 0x9340-0x937F */
	0x0e40, /* 0x9380-0x93BF */
	0x0e80, /* 0x93c0-0x93FF */
	0xffff, /* 0x9400-0x943F NOT PRESENT */
	0x0ec0, /* 0x9440-0x947F */
	0x0f00, /* 0x9480-0x94BF */
	0x0f40, /* 0x94c0-0x94FF */
	0xffff, /* 0x9500-0x953F NOT PRESENT */
	0x0f80, /* 0x9540-0x957F */
	0x0fc0, /* 0x9580-0x95BF */
	0x1000, /* 0x95c0-0x95FF */
	0xffff, /* 0x9600-0x963F NOT PRESENT */
	0x1040, /* 0x9640-0x967F */
	0x1080, /* 0x9680-0x96BF */
	0x10c0, /* 0x96c0-0x96FF */
	0xffff, /* 0x9700-0x973F NOT PRESENT */
	0x1100, /* 0x9740-0x977F */
	0x1140, /* 0x9780-0x97BF */
	0x1180, /* 0x97c0-0x97FF */
	0xffff, /* 0x9800-0x983F NOT PRESENT */
	0x11c0, /* 0x9840-0x987F */
	0x1200, /* 0x9880-0x98BF */
	0x1240, /* 0x98c0-0x98FF */
	0xffff, /* 0x9900-0x993F NOT PRESENT */
	0x1280, /* 0x9940-0x997F */
	0x12c0, /* 0x9980-0x99BF */
	0x1300, /* 0x99c0-0x99FF */
	0xffff, /* 0x9a00-0x9A3F NOT PRESENT */
	0x1340, /* 0x9a40-0x9A7F */
	0x1380, /* 0x9a80-0x9ABF */
	0x13c0, /* 0x9ac0-0x9AFF */
	0xffff, /* 0x9b00-0x9B3F NOT PRESENT */
	0x1400, /* 0x9b40-0x9B7F */
	0x1440, /* 0x9b80-0x9BBF */
	0x1480, /* 0x9bc0-0x9BFF */
	0xffff, /* 0x9c00-0x9C3F NOT PRESENT */
	0x14c0, /* 0x9c40-0x9C7F */
	0x1500, /* 0x9c80-0x9CBF */
	0x1540, /* 0x9cc0-0x9CFF */
	0xffff, /* 0x9d00-0x9D3F NOT PRESENT */
	0x1580, /* 0x9d40-0x9D7F */
	0x15c0, /* 0x9d80-0x9DBF */
	0x1600, /* 0x9dc0-0x9DFF */
	0xffff, /* 0x9e00-0x9E3F NOT PRESENT */
	0x1640, /* 0x9e40-0x9E7F */
	0x1680, /* 0x9e80-0x9EBF */
	0x16c0, /* 0x9ec0-0x9EFF */
	0xffff, /* 0x9f00-0x9F3F NOT PRESENT */
	0x1700, /* 0x9f40-0x9F7F */
	0x1740, /* 0x9f80-0x9FBF */
	0x1780, /* 0x9fc0-0x9FFF */
	0xffff, /* 0xa000-0xA03F NOT PRESENT */
	0x17c0, /* 0xa040-0xA07F */
	0x1800, /* 0xa080-0xA0BF */
	0x1840, /* 0xa0c0-0xA0FF */
	0xffff, /* 0xa100-0xA13F NOT PRESENT */
	0x1880, /* 0xa140-0xA17F */
	0x18c0, /* 0xa180-0xA1BF */
	0x1900, /* 0xa1c0-0xA1FF */
	0xffff, /* 0xa200-0xA23F NOT PRESENT */
	0x1940, /* 0xa240-0xA27F */
	0x1980, /* 0xa280-0xA2BF */
	0x19c0, /* 0xa2c0-0xA2FF */
	0xffff, /* 0xa300-0xA33F NOT PRESENT */
	0x1a00, /* 0xa340-0xA37F */
	0x1a40, /* 0xa380-0xA3BF */
	0x1a80, /* 0xa3c0-0xA3FF */
	0xffff, /* 0xa400-0xA43F NOT PRESENT */
	0x1ac0, /* 0xa440-0xA47F */
	0x1b00, /* 0xa480-0xA4BF */
	0x1b40, /* 0xa4c0-0xA4FF */
	0xffff, /* 0xa500-0xA53F NOT PRESENT */
	0x1b80, /* 0xa540-0xA57F */
	0x1bc0, /* 0xa580-0xA5BF */
	0x1c00, /* 0xa5c0-0xA5FF */
	0xffff, /* 0xa600-0xA63F NOT PRESENT */
	0x1c40, /* 0xa640-0xA67F */
	0x1c80, /* 0xa680-0xA6BF */
	0x1cc0, /* 0xa6c0-0xA6FF */
	0xffff, /* 0xa700-0xA73F NOT PRESENT */
	0x1d00, /* 0xa740-0xA77F */
	0x1d40, /* 0xa780-0xA7BF */
	0x1d80, /* 0xa7c0-0xA7FF */
	0xffff, /* 0xa800-0xA83F NOT PRESENT */
	0x1dc0, /* 0xa840-0xA87F */
	0x1e00, /* 0xa880-0xA8BF */
	0x1e40, /* 0xa8c0-0xA8FF */
	0xffff, /* 0xa900-0xA93F NOT PRESENT */
	0x1e80, /* 0xa940-0xA97F */
	0x1ec0, /* 0xa980-0xA9BF */
	0x1f00, /* 0xa9c0-0xA9FF */
	0xffff, /* 0xaa00-0xAA3F NOT PRESENT */
	0x1f40, /* 0xaa40-0xAA7F */
	0x1f80, /* 0xaa80-0xAABF */
	0x1fc0, /* 0xaac0-0xAAFF */
	0xffff, /* 0xab00-0xAB3F NOT PRESENT */
	0x2000, /* 0xab40-0xAB7F */
	0x2040, /* 0xab80-0xABBF */
	0x2080, /* 0xabc0-0xABFF */
	0xffff, /* 0xac00-0xAC3F NOT PRESENT */
	0x20c0, /* 0xac40-0xAC7F */
	0x2100, /* 0xac80-0xACBF */
	0x2140, /* 0xacc0-0xACFF */
	0xffff, /* 0xad00-0xAD3F NOT PRESENT */
	0x2180, /* 0xad40-0xAD7F */
	0x21c0, /* 0xad80-0xADBF */
	0xffff, /* 0xadc0-0xADFF NOT PRESENT */
	0xffff, /* 0xae00-0xAE3F NOT PRESENT */
	0x2200, /* 0xae40-0xAE7F */
	0x2240, /* 0xae80-0xAEBF */
	0xffff, /* 0xaec0-0xAEFF NOT PRESENT */
	0xffff, /* 0xaf00-0xAF3F NOT PRESENT */
	0x2280, /* 0xaf40-0xAF7F */
	0x22c0, /* 0xaf80-0xAFBF */
	0xffff, /* 0xafc0-0xAFFF NOT PRESENT */
	0xffff, /* 0xb000-0xB03F NOT PRESENT */
	0x2300, /* 0xb040-0xB07F */
	0x2340, /* 0xb080-0xB0BF */
	0x2380, /* 0xb0c0-0xB0FF */
	0xffff, /* 0xb100-0xB13F NOT PRESENT */
	0x23c0, /* 0xb140-0xB17F */
	0x2400, /* 0xb180-0xB1BF */
	0x2440, /* 0xb1c0-0xB1FF */
	0xffff, /* 0xb200-0xB23F NOT PRESENT */
	0x2480, /* 0xb240-0xB27F */
	0x24c0, /* 0xb280-0xB2BF */
	0x2500, /* 0xb2c0-0xB2FF */
	0xffff, /* 0xb300-0xB33F NOT PRESENT */
	0x2540, /* 0xb340-0xB37F */
	0x2580, /* 0xb380-0xB3BF */
	0x25c0, /* 0xb3c0-0xB3FF */
	0xffff, /* 0xb400-0xB43F NOT PRESENT */
	0x2600, /* 0xb440-0xB47F */
	0x2640, /* 0xb480-0xB4BF */
	0x2680, /* 0xb4c0-0xB4FF */
	0xffff, /* 0xb500-0xB53F NOT PRESENT */
	0x26c0, /* 0xb540-0xB57F */
	0x2700, /* 0xb580-0xB5BF */
	0x2740, /* 0xb5c0-0xB5FF */
	0xffff, /* 0xb600-0xB63F NOT PRESENT */
	0x2780, /* 0xb640-0xB67F */
	0x27c0, /* 0xb680-0xB6BF */
	0x2800, /* 0xb6c0-0xB6FF */
	0xffff, /* 0xb700-0xB73F NOT PRESENT */
	0x2840, /* 0xb740-0xB77F */
	0x2880, /* 0xb780-0xB7BF */
	0x28c0, /* 0xb7c0-0xB7FF */
	0xffff, /* 0xb800-0xB83F NOT PRESENT */
	0x2900, /* 0xb840-0xB87F */
	0x2940, /* 0xb880-0xB8BF */
	0x2980, /* 0xb8c0-0xB8FF */
	0xffff, /* 0xb900-0xB93F NOT PRESENT */
	0x29c0, /* 0xb940-0xB97F */
	0x2a00, /* 0xb980-0xB9BF */
	0x2a40, /* 0xb9c0-0xB9FF */
	0xffff, /* 0xba00-0xBA3F NOT PRESENT */
	0x2a80, /* 0xba40-0xBA7F */
	0x2ac0, /* 0xba80-0xBABF */
	0x2b00, /* 0xbac0-0xBAFF */
	0xffff, /* 0xbb00-0xBB3F NOT PRESENT */
	0x2b40, /* 0xbb40-0xBB7F */
	0x2b80, /* 0xbb80-0xBBBF */
	0x2bc0, /* 0xbbc0-0xBBFF */
	0xffff, /* 0xbc00-0xBC3F NOT PRESENT */
	0x2c00, /* 0xbc40-0xBC7F */
	0x2c40, /* 0xbc80-0xBCBF */
	0x2c80, /* 0xbcc0-0xBCFF */
	0xffff, /* 0xbd00-0xBD3F NOT PRESENT */
	0x2cc0, /* 0xbd40-0xBD7F */
	0x2d00, /* 0xbd80-0xBDBF */
	0x2d40, /* 0xbdc0-0xBDFF */
	0xffff, /* 0xbe00-0xBE3F NOT PRESENT */
	0x2d80, /* 0xbe40-0xBE7F */
	0x2dc0, /* 0xbe80-0xBEBF */
	0x2e00, /* 0xbec0-0xBEFF */
	0xffff, /* 0xbf00-0xBF3F NOT PRESENT */
	0x2e40, /* 0xbf40-0xBF7F */
	0x2e80, /* 0xbf80-0xBFBF */
	0x2ec0, /* 0xbfc0-0xBFFF */
	0xffff, /* 0xc000-0xC03F NOT PRESENT */
	0x2f00, /* 0xc040-0xC07F */
	0x2f40, /* 0xc080-0xC0BF */
	0x2f80, /* 0xc0c0-0xC0FF */
	0xffff, /* 0xc100-0xC13F NOT PRESENT */
	0x2fc0, /* 0xc140-0xC17F */
	0x3000, /* 0xc180-0xC1BF */
	0x3040, /* 0xc1c0-0xC1FF */
	0xffff, /* 0xc200-0xC23F NOT PRESENT */
	0x3080, /* 0xc240-0xC27F */
	0x30c0, /* 0xc280-0xC2BF */
	0x3100, /* 0xc2c0-0xC2FF */
	0xffff, /* 0xc300-0xC33F NOT PRESENT */
	0x3140, /* 0xc340-0xC37F */
	0x3180, /* 0xc380-0xC3BF */
	0x31c0, /* 0xc3c0-0xC3FF */
	0xffff, /* 0xc400-0xC43F NOT PRESENT */
	0x3200, /* 0xc440-0xC47F */
	0x3240, /* 0xc480-0xC4BF */
	0x3280, /* 0xc4c0-0xC4FF */
	0xffff, /* 0xc500-0xC53F NOT PRESENT */
	0x32c0, /* 0xc540-0xC57F */
	0x3300, /* 0xc580-0xC5BF */
	0x3340, /* 0xc5c0-0xC5FF */
	0xffff, /* 0xc600-0xC63F NOT PRESENT */
	0x3380, /* 0xc640-0xC67F */
	0x33c0, /* 0xc680-0xC6BF */
	0x3400, /* 0xc6c0-0xC6FF */
	0xffff, /* 0xc700-0xC73F NOT PRESENT */
	0xffff, /* 0xc740-0xC77F NOT PRESENT */
	0x3440, /* 0xc780-0xC7BF */
	0x3480, /* 0xc7c0-0xC7FF */
	0xffff, /* 0xc800-0xC83F NOT PRESENT */
	0xffff, /* 0xc840-0xC87F NOT PRESENT */
	0x34c0, /* 0xc880-0xC8BF */
	0x3500, /* 0xc8c0-0xC8FF */
	0xffff, /* 0xc900-0xC93F NOT PRESENT */
	0xffff, /* 0xc940-0xC97F NOT PRESENT */
	0xffff, /* 0xc980-0xC9BF NOT PRESENT */
	0xffff, /* 0xc9c0-0xC9FF NOT PRESENT */
	0xffff, /* 0xca00-0xCA3F NOT PRESENT */
	0xffff, /* 0xca40-0xCA7F NOT PRESENT */
	0x3540, /* 0xca80-0xCABF */
	0x3580, /* 0xcac0-0xCAFF */
	0xffff, /* 0xcb00-0xCB3F NOT PRESENT */
	0xffff, /* 0xcb40-0xCB7F NOT PRESENT */
	0x35c0, /* 0xcb80-0xCBBF */
	0x3600, /* 0xcbc0-0xCBFF */
	0xffff, /* 0xcc00-0xCC3F NOT PRESENT */
	0xffff, /* 0xcc40-0xCC7F NOT PRESENT */
	0x3640, /* 0xcc80-0xCCBF */
	0x3680, /* 0xccc0-0xCCFF */
	0xffff, /* 0xcd00-0xCD3F NOT PRESENT */
	0xffff, /* 0xcd40-0xCD7F NOT PRESENT */
	0x36c0, /* 0xcd80-0xCDBF */
	0x3700, /* 0xcdc0-0xCDFF */
	0xffff, /* 0xce00-0xCE3F NOT PRESENT */
	0xffff, /* 0xce40-0xCE7F NOT PRESENT */
	0x3740, /* 0xce80-0xCEBF */
	0x3780, /* 0xcec0-0xCEFF */
	0xffff, /* 0xcf00-0xCF3F NOT PRESENT */
	0xffff, /* 0xcf40-0xCF7F NOT PRESENT */
	0x37c0, /* 0xcf80-0xCFBF */
	0x3800, /* 0xcfc0-0xCFFF */
	0xffff, /* 0xd000-0xD03F NOT PRESENT */
	0xffff, /* 0xd040-0xD07F NOT PRESENT */
	0x3840, /* 0xd080-0xD0BF */
	0x3880, /* 0xd0c0-0xD0FF */
	0xffff, /* 0xd100-0xD13F NOT PRESENT */
	0xffff, /* 0xd140-0xD17F NOT PRESENT */
	0x38c0, /* 0xd180-0xD1BF */
	0x3900, /* 0xd1c0-0xD1FF */
	0xffff, /* 0xd200-0xD23F NOT PRESENT */
	0xffff, /* 0xd240-0xD27F NOT PRESENT */
	0x3940, /* 0xd280-0xD2BF */
	0x3980, /* 0xd2c0-0xD2FF */
	0xffff, /* 0xd300-0xD33F NOT PRESENT */
	0xffff, /* 0xd340-0xD37F NOT PRESENT */
	0x39c0, /* 0xd380-0xD3BF */
	0x3a00, /* 0xd3c0-0xD3FF */
	0xffff, /* 0xd400-0xD43F NOT PRESENT */
	0xffff, /* 0xd440-0xD47F NOT PRESENT */
	0x3a40, /* 0xd480-0xD4BF */
	0x3a80, /* 0xd4c0-0xD4FF */
	0xffff, /* 0xd500-0xD53F NOT PRESENT */
	0xffff, /* 0xd540-0xD57F NOT PRESENT */
	0x3ac0, /* 0xd580-0xD5BF */
	0x3b00, /* 0xd5c0-0xD5FF */
	0xffff, /* 0xd600-0xD63F NOT PRESENT */
	0xffff, /* 0xd640-0xD67F NOT PRESENT */
	0x3b40, /* 0xd680-0xD6BF */
	0x3b80, /* 0xd6c0-0xD6FF */
	0xffff, /* 0xd700-0xD73F NOT PRESENT */
	0xffff, /* 0xd740-0xD77F NOT PRESENT */
	0x3bc0, /* 0xd780-0xD7BF */
	0x3c00, /* 0xd7c0-0xD7FF */
	0xffff, /* 0xd800-0xD83F NOT PRESENT */
	0xffff, /* 0xd840-0xD87F NOT PRESENT */
	0x3c40, /* 0xd880-0xD8BF */
	0x3c80, /* 0xd8c0-0xD8FF */
	0xffff, /* 0xd900-0xD93F NOT PRESENT */
	0xffff, /* 0xd940-0xD97F NOT PRESENT */
	0x3cc0, /* 0xd980-0xD9BF */
	0x3d00, /* 0xd9c0-0xD9FF */
	0xffff, /* 0xda00-0xDA3F NOT PRESENT */
	0xffff, /* 0xda40-0xDA7F NOT PRESENT */
	0x3d40, /* 0xda80-0xDABF */
	0x3d80, /* 0xdac0-0xDAFF */
	0xffff, /* 0xdb00-0xDB3F NOT PRESENT */
	0xffff, /* 0xdb40-0xDB7F NOT PRESENT */
	0x3dc0, /* 0xdb80-0xDBBF */
	0x3e00, /* 0xdbc0-0xDBFF */
	0xffff, /* 0xdc00-0xDC3F NOT PRESENT */
	0xffff, /* 0xdc40-0xDC7F NOT PRESENT */
	0x3e40, /* 0xdc80-0xDCBF */
	0x3e80, /* 0xdcc0-0xDCFF */
	0xffff, /* 0xdd00-0xDD3F NOT PRESENT */
	0xffff, /* 0xdd40-0xDD7F NOT PRESENT */
	0x3ec0, /* 0xdd80-0xDDBF */
	0x3f00, /* 0xddc0-0xDDFF */
	0xffff, /* 0xde00-0xDE3F NOT PRESENT */
	0xffff, /* 0xde40-0xDE7F NOT PRESENT */
	0x3f40, /* 0xde80-0xDEBF */
	0x3f80, /* 0xdec0-0xDEFF */
	0xffff, /* 0xdf00-0xDF3F NOT PRESENT */
	0xffff, /* 0xdf40-0xDF7F NOT PRESENT */
	0x3fc0, /* 0xdf80-0xDFBF */
	0x4000, /* 0xdfc0-0xDFFF */
	0xffff, /* 0xe000-0xE03F NOT PRESENT */
	0xffff, /* 0xe040-0xE07F NOT PRESENT */
	0x4040, /* 0xe080-0xE0BF */
	0x4080, /* 0xe0c0-0xE0FF */
	0xffff, /* 0xe100-0xE13F NOT PRESENT */
	0xffff, /* 0xe140-0xE17F NOT PRESENT */
	0x40c0, /* 0xe180-0xE1BF */
	0x4100, /* 0xe1c0-0xE1FF */
	0xffff, /* 0xe200-0xE23F NOT PRESENT */
	0xffff, /* 0xe240-0xE27F NOT PRESENT */
	0x4140, /* 0xe280-0xE2BF */
	0x4180, /* 0xe2c0-0xE2FF */
	0xffff, /* 0xe300-0xE33F NOT PRESENT */
	0xffff, /* 0xe340-0xE37F NOT PRESENT */
	0x41c0, /* 0xe380-0xE3BF */
	0x4200, /* 0xe3c0-0xE3FF */
	0xffff, /* 0xe400-0xE43F NOT PRESENT */
	0xffff, /* 0xe440-0xE47F NOT PRESENT */
	0x4240, /* 0xe480-0xE4BF */
	0x4280, /* 0xe4c0-0xE4FF */
	0xffff, /* 0xe500-0xE53F NOT PRESENT */
	0xffff, /* 0xe540-0xE57F NOT PRESENT */
	0x42c0, /* 0xe580-0xE5BF */
	0x4300, /* 0xe5c0-0xE5FF */
	0xffff, /* 0xe600-0xE63F NOT PRESENT */
	0xffff, /* 0xe640-0xE67F NOT PRESENT */
	0x4340, /* 0xe680-0xE6BF */
	0x4380, /* 0xe6c0-0xE6FF */
	0xffff, /* 0xe700-0xE73F NOT PRESENT */
	0xffff, /* 0xe740-0xE77F NOT PRESENT */
	0x43c0, /* 0xe780-0xE7BF */
	0x4400, /* 0xe7c0-0xE7FF */
	0xffff, /* 0xe800-0xE83F NOT PRESENT */
	0xffff, /* 0xe840-0xE87F NOT PRESENT */
	0x4440, /* 0xe880-0xE8BF */
	0x4480, /* 0xe8c0-0xE8FF */
	0xffff, /* 0xe900-0xE93F NOT PRESENT */
	0xffff, /* 0xe940-0xE97F NOT PRESENT */
	0x44c0, /* 0xe980-0xE9BF */
	0x4500, /* 0xe9c0-0xE9FF */
	0xffff, /* 0xea00-0xEA3F NOT PRESENT */
	0xffff, /* 0xea40-0xEA7F NOT PRESENT */
	0x4540, /* 0xea80-0xEABF */
	0x4580, /* 0xeac0-0xEAFF */
	0xffff, /* 0xeb00-0xEB3F NOT PRESENT */
	0xffff, /* 0xeb40-0xEB7F NOT PRESENT */
	0x45c0, /* 0xeb80-0xEBBF */
	0x4600, /* 0xebc0-0xEBFF */
	0xffff, /* 0xec00-0xEC3F NOT PRESENT */
	0xffff, /* 0xec40-0xEC7F NOT PRESENT */
	0x4640, /* 0xec80-0xECBF */
	0x4680, /* 0xecc0-0xECFF */
	0xffff, /* 0xed00-0xED3F NOT PRESENT */
	0xffff, /* 0xed40-0xED7F NOT PRESENT */
	0x46c0, /* 0xed80-0xEDBF */
	0x4700, /* 0xedc0-0xEDFF */
	0xffff, /* 0xee00-0xEE3F NOT PRESENT */
	0xffff, /* 0xee40-0xEE7F NOT PRESENT */
	0x4740, /* 0xee80-0xEEBF */
	0x4780, /* 0xeec0-0xEEFF */
	0xffff, /* 0xef00-0xEF3F NOT PRESENT */
	0xffff, /* 0xef40-0xEF7F NOT PRESENT */
	0x47c0, /* 0xef80-0xEFBF */
	0x4800, /* 0xefc0-0xEFFF */
	0xffff, /* 0xf000-0xF03F NOT PRESENT */
	0xffff, /* 0xf040-0xF07F NOT PRESENT */
	0x4840, /* 0xf080-0xF0BF */
	0x4880, /* 0xf0c0-0xF0FF */
	0xffff, /* 0xf100-0xF13F NOT PRESENT */
	0xffff, /* 0xf140-0xF17F NOT PRESENT */
	0x48c0, /* 0xf180-0xF1BF */
	0x4900, /* 0xf1c0-0xF1FF */
	0xffff, /* 0xf200-0xF23F NOT PRESENT */
	0xffff, /* 0xf240-0xF27F NOT PRESENT */
	0x4940, /* 0xf280-0xF2BF */
	0x4980, /* 0xf2c0-0xF2FF */
	0xffff, /* 0xf300-0xF33F NOT PRESENT */
	0xffff, /* 0xf340-0xF37F NOT PRESENT */
	0x49c0, /* 0xf380-0xF3BF */
	0x4a00, /* 0xf3c0-0xF3FF */
	0xffff, /* 0xf400-0xF43F NOT PRESENT */
	0xffff, /* 0xf440-0xF47F NOT PRESENT */
	0x4a40, /* 0xf480-0xF4BF */
	0x4a80, /* 0xf4c0-0xF4FF */
	0xffff, /* 0xf500-0xF53F NOT PRESENT */
	0xffff, /* 0xf540-0xF57F NOT PRESENT */
	0x4ac0, /* 0xf580-0xF5BF */
	0x4b00, /* 0xf5c0-0xF5FF */
	0xffff, /* 0xf600-0xF63F NOT PRESENT */
	0xffff, /* 0xf640-0xF67F NOT PRESENT */
	0x4b40, /* 0xf680-0xF6BF */
	0x4b80, /* 0xf6c0-0xF6FF */
	0xffff, /* 0xf700-0xF73F NOT PRESENT */
	0xffff, /* 0xf740-0xF77F NOT PRESENT */
	0x4bc0, /* 0xf780-0xF7BF */
	0x4c00, /* 0xf7c0-0xF7FF */
	0xffff, /* 0xf800-0xF83F NOT PRESENT */
	0xffff, /* 0xf840-0xF87F NOT PRESENT */
	0x4c40, /* 0xf880-0xF8BF */
	0x4c80, /* 0xf8c0-0xF8FF */
	0xffff, /* 0xf900-0xF93F NOT PRESENT */
	0xffff, /* 0xf940-0xF97F NOT PRESENT */
	0x4cc0, /* 0xf980-0xF9BF */
	0x4d00, /* 0xf9c0-0xF9FF */
	0xffff, /* 0xfa00-0xFA3F NOT PRESENT */
	0xffff, /* 0xfa40-0xFA7F NOT PRESENT */
	0x4d40, /* 0xfa80-0xFABF */
	0x4d80, /* 0xfac0-0xFAFF */
	0xffff, /* 0xfb00-0xFB3F NOT PRESENT */
	0xffff, /* 0xfb40-0xFB7F NOT PRESENT */
	0x4dc0, /* 0xfb80-0xFBBF */
	0x4e00, /* 0xfbc0-0xFBFF */
	0xffff, /* 0xfc00-0xFC3F NOT PRESENT */
	0xffff, /* 0xfc40-0xFC7F NOT PRESENT */
	0x4e40, /* 0xfc80-0xFCBF */
	0x4e80, /* 0xfcc0-0xFCFF */
	0xffff, /* 0xfd00-0xFD3F NOT PRESENT */
	0xffff, /* 0xfd40-0xFD7F NOT PRESENT */
	0x4ec0, /* 0xfd80-0xFDBF */
	0x4f00, /* 0xfdc0-0xFDFF */
	0xffff, /* 0xfe00-0xFE3F NOT PRESENT */
	0xffff, /* 0xfe40-0xFE7F NOT PRESENT */
	0xffff, /* 0xfe80-0xFEBF NOT PRESENT */
	0xffff, /* 0xfec0-0xFEFF NOT PRESENT */
	0xffff, /* 0xff00-0xFF3F NOT PRESENT */
	0xffff, /* 0xff40-0xFF7F NOT PRESENT */
	0xffff, /* 0xff80-0xFFBF NOT PRESENT */
	0xffff  /* 0xffc0-0xFFFF NOT PRESENT */
};
