/* 
 * intersections.h -- Circle, Plane, Segment, Sphere intersection operators 
 *
 * This file is part of ePiX, a C++ library for creating high-quality 
 * figures in LaTeX 
 *
 * Version 1.1.9
 * Last Change: July 30, 2007
 */

/* 
 * Copyright (C) 2001, 2002, 2003, 2004, 2005, 2006, 2007
 * Andrew D. Hwang <rot 13 nujnat at zngupf dot ubylpebff dot rqh>
 * Department of Mathematics and Computer Science
 * College of the Holy Cross
 * Worcester, MA, 01610-2395, USA
 */

/*
 * ePiX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ePiX is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ePiX; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef EPIX_INTERSECTIONS
#define EPIX_INTERSECTIONS

namespace ePiX {

  class Circle;
  class Plane;
  class Segment;
  class Sphere;

  Segment operator* (const Circle&,  const Circle&);
  Segment operator* (const Circle&,  const Plane&);
  Segment operator* (const Circle&,  const Segment&);
  Segment operator* (const Circle&,  const Sphere&);

  Segment operator* (const Plane&,   const Plane&);
  P       operator* (const Plane&,   const Segment&);
  Circle  operator* (const Plane&,   const Sphere&);

  P       operator* (const Segment&, const Segment&);
  Segment operator* (const Segment&, const Sphere&);

  Circle  operator* (const Sphere&,  const Sphere&);

  // derived operators with reversed argument order
  Segment operator* (const Plane&,   const Circle&);
  Segment operator* (const Segment&, const Circle&);
  Segment operator* (const Sphere&,  const Circle&);

  P       operator* (const Segment&, const Plane&);
  Circle  operator* (const Sphere&,  const Plane&);

  Segment operator* (const Sphere&,  const Segment&);

} // end of namespace

#endif /* EPIX_INTERSECTIONS */
