/*
 * epw.h - Żҥ֥å/EPWING桼ƥƥ إåե
 *
 *	Written by Junn Ohta (ohta@src.ricoh.co.jp). Public Domain.
 */

typedef	unsigned char	uchr;
typedef	unsigned long	ulng;
typedef	unsigned char	byte;
typedef	unsigned int	word;
typedef	unsigned long	dword;

#define	OK		0
#define	ERR		(-1)

#define	FALSE		0
#define	TRUE		1

/*
 * ҥ֥å
 */
#define	BLKSIZ		2048

/*
 * ʣҴ̻
 */
#define	ID_CINFO	0xff

/*
 * Ҵ֥åι¤
 */
#define	ITEMS_LEN	 2	/* ҹǿ		*/
#define	RESV1_LEN	 2	/* ͽΰ1(Ҽ/ݸ)	*/
#define	IDXHNDL_LEN	 1	/* ǥåμ谷ˡ	*/
#define	RESV2_LEN	11	/* ͽΰ2			*/
				/* (ʲǿ֤)	*/
#define	ITEMID_LEN	 1	/*   ҹǼ̻		*/
#define	RESV3_LEN	 1	/*   ͽΰ3			*/
#define	TOPBLK_LEN	 4	/*   Ƭɥ쥹(֥åֹ)	*/
#define	BLKS_LEN	 4	/*   ΰ襵(֥å)	*/
#define	IDXVALID_LEN	 1	/*   ǥåͭ	*/
#define	IDXINFO_LEN	 3	/*   ǥå	*/
#define	RESV4_LEN	 2	/*   ͽΰ4			*/
				/* (֤)		*/
#define	DSPVALID_LEN	 1	/* ɽˡ;̵ͭե饰 */
#define	RESV5_LEN	 3	/* ͽΰ5			*/
#define	DSPLIST_LEN	 1	/* ɽɽ			*/
#define	DSPSTYLE_LEN	 1	/* ʸɽˡ			*/
#define	RESV6_LEN	10	/* ͽΰ6			*/

/*
 * ʣ縡֥åι¤
 */
#define	CENTS_LEN	 2	/* ʣ票ȥ		*/
#define	CRESV1_LEN	14	/* ͽΰ1			*/
				/* (ʲȥ֤)	*/
#define	CITEMS_LEN	 1	/*   ҹǿ		*/
#define	CRESV2_LEN	 1	/*   ͽΰ2			*/
#define	CNAME_LEN	30	/*   ̾			*/
				/*   (ʲǿ֤)	*/
#define	CITEMID_LEN	 1	/*     ҹǼ̻	*/
#define	CRESV3_LEN	 1	/*     ͽΰ3		*/
#define	CTOPBLK_LEN	 4	/*     Ƭɥ쥹(֥åֹ)*/
#define	CBLKS_LEN	 4	/*     ΰ襵(֥å)	*/
#define	CRESV4_LEN	 6	/*     ͽΰ4		*/
				/*   (֤)		*/
				/* (֤)		*/
/*
 * CRESV4_LENJIS X4081(ʿ8ǯ1130ȯԤ1)ˤ5
 * ºݤνҤǤ6ˤʤäƤ롣
 */

/*
 * 
 */
typedef	struct info_t	INFO_T;		/* Ҵ		*/
typedef	struct item_t	ITEM_T;		/* ҹ		*/
typedef	struct cinfo_t	CINFO_T;	/* ʣ縡	*/
typedef	struct cent_t	CENT_T;		/* ʣ票ȥ		*/
typedef	struct citem_t	CITEM_T;	/* ʣ縡ҹ	*/

/*
 * Ҵ
 */
struct info_t {
    word	items;			/* Ͽҿ		*/
    byte	resv1[RESV1_LEN];	/* ͽΰ1		*/
    byte	idxhndl;		/* ǥåμ谷ˡ */
    byte	resv2[RESV2_LEN];	/* ͽΰ2		*/
    ITEM_T	*item;			/* ҹ		*/
    byte	dspvalid;		/* ̵ͭե饰	*/
    byte	resv5[RESV5_LEN];	/* ͽΰ5		*/
    byte	dsplist;		/* ɽɽ		*/
    byte	dspstyle;		/* ʸɽˡ		*/
    byte	resv6[RESV6_LEN];	/* ͽΰ6		*/
};

/*
 * ҹ
 */
struct item_t {
    byte	itemid;			/* ҹǼ̻	*/
    byte	resv3[RESV3_LEN];	/* ͽΰ3		*/
    dword	topblk;			/* Ƭɥ쥹		*/
    dword	blks;			/* ΰ襵		*/
    byte	idxvalid;		/* ǥåͭ */
    dword	idxinfo;		/* ǥå */
    byte	resv4[RESV4_LEN];	/* ͽΰ4		*/
    CINFO_T	*cinfo;			/* ʣ縡	*/
};

/*
 * ʣ縡
 */
struct cinfo_t {
    word	cents;			/* ʣ票ȥ	*/
    byte	cresv1[CRESV1_LEN];	/* ͽΰ1		*/
    CENT_T	*cent;			/* ʣ票ȥ		*/
};

/*
 * ʣ票ȥ
 */
struct cent_t {
    byte	citems;			/* ҹǿ	*/
    byte	cresv2[CRESV2_LEN];	/* ͽΰ2		*/
    byte	cname[CNAME_LEN];	/* ̾		*/
    CITEM_T	*citem;			/* ʣҹ	*/
};

/*
 * ʣҹ
 */
struct citem_t {
    uchr	citemid;		/* ҹǼ̻	*/
    uchr	cresv3[CRESV3_LEN];	/* ͽΰ3		*/
    dword	ctopblk;		/* Ƭɥ쥹		*/
    dword	cblks;			/* ΰ襵		*/
    uchr	cresv4[CRESV4_LEN];	/* ͽΰ4		*/
};

/*
 * bread.c
 */
int	open_book();
int	close_book();
int	locate_block();
int	read_block();
long	cur_block();
int	cur_off();
byte	getbyte();
word	getword();
dword	getdword();
long	getbcd();
byte	*getbytes();
INFO_T	*getinfo();
void	freeinfo();

/*
 * bwrite.c
 */
int	open_newbook();
int	close_newbook();
int	locate_newblock();
int	write_newblock();
long	cur_newblock();
int	cur_newoff();
int	get_error();
void	reset_error();
int	putbyte();
int	putword();
int	putdword();
int	putbcd();
int	putbytes();
int	putinfo();
