// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016-2017 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  assoc_laguerre
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>


// Test data for n=0, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data001[11] =
{
  { 1.0000000000000000, 0, 0, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  100.00000000000000 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for n=0, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data002[11] =
{
  { 1.0000000000000000, 0, 1, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 1, 
	  100.00000000000000 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for n=0, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data003[11] =
{
  { 1.0000000000000000, 0, 2, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 2, 
	  100.00000000000000 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for n=0, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data004[11] =
{
  { 1.0000000000000000, 0, 5, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 5, 
	  100.00000000000000 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for n=0, m=10.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data005[11] =
{
  { 1.0000000000000000, 0, 10, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 10, 
	  100.00000000000000 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for n=0, m=20.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data006[11] =
{
  { 1.0000000000000000, 0, 20, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 20, 
	  100.00000000000000 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for n=0, m=50.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data007[11] =
{
  { 1.0000000000000000, 0, 50, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 50, 
	  100.00000000000000 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for n=0, m=100.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data008[11] =
{
  { 1.0000000000000000, 0, 100, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  10.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  20.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  30.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  40.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  50.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  60.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  70.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  80.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  90.000000000000000 },
  { 1.0000000000000000, 0, 100, 
	  100.00000000000000 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for n=1, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data009[11] =
{
  { 1.0000000000000000, 1, 0, 
	  0.0000000000000000 },
  { -9.0000000000000000, 1, 0, 
	  10.000000000000000 },
  { -19.000000000000000, 1, 0, 
	  20.000000000000000 },
  { -29.000000000000000, 1, 0, 
	  30.000000000000000 },
  { -39.000000000000000, 1, 0, 
	  40.000000000000000 },
  { -49.000000000000000, 1, 0, 
	  50.000000000000000 },
  { -59.000000000000000, 1, 0, 
	  60.000000000000000 },
  { -69.000000000000000, 1, 0, 
	  70.000000000000000 },
  { -79.000000000000000, 1, 0, 
	  80.000000000000000 },
  { -89.000000000000000, 1, 0, 
	  90.000000000000000 },
  { -99.000000000000000, 1, 0, 
	  100.00000000000000 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for n=1, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data010[11] =
{
  { 2.0000000000000000, 1, 1, 
	  0.0000000000000000 },
  { -8.0000000000000000, 1, 1, 
	  10.000000000000000 },
  { -18.000000000000000, 1, 1, 
	  20.000000000000000 },
  { -28.000000000000000, 1, 1, 
	  30.000000000000000 },
  { -38.000000000000000, 1, 1, 
	  40.000000000000000 },
  { -48.000000000000000, 1, 1, 
	  50.000000000000000 },
  { -58.000000000000000, 1, 1, 
	  60.000000000000000 },
  { -68.000000000000000, 1, 1, 
	  70.000000000000000 },
  { -78.000000000000000, 1, 1, 
	  80.000000000000000 },
  { -88.000000000000000, 1, 1, 
	  90.000000000000000 },
  { -98.000000000000000, 1, 1, 
	  100.00000000000000 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for n=1, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data011[11] =
{
  { 3.0000000000000000, 1, 2, 
	  0.0000000000000000 },
  { -7.0000000000000000, 1, 2, 
	  10.000000000000000 },
  { -17.000000000000000, 1, 2, 
	  20.000000000000000 },
  { -27.000000000000000, 1, 2, 
	  30.000000000000000 },
  { -37.000000000000000, 1, 2, 
	  40.000000000000000 },
  { -47.000000000000000, 1, 2, 
	  50.000000000000000 },
  { -57.000000000000000, 1, 2, 
	  60.000000000000000 },
  { -67.000000000000000, 1, 2, 
	  70.000000000000000 },
  { -77.000000000000000, 1, 2, 
	  80.000000000000000 },
  { -87.000000000000000, 1, 2, 
	  90.000000000000000 },
  { -97.000000000000000, 1, 2, 
	  100.00000000000000 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for n=1, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data012[11] =
{
  { 6.0000000000000000, 1, 5, 
	  0.0000000000000000 },
  { -4.0000000000000000, 1, 5, 
	  10.000000000000000 },
  { -14.000000000000000, 1, 5, 
	  20.000000000000000 },
  { -24.000000000000000, 1, 5, 
	  30.000000000000000 },
  { -34.000000000000000, 1, 5, 
	  40.000000000000000 },
  { -44.000000000000000, 1, 5, 
	  50.000000000000000 },
  { -54.000000000000000, 1, 5, 
	  60.000000000000000 },
  { -64.000000000000000, 1, 5, 
	  70.000000000000000 },
  { -74.000000000000000, 1, 5, 
	  80.000000000000000 },
  { -84.000000000000000, 1, 5, 
	  90.000000000000000 },
  { -94.000000000000000, 1, 5, 
	  100.00000000000000 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for n=1, m=10.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data013[11] =
{
  { 11.000000000000000, 1, 10, 
	  0.0000000000000000 },
  { 1.0000000000000000, 1, 10, 
	  10.000000000000000 },
  { -9.0000000000000000, 1, 10, 
	  20.000000000000000 },
  { -19.000000000000000, 1, 10, 
	  30.000000000000000 },
  { -29.000000000000000, 1, 10, 
	  40.000000000000000 },
  { -39.000000000000000, 1, 10, 
	  50.000000000000000 },
  { -49.000000000000000, 1, 10, 
	  60.000000000000000 },
  { -59.000000000000000, 1, 10, 
	  70.000000000000000 },
  { -69.000000000000000, 1, 10, 
	  80.000000000000000 },
  { -79.000000000000000, 1, 10, 
	  90.000000000000000 },
  { -89.000000000000000, 1, 10, 
	  100.00000000000000 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for n=1, m=20.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data014[11] =
{
  { 21.000000000000000, 1, 20, 
	  0.0000000000000000 },
  { 11.000000000000000, 1, 20, 
	  10.000000000000000 },
  { 1.0000000000000000, 1, 20, 
	  20.000000000000000 },
  { -9.0000000000000000, 1, 20, 
	  30.000000000000000 },
  { -19.000000000000000, 1, 20, 
	  40.000000000000000 },
  { -29.000000000000000, 1, 20, 
	  50.000000000000000 },
  { -39.000000000000000, 1, 20, 
	  60.000000000000000 },
  { -49.000000000000000, 1, 20, 
	  70.000000000000000 },
  { -59.000000000000000, 1, 20, 
	  80.000000000000000 },
  { -69.000000000000000, 1, 20, 
	  90.000000000000000 },
  { -79.000000000000000, 1, 20, 
	  100.00000000000000 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for n=1, m=50.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data015[11] =
{
  { 51.000000000000000, 1, 50, 
	  0.0000000000000000 },
  { 41.000000000000000, 1, 50, 
	  10.000000000000000 },
  { 31.000000000000000, 1, 50, 
	  20.000000000000000 },
  { 21.000000000000000, 1, 50, 
	  30.000000000000000 },
  { 11.000000000000000, 1, 50, 
	  40.000000000000000 },
  { 1.0000000000000000, 1, 50, 
	  50.000000000000000 },
  { -9.0000000000000000, 1, 50, 
	  60.000000000000000 },
  { -19.000000000000000, 1, 50, 
	  70.000000000000000 },
  { -29.000000000000000, 1, 50, 
	  80.000000000000000 },
  { -39.000000000000000, 1, 50, 
	  90.000000000000000 },
  { -49.000000000000000, 1, 50, 
	  100.00000000000000 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for n=1, m=100.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data016[11] =
{
  { 101.00000000000000, 1, 100, 
	  0.0000000000000000 },
  { 91.000000000000000, 1, 100, 
	  10.000000000000000 },
  { 81.000000000000000, 1, 100, 
	  20.000000000000000 },
  { 71.000000000000000, 1, 100, 
	  30.000000000000000 },
  { 61.000000000000000, 1, 100, 
	  40.000000000000000 },
  { 51.000000000000000, 1, 100, 
	  50.000000000000000 },
  { 41.000000000000000, 1, 100, 
	  60.000000000000000 },
  { 31.000000000000000, 1, 100, 
	  70.000000000000000 },
  { 21.000000000000000, 1, 100, 
	  80.000000000000000 },
  { 11.000000000000000, 1, 100, 
	  90.000000000000000 },
  { 1.0000000000000000, 1, 100, 
	  100.00000000000000 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for n=2, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data017[11] =
{
  { 1.0000000000000000, 2, 0, 
	  0.0000000000000000 },
  { 31.000000000000000, 2, 0, 
	  10.000000000000000 },
  { 161.00000000000000, 2, 0, 
	  20.000000000000000 },
  { 391.00000000000000, 2, 0, 
	  30.000000000000000 },
  { 721.00000000000000, 2, 0, 
	  40.000000000000000 },
  { 1151.0000000000000, 2, 0, 
	  50.000000000000000 },
  { 1681.0000000000000, 2, 0, 
	  60.000000000000000 },
  { 2311.0000000000000, 2, 0, 
	  70.000000000000000 },
  { 3041.0000000000000, 2, 0, 
	  80.000000000000000 },
  { 3871.0000000000000, 2, 0, 
	  90.000000000000000 },
  { 4801.0000000000000, 2, 0, 
	  100.00000000000000 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for n=2, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data018[11] =
{
  { 3.0000000000000000, 2, 1, 
	  0.0000000000000000 },
  { 23.000000000000000, 2, 1, 
	  10.000000000000000 },
  { 143.00000000000000, 2, 1, 
	  20.000000000000000 },
  { 363.00000000000000, 2, 1, 
	  30.000000000000000 },
  { 683.00000000000000, 2, 1, 
	  40.000000000000000 },
  { 1103.0000000000000, 2, 1, 
	  50.000000000000000 },
  { 1623.0000000000000, 2, 1, 
	  60.000000000000000 },
  { 2243.0000000000000, 2, 1, 
	  70.000000000000000 },
  { 2963.0000000000000, 2, 1, 
	  80.000000000000000 },
  { 3783.0000000000000, 2, 1, 
	  90.000000000000000 },
  { 4703.0000000000000, 2, 1, 
	  100.00000000000000 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for n=2, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data019[11] =
{
  { 6.0000000000000000, 2, 2, 
	  0.0000000000000000 },
  { 16.000000000000000, 2, 2, 
	  10.000000000000000 },
  { 126.00000000000000, 2, 2, 
	  20.000000000000000 },
  { 336.00000000000000, 2, 2, 
	  30.000000000000000 },
  { 646.00000000000000, 2, 2, 
	  40.000000000000000 },
  { 1056.0000000000000, 2, 2, 
	  50.000000000000000 },
  { 1566.0000000000000, 2, 2, 
	  60.000000000000000 },
  { 2176.0000000000000, 2, 2, 
	  70.000000000000000 },
  { 2886.0000000000000, 2, 2, 
	  80.000000000000000 },
  { 3696.0000000000000, 2, 2, 
	  90.000000000000000 },
  { 4606.0000000000000, 2, 2, 
	  100.00000000000000 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for n=2, m=5.
// max(|f - f_GSL|): 4.5519144009631418e-15
// max(|f - f_GSL| / |f_GSL|): 4.5519144009631623e-15
const testcase_assoc_laguerre<double>
data020[11] =
{
  { 21.000000000000000, 2, 5, 
	  0.0000000000000000 },
  { 0.99999999999999545, 2, 5, 
	  10.000000000000000 },
  { 81.000000000000000, 2, 5, 
	  20.000000000000000 },
  { 261.00000000000000, 2, 5, 
	  30.000000000000000 },
  { 541.00000000000000, 2, 5, 
	  40.000000000000000 },
  { 921.00000000000000, 2, 5, 
	  50.000000000000000 },
  { 1401.0000000000000, 2, 5, 
	  60.000000000000000 },
  { 1981.0000000000000, 2, 5, 
	  70.000000000000000 },
  { 2661.0000000000000, 2, 5, 
	  80.000000000000000 },
  { 3441.0000000000000, 2, 5, 
	  90.000000000000000 },
  { 4321.0000000000000, 2, 5, 
	  100.00000000000000 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for n=2, m=10.
// max(|f - f_GSL|): 3.5527136788005009e-14
// max(|f - f_GSL| / |f_GSL|): 2.4424906541753385e-15
const testcase_assoc_laguerre<double>
data021[11] =
{
  { 66.000000000000000, 2, 10, 
	  0.0000000000000000 },
  { -4.0000000000000098, 2, 10, 
	  10.000000000000000 },
  { 25.999999999999964, 2, 10, 
	  20.000000000000000 },
  { 156.00000000000000, 2, 10, 
	  30.000000000000000 },
  { 386.00000000000000, 2, 10, 
	  40.000000000000000 },
  { 716.00000000000000, 2, 10, 
	  50.000000000000000 },
  { 1146.0000000000000, 2, 10, 
	  60.000000000000000 },
  { 1676.0000000000000, 2, 10, 
	  70.000000000000000 },
  { 2306.0000000000000, 2, 10, 
	  80.000000000000000 },
  { 3036.0000000000000, 2, 10, 
	  90.000000000000000 },
  { 3866.0000000000000, 2, 10, 
	  100.00000000000000 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for n=2, m=20.
// max(|f - f_GSL|): 5.6843418860808015e-13
// max(|f - f_GSL| / |f_GSL|): 5.9211894646674663e-15
const testcase_assoc_laguerre<double>
data022[11] =
{
  { 231.00000000000000, 2, 20, 
	  0.0000000000000000 },
  { 61.000000000000206, 2, 20, 
	  10.000000000000000 },
  { -9.0000000000000053, 2, 20, 
	  20.000000000000000 },
  { 21.000000000000124, 2, 20, 
	  30.000000000000000 },
  { 151.00000000000057, 2, 20, 
	  40.000000000000000 },
  { 381.00000000000000, 2, 20, 
	  50.000000000000000 },
  { 711.00000000000000, 2, 20, 
	  60.000000000000000 },
  { 1141.0000000000000, 2, 20, 
	  70.000000000000000 },
  { 1670.9999999999998, 2, 20, 
	  80.000000000000000 },
  { 2301.0000000000000, 2, 20, 
	  90.000000000000000 },
  { 3031.0000000000000, 2, 20, 
	  100.00000000000000 },
};
const double toler022 = 5.0000000000000039e-13;

// Test data for n=2, m=50.
// max(|f - f_GSL|): 3.6379788070917130e-12
// max(|f - f_GSL| / |f_GSL|): 1.9243865760169750e-14
const testcase_assoc_laguerre<double>
data023[11] =
{
  { 1326.0000000000000, 2, 50, 
	  0.0000000000000000 },
  { 855.99999999999693, 2, 50, 
	  10.000000000000000 },
  { 485.99999999999835, 2, 50, 
	  20.000000000000000 },
  { 215.99999999999937, 2, 50, 
	  30.000000000000000 },
  { 45.999999999999829, 2, 50, 
	  40.000000000000000 },
  { -23.999999999999538, 2, 50, 
	  50.000000000000000 },
  { 6.0000000000001057, 2, 50, 
	  60.000000000000000 },
  { 135.99999999999963, 2, 50, 
	  70.000000000000000 },
  { 365.99999999999892, 2, 50, 
	  80.000000000000000 },
  { 695.99999999999784, 2, 50, 
	  90.000000000000000 },
  { 1125.9999999999964, 2, 50, 
	  100.00000000000000 },
};
const double toler023 = 1.0000000000000008e-12;

// Test data for n=2, m=100.
// max(|f - f_GSL|): 6.5483618527650833e-11
// max(|f - f_GSL| / |f_GSL|): 1.6416871873157281e-14
const testcase_assoc_laguerre<double>
data024[11] =
{
  { 5151.0000000000000, 2, 100, 
	  0.0000000000000000 },
  { 4181.0000000000655, 2, 100, 
	  10.000000000000000 },
  { 3311.0000000000518, 2, 100, 
	  20.000000000000000 },
  { 2541.0000000000400, 2, 100, 
	  30.000000000000000 },
  { 1871.0000000000291, 2, 100, 
	  40.000000000000000 },
  { 1301.0000000000207, 2, 100, 
	  50.000000000000000 },
  { 831.00000000001364, 2, 100, 
	  60.000000000000000 },
  { 461.00000000000682, 2, 100, 
	  70.000000000000000 },
  { 191.00000000000250, 2, 100, 
	  80.000000000000000 },
  { 21.000000000000046, 2, 100, 
	  90.000000000000000 },
  { -48.999999999999915, 2, 100, 
	  100.00000000000000 },
};
const double toler024 = 1.0000000000000008e-12;

// Test data for n=5, m=0.
// max(|f - f_GSL|): 7.4505805969238281e-09
// max(|f - f_GSL| / |f_GSL|): 1.9501553136894460e-16
const testcase_assoc_laguerre<double>
data025[11] =
{
  { 1.0000000000000000, 5, 0, 
	  0.0000000000000000 },
  { 34.333333333333329, 5, 0, 
	  10.000000000000000 },
  { -4765.6666666666670, 5, 0, 
	  20.000000000000000 },
  { -74399.000000000000, 5, 0, 
	  30.000000000000000 },
  { -418865.66666666663, 5, 0, 
	  40.000000000000000 },
  { -1498165.6666666665, 5, 0, 
	  50.000000000000000 },
  { -4122299.0000000000, 5, 0, 
	  60.000000000000000 },
  { -9551265.6666666679, 5, 0, 
	  70.000000000000000 },
  { -19595065.666666664, 5, 0, 
	  80.000000000000000 },
  { -36713699.000000000, 5, 0, 
	  90.000000000000000 },
  { -64117165.666666664, 5, 0, 
	  100.00000000000000 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for n=5, m=1.
// max(|f - f_GSL|): 3.7252902984619141e-09
// max(|f - f_GSL| / |f_GSL|): 3.1347473636475015e-16
const testcase_assoc_laguerre<double>
data026[11] =
{
  { 6.0000000000000000, 5, 1, 
	  0.0000000000000000 },
  { 22.666666666666661, 5, 1, 
	  10.000000000000000 },
  { -2960.6666666666661, 5, 1, 
	  20.000000000000000 },
  { -58944.000000000000, 5, 1, 
	  30.000000000000000 },
  { -357927.33333333326, 5, 1, 
	  40.000000000000000 },
  { -1329910.6666666665, 5, 1, 
	  50.000000000000000 },
  { -3744894.0000000000, 5, 1, 
	  60.000000000000000 },
  { -8812877.3333333321, 5, 1, 
	  70.000000000000000 },
  { -18283860.666666664, 5, 1, 
	  80.000000000000000 },
  { -34547844.000000000, 5, 1, 
	  90.000000000000000 },
  { -60734827.333333336, 5, 1, 
	  100.00000000000000 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for n=5, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_laguerre<double>
data027[11] =
{
  { 21.000000000000000, 5, 2, 
	  0.0000000000000000 },
  { 4.3333333333333339, 5, 2, 
	  10.000000000000000 },
  { -1679.0000000000000, 5, 2, 
	  20.000000000000000 },
  { -46029.000000000000, 5, 2, 
	  30.000000000000000 },
  { -304045.66666666669, 5, 2, 
	  40.000000000000000 },
  { -1176729.0000000002, 5, 2, 
	  50.000000000000000 },
  { -3395079.0000000000, 5, 2, 
	  60.000000000000000 },
  { -8120095.6666666660, 5, 2, 
	  70.000000000000000 },
  { -17042778.999999996, 5, 2, 
	  80.000000000000000 },
  { -32484129.000000000, 5, 2, 
	  90.000000000000000 },
  { -57495145.666666664, 5, 2, 
	  100.00000000000000 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for n=5, m=5.
// max(|f - f_GSL|): 7.4505805969238281e-09
// max(|f - f_GSL| / |f_GSL|): 1.7763568394002536e-15
const testcase_assoc_laguerre<double>
data028[11] =
{
  { 252.00000000000000, 5, 5, 
	  0.0000000000000000 },
  { -14.666666666666654, 5, 5, 
	  10.000000000000000 },
  { 51.999999999999908, 5, 5, 
	  20.000000000000000 },
  { -19548.000000000000, 5, 5, 
	  30.000000000000000 },
  { -178814.66666666660, 5, 5, 
	  40.000000000000000 },
  { -797747.99999999977, 5, 5, 
	  50.000000000000000 },
  { -2496348.0000000000, 5, 5, 
	  60.000000000000000 },
  { -6294614.6666666660, 5, 5, 
	  70.000000000000000 },
  { -13712547.999999996, 5, 5, 
	  80.000000000000000 },
  { -26870147.999999993, 5, 5, 
	  90.000000000000000 },
  { -48587414.666666672, 5, 5, 
	  100.00000000000000 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for n=5, m=10.
// max(|f - f_GSL|): 7.4505805969238281e-09
// max(|f - f_GSL| / |f_GSL|): 1.9556222085140405e-15
const testcase_assoc_laguerre<double>
data029[11] =
{
  { 3003.0000000000000, 5, 10, 
	  0.0000000000000000 },
  { 19.666666666666668, 5, 10, 
	  10.000000000000000 },
  { 36.333333333333272, 5, 10, 
	  20.000000000000000 },
  { -1947.0000000000000, 5, 10, 
	  30.000000000000000 },
  { -60930.333333333314, 5, 10, 
	  40.000000000000000 },
  { -381913.66666666651, 5, 10, 
	  50.000000000000000 },
  { -1419897.0000000000, 5, 10, 
	  60.000000000000000 },
  { -3979880.3333333330, 5, 10, 
	  70.000000000000000 },
  { -9316863.6666666642, 5, 10, 
	  80.000000000000000 },
  { -19235847.000000000, 5, 10, 
	  90.000000000000000 },
  { -36191830.333333328, 5, 10, 
	  100.00000000000000 },
};
const double toler029 = 2.5000000000000020e-13;

// Test data for n=5, m=20.
// max(|f - f_GSL|): 1.8626451492309570e-09
// max(|f - f_GSL| / |f_GSL|): 2.8421709430404088e-15
const testcase_assoc_laguerre<double>
data030[11] =
{
  { 53130.000000000000, 5, 20, 
	  0.0000000000000000 },
  { 1213.3333333333335, 5, 20, 
	  10.000000000000000 },
  { 129.99999999999963, 5, 20, 
	  20.000000000000000 },
  { -119.99999999999974, 5, 20, 
	  30.000000000000000 },
  { 463.33333333333320, 5, 20, 
	  40.000000000000000 },
  { -48120.000000000015, 5, 20, 
	  50.000000000000000 },
  { -345870.00000000017, 5, 20, 
	  60.000000000000000 },
  { -1342786.6666666667, 5, 20, 
	  70.000000000000000 },
  { -3838870.0000000009, 5, 20, 
	  80.000000000000000 },
  { -9084120.0000000000, 5, 20, 
	  90.000000000000000 },
  { -18878536.666666668, 5, 20, 
	  100.00000000000000 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for n=5, m=50.
// max(|f - f_GSL|): 5.8207660913467407e-11
// max(|f - f_GSL| / |f_GSL|): 8.3212917817998576e-15
const testcase_assoc_laguerre<double>
data031[11] =
{
  { 3478761.0000000000, 5, 50, 
	  0.0000000000000000 },
  { 1154544.3333333335, 5, 50, 
	  10.000000000000000 },
  { 264661.00000000006, 5, 50, 
	  20.000000000000000 },
  { 24111.000000000033, 5, 50, 
	  30.000000000000000 },
  { -2105.6666666666665, 5, 50, 
	  40.000000000000000 },
  { 1010.9999999999916, 5, 50, 
	  50.000000000000000 },
  { -1538.9999999999955, 5, 50, 
	  60.000000000000000 },
  { 5244.3333333333449, 5, 50, 
	  70.000000000000000 },
  { -13639.000000000011, 5, 50, 
	  80.000000000000000 },
  { -243189.00000000006, 5, 50, 
	  90.000000000000000 },
  { -1118405.6666666667, 5, 50, 
	  100.00000000000000 },
};
const double toler031 = 5.0000000000000039e-13;

// Test data for n=5, m=100.
// max(|f - f_GSL|): 1.4901161193847656e-08
// max(|f - f_GSL| / |f_GSL|): 4.3934583843896481e-16
const testcase_assoc_laguerre<double>
data032[11] =
{
  { 96560646.000000000, 5, 100, 
	  0.0000000000000000 },
  { 57264262.666666649, 5, 100, 
	  10.000000000000000 },
  { 31841379.333333332, 5, 100, 
	  20.000000000000000 },
  { 16281996.000000000, 5, 100, 
	  30.000000000000000 },
  { 7426112.6666666670, 5, 100, 
	  40.000000000000000 },
  { 2863729.3333333330, 5, 100, 
	  50.000000000000000 },
  { 834846.00000000000, 5, 100, 
	  60.000000000000000 },
  { 129462.66666666663, 5, 100, 
	  70.000000000000000 },
  { -12420.666666666668, 5, 100, 
	  80.000000000000000 },
  { -804.00000000000000, 5, 100, 
	  90.000000000000000 },
  { 4312.6666666666670, 5, 100, 
	  100.00000000000000 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for n=10, m=0.
// max(|f - f_GSL|): 6.1035156250000000e-05
// max(|f - f_GSL| / |f_GSL|): 6.1315986390500118e-15
const testcase_assoc_laguerre<double>
data033[11] =
{
  { 1.0000000000000000, 10, 0, 
	  0.0000000000000000 },
  { 27.984126984126977, 10, 0, 
	  10.000000000000000 },
  { 3227.8077601410932, 10, 0, 
	  20.000000000000000 },
  { 15129.571428571455, 10, 0, 
	  30.000000000000000 },
  { 79724066.608465582, 10, 0, 
	  40.000000000000000 },
  { 2037190065.3738980, 10, 0, 
	  50.000000000000000 },
  { 21804200401.000000, 10, 0, 
	  60.000000000000000 },
  { 144688291819.51855, 10, 0, 
	  70.000000000000000 },
  { 703324772760.08276, 10, 0, 
	  80.000000000000000 },
  { 2741055412243.8569, 10, 0, 
	  90.000000000000000 },
  { 9051283795429.5723, 10, 0, 
	  100.00000000000000 },
};
const double toler033 = 5.0000000000000039e-13;

// Test data for n=10, m=1.
// max(|f - f_GSL|): 0.0019531250000000000
// max(|f - f_GSL| / |f_GSL|): 3.2082933888884751e-16
const testcase_assoc_laguerre<double>
data034[11] =
{
  { 11.000000000000000, 10, 1, 
	  0.0000000000000000 },
  { 14.791887125220455, 10, 1, 
	  10.000000000000000 },
  { 2704.6507936507933, 10, 1, 
	  20.000000000000000 },
  { -182924.71428571423, 10, 1, 
	  30.000000000000000 },
  { 48066036.749559075, 10, 1, 
	  40.000000000000000 },
  { 1486264192.2169311, 10, 1, 
	  50.000000000000000 },
  { 17239562282.428574, 10, 1, 
	  60.000000000000000 },
  { 119837491630.13579, 10, 1, 
	  70.000000000000000 },
  { 600681375251.21167, 10, 1, 
	  80.000000000000000 },
  { 2392908405632.4287, 10, 1, 
	  90.000000000000000 },
  { 8033035722509.2373, 10, 1, 
	  100.00000000000000 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for n=10, m=2.
// max(|f - f_GSL|): 0.00012207031250000000
// max(|f - f_GSL| / |f_GSL|): 3.0884259455918855e-16
const testcase_assoc_laguerre<double>
data035[11] =
{
  { 66.000000000000000, 10, 2, 
	  0.0000000000000000 },
  { -14.511463844797181, 10, 2, 
	  10.000000000000000 },
  { 1064.5890652557316, 10, 2, 
	  20.000000000000000 },
  { -194569.71428571429, 10, 2, 
	  30.000000000000000 },
  { 27343569.350970022, 10, 2, 
	  40.000000000000000 },
  { 1067807661.6790125, 10, 2, 
	  50.000000000000000 },
  { 13529451580.285711, 10, 2, 
	  60.000000000000000 },
  { 98812724224.641937, 10, 2, 
	  70.000000000000000 },
  { 511482736187.34021, 10, 2, 
	  80.000000000000000 },
  { 2084478393087.4285, 10, 2, 
	  90.000000000000000 },
  { 7117724862237.0752, 10, 2, 
	  100.00000000000000 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for n=10, m=5.
// max(|f - f_GSL|): 0.0019531250000000000
// max(|f - f_GSL| / |f_GSL|): 5.4929549774030811e-15
const testcase_assoc_laguerre<double>
data036[11] =
{
  { 3003.0000000000000, 10, 5, 
	  0.0000000000000000 },
  { 11.641975308642031, 10, 5, 
	  10.000000000000000 },
  { -1137.5643738977069, 10, 5, 
	  20.000000000000000 },
  { -9254.1428571428605, 10, 5, 
	  30.000000000000000 },
  { 2121878.8377425023, 10, 5, 
	  40.000000000000000 },
  { 352060171.43033499, 10, 5, 
	  50.000000000000000 },
  { 6212028560.1428576, 10, 5, 
	  60.000000000000000 },
  { 53782171674.604919, 10, 5, 
	  70.000000000000000 },
  { 309720255837.56775, 10, 5, 
	  80.000000000000000 },
  { 1359043035731.5713, 10, 5, 
	  90.000000000000000 },
  { 4900625954398.9434, 10, 5, 
	  100.00000000000000 },
};
const double toler036 = 5.0000000000000039e-13;

// Test data for n=10, m=10.
// max(|f - f_GSL|): 0.00048828125000000000
// max(|f - f_GSL| / |f_GSL|): 1.2999856205575476e-15
const testcase_assoc_laguerre<double>
data037[11] =
{
  { 184756.00000000000, 10, 10, 
	  0.0000000000000000 },
  { -210.84303350970018, 10, 10, 
	  10.000000000000000 },
  { 508.38095238095184, 10, 10, 
	  20.000000000000000 },
  { 2098.8571428571431, 10, 10, 
	  30.000000000000000 },
  { -536338.88536155177, 10, 10, 
	  40.000000000000000 },
  { 24865988.804232784, 10, 10, 
	  50.000000000000000 },
  { 1343756013.1428571, 10, 10, 
	  60.000000000000000 },
  { 17298791247.358025, 10, 10, 
	  70.000000000000000 },
  { 124528450897.79892, 10, 10, 
	  80.000000000000000 },
  { 632674413641.71423, 10, 10, 
	  90.000000000000000 },
  { 2533008935405.0298, 10, 10, 
	  100.00000000000000 },
};
const double toler037 = 2.5000000000000020e-13;

// Test data for n=10, m=20.
// max(|f - f_GSL|): 1.1444091796875000e-05
// max(|f - f_GSL| / |f_GSL|): 1.3165826881543491e-14
const testcase_assoc_laguerre<double>
data038[11] =
{
  { 30045014.999999993, 10, 20, 
	  0.0000000000000000 },
  { -23087.733686067022, 10, 20, 
	  10.000000000000000 },
  { 207.23985890652330, 10, 20, 
	  20.000000000000000 },
  { 1407.8571428571508, 10, 20, 
	  30.000000000000000 },
  { -44618.156966490322, 10, 20, 
	  40.000000000000000 },
  { 158690.04409171100, 10, 20, 
	  50.000000000000000 },
  { -6870413.5714285728, 10, 20, 
	  60.000000000000000 },
  { 793841351.41975331, 10, 20, 
	  70.000000000000000 },
  { 13358288958.562618, 10, 20, 
	  80.000000000000000 },
  { 106073722407.85715, 10, 20, 
	  90.000000000000000 },
  { 566337213392.42493, 10, 20, 
	  100.00000000000000 },
};
const double toler038 = 1.0000000000000008e-12;

// Test data for n=10, m=50.
// max(|f - f_GSL|): 1.7881393432617188e-07
// max(|f - f_GSL| / |f_GSL|): 1.9220038158581863e-14
const testcase_assoc_laguerre<double>
data039[11] =
{
  { 75394027566.000000, 10, 50, 
	  0.0000000000000000 },
  { 8048106183.3721361, 10, 50, 
	  10.000000000000000 },
  { 328045023.84832460, 10, 50, 
	  20.000000000000000 },
  { -2568769.7142857178, 10, 50, 
	  30.000000000000000 },
  { 6971.9964726631533, 10, 50, 
	  40.000000000000000 },
  { 136111.41446207993, 10, 50, 
	  50.000000000000000 },
  { -62462.571428570242, 10, 50, 
	  60.000000000000000 },
  { -248167.95061728527, 10, 50, 
	  70.000000000000000 },
  { 1941270.4091710770, 10, 50, 
	  80.000000000000000 },
  { -8643512.5714285765, 10, 50, 
	  90.000000000000000 },
  { -140863522.18342152, 10, 50, 
	  100.00000000000000 },
};
const double toler039 = 1.0000000000000008e-12;

// Test data for n=10, m=100.
// max(|f - f_GSL|): 0.0019531250000000000
// max(|f - f_GSL| / |f_GSL|): 8.5796208358610616e-15
const testcase_assoc_laguerre<double>
data040[11] =
{
  { 46897636623981.000, 10, 100, 
	  0.0000000000000000 },
  { 16444031323272.084, 10, 100, 
	  10.000000000000000 },
  { 5020343986463.5391, 10, 100, 
	  20.000000000000000 },
  { 1270977490645.2859, 10, 100, 
	  30.000000000000000 },
  { 244835756822.62262, 10, 100, 
	  40.000000000000000 },
  { 29786827693.962959, 10, 100, 
	  50.000000000000000 },
  { 1127612095.2857144, 10, 100, 
	  60.000000000000000 },
  { -66370555.419753075, 10, 100, 
	  70.000000000000000 },
  { 10420852.957671870, 10, 100, 
	  80.000000000000000 },
  { -3373097.5714285718, 10, 100, 
	  90.000000000000000 },
  { 2065423.6807760145, 10, 100, 
	  100.00000000000000 },
};
const double toler040 = 5.0000000000000039e-13;

// Test data for n=20, m=0.
// max(|f - f_GSL|): 20.000000000000000
// max(|f - f_GSL| / |f_GSL|): 4.7350442720305269e-15
const testcase_assoc_laguerre<double>
data041[11] =
{
  { 1.0000000000000000, 20, 0, 
	  0.0000000000000000 },
  { -11.961333867812119, 20, 0, 
	  10.000000000000000 },
  { 2829.4728613531743, 20, 0, 
	  20.000000000000000 },
  { -18439.424502520938, 20, 0, 
	  30.000000000000000 },
  { 24799805.877530713, 20, 0, 
	  40.000000000000000 },
  { 7551960453.7672548, 20, 0, 
	  50.000000000000000 },
  { -1379223608444.9155, 20, 0, 
	  60.000000000000000 },
  { 165423821874449.94, 20, 0, 
	  70.000000000000000 },
  { 29500368536981676., 20, 0, 
	  80.000000000000000 },
  { 1.1292309514432901e+18, 20, 0, 
	  90.000000000000000 },
  { 2.2061882785931735e+19, 20, 0, 
	  100.00000000000000 },
};
const double toler041 = 2.5000000000000020e-13;

// Test data for n=20, m=1.
// max(|f - f_GSL|): 8192.0000000000000
// max(|f - f_GSL| / |f_GSL|): 2.0583579235866667e-15
const testcase_assoc_laguerre<double>
data042[11] =
{
  { 21.000000000000000, 20, 1, 
	  0.0000000000000000 },
  { 19.900488129734079, 20, 1, 
	  10.000000000000000 },
  { 2208.0318569557585, 20, 1, 
	  20.000000000000000 },
  { 263690.96303121914, 20, 1, 
	  30.000000000000000 },
  { 40667285.630564235, 20, 1, 
	  40.000000000000000 },
  { 1737442572.8115399, 20, 1, 
	  50.000000000000000 },
  { -588280953643.28125, 20, 1, 
	  60.000000000000000 },
  { 45617733778241.328, 20, 1, 
	  70.000000000000000 },
  { 17293487114876864., 20, 1, 
	  80.000000000000000 },
  { 7.6219135858585062e+17, 20, 1, 
	  90.000000000000000 },
  { 1.6037288204336759e+19, 20, 1, 
	  100.00000000000000 },
};
const double toler042 = 2.5000000000000020e-13;

// Test data for n=20, m=2.
// max(|f - f_GSL|): 6144.0000000000000
// max(|f - f_GSL| / |f_GSL|): 9.3068805041852228e-15
const testcase_assoc_laguerre<double>
data043[11] =
{
  { 231.00000000000003, 20, 2, 
	  0.0000000000000000 },
  { 47.009338065112921, 20, 2, 
	  10.000000000000000 },
  { -652.51305461728589, 20, 2, 
	  20.000000000000000 },
  { 285388.25895069109, 20, 2, 
	  30.000000000000000 },
  { 28664069.685624730, 20, 2, 
	  40.000000000000000 },
  { -1399631966.3144732, 20, 2, 
	  50.000000000000000 },
  { -115357373248.28194, 20, 2, 
	  60.000000000000000 },
  { -3357730872975.8750, 20, 2, 
	  70.000000000000000 },
  { 9765808962855122.0, 20, 2, 
	  80.000000000000000 },
  { 5.0717292945559181e+17, 20, 2, 
	  90.000000000000000 },
  { 1.1564665701334456e+19, 20, 2, 
	  100.00000000000000 },
};
const double toler043 = 5.0000000000000039e-13;

// Test data for n=20, m=5.
// max(|f - f_GSL|): 16.000000000000000
// max(|f - f_GSL| / |f_GSL|): 3.5731302592472765e-15
const testcase_assoc_laguerre<double>
data044[11] =
{
  { 53130.000000000000, 20, 5, 
	  0.0000000000000000 },
  { -158.69554500944142, 20, 5, 
	  10.000000000000000 },
  { 334.08012288038952, 20, 5, 
	  20.000000000000000 },
  { -198372.47662554163, 20, 5, 
	  30.000000000000000 },
  { -13627144.088579426, 20, 5, 
	  40.000000000000000 },
  { -780579985.44731510, 20, 5, 
	  50.000000000000000 },
  { 116648634237.73535, 20, 5, 
	  60.000000000000000 },
  { -12347348707739.742, 20, 5, 
	  70.000000000000000 },
  { 1199516248034090.8, 20, 5, 
	  80.000000000000000 },
  { 1.3451503195078531e+17, 20, 5, 
	  90.000000000000000 },
  { 4.1058904276111483e+18, 20, 5, 
	  100.00000000000000 },
};
const double toler044 = 2.5000000000000020e-13;

// Test data for n=20, m=10.
// max(|f - f_GSL|): 64.000000000000000
// max(|f - f_GSL| / |f_GSL|): 1.0709209504860220e-15
const testcase_assoc_laguerre<double>
data045[11] =
{
  { 30045015.000000000, 20, 10, 
	  0.0000000000000000 },
  { -1755.6226861258601, 20, 10, 
	  10.000000000000000 },
  { -9081.6726644737901, 20, 10, 
	  20.000000000000000 },
  { 95771.650912113109, 20, 10, 
	  30.000000000000000 },
  { 5089151.9272779236, 20, 10, 
	  40.000000000000000 },
  { 97400399.450206712, 20, 10, 
	  50.000000000000000 },
  { -16009352450.477026, 20, 10, 
	  60.000000000000000 },
  { 842271286905.01050, 20, 10, 
	  70.000000000000000 },
  { -79901725466796.938, 20, 10, 
	  80.000000000000000 },
  { 7944103675858637.0, 20, 10, 
	  90.000000000000000 },
  { 5.7429821893388288e+17, 20, 10, 
	  100.00000000000000 },
};
const double toler045 = 2.5000000000000020e-13;

// Test data for n=20, m=20.
// max(|f - f_GSL|): 2.1250000000000000
// max(|f - f_GSL| / |f_GSL|): 1.1968937782285294e-14
const testcase_assoc_laguerre<double>
data046[11] =
{
  { 137846528819.99994, 20, 20, 
	  0.0000000000000000 },
  { -136976.49571333229, 20, 20, 
	  10.000000000000000 },
  { 113878.49908041643, 20, 20, 
	  20.000000000000000 },
  { -342529.21778796182, 20, 20, 
	  30.000000000000000 },
  { -350112.66981443466, 20, 20, 
	  40.000000000000000 },
  { -10791735.172977809, 20, 20, 
	  50.000000000000000 },
  { -1038073940.0811402, 20, 20, 
	  60.000000000000000 },
  { 667312550.63616335, 20, 20, 
	  70.000000000000000 },
  { 741537869902.29028, 20, 20, 
	  80.000000000000000 },
  { -32378376755737.418, 20, 20, 
	  90.000000000000000 },
  { -601760332167937.62, 20, 20, 
	  100.00000000000000 },
};
const double toler046 = 1.0000000000000008e-12;

// Test data for n=20, m=50.
// max(|f - f_GSL|): 0.25000000000000000
// max(|f - f_GSL| / |f_GSL|): 1.2103144092558234e-14
const testcase_assoc_laguerre<double>
data047[11] =
{
  { 1.6188460366265789e+17, 20, 50, 
	  0.0000000000000000 },
  { 1599011936804291.5, 20, 50, 
	  10.000000000000000 },
  { -131273880831.42432, 20, 50, 
	  20.000000000000000 },
  { -3133213093.6903548, 20, 50, 
	  30.000000000000000 },
  { -213935628.04985175, 20, 50, 
	  40.000000000000000 },
  { -47375578.495921060, 20, 50, 
	  50.000000000000000 },
  { -115731015.14034876, 20, 50, 
	  60.000000000000000 },
  { -737415147.29420292, 20, 50, 
	  70.000000000000000 },
  { -2123455626.8621769, 20, 50, 
	  80.000000000000000 },
  { 29801266858.608929, 20, 50, 
	  90.000000000000000 },
  { -132886631026.82553, 20, 50, 
	  100.00000000000000 },
};
const double toler047 = 1.0000000000000008e-12;

// Test data for n=20, m=100.
// max(|f - f_GSL|): 1572864.0000000000
// max(|f - f_GSL| / |f_GSL|): 3.6621229371267356e-14
const testcase_assoc_laguerre<double>
data048[11] =
{
  { 2.9462227291176643e+22, 20, 100, 
	  0.0000000000000000 },
  { 3.5777890748701244e+21, 20, 100, 
	  10.000000000000000 },
  { 3.1584925521456759e+20, 20, 100, 
	  20.000000000000000 },
  { 1.7389599388424864e+19, 20, 100, 
	  30.000000000000000 },
  { 4.1401342745980634e+17, 20, 100, 
	  40.000000000000000 },
  { -79359706102062.594, 20, 100, 
	  50.000000000000000 },
  { 22736203650743.145, 20, 100, 
	  60.000000000000000 },
  { 65679006380.095703, 20, 100, 
	  70.000000000000000 },
  { -236263257610.77792, 20, 100, 
	  80.000000000000000 },
  { -38072644585.303101, 20, 100, 
	  90.000000000000000 },
  { 68236474365.173973, 20, 100, 
	  100.00000000000000 },
};
const double toler048 = 2.5000000000000015e-12;

// Test data for n=50, m=0.
// max(|f - f_GSL|): 196608.00000000000
// max(|f - f_GSL| / |f_GSL|): 4.2910775919271532e-15
const testcase_assoc_laguerre<double>
data049[11] =
{
  { 1.0000000000000000, 50, 0, 
	  0.0000000000000000 },
  { 17.534183446338233, 50, 0, 
	  10.000000000000000 },
  { 980.26961889791028, 50, 0, 
	  20.000000000000000 },
  { 293000.50735962362, 50, 0, 
	  30.000000000000000 },
  { -14896937.968694873, 50, 0, 
	  40.000000000000000 },
  { 2513677852.6916871, 50, 0, 
	  50.000000000000000 },
  { -883876565337.99219, 50, 0, 
	  60.000000000000000 },
  { -80967880733583.234, 50, 0, 
	  70.000000000000000 },
  { -8217471769564841.0, 50, 0, 
	  80.000000000000000 },
  { -2.1140031308048891e+18, 50, 0, 
	  90.000000000000000 },
  { -3.9710103487094692e+20, 50, 0, 
	  100.00000000000000 },
};
const double toler049 = 2.5000000000000020e-13;

// Test data for n=50, m=1.
// max(|f - f_GSL|): 311296.00000000000
// max(|f - f_GSL| / |f_GSL|): 4.3113718426975911e-14
const testcase_assoc_laguerre<double>
data050[11] =
{
  { 51.000000000000021, 50, 1, 
	  0.0000000000000000 },
  { 1.4214573271639575, 50, 1, 
	  10.000000000000000 },
  { -2574.8072295127827, 50, 1, 
	  20.000000000000000 },
  { 35846.479728359205, 50, 1, 
	  30.000000000000000 },
  { -48263698.768318526, 50, 1, 
	  40.000000000000000 },
  { 6161525870.2738533, 50, 1, 
	  50.000000000000000 },
  { -382655486658.47125, 50, 1, 
	  60.000000000000000 },
  { -109635579833241.72, 50, 1, 
	  70.000000000000000 },
  { -14623805817283490., 50, 1, 
	  80.000000000000000 },
  { -2.0666847190878152e+18, 50, 1, 
	  90.000000000000000 },
  { -1.4385187953997626e+20, 50, 1, 
	  100.00000000000000 },
};
const double toler050 = 2.5000000000000015e-12;

// Test data for n=50, m=2.
// max(|f - f_GSL|): 139264.00000000000
// max(|f - f_GSL| / |f_GSL|): 2.5437687254653283e-15
const testcase_assoc_laguerre<double>
data051[11] =
{
  { 1326.0000000000000, 50, 2, 
	  0.0000000000000000 },
  { -87.860732516444529, 50, 2, 
	  10.000000000000000 },
  { -5203.2351191780917, 50, 2, 
	  20.000000000000000 },
  { -461059.50012538867, 50, 2, 
	  30.000000000000000 },
  { -30476695.327440590, 50, 2, 
	  40.000000000000000 },
  { 3720804977.9338136, 50, 2, 
	  50.000000000000000 },
  { 362262002434.51453, 50, 2, 
	  60.000000000000000 },
  { -52210917867820.227, 50, 2, 
	  70.000000000000000 },
  { -9567965136901914.0, 50, 2, 
	  80.000000000000000 },
  { -8.9171277517712883e+17, 50, 2, 
	  90.000000000000000 },
  { 5.7231129448806982e+19, 50, 2, 
	  100.00000000000000 },
};
const double toler051 = 2.5000000000000020e-13;

// Test data for n=50, m=5.
// max(|f - f_GSL|): 81920.000000000000
// max(|f - f_GSL| / |f_GSL|): 2.6215979818234617e-15
const testcase_assoc_laguerre<double>
data052[11] =
{
  { 3478761.0000000000, 50, 5, 
	  0.0000000000000000 },
  { 1055.8381917651498, 50, 5, 
	  10.000000000000000 },
  { 15264.646660345055, 50, 5, 
	  20.000000000000000 },
  { 1229651.8966600848, 50, 5, 
	  30.000000000000000 },
  { 39270451.823656842, 50, 5, 
	  40.000000000000000 },
  { -4424062601.1152029, 50, 5, 
	  50.000000000000000 },
  { -186017434284.19223, 50, 5, 
	  60.000000000000000 },
  { 50972853949302.609, 50, 5, 
	  70.000000000000000 },
  { 6530702754012517.0, 50, 5, 
	  80.000000000000000 },
  { 6.8387592714678029e+17, 50, 5, 
	  90.000000000000000 },
  { 3.9198742504338391e+19, 50, 5, 
	  100.00000000000000 },
};
const double toler052 = 2.5000000000000020e-13;

// Test data for n=50, m=10.
// max(|f - f_GSL|): 192.00000000000000
// max(|f - f_GSL| / |f_GSL|): 3.6229303412867937e-15
const testcase_assoc_laguerre<double>
data053[11] =
{
  { 75394027565.999985, 50, 10, 
	  0.0000000000000000 },
  { 91833.924098770178, 50, 10, 
	  10.000000000000000 },
  { 330501.87929778261, 50, 10, 
	  20.000000000000000 },
  { 3625088.1635972536, 50, 10, 
	  30.000000000000000 },
  { 213954727.28632012, 50, 10, 
	  40.000000000000000 },
  { -9381006937.7517681, 50, 10, 
	  50.000000000000000 },
  { 535333683777.48615, 50, 10, 
	  60.000000000000000 },
  { 18824406573722.172, 50, 10, 
	  70.000000000000000 },
  { -533858276780013.12, 50, 10, 
	  80.000000000000000 },
  { -52995774666704016., 50, 10, 
	  90.000000000000000 },
  { 6.0504182862448783e+18, 50, 10, 
	  100.00000000000000 },
};
const double toler053 = 2.5000000000000020e-13;

// Test data for n=50, m=20.
// max(|f - f_GSL|): 512.00000000000000
// max(|f - f_GSL| / |f_GSL|): 9.6616871455409171e-14
const testcase_assoc_laguerre<double>
data054[11] =
{
  { 1.6188460366265779e+17, 50, 20, 
	  0.0000000000000000 },
  { -307637087.25169408, 50, 20, 
	  10.000000000000000 },
  { 12524651.102974586, 50, 20, 
	  20.000000000000000 },
  { -315460483.86210561, 50, 20, 
	  30.000000000000000 },
  { -1889683587.3459988, 50, 20, 
	  40.000000000000000 },
  { 37457044404.200348, 50, 20, 
	  50.000000000000000 },
  { -843831858224.71802, 50, 20, 
	  60.000000000000000 },
  { -92231643172.307495, 50, 20, 
	  70.000000000000000 },
  { 904211757769501.00, 50, 20, 
	  80.000000000000000 },
  { 46508193600283272., 50, 20, 
	  90.000000000000000 },
  { 2.3216887928162719e+18, 50, 20, 
	  100.00000000000000 },
};
const double toler054 = 5.0000000000000029e-12;

// Test data for n=50, m=50.
// max(|f - f_GSL|): 989855744.00000000
// max(|f - f_GSL| / |f_GSL|): 1.1139535389485780e-14
const testcase_assoc_laguerre<double>
data055[11] =
{
  { 1.0089134454556417e+29, 50, 50, 
	  0.0000000000000000 },
  { 1.3822795753070493e+23, 50, 50, 
	  10.000000000000000 },
  { 95817260381628336., 50, 50, 
	  20.000000000000000 },
  { -910798580856015.38, 50, 50, 
	  30.000000000000000 },
  { 50513254049166.922, 50, 50, 
	  40.000000000000000 },
  { 84159703903348.938, 50, 50, 
	  50.000000000000000 },
  { -138805244691822.72, 50, 50, 
	  60.000000000000000 },
  { 181046391269246.25, 50, 50, 
	  70.000000000000000 },
  { 2086884905317107.5, 50, 50, 
	  80.000000000000000 },
  { -2765620139862428.0, 50, 50, 
	  90.000000000000000 },
  { -1.3706751678146290e+17, 50, 50, 
	  100.00000000000000 },
};
const double toler055 = 1.0000000000000008e-12;

// Test data for n=50, m=100.
// max(|f - f_GSL|): 1.8889465931478581e+22
// max(|f - f_GSL| / |f_GSL|): 2.2737143709403468e-14
const testcase_assoc_laguerre<double>
data056[11] =
{
  { 2.0128660909731929e+40, 50, 100, 
	  0.0000000000000000 },
  { 9.3675094807695474e+37, 50, 100, 
	  10.000000000000000 },
  { 1.3009321481877196e+35, 50, 100, 
	  20.000000000000000 },
  { 7.3720026893233823e+30, 50, 100, 
	  30.000000000000000 },
  { -6.0824679079634667e+25, 50, 100, 
	  40.000000000000000 },
  { -6.0053188793543450e+23, 50, 100, 
	  50.000000000000000 },
  { 1.4178129287264692e+22, 50, 100, 
	  60.000000000000000 },
  { -5.4652099341566706e+20, 50, 100, 
	  70.000000000000000 },
  { -1.0817271759263274e+20, 50, 100, 
	  80.000000000000000 },
  { 3.8058734007924195e+19, 50, 100, 
	  90.000000000000000 },
  { 4.7439240848028344e+19, 50, 100, 
	  100.00000000000000 },
};
const double toler056 = 2.5000000000000015e-12;

// Test data for n=100, m=0.
// max(|f - f_GSL|): 98304.000000000000
// max(|f - f_GSL| / |f_GSL|): 3.8776197831393928e-15
const testcase_assoc_laguerre<double>
data057[11] =
{
  { 1.0000000000000000, 100, 0, 
	  0.0000000000000000 },
  { 13.277662844303450, 100, 0, 
	  10.000000000000000 },
  { 1854.0367283243388, 100, 0, 
	  20.000000000000000 },
  { 170141.86987046551, 100, 0, 
	  30.000000000000000 },
  { -7272442.3156006960, 100, 0, 
	  40.000000000000000 },
  { 4847420871.2690506, 100, 0, 
	  50.000000000000000 },
  { 693492765740.29688, 100, 0, 
	  60.000000000000000 },
  { 17125518672239.770, 100, 0, 
	  70.000000000000000 },
  { -13763178176383768., 100, 0, 
	  80.000000000000000 },
  { 2.1307220490380173e+18, 100, 0, 
	  90.000000000000000 },
  { -2.6292260693068916e+20, 100, 0, 
	  100.00000000000000 },
};
const double toler057 = 2.5000000000000020e-13;

// Test data for n=100, m=1.
// max(|f - f_GSL|): 245760.00000000000
// max(|f - f_GSL| / |f_GSL|): 1.4500034612453474e-14
const testcase_assoc_laguerre<double>
data058[11] =
{
  { 101.00000000000003, 100, 1, 
	  0.0000000000000000 },
  { -14.650661983680420, 100, 1, 
	  10.000000000000000 },
  { 1626.5010939361582, 100, 1, 
	  20.000000000000000 },
  { 417884.77658268728, 100, 1, 
	  30.000000000000000 },
  { -55617646.951649837, 100, 1, 
	  40.000000000000000 },
  { 884829874.26626217, 100, 1, 
	  50.000000000000000 },
  { 154466082750.32202, 100, 1, 
	  60.000000000000000 },
  { -101423973484646.00, 100, 1, 
	  70.000000000000000 },
  { -1388352348671756.8, 100, 1, 
	  80.000000000000000 },
  { 7.8048705513268582e+17, 100, 1, 
	  90.000000000000000 },
  { 1.6948925059042755e+19, 100, 1, 
	  100.00000000000000 },
};
const double toler058 = 1.0000000000000008e-12;

// Test data for n=100, m=2.
// max(|f - f_GSL|): 557056.00000000000
// max(|f - f_GSL| / |f_GSL|): 5.1603746667135714e-15
const testcase_assoc_laguerre<double>
data059[11] =
{
  { 5151.0000000000055, 100, 2, 
	  0.0000000000000000 },
  { -150.22012290951324, 100, 2, 
	  10.000000000000000 },
  { -7655.0593294049449, 100, 2, 
	  20.000000000000000 },
  { -140996.69276179091, 100, 2, 
	  30.000000000000000 },
  { -38645171.278549351, 100, 2, 
	  40.000000000000000 },
  { -8889263688.2118931, 100, 2, 
	  50.000000000000000 },
  { -1010338971533.3400, 100, 2, 
	  60.000000000000000 },
  { -127582564332943.91, 100, 2, 
	  70.000000000000000 },
  { 15970305694654312., 100, 2, 
	  80.000000000000000 },
  { -1.6019844992862820e+18, 100, 2, 
	  90.000000000000000 },
  { 2.8267024730962955e+20, 100, 2, 
	  100.00000000000000 },
};
const double toler059 = 5.0000000000000039e-13;

// Test data for n=100, m=5.
// max(|f - f_GSL|): 393216.00000000000
// max(|f - f_GSL| / |f_GSL|): 8.0946565190235238e-15
const testcase_assoc_laguerre<double>
data060[11] =
{
  { 96560646.000000030, 100, 5, 
	  0.0000000000000000 },
  { 2430.6732236677612, 100, 5, 
	  10.000000000000000 },
  { 111162.32026994647, 100, 5, 
	  20.000000000000000 },
  { 4036708.2599413628, 100, 5, 
	  30.000000000000000 },
  { -34055982.664405443, 100, 5, 
	  40.000000000000000 },
  { 30110688343.562328, 100, 5, 
	  50.000000000000000 },
  { 2651429940558.2974, 100, 5, 
	  60.000000000000000 },
  { 192108556058943.09, 100, 5, 
	  70.000000000000000 },
  { -25410533973455528., 100, 5, 
	  80.000000000000000 },
  { 2.1072955633564431e+18, 100, 5, 
	  90.000000000000000 },
  { -2.9434005355877289e+20, 100, 5, 
	  100.00000000000000 },
};
const double toler060 = 5.0000000000000039e-13;

// Test data for n=100, m=10.
// max(|f - f_GSL|): 155648.00000000000
// max(|f - f_GSL| / |f_GSL|): 5.1685581852917721e-15
const testcase_assoc_laguerre<double>
data061[11] =
{
  { 46897636623981.039, 100, 10, 
	  0.0000000000000000 },
  { 529208.11550990329, 100, 10, 
	  10.000000000000000 },
  { 7402892.1748803817, 100, 10, 
	  20.000000000000000 },
  { 88369632.083243579, 100, 10, 
	  30.000000000000000 },
  { 822187797.59096563, 100, 10, 
	  40.000000000000000 },
  { 180231446033.06866, 100, 10, 
	  50.000000000000000 },
  { 7922942703798.1309, 100, 10, 
	  60.000000000000000 },
  { 784424250559042.12, 100, 10, 
	  70.000000000000000 },
  { -16325634720239370., 100, 10, 
	  80.000000000000000 },
  { -1.0879588307443162e+18, 100, 10, 
	  90.000000000000000 },
  { 3.0114394463610642e+19, 100, 10, 
	  100.00000000000000 },
};
const double toler061 = 5.0000000000000039e-13;

// Test data for n=100, m=20.
// max(|f - f_GSL|): 524288.00000000000
// max(|f - f_GSL| / |f_GSL|): 3.7005989410347388e-14
const testcase_assoc_laguerre<double>
data062[11] =
{
  { 2.9462227291176614e+22, 100, 20, 
	  0.0000000000000000 },
  { 313694958939.90405, 100, 20, 
	  10.000000000000000 },
  { 45396489338.096191, 100, 20, 
	  20.000000000000000 },
  { -7215826758.0081253, 100, 20, 
	  30.000000000000000 },
  { 825949194005.88855, 100, 20, 
	  40.000000000000000 },
  { -2764742119971.0811, 100, 20, 
	  50.000000000000000 },
  { -219802198273516.03, 100, 20, 
	  60.000000000000000 },
  { -1699053306145262.0, 100, 20, 
	  70.000000000000000 },
  { 3.5495709345023846e+17, 100, 20, 
	  80.000000000000000 },
  { -9.6128675110292419e+18, 100, 20, 
	  90.000000000000000 },
  { 4.3619868422072212e+20, 100, 20, 
	  100.00000000000000 },
};
const double toler062 = 2.5000000000000015e-12;

// Test data for n=100, m=50.
// max(|f - f_GSL|): 316659348799488.00
// max(|f - f_GSL| / |f_GSL|): 1.1554040570270351e-14
const testcase_assoc_laguerre<double>
data063[11] =
{
  { 2.0128660909731931e+40, 100, 50, 
	  0.0000000000000000 },
  { -4.0151443913473373e+28, 100, 50, 
	  10.000000000000000 },
  { 3.2199632594551924e+22, 100, 50, 
	  20.000000000000000 },
  { -2.7568702092659756e+20, 100, 50, 
	  30.000000000000000 },
  { 7.5553066015421563e+19, 100, 50, 
	  40.000000000000000 },
  { -2.7651625252387734e+19, 100, 50, 
	  50.000000000000000 },
  { -5.8963680147283804e+19, 100, 50, 
	  60.000000000000000 },
  { -1.8082798163033106e+20, 100, 50, 
	  70.000000000000000 },
  { -3.9044276986817249e+20, 100, 50, 
	  80.000000000000000 },
  { 6.9926310700401904e+21, 100, 50, 
	  90.000000000000000 },
  { -5.5727272809923646e+22, 100, 50, 
	  100.00000000000000 },
};
const double toler063 = 1.0000000000000008e-12;

// Test data for n=100, m=100.
// max(|f - f_GSL|): 2.3819765684465692e+39
// max(|f - f_GSL| / |f_GSL|): 1.9897039067343855e-14
const testcase_assoc_laguerre<double>
data064[11] =
{
  { 9.0548514656103225e+58, 100, 100, 
	  0.0000000000000000 },
  { 1.3334078033060556e+54, 100, 100, 
	  10.000000000000000 },
  { 2.1002639254211340e+46, 100, 100, 
	  20.000000000000000 },
  { -1.1073158068796292e+39, 100, 100, 
	  30.000000000000000 },
  { -8.3640937363981346e+35, 100, 100, 
	  40.000000000000000 },
  { -6.5879339429312686e+32, 100, 100, 
	  50.000000000000000 },
  { -2.4190645077698771e+30, 100, 100, 
	  60.000000000000000 },
  { -7.9224960465662171e+29, 100, 100, 
	  70.000000000000000 },
  { -2.8605772478408694e+29, 100, 100, 
	  80.000000000000000 },
  { 2.4149589189609957e+28, 100, 100, 
	  90.000000000000000 },
  { 5.1146476014859021e+28, 100, 100, 
	  100.00000000000000 },
};
const double toler064 = 1.0000000000000008e-12;

template<typename Tp, unsigned int Num>
  void
  test(const testcase_assoc_laguerre<Tp> (&data)[Num], Tp toler)
  {
    const Tp eps = std::numeric_limits<Tp>::epsilon();
    Tp max_abs_diff = -Tp(1);
    Tp max_abs_frac = -Tp(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Tp f = std::assoc_laguerre(data[i].n, data[i].m,
		     data[i].x);
	const Tp f0 = data[i].f0;
	const Tp diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Tp(10) * eps
	 && std::abs(f) > Tp(10) * eps)
	  {
	    const Tp frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  test(data037, toler037);
  test(data038, toler038);
  test(data039, toler039);
  test(data040, toler040);
  test(data041, toler041);
  test(data042, toler042);
  test(data043, toler043);
  test(data044, toler044);
  test(data045, toler045);
  test(data046, toler046);
  test(data047, toler047);
  test(data048, toler048);
  test(data049, toler049);
  test(data050, toler050);
  test(data051, toler051);
  test(data052, toler052);
  test(data053, toler053);
  test(data054, toler054);
  test(data055, toler055);
  test(data056, toler056);
  test(data057, toler057);
  test(data058, toler058);
  test(data059, toler059);
  test(data060, toler060);
  test(data061, toler061);
  test(data062, toler062);
  test(data063, toler063);
  test(data064, toler064);
  return 0;
}
