// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package docdb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/AddTagsToResource
func (c *DocDB) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Adds metadata tags to an Amazon DocumentDB resource. You can use these tags
// with cost allocation reporting to track costs that are associated with Amazon
// DocumentDB resources. or in a Condition statement in an AWS Identity and
// Access Management (IAM) policy for Amazon DocumentDB.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/AddTagsToResource
func (c *DocDB) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyPendingMaintenanceAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyPendingMaintenanceAction for more information on using the ApplyPendingMaintenanceAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyPendingMaintenanceActionRequest method.
//    req, resp := client.ApplyPendingMaintenanceActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ApplyPendingMaintenanceAction
func (c *DocDB) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	output = &ApplyPendingMaintenanceActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyPendingMaintenanceAction API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Applies a pending maintenance action to a resource (for example, to an Amazon
// DocumentDB instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ApplyPendingMaintenanceAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ApplyPendingMaintenanceAction
func (c *DocDB) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	return out, req.Send()
}

// ApplyPendingMaintenanceActionWithContext is the same as ApplyPendingMaintenanceAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyPendingMaintenanceAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ApplyPendingMaintenanceActionWithContext(ctx aws.Context, input *ApplyPendingMaintenanceActionInput, opts ...request.Option) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterParameterGroup = "CopyDBClusterParameterGroup"

// CopyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterParameterGroup for more information on using the CopyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterParameterGroupRequest method.
//    req, resp := client.CopyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterParameterGroup
func (c *DocDB) CopyDBClusterParameterGroupRequest(input *CopyDBClusterParameterGroupInput) (req *request.Request, output *CopyDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterParameterGroupInput{}
	}

	output = &CopyDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterParameterGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Copies the specified cluster parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CopyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   This request would cause you to exceed the allowed number of parameter groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A parameter group with the same name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterParameterGroup
func (c *DocDB) CopyDBClusterParameterGroup(input *CopyDBClusterParameterGroupInput) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBClusterParameterGroupWithContext is the same as CopyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CopyDBClusterParameterGroupWithContext(ctx aws.Context, input *CopyDBClusterParameterGroupInput, opts ...request.Option) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterSnapshot = "CopyDBClusterSnapshot"

// CopyDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterSnapshot for more information on using the CopyDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterSnapshotRequest method.
//    req, resp := client.CopyDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterSnapshot
func (c *DocDB) CopyDBClusterSnapshotRequest(input *CopyDBClusterSnapshotInput) (req *request.Request, output *CopyDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterSnapshotInput{}
	}

	output = &CopyDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterSnapshot API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Copies a snapshot of a cluster.
//
// To copy a cluster snapshot from a shared manual cluster snapshot, SourceDBClusterSnapshotIdentifier
// must be the Amazon Resource Name (ARN) of the shared cluster snapshot. You
// can only copy a shared DB cluster snapshot, whether encrypted or not, in
// the same AWS Region.
//
// To cancel the copy operation after it is in progress, delete the target cluster
// snapshot identified by TargetDBClusterSnapshotIdentifier while that cluster
// snapshot is in the copying status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CopyDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   You already have a cluster snapshot with the given identifier.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would cause you to exceed the allowed number of snapshots.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred when accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterSnapshot
func (c *DocDB) CopyDBClusterSnapshot(input *CopyDBClusterSnapshotInput) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CopyDBClusterSnapshotWithContext is the same as CopyDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CopyDBClusterSnapshotWithContext(ctx aws.Context, input *CopyDBClusterSnapshotInput, opts ...request.Option) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBCluster = "CreateDBCluster"

// CreateDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBCluster for more information on using the CreateDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterRequest method.
//    req, resp := client.CreateDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBCluster
func (c *DocDB) CreateDBClusterRequest(input *CreateDBClusterInput) (req *request.Request, output *CreateDBClusterOutput) {
	op := &request.Operation{
		Name:       opCreateDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterInput{}
	}

	output = &CreateDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBCluster API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new Amazon DocumentDB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CreateDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   You already have a cluster with the given identifier.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is not enough storage available for the current action. You might be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The cluster can't be created because you have reached the maximum allowed
//   quota of clusters.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The subnet group doesn't cover all Availability Zones after it is created
//   because of changes that were made.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The subnet group can't be deleted because it's in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing cluster parameter
//   group.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred when accessing an AWS KMS key.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBCluster
func (c *DocDB) CreateDBCluster(input *CreateDBClusterInput) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	return out, req.Send()
}

// CreateDBClusterWithContext is the same as CreateDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CreateDBClusterWithContext(ctx aws.Context, input *CreateDBClusterInput, opts ...request.Option) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterParameterGroup = "CreateDBClusterParameterGroup"

// CreateDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterParameterGroup for more information on using the CreateDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterParameterGroupRequest method.
//    req, resp := client.CreateDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterParameterGroup
func (c *DocDB) CreateDBClusterParameterGroupRequest(input *CreateDBClusterParameterGroupInput) (req *request.Request, output *CreateDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterParameterGroupInput{}
	}

	output = &CreateDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterParameterGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new cluster parameter group.
//
// Parameters in a cluster parameter group apply to all of the instances in
// a cluster.
//
// A cluster parameter group is initially created with the default parameters
// for the database engine used by instances in the cluster. In Amazon DocumentDB,
// you cannot make modifications directly to the default.docdb3.6 cluster parameter
// group. If your Amazon DocumentDB cluster is using the default cluster parameter
// group and you want to modify a value in it, you must first create a new parameter
// group (https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html)
// or copy an existing parameter group (https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html),
// modify it, and then apply the modified parameter group to your cluster. For
// the new cluster parameter group and associated settings to take effect, you
// must then reboot the instances in the cluster without failover. For more
// information, see Modifying Amazon DocumentDB Cluster Parameter Groups (https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CreateDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   This request would cause you to exceed the allowed number of parameter groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A parameter group with the same name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterParameterGroup
func (c *DocDB) CreateDBClusterParameterGroup(input *CreateDBClusterParameterGroupInput) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBClusterParameterGroupWithContext is the same as CreateDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CreateDBClusterParameterGroupWithContext(ctx aws.Context, input *CreateDBClusterParameterGroupInput, opts ...request.Option) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterSnapshot = "CreateDBClusterSnapshot"

// CreateDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterSnapshot for more information on using the CreateDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterSnapshotRequest method.
//    req, resp := client.CreateDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterSnapshot
func (c *DocDB) CreateDBClusterSnapshotRequest(input *CreateDBClusterSnapshotInput) (req *request.Request, output *CreateDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterSnapshotInput{}
	}

	output = &CreateDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterSnapshot API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Creates a snapshot of a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CreateDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   You already have a cluster snapshot with the given identifier.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would cause you to exceed the allowed number of snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterSnapshot
func (c *DocDB) CreateDBClusterSnapshot(input *CreateDBClusterSnapshotInput) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CreateDBClusterSnapshotWithContext is the same as CreateDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CreateDBClusterSnapshotWithContext(ctx aws.Context, input *CreateDBClusterSnapshotInput, opts ...request.Option) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBInstance for more information on using the CreateDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBInstanceRequest method.
//    req, resp := client.CreateDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstance
func (c *DocDB) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	output = &CreateDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBInstance API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CreateDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   You already have a instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   The request would cause you to exceed the allowed number of instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The subnet group doesn't cover all Availability Zones after it is created
//   because of changes that were made.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the specified StorageType can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP or Amazon EC2 security group isn't authorized for the
//   specified security group.
//
//   Amazon DocumentDB also might not be authorized to perform necessary actions
//   on your behalf using IAM.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred when accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstance
func (c *DocDB) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	return out, req.Send()
}

// CreateDBInstanceWithContext is the same as CreateDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CreateDBInstanceWithContext(ctx aws.Context, input *CreateDBInstanceInput, opts ...request.Option) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSubnetGroup = "CreateDBSubnetGroup"

// CreateDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSubnetGroup for more information on using the CreateDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSubnetGroupRequest method.
//    req, resp := client.CreateDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBSubnetGroup
func (c *DocDB) CreateDBSubnetGroupRequest(input *CreateDBSubnetGroupInput) (req *request.Request, output *CreateDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSubnetGroupInput{}
	}

	output = &CreateDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSubnetGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new subnet group. subnet groups must contain at least one subnet
// in at least two Availability Zones in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation CreateDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupAlreadyExistsFault "DBSubnetGroupAlreadyExists"
//   DBSubnetGroupName is already being used by an existing subnet group.
//
//   * ErrCodeDBSubnetGroupQuotaExceededFault "DBSubnetGroupQuotaExceeded"
//   The request would cause you to exceed the allowed number of subnet groups.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   The request would cause you to exceed the allowed number of subnets in a
//   subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBSubnetGroup
func (c *DocDB) CreateDBSubnetGroup(input *CreateDBSubnetGroupInput) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateDBSubnetGroupWithContext is the same as CreateDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) CreateDBSubnetGroupWithContext(ctx aws.Context, input *CreateDBSubnetGroupInput, opts ...request.Option) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBCluster = "DeleteDBCluster"

// DeleteDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBCluster for more information on using the DeleteDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterRequest method.
//    req, resp := client.DeleteDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBCluster
func (c *DocDB) DeleteDBClusterRequest(input *DeleteDBClusterInput) (req *request.Request, output *DeleteDBClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterInput{}
	}

	output = &DeleteDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBCluster API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Deletes a previously provisioned cluster. When you delete a cluster, all
// automated backups for that cluster are deleted and can't be recovered. Manual
// DB cluster snapshots of the specified cluster are not deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DeleteDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   You already have a cluster snapshot with the given identifier.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would cause you to exceed the allowed number of snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBCluster
func (c *DocDB) DeleteDBCluster(input *DeleteDBClusterInput) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	return out, req.Send()
}

// DeleteDBClusterWithContext is the same as DeleteDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DeleteDBClusterWithContext(ctx aws.Context, input *DeleteDBClusterInput, opts ...request.Option) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterParameterGroup = "DeleteDBClusterParameterGroup"

// DeleteDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterParameterGroup for more information on using the DeleteDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterParameterGroupRequest method.
//    req, resp := client.DeleteDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterParameterGroup
func (c *DocDB) DeleteDBClusterParameterGroupRequest(input *DeleteDBClusterParameterGroupInput) (req *request.Request, output *DeleteDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterParameterGroupInput{}
	}

	output = &DeleteDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBClusterParameterGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Deletes a specified cluster parameter group. The cluster parameter group
// to be deleted can't be associated with any clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DeleteDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The parameter group is in use, or it is in a state that is not valid. If
//   you are trying to delete the parameter group, you can't delete it when the
//   parameter group is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterParameterGroup
func (c *DocDB) DeleteDBClusterParameterGroup(input *DeleteDBClusterParameterGroupInput) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBClusterParameterGroupWithContext is the same as DeleteDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DeleteDBClusterParameterGroupWithContext(ctx aws.Context, input *DeleteDBClusterParameterGroupInput, opts ...request.Option) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterSnapshot = "DeleteDBClusterSnapshot"

// DeleteDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterSnapshot for more information on using the DeleteDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterSnapshotRequest method.
//    req, resp := client.DeleteDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterSnapshot
func (c *DocDB) DeleteDBClusterSnapshotRequest(input *DeleteDBClusterSnapshotInput) (req *request.Request, output *DeleteDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterSnapshotInput{}
	}

	output = &DeleteDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBClusterSnapshot API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Deletes a cluster snapshot. If the snapshot is being copied, the copy operation
// is terminated.
//
// The cluster snapshot must be in the available state to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DeleteDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterSnapshot
func (c *DocDB) DeleteDBClusterSnapshot(input *DeleteDBClusterSnapshotInput) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDBClusterSnapshotWithContext is the same as DeleteDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DeleteDBClusterSnapshotWithContext(ctx aws.Context, input *DeleteDBClusterSnapshotInput, opts ...request.Option) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBInstance = "DeleteDBInstance"

// DeleteDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBInstance for more information on using the DeleteDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBInstanceRequest method.
//    req, resp := client.DeleteDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBInstance
func (c *DocDB) DeleteDBInstanceRequest(input *DeleteDBInstanceInput) (req *request.Request, output *DeleteDBInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBInstanceInput{}
	}

	output = &DeleteDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBInstance API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Deletes a previously provisioned instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DeleteDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already being used by an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   The request would cause you to exceed the allowed number of snapshots.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBInstance
func (c *DocDB) DeleteDBInstance(input *DeleteDBInstanceInput) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	return out, req.Send()
}

// DeleteDBInstanceWithContext is the same as DeleteDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DeleteDBInstanceWithContext(ctx aws.Context, input *DeleteDBInstanceInput, opts ...request.Option) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSubnetGroup = "DeleteDBSubnetGroup"

// DeleteDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSubnetGroup for more information on using the DeleteDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSubnetGroupRequest method.
//    req, resp := client.DeleteDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBSubnetGroup
func (c *DocDB) DeleteDBSubnetGroupRequest(input *DeleteDBSubnetGroupInput) (req *request.Request, output *DeleteDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSubnetGroupInput{}
	}

	output = &DeleteDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBSubnetGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Deletes a subnet group.
//
// The specified database subnet group must not be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DeleteDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The subnet group can't be deleted because it's in use.
//
//   * ErrCodeInvalidDBSubnetStateFault "InvalidDBSubnetStateFault"
//   The subnet isn't in the available state.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBSubnetGroup
func (c *DocDB) DeleteDBSubnetGroup(input *DeleteDBSubnetGroupInput) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteDBSubnetGroupWithContext is the same as DeleteDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DeleteDBSubnetGroupWithContext(ctx aws.Context, input *DeleteDBSubnetGroupInput, opts ...request.Option) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificates for more information on using the DescribeCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificatesRequest method.
//    req, resp := client.DescribeCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeCertificates
func (c *DocDB) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	output = &DescribeCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificates API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of certificate authority (CA) certificates provided by Amazon
// DocumentDB for this AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier doesn't refer to an existing certificate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeCertificates
func (c *DocDB) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	return out, req.Send()
}

// DescribeCertificatesWithContext is the same as DescribeCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeCertificatesWithContext(ctx aws.Context, input *DescribeCertificatesInput, opts ...request.Option) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCertificatesPages iterates over the pages of a DescribeCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCertificates operation.
//    pageNum := 0
//    err := client.DescribeCertificatesPages(params,
//        func(page *docdb.DescribeCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeCertificatesPages(input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool) error {
	return c.DescribeCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCertificatesPagesWithContext same as DescribeCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeCertificatesPagesWithContext(ctx aws.Context, input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCertificatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBClusterParameterGroups = "DescribeDBClusterParameterGroups"

// DescribeDBClusterParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameterGroups for more information on using the DescribeDBClusterParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParameterGroupsRequest method.
//    req, resp := client.DescribeDBClusterParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameterGroups
func (c *DocDB) DescribeDBClusterParameterGroupsRequest(input *DescribeDBClusterParameterGroupsInput) (req *request.Request, output *DescribeDBClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBClusterParameterGroupsInput{}
	}

	output = &DescribeDBClusterParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameterGroups API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName
// parameter is specified, the list contains only the description of the specified
// cluster parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBClusterParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameterGroups
func (c *DocDB) DescribeDBClusterParameterGroups(input *DescribeDBClusterParameterGroupsInput) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParameterGroupsWithContext is the same as DescribeDBClusterParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterParameterGroupsWithContext(ctx aws.Context, input *DescribeDBClusterParameterGroupsInput, opts ...request.Option) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBClusterParameterGroupsPages iterates over the pages of a DescribeDBClusterParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBClusterParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBClusterParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeDBClusterParameterGroupsPages(params,
//        func(page *docdb.DescribeDBClusterParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBClusterParameterGroupsPages(input *DescribeDBClusterParameterGroupsInput, fn func(*DescribeDBClusterParameterGroupsOutput, bool) bool) error {
	return c.DescribeDBClusterParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBClusterParameterGroupsPagesWithContext same as DescribeDBClusterParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterParameterGroupsPagesWithContext(ctx aws.Context, input *DescribeDBClusterParameterGroupsInput, fn func(*DescribeDBClusterParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBClusterParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBClusterParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBClusterParameterGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBClusterParameters = "DescribeDBClusterParameters"

// DescribeDBClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameters for more information on using the DescribeDBClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParametersRequest method.
//    req, resp := client.DescribeDBClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameters
func (c *DocDB) DescribeDBClusterParametersRequest(input *DescribeDBClusterParametersInput) (req *request.Request, output *DescribeDBClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBClusterParametersInput{}
	}

	output = &DescribeDBClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameters API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns the detailed parameter list for a particular cluster parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBClusterParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameters
func (c *DocDB) DescribeDBClusterParameters(input *DescribeDBClusterParametersInput) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParametersWithContext is the same as DescribeDBClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterParametersWithContext(ctx aws.Context, input *DescribeDBClusterParametersInput, opts ...request.Option) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBClusterParametersPages iterates over the pages of a DescribeDBClusterParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBClusterParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBClusterParameters operation.
//    pageNum := 0
//    err := client.DescribeDBClusterParametersPages(params,
//        func(page *docdb.DescribeDBClusterParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBClusterParametersPages(input *DescribeDBClusterParametersInput, fn func(*DescribeDBClusterParametersOutput, bool) bool) error {
	return c.DescribeDBClusterParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBClusterParametersPagesWithContext same as DescribeDBClusterParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterParametersPagesWithContext(ctx aws.Context, input *DescribeDBClusterParametersInput, fn func(*DescribeDBClusterParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBClusterParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBClusterParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBClusterParametersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBClusterSnapshotAttributes = "DescribeDBClusterSnapshotAttributes"

// DescribeDBClusterSnapshotAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshotAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshotAttributes for more information on using the DescribeDBClusterSnapshotAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotAttributesRequest method.
//    req, resp := client.DescribeDBClusterSnapshotAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *DocDB) DescribeDBClusterSnapshotAttributesRequest(input *DescribeDBClusterSnapshotAttributesInput) (req *request.Request, output *DescribeDBClusterSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotAttributesInput{}
	}

	output = &DescribeDBClusterSnapshotAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshotAttributes API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of cluster snapshot attribute names and values for a manual
// DB cluster snapshot.
//
// When you share snapshots with other AWS accounts, DescribeDBClusterSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual cluster snapshot. If all is
// included in the list of values for the restore attribute, then the manual
// cluster snapshot is public and can be copied or restored by all AWS accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBClusterSnapshotAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *DocDB) DescribeDBClusterSnapshotAttributes(input *DescribeDBClusterSnapshotAttributesInput) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotAttributesWithContext is the same as DescribeDBClusterSnapshotAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshotAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterSnapshotAttributesWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotAttributesInput, opts ...request.Option) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshots = "DescribeDBClusterSnapshots"

// DescribeDBClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshots for more information on using the DescribeDBClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotsRequest method.
//    req, resp := client.DescribeDBClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshots
func (c *DocDB) DescribeDBClusterSnapshotsRequest(input *DescribeDBClusterSnapshotsInput) (req *request.Request, output *DescribeDBClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotsInput{}
	}

	output = &DescribeDBClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshots API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns information about cluster snapshots. This API operation supports
// pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshots
func (c *DocDB) DescribeDBClusterSnapshots(input *DescribeDBClusterSnapshotsInput) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotsWithContext is the same as DescribeDBClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterSnapshotsWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotsInput, opts ...request.Option) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBClusterSnapshotsPages iterates over the pages of a DescribeDBClusterSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBClusterSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBClusterSnapshots operation.
//    pageNum := 0
//    err := client.DescribeDBClusterSnapshotsPages(params,
//        func(page *docdb.DescribeDBClusterSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBClusterSnapshotsPages(input *DescribeDBClusterSnapshotsInput, fn func(*DescribeDBClusterSnapshotsOutput, bool) bool) error {
	return c.DescribeDBClusterSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBClusterSnapshotsPagesWithContext same as DescribeDBClusterSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClusterSnapshotsPagesWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotsInput, fn func(*DescribeDBClusterSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBClusterSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBClusterSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBClusterSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBClusters = "DescribeDBClusters"

// DescribeDBClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusters for more information on using the DescribeDBClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClustersRequest method.
//    req, resp := client.DescribeDBClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters
func (c *DocDB) DescribeDBClustersRequest(input *DescribeDBClustersInput) (req *request.Request, output *DescribeDBClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBClustersInput{}
	}

	output = &DescribeDBClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusters API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns information about provisioned Amazon DocumentDB clusters. This API
// operation supports pagination. For certain management features such as cluster
// and instance lifecycle management, Amazon DocumentDB leverages operational
// technology that is shared with Amazon RDS and Amazon Neptune. Use the filterName=engine,Values=docdb
// filter parameter to return only Amazon DocumentDB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters
func (c *DocDB) DescribeDBClusters(input *DescribeDBClustersInput) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	return out, req.Send()
}

// DescribeDBClustersWithContext is the same as DescribeDBClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClustersWithContext(ctx aws.Context, input *DescribeDBClustersInput, opts ...request.Option) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBClustersPages iterates over the pages of a DescribeDBClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBClusters operation.
//    pageNum := 0
//    err := client.DescribeDBClustersPages(params,
//        func(page *docdb.DescribeDBClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBClustersPages(input *DescribeDBClustersInput, fn func(*DescribeDBClustersOutput, bool) bool) error {
	return c.DescribeDBClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBClustersPagesWithContext same as DescribeDBClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBClustersPagesWithContext(ctx aws.Context, input *DescribeDBClustersInput, fn func(*DescribeDBClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBEngineVersions = "DescribeDBEngineVersions"

// DescribeDBEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBEngineVersions for more information on using the DescribeDBEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBEngineVersionsRequest method.
//    req, resp := client.DescribeDBEngineVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions
func (c *DocDB) DescribeDBEngineVersionsRequest(input *DescribeDBEngineVersionsInput) (req *request.Request, output *DescribeDBEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBEngineVersionsInput{}
	}

	output = &DescribeDBEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBEngineVersions API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of the available engines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBEngineVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions
func (c *DocDB) DescribeDBEngineVersions(input *DescribeDBEngineVersionsInput) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeDBEngineVersionsWithContext is the same as DescribeDBEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBEngineVersionsWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, opts ...request.Option) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBEngineVersionsPages iterates over the pages of a DescribeDBEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBEngineVersions operation.
//    pageNum := 0
//    err := client.DescribeDBEngineVersionsPages(params,
//        func(page *docdb.DescribeDBEngineVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBEngineVersionsPages(input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool) error {
	return c.DescribeDBEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBEngineVersionsPagesWithContext same as DescribeDBEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBEngineVersionsPagesWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBEngineVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBInstances for more information on using the DescribeDBInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBInstancesRequest method.
//    req, resp := client.DescribeDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances
func (c *DocDB) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	output = &DescribeDBInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBInstances API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns information about provisioned Amazon DocumentDB instances. This API
// supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances
func (c *DocDB) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesWithContext is the same as DescribeDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBInstancesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, opts ...request.Option) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBInstancesPages iterates over the pages of a DescribeDBInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBInstances operation.
//    pageNum := 0
//    err := client.DescribeDBInstancesPages(params,
//        func(page *docdb.DescribeDBInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBInstancesPages(input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool) error {
	return c.DescribeDBInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBInstancesPagesWithContext same as DescribeDBInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBInstancesPagesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeDBSubnetGroups = "DescribeDBSubnetGroups"

// DescribeDBSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSubnetGroups for more information on using the DescribeDBSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSubnetGroupsRequest method.
//    req, resp := client.DescribeDBSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups
func (c *DocDB) DescribeDBSubnetGroupsRequest(input *DescribeDBSubnetGroupsInput) (req *request.Request, output *DescribeDBSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSubnetGroupsInput{}
	}

	output = &DescribeDBSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSubnetGroups API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified,
// the list will contain only the descriptions of the specified DBSubnetGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeDBSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups
func (c *DocDB) DescribeDBSubnetGroups(input *DescribeDBSubnetGroupsInput) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBSubnetGroupsWithContext is the same as DescribeDBSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBSubnetGroupsWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, opts ...request.Option) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSubnetGroupsPages iterates over the pages of a DescribeDBSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeDBSubnetGroupsPages(params,
//        func(page *docdb.DescribeDBSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeDBSubnetGroupsPages(input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool) error {
	return c.DescribeDBSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSubnetGroupsPagesWithContext same as DescribeDBSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeDBSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDBSubnetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEngineDefaultClusterParameters = "DescribeEngineDefaultClusterParameters"

// DescribeEngineDefaultClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultClusterParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultClusterParameters for more information on using the DescribeEngineDefaultClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultClusterParametersRequest method.
//    req, resp := client.DescribeEngineDefaultClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *DocDB) DescribeEngineDefaultClusterParametersRequest(input *DescribeEngineDefaultClusterParametersInput) (req *request.Request, output *DescribeEngineDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngineDefaultClusterParametersInput{}
	}

	output = &DescribeEngineDefaultClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultClusterParameters API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns the default engine and system parameter information for the cluster
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeEngineDefaultClusterParameters for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *DocDB) DescribeEngineDefaultClusterParameters(input *DescribeEngineDefaultClusterParametersInput) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultClusterParametersWithContext is the same as DescribeEngineDefaultClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeEngineDefaultClusterParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultClusterParametersInput, opts ...request.Option) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEventCategories
func (c *DocDB) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Displays a list of categories for all event source types, or, if specified,
// for a specified source type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEventCategories
func (c *DocDB) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents
func (c *DocDB) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns events related to instances, security groups, snapshots, and DB parameter
// groups for the past 14 days. You can obtain events specific to a particular
// DB instance, security group, snapshot, or parameter group by providing the
// name as a parameter. By default, the events of the past hour are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents
func (c *DocDB) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *docdb.DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrderableDBInstanceOptions = "DescribeOrderableDBInstanceOptions"

// DescribeOrderableDBInstanceOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableDBInstanceOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableDBInstanceOptions for more information on using the DescribeOrderableDBInstanceOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableDBInstanceOptionsRequest method.
//    req, resp := client.DescribeOrderableDBInstanceOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *DocDB) DescribeOrderableDBInstanceOptionsRequest(input *DescribeOrderableDBInstanceOptionsInput) (req *request.Request, output *DescribeOrderableDBInstanceOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableDBInstanceOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableDBInstanceOptionsInput{}
	}

	output = &DescribeOrderableDBInstanceOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableDBInstanceOptions API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of orderable instance options for the specified engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribeOrderableDBInstanceOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *DocDB) DescribeOrderableDBInstanceOptions(input *DescribeOrderableDBInstanceOptionsInput) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsWithContext is the same as DescribeOrderableDBInstanceOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableDBInstanceOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeOrderableDBInstanceOptionsWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, opts ...request.Option) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsPages iterates over the pages of a DescribeOrderableDBInstanceOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableDBInstanceOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableDBInstanceOptions operation.
//    pageNum := 0
//    err := client.DescribeOrderableDBInstanceOptionsPages(params,
//        func(page *docdb.DescribeOrderableDBInstanceOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribeOrderableDBInstanceOptionsPages(input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool) error {
	return c.DescribeOrderableDBInstanceOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableDBInstanceOptionsPagesWithContext same as DescribeOrderableDBInstanceOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribeOrderableDBInstanceOptionsPagesWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableDBInstanceOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableDBInstanceOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrderableDBInstanceOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingMaintenanceActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingMaintenanceActions for more information on using the DescribePendingMaintenanceActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingMaintenanceActionsRequest method.
//    req, resp := client.DescribePendingMaintenanceActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribePendingMaintenanceActions
func (c *DocDB) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	output = &DescribePendingMaintenanceActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingMaintenanceActions API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Returns a list of resources (for example, instances) that have at least one
// pending maintenance action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation DescribePendingMaintenanceActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribePendingMaintenanceActions
func (c *DocDB) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsWithContext is the same as DescribePendingMaintenanceActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingMaintenanceActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribePendingMaintenanceActionsWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, opts ...request.Option) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsPages iterates over the pages of a DescribePendingMaintenanceActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePendingMaintenanceActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePendingMaintenanceActions operation.
//    pageNum := 0
//    err := client.DescribePendingMaintenanceActionsPages(params,
//        func(page *docdb.DescribePendingMaintenanceActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DocDB) DescribePendingMaintenanceActionsPages(input *DescribePendingMaintenanceActionsInput, fn func(*DescribePendingMaintenanceActionsOutput, bool) bool) error {
	return c.DescribePendingMaintenanceActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePendingMaintenanceActionsPagesWithContext same as DescribePendingMaintenanceActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) DescribePendingMaintenanceActionsPagesWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, fn func(*DescribePendingMaintenanceActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePendingMaintenanceActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePendingMaintenanceActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePendingMaintenanceActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opFailoverDBCluster = "FailoverDBCluster"

// FailoverDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the FailoverDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailoverDBCluster for more information on using the FailoverDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FailoverDBClusterRequest method.
//    req, resp := client.FailoverDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/FailoverDBCluster
func (c *DocDB) FailoverDBClusterRequest(input *FailoverDBClusterInput) (req *request.Request, output *FailoverDBClusterOutput) {
	op := &request.Operation{
		Name:       opFailoverDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverDBClusterInput{}
	}

	output = &FailoverDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FailoverDBCluster API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Forces a failover for a cluster.
//
// A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only
// instances) in the cluster to be the primary instance (the cluster writer).
//
// If the primary instance fails, Amazon DocumentDB automatically fails over
// to an Amazon DocumentDB replica, if one exists. You can force a failover
// when you want to simulate a failure of a primary instance for testing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation FailoverDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/FailoverDBCluster
func (c *DocDB) FailoverDBCluster(input *FailoverDBClusterInput) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	return out, req.Send()
}

// FailoverDBClusterWithContext is the same as FailoverDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See FailoverDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) FailoverDBClusterWithContext(ctx aws.Context, input *FailoverDBClusterInput, opts ...request.Option) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ListTagsForResource
func (c *DocDB) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Lists all tags on an Amazon DocumentDB resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ListTagsForResource
func (c *DocDB) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBCluster = "ModifyDBCluster"

// ModifyDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBCluster for more information on using the ModifyDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterRequest method.
//    req, resp := client.ModifyDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBCluster
func (c *DocDB) ModifyDBClusterRequest(input *ModifyDBClusterInput) (req *request.Request, output *ModifyDBClusterOutput) {
	op := &request.Operation{
		Name:       opModifyDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterInput{}
	}

	output = &ModifyDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBCluster API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Modifies a setting for an Amazon DocumentDB cluster. You can change one or
// more database configuration parameters by specifying these parameters and
// the new values in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ModifyDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The subnet group doesn't cover all Availability Zones after it is created
//   because of changes that were made.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The subnet group can't be deleted because it's in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName doesn't refer to an existing cluster parameter
//   group.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the security group doesn't allow deletion.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   You already have a cluster with the given identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBCluster
func (c *DocDB) ModifyDBCluster(input *ModifyDBClusterInput) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	return out, req.Send()
}

// ModifyDBClusterWithContext is the same as ModifyDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ModifyDBClusterWithContext(ctx aws.Context, input *ModifyDBClusterInput, opts ...request.Option) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterParameterGroup = "ModifyDBClusterParameterGroup"

// ModifyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterParameterGroup for more information on using the ModifyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterParameterGroupRequest method.
//    req, resp := client.ModifyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterParameterGroup
func (c *DocDB) ModifyDBClusterParameterGroupRequest(input *ModifyDBClusterParameterGroupInput) (req *request.Request, output *ModifyDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterParameterGroupInput{}
	}

	output = &ModifyDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterParameterGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Modifies the parameters of a cluster parameter group. To modify more than
// one parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot or maintenance window before the change can take
// effect.
//
// After you create a cluster parameter group, you should wait at least 5 minutes
// before creating your first cluster that uses that cluster parameter group
// as the default parameter group. This allows Amazon DocumentDB to fully complete
// the create action before the parameter group is used as the default for a
// new cluster. This step is especially important for parameters that are critical
// when creating the default database for a cluster, such as the character set
// for the default database defined by the character_set_database parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ModifyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The parameter group is in use, or it is in a state that is not valid. If
//   you are trying to delete the parameter group, you can't delete it when the
//   parameter group is in this state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterParameterGroup
func (c *DocDB) ModifyDBClusterParameterGroup(input *ModifyDBClusterParameterGroupInput) (*ModifyDBClusterParameterGroupOutput, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBClusterParameterGroupWithContext is the same as ModifyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ModifyDBClusterParameterGroupWithContext(ctx aws.Context, input *ModifyDBClusterParameterGroupInput, opts ...request.Option) (*ModifyDBClusterParameterGroupOutput, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterSnapshotAttribute = "ModifyDBClusterSnapshotAttribute"

// ModifyDBClusterSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterSnapshotAttribute for more information on using the ModifyDBClusterSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterSnapshotAttributeRequest method.
//    req, resp := client.ModifyDBClusterSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *DocDB) ModifyDBClusterSnapshotAttributeRequest(input *ModifyDBClusterSnapshotAttributeInput) (req *request.Request, output *ModifyDBClusterSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterSnapshotAttributeInput{}
	}

	output = &ModifyDBClusterSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterSnapshotAttribute API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Adds an attribute and values to, or removes an attribute and values from,
// a manual DB cluster snapshot.
//
// To share a manual cluster snapshot with other AWS accounts, specify restore
// as the AttributeName, and use the ValuesToAdd parameter to add a list of
// IDs of the AWS accounts that are authorized to restore the manual cluster
// snapshot. Use the value all to make the manual cluster snapshot public, which
// means that it can be copied or restored by all AWS accounts. Do not add the
// all value for any manual DB cluster snapshots that contain private information
// that you don't want available to all AWS accounts. If a manual cluster snapshot
// is encrypted, it can be shared, but only by specifying a list of authorized
// AWS account IDs for the ValuesToAdd parameter. You can't use all as a value
// for that parameter in this case.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ModifyDBClusterSnapshotAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
//   * ErrCodeSharedSnapshotQuotaExceededFault "SharedSnapshotQuotaExceeded"
//   You have exceeded the maximum number of accounts that you can share a manual
//   DB snapshot with.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *DocDB) ModifyDBClusterSnapshotAttribute(input *ModifyDBClusterSnapshotAttributeInput) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifyDBClusterSnapshotAttributeWithContext is the same as ModifyDBClusterSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ModifyDBClusterSnapshotAttributeWithContext(ctx aws.Context, input *ModifyDBClusterSnapshotAttributeInput, opts ...request.Option) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBInstance = "ModifyDBInstance"

// ModifyDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBInstance for more information on using the ModifyDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBInstanceRequest method.
//    req, resp := client.ModifyDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBInstance
func (c *DocDB) ModifyDBInstanceRequest(input *ModifyDBInstanceInput) (req *request.Request, output *ModifyDBInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBInstanceInput{}
	}

	output = &ModifyDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBInstance API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Modifies settings for an instance. You can change one or more database configuration
// parameters by specifying these parameters and the new values in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ModifyDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the security group doesn't allow deletion.
//
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   You already have a instance with the given identifier.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName doesn't refer to an existing security group.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   The specified instance class isn't available in the specified Availability
//   Zone.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The subnet group doesn't cover all Availability Zones after it is created
//   because of changes that were made.
//
//   * ErrCodeDBUpgradeDependencyFailureFault "DBUpgradeDependencyFailure"
//   The upgrade failed because a resource that the depends on can't be modified.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   Storage of the specified StorageType can't be associated with the DB instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   The specified CIDR IP or Amazon EC2 security group isn't authorized for the
//   specified security group.
//
//   Amazon DocumentDB also might not be authorized to perform necessary actions
//   on your behalf using IAM.
//
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier doesn't refer to an existing certificate.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBInstance
func (c *DocDB) ModifyDBInstance(input *ModifyDBInstanceInput) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	return out, req.Send()
}

// ModifyDBInstanceWithContext is the same as ModifyDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ModifyDBInstanceWithContext(ctx aws.Context, input *ModifyDBInstanceInput, opts ...request.Option) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSubnetGroup = "ModifyDBSubnetGroup"

// ModifyDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSubnetGroup for more information on using the ModifyDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSubnetGroupRequest method.
//    req, resp := client.ModifyDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBSubnetGroup
func (c *DocDB) ModifyDBSubnetGroupRequest(input *ModifyDBSubnetGroupInput) (req *request.Request, output *ModifyDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSubnetGroupInput{}
	}

	output = &ModifyDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSubnetGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Modifies an existing subnet group. subnet groups must contain at least one
// subnet in at least two Availability Zones in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ModifyDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   The request would cause you to exceed the allowed number of subnets in a
//   subnet group.
//
//   * ErrCodeSubnetAlreadyInUse "SubnetAlreadyInUse"
//   The subnet is already in use in the Availability Zone.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBSubnetGroup
func (c *DocDB) ModifyDBSubnetGroup(input *ModifyDBSubnetGroupInput) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyDBSubnetGroupWithContext is the same as ModifyDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ModifyDBSubnetGroupWithContext(ctx aws.Context, input *ModifyDBSubnetGroupInput, opts ...request.Option) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootDBInstance = "RebootDBInstance"

// RebootDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootDBInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootDBInstance for more information on using the RebootDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootDBInstanceRequest method.
//    req, resp := client.RebootDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RebootDBInstance
func (c *DocDB) RebootDBInstanceRequest(input *RebootDBInstanceInput) (req *request.Request, output *RebootDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootDBInstanceInput{}
	}

	output = &RebootDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootDBInstance API operation for Amazon DocumentDB with MongoDB compatibility.
//
// You might need to reboot your instance, usually for maintenance reasons.
// For example, if you make certain changes, or if you change the cluster parameter
// group that is associated with the instance, you must reboot the instance
// for the changes to take effect.
//
// Rebooting an instance restarts the database engine service. Rebooting an
// instance results in a momentary outage, during which the instance status
// is set to rebooting.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation RebootDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RebootDBInstance
func (c *DocDB) RebootDBInstance(input *RebootDBInstanceInput) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	return out, req.Send()
}

// RebootDBInstanceWithContext is the same as RebootDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) RebootDBInstanceWithContext(ctx aws.Context, input *RebootDBInstanceInput, opts ...request.Option) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RemoveTagsFromResource
func (c *DocDB) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Removes metadata tags from an Amazon DocumentDB resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier doesn't refer to an existing instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RemoveTagsFromResource
func (c *DocDB) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBClusterParameterGroup = "ResetDBClusterParameterGroup"

// ResetDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBClusterParameterGroup for more information on using the ResetDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBClusterParameterGroupRequest method.
//    req, resp := client.ResetDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ResetDBClusterParameterGroup
func (c *DocDB) ResetDBClusterParameterGroupRequest(input *ResetDBClusterParameterGroupInput) (req *request.Request, output *ResetDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opResetDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBClusterParameterGroupInput{}
	}

	output = &ResetDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBClusterParameterGroup API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Modifies the parameters of a cluster parameter group to the default value.
// To reset specific parameters, submit a list of the following: ParameterName
// and ApplyMethod. To reset the entire cluster parameter group, specify the
// DBClusterParameterGroupName and ResetAllParameters parameters.
//
// When you reset the entire group, dynamic parameters are updated immediately
// and static parameters are set to pending-reboot to take effect on the next
// DB instance reboot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation ResetDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The parameter group is in use, or it is in a state that is not valid. If
//   you are trying to delete the parameter group, you can't delete it when the
//   parameter group is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName doesn't refer to an existing parameter group.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ResetDBClusterParameterGroup
func (c *DocDB) ResetDBClusterParameterGroup(input *ResetDBClusterParameterGroupInput) (*ResetDBClusterParameterGroupOutput, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBClusterParameterGroupWithContext is the same as ResetDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) ResetDBClusterParameterGroupWithContext(ctx aws.Context, input *ResetDBClusterParameterGroupInput, opts ...request.Option) (*ResetDBClusterParameterGroupOutput, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterFromSnapshot = "RestoreDBClusterFromSnapshot"

// RestoreDBClusterFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterFromSnapshot for more information on using the RestoreDBClusterFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterFromSnapshotRequest method.
//    req, resp := client.RestoreDBClusterFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterFromSnapshot
func (c *DocDB) RestoreDBClusterFromSnapshotRequest(input *RestoreDBClusterFromSnapshotInput) (req *request.Request, output *RestoreDBClusterFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromSnapshotInput{}
	}

	output = &RestoreDBClusterFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterFromSnapshot API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new cluster from a snapshot or cluster snapshot.
//
// If a snapshot is specified, the target cluster is created from the source
// DB snapshot with a default configuration and default security group.
//
// If a cluster snapshot is specified, the target cluster is created from the
// source cluster restore point with the same configuration as the original
// source DB cluster, except that the new cluster is created with the default
// security group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation RestoreDBClusterFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   You already have a cluster with the given identifier.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The cluster can't be created because you have reached the maximum allowed
//   quota of clusters.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier doesn't refer to an existing snapshot.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The cluster doesn't have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is not enough storage available for the current action. You might be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the snapshot doesn't allow deletion.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The subnet group doesn't cover all Availability Zones after it is created
//   because of changes that were made.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   You cannot restore from a virtual private cloud (VPC) backup to a non-VPC
//   DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred when accessing an AWS KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterFromSnapshot
func (c *DocDB) RestoreDBClusterFromSnapshot(input *RestoreDBClusterFromSnapshotInput) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreDBClusterFromSnapshotWithContext is the same as RestoreDBClusterFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) RestoreDBClusterFromSnapshotWithContext(ctx aws.Context, input *RestoreDBClusterFromSnapshotInput, opts ...request.Option) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterToPointInTime = "RestoreDBClusterToPointInTime"

// RestoreDBClusterToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterToPointInTime operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterToPointInTime for more information on using the RestoreDBClusterToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterToPointInTimeRequest method.
//    req, resp := client.RestoreDBClusterToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterToPointInTime
func (c *DocDB) RestoreDBClusterToPointInTimeRequest(input *RestoreDBClusterToPointInTimeInput) (req *request.Request, output *RestoreDBClusterToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterToPointInTimeInput{}
	}

	output = &RestoreDBClusterToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterToPointInTime API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Restores a cluster to an arbitrary point in time. Users can restore to any
// point in time before LatestRestorableTime for up to BackupRetentionPeriod
// days. The target cluster is created from the source cluster with the same
// configuration as the original cluster, except that the new cluster is created
// with the default security group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation RestoreDBClusterToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   You already have a cluster with the given identifier.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   The cluster can't be created because you have reached the maximum allowed
//   quota of clusters.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier doesn't refer to an existing cluster snapshot.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName doesn't refer to an existing subnet group.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The cluster doesn't have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is not enough storage available for the current action. You might be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The provided value isn't a valid cluster snapshot state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the snapshot doesn't allow deletion.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   You cannot restore from a virtual private cloud (VPC) backup to a non-VPC
//   DB instance.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is not valid, or multiple subnets were requested that
//   are not all in a common virtual private cloud (VPC).
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The subnet group doesn't cover all Availability Zones after it is created
//   because of changes that were made.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   An error occurred when accessing an AWS KMS key.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   The request would cause you to exceed the allowed amount of storage available
//   across all instances.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterToPointInTime
func (c *DocDB) RestoreDBClusterToPointInTime(input *RestoreDBClusterToPointInTimeInput) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreDBClusterToPointInTimeWithContext is the same as RestoreDBClusterToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) RestoreDBClusterToPointInTimeWithContext(ctx aws.Context, input *RestoreDBClusterToPointInTimeInput, opts ...request.Option) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDBCluster = "StartDBCluster"

// StartDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the StartDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDBCluster for more information on using the StartDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDBClusterRequest method.
//    req, resp := client.StartDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StartDBCluster
func (c *DocDB) StartDBClusterRequest(input *StartDBClusterInput) (req *request.Request, output *StartDBClusterOutput) {
	op := &request.Operation{
		Name:       opStartDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDBClusterInput{}
	}

	output = &StartDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDBCluster API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Restarts the stopped cluster that is specified by DBClusterIdentifier. For
// more information, see Stopping and Starting an Amazon DocumentDB Cluster
// (https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation StartDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StartDBCluster
func (c *DocDB) StartDBCluster(input *StartDBClusterInput) (*StartDBClusterOutput, error) {
	req, out := c.StartDBClusterRequest(input)
	return out, req.Send()
}

// StartDBClusterWithContext is the same as StartDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See StartDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) StartDBClusterWithContext(ctx aws.Context, input *StartDBClusterInput, opts ...request.Option) (*StartDBClusterOutput, error) {
	req, out := c.StartDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDBCluster = "StopDBCluster"

// StopDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the StopDBCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDBCluster for more information on using the StopDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDBClusterRequest method.
//    req, resp := client.StopDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StopDBCluster
func (c *DocDB) StopDBClusterRequest(input *StopDBClusterInput) (req *request.Request, output *StopDBClusterOutput) {
	op := &request.Operation{
		Name:       opStopDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDBClusterInput{}
	}

	output = &StopDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDBCluster API operation for Amazon DocumentDB with MongoDB compatibility.
//
// Stops the running cluster that is specified by DBClusterIdentifier. The cluster
// must be in the available state. For more information, see Stopping and Starting
// an Amazon DocumentDB Cluster (https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB with MongoDB compatibility's
// API operation StopDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier doesn't refer to an existing cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The cluster isn't in a valid state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified instance isn't in the available state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StopDBCluster
func (c *DocDB) StopDBCluster(input *StopDBClusterInput) (*StopDBClusterOutput, error) {
	req, out := c.StopDBClusterRequest(input)
	return out, req.Send()
}

// StopDBClusterWithContext is the same as StopDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See StopDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDB) StopDBClusterWithContext(ctx aws.Context, input *StopDBClusterInput, opts ...request.Option) (*StopDBClusterOutput, error) {
	req, out := c.StopDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input to AddTagsToResource.
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon DocumentDB resource that the tags are added to. This value is
	// an Amazon Resource Name .
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tags to be assigned to the Amazon DocumentDB resource.
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *AddTagsToResourceInput) SetResourceName(v string) *AddTagsToResourceInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Represents the input to ApplyPendingMaintenanceAction.
type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	//
	// Valid values: system-update, db-upgrade
	//
	// ApplyAction is a required field
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request or undoes an opt-in request.
	// An opt-in request of type immediate can't be undone.
	//
	// Valid values:
	//
	//    * immediate - Apply the maintenance action immediately.
	//
	//    * next-maintenance - Apply the maintenance action during the next maintenance
	//    window for the resource.
	//
	//    * undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// OptInType is a required field
	OptInType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource that the pending maintenance
	// action applies to.
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyPendingMaintenanceActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyPendingMaintenanceActionInput"}
	if s.ApplyAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyAction"))
	}
	if s.OptInType == nil {
		invalidParams.Add(request.NewErrParamRequired("OptInType"))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyAction sets the ApplyAction field's value.
func (s *ApplyPendingMaintenanceActionInput) SetApplyAction(v string) *ApplyPendingMaintenanceActionInput {
	s.ApplyAction = &v
	return s
}

// SetOptInType sets the OptInType field's value.
func (s *ApplyPendingMaintenanceActionInput) SetOptInType(v string) *ApplyPendingMaintenanceActionInput {
	s.OptInType = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ApplyPendingMaintenanceActionInput) SetResourceIdentifier(v string) *ApplyPendingMaintenanceActionInput {
	s.ResourceIdentifier = &v
	return s
}

type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of ApplyPendingMaintenanceAction.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

// SetResourcePendingMaintenanceActions sets the ResourcePendingMaintenanceActions field's value.
func (s *ApplyPendingMaintenanceActionOutput) SetResourcePendingMaintenanceActions(v *ResourcePendingMaintenanceActions) *ApplyPendingMaintenanceActionOutput {
	s.ResourcePendingMaintenanceActions = v
	return s
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// A certificate authority (CA) certificate for an AWS account.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	//
	// Example: arn:aws:rds:us-east-1::cert:rds-ca-2019
	CertificateArn *string `type:"string"`

	// The unique key that identifies a certificate.
	//
	// Example: rds-ca-2019
	CertificateIdentifier *string `type:"string"`

	// The type of the certificate.
	//
	// Example: CA
	CertificateType *string `type:"string"`

	// The thumbprint of the certificate.
	Thumbprint *string `type:"string"`

	// The starting date-time from which the certificate is valid.
	//
	// Example: 2019-07-31T17:57:09Z
	ValidFrom *time.Time `type:"timestamp"`

	// The date-time after which the certificate is no longer valid.
	//
	// Example: 2024-07-31T17:57:09Z
	ValidTill *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *Certificate) SetCertificateIdentifier(v string) *Certificate {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificateType sets the CertificateType field's value.
func (s *Certificate) SetCertificateType(v string) *Certificate {
	s.CertificateType = &v
	return s
}

// SetThumbprint sets the Thumbprint field's value.
func (s *Certificate) SetThumbprint(v string) *Certificate {
	s.Thumbprint = &v
	return s
}

// SetValidFrom sets the ValidFrom field's value.
func (s *Certificate) SetValidFrom(v time.Time) *Certificate {
	s.ValidFrom = &v
	return s
}

// SetValidTill sets the ValidTill field's value.
func (s *Certificate) SetValidTill(v time.Time) *Certificate {
	s.ValidTill = &v
	return s
}

// The configuration setting for the log types to be enabled for export to Amazon
// CloudWatch Logs for a specific instance or cluster.
//
// The EnableLogTypes and DisableLogTypes arrays determine which logs are exported
// (or not exported) to CloudWatch Logs. The values within these arrays depend
// on the engine that is being used.
type CloudwatchLogsExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of log types to disable.
	DisableLogTypes []*string `type:"list"`

	// The list of log types to enable.
	EnableLogTypes []*string `type:"list"`
}

// String returns the string representation
func (s CloudwatchLogsExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudwatchLogsExportConfiguration) GoString() string {
	return s.String()
}

// SetDisableLogTypes sets the DisableLogTypes field's value.
func (s *CloudwatchLogsExportConfiguration) SetDisableLogTypes(v []*string) *CloudwatchLogsExportConfiguration {
	s.DisableLogTypes = v
	return s
}

// SetEnableLogTypes sets the EnableLogTypes field's value.
func (s *CloudwatchLogsExportConfiguration) SetEnableLogTypes(v []*string) *CloudwatchLogsExportConfiguration {
	s.EnableLogTypes = v
	return s
}

// Represents the input to CopyDBClusterParameterGroup.
type CopyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or Amazon Resource Name (ARN) for the source cluster parameter
	// group.
	//
	// Constraints:
	//
	//    * Must specify a valid cluster parameter group.
	//
	//    * If the source cluster parameter group is in the same AWS Region as the
	//    copy, specify a valid parameter group identifier; for example, my-db-cluster-param-group,
	//    or a valid ARN.
	//
	//    * If the source parameter group is in a different AWS Region than the
	//    copy, specify a valid cluster parameter group ARN; for example, arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group.
	//
	// SourceDBClusterParameterGroupIdentifier is a required field
	SourceDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`

	// The tags that are to be assigned to the parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied cluster parameter group.
	//
	// TargetDBClusterParameterGroupDescription is a required field
	TargetDBClusterParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied cluster parameter group.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-param-group1
	//
	// TargetDBClusterParameterGroupIdentifier is a required field
	TargetDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterParameterGroupInput"}
	if s.SourceDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterParameterGroupIdentifier"))
	}
	if s.TargetDBClusterParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupDescription"))
	}
	if s.TargetDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBClusterParameterGroupIdentifier sets the SourceDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetSourceDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.SourceDBClusterParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterParameterGroupInput) SetTags(v []*Tag) *CopyDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterParameterGroupDescription sets the TargetDBClusterParameterGroupDescription field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupDescription(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupDescription = &v
	return s
}

// SetTargetDBClusterParameterGroupIdentifier sets the TargetDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupIdentifier = &v
	return s
}

type CopyDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster parameter group.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CopyDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CopyDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

// Represents the input to CopyDBClusterSnapshot.
type CopyDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Set to true to copy all tags from the source cluster snapshot to the target
	// cluster snapshot, and otherwise false. The default is false.
	CopyTags *bool `type:"boolean"`

	// The AWS KMS key ID for an encrypted cluster snapshot. The AWS KMS key ID
	// is the Amazon Resource Name (ARN), AWS KMS key identifier, or the AWS KMS
	// key alias for the AWS KMS encryption key.
	//
	// If you copy an encrypted cluster snapshot from your AWS account, you can
	// specify a value for KmsKeyId to encrypt the copy with a new AWS KMS encryption
	// key. If you don't specify a value for KmsKeyId, then the copy of the cluster
	// snapshot is encrypted with the same AWS KMS key as the source cluster snapshot.
	//
	// If you copy an encrypted cluster snapshot that is shared from another AWS
	// account, then you must specify a value for KmsKeyId.
	//
	// To copy an encrypted cluster snapshot to another AWS Region, set KmsKeyId
	// to the AWS KMS key ID that you want to use to encrypt the copy of the cluster
	// snapshot in the destination Region. AWS KMS encryption keys are specific
	// to the AWS Region that they are created in, and you can't use encryption
	// keys from one AWS Region in another AWS Region.
	//
	// If you copy an unencrypted cluster snapshot and specify a value for the KmsKeyId
	// parameter, an error is returned.
	KmsKeyId *string `type:"string"`

	// The URL that contains a Signature Version 4 signed request for the CopyDBClusterSnapshot
	// API action in the AWS Region that contains the source cluster snapshot to
	// copy. You must use the PreSignedUrl parameter when copying a cluster snapshot
	// from another AWS Region.
	//
	// If you are using an AWS SDK tool or the AWS CLI, you can specify SourceRegion
	// (or --source-region for the AWS CLI) instead of specifying PreSignedUrl manually.
	// Specifying SourceRegion autogenerates a pre-signed URL that is a valid request
	// for the operation that can be executed in the source AWS Region.
	//
	// The presigned URL must be a valid request for the CopyDBClusterSnapshot API
	// action that can be executed in the source AWS Region that contains the cluster
	// snapshot to be copied. The presigned URL request must contain the following
	// parameter values:
	//
	//    * SourceRegion - The ID of the region that contains the snapshot to be
	//    copied.
	//
	//    * SourceDBClusterSnapshotIdentifier - The identifier for the the encrypted
	//    cluster snapshot to be copied. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are copying
	//    an encrypted cluster snapshot from the us-east-1 AWS Region, then your
	//    SourceDBClusterSnapshotIdentifier looks something like the following:
	//    arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot.
	//
	//    * TargetDBClusterSnapshotIdentifier - The identifier for the new cluster
	//    snapshot to be created. This parameter isn't case sensitive.
	PreSignedUrl *string `type:"string"`

	// The identifier of the cluster snapshot to copy. This parameter is not case
	// sensitive.
	//
	// Constraints:
	//
	//    * Must specify a valid system snapshot in the available state.
	//
	//    * If the source snapshot is in the same AWS Region as the copy, specify
	//    a valid snapshot identifier.
	//
	//    * If the source snapshot is in a different AWS Region than the copy, specify
	//    a valid cluster snapshot ARN.
	//
	// Example: my-cluster-snapshot1
	//
	// SourceDBClusterSnapshotIdentifier is a required field
	SourceDBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the new cluster snapshot to create from the source cluster
	// snapshot. This parameter is not case sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-snapshot2
	//
	// TargetDBClusterSnapshotIdentifier is a required field
	TargetDBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterSnapshotInput"}
	if s.SourceDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterSnapshotIdentifier"))
	}
	if s.TargetDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *CopyDBClusterSnapshotInput) SetCopyTags(v bool) *CopyDBClusterSnapshotInput {
	s.CopyTags = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyDBClusterSnapshotInput) SetKmsKeyId(v string) *CopyDBClusterSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CopyDBClusterSnapshotInput) SetPreSignedUrl(v string) *CopyDBClusterSnapshotInput {
	s.PreSignedUrl = &v
	return s
}

// SetSourceDBClusterSnapshotIdentifier sets the SourceDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetSourceDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.SourceDBClusterSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterSnapshotInput) SetTags(v []*Tag) *CopyDBClusterSnapshotInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterSnapshotIdentifier sets the TargetDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetTargetDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.TargetDBClusterSnapshotIdentifier = &v
	return s
}

type CopyDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster snapshot.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CopyDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CopyDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Represents the input to CreateDBCluster.
type CreateDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon EC2 Availability Zones that instances in the cluster can
	// be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The cluster identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the cluster parameter group to associate with this cluster.
	DBClusterParameterGroupName *string `type:"string"`

	// A subnet group to associate with this cluster.
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// Specifies whether this cluster can be deleted. If DeletionProtection is enabled,
	// the cluster cannot be deleted unless it is modified and DeletionProtection
	// is disabled. DeletionProtection protects clusters from being accidentally
	// deleted.
	DeletionProtection *bool `type:"boolean"`

	// A list of log types that need to be enabled for exporting to Amazon CloudWatch
	// Logs. You can enable audit logs or profiler logs. For more information, see
	// Auditing Amazon DocumentDB Events (https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html)
	// and Profiling Amazon DocumentDB Operations (https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html).
	EnableCloudwatchLogsExports []*string `type:"list"`

	// The name of the database engine to be used for this cluster.
	//
	// Valid values: docdb
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use. The --engine-version will
	// default to the latest major engine version. For production workloads, we
	// recommend explicitly declaring this parameter with the intended major engine
	// version.
	EngineVersion *string `type:"string"`

	// The AWS KMS key identifier for an encrypted cluster.
	//
	// The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
	// KMS encryption key. If you are creating a cluster using the same AWS account
	// that owns the AWS KMS encryption key that is used to encrypt the new cluster,
	// you can use the AWS KMS key alias instead of the ARN for the AWS KMS encryption
	// key.
	//
	// If an encryption key is not specified in KmsKeyId:
	//
	//    * If ReplicationSourceIdentifier identifies an encrypted source, then
	//    Amazon DocumentDB uses the encryption key that is used to encrypt the
	//    source. Otherwise, Amazon DocumentDB uses your default encryption key.
	//
	//    * If the StorageEncrypted parameter is true and ReplicationSourceIdentifier
	//    is not specified, Amazon DocumentDB uses your default encryption key.
	//
	// AWS KMS creates the default encryption key for your AWS account. Your AWS
	// account has a different default encryption key for each AWS Region.
	//
	// If you create a replica of an encrypted cluster in another AWS Region, you
	// must set KmsKeyId to a KMS key ID that is valid in the destination AWS Region.
	// This key is used to encrypt the replica in that AWS Region.
	KmsKeyId *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except forward slash (/), double quote ("), or
	// the "at" symbol (@).
	//
	// Constraints: Must contain from 8 to 100 characters.
	//
	// MasterUserPassword is a required field
	MasterUserPassword *string `type:"string" required:"true"`

	// The name of the master user for the cluster.
	//
	// Constraints:
	//
	//    * Must be from 1 to 63 letters or numbers.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	//
	// MasterUsername is a required field
	MasterUsername *string `type:"string" required:"true"`

	// The port number on which the instances in the cluster accept connections.
	Port *int64 `type:"integer"`

	// Not currently supported.
	PreSignedUrl *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled using the BackupRetentionPeriod parameter.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Must be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies whether the cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The tags to be assigned to the cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of EC2 VPC security groups to associate with this cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.MasterUserPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUserPassword"))
	}
	if s.MasterUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUsername"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateDBClusterInput) SetAvailabilityZones(v []*string) *CreateDBClusterInput {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBClusterInput) SetBackupRetentionPeriod(v int64) *CreateDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterInput) SetDBClusterIdentifier(v string) *CreateDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBClusterInput) SetDBSubnetGroupName(v string) *CreateDBClusterInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateDBClusterInput) SetDeletionProtection(v bool) *CreateDBClusterInput {
	s.DeletionProtection = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *CreateDBClusterInput) SetEnableCloudwatchLogsExports(v []*string) *CreateDBClusterInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBClusterInput) SetEngine(v string) *CreateDBClusterInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBClusterInput) SetEngineVersion(v string) *CreateDBClusterInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBClusterInput) SetKmsKeyId(v string) *CreateDBClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBClusterInput) SetMasterUserPassword(v string) *CreateDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBClusterInput) SetMasterUsername(v string) *CreateDBClusterInput {
	s.MasterUsername = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBClusterInput) SetPort(v int64) *CreateDBClusterInput {
	s.Port = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CreateDBClusterInput) SetPreSignedUrl(v string) *CreateDBClusterInput {
	s.PreSignedUrl = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBClusterInput) SetPreferredBackupWindow(v string) *CreateDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBClusterInput) SetPreferredMaintenanceWindow(v string) *CreateDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBClusterInput) SetStorageEncrypted(v bool) *CreateDBClusterInput {
	s.StorageEncrypted = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterInput) SetTags(v []*Tag) *CreateDBClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *CreateDBClusterOutput) SetDBCluster(v *DBCluster) *CreateDBClusterOutput {
	s.DBCluster = v
	return s
}

// Represents the input of CreateDBClusterParameterGroup.
type CreateDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group.
	//
	// Constraints:
	//
	//    * Must not match the name of an existing DBClusterParameterGroup.
	//
	// This value is stored as a lowercase string.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// The cluster parameter group family name.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The description for the cluster parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The tags to be assigned to the cluster parameter group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBClusterParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBClusterParameterGroupInput) SetDescription(v string) *CreateDBClusterParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterParameterGroupInput) SetTags(v []*Tag) *CreateDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

type CreateDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster parameter group.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CreateDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CreateDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

// Represents the input of CreateDBClusterSnapshot.
type CreateDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to create a snapshot for. This parameter is
	// not case sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// Example: my-cluster
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the cluster snapshot. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-snapshot1
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterSnapshotInput) SetTags(v []*Tag) *CreateDBClusterSnapshotInput {
	s.Tags = v
	return s
}

type CreateDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster snapshot.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CreateDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CreateDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Represents the input to CreateDBInstance.
type CreateDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor engine upgrades are applied automatically to the instance
	// during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Amazon EC2 Availability Zone that the instance is created in.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// The identifier of the cluster that the instance will belong to.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The compute and memory capacity of the instance; for example, db.r5.large.
	//
	// DBInstanceClass is a required field
	DBInstanceClass *string `type:"string" required:"true"`

	// The instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the database engine to be used for this instance.
	//
	// Valid value: docdb
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The time range each week during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	//
	// Default: 1
	//
	// Valid values: 0-15
	PromotionTier *int64 `type:"integer"`

	// The tags to be assigned to the instance. You can assign up to 10 tags to
	// an instance.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.DBInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceClass"))
	}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDBInstanceInput) SetAvailabilityZone(v string) *CreateDBInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBClusterIdentifier(v string) *CreateDBInstanceInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *CreateDBInstanceInput) SetDBInstanceClass(v string) *CreateDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBInstanceIdentifier(v string) *CreateDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBInstanceInput) SetEngine(v string) *CreateDBInstanceInput {
	s.Engine = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *CreateDBInstanceInput) SetPromotionTier(v int64) *CreateDBInstanceInput {
	s.PromotionTier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceInput) SetTags(v []*Tag) *CreateDBInstanceInput {
	s.Tags = v
	return s
}

type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about an instance.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *CreateDBInstanceOutput) SetDBInstance(v *DBInstance) *CreateDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Represents the input to CreateDBSubnetGroup.
type CreateDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the subnet group.
	//
	// DBSubnetGroupDescription is a required field
	DBSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 letters, numbers, periods, underscores,
	// spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The Amazon EC2 subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// The tags to be assigned to the subnet group.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSubnetGroupInput"}
	if s.DBSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupDescription"))
	}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupName(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateDBSubnetGroupInput) SetSubnetIds(v []*string) *CreateDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSubnetGroupInput) SetTags(v []*Tag) *CreateDBSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *CreateDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *CreateDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

// Detailed information about a cluster.
type DBCluster struct {
	_ struct{} `type:"structure"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the cluster. IAM roles that are associated with a cluster
	// grant permission for the cluster to access other AWS services on your behalf.
	AssociatedRoles []*DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of Amazon EC2 Availability Zones that instances in the
	// cluster can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the number of days for which automatic snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the time when the cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied cluster identifier. This identifier is the unique
	// key that identifies a cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the cluster.
	DBClusterMembers []*DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Specifies the name of the cluster parameter group for the cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group that is associated with the cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// The AWS Region-unique, immutable identifier for the cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the cluster
	// is accessed.
	DbClusterResourceId *string `type:"string"`

	// Specifies whether this cluster can be deleted. If DeletionProtection is enabled,
	// the cluster cannot be deleted unless it is modified and DeletionProtection
	// is disabled. DeletionProtection protects clusters from being accidentally
	// deleted.
	DeletionProtection *bool `type:"boolean"`

	// The earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp"`

	// A list of log types that this cluster is configured to export to Amazon CloudWatch
	// Logs.
	EnabledCloudwatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint for the primary instance of the cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// Contains the master user name for the cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// The reader endpoint for the cluster. The reader endpoint for a cluster load
	// balances connections across the Amazon DocumentDB replicas that are available
	// in a cluster. As clients request new connections to the reader endpoint,
	// Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB
	// replicas in the cluster. This functionality can help balance your read workload
	// across multiple Amazon DocumentDB replicas in your cluster.
	//
	// If a failover occurs, and the Amazon DocumentDB replica that you are connected
	// to is promoted to be the primary instance, your connection is dropped. To
	// continue sending your read workload to other Amazon DocumentDB replicas in
	// the cluster, you can then reconnect to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Specifies the current state of this cluster.
	Status *string `type:"string"`

	// Specifies whether the cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of virtual private cloud (VPC) security groups that the cluster
	// belongs to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBCluster) GoString() string {
	return s.String()
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *DBCluster) SetAssociatedRoles(v []*DBClusterRole) *DBCluster {
	s.AssociatedRoles = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBCluster) SetAvailabilityZones(v []*string) *DBCluster {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBCluster) SetBackupRetentionPeriod(v int64) *DBCluster {
	s.BackupRetentionPeriod = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBCluster) SetClusterCreateTime(v time.Time) *DBCluster {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterArn sets the DBClusterArn field's value.
func (s *DBCluster) SetDBClusterArn(v string) *DBCluster {
	s.DBClusterArn = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBCluster) SetDBClusterIdentifier(v string) *DBCluster {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterMembers sets the DBClusterMembers field's value.
func (s *DBCluster) SetDBClusterMembers(v []*DBClusterMember) *DBCluster {
	s.DBClusterMembers = v
	return s
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *DBCluster) SetDBClusterParameterGroup(v string) *DBCluster {
	s.DBClusterParameterGroup = &v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBCluster) SetDBSubnetGroup(v string) *DBCluster {
	s.DBSubnetGroup = &v
	return s
}

// SetDbClusterResourceId sets the DbClusterResourceId field's value.
func (s *DBCluster) SetDbClusterResourceId(v string) *DBCluster {
	s.DbClusterResourceId = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *DBCluster) SetDeletionProtection(v bool) *DBCluster {
	s.DeletionProtection = &v
	return s
}

// SetEarliestRestorableTime sets the EarliestRestorableTime field's value.
func (s *DBCluster) SetEarliestRestorableTime(v time.Time) *DBCluster {
	s.EarliestRestorableTime = &v
	return s
}

// SetEnabledCloudwatchLogsExports sets the EnabledCloudwatchLogsExports field's value.
func (s *DBCluster) SetEnabledCloudwatchLogsExports(v []*string) *DBCluster {
	s.EnabledCloudwatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBCluster) SetEndpoint(v string) *DBCluster {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBCluster) SetEngine(v string) *DBCluster {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBCluster) SetEngineVersion(v string) *DBCluster {
	s.EngineVersion = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DBCluster) SetHostedZoneId(v string) *DBCluster {
	s.HostedZoneId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBCluster) SetKmsKeyId(v string) *DBCluster {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBCluster) SetLatestRestorableTime(v time.Time) *DBCluster {
	s.LatestRestorableTime = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBCluster) SetMasterUsername(v string) *DBCluster {
	s.MasterUsername = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBCluster) SetMultiAZ(v bool) *DBCluster {
	s.MultiAZ = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBCluster) SetPercentProgress(v string) *DBCluster {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBCluster) SetPort(v int64) *DBCluster {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBCluster) SetPreferredBackupWindow(v string) *DBCluster {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBCluster) SetPreferredMaintenanceWindow(v string) *DBCluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *DBCluster) SetReaderEndpoint(v string) *DBCluster {
	s.ReaderEndpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBCluster) SetStatus(v string) *DBCluster {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBCluster) SetStorageEncrypted(v bool) *DBCluster {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBCluster) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBCluster {
	s.VpcSecurityGroups = v
	return s
}

// Contains information about an instance that is part of a cluster.
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the cluster parameter group for this member of the
	// DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the cluster.
	DBInstanceIdentifier *string `type:"string"`

	// A value that is true if the cluster member is the primary instance for the
	// cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterMember) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupStatus sets the DBClusterParameterGroupStatus field's value.
func (s *DBClusterMember) SetDBClusterParameterGroupStatus(v string) *DBClusterMember {
	s.DBClusterParameterGroupStatus = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBClusterMember) SetDBInstanceIdentifier(v string) *DBClusterMember {
	s.DBInstanceIdentifier = &v
	return s
}

// SetIsClusterWriter sets the IsClusterWriter field's value.
func (s *DBClusterMember) SetIsClusterWriter(v bool) *DBClusterMember {
	s.IsClusterWriter = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBClusterMember) SetPromotionTier(v int64) *DBClusterMember {
	s.PromotionTier = &v
	return s
}

// Detailed information about a cluster parameter group.
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the parameter group family that this cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this cluster parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroup) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupArn sets the DBClusterParameterGroupArn field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupArn(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupArn = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupName(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBClusterParameterGroup) SetDBParameterGroupFamily(v string) *DBClusterParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBClusterParameterGroup) SetDescription(v string) *DBClusterParameterGroup {
	s.Description = &v
	return s
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a cluster.
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - The IAM role ARN is associated with the cluster and can be
	//    used to access other AWS services on your behalf.
	//
	//    * PENDING - The IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - The IAM role ARN is associated with the cluster, but the cluster
	//    cannot assume the IAM role to access other AWS services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterRole) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *DBClusterRole) SetRoleArn(v string) *DBClusterRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterRole) SetStatus(v string) *DBClusterRole {
	s.Status = &v
	return s
}

// Detailed information about a cluster snapshot.
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Provides the list of Amazon EC2 Availability Zones that instances in the
	// cluster snapshot can be restored in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies the cluster identifier of the cluster that this cluster snapshot
	// was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this cluster snapshot.
	EngineVersion *string `type:"string"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the master user name for the cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the cluster was listening on at the time of the snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in UTC.
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the cluster snapshot was copied from a source cluster snapshot, the ARN
	// for the source cluster snapshot; otherwise, a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the virtual private cloud (VPC) ID that is associated with the cluster
	// snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshot) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBClusterSnapshot) SetAvailabilityZones(v []*string) *DBClusterSnapshot {
	s.AvailabilityZones = v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBClusterSnapshot) SetClusterCreateTime(v time.Time) *DBClusterSnapshot {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotArn sets the DBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotArn = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBClusterSnapshot) SetEngine(v string) *DBClusterSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBClusterSnapshot) SetEngineVersion(v string) *DBClusterSnapshot {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBClusterSnapshot) SetKmsKeyId(v string) *DBClusterSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBClusterSnapshot) SetMasterUsername(v string) *DBClusterSnapshot {
	s.MasterUsername = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBClusterSnapshot) SetPercentProgress(v int64) *DBClusterSnapshot {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBClusterSnapshot) SetPort(v int64) *DBClusterSnapshot {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *DBClusterSnapshot) SetSnapshotCreateTime(v time.Time) *DBClusterSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DBClusterSnapshot) SetSnapshotType(v string) *DBClusterSnapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceDBClusterSnapshotArn sets the SourceDBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetSourceDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.SourceDBClusterSnapshotArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterSnapshot) SetStatus(v string) *DBClusterSnapshot {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBClusterSnapshot) SetStorageEncrypted(v bool) *DBClusterSnapshot {
	s.StorageEncrypted = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBClusterSnapshot) SetVpcId(v string) *DBClusterSnapshot {
	s.VpcId = &v
	return s
}

// Contains the name and values of a manual cluster snapshot attribute.
//
// Manual cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual cluster snapshot.
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual cluster snapshot.
	AttributeName *string `type:"string"`

	// The values for the manual cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual cluster snapshot. If a value of all is in the list, then the manual
	// cluster snapshot is public and available for any AWS account to copy or restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeName(v string) *DBClusterSnapshotAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeValues(v []*string) *DBClusterSnapshotAttribute {
	s.AttributeValues = v
	return s
}

// Detailed information about the attributes that are associated with a cluster
// snapshot.
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the cluster snapshot.
	DBClusterSnapshotAttributes []*DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the cluster snapshot that the attributes apply to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttributesResult) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributes sets the DBClusterSnapshotAttributes field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotAttributes(v []*DBClusterSnapshotAttribute) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotAttributes = v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// Detailed information about an engine version.
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// The types of logs that the database engine has available for export to Amazon
	// CloudWatch Logs.
	ExportableLogTypes []*string `type:"list"`

	// A value that indicates whether the engine version supports exporting the
	// log types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool `type:"boolean"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []*UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBEngineVersion) GoString() string {
	return s.String()
}

// SetDBEngineDescription sets the DBEngineDescription field's value.
func (s *DBEngineVersion) SetDBEngineDescription(v string) *DBEngineVersion {
	s.DBEngineDescription = &v
	return s
}

// SetDBEngineVersionDescription sets the DBEngineVersionDescription field's value.
func (s *DBEngineVersion) SetDBEngineVersionDescription(v string) *DBEngineVersion {
	s.DBEngineVersionDescription = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBEngineVersion) SetDBParameterGroupFamily(v string) *DBEngineVersion {
	s.DBParameterGroupFamily = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBEngineVersion) SetEngine(v string) *DBEngineVersion {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBEngineVersion) SetEngineVersion(v string) *DBEngineVersion {
	s.EngineVersion = &v
	return s
}

// SetExportableLogTypes sets the ExportableLogTypes field's value.
func (s *DBEngineVersion) SetExportableLogTypes(v []*string) *DBEngineVersion {
	s.ExportableLogTypes = v
	return s
}

// SetSupportsLogExportsToCloudwatchLogs sets the SupportsLogExportsToCloudwatchLogs field's value.
func (s *DBEngineVersion) SetSupportsLogExportsToCloudwatchLogs(v bool) *DBEngineVersion {
	s.SupportsLogExportsToCloudwatchLogs = &v
	return s
}

// SetValidUpgradeTarget sets the ValidUpgradeTarget field's value.
func (s *DBEngineVersion) SetValidUpgradeTarget(v []*UpgradeTarget) *DBEngineVersion {
	s.ValidUpgradeTarget = v
	return s
}

// Detailed information about an instance.
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone that the instance is located
	// in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the name of the cluster that the instance is a member of if the
	// instance is a member of a cluster.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-provided database identifier. This identifier is the unique
	// key that identifies an instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// Specifies information on the subnet group that is associated with the instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// The AWS Region-unique, immutable identifier for the instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the instance
	// is accessed.
	DbiResourceId *string `type:"string"`

	// A list of log types that this instance is configured to export to Amazon
	// CloudWatch Logs.
	EnabledCloudwatchLogsExports []*string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Provides the date and time that the instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// Specifies that changes to the instance are pending. This element is included
	// only when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	PromotionTier *int64 `type:"integer"`

	// Not supported. Amazon DocumentDB does not currently support public endpoints.
	// The value of PubliclyAccessible is always false.
	PubliclyAccessible *bool `type:"boolean"`

	// The status of a read replica. If the instance is not a read replica, this
	// is blank.
	StatusInfos []*DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Specifies whether or not the instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security group elements that the instance belongs
	// to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstance) GoString() string {
	return s.String()
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *DBInstance) SetAutoMinorVersionUpgrade(v bool) *DBInstance {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBInstance) SetAvailabilityZone(v string) *DBInstance {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBInstance) SetBackupRetentionPeriod(v int64) *DBInstance {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *DBInstance) SetCACertificateIdentifier(v string) *DBInstance {
	s.CACertificateIdentifier = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBInstance) SetDBClusterIdentifier(v string) *DBInstance {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceArn sets the DBInstanceArn field's value.
func (s *DBInstance) SetDBInstanceArn(v string) *DBInstance {
	s.DBInstanceArn = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DBInstance) SetDBInstanceClass(v string) *DBInstance {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBInstance) SetDBInstanceIdentifier(v string) *DBInstance {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBInstanceStatus sets the DBInstanceStatus field's value.
func (s *DBInstance) SetDBInstanceStatus(v string) *DBInstance {
	s.DBInstanceStatus = &v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBInstance) SetDBSubnetGroup(v *DBSubnetGroup) *DBInstance {
	s.DBSubnetGroup = v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DBInstance) SetDbiResourceId(v string) *DBInstance {
	s.DbiResourceId = &v
	return s
}

// SetEnabledCloudwatchLogsExports sets the EnabledCloudwatchLogsExports field's value.
func (s *DBInstance) SetEnabledCloudwatchLogsExports(v []*string) *DBInstance {
	s.EnabledCloudwatchLogsExports = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBInstance) SetEndpoint(v *Endpoint) *DBInstance {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBInstance) SetEngine(v string) *DBInstance {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBInstance) SetEngineVersion(v string) *DBInstance {
	s.EngineVersion = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBInstance) SetInstanceCreateTime(v time.Time) *DBInstance {
	s.InstanceCreateTime = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBInstance) SetKmsKeyId(v string) *DBInstance {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBInstance) SetLatestRestorableTime(v time.Time) *DBInstance {
	s.LatestRestorableTime = &v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *DBInstance) SetPendingModifiedValues(v *PendingModifiedValues) *DBInstance {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBInstance) SetPreferredBackupWindow(v string) *DBInstance {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBInstance) SetPreferredMaintenanceWindow(v string) *DBInstance {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBInstance) SetPromotionTier(v int64) *DBInstance {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *DBInstance) SetPubliclyAccessible(v bool) *DBInstance {
	s.PubliclyAccessible = &v
	return s
}

// SetStatusInfos sets the StatusInfos field's value.
func (s *DBInstance) SetStatusInfos(v []*DBInstanceStatusInfo) *DBInstance {
	s.StatusInfos = v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBInstance) SetStorageEncrypted(v bool) *DBInstance {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBInstance) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBInstance {
	s.VpcSecurityGroups = v
	return s
}

// Provides a list of status information for an instance.
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// is not in an error state, this value is blank.
	Message *string `type:"string"`

	// A Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the instance. For a StatusType of read replica, the values can
	// be replicating, error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceStatusInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DBInstanceStatusInfo) SetMessage(v string) *DBInstanceStatusInfo {
	s.Message = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *DBInstanceStatusInfo) SetNormal(v bool) *DBInstanceStatusInfo {
	s.Normal = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBInstanceStatusInfo) SetStatus(v string) *DBInstanceStatusInfo {
	s.Status = &v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *DBInstanceStatusInfo) SetStatusType(v string) *DBInstanceStatusInfo {
	s.StatusType = &v
	return s
}

// Detailed information about a subnet group.
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Detailed information about one or more subnets within a subnet group.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the virtual private cloud (VPC) ID of the subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSubnetGroup) GoString() string {
	return s.String()
}

// SetDBSubnetGroupArn sets the DBSubnetGroupArn field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupArn(v string) *DBSubnetGroup {
	s.DBSubnetGroupArn = &v
	return s
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupDescription(v string) *DBSubnetGroup {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupName(v string) *DBSubnetGroup {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *DBSubnetGroup) SetSubnetGroupStatus(v string) *DBSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *DBSubnetGroup) SetSubnets(v []*Subnet) *DBSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSubnetGroup) SetVpcId(v string) *DBSubnetGroup {
	s.VpcId = &v
	return s
}

// Represents the input to DeleteDBCluster.
type DeleteDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster identifier for the cluster to be deleted. This parameter isn't
	// case sensitive.
	//
	// Constraints:
	//
	//    * Must match an existing DBClusterIdentifier.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The cluster snapshot identifier of the new cluster snapshot created when
	// SkipFinalSnapshot is set to false.
	//
	// Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must be from 1 to 255 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final cluster snapshot is created before the cluster
	// is deleted. If true is specified, no cluster snapshot is created. If false
	// is specified, a cluster snapshot is created before the DB cluster is deleted.
	//
	// If SkipFinalSnapshot is false, you must specify a FinalDBSnapshotIdentifier
	// parameter.
	//
	// Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DeleteDBClusterInput) SetDBClusterIdentifier(v string) *DeleteDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBClusterInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBClusterInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBClusterInput) SetSkipFinalSnapshot(v bool) *DeleteDBClusterInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *DeleteDBClusterOutput) SetDBCluster(v *DBCluster) *DeleteDBClusterOutput {
	s.DBCluster = v
	return s
}

// Represents the input to DeleteDBClusterParameterGroup.
type DeleteDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing cluster parameter group.
	//
	//    * You can't delete a default cluster parameter group.
	//
	//    * Cannot be associated with any clusters.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DeleteDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *DeleteDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

type DeleteDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// Represents the input to DeleteDBClusterSnapshot.
type DeleteDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster snapshot to delete.
	//
	// Constraints: Must be the name of an existing cluster snapshot in the available
	// state.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterSnapshotInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DeleteDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *DeleteDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

type DeleteDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster snapshot.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *DeleteDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *DeleteDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Represents the input to DeleteDBInstance.
type DeleteDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance identifier for the instance to be deleted. This parameter isn't
	// case sensitive.
	//
	// Constraints:
	//
	//    * Must match the name of an existing instance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DeleteDBInstanceInput) SetDBInstanceIdentifier(v string) *DeleteDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

type DeleteDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about an instance.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *DeleteDBInstanceOutput) SetDBInstance(v *DBInstance) *DeleteDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Represents the input to DeleteDBSubnetGroup.
type DeleteDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the database subnet group to delete.
	//
	// You can't delete the default subnet group.
	//
	// Constraints:
	//
	// Must match the name of an existing DBSubnetGroup. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DeleteDBSubnetGroupInput) SetDBSubnetGroupName(v string) *DeleteDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

type DeleteDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupOutput) GoString() string {
	return s.String()
}

type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied certificate identifier. If this parameter is specified,
	// information for only the specified certificate is returned. If this parameter
	// is omitted, a list of up to MaxRecords certificates is returned. This parameter
	// is not case sensitive.
	//
	// Constraints
	//
	//    * Must match an existing CertificateIdentifier.
	CertificateIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints:
	//
	//    * Minimum: 20
	//
	//    * Maximum: 100
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *DescribeCertificatesInput) SetCertificateIdentifier(v string) *DescribeCertificatesInput {
	s.CertificateIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeCertificatesInput) SetFilters(v []*Filter) *DescribeCertificatesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesInput) SetMarker(v string) *DescribeCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCertificatesInput) SetMaxRecords(v int64) *DescribeCertificatesInput {
	s.MaxRecords = &v
	return s
}

type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of certificates for this AWS account.
	Certificates []*Certificate `locationNameList:"Certificate" type:"list"`

	// An optional pagination token provided if the number of records retrieved
	// is greater than MaxRecords. If this parameter is specified, the marker specifies
	// the next record in the list. Including the value of Marker in the next call
	// to DescribeCertificates results in the next page of certificates.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *DescribeCertificatesOutput) SetCertificates(v []*Certificate) *DescribeCertificatesOutput {
	s.Certificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesOutput) SetMarker(v string) *DescribeCertificatesOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeDBClusterParameterGroups.
type DescribeDBClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cluster parameter group to return details for.
	//
	// Constraints:
	//
	//    * If provided, must match the name of an existing DBClusterParameterGroup.
	DBClusterParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParameterGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParameterGroupsInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetFilters(v []*Filter) *DescribeDBClusterParameterGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMarker(v string) *DescribeDBClusterParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMaxRecords(v int64) *DescribeDBClusterParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of DBClusterParameterGroups.
type DescribeDBClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of cluster parameter groups.
	DBClusterParameterGroups []*DBClusterParameterGroup `locationNameList:"DBClusterParameterGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroups sets the DBClusterParameterGroups field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetDBClusterParameterGroups(v []*DBClusterParameterGroup) *DescribeDBClusterParameterGroupsOutput {
	s.DBClusterParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetMarker(v string) *DescribeDBClusterParameterGroupsOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeDBClusterParameters.
type DescribeDBClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific cluster parameter group to return parameter details
	// for.
	//
	// Constraints:
	//
	//    * If provided, must match the name of an existing DBClusterParameterGroup.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A value that indicates to return only parameters for a specific source. Parameter
	// sources can be engine, service, or customer.
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParametersInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParametersInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParametersInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParametersInput) SetFilters(v []*Filter) *DescribeDBClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersInput) SetMarker(v string) *DescribeDBClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParametersInput) SetMaxRecords(v int64) *DescribeDBClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDBClusterParametersInput) SetSource(v string) *DescribeDBClusterParametersInput {
	s.Source = &v
	return s
}

// Represents the output of DBClusterParameterGroup.
type DescribeDBClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// Provides a list of parameters for the cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersOutput) SetMarker(v string) *DescribeDBClusterParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBClusterParametersOutput) SetParameters(v []*Parameter) *DescribeDBClusterParametersOutput {
	s.Parameters = v
	return s
}

// Represents the input to DescribeDBClusterSnapshotAttributes.
type DescribeDBClusterSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the cluster snapshot to describe the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotAttributesInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotAttributesInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotAttributesInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

type DescribeDBClusterSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the attributes that are associated with a cluster
	// snapshot.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *DescribeDBClusterSnapshotAttributesOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *DescribeDBClusterSnapshotAttributesOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

// Represents the input to DescribeDBClusterSnapshots.
type DescribeDBClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the cluster to retrieve the list of cluster snapshots for. This
	// parameter can't be used with the DBClusterSnapshotIdentifier parameter. This
	// parameter is not case sensitive.
	//
	// Constraints:
	//
	//    * If provided, must match the identifier of an existing DBCluster.
	DBClusterIdentifier *string `type:"string"`

	// A specific cluster snapshot identifier to describe. This parameter can't
	// be used with the DBClusterIdentifier parameter. This value is stored as a
	// lowercase string.
	//
	// Constraints:
	//
	//    * If provided, must match the identifier of an existing DBClusterSnapshot.
	//
	//    * If this identifier is for an automated snapshot, the SnapshotType parameter
	//    must also be specified.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// Set to true to include manual cluster snapshots that are public and can be
	// copied or restored by any AWS account, and otherwise false. The default is
	// false.
	IncludePublic *bool `type:"boolean"`

	// Set to true to include shared manual cluster snapshots from other AWS accounts
	// that this AWS account has been given permission to copy or restore, and otherwise
	// false. The default is false.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of cluster snapshots to be returned. You can specify one of the
	// following values:
	//
	//    * automated - Return all cluster snapshots that Amazon DocumentDB has
	//    automatically created for your AWS account.
	//
	//    * manual - Return all cluster snapshots that you have manually created
	//    for your AWS account.
	//
	//    * shared - Return all manual cluster snapshots that have been shared to
	//    your AWS account.
	//
	//    * public - Return all cluster snapshots that have been marked as public.
	//
	// If you don't specify a SnapshotType value, then both automated and manual
	// cluster snapshots are returned. You can include shared cluster snapshots
	// with these results by setting the IncludeShared parameter to true. You can
	// include public cluster snapshots with these results by setting the IncludePublic
	// parameter to true.
	//
	// The IncludeShared and IncludePublic parameters don't apply for SnapshotType
	// values of manual or automated. The IncludePublic parameter doesn't apply
	// when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
	// when SnapshotType is set to public.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterSnapshotsInput) SetFilters(v []*Filter) *DescribeDBClusterSnapshotsInput {
	s.Filters = v
	return s
}

// SetIncludePublic sets the IncludePublic field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludePublic(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludePublic = &v
	return s
}

// SetIncludeShared sets the IncludeShared field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludeShared(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludeShared = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMarker(v string) *DescribeDBClusterSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMaxRecords(v int64) *DescribeDBClusterSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeDBClusterSnapshotsInput) SetSnapshotType(v string) *DescribeDBClusterSnapshotsInput {
	s.SnapshotType = &v
	return s
}

// Represents the output of DescribeDBClusterSnapshots.
type DescribeDBClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a list of cluster snapshots.
	DBClusterSnapshots []*DBClusterSnapshot `locationNameList:"DBClusterSnapshot" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshots sets the DBClusterSnapshots field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetDBClusterSnapshots(v []*DBClusterSnapshot) *DescribeDBClusterSnapshotsOutput {
	s.DBClusterSnapshots = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetMarker(v string) *DescribeDBClusterSnapshotsOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeDBClusters.
type DescribeDBClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-provided cluster identifier. If this parameter is specified, information
	// from only the specific cluster is returned. This parameter isn't case sensitive.
	//
	// Constraints:
	//
	//    * If provided, must match an existing DBClusterIdentifier.
	DBClusterIdentifier *string `type:"string"`

	// A filter that specifies one or more clusters to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource
	//    Names (ARNs). The results list only includes information about the clusters
	//    identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClustersInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClustersInput) SetDBClusterIdentifier(v string) *DescribeDBClustersInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClustersInput) SetFilters(v []*Filter) *DescribeDBClustersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClustersInput) SetMarker(v string) *DescribeDBClustersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClustersInput) SetMaxRecords(v int64) *DescribeDBClustersInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of DescribeDBClusters.
type DescribeDBClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of clusters.
	DBClusters []*DBCluster `locationNameList:"DBCluster" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersOutput) GoString() string {
	return s.String()
}

// SetDBClusters sets the DBClusters field's value.
func (s *DescribeDBClustersOutput) SetDBClusters(v []*DBCluster) *DescribeDBClustersOutput {
	s.DBClusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClustersOutput) SetMarker(v string) *DescribeDBClustersOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeDBEngineVersions.
type DescribeDBEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific parameter group family to return details for.
	//
	// Constraints:
	//
	//    * If provided, must match an existing DBParameterGroupFamily.
	DBParameterGroupFamily *string `type:"string"`

	// Indicates that only the default version of the specified engine or engine
	// and major version combination is returned.
	DefaultOnly *bool `type:"boolean"`

	// The database engine to return.
	Engine *string `type:"string"`

	// The database engine version to return.
	//
	// Example: 3.6.0
	EngineVersion *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// If this parameter is specified and the requested engine supports the CharacterSetName
	// parameter for CreateDBInstance, the response includes a list of supported
	// character sets for each engine version.
	ListSupportedCharacterSets *bool `type:"boolean"`

	// If this parameter is specified and the requested engine supports the TimeZone
	// parameter for CreateDBInstance, the response includes a list of supported
	// time zones for each engine version.
	ListSupportedTimezones *bool `type:"boolean"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBEngineVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBEngineVersionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeDBEngineVersionsInput) SetDBParameterGroupFamily(v string) *DescribeDBEngineVersionsInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDefaultOnly sets the DefaultOnly field's value.
func (s *DescribeDBEngineVersionsInput) SetDefaultOnly(v bool) *DescribeDBEngineVersionsInput {
	s.DefaultOnly = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeDBEngineVersionsInput) SetEngine(v string) *DescribeDBEngineVersionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeDBEngineVersionsInput) SetEngineVersion(v string) *DescribeDBEngineVersionsInput {
	s.EngineVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBEngineVersionsInput) SetFilters(v []*Filter) *DescribeDBEngineVersionsInput {
	s.Filters = v
	return s
}

// SetListSupportedCharacterSets sets the ListSupportedCharacterSets field's value.
func (s *DescribeDBEngineVersionsInput) SetListSupportedCharacterSets(v bool) *DescribeDBEngineVersionsInput {
	s.ListSupportedCharacterSets = &v
	return s
}

// SetListSupportedTimezones sets the ListSupportedTimezones field's value.
func (s *DescribeDBEngineVersionsInput) SetListSupportedTimezones(v bool) *DescribeDBEngineVersionsInput {
	s.ListSupportedTimezones = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBEngineVersionsInput) SetMarker(v string) *DescribeDBEngineVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBEngineVersionsInput) SetMaxRecords(v int64) *DescribeDBEngineVersionsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of DescribeDBEngineVersions.
type DescribeDBEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about one or more engine versions.
	DBEngineVersions []*DBEngineVersion `locationNameList:"DBEngineVersion" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetDBEngineVersions sets the DBEngineVersions field's value.
func (s *DescribeDBEngineVersionsOutput) SetDBEngineVersions(v []*DBEngineVersion) *DescribeDBEngineVersionsOutput {
	s.DBEngineVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBEngineVersionsOutput) SetMarker(v string) *DescribeDBEngineVersionsOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeDBInstances.
type DescribeDBInstancesInput struct {
	_ struct{} `type:"structure"`

	// The user-provided instance identifier. If this parameter is specified, information
	// from only the specific instance is returned. This parameter isn't case sensitive.
	//
	// Constraints:
	//
	//    * If provided, must match the identifier of an existing DBInstance.
	DBInstanceIdentifier *string `type:"string"`

	// A filter that specifies one or more instances to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource
	//    Names (ARNs). The results list includes only the information about the
	//    instances that are associated with the clusters that are identified by
	//    these ARNs.
	//
	//    * db-instance-id - Accepts instance identifiers and instance ARNs. The
	//    results list includes only the information about the instances that are
	//    identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DescribeDBInstancesInput) SetDBInstanceIdentifier(v string) *DescribeDBInstancesInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBInstancesInput) SetFilters(v []*Filter) *DescribeDBInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBInstancesInput) SetMarker(v string) *DescribeDBInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBInstancesInput) SetMaxRecords(v int64) *DescribeDBInstancesInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of DescribeDBInstances.
type DescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about one or more instances.
	DBInstances []*DBInstance `locationNameList:"DBInstance" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetDBInstances sets the DBInstances field's value.
func (s *DescribeDBInstancesOutput) SetDBInstances(v []*DBInstance) *DescribeDBInstancesOutput {
	s.DBInstances = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBInstancesOutput) SetMarker(v string) *DescribeDBInstancesOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeDBSubnetGroups.
type DescribeDBSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to return details for.
	DBSubnetGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DescribeDBSubnetGroupsInput) SetDBSubnetGroupName(v string) *DescribeDBSubnetGroupsInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBSubnetGroupsInput) SetFilters(v []*Filter) *DescribeDBSubnetGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSubnetGroupsInput) SetMarker(v string) *DescribeDBSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBSubnetGroupsInput) SetMaxRecords(v int64) *DescribeDBSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

// Represents the output of DescribeDBSubnetGroups.
type DescribeDBSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about one or more subnet groups.
	DBSubnetGroups []*DBSubnetGroup `locationNameList:"DBSubnetGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroups sets the DBSubnetGroups field's value.
func (s *DescribeDBSubnetGroupsOutput) SetDBSubnetGroups(v []*DBSubnetGroup) *DescribeDBSubnetGroupsOutput {
	s.DBSubnetGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSubnetGroupsOutput) SetMarker(v string) *DescribeDBSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeEngineDefaultClusterParameters.
type DescribeEngineDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group family to return the engine parameter
	// information for.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngineDefaultClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngineDefaultClusterParametersInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetDBParameterGroupFamily(v string) *DescribeEngineDefaultClusterParametersInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetFilters(v []*Filter) *DescribeEngineDefaultClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetMarker(v string) *DescribeEngineDefaultClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetMaxRecords(v int64) *DescribeEngineDefaultClusterParametersInput {
	s.MaxRecords = &v
	return s
}

type DescribeEngineDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultClusterParameters
	// operation.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

// SetEngineDefaults sets the EngineDefaults field's value.
func (s *DescribeEngineDefaultClusterParametersOutput) SetEngineDefaults(v *EngineDefaults) *DescribeEngineDefaultClusterParametersOutput {
	s.EngineDefaults = v
	return s
}

// Represents the input to DescribeEventCategories.
type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The type of source that is generating the events.
	//
	// Valid values: db-instance, db-parameter-group, db-security-group, db-snapshot
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventCategoriesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventCategoriesInput) SetFilters(v []*Filter) *DescribeEventCategoriesInput {
	s.Filters = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

// Represents the output of DescribeEventCategories.
type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event category maps.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoriesMapList sets the EventCategoriesMapList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoriesMapList(v []*EventCategoriesMap) *DescribeEventCategoriesOutput {
	s.EventCategoriesMapList = v
	return s
}

// Represents the input to DescribeEvents.
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes to retrieve events for.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format.
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp"`

	// A list of event categories that trigger notifications for an event notification
	// subscription.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events are returned. If not
	// specified, then all sources are included in the response.
	//
	// Constraints:
	//
	//    * If SourceIdentifier is provided, SourceType must also be provided.
	//
	//    * If the source type is DBInstance, a DBInstanceIdentifier must be provided.
	//
	//    * If the source type is DBSecurityGroup, a DBSecurityGroupName must be
	//    provided.
	//
	//    * If the source type is DBParameterGroup, a DBParameterGroupName must
	//    be provided.
	//
	//    * If the source type is DBSnapshot, a DBSnapshotIdentifier must be provided.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format.
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *DescribeEventsInput) SetEventCategories(v []*string) *DescribeEventsInput {
	s.EventCategories = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventsInput) SetFilters(v []*Filter) *DescribeEventsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

// Represents the output of DescribeEvents.
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about one or more events.
	Events []*Event `locationNameList:"Event" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

// Represents the input to DescribeOrderableDBInstanceOptions.
type DescribeOrderableDBInstanceOptionsInput struct {
	_ struct{} `type:"structure"`

	// The instance class filter value. Specify this parameter to show only the
	// available offerings that match the specified instance class.
	DBInstanceClass *string `type:"string"`

	// The name of the engine to retrieve instance options for.
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The engine version filter value. Specify this parameter to show only the
	// available offerings that match the specified engine version.
	EngineVersion *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The license model filter value. Specify this parameter to show only the available
	// offerings that match the specified license model.
	LicenseModel *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The virtual private cloud (VPC) filter value. Specify this parameter to show
	// only the available VPC or non-VPC offerings.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrderableDBInstanceOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrderableDBInstanceOptionsInput"}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetDBInstanceClass(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.DBInstanceClass = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetEngine(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetEngineVersion(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.EngineVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetFilters(v []*Filter) *DescribeOrderableDBInstanceOptionsInput {
	s.Filters = v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetLicenseModel(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.LicenseModel = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetMarker(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetMaxRecords(v int64) *DescribeOrderableDBInstanceOptionsInput {
	s.MaxRecords = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetVpc(v bool) *DescribeOrderableDBInstanceOptionsInput {
	s.Vpc = &v
	return s
}

// Represents the output of DescribeOrderableDBInstanceOptions.
type DescribeOrderableDBInstanceOptionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The options that are available for a particular orderable instance.
	OrderableDBInstanceOptions []*OrderableDBInstanceOption `locationNameList:"OrderableDBInstanceOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableDBInstanceOptionsOutput) SetMarker(v string) *DescribeOrderableDBInstanceOptionsOutput {
	s.Marker = &v
	return s
}

// SetOrderableDBInstanceOptions sets the OrderableDBInstanceOptions field's value.
func (s *DescribeOrderableDBInstanceOptionsOutput) SetOrderableDBInstanceOptions(v []*OrderableDBInstanceOption) *DescribeOrderableDBInstanceOptionsOutput {
	s.OrderableDBInstanceOptions = v
	return s
}

// Represents the input to DescribePendingMaintenanceActions.
type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	// A filter that specifies one or more resources to return pending maintenance
	// actions for.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource
	//    Names (ARNs). The results list includes only pending maintenance actions
	//    for the clusters identified by these ARNs.
	//
	//    * db-instance-id - Accepts instance identifiers and instance ARNs. The
	//    results list includes only pending maintenance actions for the DB instances
	//    identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token (marker) is
	// included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The ARN of a resource to return pending maintenance actions for.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePendingMaintenanceActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePendingMaintenanceActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePendingMaintenanceActionsInput) SetFilters(v []*Filter) *DescribePendingMaintenanceActionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMarker(v string) *DescribePendingMaintenanceActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMaxRecords(v int64) *DescribePendingMaintenanceActionsInput {
	s.MaxRecords = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *DescribePendingMaintenanceActionsInput) SetResourceIdentifier(v string) *DescribePendingMaintenanceActionsInput {
	s.ResourceIdentifier = &v
	return s
}

// Represents the output of DescribePendingMaintenanceActions.
type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maintenance actions to be applied.
	PendingMaintenanceActions []*ResourcePendingMaintenanceActions `locationNameList:"ResourcePendingMaintenanceActions" type:"list"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetMarker(v string) *DescribePendingMaintenanceActionsOutput {
	s.Marker = &v
	return s
}

// SetPendingMaintenanceActions sets the PendingMaintenanceActions field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetPendingMaintenanceActions(v []*ResourcePendingMaintenanceActions) *DescribePendingMaintenanceActionsOutput {
	s.PendingMaintenanceActions = v
	return s
}

// Network information for accessing a cluster or instance. Client programs
// must specify a valid endpoint to access these Amazon DocumentDB resources.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *Endpoint) SetHostedZoneId(v string) *Endpoint {
	s.HostedZoneId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Contains the result of a successful invocation of the DescribeEngineDefaultClusterParameters
// operation.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group family to return the engine parameter
	// information for.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The parameters of a particular cluster parameter group family.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineDefaults) GoString() string {
	return s.String()
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *EngineDefaults) SetDBParameterGroupFamily(v string) *EngineDefaults {
	s.DBParameterGroupFamily = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *EngineDefaults) SetMarker(v string) *EngineDefaults {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *EngineDefaults) SetParameters(v []*Parameter) *EngineDefaults {
	s.Parameters = v
	return s
}

// Detailed information about an event.
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp"`

	// Specifies the category for the event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Event) SetSourceArn(v string) *Event {
	s.SourceArn = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// An event source type, accompanied by one or more event category names.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventCategoriesMap) SetEventCategories(v []*string) *EventCategoriesMap {
	s.EventCategories = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoriesMap) SetSourceType(v string) *EventCategoriesMap {
	s.SourceType = &v
	return s
}

// Represents the input to FailoverDBCluster.
type FailoverDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A cluster identifier to force a failover for. This parameter is not case
	// sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	DBClusterIdentifier *string `type:"string"`

	// The name of the instance to promote to the primary instance.
	//
	// You must specify the instance identifier for an Amazon DocumentDB replica
	// in the cluster. For example, mydbcluster-replica1.
	TargetDBInstanceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s FailoverDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterInput) GoString() string {
	return s.String()
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *FailoverDBClusterInput) SetDBClusterIdentifier(v string) *FailoverDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetTargetDBInstanceIdentifier sets the TargetDBInstanceIdentifier field's value.
func (s *FailoverDBClusterInput) SetTargetDBInstanceIdentifier(v string) *FailoverDBClusterInput {
	s.TargetDBInstanceIdentifier = &v
	return s
}

type FailoverDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s FailoverDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *FailoverDBClusterOutput) SetDBCluster(v *DBCluster) *FailoverDBClusterOutput {
	s.DBCluster = v
	return s
}

// A named set of filter values, used to return a more specific list of results.
// You can use a filter to match a set of resources by specific criteria, such
// as IDs.
//
// Wildcards are not supported in filters.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// One or more filter values. Filter values are case sensitive.
	//
	// Values is a required field
	Values []*string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Represents the input to ListTagsForResource.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The Amazon DocumentDB resource with tags to be listed. This value is an Amazon
	// Resource Name (ARN).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListTagsForResourceInput) SetFilters(v []*Filter) *ListTagsForResourceInput {
	s.Filters = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListTagsForResourceInput) SetResourceName(v string) *ListTagsForResourceInput {
	s.ResourceName = &v
	return s
}

// Represents the output of ListTagsForResource.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of one or more tags.
	TagList []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// Represents the input to ModifyDBCluster.
type ModifyDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A value that specifies whether the changes in this request and any pending
	// changes are asynchronously applied as soon as possible, regardless of the
	// PreferredMaintenanceWindow setting for the cluster. If this parameter is
	// set to false, changes to the cluster are applied during the next maintenance
	// window.
	//
	// The ApplyImmediately parameter affects only the NewDBClusterIdentifier and
	// MasterUserPassword values. If you set this parameter value to false, the
	// changes to the NewDBClusterIdentifier and MasterUserPassword values are applied
	// during the next maintenance window. All other changes are applied immediately,
	// regardless of the value of the ApplyImmediately parameter.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The configuration setting for the log types to be enabled for export to Amazon
	// CloudWatch Logs for a specific instance or cluster. The EnableLogTypes and
	// DisableLogTypes arrays determine which logs are exported (or not exported)
	// to CloudWatch Logs.
	CloudwatchLogsExportConfiguration *CloudwatchLogsExportConfiguration `type:"structure"`

	// The cluster identifier for the cluster that is being modified. This parameter
	// is not case sensitive.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the cluster parameter group to use for the cluster.
	DBClusterParameterGroupName *string `type:"string"`

	// Specifies whether this cluster can be deleted. If DeletionProtection is enabled,
	// the cluster cannot be deleted unless it is modified and DeletionProtection
	// is disabled. DeletionProtection protects clusters from being accidentally
	// deleted.
	DeletionProtection *bool `type:"boolean"`

	// The version number of the database engine to which you want to upgrade. Changing
	// this parameter results in an outage. The change is applied during the next
	// maintenance window unless the ApplyImmediately parameter is set to true.
	EngineVersion *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except forward slash (/), double quote ("), or
	// the "at" symbol (@).
	//
	// Constraints: Must contain from 8 to 100 characters.
	MasterUserPassword *string `type:"string"`

	// The new cluster identifier for the cluster when renaming a cluster. This
	// value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster2
	NewDBClusterIdentifier *string `type:"string"`

	// The port number on which the cluster accepts connections.
	//
	// Constraints: Must be a value from 1150 to 65535.
	//
	// Default: The same port as the original cluster.
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Must be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A list of virtual private cloud (VPC) security groups that the cluster will
	// belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyDBClusterInput) SetApplyImmediately(v bool) *ModifyDBClusterInput {
	s.ApplyImmediately = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *ModifyDBClusterInput) SetBackupRetentionPeriod(v int64) *ModifyDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCloudwatchLogsExportConfiguration sets the CloudwatchLogsExportConfiguration field's value.
func (s *ModifyDBClusterInput) SetCloudwatchLogsExportConfiguration(v *CloudwatchLogsExportConfiguration) *ModifyDBClusterInput {
	s.CloudwatchLogsExportConfiguration = v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *ModifyDBClusterInput) SetDBClusterIdentifier(v string) *ModifyDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterInput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *ModifyDBClusterInput) SetDeletionProtection(v bool) *ModifyDBClusterInput {
	s.DeletionProtection = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyDBClusterInput) SetEngineVersion(v string) *ModifyDBClusterInput {
	s.EngineVersion = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyDBClusterInput) SetMasterUserPassword(v string) *ModifyDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetNewDBClusterIdentifier sets the NewDBClusterIdentifier field's value.
func (s *ModifyDBClusterInput) SetNewDBClusterIdentifier(v string) *ModifyDBClusterInput {
	s.NewDBClusterIdentifier = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ModifyDBClusterInput) SetPort(v int64) *ModifyDBClusterInput {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *ModifyDBClusterInput) SetPreferredBackupWindow(v string) *ModifyDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyDBClusterInput) SetPreferredMaintenanceWindow(v string) *ModifyDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyDBClusterInput) SetVpcSecurityGroupIds(v []*string) *ModifyDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type ModifyDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *ModifyDBClusterOutput) SetDBCluster(v *DBCluster) *ModifyDBClusterOutput {
	s.DBCluster = v
	return s
}

// Represents the input to ModifyDBClusterParameterGroup.
type ModifyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group to modify.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameters in the cluster parameter group to modify.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyDBClusterParameterGroupInput) SetParameters(v []*Parameter) *ModifyDBClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// Contains the name of a cluster parameter group.
type ModifyDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of a cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be from 1 to 255 letters or numbers.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// This value is stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ModifyDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterParameterGroupOutput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterParameterGroupOutput {
	s.DBClusterParameterGroupName = &v
	return s
}

// Represents the input to ModifyDBClusterSnapshotAttribute.
type ModifyDBClusterSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster snapshot attribute to modify.
	//
	// To manage authorization for other AWS accounts to copy or restore a manual
	// cluster snapshot, set this value to restore.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The identifier for the cluster snapshot to modify the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of cluster snapshot attributes to add to the attribute specified by
	// AttributeName.
	//
	// To authorize other AWS accounts to copy or restore a manual cluster snapshot,
	// set this list to include one or more AWS account IDs. To make the manual
	// cluster snapshot restorable by any AWS account, set it to all. Do not add
	// the all value for any manual cluster snapshots that contain private information
	// that you don't want to be available to all AWS accounts.
	ValuesToAdd []*string `locationNameList:"AttributeValue" type:"list"`

	// A list of cluster snapshot attributes to remove from the attribute specified
	// by AttributeName.
	//
	// To remove authorization for other AWS accounts to copy or restore a manual
	// cluster snapshot, set this list to include one or more AWS account identifiers.
	// To remove authorization for any AWS account to copy or restore the cluster
	// snapshot, set it to all . If you specify all, an AWS account whose account
	// ID is explicitly added to the restore attribute can still copy or restore
	// a manual cluster snapshot.
	ValuesToRemove []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterSnapshotAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterSnapshotAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterSnapshotAttributeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetAttributeName(v string) *ModifyDBClusterSnapshotAttributeInput {
	s.AttributeName = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetDBClusterSnapshotIdentifier(v string) *ModifyDBClusterSnapshotAttributeInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetValuesToAdd sets the ValuesToAdd field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetValuesToAdd(v []*string) *ModifyDBClusterSnapshotAttributeInput {
	s.ValuesToAdd = v
	return s
}

// SetValuesToRemove sets the ValuesToRemove field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetValuesToRemove(v []*string) *ModifyDBClusterSnapshotAttributeInput {
	s.ValuesToRemove = v
	return s
}

type ModifyDBClusterSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the attributes that are associated with a cluster
	// snapshot.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterSnapshotAttributeOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *ModifyDBClusterSnapshotAttributeOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *ModifyDBClusterSnapshotAttributeOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

// Represents the input to ModifyDBInstance.
type ModifyDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the modifications in this request and any pending modifications
	// are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow
	// setting for the instance.
	//
	// If this parameter is set to false, changes to the instance are applied during
	// the next maintenance window. Some parameter changes can cause an outage and
	// are applied on the next reboot.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// Indicates that minor version upgrades are applied automatically to the instance
	// during the maintenance window. Changing this parameter doesn't result in
	// an outage except in the following case, and the change is asynchronously
	// applied as soon as possible. An outage results if this parameter is set to
	// true during the maintenance window, and a newer minor version is available,
	// and Amazon DocumentDB has enabled automatic patching for that engine version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Indicates the certificate that needs to be associated with the instance.
	CACertificateIdentifier *string `type:"string"`

	// The new compute and memory capacity of the instance; for example, db.r5.large.
	// Not all instance classes are available in all AWS Regions.
	//
	// If you modify the instance class, an outage occurs during the change. The
	// change is applied during the next maintenance window, unless ApplyImmediately
	// is specified as true for this request.
	//
	// Default: Uses existing setting.
	DBInstanceClass *string `type:"string"`

	// The instance identifier. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBInstance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The new instance identifier for the instance when renaming an instance. When
	// you change the instance identifier, an instance reboot occurs immediately
	// if you set Apply Immediately to true. It occurs during the next maintenance
	// window if you set Apply Immediately to false. This value is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	NewDBInstanceIdentifier *string `type:"string"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter doesn't result in
	// an outage except in the following situation, and the change is asynchronously
	// applied as soon as possible. If there are pending actions that cause a reboot,
	// and the maintenance window is changed to include the current time, changing
	// this parameter causes a reboot of the instance. If you are moving this window
	// to the current time, there must be at least 30 minutes between the current
	// time and end of the window to ensure that pending changes are applied.
	//
	// Default: Uses existing setting.
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Must be at least 30 minutes.
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	//
	// Default: 1
	//
	// Valid values: 0-15
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s ModifyDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyDBInstanceInput) SetApplyImmediately(v bool) *ModifyDBInstanceInput {
	s.ApplyImmediately = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *ModifyDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *ModifyDBInstanceInput) SetCACertificateIdentifier(v string) *ModifyDBInstanceInput {
	s.CACertificateIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *ModifyDBInstanceInput) SetDBInstanceClass(v string) *ModifyDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *ModifyDBInstanceInput) SetDBInstanceIdentifier(v string) *ModifyDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetNewDBInstanceIdentifier sets the NewDBInstanceIdentifier field's value.
func (s *ModifyDBInstanceInput) SetNewDBInstanceIdentifier(v string) *ModifyDBInstanceInput {
	s.NewDBInstanceIdentifier = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyDBInstanceInput) SetPreferredMaintenanceWindow(v string) *ModifyDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *ModifyDBInstanceInput) SetPromotionTier(v int64) *ModifyDBInstanceInput {
	s.PromotionTier = &v
	return s
}

type ModifyDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about an instance.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *ModifyDBInstanceOutput) SetDBInstance(v *DBInstance) *ModifyDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Represents the input to ModifyDBSubnetGroup.
type ModifyDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name for the subnet group. This value is stored as a lowercase string.
	// You can't modify the default subnet group.
	//
	// Constraints: Must match the name of an existing DBSubnetGroup. Must not be
	// default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The Amazon EC2 subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *ModifyDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *ModifyDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *ModifyDBSubnetGroupInput) SetDBSubnetGroupName(v string) *ModifyDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyDBSubnetGroupInput) SetSubnetIds(v []*string) *ModifyDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type ModifyDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *ModifyDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *ModifyDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

// The options that are available for an instance.
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for an instance.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The instance class for an instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of an instance.
	Engine *string `type:"string"`

	// The engine version of an instance.
	EngineVersion *string `type:"string"`

	// The license model for an instance.
	LicenseModel *string `type:"string"`

	// Indicates whether an instance is in a virtual private cloud (VPC).
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableDBInstanceOption) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *OrderableDBInstanceOption) SetAvailabilityZones(v []*AvailabilityZone) *OrderableDBInstanceOption {
	s.AvailabilityZones = v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *OrderableDBInstanceOption) SetDBInstanceClass(v string) *OrderableDBInstanceOption {
	s.DBInstanceClass = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *OrderableDBInstanceOption) SetEngine(v string) *OrderableDBInstanceOption {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *OrderableDBInstanceOption) SetEngineVersion(v string) *OrderableDBInstanceOption {
	s.EngineVersion = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *OrderableDBInstanceOption) SetLicenseModel(v string) *OrderableDBInstanceOption {
	s.LicenseModel = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *OrderableDBInstanceOption) SetVpc(v bool) *OrderableDBInstanceOption {
	s.Vpc = &v
	return s
}

// Detailed information about an individual parameter.
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod *string `type:"string" enum:"ApplyMethod"`

	// Specifies the engine-specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetApplyMethod sets the ApplyMethod field's value.
func (s *Parameter) SetApplyMethod(v string) *Parameter {
	s.ApplyMethod = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *Parameter) SetApplyType(v string) *Parameter {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v bool) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// A list of the log types whose configuration is still pending. These log types
// are in the process of being activated or deactivated.
type PendingCloudwatchLogsExports struct {
	_ struct{} `type:"structure"`

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to Amazon CloudWatch Logs.
	LogTypesToDisable []*string `type:"list"`

	// Log types that are in the process of being deactivated. After they are deactivated,
	// these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []*string `type:"list"`
}

// String returns the string representation
func (s PendingCloudwatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingCloudwatchLogsExports) GoString() string {
	return s.String()
}

// SetLogTypesToDisable sets the LogTypesToDisable field's value.
func (s *PendingCloudwatchLogsExports) SetLogTypesToDisable(v []*string) *PendingCloudwatchLogsExports {
	s.LogTypesToDisable = v
	return s
}

// SetLogTypesToEnable sets the LogTypesToEnable field's value.
func (s *PendingCloudwatchLogsExports) SetLogTypesToEnable(v []*string) *PendingCloudwatchLogsExports {
	s.LogTypesToEnable = v
	return s
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after
	// this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp"`

	// The effective date when the pending maintenance action is applied to the
	// resource.
	CurrentApplyDate *time.Time `type:"timestamp"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action is automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingMaintenanceAction) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PendingMaintenanceAction) SetAction(v string) *PendingMaintenanceAction {
	s.Action = &v
	return s
}

// SetAutoAppliedAfterDate sets the AutoAppliedAfterDate field's value.
func (s *PendingMaintenanceAction) SetAutoAppliedAfterDate(v time.Time) *PendingMaintenanceAction {
	s.AutoAppliedAfterDate = &v
	return s
}

// SetCurrentApplyDate sets the CurrentApplyDate field's value.
func (s *PendingMaintenanceAction) SetCurrentApplyDate(v time.Time) *PendingMaintenanceAction {
	s.CurrentApplyDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PendingMaintenanceAction) SetDescription(v string) *PendingMaintenanceAction {
	s.Description = &v
	return s
}

// SetForcedApplyDate sets the ForcedApplyDate field's value.
func (s *PendingMaintenanceAction) SetForcedApplyDate(v time.Time) *PendingMaintenanceAction {
	s.ForcedApplyDate = &v
	return s
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *PendingMaintenanceAction) SetOptInStatus(v string) *PendingMaintenanceAction {
	s.OptInStatus = &v
	return s
}

// One or more modified settings for an instance. These modified settings have
// been requested, but haven't been applied yet.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for then instance that will be applied
	// or is currently being applied.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the certificate authority (CA) certificate for
	// the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the instance that will be applied or
	// is currently being applied.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the instance that will be applied
	// or is currently being applied.
	DBInstanceIdentifier *string `type:"string"`

	// The new subnet group for the instance.
	DBSubnetGroupName *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the instance that will be applied
	// or is currently being applied.
	Iops *int64 `type:"integer"`

	// The license model for the instance.
	//
	// Valid values: license-included, bring-your-own-license, general-public-license
	LicenseModel *string `type:"string"`

	// Contains the pending or currently in-progress change of the master credentials
	// for the instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// A list of the log types whose configuration is still pending. These log types
	// are in the process of being activated or deactivated.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports `type:"structure"`

	// Specifies the pending port for the instance.
	Port *int64 `type:"integer"`

	// Specifies the storage type to be associated with the instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *PendingModifiedValues) SetAllocatedStorage(v int64) *PendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *PendingModifiedValues) SetBackupRetentionPeriod(v int64) *PendingModifiedValues {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *PendingModifiedValues) SetCACertificateIdentifier(v string) *PendingModifiedValues {
	s.CACertificateIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *PendingModifiedValues) SetDBInstanceClass(v string) *PendingModifiedValues {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *PendingModifiedValues) SetDBInstanceIdentifier(v string) *PendingModifiedValues {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *PendingModifiedValues) SetDBSubnetGroupName(v string) *PendingModifiedValues {
	s.DBSubnetGroupName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PendingModifiedValues) SetEngineVersion(v string) *PendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *PendingModifiedValues) SetIops(v int64) *PendingModifiedValues {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *PendingModifiedValues) SetLicenseModel(v string) *PendingModifiedValues {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *PendingModifiedValues) SetMasterUserPassword(v string) *PendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *PendingModifiedValues) SetMultiAZ(v bool) *PendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetPendingCloudwatchLogsExports sets the PendingCloudwatchLogsExports field's value.
func (s *PendingModifiedValues) SetPendingCloudwatchLogsExports(v *PendingCloudwatchLogsExports) *PendingModifiedValues {
	s.PendingCloudwatchLogsExports = v
	return s
}

// SetPort sets the Port field's value.
func (s *PendingModifiedValues) SetPort(v int64) *PendingModifiedValues {
	s.Port = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *PendingModifiedValues) SetStorageType(v string) *PendingModifiedValues {
	s.StorageType = &v
	return s
}

// Represents the input to RebootDBInstance.
type RebootDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBInstance.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// When true, the reboot is conducted through a Multi-AZ failover.
	//
	// Constraint: You can't specify true if the instance is not configured for
	// Multi-AZ.
	ForceFailover *bool `type:"boolean"`
}

// String returns the string representation
func (s RebootDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *RebootDBInstanceInput) SetDBInstanceIdentifier(v string) *RebootDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetForceFailover sets the ForceFailover field's value.
func (s *RebootDBInstanceInput) SetForceFailover(v bool) *RebootDBInstanceInput {
	s.ForceFailover = &v
	return s
}

type RebootDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about an instance.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RebootDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *RebootDBInstanceOutput) SetDBInstance(v *DBInstance) *RebootDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Represents the input to RemoveTagsFromResource.
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon DocumentDB resource that the tags are removed from. This value
	// is an Amazon Resource Name (ARN).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *RemoveTagsFromResourceInput) SetResourceName(v string) *RemoveTagsFromResourceInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// Represents the input to ResetDBClusterParameterGroup.
type ResetDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster parameter group to reset.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameter names in the cluster parameter group to reset to the
	// default values. You can't use this parameter if the ResetAllParameters parameter
	// is set to true.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// A value that is set to true to reset all parameters in the cluster parameter
	// group to their default values, and false otherwise. You can't use this parameter
	// if there is a list of parameter names specified for the Parameters parameter.
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ResetDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *ResetDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetDBClusterParameterGroupInput) SetParameters(v []*Parameter) *ResetDBClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetDBClusterParameterGroupInput) SetResetAllParameters(v bool) *ResetDBClusterParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

// Contains the name of a cluster parameter group.
type ResetDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of a cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be from 1 to 255 letters or numbers.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// This value is stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ResetDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ResetDBClusterParameterGroupOutput) SetDBClusterParameterGroupName(v string) *ResetDBClusterParameterGroupOutput {
	s.DBClusterParameterGroupName = &v
	return s
}

// Represents the output of ApplyPendingMaintenanceAction.
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []*PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The Amazon Resource Name (ARN) of the resource that has pending maintenance
	// actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePendingMaintenanceActions) GoString() string {
	return s.String()
}

// SetPendingMaintenanceActionDetails sets the PendingMaintenanceActionDetails field's value.
func (s *ResourcePendingMaintenanceActions) SetPendingMaintenanceActionDetails(v []*PendingMaintenanceAction) *ResourcePendingMaintenanceActions {
	s.PendingMaintenanceActionDetails = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourcePendingMaintenanceActions) SetResourceIdentifier(v string) *ResourcePendingMaintenanceActions {
	s.ResourceIdentifier = &v
	return s
}

// Represents the input to RestoreDBClusterFromSnapshot.
type RestoreDBClusterFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Provides the list of Amazon EC2 Availability Zones that instances in the
	// restored DB cluster can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The name of the cluster to create from the snapshot or cluster snapshot.
	// This parameter isn't case sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-snapshot-id
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the subnet group to use for the new cluster.
	//
	// Constraints: If provided, must match the name of an existing DBSubnetGroup.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// Specifies whether this cluster can be deleted. If DeletionProtection is enabled,
	// the cluster cannot be deleted unless it is modified and DeletionProtection
	// is disabled. DeletionProtection protects clusters from being accidentally
	// deleted.
	DeletionProtection *bool `type:"boolean"`

	// A list of log types that must be enabled for exporting to Amazon CloudWatch
	// Logs.
	EnableCloudwatchLogsExports []*string `type:"list"`

	// The database engine to use for the new cluster.
	//
	// Default: The same as source.
	//
	// Constraint: Must be compatible with the engine of the source.
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version of the database engine to use for the new cluster.
	EngineVersion *string `type:"string"`

	// The AWS KMS key identifier to use when restoring an encrypted cluster from
	// a DB snapshot or cluster snapshot.
	//
	// The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
	// KMS encryption key. If you are restoring a cluster with the same AWS account
	// that owns the AWS KMS encryption key used to encrypt the new cluster, then
	// you can use the AWS KMS key alias instead of the ARN for the AWS KMS encryption
	// key.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// occurs:
	//
	//    * If the snapshot or cluster snapshot in SnapshotIdentifier is encrypted,
	//    then the restored cluster is encrypted using the AWS KMS key that was
	//    used to encrypt the snapshot or the cluster snapshot.
	//
	//    * If the snapshot or the cluster snapshot in SnapshotIdentifier is not
	//    encrypted, then the restored DB cluster is not encrypted.
	KmsKeyId *string `type:"string"`

	// The port number on which the new cluster accepts connections.
	//
	// Constraints: Must be a value from 1150 to 65535.
	//
	// Default: The same port as the original cluster.
	Port *int64 `type:"integer"`

	// The identifier for the snapshot or cluster snapshot to restore from.
	//
	// You can use either the name or the Amazon Resource Name (ARN) to specify
	// a cluster snapshot. However, you can use only the ARN to specify a snapshot.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing snapshot.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the restored cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of virtual private cloud (VPC) security groups that the new cluster
	// will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterFromSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetAvailabilityZones(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.AvailabilityZones = v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBClusterIdentifier(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBSubnetGroupName(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDeletionProtection(v bool) *RestoreDBClusterFromSnapshotInput {
	s.DeletionProtection = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEnableCloudwatchLogsExports(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEngine(v string) *RestoreDBClusterFromSnapshotInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEngineVersion(v string) *RestoreDBClusterFromSnapshotInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetKmsKeyId(v string) *RestoreDBClusterFromSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetPort(v int64) *RestoreDBClusterFromSnapshotInput {
	s.Port = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetSnapshotIdentifier(v string) *RestoreDBClusterFromSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetTags(v []*Tag) *RestoreDBClusterFromSnapshotInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.VpcSecurityGroupIds = v
	return s
}

type RestoreDBClusterFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterFromSnapshotOutput) SetDBCluster(v *DBCluster) *RestoreDBClusterFromSnapshotOutput {
	s.DBCluster = v
	return s
}

// Represents the input to RestoreDBClusterToPointInTime.
type RestoreDBClusterToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// The name of the new cluster to be created.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The subnet group name to use for the new cluster.
	//
	// Constraints: If provided, must match the name of an existing DBSubnetGroup.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// Specifies whether this cluster can be deleted. If DeletionProtection is enabled,
	// the cluster cannot be deleted unless it is modified and DeletionProtection
	// is disabled. DeletionProtection protects clusters from being accidentally
	// deleted.
	DeletionProtection *bool `type:"boolean"`

	// A list of log types that must be enabled for exporting to Amazon CloudWatch
	// Logs.
	EnableCloudwatchLogsExports []*string `type:"list"`

	// The AWS KMS key identifier to use when restoring an encrypted cluster from
	// an encrypted cluster.
	//
	// The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
	// KMS encryption key. If you are restoring a cluster with the same AWS account
	// that owns the AWS KMS encryption key used to encrypt the new cluster, then
	// you can use the AWS KMS key alias instead of the ARN for the AWS KMS encryption
	// key.
	//
	// You can restore to a new cluster and encrypt the new cluster with an AWS
	// KMS key that is different from the AWS KMS key used to encrypt the source
	// cluster. The new DB cluster is encrypted with the AWS KMS key identified
	// by the KmsKeyId parameter.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// occurs:
	//
	//    * If the cluster is encrypted, then the restored cluster is encrypted
	//    using the AWS KMS key that was used to encrypt the source cluster.
	//
	//    * If the cluster is not encrypted, then the restored cluster is not encrypted.
	//
	// If DBClusterIdentifier refers to a cluster that is not encrypted, then the
	// restore request is rejected.
	KmsKeyId *string `type:"string"`

	// The port number on which the new cluster accepts connections.
	//
	// Constraints: Must be a value from 1150 to 65535.
	//
	// Default: The default port for the engine.
	Port *int64 `type:"integer"`

	// The date and time to restore the cluster to.
	//
	// Valid values: A time in Universal Coordinated Time (UTC) format.
	//
	// Constraints:
	//
	//    * Must be before the latest restorable time for the instance.
	//
	//    * Must be specified if the UseLatestRestorableTime parameter is not provided.
	//
	//    * Cannot be specified if the UseLatestRestorableTime parameter is true.
	//
	//    * Cannot be specified if the RestoreType parameter is copy-on-write.
	//
	// Example: 2015-03-07T23:45:00Z
	RestoreToTime *time.Time `type:"timestamp"`

	// The identifier of the source cluster from which to restore.
	//
	// Constraints:
	//
	//    * Must match the identifier of an existing DBCluster.
	//
	// SourceDBClusterIdentifier is a required field
	SourceDBClusterIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the restored cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A value that is set to true to restore the cluster to the latest restorable
	// backup time, and false otherwise.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if the RestoreToTime parameter is provided.
	UseLatestRestorableTime *bool `type:"boolean"`

	// A list of VPC security groups that the new cluster belongs to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterToPointInTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterToPointInTimeInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.SourceDBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBClusterIdentifier(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBSubnetGroupName(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDeletionProtection(v bool) *RestoreDBClusterToPointInTimeInput {
	s.DeletionProtection = &v
	return s
}

// SetEnableCloudwatchLogsExports sets the EnableCloudwatchLogsExports field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetEnableCloudwatchLogsExports(v []*string) *RestoreDBClusterToPointInTimeInput {
	s.EnableCloudwatchLogsExports = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetKmsKeyId(v string) *RestoreDBClusterToPointInTimeInput {
	s.KmsKeyId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetPort(v int64) *RestoreDBClusterToPointInTimeInput {
	s.Port = &v
	return s
}

// SetRestoreToTime sets the RestoreToTime field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetRestoreToTime(v time.Time) *RestoreDBClusterToPointInTimeInput {
	s.RestoreToTime = &v
	return s
}

// SetSourceDBClusterIdentifier sets the SourceDBClusterIdentifier field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetSourceDBClusterIdentifier(v string) *RestoreDBClusterToPointInTimeInput {
	s.SourceDBClusterIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetTags(v []*Tag) *RestoreDBClusterToPointInTimeInput {
	s.Tags = v
	return s
}

// SetUseLatestRestorableTime sets the UseLatestRestorableTime field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetUseLatestRestorableTime(v bool) *RestoreDBClusterToPointInTimeInput {
	s.UseLatestRestorableTime = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterToPointInTimeInput {
	s.VpcSecurityGroupIds = v
	return s
}

type RestoreDBClusterToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterToPointInTimeOutput) SetDBCluster(v *DBCluster) *RestoreDBClusterToPointInTimeOutput {
	s.DBCluster = v
	return s
}

type StartDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to restart. Example: docdb-2019-05-28-15-24-52
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *StartDBClusterInput) SetDBClusterIdentifier(v string) *StartDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

type StartDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s StartDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *StartDBClusterOutput) SetDBCluster(v *DBCluster) *StartDBClusterOutput {
	s.DBCluster = v
	return s
}

type StopDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster to stop. Example: docdb-2019-05-28-15-24-52
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *StopDBClusterInput) SetDBClusterIdentifier(v string) *StopDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

type StopDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a cluster.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s StopDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *StopDBClusterOutput) SetDBCluster(v *DBCluster) *StopDBClusterOutput {
	s.DBCluster = v
	return s
}

// Detailed information about a subnet.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Specifies the Availability Zone for the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// Specifies the status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *Subnet) SetSubnetStatus(v string) *Subnet {
	s.SubnetStatus = &v
	return s
}

// Metadata assigned to an Amazon DocumentDB resource consisting of a key-value
// pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The required name of the tag. The string value can be from 1 to 128 Unicode
	// characters in length and can't be prefixed with "aws:" or "rds:". The string
	// can contain only the set of Unicode letters, digits, white space, '_', '.',
	// '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// The optional value of the tag. The string value can be from 1 to 256 Unicode
	// characters in length and can't be prefixed with "aws:" or "rds:". The string
	// can contain only the set of Unicode letters, digits, white space, '_', '.',
	// '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The version of the database engine that an instance can be upgraded to.
type UpgradeTarget struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the target version is applied to any source
	// DB instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool `type:"boolean"`

	// The version of the database engine that an instance can be upgraded to.
	Description *string `type:"string"`

	// The name of the upgrade target database engine.
	Engine *string `type:"string"`

	// The version number of the upgrade target database engine.
	EngineVersion *string `type:"string"`

	// A value that indicates whether a database engine is upgraded to a major version.
	IsMajorVersionUpgrade *bool `type:"boolean"`
}

// String returns the string representation
func (s UpgradeTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeTarget) GoString() string {
	return s.String()
}

// SetAutoUpgrade sets the AutoUpgrade field's value.
func (s *UpgradeTarget) SetAutoUpgrade(v bool) *UpgradeTarget {
	s.AutoUpgrade = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpgradeTarget) SetDescription(v string) *UpgradeTarget {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *UpgradeTarget) SetEngine(v string) *UpgradeTarget {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *UpgradeTarget) SetEngineVersion(v string) *UpgradeTarget {
	s.EngineVersion = &v
	return s
}

// SetIsMajorVersionUpgrade sets the IsMajorVersionUpgrade field's value.
func (s *UpgradeTarget) SetIsMajorVersionUpgrade(v bool) *UpgradeTarget {
	s.IsMajorVersionUpgrade = &v
	return s
}

// Used as a response element for queries on virtual private cloud (VPC) security
// group membership.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

const (
	// ApplyMethodImmediate is a ApplyMethod enum value
	ApplyMethodImmediate = "immediate"

	// ApplyMethodPendingReboot is a ApplyMethod enum value
	ApplyMethodPendingReboot = "pending-reboot"
)

// ApplyMethod_Values returns all elements of the ApplyMethod enum
func ApplyMethod_Values() []string {
	return []string{
		ApplyMethodImmediate,
		ApplyMethodPendingReboot,
	}
}

const (
	// SourceTypeDbInstance is a SourceType enum value
	SourceTypeDbInstance = "db-instance"

	// SourceTypeDbParameterGroup is a SourceType enum value
	SourceTypeDbParameterGroup = "db-parameter-group"

	// SourceTypeDbSecurityGroup is a SourceType enum value
	SourceTypeDbSecurityGroup = "db-security-group"

	// SourceTypeDbSnapshot is a SourceType enum value
	SourceTypeDbSnapshot = "db-snapshot"

	// SourceTypeDbCluster is a SourceType enum value
	SourceTypeDbCluster = "db-cluster"

	// SourceTypeDbClusterSnapshot is a SourceType enum value
	SourceTypeDbClusterSnapshot = "db-cluster-snapshot"
)

// SourceType_Values returns all elements of the SourceType enum
func SourceType_Values() []string {
	return []string{
		SourceTypeDbInstance,
		SourceTypeDbParameterGroup,
		SourceTypeDbSecurityGroup,
		SourceTypeDbSnapshot,
		SourceTypeDbCluster,
		SourceTypeDbClusterSnapshot,
	}
}
