// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchCreateVariable = "BatchCreateVariable"

// BatchCreateVariableRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateVariable for more information on using the BatchCreateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateVariableRequest method.
//    req, resp := client.BatchCreateVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable
func (c *FraudDetector) BatchCreateVariableRequest(input *BatchCreateVariableInput) (req *request.Request, output *BatchCreateVariableOutput) {
	op := &request.Operation{
		Name:       opBatchCreateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCreateVariableInput{}
	}

	output = &BatchCreateVariableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateVariable API operation for Amazon Fraud Detector.
//
// Creates a batch of variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation BatchCreateVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable
func (c *FraudDetector) BatchCreateVariable(input *BatchCreateVariableInput) (*BatchCreateVariableOutput, error) {
	req, out := c.BatchCreateVariableRequest(input)
	return out, req.Send()
}

// BatchCreateVariableWithContext is the same as BatchCreateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) BatchCreateVariableWithContext(ctx aws.Context, input *BatchCreateVariableInput, opts ...request.Option) (*BatchCreateVariableOutput, error) {
	req, out := c.BatchCreateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetVariable = "BatchGetVariable"

// BatchGetVariableRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetVariable for more information on using the BatchGetVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetVariableRequest method.
//    req, resp := client.BatchGetVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *FraudDetector) BatchGetVariableRequest(input *BatchGetVariableInput) (req *request.Request, output *BatchGetVariableOutput) {
	op := &request.Operation{
		Name:       opBatchGetVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetVariableInput{}
	}

	output = &BatchGetVariableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetVariable API operation for Amazon Fraud Detector.
//
// Gets a batch of variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation BatchGetVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *FraudDetector) BatchGetVariable(input *BatchGetVariableInput) (*BatchGetVariableOutput, error) {
	req, out := c.BatchGetVariableRequest(input)
	return out, req.Send()
}

// BatchGetVariableWithContext is the same as BatchGetVariable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) BatchGetVariableWithContext(ctx aws.Context, input *BatchGetVariableInput, opts ...request.Option) (*BatchGetVariableOutput, error) {
	req, out := c.BatchGetVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDetectorVersion = "CreateDetectorVersion"

// CreateDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDetectorVersion for more information on using the CreateDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDetectorVersionRequest method.
//    req, resp := client.CreateDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *FraudDetector) CreateDetectorVersionRequest(input *CreateDetectorVersionInput) (req *request.Request, output *CreateDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opCreateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDetectorVersionInput{}
	}

	output = &CreateDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDetectorVersion API operation for Amazon Fraud Detector.
//
// Creates a detector version. The detector version starts in a DRAFT status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *FraudDetector) CreateDetectorVersion(input *CreateDetectorVersionInput) (*CreateDetectorVersionOutput, error) {
	req, out := c.CreateDetectorVersionRequest(input)
	return out, req.Send()
}

// CreateDetectorVersionWithContext is the same as CreateDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateDetectorVersionWithContext(ctx aws.Context, input *CreateDetectorVersionInput, opts ...request.Option) (*CreateDetectorVersionOutput, error) {
	req, out := c.CreateDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel
func (c *FraudDetector) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateModel API operation for Amazon Fraud Detector.
//
// Creates a model using the specified model type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel
func (c *FraudDetector) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelVersion = "CreateModelVersion"

// CreateModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelVersion for more information on using the CreateModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelVersionRequest method.
//    req, resp := client.CreateModelVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion
func (c *FraudDetector) CreateModelVersionRequest(input *CreateModelVersionInput) (req *request.Request, output *CreateModelVersionOutput) {
	op := &request.Operation{
		Name:       opCreateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelVersionInput{}
	}

	output = &CreateModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelVersion API operation for Amazon Fraud Detector.
//
// Creates a version of the model using the specified model type and model id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateModelVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion
func (c *FraudDetector) CreateModelVersion(input *CreateModelVersionInput) (*CreateModelVersionOutput, error) {
	req, out := c.CreateModelVersionRequest(input)
	return out, req.Send()
}

// CreateModelVersionWithContext is the same as CreateModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateModelVersionWithContext(ctx aws.Context, input *CreateModelVersionInput, opts ...request.Option) (*CreateModelVersionOutput, error) {
	req, out := c.CreateModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *FraudDetector) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for Amazon Fraud Detector.
//
// Creates a rule for use with the specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *FraudDetector) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVariable = "CreateVariable"

// CreateVariableRequest generates a "aws/request.Request" representing the
// client's request for the CreateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVariable for more information on using the CreateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVariableRequest method.
//    req, resp := client.CreateVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable
func (c *FraudDetector) CreateVariableRequest(input *CreateVariableInput) (req *request.Request, output *CreateVariableOutput) {
	op := &request.Operation{
		Name:       opCreateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVariableInput{}
	}

	output = &CreateVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVariable API operation for Amazon Fraud Detector.
//
// Creates a variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable
func (c *FraudDetector) CreateVariable(input *CreateVariableInput) (*CreateVariableOutput, error) {
	req, out := c.CreateVariableRequest(input)
	return out, req.Send()
}

// CreateVariableWithContext is the same as CreateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateVariableWithContext(ctx aws.Context, input *CreateVariableInput, opts ...request.Option) (*CreateVariableOutput, error) {
	req, out := c.CreateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetector = "DeleteDetector"

// DeleteDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetector for more information on using the DeleteDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDetectorRequest method.
//    req, resp := client.DeleteDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector
func (c *FraudDetector) DeleteDetectorRequest(input *DeleteDetectorInput) (req *request.Request, output *DeleteDetectorOutput) {
	op := &request.Operation{
		Name:       opDeleteDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDetectorInput{}
	}

	output = &DeleteDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetector API operation for Amazon Fraud Detector.
//
// Deletes the detector. Before deleting a detector, you must first delete all
// detector versions and rule versions associated with the detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteDetector for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   An exception indicating there was a conflict during a delete operation. The
//   following delete operations can cause a conflict exception:
//
//      * DeleteDetector: A conflict exception will occur if the detector has
//      associated Rules or DetectorVersions. You can only delete a detector if
//      it has no Rules or DetectorVersions.
//
//      * DeleteDetectorVersion: A conflict exception will occur if the DetectorVersion
//      status is ACTIVE.
//
//      * DeleteRule: A conflict exception will occur if the RuleVersion is in
//      use by an associated ACTIVE or INACTIVE DetectorVersion.
//
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector
func (c *FraudDetector) DeleteDetector(input *DeleteDetectorInput) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	return out, req.Send()
}

// DeleteDetectorWithContext is the same as DeleteDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteDetectorWithContext(ctx aws.Context, input *DeleteDetectorInput, opts ...request.Option) (*DeleteDetectorOutput, error) {
	req, out := c.DeleteDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetectorVersion = "DeleteDetectorVersion"

// DeleteDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetectorVersion for more information on using the DeleteDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDetectorVersionRequest method.
//    req, resp := client.DeleteDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion
func (c *FraudDetector) DeleteDetectorVersionRequest(input *DeleteDetectorVersionInput) (req *request.Request, output *DeleteDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDetectorVersionInput{}
	}

	output = &DeleteDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetectorVersion API operation for Amazon Fraud Detector.
//
// Deletes the detector version. You cannot delete detector versions that are
// in ACTIVE status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * ConflictException
//   An exception indicating there was a conflict during a delete operation. The
//   following delete operations can cause a conflict exception:
//
//      * DeleteDetector: A conflict exception will occur if the detector has
//      associated Rules or DetectorVersions. You can only delete a detector if
//      it has no Rules or DetectorVersions.
//
//      * DeleteDetectorVersion: A conflict exception will occur if the DetectorVersion
//      status is ACTIVE.
//
//      * DeleteRule: A conflict exception will occur if the RuleVersion is in
//      use by an associated ACTIVE or INACTIVE DetectorVersion.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion
func (c *FraudDetector) DeleteDetectorVersion(input *DeleteDetectorVersionInput) (*DeleteDetectorVersionOutput, error) {
	req, out := c.DeleteDetectorVersionRequest(input)
	return out, req.Send()
}

// DeleteDetectorVersionWithContext is the same as DeleteDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteDetectorVersionWithContext(ctx aws.Context, input *DeleteDetectorVersionInput, opts ...request.Option) (*DeleteDetectorVersionOutput, error) {
	req, out := c.DeleteDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvent = "DeleteEvent"

// DeleteEventRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvent for more information on using the DeleteEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventRequest method.
//    req, resp := client.DeleteEventRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *FraudDetector) DeleteEventRequest(input *DeleteEventInput) (req *request.Request, output *DeleteEventOutput) {
	op := &request.Operation{
		Name:       opDeleteEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventInput{}
	}

	output = &DeleteEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEvent API operation for Amazon Fraud Detector.
//
// Deletes the specified event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteEvent for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *FraudDetector) DeleteEvent(input *DeleteEventInput) (*DeleteEventOutput, error) {
	req, out := c.DeleteEventRequest(input)
	return out, req.Send()
}

// DeleteEventWithContext is the same as DeleteEvent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteEventWithContext(ctx aws.Context, input *DeleteEventInput, opts ...request.Option) (*DeleteEventOutput, error) {
	req, out := c.DeleteEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule
func (c *FraudDetector) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon Fraud Detector.
//
// Deletes the rule. You cannot delete a rule if it is used by an ACTIVE or
// INACTIVE detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   An exception indicating there was a conflict during a delete operation. The
//   following delete operations can cause a conflict exception:
//
//      * DeleteDetector: A conflict exception will occur if the detector has
//      associated Rules or DetectorVersions. You can only delete a detector if
//      it has no Rules or DetectorVersions.
//
//      * DeleteDetectorVersion: A conflict exception will occur if the DetectorVersion
//      status is ACTIVE.
//
//      * DeleteRule: A conflict exception will occur if the RuleVersion is in
//      use by an associated ACTIVE or INACTIVE DetectorVersion.
//
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule
func (c *FraudDetector) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDetector = "DescribeDetector"

// DescribeDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDetector for more information on using the DescribeDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDetectorRequest method.
//    req, resp := client.DescribeDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *FraudDetector) DescribeDetectorRequest(input *DescribeDetectorInput) (req *request.Request, output *DescribeDetectorOutput) {
	op := &request.Operation{
		Name:       opDescribeDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDetectorInput{}
	}

	output = &DescribeDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDetector API operation for Amazon Fraud Detector.
//
// Gets all versions for a specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DescribeDetector for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *FraudDetector) DescribeDetector(input *DescribeDetectorInput) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	return out, req.Send()
}

// DescribeDetectorWithContext is the same as DescribeDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeDetectorWithContext(ctx aws.Context, input *DescribeDetectorInput, opts ...request.Option) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelVersions = "DescribeModelVersions"

// DescribeModelVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelVersions for more information on using the DescribeModelVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelVersionsRequest method.
//    req, resp := client.DescribeModelVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *FraudDetector) DescribeModelVersionsRequest(input *DescribeModelVersionsInput) (req *request.Request, output *DescribeModelVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeModelVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeModelVersionsInput{}
	}

	output = &DescribeModelVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelVersions API operation for Amazon Fraud Detector.
//
// Gets all of the model versions for the specified model type or for the specified
// model type and model ID. You can also get details for a single, specified
// model version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DescribeModelVersions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *FraudDetector) DescribeModelVersions(input *DescribeModelVersionsInput) (*DescribeModelVersionsOutput, error) {
	req, out := c.DescribeModelVersionsRequest(input)
	return out, req.Send()
}

// DescribeModelVersionsWithContext is the same as DescribeModelVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeModelVersionsWithContext(ctx aws.Context, input *DescribeModelVersionsInput, opts ...request.Option) (*DescribeModelVersionsOutput, error) {
	req, out := c.DescribeModelVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeModelVersionsPages iterates over the pages of a DescribeModelVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeModelVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeModelVersions operation.
//    pageNum := 0
//    err := client.DescribeModelVersionsPages(params,
//        func(page *frauddetector.DescribeModelVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) DescribeModelVersionsPages(input *DescribeModelVersionsInput, fn func(*DescribeModelVersionsOutput, bool) bool) error {
	return c.DescribeModelVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeModelVersionsPagesWithContext same as DescribeModelVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeModelVersionsPagesWithContext(ctx aws.Context, input *DescribeModelVersionsInput, fn func(*DescribeModelVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeModelVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeModelVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeModelVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDetectorVersion = "GetDetectorVersion"

// GetDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetectorVersion for more information on using the GetDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDetectorVersionRequest method.
//    req, resp := client.GetDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion
func (c *FraudDetector) GetDetectorVersionRequest(input *GetDetectorVersionInput) (req *request.Request, output *GetDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opGetDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDetectorVersionInput{}
	}

	output = &GetDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetectorVersion API operation for Amazon Fraud Detector.
//
// Gets a particular detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion
func (c *FraudDetector) GetDetectorVersion(input *GetDetectorVersionInput) (*GetDetectorVersionOutput, error) {
	req, out := c.GetDetectorVersionRequest(input)
	return out, req.Send()
}

// GetDetectorVersionWithContext is the same as GetDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorVersionWithContext(ctx aws.Context, input *GetDetectorVersionInput, opts ...request.Option) (*GetDetectorVersionOutput, error) {
	req, out := c.GetDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDetectors = "GetDetectors"

// GetDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetectors for more information on using the GetDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDetectorsRequest method.
//    req, resp := client.GetDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *FraudDetector) GetDetectorsRequest(input *GetDetectorsInput) (req *request.Request, output *GetDetectorsOutput) {
	op := &request.Operation{
		Name:       opGetDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDetectorsInput{}
	}

	output = &GetDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetectors API operation for Amazon Fraud Detector.
//
// Gets all detectors or a single detector if a detectorId is specified. This
// is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetDetectorsResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDetectors for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *FraudDetector) GetDetectors(input *GetDetectorsInput) (*GetDetectorsOutput, error) {
	req, out := c.GetDetectorsRequest(input)
	return out, req.Send()
}

// GetDetectorsWithContext is the same as GetDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorsWithContext(ctx aws.Context, input *GetDetectorsInput, opts ...request.Option) (*GetDetectorsOutput, error) {
	req, out := c.GetDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDetectorsPages iterates over the pages of a GetDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDetectors operation.
//    pageNum := 0
//    err := client.GetDetectorsPages(params,
//        func(page *frauddetector.GetDetectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetDetectorsPages(input *GetDetectorsInput, fn func(*GetDetectorsOutput, bool) bool) error {
	return c.GetDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDetectorsPagesWithContext same as GetDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorsPagesWithContext(ctx aws.Context, input *GetDetectorsInput, fn func(*GetDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDetectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEntityTypes = "GetEntityTypes"

// GetEntityTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetEntityTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEntityTypes for more information on using the GetEntityTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEntityTypesRequest method.
//    req, resp := client.GetEntityTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes
func (c *FraudDetector) GetEntityTypesRequest(input *GetEntityTypesInput) (req *request.Request, output *GetEntityTypesOutput) {
	op := &request.Operation{
		Name:       opGetEntityTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEntityTypesInput{}
	}

	output = &GetEntityTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEntityTypes API operation for Amazon Fraud Detector.
//
// Gets all entity types or a specific entity type if a name is specified. This
// is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetEntityTypesResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEntityTypes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes
func (c *FraudDetector) GetEntityTypes(input *GetEntityTypesInput) (*GetEntityTypesOutput, error) {
	req, out := c.GetEntityTypesRequest(input)
	return out, req.Send()
}

// GetEntityTypesWithContext is the same as GetEntityTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetEntityTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEntityTypesWithContext(ctx aws.Context, input *GetEntityTypesInput, opts ...request.Option) (*GetEntityTypesOutput, error) {
	req, out := c.GetEntityTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEntityTypesPages iterates over the pages of a GetEntityTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEntityTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEntityTypes operation.
//    pageNum := 0
//    err := client.GetEntityTypesPages(params,
//        func(page *frauddetector.GetEntityTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetEntityTypesPages(input *GetEntityTypesInput, fn func(*GetEntityTypesOutput, bool) bool) error {
	return c.GetEntityTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEntityTypesPagesWithContext same as GetEntityTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEntityTypesPagesWithContext(ctx aws.Context, input *GetEntityTypesInput, fn func(*GetEntityTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEntityTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEntityTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEntityTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetEventPrediction = "GetEventPrediction"

// GetEventPredictionRequest generates a "aws/request.Request" representing the
// client's request for the GetEventPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventPrediction for more information on using the GetEventPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventPredictionRequest method.
//    req, resp := client.GetEventPredictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction
func (c *FraudDetector) GetEventPredictionRequest(input *GetEventPredictionInput) (req *request.Request, output *GetEventPredictionOutput) {
	op := &request.Operation{
		Name:       opGetEventPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventPredictionInput{}
	}

	output = &GetEventPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventPrediction API operation for Amazon Fraud Detector.
//
// Evaluates an event against a detector version. If a version ID is not provided,
// the detector’s (ACTIVE) version is used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEventPrediction for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction
func (c *FraudDetector) GetEventPrediction(input *GetEventPredictionInput) (*GetEventPredictionOutput, error) {
	req, out := c.GetEventPredictionRequest(input)
	return out, req.Send()
}

// GetEventPredictionWithContext is the same as GetEventPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventPredictionWithContext(ctx aws.Context, input *GetEventPredictionInput, opts ...request.Option) (*GetEventPredictionOutput, error) {
	req, out := c.GetEventPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventTypes = "GetEventTypes"

// GetEventTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetEventTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventTypes for more information on using the GetEventTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventTypesRequest method.
//    req, resp := client.GetEventTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes
func (c *FraudDetector) GetEventTypesRequest(input *GetEventTypesInput) (req *request.Request, output *GetEventTypesOutput) {
	op := &request.Operation{
		Name:       opGetEventTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetEventTypesInput{}
	}

	output = &GetEventTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventTypes API operation for Amazon Fraud Detector.
//
// Gets all event types or a specific event type if name is provided. This is
// a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetEventTypesResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetEventTypes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes
func (c *FraudDetector) GetEventTypes(input *GetEventTypesInput) (*GetEventTypesOutput, error) {
	req, out := c.GetEventTypesRequest(input)
	return out, req.Send()
}

// GetEventTypesWithContext is the same as GetEventTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventTypesWithContext(ctx aws.Context, input *GetEventTypesInput, opts ...request.Option) (*GetEventTypesOutput, error) {
	req, out := c.GetEventTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetEventTypesPages iterates over the pages of a GetEventTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetEventTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetEventTypes operation.
//    pageNum := 0
//    err := client.GetEventTypesPages(params,
//        func(page *frauddetector.GetEventTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetEventTypesPages(input *GetEventTypesInput, fn func(*GetEventTypesOutput, bool) bool) error {
	return c.GetEventTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetEventTypesPagesWithContext same as GetEventTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetEventTypesPagesWithContext(ctx aws.Context, input *GetEventTypesInput, fn func(*GetEventTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetEventTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEventTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetEventTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetExternalModels = "GetExternalModels"

// GetExternalModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetExternalModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExternalModels for more information on using the GetExternalModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExternalModelsRequest method.
//    req, resp := client.GetExternalModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *FraudDetector) GetExternalModelsRequest(input *GetExternalModelsInput) (req *request.Request, output *GetExternalModelsOutput) {
	op := &request.Operation{
		Name:       opGetExternalModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExternalModelsInput{}
	}

	output = &GetExternalModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExternalModels API operation for Amazon Fraud Detector.
//
// Gets the details for one or more Amazon SageMaker models that have been imported
// into the service. This is a paginated API. If you provide a null maxResults,
// this actions retrieves a maximum of 10 records per page. If you provide a
// maxResults, the value must be between 5 and 10. To get the next page results,
// provide the pagination token from the GetExternalModelsResult as part of
// your request. A null pagination token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetExternalModels for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *FraudDetector) GetExternalModels(input *GetExternalModelsInput) (*GetExternalModelsOutput, error) {
	req, out := c.GetExternalModelsRequest(input)
	return out, req.Send()
}

// GetExternalModelsWithContext is the same as GetExternalModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetExternalModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetExternalModelsWithContext(ctx aws.Context, input *GetExternalModelsInput, opts ...request.Option) (*GetExternalModelsOutput, error) {
	req, out := c.GetExternalModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetExternalModelsPages iterates over the pages of a GetExternalModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetExternalModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetExternalModels operation.
//    pageNum := 0
//    err := client.GetExternalModelsPages(params,
//        func(page *frauddetector.GetExternalModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetExternalModelsPages(input *GetExternalModelsInput, fn func(*GetExternalModelsOutput, bool) bool) error {
	return c.GetExternalModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetExternalModelsPagesWithContext same as GetExternalModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetExternalModelsPagesWithContext(ctx aws.Context, input *GetExternalModelsInput, fn func(*GetExternalModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetExternalModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetExternalModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetExternalModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetKMSEncryptionKey = "GetKMSEncryptionKey"

// GetKMSEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetKMSEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKMSEncryptionKey for more information on using the GetKMSEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKMSEncryptionKeyRequest method.
//    req, resp := client.GetKMSEncryptionKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey
func (c *FraudDetector) GetKMSEncryptionKeyRequest(input *GetKMSEncryptionKeyInput) (req *request.Request, output *GetKMSEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opGetKMSEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKMSEncryptionKeyInput{}
	}

	output = &GetKMSEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKMSEncryptionKey API operation for Amazon Fraud Detector.
//
// Gets the encryption key if a Key Management Service (KMS) customer master
// key (CMK) has been specified to be used to encrypt content in Amazon Fraud
// Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetKMSEncryptionKey for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey
func (c *FraudDetector) GetKMSEncryptionKey(input *GetKMSEncryptionKeyInput) (*GetKMSEncryptionKeyOutput, error) {
	req, out := c.GetKMSEncryptionKeyRequest(input)
	return out, req.Send()
}

// GetKMSEncryptionKeyWithContext is the same as GetKMSEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetKMSEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetKMSEncryptionKeyWithContext(ctx aws.Context, input *GetKMSEncryptionKeyInput, opts ...request.Option) (*GetKMSEncryptionKeyOutput, error) {
	req, out := c.GetKMSEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLabels = "GetLabels"

// GetLabelsRequest generates a "aws/request.Request" representing the
// client's request for the GetLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLabels for more information on using the GetLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLabelsRequest method.
//    req, resp := client.GetLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels
func (c *FraudDetector) GetLabelsRequest(input *GetLabelsInput) (req *request.Request, output *GetLabelsOutput) {
	op := &request.Operation{
		Name:       opGetLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLabelsInput{}
	}

	output = &GetLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLabels API operation for Amazon Fraud Detector.
//
// Gets all labels or a specific label if name is provided. This is a paginated
// API. If you provide a null maxResults, this action retrieves a maximum of
// 50 records per page. If you provide a maxResults, the value must be between
// 10 and 50. To get the next page results, provide the pagination token from
// the GetGetLabelsResponse as part of your request. A null pagination token
// fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetLabels for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels
func (c *FraudDetector) GetLabels(input *GetLabelsInput) (*GetLabelsOutput, error) {
	req, out := c.GetLabelsRequest(input)
	return out, req.Send()
}

// GetLabelsWithContext is the same as GetLabels with the addition of
// the ability to pass a context and additional request options.
//
// See GetLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetLabelsWithContext(ctx aws.Context, input *GetLabelsInput, opts ...request.Option) (*GetLabelsOutput, error) {
	req, out := c.GetLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetLabelsPages iterates over the pages of a GetLabels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetLabels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetLabels operation.
//    pageNum := 0
//    err := client.GetLabelsPages(params,
//        func(page *frauddetector.GetLabelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetLabelsPages(input *GetLabelsInput, fn func(*GetLabelsOutput, bool) bool) error {
	return c.GetLabelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetLabelsPagesWithContext same as GetLabelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetLabelsPagesWithContext(ctx aws.Context, input *GetLabelsInput, fn func(*GetLabelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetLabelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetLabelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetLabelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetModelVersion = "GetModelVersion"

// GetModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelVersion for more information on using the GetModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelVersionRequest method.
//    req, resp := client.GetModelVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *FraudDetector) GetModelVersionRequest(input *GetModelVersionInput) (req *request.Request, output *GetModelVersionOutput) {
	op := &request.Operation{
		Name:       opGetModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetModelVersionInput{}
	}

	output = &GetModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelVersion API operation for Amazon Fraud Detector.
//
// Gets the details of the specified model version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetModelVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *FraudDetector) GetModelVersion(input *GetModelVersionInput) (*GetModelVersionOutput, error) {
	req, out := c.GetModelVersionRequest(input)
	return out, req.Send()
}

// GetModelVersionWithContext is the same as GetModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelVersionWithContext(ctx aws.Context, input *GetModelVersionInput, opts ...request.Option) (*GetModelVersionOutput, error) {
	req, out := c.GetModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModels = "GetModels"

// GetModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModels for more information on using the GetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelsRequest method.
//    req, resp := client.GetModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *FraudDetector) GetModelsRequest(input *GetModelsInput) (req *request.Request, output *GetModelsOutput) {
	op := &request.Operation{
		Name:       opGetModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	output = &GetModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModels API operation for Amazon Fraud Detector.
//
// Gets one or more models. Gets all models for the AWS account if no model
// type and no model id provided. Gets all models for the AWS account and model
// type, if the model type is specified but model id is not provided. Gets a
// specific model if (model type, model id) tuple is specified.
//
// This is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 1 and 10. To get the next page results, provide the pagination
// token from the response as part of your request. A null pagination token
// fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetModels for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *FraudDetector) GetModels(input *GetModelsInput) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	return out, req.Send()
}

// GetModelsWithContext is the same as GetModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelsWithContext(ctx aws.Context, input *GetModelsInput, opts ...request.Option) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetModelsPages iterates over the pages of a GetModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetModels operation.
//    pageNum := 0
//    err := client.GetModelsPages(params,
//        func(page *frauddetector.GetModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetModelsPages(input *GetModelsInput, fn func(*GetModelsOutput, bool) bool) error {
	return c.GetModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetModelsPagesWithContext same as GetModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelsPagesWithContext(ctx aws.Context, input *GetModelsInput, fn func(*GetModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOutcomes = "GetOutcomes"

// GetOutcomesRequest generates a "aws/request.Request" representing the
// client's request for the GetOutcomes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutcomes for more information on using the GetOutcomes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOutcomesRequest method.
//    req, resp := client.GetOutcomesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes
func (c *FraudDetector) GetOutcomesRequest(input *GetOutcomesInput) (req *request.Request, output *GetOutcomesOutput) {
	op := &request.Operation{
		Name:       opGetOutcomes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOutcomesInput{}
	}

	output = &GetOutcomesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutcomes API operation for Amazon Fraud Detector.
//
// Gets one or more outcomes. This is a paginated API. If you provide a null
// maxResults, this actions retrieves a maximum of 100 records per page. If
// you provide a maxResults, the value must be between 50 and 100. To get the
// next page results, provide the pagination token from the GetOutcomesResult
// as part of your request. A null pagination token fetches the records from
// the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetOutcomes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes
func (c *FraudDetector) GetOutcomes(input *GetOutcomesInput) (*GetOutcomesOutput, error) {
	req, out := c.GetOutcomesRequest(input)
	return out, req.Send()
}

// GetOutcomesWithContext is the same as GetOutcomes with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutcomes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetOutcomesWithContext(ctx aws.Context, input *GetOutcomesInput, opts ...request.Option) (*GetOutcomesOutput, error) {
	req, out := c.GetOutcomesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOutcomesPages iterates over the pages of a GetOutcomes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOutcomes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetOutcomes operation.
//    pageNum := 0
//    err := client.GetOutcomesPages(params,
//        func(page *frauddetector.GetOutcomesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetOutcomesPages(input *GetOutcomesInput, fn func(*GetOutcomesOutput, bool) bool) error {
	return c.GetOutcomesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOutcomesPagesWithContext same as GetOutcomesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetOutcomesPagesWithContext(ctx aws.Context, input *GetOutcomesInput, fn func(*GetOutcomesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOutcomesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOutcomesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOutcomesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetRules = "GetRules"

// GetRulesRequest generates a "aws/request.Request" representing the
// client's request for the GetRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRules for more information on using the GetRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRulesRequest method.
//    req, resp := client.GetRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules
func (c *FraudDetector) GetRulesRequest(input *GetRulesInput) (req *request.Request, output *GetRulesOutput) {
	op := &request.Operation{
		Name:       opGetRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetRulesInput{}
	}

	output = &GetRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRules API operation for Amazon Fraud Detector.
//
// Get all rules for a detector (paginated) if ruleId and ruleVersion are not
// specified. Gets all rules for the detector and the ruleId if present (paginated).
// Gets a specific rule if both the ruleId and the ruleVersion are specified.
//
// This is a paginated API. Providing null maxResults results in retrieving
// maximum of 100 records per page. If you provide maxResults the value must
// be between 50 and 100. To get the next page result, a provide a pagination
// token from GetRulesResult as part of your request. Null pagination token
// fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetRules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules
func (c *FraudDetector) GetRules(input *GetRulesInput) (*GetRulesOutput, error) {
	req, out := c.GetRulesRequest(input)
	return out, req.Send()
}

// GetRulesWithContext is the same as GetRules with the addition of
// the ability to pass a context and additional request options.
//
// See GetRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetRulesWithContext(ctx aws.Context, input *GetRulesInput, opts ...request.Option) (*GetRulesOutput, error) {
	req, out := c.GetRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetRulesPages iterates over the pages of a GetRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetRules operation.
//    pageNum := 0
//    err := client.GetRulesPages(params,
//        func(page *frauddetector.GetRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetRulesPages(input *GetRulesInput, fn func(*GetRulesOutput, bool) bool) error {
	return c.GetRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetRulesPagesWithContext same as GetRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetRulesPagesWithContext(ctx aws.Context, input *GetRulesInput, fn func(*GetRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetVariables = "GetVariables"

// GetVariablesRequest generates a "aws/request.Request" representing the
// client's request for the GetVariables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVariables for more information on using the GetVariables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVariablesRequest method.
//    req, resp := client.GetVariablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *FraudDetector) GetVariablesRequest(input *GetVariablesInput) (req *request.Request, output *GetVariablesOutput) {
	op := &request.Operation{
		Name:       opGetVariables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetVariablesInput{}
	}

	output = &GetVariablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVariables API operation for Amazon Fraud Detector.
//
// Gets all of the variables or the specific variable. This is a paginated API.
// Providing null maxSizePerPage results in retrieving maximum of 100 records
// per page. If you provide maxSizePerPage the value must be between 50 and
// 100. To get the next page result, a provide a pagination token from GetVariablesResult
// as part of your request. Null pagination token fetches the records from the
// beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetVariables for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *FraudDetector) GetVariables(input *GetVariablesInput) (*GetVariablesOutput, error) {
	req, out := c.GetVariablesRequest(input)
	return out, req.Send()
}

// GetVariablesWithContext is the same as GetVariables with the addition of
// the ability to pass a context and additional request options.
//
// See GetVariables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetVariablesWithContext(ctx aws.Context, input *GetVariablesInput, opts ...request.Option) (*GetVariablesOutput, error) {
	req, out := c.GetVariablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetVariablesPages iterates over the pages of a GetVariables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetVariables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetVariables operation.
//    pageNum := 0
//    err := client.GetVariablesPages(params,
//        func(page *frauddetector.GetVariablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetVariablesPages(input *GetVariablesInput, fn func(*GetVariablesOutput, bool) bool) error {
	return c.GetVariablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetVariablesPagesWithContext same as GetVariablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetVariablesPagesWithContext(ctx aws.Context, input *GetVariablesInput, fn func(*GetVariablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetVariablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVariablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetVariablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource
func (c *FraudDetector) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Fraud Detector.
//
// Lists all tags associated with the resource. This is a paginated API. To
// get the next page results, provide the pagination token from the response
// as part of your request. A null pagination token fetches the records from
// the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource
func (c *FraudDetector) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *frauddetector.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDetector = "PutDetector"

// PutDetectorRequest generates a "aws/request.Request" representing the
// client's request for the PutDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDetector for more information on using the PutDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDetectorRequest method.
//    req, resp := client.PutDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector
func (c *FraudDetector) PutDetectorRequest(input *PutDetectorInput) (req *request.Request, output *PutDetectorOutput) {
	op := &request.Operation{
		Name:       opPutDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDetectorInput{}
	}

	output = &PutDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDetector API operation for Amazon Fraud Detector.
//
// Creates or updates a detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutDetector for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector
func (c *FraudDetector) PutDetector(input *PutDetectorInput) (*PutDetectorOutput, error) {
	req, out := c.PutDetectorRequest(input)
	return out, req.Send()
}

// PutDetectorWithContext is the same as PutDetector with the addition of
// the ability to pass a context and additional request options.
//
// See PutDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutDetectorWithContext(ctx aws.Context, input *PutDetectorInput, opts ...request.Option) (*PutDetectorOutput, error) {
	req, out := c.PutDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEntityType = "PutEntityType"

// PutEntityTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutEntityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEntityType for more information on using the PutEntityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEntityTypeRequest method.
//    req, resp := client.PutEntityTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType
func (c *FraudDetector) PutEntityTypeRequest(input *PutEntityTypeInput) (req *request.Request, output *PutEntityTypeOutput) {
	op := &request.Operation{
		Name:       opPutEntityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEntityTypeInput{}
	}

	output = &PutEntityTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEntityType API operation for Amazon Fraud Detector.
//
// Creates or updates an entity type. An entity represents who is performing
// the event. As part of a fraud prediction, you pass the entity ID to indicate
// the specific entity who performed the event. An entity type classifies the
// entity. Example classifications include customer, merchant, or account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutEntityType for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType
func (c *FraudDetector) PutEntityType(input *PutEntityTypeInput) (*PutEntityTypeOutput, error) {
	req, out := c.PutEntityTypeRequest(input)
	return out, req.Send()
}

// PutEntityTypeWithContext is the same as PutEntityType with the addition of
// the ability to pass a context and additional request options.
//
// See PutEntityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutEntityTypeWithContext(ctx aws.Context, input *PutEntityTypeInput, opts ...request.Option) (*PutEntityTypeOutput, error) {
	req, out := c.PutEntityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventType = "PutEventType"

// PutEventTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutEventType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventType for more information on using the PutEventType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventTypeRequest method.
//    req, resp := client.PutEventTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType
func (c *FraudDetector) PutEventTypeRequest(input *PutEventTypeInput) (req *request.Request, output *PutEventTypeOutput) {
	op := &request.Operation{
		Name:       opPutEventType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventTypeInput{}
	}

	output = &PutEventTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEventType API operation for Amazon Fraud Detector.
//
// Creates or updates an event type. An event is a business activity that is
// evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud
// predictions for events. An event type defines the structure for an event
// sent to Amazon Fraud Detector. This includes the variables sent as part of
// the event, the entity performing the event (such as a customer), and the
// labels that classify the event. Example event types include online payment
// transactions, account registrations, and authentications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutEventType for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType
func (c *FraudDetector) PutEventType(input *PutEventTypeInput) (*PutEventTypeOutput, error) {
	req, out := c.PutEventTypeRequest(input)
	return out, req.Send()
}

// PutEventTypeWithContext is the same as PutEventType with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutEventTypeWithContext(ctx aws.Context, input *PutEventTypeInput, opts ...request.Option) (*PutEventTypeOutput, error) {
	req, out := c.PutEventTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutExternalModel = "PutExternalModel"

// PutExternalModelRequest generates a "aws/request.Request" representing the
// client's request for the PutExternalModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutExternalModel for more information on using the PutExternalModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutExternalModelRequest method.
//    req, resp := client.PutExternalModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel
func (c *FraudDetector) PutExternalModelRequest(input *PutExternalModelInput) (req *request.Request, output *PutExternalModelOutput) {
	op := &request.Operation{
		Name:       opPutExternalModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutExternalModelInput{}
	}

	output = &PutExternalModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutExternalModel API operation for Amazon Fraud Detector.
//
// Creates or updates an Amazon SageMaker model endpoint. You can also use this
// action to update the configuration of the model endpoint, including the IAM
// role and/or the mapped variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutExternalModel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel
func (c *FraudDetector) PutExternalModel(input *PutExternalModelInput) (*PutExternalModelOutput, error) {
	req, out := c.PutExternalModelRequest(input)
	return out, req.Send()
}

// PutExternalModelWithContext is the same as PutExternalModel with the addition of
// the ability to pass a context and additional request options.
//
// See PutExternalModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutExternalModelWithContext(ctx aws.Context, input *PutExternalModelInput, opts ...request.Option) (*PutExternalModelOutput, error) {
	req, out := c.PutExternalModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutKMSEncryptionKey = "PutKMSEncryptionKey"

// PutKMSEncryptionKeyRequest generates a "aws/request.Request" representing the
// client's request for the PutKMSEncryptionKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutKMSEncryptionKey for more information on using the PutKMSEncryptionKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutKMSEncryptionKeyRequest method.
//    req, resp := client.PutKMSEncryptionKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey
func (c *FraudDetector) PutKMSEncryptionKeyRequest(input *PutKMSEncryptionKeyInput) (req *request.Request, output *PutKMSEncryptionKeyOutput) {
	op := &request.Operation{
		Name:       opPutKMSEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKMSEncryptionKeyInput{}
	}

	output = &PutKMSEncryptionKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutKMSEncryptionKey API operation for Amazon Fraud Detector.
//
// Specifies the Key Management Service (KMS) customer master key (CMK) to be
// used to encrypt content in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutKMSEncryptionKey for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey
func (c *FraudDetector) PutKMSEncryptionKey(input *PutKMSEncryptionKeyInput) (*PutKMSEncryptionKeyOutput, error) {
	req, out := c.PutKMSEncryptionKeyRequest(input)
	return out, req.Send()
}

// PutKMSEncryptionKeyWithContext is the same as PutKMSEncryptionKey with the addition of
// the ability to pass a context and additional request options.
//
// See PutKMSEncryptionKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutKMSEncryptionKeyWithContext(ctx aws.Context, input *PutKMSEncryptionKeyInput, opts ...request.Option) (*PutKMSEncryptionKeyOutput, error) {
	req, out := c.PutKMSEncryptionKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLabel = "PutLabel"

// PutLabelRequest generates a "aws/request.Request" representing the
// client's request for the PutLabel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLabel for more information on using the PutLabel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLabelRequest method.
//    req, resp := client.PutLabelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel
func (c *FraudDetector) PutLabelRequest(input *PutLabelInput) (req *request.Request, output *PutLabelOutput) {
	op := &request.Operation{
		Name:       opPutLabel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLabelInput{}
	}

	output = &PutLabelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLabel API operation for Amazon Fraud Detector.
//
// Creates or updates label. A label classifies an event as fraudulent or legitimate.
// Labels are associated with event types and used to train supervised machine
// learning models in Amazon Fraud Detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutLabel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel
func (c *FraudDetector) PutLabel(input *PutLabelInput) (*PutLabelOutput, error) {
	req, out := c.PutLabelRequest(input)
	return out, req.Send()
}

// PutLabelWithContext is the same as PutLabel with the addition of
// the ability to pass a context and additional request options.
//
// See PutLabel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutLabelWithContext(ctx aws.Context, input *PutLabelInput, opts ...request.Option) (*PutLabelOutput, error) {
	req, out := c.PutLabelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOutcome = "PutOutcome"

// PutOutcomeRequest generates a "aws/request.Request" representing the
// client's request for the PutOutcome operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOutcome for more information on using the PutOutcome
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOutcomeRequest method.
//    req, resp := client.PutOutcomeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *FraudDetector) PutOutcomeRequest(input *PutOutcomeInput) (req *request.Request, output *PutOutcomeOutput) {
	op := &request.Operation{
		Name:       opPutOutcome,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOutcomeInput{}
	}

	output = &PutOutcomeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutOutcome API operation for Amazon Fraud Detector.
//
// Creates or updates an outcome.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutOutcome for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *FraudDetector) PutOutcome(input *PutOutcomeInput) (*PutOutcomeOutput, error) {
	req, out := c.PutOutcomeRequest(input)
	return out, req.Send()
}

// PutOutcomeWithContext is the same as PutOutcome with the addition of
// the ability to pass a context and additional request options.
//
// See PutOutcome for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutOutcomeWithContext(ctx aws.Context, input *PutOutcomeInput, opts ...request.Option) (*PutOutcomeOutput, error) {
	req, out := c.PutOutcomeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource
func (c *FraudDetector) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Fraud Detector.
//
// Assigns tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource
func (c *FraudDetector) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource
func (c *FraudDetector) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Fraud Detector.
//
// Removes tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource
func (c *FraudDetector) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersion = "UpdateDetectorVersion"

// UpdateDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersion for more information on using the UpdateDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorVersionRequest method.
//    req, resp := client.UpdateDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion
func (c *FraudDetector) UpdateDetectorVersionRequest(input *UpdateDetectorVersionInput) (req *request.Request, output *UpdateDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionInput{}
	}

	output = &UpdateDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersion API operation for Amazon Fraud Detector.
//
// Updates a detector version. The detector version attributes that you can
// update include models, external model endpoints, rules, rule execution mode,
// and description. You can only update a DRAFT detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion
func (c *FraudDetector) UpdateDetectorVersion(input *UpdateDetectorVersionInput) (*UpdateDetectorVersionOutput, error) {
	req, out := c.UpdateDetectorVersionRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionWithContext is the same as UpdateDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionWithContext(ctx aws.Context, input *UpdateDetectorVersionInput, opts ...request.Option) (*UpdateDetectorVersionOutput, error) {
	req, out := c.UpdateDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersionMetadata = "UpdateDetectorVersionMetadata"

// UpdateDetectorVersionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersionMetadata for more information on using the UpdateDetectorVersionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorVersionMetadataRequest method.
//    req, resp := client.UpdateDetectorVersionMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *FraudDetector) UpdateDetectorVersionMetadataRequest(input *UpdateDetectorVersionMetadataInput) (req *request.Request, output *UpdateDetectorVersionMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionMetadataInput{}
	}

	output = &UpdateDetectorVersionMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersionMetadata API operation for Amazon Fraud Detector.
//
// Updates the detector version's description. You can update the metadata for
// any detector version (DRAFT, ACTIVE, or INACTIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersionMetadata for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *FraudDetector) UpdateDetectorVersionMetadata(input *UpdateDetectorVersionMetadataInput) (*UpdateDetectorVersionMetadataOutput, error) {
	req, out := c.UpdateDetectorVersionMetadataRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionMetadataWithContext is the same as UpdateDetectorVersionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionMetadataWithContext(ctx aws.Context, input *UpdateDetectorVersionMetadataInput, opts ...request.Option) (*UpdateDetectorVersionMetadataOutput, error) {
	req, out := c.UpdateDetectorVersionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersionStatus = "UpdateDetectorVersionStatus"

// UpdateDetectorVersionStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersionStatus for more information on using the UpdateDetectorVersionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorVersionStatusRequest method.
//    req, resp := client.UpdateDetectorVersionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *FraudDetector) UpdateDetectorVersionStatusRequest(input *UpdateDetectorVersionStatusInput) (req *request.Request, output *UpdateDetectorVersionStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionStatusInput{}
	}

	output = &UpdateDetectorVersionStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersionStatus API operation for Amazon Fraud Detector.
//
// Updates the detector version’s status. You can perform the following promotions
// or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to
// INACTIVE, and INACTIVE to ACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersionStatus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *FraudDetector) UpdateDetectorVersionStatus(input *UpdateDetectorVersionStatusInput) (*UpdateDetectorVersionStatusOutput, error) {
	req, out := c.UpdateDetectorVersionStatusRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionStatusWithContext is the same as UpdateDetectorVersionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionStatusWithContext(ctx aws.Context, input *UpdateDetectorVersionStatusInput, opts ...request.Option) (*UpdateDetectorVersionStatusOutput, error) {
	req, out := c.UpdateDetectorVersionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModel for more information on using the UpdateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelRequest method.
//    req, resp := client.UpdateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel
func (c *FraudDetector) UpdateModelRequest(input *UpdateModelInput) (req *request.Request, output *UpdateModelOutput) {
	op := &request.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	output = &UpdateModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateModel API operation for Amazon Fraud Detector.
//
// Updates a model. You can update the description attribute using this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel
func (c *FraudDetector) UpdateModel(input *UpdateModelInput) (*UpdateModelOutput, error) {
	req, out := c.UpdateModelRequest(input)
	return out, req.Send()
}

// UpdateModelWithContext is the same as UpdateModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelWithContext(ctx aws.Context, input *UpdateModelInput, opts ...request.Option) (*UpdateModelOutput, error) {
	req, out := c.UpdateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelVersion = "UpdateModelVersion"

// UpdateModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelVersion for more information on using the UpdateModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelVersionRequest method.
//    req, resp := client.UpdateModelVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *FraudDetector) UpdateModelVersionRequest(input *UpdateModelVersionInput) (req *request.Request, output *UpdateModelVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionInput{}
	}

	output = &UpdateModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateModelVersion API operation for Amazon Fraud Detector.
//
// Updates a model version. Updating a model version retrains an existing model
// version using updated training data and produces a new minor version of the
// model. You can update the training data set location and data access role
// attributes using this action. This action creates and trains a new minor
// version of the model, for example version 1.01, 1.02, 1.03.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModelVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *FraudDetector) UpdateModelVersion(input *UpdateModelVersionInput) (*UpdateModelVersionOutput, error) {
	req, out := c.UpdateModelVersionRequest(input)
	return out, req.Send()
}

// UpdateModelVersionWithContext is the same as UpdateModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelVersionWithContext(ctx aws.Context, input *UpdateModelVersionInput, opts ...request.Option) (*UpdateModelVersionOutput, error) {
	req, out := c.UpdateModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelVersionStatus = "UpdateModelVersionStatus"

// UpdateModelVersionStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelVersionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelVersionStatus for more information on using the UpdateModelVersionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelVersionStatusRequest method.
//    req, resp := client.UpdateModelVersionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus
func (c *FraudDetector) UpdateModelVersionStatusRequest(input *UpdateModelVersionStatusInput) (req *request.Request, output *UpdateModelVersionStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateModelVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionStatusInput{}
	}

	output = &UpdateModelVersionStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateModelVersionStatus API operation for Amazon Fraud Detector.
//
// Updates the status of a model version.
//
// You can perform the following status updates:
//
// Change the TRAINING_COMPLETE status to ACTIVE.
//
// Change ACTIVEto INACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModelVersionStatus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus
func (c *FraudDetector) UpdateModelVersionStatus(input *UpdateModelVersionStatusInput) (*UpdateModelVersionStatusOutput, error) {
	req, out := c.UpdateModelVersionStatusRequest(input)
	return out, req.Send()
}

// UpdateModelVersionStatusWithContext is the same as UpdateModelVersionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelVersionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelVersionStatusWithContext(ctx aws.Context, input *UpdateModelVersionStatusInput, opts ...request.Option) (*UpdateModelVersionStatusOutput, error) {
	req, out := c.UpdateModelVersionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleMetadata = "UpdateRuleMetadata"

// UpdateRuleMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleMetadata for more information on using the UpdateRuleMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleMetadataRequest method.
//    req, resp := client.UpdateRuleMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *FraudDetector) UpdateRuleMetadataRequest(input *UpdateRuleMetadataInput) (req *request.Request, output *UpdateRuleMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleMetadataInput{}
	}

	output = &UpdateRuleMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRuleMetadata API operation for Amazon Fraud Detector.
//
// Updates a rule's metadata. The description attribute can be updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateRuleMetadata for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *FraudDetector) UpdateRuleMetadata(input *UpdateRuleMetadataInput) (*UpdateRuleMetadataOutput, error) {
	req, out := c.UpdateRuleMetadataRequest(input)
	return out, req.Send()
}

// UpdateRuleMetadataWithContext is the same as UpdateRuleMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateRuleMetadataWithContext(ctx aws.Context, input *UpdateRuleMetadataInput, opts ...request.Option) (*UpdateRuleMetadataOutput, error) {
	req, out := c.UpdateRuleMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleVersion = "UpdateRuleVersion"

// UpdateRuleVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleVersion for more information on using the UpdateRuleVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleVersionRequest method.
//    req, resp := client.UpdateRuleVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *FraudDetector) UpdateRuleVersionRequest(input *UpdateRuleVersionInput) (req *request.Request, output *UpdateRuleVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleVersionInput{}
	}

	output = &UpdateRuleVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleVersion API operation for Amazon Fraud Detector.
//
// Updates a rule version resulting in a new rule version. Updates a rule version
// resulting in a new rule version (version 1, 2, 3 ...).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateRuleVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *FraudDetector) UpdateRuleVersion(input *UpdateRuleVersionInput) (*UpdateRuleVersionOutput, error) {
	req, out := c.UpdateRuleVersionRequest(input)
	return out, req.Send()
}

// UpdateRuleVersionWithContext is the same as UpdateRuleVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateRuleVersionWithContext(ctx aws.Context, input *UpdateRuleVersionInput, opts ...request.Option) (*UpdateRuleVersionOutput, error) {
	req, out := c.UpdateRuleVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVariable = "UpdateVariable"

// UpdateVariableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVariable for more information on using the UpdateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVariableRequest method.
//    req, resp := client.UpdateVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable
func (c *FraudDetector) UpdateVariableRequest(input *UpdateVariableInput) (req *request.Request, output *UpdateVariableOutput) {
	op := &request.Operation{
		Name:       opUpdateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVariableInput{}
	}

	output = &UpdateVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateVariable API operation for Amazon Fraud Detector.
//
// Updates a variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
//   * AccessDeniedException
//   An exception indicating Amazon Fraud Detector does not have the needed permissions.
//   This can occur if you submit a request, such as PutExternalModel, that specifies
//   a role that is not in your account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable
func (c *FraudDetector) UpdateVariable(input *UpdateVariableInput) (*UpdateVariableOutput, error) {
	req, out := c.UpdateVariableRequest(input)
	return out, req.Send()
}

// UpdateVariableWithContext is the same as UpdateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateVariableWithContext(ctx aws.Context, input *UpdateVariableInput, opts ...request.Option) (*UpdateVariableOutput, error) {
	req, out := c.UpdateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An exception indicating Amazon Fraud Detector does not have the needed permissions.
// This can occur if you submit a request, such as PutExternalModel, that specifies
// a role that is not in your account.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides the error of the batch create variable API.
type BatchCreateVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchCreateVariableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateVariableError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchCreateVariableError) SetCode(v int64) *BatchCreateVariableError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchCreateVariableError) SetMessage(v string) *BatchCreateVariableError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchCreateVariableError) SetName(v string) *BatchCreateVariableError {
	s.Name = &v
	return s
}

type BatchCreateVariableInput struct {
	_ struct{} `type:"structure"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The list of variables for the batch create variable request.
	//
	// VariableEntries is a required field
	VariableEntries []*VariableEntry `locationName:"variableEntries" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchCreateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateVariableInput"}
	if s.VariableEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("VariableEntries"))
	}
	if s.VariableEntries != nil && len(s.VariableEntries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VariableEntries", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTags sets the Tags field's value.
func (s *BatchCreateVariableInput) SetTags(v []*Tag) *BatchCreateVariableInput {
	s.Tags = v
	return s
}

// SetVariableEntries sets the VariableEntries field's value.
func (s *BatchCreateVariableInput) SetVariableEntries(v []*VariableEntry) *BatchCreateVariableInput {
	s.VariableEntries = v
	return s
}

type BatchCreateVariableOutput struct {
	_ struct{} `type:"structure"`

	// Provides the errors for the BatchCreateVariable request.
	Errors []*BatchCreateVariableError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchCreateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateVariableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateVariableOutput) SetErrors(v []*BatchCreateVariableError) *BatchCreateVariableOutput {
	s.Errors = v
	return s
}

// Provides the error of the batch get variable API.
type BatchGetVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The error name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchGetVariableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetVariableError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchGetVariableError) SetCode(v int64) *BatchGetVariableError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetVariableError) SetMessage(v string) *BatchGetVariableError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchGetVariableError) SetName(v string) *BatchGetVariableError {
	s.Name = &v
	return s
}

type BatchGetVariableInput struct {
	_ struct{} `type:"structure"`

	// The list of variable names to get.
	//
	// Names is a required field
	Names []*string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetVariableInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *BatchGetVariableInput) SetNames(v []*string) *BatchGetVariableInput {
	s.Names = v
	return s
}

type BatchGetVariableOutput struct {
	_ struct{} `type:"structure"`

	// The errors from the request.
	Errors []*BatchGetVariableError `locationName:"errors" type:"list"`

	// The returned variables.
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s BatchGetVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetVariableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetVariableOutput) SetErrors(v []*BatchGetVariableError) *BatchGetVariableOutput {
	s.Errors = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *BatchGetVariableOutput) SetVariables(v []*Variable) *BatchGetVariableOutput {
	s.Variables = v
	return s
}

// An exception indicating there was a conflict during a delete operation. The
// following delete operations can cause a conflict exception:
//
//    * DeleteDetector: A conflict exception will occur if the detector has
//    associated Rules or DetectorVersions. You can only delete a detector if
//    it has no Rules or DetectorVersions.
//
//    * DeleteDetectorVersion: A conflict exception will occur if the DetectorVersion
//    status is ACTIVE.
//
//    * DeleteRule: A conflict exception will occur if the RuleVersion is in
//    use by an associated ACTIVE or INACTIVE DetectorVersion.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the detector under which you want to create a new version.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The Amazon Sagemaker model endpoints to include in the detector version.
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list"`

	// The model versions to include in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rule execution mode for the rules included in the detector version.
	//
	// You can define and edit the rule mode at the detector version level, when
	// it is in draft status.
	//
	// If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules.
	//
	// The default behavior is FIRST_MATCHED.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDetectorVersionInput) SetDescription(v string) *CreateDetectorVersionInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorVersionInput) SetDetectorId(v string) *CreateDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *CreateDetectorVersionInput) SetExternalModelEndpoints(v []*string) *CreateDetectorVersionInput {
	s.ExternalModelEndpoints = v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *CreateDetectorVersionInput) SetModelVersions(v []*ModelVersion) *CreateDetectorVersionInput {
	s.ModelVersions = v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *CreateDetectorVersionInput) SetRuleExecutionMode(v string) *CreateDetectorVersionInput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateDetectorVersionInput) SetRules(v []*Rule) *CreateDetectorVersionInput {
	s.Rules = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDetectorVersionInput) SetTags(v []*Tag) *CreateDetectorVersionInput {
	s.Tags = v
	return s
}

type CreateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the created version's parent detector.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The ID for the created detector.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The status of the detector version.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s CreateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorVersionOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorVersionOutput) SetDetectorId(v string) *CreateDetectorVersionOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *CreateDetectorVersionOutput) SetDetectorVersionId(v string) *CreateDetectorVersionOutput {
	s.DetectorVersionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDetectorVersionOutput) SetStatus(v string) *CreateDetectorVersionOutput {
	s.Status = &v
	return s
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateModelInput) SetDescription(v string) *CreateModelInput {
	s.Description = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *CreateModelInput) SetEventTypeName(v string) *CreateModelInput {
	s.EventTypeName = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelInput) SetModelId(v string) *CreateModelInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelInput) SetModelType(v string) *CreateModelInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelInput) SetTags(v []*Tag) *CreateModelInput {
	s.Tags = v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelOutput) GoString() string {
	return s.String()
}

type CreateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// Details for the external events data used for model version training. Required
	// if trainingDataSource is EXTERNAL_EVENTS.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The training data schema.
	//
	// TrainingDataSchema is a required field
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure" required:"true"`

	// The training data source location in Amazon S3.
	//
	// TrainingDataSource is a required field
	TrainingDataSource *string `locationName:"trainingDataSource" type:"string" required:"true" enum:"TrainingDataSourceEnum"`
}

// String returns the string representation
func (s CreateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelVersionInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.TrainingDataSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataSchema"))
	}
	if s.TrainingDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataSource"))
	}
	if s.ExternalEventsDetail != nil {
		if err := s.ExternalEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("ExternalEventsDetail", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrainingDataSchema != nil {
		if err := s.TrainingDataSchema.Validate(); err != nil {
			invalidParams.AddNested("TrainingDataSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *CreateModelVersionInput) SetExternalEventsDetail(v *ExternalEventsDetail) *CreateModelVersionInput {
	s.ExternalEventsDetail = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelVersionInput) SetModelId(v string) *CreateModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelVersionInput) SetModelType(v string) *CreateModelVersionInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelVersionInput) SetTags(v []*Tag) *CreateModelVersionInput {
	s.Tags = v
	return s
}

// SetTrainingDataSchema sets the TrainingDataSchema field's value.
func (s *CreateModelVersionInput) SetTrainingDataSchema(v *TrainingDataSchema) *CreateModelVersionInput {
	s.TrainingDataSchema = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *CreateModelVersionInput) SetTrainingDataSource(v string) *CreateModelVersionInput {
	s.TrainingDataSource = &v
	return s
}

type CreateModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number of the model version created.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string"`

	// The model version status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s CreateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelVersionOutput) GoString() string {
	return s.String()
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelVersionOutput) SetModelId(v string) *CreateModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelVersionOutput) SetModelType(v string) *CreateModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *CreateModelVersionOutput) SetModelVersionNumber(v string) *CreateModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateModelVersionOutput) SetStatus(v string) *CreateModelVersionOutput {
	s.Status = &v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID for the rule's parent detector.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true" sensitive:"true"`

	// The language of the rule.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"Language"`

	// The outcome or outcomes returned when the rule expression matches.
	//
	// Outcomes is a required field
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Outcomes == nil {
		invalidParams.Add(request.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outcomes", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRuleInput) SetDescription(v string) *CreateRuleInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateRuleInput) SetDetectorId(v string) *CreateRuleInput {
	s.DetectorId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CreateRuleInput) SetExpression(v string) *CreateRuleInput {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateRuleInput) SetLanguage(v string) *CreateRuleInput {
	s.Language = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *CreateRuleInput) SetOutcomes(v []*string) *CreateRuleInput {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *CreateRuleInput) SetRuleId(v string) *CreateRuleInput {
	s.RuleId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleInput) SetTags(v []*Tag) *CreateRuleInput {
	s.Tags = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The created rule.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *CreateRuleOutput) SetRule(v *Rule) *CreateRuleOutput {
	s.Rule = v
	return s
}

type CreateVariableInput struct {
	_ struct{} `type:"structure"`

	// The source of the data.
	//
	// DataSource is a required field
	DataSource *string `locationName:"dataSource" type:"string" required:"true" enum:"DataSource"`

	// The data type.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"DataType"`

	// The default value for the variable when no value is received.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The variable type. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	//
	// Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 |
	// BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE
	// | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS |
	// FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID
	// | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1
	// | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME
	// | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s CreateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVariableInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DefaultValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultValue"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreateVariableInput) SetDataSource(v string) *CreateVariableInput {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *CreateVariableInput) SetDataType(v string) *CreateVariableInput {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CreateVariableInput) SetDefaultValue(v string) *CreateVariableInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateVariableInput) SetDescription(v string) *CreateVariableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVariableInput) SetName(v string) *CreateVariableInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVariableInput) SetTags(v []*Tag) *CreateVariableInput {
	s.Tags = v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *CreateVariableInput) SetVariableType(v string) *CreateVariableInput {
	s.VariableType = &v
	return s
}

type CreateVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVariableOutput) GoString() string {
	return s.String()
}

// The model training validation messages.
type DataValidationMetrics struct {
	_ struct{} `type:"structure"`

	// The field-specific model training validation messages.
	FieldLevelMessages []*FieldValidationMessage `locationName:"fieldLevelMessages" type:"list"`

	// The file-specific model training validation messages.
	FileLevelMessages []*FileValidationMessage `locationName:"fileLevelMessages" type:"list"`
}

// String returns the string representation
func (s DataValidationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataValidationMetrics) GoString() string {
	return s.String()
}

// SetFieldLevelMessages sets the FieldLevelMessages field's value.
func (s *DataValidationMetrics) SetFieldLevelMessages(v []*FieldValidationMessage) *DataValidationMetrics {
	s.FieldLevelMessages = v
	return s
}

// SetFileLevelMessages sets the FileLevelMessages field's value.
func (s *DataValidationMetrics) SetFileLevelMessages(v []*FileValidationMessage) *DataValidationMetrics {
	s.FileLevelMessages = v
	return s
}

type DeleteDetectorInput struct {
	_ struct{} `type:"structure"`

	// The ID of the detector to delete.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorInput) SetDetectorId(v string) *DeleteDetectorInput {
	s.DetectorId = &v
	return s
}

type DeleteDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorOutput) GoString() string {
	return s.String()
}

type DeleteDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent detector for the detector version to delete.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The ID of the detector version to delete.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorVersionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorVersionInput) SetDetectorId(v string) *DeleteDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *DeleteDetectorVersionInput) SetDetectorVersionId(v string) *DeleteDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

type DeleteDetectorVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorVersionOutput) GoString() string {
	return s.String()
}

type DeleteEventInput struct {
	_ struct{} `type:"structure"`

	// The ID of the event to delete.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *DeleteEventInput) SetEventId(v string) *DeleteEventInput {
	s.EventId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *DeleteEventInput) SetEventTypeName(v string) *DeleteEventInput {
	s.EventTypeName = &v
	return s
}

type DeleteEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventOutput) GoString() string {
	return s.String()
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// A rule.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *DeleteRuleInput) SetRule(v *Rule) *DeleteRuleInput {
	s.Rule = v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type DescribeDetectorInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1000" type:"integer"`

	// The next token from the previous response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeDetectorInput) SetDetectorId(v string) *DescribeDetectorInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDetectorInput) SetMaxResults(v int64) *DescribeDetectorInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDetectorInput) SetNextToken(v string) *DescribeDetectorInput {
	s.NextToken = &v
	return s
}

type DescribeDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The detector ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The status and description for each detector version.
	DetectorVersionSummaries []*DetectorVersionSummary `locationName:"detectorVersionSummaries" type:"list"`

	// The next token to be used for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeDetectorOutput) SetArn(v string) *DescribeDetectorOutput {
	s.Arn = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeDetectorOutput) SetDetectorId(v string) *DescribeDetectorOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionSummaries sets the DetectorVersionSummaries field's value.
func (s *DescribeDetectorOutput) SetDetectorVersionSummaries(v []*DetectorVersionSummary) *DescribeDetectorOutput {
	s.DetectorVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDetectorOutput) SetNextToken(v string) *DescribeDetectorOutput {
	s.NextToken = &v
	return s
}

type DescribeModelVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The next token from the previous results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeModelVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeModelVersionsInput) SetMaxResults(v int64) *DescribeModelVersionsInput {
	s.MaxResults = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *DescribeModelVersionsInput) SetModelId(v string) *DescribeModelVersionsInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *DescribeModelVersionsInput) SetModelType(v string) *DescribeModelVersionsInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *DescribeModelVersionsInput) SetModelVersionNumber(v string) *DescribeModelVersionsInput {
	s.ModelVersionNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeModelVersionsInput) SetNextToken(v string) *DescribeModelVersionsInput {
	s.NextToken = &v
	return s
}

type DescribeModelVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The model version details.
	ModelVersionDetails []*ModelVersionDetail `locationName:"modelVersionDetails" type:"list"`

	// The next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeModelVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelVersionsOutput) GoString() string {
	return s.String()
}

// SetModelVersionDetails sets the ModelVersionDetails field's value.
func (s *DescribeModelVersionsOutput) SetModelVersionDetails(v []*ModelVersionDetail) *DescribeModelVersionsOutput {
	s.ModelVersionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeModelVersionsOutput) SetNextToken(v string) *DescribeModelVersionsOutput {
	s.NextToken = &v
	return s
}

// The detector.
type Detector struct {
	_ struct{} `type:"structure"`

	// The detector ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the detector was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The detector description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The name of the event type.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// Timestamp of when the detector was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`
}

// String returns the string representation
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Detector) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Detector) SetArn(v string) *Detector {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Detector) SetCreatedTime(v string) *Detector {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Detector) SetDescription(v string) *Detector {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Detector) SetDetectorId(v string) *Detector {
	s.DetectorId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *Detector) SetEventTypeName(v string) *Detector {
	s.EventTypeName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Detector) SetLastUpdatedTime(v string) *Detector {
	s.LastUpdatedTime = &v
	return s
}

// The summary of the detector version.
type DetectorVersionSummary struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// Timestamp of when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The detector version status.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s DetectorVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorVersionSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DetectorVersionSummary) SetDescription(v string) *DetectorVersionSummary {
	s.Description = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *DetectorVersionSummary) SetDetectorVersionId(v string) *DetectorVersionSummary {
	s.DetectorVersionId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DetectorVersionSummary) SetLastUpdatedTime(v string) *DetectorVersionSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DetectorVersionSummary) SetStatus(v string) *DetectorVersionSummary {
	s.Status = &v
	return s
}

// The entity details.
type Entity struct {
	_ struct{} `type:"structure"`

	// The entity ID. If you do not know the entityId, you can pass unknown, which
	// is areserved string literal.
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" min:"1" type:"string" required:"true"`

	// The entity type.
	//
	// EntityType is a required field
	EntityType *string `locationName:"entityType" type:"string" required:"true"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Entity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Entity"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *Entity) SetEntityId(v string) *Entity {
	s.EntityId = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *Entity) SetEntityType(v string) *Entity {
	s.EntityType = &v
	return s
}

// The entity type details.
type EntityType struct {
	_ struct{} `type:"structure"`

	// The entity type ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the entity type was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The entity type description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Timestamp of when the entity type was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The entity type name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s EntityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityType) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EntityType) SetArn(v string) *EntityType {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *EntityType) SetCreatedTime(v string) *EntityType {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EntityType) SetDescription(v string) *EntityType {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *EntityType) SetLastUpdatedTime(v string) *EntityType {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EntityType) SetName(v string) *EntityType {
	s.Name = &v
	return s
}

// The event type details.
type EventType struct {
	_ struct{} `type:"structure"`

	// The entity type ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the event type was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The event type description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The event type entity types.
	EntityTypes []*string `locationName:"entityTypes" min:"1" type:"list"`

	// The event type event variables.
	EventVariables []*string `locationName:"eventVariables" type:"list"`

	// The event type labels.
	Labels []*string `locationName:"labels" type:"list"`

	// Timestamp of when the event type was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The event type name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s EventType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventType) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventType) SetArn(v string) *EventType {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *EventType) SetCreatedTime(v string) *EventType {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EventType) SetDescription(v string) *EventType {
	s.Description = &v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EventType) SetEntityTypes(v []*string) *EventType {
	s.EntityTypes = v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *EventType) SetEventVariables(v []*string) *EventType {
	s.EventVariables = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *EventType) SetLabels(v []*string) *EventType {
	s.Labels = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *EventType) SetLastUpdatedTime(v string) *EventType {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventType) SetName(v string) *EventType {
	s.Name = &v
	return s
}

// Details for the external events data used for model version training.
type ExternalEventsDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the role that provides Amazon Fraud Detector access to the data
	// location.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"1" type:"string" required:"true"`

	// The Amazon S3 bucket location for the data.
	//
	// DataLocation is a required field
	DataLocation *string `locationName:"dataLocation" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExternalEventsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalEventsDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalEventsDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalEventsDetail"}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 1))
	}
	if s.DataLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLocation"))
	}
	if s.DataLocation != nil && len(*s.DataLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataLocation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ExternalEventsDetail) SetDataAccessRoleArn(v string) *ExternalEventsDetail {
	s.DataAccessRoleArn = &v
	return s
}

// SetDataLocation sets the DataLocation field's value.
func (s *ExternalEventsDetail) SetDataLocation(v string) *ExternalEventsDetail {
	s.DataLocation = &v
	return s
}

// The Amazon SageMaker model.
type ExternalModel struct {
	_ struct{} `type:"structure"`

	// The model ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the model was last created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The input configuration.
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure"`

	// The role used to invoke the model.
	InvokeModelEndpointRoleArn *string `locationName:"invokeModelEndpointRoleArn" type:"string"`

	// Timestamp of when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The Amazon SageMaker model endpoints.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The Amazon Fraud Detector status for the external model endpoint
	ModelEndpointStatus *string `locationName:"modelEndpointStatus" type:"string" enum:"ModelEndpointStatus"`

	// The source of the model.
	ModelSource *string `locationName:"modelSource" type:"string" enum:"ModelSource"`

	// The output configuration.
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure"`
}

// String returns the string representation
func (s ExternalModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalModel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ExternalModel) SetArn(v string) *ExternalModel {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ExternalModel) SetCreatedTime(v string) *ExternalModel {
	s.CreatedTime = &v
	return s
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *ExternalModel) SetInputConfiguration(v *ModelInputConfiguration) *ExternalModel {
	s.InputConfiguration = v
	return s
}

// SetInvokeModelEndpointRoleArn sets the InvokeModelEndpointRoleArn field's value.
func (s *ExternalModel) SetInvokeModelEndpointRoleArn(v string) *ExternalModel {
	s.InvokeModelEndpointRoleArn = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ExternalModel) SetLastUpdatedTime(v string) *ExternalModel {
	s.LastUpdatedTime = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *ExternalModel) SetModelEndpoint(v string) *ExternalModel {
	s.ModelEndpoint = &v
	return s
}

// SetModelEndpointStatus sets the ModelEndpointStatus field's value.
func (s *ExternalModel) SetModelEndpointStatus(v string) *ExternalModel {
	s.ModelEndpointStatus = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *ExternalModel) SetModelSource(v string) *ExternalModel {
	s.ModelSource = &v
	return s
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *ExternalModel) SetOutputConfiguration(v *ModelOutputConfiguration) *ExternalModel {
	s.OutputConfiguration = v
	return s
}

// The message details.
type FieldValidationMessage struct {
	_ struct{} `type:"structure"`

	// The message content.
	Content *string `locationName:"content" type:"string"`

	// The field name.
	FieldName *string `locationName:"fieldName" type:"string"`

	// The message ID.
	Identifier *string `locationName:"identifier" type:"string"`

	// The message title.
	Title *string `locationName:"title" type:"string"`

	// The message type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s FieldValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldValidationMessage) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *FieldValidationMessage) SetContent(v string) *FieldValidationMessage {
	s.Content = &v
	return s
}

// SetFieldName sets the FieldName field's value.
func (s *FieldValidationMessage) SetFieldName(v string) *FieldValidationMessage {
	s.FieldName = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *FieldValidationMessage) SetIdentifier(v string) *FieldValidationMessage {
	s.Identifier = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *FieldValidationMessage) SetTitle(v string) *FieldValidationMessage {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *FieldValidationMessage) SetType(v string) *FieldValidationMessage {
	s.Type = &v
	return s
}

// The message details.
type FileValidationMessage struct {
	_ struct{} `type:"structure"`

	// The message content.
	Content *string `locationName:"content" type:"string"`

	// The message title.
	Title *string `locationName:"title" type:"string"`

	// The message type.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s FileValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileValidationMessage) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *FileValidationMessage) SetContent(v string) *FileValidationMessage {
	s.Content = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *FileValidationMessage) SetTitle(v string) *FileValidationMessage {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *FileValidationMessage) SetType(v string) *FileValidationMessage {
	s.Type = &v
	return s
}

type GetDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorVersionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorVersionInput) SetDetectorId(v string) *GetDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetDetectorVersionInput) SetDetectorVersionId(v string) *GetDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

type GetDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The detector version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp when the detector version was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The Amazon SageMaker model endpoints included in the detector version.
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list"`

	// The timestamp when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model versions included in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The execution mode of the rule in the dectector
	//
	// FIRST_MATCHED indicates that Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// ALL_MATCHED indicates that Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules. You can define and edit the rule
	// mode at the detector version level, when it is in draft status.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// The rules included in the detector version.
	Rules []*Rule `locationName:"rules" type:"list"`

	// The status of the detector version.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s GetDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDetectorVersionOutput) SetArn(v string) *GetDetectorVersionOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetDetectorVersionOutput) SetCreatedTime(v string) *GetDetectorVersionOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDetectorVersionOutput) SetDescription(v string) *GetDetectorVersionOutput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorVersionOutput) SetDetectorId(v string) *GetDetectorVersionOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetDetectorVersionOutput) SetDetectorVersionId(v string) *GetDetectorVersionOutput {
	s.DetectorVersionId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *GetDetectorVersionOutput) SetExternalModelEndpoints(v []*string) *GetDetectorVersionOutput {
	s.ExternalModelEndpoints = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetDetectorVersionOutput) SetLastUpdatedTime(v string) *GetDetectorVersionOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *GetDetectorVersionOutput) SetModelVersions(v []*ModelVersion) *GetDetectorVersionOutput {
	s.ModelVersions = v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *GetDetectorVersionOutput) SetRuleExecutionMode(v string) *GetDetectorVersionOutput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetDetectorVersionOutput) SetRules(v []*Rule) *GetDetectorVersionOutput {
	s.Rules = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDetectorVersionOutput) SetStatus(v string) *GetDetectorVersionOutput {
	s.Status = &v
	return s
}

type GetDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorsInput"}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorsInput) SetDetectorId(v string) *GetDetectorsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDetectorsInput) SetMaxResults(v int64) *GetDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDetectorsInput) SetNextToken(v string) *GetDetectorsInput {
	s.NextToken = &v
	return s
}

type GetDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// The detectors.
	Detectors []*Detector `locationName:"detectors" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectors sets the Detectors field's value.
func (s *GetDetectorsOutput) SetDetectors(v []*Detector) *GetDetectorsOutput {
	s.Detectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDetectorsOutput) SetNextToken(v string) *GetDetectorsOutput {
	s.NextToken = &v
	return s
}

type GetEntityTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEntityTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEntityTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEntityTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEntityTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEntityTypesInput) SetMaxResults(v int64) *GetEntityTypesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEntityTypesInput) SetName(v string) *GetEntityTypesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEntityTypesInput) SetNextToken(v string) *GetEntityTypesInput {
	s.NextToken = &v
	return s
}

type GetEntityTypesOutput struct {
	_ struct{} `type:"structure"`

	// An array of entity types.
	EntityTypes []*EntityType `locationName:"entityTypes" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEntityTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEntityTypesOutput) GoString() string {
	return s.String()
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *GetEntityTypesOutput) SetEntityTypes(v []*EntityType) *GetEntityTypesOutput {
	s.EntityTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEntityTypesOutput) SetNextToken(v string) *GetEntityTypesOutput {
	s.NextToken = &v
	return s
}

type GetEventPredictionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" type:"string" required:"true"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The entity type (associated with the detector's event type) and specific
	// entity ID representing who performed the event. If an entity id is not available,
	// use "UNKNOWN."
	//
	// Entities is a required field
	Entities []*Entity `locationName:"entities" type:"list" required:"true"`

	// The unique ID used to identify the event.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// Timestamp that defines when the event under evaluation occurred.
	//
	// EventTimestamp is a required field
	EventTimestamp *string `locationName:"eventTimestamp" type:"string" required:"true"`

	// The event type associated with the detector specified for the prediction.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" type:"string" required:"true"`

	// Names of the event type's variables you defined in Amazon Fraud Detector
	// to represent data elements and their corresponding values for the event you
	// are sending for evaluation.
	//
	// EventVariables is a required field
	EventVariables map[string]*string `locationName:"eventVariables" min:"1" type:"map" required:"true"`

	// The Amazon SageMaker model endpoint input data blobs.
	ExternalModelEndpointDataBlobs map[string]*ModelEndpointDataBlob `locationName:"externalModelEndpointDataBlobs" type:"map" sensitive:"true"`
}

// String returns the string representation
func (s GetEventPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventPredictionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.Entities == nil {
		invalidParams.Add(request.NewErrParamRequired("Entities"))
	}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.EventTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTimestamp"))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("EventVariables"))
	}
	if s.EventVariables != nil && len(s.EventVariables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventVariables", 1))
	}
	if s.Entities != nil {
		for i, v := range s.Entities {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entities", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ExternalModelEndpointDataBlobs != nil {
		for i, v := range s.ExternalModelEndpointDataBlobs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExternalModelEndpointDataBlobs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetEventPredictionInput) SetDetectorId(v string) *GetEventPredictionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetEventPredictionInput) SetDetectorVersionId(v string) *GetEventPredictionInput {
	s.DetectorVersionId = &v
	return s
}

// SetEntities sets the Entities field's value.
func (s *GetEventPredictionInput) SetEntities(v []*Entity) *GetEventPredictionInput {
	s.Entities = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *GetEventPredictionInput) SetEventId(v string) *GetEventPredictionInput {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *GetEventPredictionInput) SetEventTimestamp(v string) *GetEventPredictionInput {
	s.EventTimestamp = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *GetEventPredictionInput) SetEventTypeName(v string) *GetEventPredictionInput {
	s.EventTypeName = &v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *GetEventPredictionInput) SetEventVariables(v map[string]*string) *GetEventPredictionInput {
	s.EventVariables = v
	return s
}

// SetExternalModelEndpointDataBlobs sets the ExternalModelEndpointDataBlobs field's value.
func (s *GetEventPredictionInput) SetExternalModelEndpointDataBlobs(v map[string]*ModelEndpointDataBlob) *GetEventPredictionInput {
	s.ExternalModelEndpointDataBlobs = v
	return s
}

type GetEventPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The model scores. Amazon Fraud Detector generates model scores between 0
	// and 1000, where 0 is low fraud risk and 1000 is high fraud risk. Model scores
	// are directly related to the false positive rate (FPR). For example, a score
	// of 600 corresponds to an estimated 10% false positive rate whereas a score
	// of 900 corresponds to an estimated 2% false positive rate.
	ModelScores []*ModelScores `locationName:"modelScores" type:"list"`

	// The results.
	RuleResults []*RuleResult `locationName:"ruleResults" type:"list"`
}

// String returns the string representation
func (s GetEventPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventPredictionOutput) GoString() string {
	return s.String()
}

// SetModelScores sets the ModelScores field's value.
func (s *GetEventPredictionOutput) SetModelScores(v []*ModelScores) *GetEventPredictionOutput {
	s.ModelScores = v
	return s
}

// SetRuleResults sets the RuleResults field's value.
func (s *GetEventPredictionOutput) SetRuleResults(v []*RuleResult) *GetEventPredictionOutput {
	s.RuleResults = v
	return s
}

type GetEventTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEventTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEventTypesInput) SetMaxResults(v int64) *GetEventTypesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEventTypesInput) SetName(v string) *GetEventTypesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEventTypesInput) SetNextToken(v string) *GetEventTypesInput {
	s.NextToken = &v
	return s
}

type GetEventTypesOutput struct {
	_ struct{} `type:"structure"`

	// An array of event types.
	EventTypes []*EventType `locationName:"eventTypes" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEventTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventTypesOutput) GoString() string {
	return s.String()
}

// SetEventTypes sets the EventTypes field's value.
func (s *GetEventTypesOutput) SetEventTypes(v []*EventType) *GetEventTypesOutput {
	s.EventTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEventTypesOutput) SetNextToken(v string) *GetEventTypesOutput {
	s.NextToken = &v
	return s
}

type GetExternalModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The Amazon SageMaker model endpoint.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetExternalModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExternalModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExternalModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExternalModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExternalModelsInput) SetMaxResults(v int64) *GetExternalModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *GetExternalModelsInput) SetModelEndpoint(v string) *GetExternalModelsInput {
	s.ModelEndpoint = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExternalModelsInput) SetNextToken(v string) *GetExternalModelsInput {
	s.NextToken = &v
	return s
}

type GetExternalModelsOutput struct {
	_ struct{} `type:"structure"`

	// Gets the Amazon SageMaker models.
	ExternalModels []*ExternalModel `locationName:"externalModels" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetExternalModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExternalModelsOutput) GoString() string {
	return s.String()
}

// SetExternalModels sets the ExternalModels field's value.
func (s *GetExternalModelsOutput) SetExternalModels(v []*ExternalModel) *GetExternalModelsOutput {
	s.ExternalModels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExternalModelsOutput) SetNextToken(v string) *GetExternalModelsOutput {
	s.NextToken = &v
	return s
}

type GetKMSEncryptionKeyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetKMSEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKMSEncryptionKeyInput) GoString() string {
	return s.String()
}

type GetKMSEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`

	// The KMS encryption key.
	KmsKey *KMSKey `locationName:"kmsKey" type:"structure"`
}

// String returns the string representation
func (s GetKMSEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKMSEncryptionKeyOutput) GoString() string {
	return s.String()
}

// SetKmsKey sets the KmsKey field's value.
func (s *GetKMSEncryptionKeyOutput) SetKmsKey(v *KMSKey) *GetKMSEncryptionKeyOutput {
	s.KmsKey = v
	return s
}

type GetLabelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// The name of the label or labels to get.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLabelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetLabelsInput) SetMaxResults(v int64) *GetLabelsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetLabelsInput) SetName(v string) *GetLabelsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLabelsInput) SetNextToken(v string) *GetLabelsInput {
	s.NextToken = &v
	return s
}

type GetLabelsOutput struct {
	_ struct{} `type:"structure"`

	// An array of labels.
	Labels []*Label `locationName:"labels" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLabelsOutput) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *GetLabelsOutput) SetLabels(v []*Label) *GetLabelsOutput {
	s.Labels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLabelsOutput) SetNextToken(v string) *GetLabelsOutput {
	s.NextToken = &v
	return s
}

type GetModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelVersionInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *GetModelVersionInput) SetModelId(v string) *GetModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelVersionInput) SetModelType(v string) *GetModelVersionInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *GetModelVersionInput) SetModelVersionNumber(v string) *GetModelVersionInput {
	s.ModelVersionNumber = &v
	return s
}

type GetModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The event details.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The model version status.
	Status *string `locationName:"status" type:"string"`

	// The training data schema.
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure"`

	// The training data source.
	TrainingDataSource *string `locationName:"trainingDataSource" type:"string" enum:"TrainingDataSourceEnum"`
}

// String returns the string representation
func (s GetModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetModelVersionOutput) SetArn(v string) *GetModelVersionOutput {
	s.Arn = &v
	return s
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *GetModelVersionOutput) SetExternalEventsDetail(v *ExternalEventsDetail) *GetModelVersionOutput {
	s.ExternalEventsDetail = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelVersionOutput) SetModelId(v string) *GetModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelVersionOutput) SetModelType(v string) *GetModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *GetModelVersionOutput) SetModelVersionNumber(v string) *GetModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetModelVersionOutput) SetStatus(v string) *GetModelVersionOutput {
	s.Status = &v
	return s
}

// SetTrainingDataSchema sets the TrainingDataSchema field's value.
func (s *GetModelVersionOutput) SetTrainingDataSchema(v *TrainingDataSchema) *GetModelVersionOutput {
	s.TrainingDataSchema = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *GetModelVersionOutput) SetTrainingDataSource(v string) *GetModelVersionOutput {
	s.TrainingDataSource = &v
	return s
}

type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetModelsInput) SetMaxResults(v int64) *GetModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelsInput) SetModelId(v string) *GetModelsInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelsInput) SetModelType(v string) *GetModelsInput {
	s.ModelType = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsInput) SetNextToken(v string) *GetModelsInput {
	s.NextToken = &v
	return s
}

type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	// The array of models.
	Models []*Model `locationName:"models" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *GetModelsOutput) SetModels(v []*Model) *GetModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsOutput) SetNextToken(v string) *GetModelsOutput {
	s.NextToken = &v
	return s
}

type GetOutcomesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the outcome or outcomes to get.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetOutcomesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutcomesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutcomesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutcomesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetOutcomesInput) SetMaxResults(v int64) *GetOutcomesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetOutcomesInput) SetName(v string) *GetOutcomesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutcomesInput) SetNextToken(v string) *GetOutcomesInput {
	s.NextToken = &v
	return s
}

type GetOutcomesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The outcomes.
	Outcomes []*Outcome `locationName:"outcomes" type:"list"`
}

// String returns the string representation
func (s GetOutcomesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutcomesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutcomesOutput) SetNextToken(v string) *GetOutcomesOutput {
	s.NextToken = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *GetOutcomesOutput) SetOutcomes(v []*Outcome) *GetOutcomesOutput {
	s.Outcomes = v
	return s
}

type GetRulesInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of rules to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s GetRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRulesInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetRulesInput) SetDetectorId(v string) *GetRulesInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRulesInput) SetMaxResults(v int64) *GetRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRulesInput) SetNextToken(v string) *GetRulesInput {
	s.NextToken = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetRulesInput) SetRuleId(v string) *GetRulesInput {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *GetRulesInput) SetRuleVersion(v string) *GetRulesInput {
	s.RuleVersion = &v
	return s
}

type GetRulesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The details of the requested rule.
	RuleDetails []*RuleDetail `locationName:"ruleDetails" type:"list"`
}

// String returns the string representation
func (s GetRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetRulesOutput) SetNextToken(v string) *GetRulesOutput {
	s.NextToken = &v
	return s
}

// SetRuleDetails sets the RuleDetails field's value.
func (s *GetRulesOutput) SetRuleDetails(v []*RuleDetail) *GetRulesOutput {
	s.RuleDetails = v
	return s
}

type GetVariablesInput struct {
	_ struct{} `type:"structure"`

	// The max size per page determined for the get variable request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The next page token of the get variable request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVariablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVariablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVariablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVariablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetVariablesInput) SetMaxResults(v int64) *GetVariablesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetVariablesInput) SetName(v string) *GetVariablesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVariablesInput) SetNextToken(v string) *GetVariablesInput {
	s.NextToken = &v
	return s
}

type GetVariablesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The names of the variables returned.
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s GetVariablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVariablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetVariablesOutput) SetNextToken(v string) *GetVariablesOutput {
	s.NextToken = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *GetVariablesOutput) SetVariables(v []*Variable) *GetVariablesOutput {
	s.Variables = v
	return s
}

// An exception indicating an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The KMS key details.
type KMSKey struct {
	_ struct{} `type:"structure"`

	// The encryption key ARN.
	KmsEncryptionKeyArn *string `locationName:"kmsEncryptionKeyArn" min:"7" type:"string"`
}

// String returns the string representation
func (s KMSKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSKey) GoString() string {
	return s.String()
}

// SetKmsEncryptionKeyArn sets the KmsEncryptionKeyArn field's value.
func (s *KMSKey) SetKmsEncryptionKeyArn(v string) *KMSKey {
	s.KmsEncryptionKeyArn = &v
	return s
}

// The label details.
type Label struct {
	_ struct{} `type:"structure"`

	// The label ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the event type was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The label description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Timestamp of when the label was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The label name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Label) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Label) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Label) SetArn(v string) *Label {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Label) SetCreatedTime(v string) *Label {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Label) SetDescription(v string) *Label {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Label) SetLastUpdatedTime(v string) *Label {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Label) SetName(v string) *Label {
	s.Name = &v
	return s
}

// The label schema.
type LabelSchema struct {
	_ struct{} `type:"structure"`

	// The label mapper maps the Amazon Fraud Detector supported model classification
	// labels (FRAUD, LEGIT) to the appropriate event type labels. For example,
	// if "FRAUD" and "LEGIT" are Amazon Fraud Detector supported labels, this mapper
	// could be: {"FRAUD" => ["0"], "LEGIT" => ["1"]} or {"FRAUD" => ["false"],
	// "LEGIT" => ["true"]} or {"FRAUD" => ["fraud", "abuse"], "LEGIT" => ["legit",
	// "safe"]}. The value part of the mapper is a list, because you may have multiple
	// label variants from your event type for a single Amazon Fraud Detector label.
	//
	// LabelMapper is a required field
	LabelMapper map[string][]*string `locationName:"labelMapper" type:"map" required:"true"`
}

// String returns the string representation
func (s LabelSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelSchema"}
	if s.LabelMapper == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelMapper"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelMapper sets the LabelMapper field's value.
func (s *LabelSchema) SetLabelMapper(v map[string][]*string) *LabelSchema {
	s.LabelMapper = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The next token from the previous results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN that specifies the resource whose tags you want to list.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The next token for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Model performance metrics data points.
type MetricDataPoint struct {
	_ struct{} `type:"structure"`

	// The false positive rate. This is the percentage of total legitimate events
	// that are incorrectly predicted as fraud.
	Fpr *float64 `locationName:"fpr" type:"float"`

	// The percentage of fraud events correctly predicted as fraudulent as compared
	// to all events predicted as fraudulent.
	Precision *float64 `locationName:"precision" type:"float"`

	// The model threshold that specifies an acceptable fraud capture rate. For
	// example, a threshold of 500 means any model score 500 or above is labeled
	// as fraud.
	Threshold *float64 `locationName:"threshold" type:"float"`

	// The true positive rate. This is the percentage of total fraud the model detects.
	// Also known as capture rate.
	Tpr *float64 `locationName:"tpr" type:"float"`
}

// String returns the string representation
func (s MetricDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDataPoint) GoString() string {
	return s.String()
}

// SetFpr sets the Fpr field's value.
func (s *MetricDataPoint) SetFpr(v float64) *MetricDataPoint {
	s.Fpr = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *MetricDataPoint) SetPrecision(v float64) *MetricDataPoint {
	s.Precision = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *MetricDataPoint) SetThreshold(v float64) *MetricDataPoint {
	s.Threshold = &v
	return s
}

// SetTpr sets the Tpr field's value.
func (s *MetricDataPoint) SetTpr(v float64) *MetricDataPoint {
	s.Tpr = &v
	return s
}

// The model.
type Model struct {
	_ struct{} `type:"structure"`

	// The ARN of the model.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Timestamp of when the model was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the event type.
	EventTypeName *string `locationName:"eventTypeName" type:"string"`

	// Timestamp of last time the model was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Model) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Model) SetArn(v string) *Model {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Model) SetCreatedTime(v string) *Model {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Model) SetDescription(v string) *Model {
	s.Description = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *Model) SetEventTypeName(v string) *Model {
	s.EventTypeName = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Model) SetLastUpdatedTime(v string) *Model {
	s.LastUpdatedTime = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *Model) SetModelId(v string) *Model {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *Model) SetModelType(v string) *Model {
	s.ModelType = &v
	return s
}

// A pre-formed Amazon SageMaker model input you can include if your detector
// version includes an imported Amazon SageMaker model endpoint with pass-through
// input configuration.
type ModelEndpointDataBlob struct {
	_ struct{} `type:"structure"`

	// The byte buffer of the Amazon SageMaker model endpoint input data blob.
	//
	// ByteBuffer is automatically base64 encoded/decoded by the SDK.
	ByteBuffer []byte `locationName:"byteBuffer" type:"blob"`

	// The content type of the Amazon SageMaker model endpoint input data blob.
	ContentType *string `locationName:"contentType" min:"1" type:"string"`
}

// String returns the string representation
func (s ModelEndpointDataBlob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelEndpointDataBlob) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelEndpointDataBlob) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelEndpointDataBlob"}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteBuffer sets the ByteBuffer field's value.
func (s *ModelEndpointDataBlob) SetByteBuffer(v []byte) *ModelEndpointDataBlob {
	s.ByteBuffer = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ModelEndpointDataBlob) SetContentType(v string) *ModelEndpointDataBlob {
	s.ContentType = &v
	return s
}

// The Amazon SageMaker model input configuration.
type ModelInputConfiguration struct {
	_ struct{} `type:"structure"`

	// Template for constructing the CSV input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable-names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	CsvInputTemplate *string `locationName:"csvInputTemplate" type:"string"`

	// The event type name.
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string"`

	// The format of the model input configuration. The format differs depending
	// on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.
	Format *string `locationName:"format" type:"string" enum:"ModelInputDataFormat"`

	// Template for constructing the JSON input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	JsonInputTemplate *string `locationName:"jsonInputTemplate" type:"string"`

	// The event variables.
	//
	// UseEventVariables is a required field
	UseEventVariables *bool `locationName:"useEventVariables" type:"boolean" required:"true"`
}

// String returns the string representation
func (s ModelInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelInputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelInputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelInputConfiguration"}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.UseEventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("UseEventVariables"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvInputTemplate sets the CsvInputTemplate field's value.
func (s *ModelInputConfiguration) SetCsvInputTemplate(v string) *ModelInputConfiguration {
	s.CsvInputTemplate = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *ModelInputConfiguration) SetEventTypeName(v string) *ModelInputConfiguration {
	s.EventTypeName = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ModelInputConfiguration) SetFormat(v string) *ModelInputConfiguration {
	s.Format = &v
	return s
}

// SetJsonInputTemplate sets the JsonInputTemplate field's value.
func (s *ModelInputConfiguration) SetJsonInputTemplate(v string) *ModelInputConfiguration {
	s.JsonInputTemplate = &v
	return s
}

// SetUseEventVariables sets the UseEventVariables field's value.
func (s *ModelInputConfiguration) SetUseEventVariables(v bool) *ModelInputConfiguration {
	s.UseEventVariables = &v
	return s
}

// Provides the Amazon Sagemaker model output configuration.
type ModelOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// A map of CSV index values in the SageMaker response to the Amazon Fraud Detector
	// variables.
	CsvIndexToVariableMap map[string]*string `locationName:"csvIndexToVariableMap" type:"map"`

	// The format of the model output configuration.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"ModelOutputDataFormat"`

	// A map of JSON keys in response from SageMaker to the Amazon Fraud Detector
	// variables.
	JsonKeyToVariableMap map[string]*string `locationName:"jsonKeyToVariableMap" type:"map"`
}

// String returns the string representation
func (s ModelOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelOutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelOutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelOutputConfiguration"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvIndexToVariableMap sets the CsvIndexToVariableMap field's value.
func (s *ModelOutputConfiguration) SetCsvIndexToVariableMap(v map[string]*string) *ModelOutputConfiguration {
	s.CsvIndexToVariableMap = v
	return s
}

// SetFormat sets the Format field's value.
func (s *ModelOutputConfiguration) SetFormat(v string) *ModelOutputConfiguration {
	s.Format = &v
	return s
}

// SetJsonKeyToVariableMap sets the JsonKeyToVariableMap field's value.
func (s *ModelOutputConfiguration) SetJsonKeyToVariableMap(v map[string]*string) *ModelOutputConfiguration {
	s.JsonKeyToVariableMap = v
	return s
}

// The fraud prediction scores.
type ModelScores struct {
	_ struct{} `type:"structure"`

	// The model version.
	ModelVersion *ModelVersion `locationName:"modelVersion" type:"structure"`

	// The model's fraud prediction scores.
	Scores map[string]*float64 `locationName:"scores" type:"map"`
}

// String returns the string representation
func (s ModelScores) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelScores) GoString() string {
	return s.String()
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ModelScores) SetModelVersion(v *ModelVersion) *ModelScores {
	s.ModelVersion = v
	return s
}

// SetScores sets the Scores field's value.
func (s *ModelScores) SetScores(v map[string]*float64) *ModelScores {
	s.Scores = v
	return s
}

// The model version.
type ModelVersion struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelVersion"}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ModelVersion) SetArn(v string) *ModelVersion {
	s.Arn = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *ModelVersion) SetModelId(v string) *ModelVersion {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *ModelVersion) SetModelType(v string) *ModelVersion {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *ModelVersion) SetModelVersionNumber(v string) *ModelVersion {
	s.ModelVersionNumber = &v
	return s
}

// The details of the model version.
type ModelVersionDetail struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp when the model was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The event details.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The timestamp when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The status of the model version.
	Status *string `locationName:"status" type:"string"`

	// The training data schema.
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure"`

	// The model version training data source.
	TrainingDataSource *string `locationName:"trainingDataSource" type:"string" enum:"TrainingDataSourceEnum"`

	// The training results.
	TrainingResult *TrainingResult `locationName:"trainingResult" type:"structure"`
}

// String returns the string representation
func (s ModelVersionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelVersionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ModelVersionDetail) SetArn(v string) *ModelVersionDetail {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ModelVersionDetail) SetCreatedTime(v string) *ModelVersionDetail {
	s.CreatedTime = &v
	return s
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *ModelVersionDetail) SetExternalEventsDetail(v *ExternalEventsDetail) *ModelVersionDetail {
	s.ExternalEventsDetail = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ModelVersionDetail) SetLastUpdatedTime(v string) *ModelVersionDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *ModelVersionDetail) SetModelId(v string) *ModelVersionDetail {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *ModelVersionDetail) SetModelType(v string) *ModelVersionDetail {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *ModelVersionDetail) SetModelVersionNumber(v string) *ModelVersionDetail {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelVersionDetail) SetStatus(v string) *ModelVersionDetail {
	s.Status = &v
	return s
}

// SetTrainingDataSchema sets the TrainingDataSchema field's value.
func (s *ModelVersionDetail) SetTrainingDataSchema(v *TrainingDataSchema) *ModelVersionDetail {
	s.TrainingDataSchema = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *ModelVersionDetail) SetTrainingDataSource(v string) *ModelVersionDetail {
	s.TrainingDataSource = &v
	return s
}

// SetTrainingResult sets the TrainingResult field's value.
func (s *ModelVersionDetail) SetTrainingResult(v *TrainingResult) *ModelVersionDetail {
	s.TrainingResult = v
	return s
}

// The outcome.
type Outcome struct {
	_ struct{} `type:"structure"`

	// The outcome ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp when the outcome was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The timestamp when the outcome was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The outcome name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Outcome) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Outcome) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Outcome) SetArn(v string) *Outcome {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Outcome) SetCreatedTime(v string) *Outcome {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Outcome) SetDescription(v string) *Outcome {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Outcome) SetLastUpdatedTime(v string) *Outcome {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Outcome) SetName(v string) *Outcome {
	s.Name = &v
	return s
}

type PutDetectorInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The name of the event type.
	//
	// EventTypeName is a required field
	EventTypeName *string `locationName:"eventTypeName" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDetectorInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.EventTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypeName"))
	}
	if s.EventTypeName != nil && len(*s.EventTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventTypeName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutDetectorInput) SetDescription(v string) *PutDetectorInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *PutDetectorInput) SetDetectorId(v string) *PutDetectorInput {
	s.DetectorId = &v
	return s
}

// SetEventTypeName sets the EventTypeName field's value.
func (s *PutDetectorInput) SetEventTypeName(v string) *PutDetectorInput {
	s.EventTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutDetectorInput) SetTags(v []*Tag) *PutDetectorInput {
	s.Tags = v
	return s
}

type PutDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDetectorOutput) GoString() string {
	return s.String()
}

type PutEntityTypeInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the entity type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutEntityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEntityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEntityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEntityTypeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutEntityTypeInput) SetDescription(v string) *PutEntityTypeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutEntityTypeInput) SetName(v string) *PutEntityTypeInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutEntityTypeInput) SetTags(v []*Tag) *PutEntityTypeInput {
	s.Tags = v
	return s
}

type PutEntityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEntityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEntityTypeOutput) GoString() string {
	return s.String()
}

type PutEventTypeInput struct {
	_ struct{} `type:"structure"`

	// The description of the event type.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The entity type for the event type. Example entity types: customer, merchant,
	// account.
	//
	// EntityTypes is a required field
	EntityTypes []*string `locationName:"entityTypes" min:"1" type:"list" required:"true"`

	// The event type variables.
	//
	// EventVariables is a required field
	EventVariables []*string `locationName:"eventVariables" min:"1" type:"list" required:"true"`

	// The event type labels.
	Labels []*string `locationName:"labels" type:"list"`

	// The name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutEventTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventTypeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.EntityTypes != nil && len(s.EntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityTypes", 1))
	}
	if s.EventVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("EventVariables"))
	}
	if s.EventVariables != nil && len(s.EventVariables) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventVariables", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutEventTypeInput) SetDescription(v string) *PutEventTypeInput {
	s.Description = &v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *PutEventTypeInput) SetEntityTypes(v []*string) *PutEventTypeInput {
	s.EntityTypes = v
	return s
}

// SetEventVariables sets the EventVariables field's value.
func (s *PutEventTypeInput) SetEventVariables(v []*string) *PutEventTypeInput {
	s.EventVariables = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *PutEventTypeInput) SetLabels(v []*string) *PutEventTypeInput {
	s.Labels = v
	return s
}

// SetName sets the Name field's value.
func (s *PutEventTypeInput) SetName(v string) *PutEventTypeInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutEventTypeInput) SetTags(v []*Tag) *PutEventTypeInput {
	s.Tags = v
	return s
}

type PutEventTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEventTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventTypeOutput) GoString() string {
	return s.String()
}

type PutExternalModelInput struct {
	_ struct{} `type:"structure"`

	// The model endpoint input configuration.
	//
	// InputConfiguration is a required field
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure" required:"true"`

	// The IAM role used to invoke the model endpoint.
	//
	// InvokeModelEndpointRoleArn is a required field
	InvokeModelEndpointRoleArn *string `locationName:"invokeModelEndpointRoleArn" type:"string" required:"true"`

	// The model endpoints name.
	//
	// ModelEndpoint is a required field
	ModelEndpoint *string `locationName:"modelEndpoint" min:"1" type:"string" required:"true"`

	// The model endpoint’s status in Amazon Fraud Detector.
	//
	// ModelEndpointStatus is a required field
	ModelEndpointStatus *string `locationName:"modelEndpointStatus" type:"string" required:"true" enum:"ModelEndpointStatus"`

	// The source of the model.
	//
	// ModelSource is a required field
	ModelSource *string `locationName:"modelSource" type:"string" required:"true" enum:"ModelSource"`

	// The model endpoint output configuration.
	//
	// OutputConfiguration is a required field
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutExternalModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutExternalModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutExternalModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutExternalModelInput"}
	if s.InputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfiguration"))
	}
	if s.InvokeModelEndpointRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InvokeModelEndpointRoleArn"))
	}
	if s.ModelEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpoint"))
	}
	if s.ModelEndpoint != nil && len(*s.ModelEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelEndpoint", 1))
	}
	if s.ModelEndpointStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpointStatus"))
	}
	if s.ModelSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelSource"))
	}
	if s.OutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfiguration"))
	}
	if s.InputConfiguration != nil {
		if err := s.InputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfiguration != nil {
		if err := s.OutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OutputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *PutExternalModelInput) SetInputConfiguration(v *ModelInputConfiguration) *PutExternalModelInput {
	s.InputConfiguration = v
	return s
}

// SetInvokeModelEndpointRoleArn sets the InvokeModelEndpointRoleArn field's value.
func (s *PutExternalModelInput) SetInvokeModelEndpointRoleArn(v string) *PutExternalModelInput {
	s.InvokeModelEndpointRoleArn = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *PutExternalModelInput) SetModelEndpoint(v string) *PutExternalModelInput {
	s.ModelEndpoint = &v
	return s
}

// SetModelEndpointStatus sets the ModelEndpointStatus field's value.
func (s *PutExternalModelInput) SetModelEndpointStatus(v string) *PutExternalModelInput {
	s.ModelEndpointStatus = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *PutExternalModelInput) SetModelSource(v string) *PutExternalModelInput {
	s.ModelSource = &v
	return s
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *PutExternalModelInput) SetOutputConfiguration(v *ModelOutputConfiguration) *PutExternalModelInput {
	s.OutputConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutExternalModelInput) SetTags(v []*Tag) *PutExternalModelInput {
	s.Tags = v
	return s
}

type PutExternalModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutExternalModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutExternalModelOutput) GoString() string {
	return s.String()
}

type PutKMSEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The KMS encryption key ARN.
	//
	// KmsEncryptionKeyArn is a required field
	KmsEncryptionKeyArn *string `locationName:"kmsEncryptionKeyArn" min:"7" type:"string" required:"true"`
}

// String returns the string representation
func (s PutKMSEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKMSEncryptionKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKMSEncryptionKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKMSEncryptionKeyInput"}
	if s.KmsEncryptionKeyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsEncryptionKeyArn"))
	}
	if s.KmsEncryptionKeyArn != nil && len(*s.KmsEncryptionKeyArn) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KmsEncryptionKeyArn", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsEncryptionKeyArn sets the KmsEncryptionKeyArn field's value.
func (s *PutKMSEncryptionKeyInput) SetKmsEncryptionKeyArn(v string) *PutKMSEncryptionKeyInput {
	s.KmsEncryptionKeyArn = &v
	return s
}

type PutKMSEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutKMSEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKMSEncryptionKeyOutput) GoString() string {
	return s.String()
}

type PutLabelInput struct {
	_ struct{} `type:"structure"`

	// The label description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The label name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutLabelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLabelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLabelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLabelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutLabelInput) SetDescription(v string) *PutLabelInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutLabelInput) SetName(v string) *PutLabelInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutLabelInput) SetTags(v []*Tag) *PutLabelInput {
	s.Tags = v
	return s
}

type PutLabelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLabelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLabelOutput) GoString() string {
	return s.String()
}

type PutOutcomeInput struct {
	_ struct{} `type:"structure"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the outcome.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutOutcomeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOutcomeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOutcomeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOutcomeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutOutcomeInput) SetDescription(v string) *PutOutcomeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutOutcomeInput) SetName(v string) *PutOutcomeInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutOutcomeInput) SetTags(v []*Tag) *PutOutcomeInput {
	s.Tags = v
	return s
}

type PutOutcomeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutOutcomeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOutcomeOutput) GoString() string {
	return s.String()
}

// An exception indicating the specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// The detector for which the rule is associated.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// The rule version.
	//
	// RuleVersion is a required field
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *Rule) SetDetectorId(v string) *Rule {
	s.DetectorId = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *Rule) SetRuleId(v string) *Rule {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *Rule) SetRuleVersion(v string) *Rule {
	s.RuleVersion = &v
	return s
}

// The details of the rule.
type RuleDetail struct {
	_ struct{} `type:"structure"`

	// The rule ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The timestamp of when the rule was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector for which the rule is associated.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The rule expression.
	Expression *string `locationName:"expression" min:"1" type:"string" sensitive:"true"`

	// The rule language.
	Language *string `locationName:"language" type:"string" enum:"Language"`

	// Timestamp of the last time the rule was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The rule outcomes.
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s RuleDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RuleDetail) SetArn(v string) *RuleDetail {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RuleDetail) SetCreatedTime(v string) *RuleDetail {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuleDetail) SetDescription(v string) *RuleDetail {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *RuleDetail) SetDetectorId(v string) *RuleDetail {
	s.DetectorId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *RuleDetail) SetExpression(v string) *RuleDetail {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *RuleDetail) SetLanguage(v string) *RuleDetail {
	s.Language = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *RuleDetail) SetLastUpdatedTime(v string) *RuleDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *RuleDetail) SetOutcomes(v []*string) *RuleDetail {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleDetail) SetRuleId(v string) *RuleDetail {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *RuleDetail) SetRuleVersion(v string) *RuleDetail {
	s.RuleVersion = &v
	return s
}

// The rule results.
type RuleResult struct {
	_ struct{} `type:"structure"`

	// The outcomes of the matched rule, based on the rule execution mode.
	Outcomes []*string `locationName:"outcomes" type:"list"`

	// The rule ID that was matched, based on the rule execution mode.
	RuleId *string `locationName:"ruleId" type:"string"`
}

// String returns the string representation
func (s RuleResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleResult) GoString() string {
	return s.String()
}

// SetOutcomes sets the Outcomes field's value.
func (s *RuleResult) SetOutcomes(v []*string) *RuleResult {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleResult) SetRuleId(v string) *RuleResult {
	s.RuleId = &v
	return s
}

// A key and value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// A value assigned to a tag key.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// The tags to assign to the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An exception indicating a throttling error.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The training data schema.
type TrainingDataSchema struct {
	_ struct{} `type:"structure"`

	// The label schema.
	//
	// LabelSchema is a required field
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure" required:"true"`

	// The training data schema variables.
	//
	// ModelVariables is a required field
	ModelVariables []*string `locationName:"modelVariables" type:"list" required:"true"`
}

// String returns the string representation
func (s TrainingDataSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrainingDataSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingDataSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrainingDataSchema"}
	if s.LabelSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelSchema"))
	}
	if s.ModelVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVariables"))
	}
	if s.LabelSchema != nil {
		if err := s.LabelSchema.Validate(); err != nil {
			invalidParams.AddNested("LabelSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelSchema sets the LabelSchema field's value.
func (s *TrainingDataSchema) SetLabelSchema(v *LabelSchema) *TrainingDataSchema {
	s.LabelSchema = v
	return s
}

// SetModelVariables sets the ModelVariables field's value.
func (s *TrainingDataSchema) SetModelVariables(v []*string) *TrainingDataSchema {
	s.ModelVariables = v
	return s
}

// The training metric details.
type TrainingMetrics struct {
	_ struct{} `type:"structure"`

	// The area under the curve. This summarizes true positive rate (TPR) and false
	// positive rate (FPR) across all possible model score thresholds. A model with
	// no predictive power has an AUC of 0.5, whereas a perfect model has a score
	// of 1.0.
	Auc *float64 `locationName:"auc" type:"float"`

	// The data points details.
	MetricDataPoints []*MetricDataPoint `locationName:"metricDataPoints" type:"list"`
}

// String returns the string representation
func (s TrainingMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrainingMetrics) GoString() string {
	return s.String()
}

// SetAuc sets the Auc field's value.
func (s *TrainingMetrics) SetAuc(v float64) *TrainingMetrics {
	s.Auc = &v
	return s
}

// SetMetricDataPoints sets the MetricDataPoints field's value.
func (s *TrainingMetrics) SetMetricDataPoints(v []*MetricDataPoint) *TrainingMetrics {
	s.MetricDataPoints = v
	return s
}

// The training result details.
type TrainingResult struct {
	_ struct{} `type:"structure"`

	// The validation metrics.
	DataValidationMetrics *DataValidationMetrics `locationName:"dataValidationMetrics" type:"structure"`

	// The training metric details.
	TrainingMetrics *TrainingMetrics `locationName:"trainingMetrics" type:"structure"`
}

// String returns the string representation
func (s TrainingResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrainingResult) GoString() string {
	return s.String()
}

// SetDataValidationMetrics sets the DataValidationMetrics field's value.
func (s *TrainingResult) SetDataValidationMetrics(v *DataValidationMetrics) *TrainingResult {
	s.DataValidationMetrics = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *TrainingResult) SetTrainingMetrics(v *TrainingMetrics) *TrainingResult {
	s.TrainingMetrics = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which to remove the tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// The resource ARN.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The parent detector ID for the detector version you want to update.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The Amazon SageMaker model endpoints to include in the detector version.
	//
	// ExternalModelEndpoints is a required field
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list" required:"true"`

	// The model versions to include in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rule execution mode to add to the detector.
	//
	// If you specify FIRST_MATCHED, Amazon Fraud Detector evaluates rules sequentially,
	// first to last, stopping at the first matched rule. Amazon Fraud dectector
	// then provides the outcomes for that single rule.
	//
	// If you specifiy ALL_MATCHED, Amazon Fraud Detector evaluates all rules and
	// returns the outcomes for all matched rules. You can define and edit the rule
	// mode at the detector version level, when it is in draft status.
	//
	// The default behavior is FIRST_MATCHED.
	RuleExecutionMode *string `locationName:"ruleExecutionMode" type:"string" enum:"RuleExecutionMode"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.ExternalModelEndpoints == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalModelEndpoints"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDetectorVersionInput) SetDescription(v string) *UpdateDetectorVersionInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionInput) SetDetectorId(v string) *UpdateDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionInput) SetDetectorVersionId(v string) *UpdateDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *UpdateDetectorVersionInput) SetExternalModelEndpoints(v []*string) *UpdateDetectorVersionInput {
	s.ExternalModelEndpoints = v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *UpdateDetectorVersionInput) SetModelVersions(v []*ModelVersion) *UpdateDetectorVersionInput {
	s.ModelVersions = v
	return s
}

// SetRuleExecutionMode sets the RuleExecutionMode field's value.
func (s *UpdateDetectorVersionInput) SetRuleExecutionMode(v string) *UpdateDetectorVersionInput {
	s.RuleExecutionMode = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateDetectorVersionInput) SetRules(v []*Rule) *UpdateDetectorVersionInput {
	s.Rules = v
	return s
}

type UpdateDetectorVersionMetadataInput struct {
	_ struct{} `type:"structure"`

	// The description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorVersionMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionMetadataInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDescription(v string) *UpdateDetectorVersionMetadataInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDetectorId(v string) *UpdateDetectorVersionMetadataInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDetectorVersionId(v string) *UpdateDetectorVersionMetadataInput {
	s.DetectorVersionId = &v
	return s
}

type UpdateDetectorVersionMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionMetadataOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The new status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s UpdateDetectorVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionStatusInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionStatusInput) SetDetectorId(v string) *UpdateDetectorVersionStatusInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionStatusInput) SetDetectorVersionId(v string) *UpdateDetectorVersionStatusInput {
	s.DetectorVersionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDetectorVersionStatusInput) SetStatus(v string) *UpdateDetectorVersionStatusInput {
	s.Status = &v
	return s
}

type UpdateDetectorVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionStatusOutput) GoString() string {
	return s.String()
}

type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// The new model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`
}

// String returns the string representation
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateModelInput) SetDescription(v string) *UpdateModelInput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelInput) SetModelId(v string) *UpdateModelInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelInput) SetModelType(v string) *UpdateModelInput {
	s.ModelType = &v
	return s
}

type UpdateModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelOutput) GoString() string {
	return s.String()
}

type UpdateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The event details.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The major version number.
	//
	// MajorVersionNumber is a required field
	MajorVersionNumber *string `locationName:"majorVersionNumber" min:"1" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// A collection of key and value pairs.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s UpdateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelVersionInput"}
	if s.MajorVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersionNumber"))
	}
	if s.MajorVersionNumber != nil && len(*s.MajorVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersionNumber", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ExternalEventsDetail != nil {
		if err := s.ExternalEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("ExternalEventsDetail", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalEventsDetail sets the ExternalEventsDetail field's value.
func (s *UpdateModelVersionInput) SetExternalEventsDetail(v *ExternalEventsDetail) *UpdateModelVersionInput {
	s.ExternalEventsDetail = v
	return s
}

// SetMajorVersionNumber sets the MajorVersionNumber field's value.
func (s *UpdateModelVersionInput) SetMajorVersionNumber(v string) *UpdateModelVersionInput {
	s.MajorVersionNumber = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionInput) SetModelId(v string) *UpdateModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionInput) SetModelType(v string) *UpdateModelVersionInput {
	s.ModelType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateModelVersionInput) SetTags(v []*Tag) *UpdateModelVersionInput {
	s.Tags = v
	return s
}

type UpdateModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version number of the model version updated.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string"`

	// The status of the updated model version.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s UpdateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelVersionOutput) GoString() string {
	return s.String()
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionOutput) SetModelId(v string) *UpdateModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionOutput) SetModelType(v string) *UpdateModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *UpdateModelVersionOutput) SetModelVersionNumber(v string) *UpdateModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateModelVersionOutput) SetStatus(v string) *UpdateModelVersionOutput {
	s.Status = &v
	return s
}

type UpdateModelVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The model ID of the model version to update.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"3" type:"string" required:"true"`

	// The model version status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ModelVersionStatus"`
}

// String returns the string representation
func (s UpdateModelVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelVersionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelVersionStatusInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 3))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionStatusInput) SetModelId(v string) *UpdateModelVersionStatusInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionStatusInput) SetModelType(v string) *UpdateModelVersionStatusInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *UpdateModelVersionStatusInput) SetModelVersionNumber(v string) *UpdateModelVersionStatusInput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateModelVersionStatusInput) SetStatus(v string) *UpdateModelVersionStatusInput {
	s.Status = &v
	return s
}

type UpdateModelVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateModelVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelVersionStatusOutput) GoString() string {
	return s.String()
}

type UpdateRuleMetadataInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuleMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleMetadataInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleMetadataInput) SetDescription(v string) *UpdateRuleMetadataInput {
	s.Description = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleMetadataInput) SetRule(v *Rule) *UpdateRuleMetadataInput {
	s.Rule = v
	return s
}

type UpdateRuleMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRuleMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleMetadataOutput) GoString() string {
	return s.String()
}

type UpdateRuleVersionInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The rule expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true" sensitive:"true"`

	// The language.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"Language"`

	// The outcomes.
	//
	// Outcomes is a required field
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`

	// The tags to assign to the rule version.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s UpdateRuleVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Outcomes == nil {
		invalidParams.Add(request.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outcomes", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleVersionInput) SetDescription(v string) *UpdateRuleVersionInput {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *UpdateRuleVersionInput) SetExpression(v string) *UpdateRuleVersionInput {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *UpdateRuleVersionInput) SetLanguage(v string) *UpdateRuleVersionInput {
	s.Language = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *UpdateRuleVersionInput) SetOutcomes(v []*string) *UpdateRuleVersionInput {
	s.Outcomes = v
	return s
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleVersionInput) SetRule(v *Rule) *UpdateRuleVersionInput {
	s.Rule = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateRuleVersionInput) SetTags(v []*Tag) *UpdateRuleVersionInput {
	s.Tags = v
	return s
}

type UpdateRuleVersionOutput struct {
	_ struct{} `type:"structure"`

	// The new rule version that was created.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation
func (s UpdateRuleVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleVersionOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleVersionOutput) SetRule(v *Rule) *UpdateRuleVersionOutput {
	s.Rule = v
	return s
}

type UpdateVariableInput struct {
	_ struct{} `type:"structure"`

	// The new default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The new description.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The variable type. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s UpdateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVariableInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *UpdateVariableInput) SetDefaultValue(v string) *UpdateVariableInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateVariableInput) SetDescription(v string) *UpdateVariableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVariableInput) SetName(v string) *UpdateVariableInput {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *UpdateVariableInput) SetVariableType(v string) *UpdateVariableInput {
	s.VariableType = &v
	return s
}

type UpdateVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVariableOutput) GoString() string {
	return s.String()
}

// An exception indicating a specified value is not allowed.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The ARN of the variable.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time when the variable was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The data source of the variable.
	DataSource *string `locationName:"dataSource" type:"string" enum:"DataSource"`

	// The data type of the variable. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	DataType *string `locationName:"dataType" type:"string" enum:"DataType"`

	// The default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable.
	Description *string `locationName:"description" type:"string"`

	// The time when variable was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The variable type of the variable.
	//
	// Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 |
	// BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE
	// | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS |
	// FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID
	// | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1
	// | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME
	// | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Variable) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Variable) SetArn(v string) *Variable {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Variable) SetCreatedTime(v string) *Variable {
	s.CreatedTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *Variable) SetDataSource(v string) *Variable {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Variable) SetDataType(v string) *Variable {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *Variable) SetDefaultValue(v string) *Variable {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Variable) SetDescription(v string) *Variable {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Variable) SetLastUpdatedTime(v string) *Variable {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Variable) SetName(v string) *Variable {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *Variable) SetVariableType(v string) *Variable {
	s.VariableType = &v
	return s
}

// A variable in the list of variables for the batch create variable request.
type VariableEntry struct {
	_ struct{} `type:"structure"`

	// The data source of the variable.
	DataSource *string `locationName:"dataSource" type:"string"`

	// The data type of the variable.
	DataType *string `locationName:"dataType" type:"string"`

	// The default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The type of the variable. For more information see Variable types (https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
	//
	// Valid Values: AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 |
	// BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE
	// | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS |
	// FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID
	// | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1
	// | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME
	// | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s VariableEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VariableEntry) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *VariableEntry) SetDataSource(v string) *VariableEntry {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *VariableEntry) SetDataType(v string) *VariableEntry {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *VariableEntry) SetDefaultValue(v string) *VariableEntry {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *VariableEntry) SetDescription(v string) *VariableEntry {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *VariableEntry) SetName(v string) *VariableEntry {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *VariableEntry) SetVariableType(v string) *VariableEntry {
	s.VariableType = &v
	return s
}

const (
	// DataSourceEvent is a DataSource enum value
	DataSourceEvent = "EVENT"

	// DataSourceModelScore is a DataSource enum value
	DataSourceModelScore = "MODEL_SCORE"

	// DataSourceExternalModelScore is a DataSource enum value
	DataSourceExternalModelScore = "EXTERNAL_MODEL_SCORE"
)

// DataSource_Values returns all elements of the DataSource enum
func DataSource_Values() []string {
	return []string{
		DataSourceEvent,
		DataSourceModelScore,
		DataSourceExternalModelScore,
	}
}

const (
	// DataTypeString is a DataType enum value
	DataTypeString = "STRING"

	// DataTypeInteger is a DataType enum value
	DataTypeInteger = "INTEGER"

	// DataTypeFloat is a DataType enum value
	DataTypeFloat = "FLOAT"

	// DataTypeBoolean is a DataType enum value
	DataTypeBoolean = "BOOLEAN"
)

// DataType_Values returns all elements of the DataType enum
func DataType_Values() []string {
	return []string{
		DataTypeString,
		DataTypeInteger,
		DataTypeFloat,
		DataTypeBoolean,
	}
}

const (
	// DetectorVersionStatusDraft is a DetectorVersionStatus enum value
	DetectorVersionStatusDraft = "DRAFT"

	// DetectorVersionStatusActive is a DetectorVersionStatus enum value
	DetectorVersionStatusActive = "ACTIVE"

	// DetectorVersionStatusInactive is a DetectorVersionStatus enum value
	DetectorVersionStatusInactive = "INACTIVE"
)

// DetectorVersionStatus_Values returns all elements of the DetectorVersionStatus enum
func DetectorVersionStatus_Values() []string {
	return []string{
		DetectorVersionStatusDraft,
		DetectorVersionStatusActive,
		DetectorVersionStatusInactive,
	}
}

const (
	// LanguageDetectorpl is a Language enum value
	LanguageDetectorpl = "DETECTORPL"
)

// Language_Values returns all elements of the Language enum
func Language_Values() []string {
	return []string{
		LanguageDetectorpl,
	}
}

const (
	// ModelEndpointStatusAssociated is a ModelEndpointStatus enum value
	ModelEndpointStatusAssociated = "ASSOCIATED"

	// ModelEndpointStatusDissociated is a ModelEndpointStatus enum value
	ModelEndpointStatusDissociated = "DISSOCIATED"
)

// ModelEndpointStatus_Values returns all elements of the ModelEndpointStatus enum
func ModelEndpointStatus_Values() []string {
	return []string{
		ModelEndpointStatusAssociated,
		ModelEndpointStatusDissociated,
	}
}

const (
	// ModelInputDataFormatTextCsv is a ModelInputDataFormat enum value
	ModelInputDataFormatTextCsv = "TEXT_CSV"

	// ModelInputDataFormatApplicationJson is a ModelInputDataFormat enum value
	ModelInputDataFormatApplicationJson = "APPLICATION_JSON"
)

// ModelInputDataFormat_Values returns all elements of the ModelInputDataFormat enum
func ModelInputDataFormat_Values() []string {
	return []string{
		ModelInputDataFormatTextCsv,
		ModelInputDataFormatApplicationJson,
	}
}

const (
	// ModelOutputDataFormatTextCsv is a ModelOutputDataFormat enum value
	ModelOutputDataFormatTextCsv = "TEXT_CSV"

	// ModelOutputDataFormatApplicationJsonlines is a ModelOutputDataFormat enum value
	ModelOutputDataFormatApplicationJsonlines = "APPLICATION_JSONLINES"
)

// ModelOutputDataFormat_Values returns all elements of the ModelOutputDataFormat enum
func ModelOutputDataFormat_Values() []string {
	return []string{
		ModelOutputDataFormatTextCsv,
		ModelOutputDataFormatApplicationJsonlines,
	}
}

const (
	// ModelSourceSagemaker is a ModelSource enum value
	ModelSourceSagemaker = "SAGEMAKER"
)

// ModelSource_Values returns all elements of the ModelSource enum
func ModelSource_Values() []string {
	return []string{
		ModelSourceSagemaker,
	}
}

const (
	// ModelTypeEnumOnlineFraudInsights is a ModelTypeEnum enum value
	ModelTypeEnumOnlineFraudInsights = "ONLINE_FRAUD_INSIGHTS"
)

// ModelTypeEnum_Values returns all elements of the ModelTypeEnum enum
func ModelTypeEnum_Values() []string {
	return []string{
		ModelTypeEnumOnlineFraudInsights,
	}
}

const (
	// ModelVersionStatusActive is a ModelVersionStatus enum value
	ModelVersionStatusActive = "ACTIVE"

	// ModelVersionStatusInactive is a ModelVersionStatus enum value
	ModelVersionStatusInactive = "INACTIVE"
)

// ModelVersionStatus_Values returns all elements of the ModelVersionStatus enum
func ModelVersionStatus_Values() []string {
	return []string{
		ModelVersionStatusActive,
		ModelVersionStatusInactive,
	}
}

const (
	// RuleExecutionModeAllMatched is a RuleExecutionMode enum value
	RuleExecutionModeAllMatched = "ALL_MATCHED"

	// RuleExecutionModeFirstMatched is a RuleExecutionMode enum value
	RuleExecutionModeFirstMatched = "FIRST_MATCHED"
)

// RuleExecutionMode_Values returns all elements of the RuleExecutionMode enum
func RuleExecutionMode_Values() []string {
	return []string{
		RuleExecutionModeAllMatched,
		RuleExecutionModeFirstMatched,
	}
}

const (
	// TrainingDataSourceEnumExternalEvents is a TrainingDataSourceEnum enum value
	TrainingDataSourceEnumExternalEvents = "EXTERNAL_EVENTS"
)

// TrainingDataSourceEnum_Values returns all elements of the TrainingDataSourceEnum enum
func TrainingDataSourceEnum_Values() []string {
	return []string{
		TrainingDataSourceEnumExternalEvents,
	}
}
