// Code generated by protoc-gen-go.
// source: google/logging/v2/logging_config.proto
// DO NOT EDIT!

package v2

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/googleapis/proto-client-go/api"
import google_protobuf4 "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Available log entry formats. Log entries can be written to Cloud
// Logging in either format and can be exported in either format.
// Version 2 is the preferred format.
type LogSink_VersionFormat int32

const (
	// An unspecified version format will default to V2.
	LogSink_VERSION_FORMAT_UNSPECIFIED LogSink_VersionFormat = 0
	// `LogEntry` version 2 format.
	LogSink_V2 LogSink_VersionFormat = 1
	// `LogEntry` version 1 format.
	LogSink_V1 LogSink_VersionFormat = 2
)

var LogSink_VersionFormat_name = map[int32]string{
	0: "VERSION_FORMAT_UNSPECIFIED",
	1: "V2",
	2: "V1",
}
var LogSink_VersionFormat_value = map[string]int32{
	"VERSION_FORMAT_UNSPECIFIED": 0,
	"V2": 1,
	"V1": 2,
}

func (x LogSink_VersionFormat) String() string {
	return proto.EnumName(LogSink_VersionFormat_name, int32(x))
}
func (LogSink_VersionFormat) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// Describes a sink used to export log entries outside Cloud Logging.
type LogSink struct {
	// Required. The client-assigned sink identifier. Example:
	// `"my-severe-errors-to-pubsub"`.
	// Sink identifiers are limited to 1000 characters
	// and can include only the following characters: `A-Z`, `a-z`,
	// `0-9`, and the special characters `_-.`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The export destination. See
	// [Exporting Logs With Sinks](/logging/docs/api/tasks/exporting-logs).
	// Examples: `"storage.googleapis.com/a-bucket"`,
	// `"bigquery.googleapis.com/projects/a-project-id/datasets/a-dataset"`.
	Destination string `protobuf:"bytes,3,opt,name=destination" json:"destination,omitempty"`
	// An [advanced logs filter](/logging/docs/view/advanced_filters)
	// that defines the log entries to be exported.  The filter must be
	// consistent with the log entry format designed by the
	// `outputVersionFormat` parameter, regardless of the format of the
	// log entry that was originally written to Cloud Logging.
	// Example: `"logName:syslog AND severity>=ERROR"`.
	Filter string `protobuf:"bytes,5,opt,name=filter" json:"filter,omitempty"`
	// The log entry version used when exporting log entries from this
	// sink.  This version does not have to correspond to the version of
	// the log entry when it was written to Cloud Logging.
	OutputVersionFormat LogSink_VersionFormat `protobuf:"varint,6,opt,name=output_version_format,json=outputVersionFormat,enum=google.logging.v2.LogSink_VersionFormat" json:"output_version_format,omitempty"`
}

func (m *LogSink) Reset()                    { *m = LogSink{} }
func (m *LogSink) String() string            { return proto.CompactTextString(m) }
func (*LogSink) ProtoMessage()               {}
func (*LogSink) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// The parameters to `ListSinks`.
type ListSinksRequest struct {
	// Required. The resource name of the project containing the sinks.
	// Example: `"projects/my-logging-project"`, `"projects/01234567890"`.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName" json:"project_name,omitempty"`
	// Optional. If the `pageToken` request parameter is supplied, then the next
	// page of results in the set are retrieved.  The `pageToken` parameter must
	// be set with the value of the `nextPageToken` result parameter from the
	// previous request. The value of `projectName` must be the same as in the
	// previous request.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The maximum number of results to return from this request.  Fewer
	// results might be returned. You must check for the `nextPageToken` result to
	// determine if additional results are available, which you can retrieve by
	// passing the `nextPageToken` value in the `pageToken` parameter to the next
	// request.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListSinksRequest) Reset()                    { *m = ListSinksRequest{} }
func (m *ListSinksRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSinksRequest) ProtoMessage()               {}
func (*ListSinksRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

// Result returned from `ListSinks`.
type ListSinksResponse struct {
	// A list of sinks.
	Sinks []*LogSink `protobuf:"bytes,1,rep,name=sinks" json:"sinks,omitempty"`
	// If there are more results than were returned, then `nextPageToken` is
	// given a value in the response.  To get the next batch of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSinksResponse) Reset()                    { *m = ListSinksResponse{} }
func (m *ListSinksResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSinksResponse) ProtoMessage()               {}
func (*ListSinksResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ListSinksResponse) GetSinks() []*LogSink {
	if m != nil {
		return m.Sinks
	}
	return nil
}

// The parameters to `GetSink`.
type GetSinkRequest struct {
	// The resource name of the sink to return.
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName" json:"sink_name,omitempty"`
}

func (m *GetSinkRequest) Reset()                    { *m = GetSinkRequest{} }
func (m *GetSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSinkRequest) ProtoMessage()               {}
func (*GetSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

// The parameters to `CreateSink`.
type CreateSinkRequest struct {
	// The resource name of the project in which to create the sink.
	// Example: `"projects/my-project-id"`.
	//
	// The new sink must be provided in the request.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName" json:"project_name,omitempty"`
	// The new sink, which must not have an identifier that already
	// exists.
	Sink *LogSink `protobuf:"bytes,2,opt,name=sink" json:"sink,omitempty"`
}

func (m *CreateSinkRequest) Reset()                    { *m = CreateSinkRequest{} }
func (m *CreateSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSinkRequest) ProtoMessage()               {}
func (*CreateSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *CreateSinkRequest) GetSink() *LogSink {
	if m != nil {
		return m.Sink
	}
	return nil
}

// The parameters to `UpdateSink`.
type UpdateSinkRequest struct {
	// The resource name of the sink to update.
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	//
	// The updated sink must be provided in the request and have the
	// same name that is specified in `sinkName`.  If the sink does not
	// exist, it is created.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName" json:"sink_name,omitempty"`
	// The updated sink, whose name must be the same as the sink
	// identifier in `sinkName`.  If `sinkName` does not exist, then
	// this method creates a new sink.
	Sink *LogSink `protobuf:"bytes,2,opt,name=sink" json:"sink,omitempty"`
}

func (m *UpdateSinkRequest) Reset()                    { *m = UpdateSinkRequest{} }
func (m *UpdateSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateSinkRequest) ProtoMessage()               {}
func (*UpdateSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *UpdateSinkRequest) GetSink() *LogSink {
	if m != nil {
		return m.Sink
	}
	return nil
}

// The parameters to `DeleteSink`.
type DeleteSinkRequest struct {
	// The resource name of the sink to delete.
	// Example: `"projects/my-project-id/sinks/my-sink-id"`.
	SinkName string `protobuf:"bytes,1,opt,name=sink_name,json=sinkName" json:"sink_name,omitempty"`
}

func (m *DeleteSinkRequest) Reset()                    { *m = DeleteSinkRequest{} }
func (m *DeleteSinkRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSinkRequest) ProtoMessage()               {}
func (*DeleteSinkRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func init() {
	proto.RegisterType((*LogSink)(nil), "google.logging.v2.LogSink")
	proto.RegisterType((*ListSinksRequest)(nil), "google.logging.v2.ListSinksRequest")
	proto.RegisterType((*ListSinksResponse)(nil), "google.logging.v2.ListSinksResponse")
	proto.RegisterType((*GetSinkRequest)(nil), "google.logging.v2.GetSinkRequest")
	proto.RegisterType((*CreateSinkRequest)(nil), "google.logging.v2.CreateSinkRequest")
	proto.RegisterType((*UpdateSinkRequest)(nil), "google.logging.v2.UpdateSinkRequest")
	proto.RegisterType((*DeleteSinkRequest)(nil), "google.logging.v2.DeleteSinkRequest")
	proto.RegisterEnum("google.logging.v2.LogSink_VersionFormat", LogSink_VersionFormat_name, LogSink_VersionFormat_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion3

// Client API for ConfigServiceV2 service

type ConfigServiceV2Client interface {
	// Lists sinks.
	ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Creates a sink.
	CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Creates or updates a sink.
	UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error)
	// Deletes a sink.
	DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error)
}

type configServiceV2Client struct {
	cc *grpc.ClientConn
}

func NewConfigServiceV2Client(cc *grpc.ClientConn) ConfigServiceV2Client {
	return &configServiceV2Client{cc}
}

func (c *configServiceV2Client) ListSinks(ctx context.Context, in *ListSinksRequest, opts ...grpc.CallOption) (*ListSinksResponse, error) {
	out := new(ListSinksResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/ListSinks", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) GetSink(ctx context.Context, in *GetSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/GetSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) CreateSink(ctx context.Context, in *CreateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/CreateSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) UpdateSink(ctx context.Context, in *UpdateSinkRequest, opts ...grpc.CallOption) (*LogSink, error) {
	out := new(LogSink)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/UpdateSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configServiceV2Client) DeleteSink(ctx context.Context, in *DeleteSinkRequest, opts ...grpc.CallOption) (*google_protobuf4.Empty, error) {
	out := new(google_protobuf4.Empty)
	err := grpc.Invoke(ctx, "/google.logging.v2.ConfigServiceV2/DeleteSink", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ConfigServiceV2 service

type ConfigServiceV2Server interface {
	// Lists sinks.
	ListSinks(context.Context, *ListSinksRequest) (*ListSinksResponse, error)
	// Gets a sink.
	GetSink(context.Context, *GetSinkRequest) (*LogSink, error)
	// Creates a sink.
	CreateSink(context.Context, *CreateSinkRequest) (*LogSink, error)
	// Creates or updates a sink.
	UpdateSink(context.Context, *UpdateSinkRequest) (*LogSink, error)
	// Deletes a sink.
	DeleteSink(context.Context, *DeleteSinkRequest) (*google_protobuf4.Empty, error)
}

func RegisterConfigServiceV2Server(s *grpc.Server, srv ConfigServiceV2Server) {
	s.RegisterService(&_ConfigServiceV2_serviceDesc, srv)
}

func _ConfigServiceV2_ListSinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/ListSinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).ListSinks(ctx, req.(*ListSinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_GetSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).GetSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/GetSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).GetSink(ctx, req.(*GetSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_CreateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/CreateSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).CreateSink(ctx, req.(*CreateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_UpdateSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/UpdateSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).UpdateSink(ctx, req.(*UpdateSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigServiceV2_DeleteSink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.ConfigServiceV2/DeleteSink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServiceV2Server).DeleteSink(ctx, req.(*DeleteSinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfigServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.ConfigServiceV2",
	HandlerType: (*ConfigServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSinks",
			Handler:    _ConfigServiceV2_ListSinks_Handler,
		},
		{
			MethodName: "GetSink",
			Handler:    _ConfigServiceV2_GetSink_Handler,
		},
		{
			MethodName: "CreateSink",
			Handler:    _ConfigServiceV2_CreateSink_Handler,
		},
		{
			MethodName: "UpdateSink",
			Handler:    _ConfigServiceV2_UpdateSink_Handler,
		},
		{
			MethodName: "DeleteSink",
			Handler:    _ConfigServiceV2_DeleteSink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: fileDescriptor1,
}

func init() { proto.RegisterFile("google/logging/v2/logging_config.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 690 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x55, 0xdf, 0x4e, 0x13, 0x4f,
	0x14, 0xfe, 0x6d, 0xa1, 0x05, 0x0e, 0x3f, 0xa0, 0x1d, 0x03, 0x69, 0x16, 0xff, 0xc0, 0x6a, 0xb0,
	0x92, 0xb0, 0x5b, 0xd6, 0xe8, 0x85, 0x89, 0x31, 0x02, 0xc5, 0x90, 0x20, 0x90, 0x2d, 0xf4, 0x82,
	0x98, 0xac, 0xdb, 0x32, 0x5d, 0x47, 0xba, 0x3b, 0x4b, 0x77, 0xda, 0x88, 0xc4, 0x1b, 0x13, 0x8d,
	0xf7, 0x3e, 0x83, 0x4f, 0xe4, 0x2b, 0xf8, 0x0c, 0x5e, 0x3b, 0x3b, 0xb3, 0xa5, 0x4b, 0x5b, 0x37,
	0xf5, 0xaa, 0x3b, 0xe7, 0x7c, 0x33, 0xdf, 0x77, 0xbe, 0x73, 0x3a, 0x03, 0x6b, 0x2e, 0xa5, 0x6e,
	0x0b, 0x1b, 0x2d, 0xea, 0xba, 0xc4, 0x77, 0x8d, 0xae, 0xd9, 0xfb, 0xb4, 0x1b, 0xd4, 0x6f, 0x12,
	0x57, 0x0f, 0xda, 0x94, 0x51, 0x54, 0x90, 0x38, 0x3d, 0x4e, 0xea, 0x5d, 0x53, 0xbd, 0x1d, 0x6f,
	0x75, 0x02, 0x62, 0x38, 0xbe, 0x4f, 0x99, 0xc3, 0x08, 0xf5, 0x43, 0xb9, 0x41, 0x5d, 0x8e, 0xb3,
	0x62, 0x55, 0xef, 0x34, 0x0d, 0xec, 0x05, 0xec, 0x32, 0x4e, 0xde, 0x1b, 0x4c, 0x32, 0xe2, 0xe1,
	0x90, 0x39, 0x5e, 0x20, 0x01, 0xda, 0x6f, 0x05, 0xa6, 0xf6, 0xa9, 0x5b, 0x25, 0xfe, 0x39, 0x42,
	0x30, 0xe9, 0x3b, 0x1e, 0x2e, 0x2a, 0x2b, 0x4a, 0x69, 0xc6, 0x12, 0xdf, 0x68, 0x05, 0x66, 0xcf,
	0xf8, 0x06, 0xe2, 0x0b, 0xce, 0xe2, 0x84, 0x48, 0x25, 0x43, 0x68, 0x09, 0x72, 0x4d, 0xd2, 0x62,
	0xb8, 0x5d, 0xcc, 0x8a, 0x64, 0xbc, 0x42, 0x6f, 0x60, 0x91, 0x76, 0x58, 0xd0, 0x61, 0x76, 0x17,
	0xb7, 0x43, 0x8e, 0xb4, 0x9b, 0xb4, 0xed, 0x39, 0xac, 0x98, 0xe3, 0xb0, 0x79, 0xb3, 0xa4, 0x0f,
	0x15, 0xaa, 0xc7, 0x42, 0xf4, 0x9a, 0xdc, 0xb0, 0x2b, 0xf0, 0xd6, 0x2d, 0x79, 0xcc, 0x8d, 0xa0,
	0xf6, 0x02, 0xe6, 0x6e, 0x04, 0xd0, 0x5d, 0x50, 0x6b, 0x15, 0xab, 0xba, 0x77, 0x78, 0x60, 0xef,
	0x1e, 0x5a, 0xaf, 0x5f, 0x1e, 0xdb, 0x27, 0x07, 0xd5, 0xa3, 0xca, 0xf6, 0xde, 0xee, 0x5e, 0x65,
	0x27, 0xff, 0x1f, 0xca, 0x41, 0xa6, 0x66, 0xe6, 0x15, 0xf1, 0xbb, 0x99, 0xcf, 0x68, 0x17, 0x90,
	0xdf, 0x27, 0x21, 0x8b, 0xf8, 0x42, 0x0b, 0x5f, 0x74, 0x78, 0x45, 0x68, 0x15, 0xfe, 0xe7, 0xae,
	0xbc, 0xc7, 0x0d, 0x66, 0x27, 0x8c, 0x98, 0x8d, 0x63, 0x07, 0x91, 0x1f, 0x77, 0x00, 0x02, 0xc7,
	0xc5, 0x36, 0xa3, 0xe7, 0xd8, 0x2f, 0x66, 0x04, 0x60, 0x26, 0x8a, 0x1c, 0x47, 0x01, 0xb4, 0x0c,
	0x62, 0x61, 0x87, 0xe4, 0x23, 0x16, 0x66, 0x65, 0xad, 0xe9, 0x28, 0x50, 0xe5, 0x6b, 0xcd, 0x83,
	0x42, 0x82, 0x32, 0x0c, 0x78, 0x0f, 0x31, 0x2a, 0x43, 0x36, 0x8c, 0x02, 0x9c, 0x6c, 0xa2, 0x34,
	0x6b, 0xaa, 0x7f, 0xb7, 0xc5, 0x92, 0x40, 0xb4, 0x06, 0x0b, 0x3e, 0xfe, 0xc0, 0xec, 0x21, 0x1d,
	0x73, 0x51, 0xf8, 0xa8, 0xa7, 0x45, 0xdb, 0x80, 0xf9, 0x57, 0x58, 0xb0, 0xf5, 0xea, 0xe3, 0xea,
	0xa2, 0x23, 0x92, 0xc5, 0x4d, 0x47, 0x81, 0xa8, 0x32, 0xad, 0x09, 0x85, 0xed, 0x36, 0x76, 0x18,
	0x4e, 0xee, 0x18, 0xc3, 0x11, 0x1d, 0x26, 0xa3, 0x33, 0x84, 0x86, 0x74, 0xfd, 0x02, 0xa7, 0xbd,
	0x85, 0xc2, 0x49, 0x70, 0x36, 0xc0, 0x93, 0xa6, 0xec, 0x9f, 0x19, 0xca, 0x50, 0xd8, 0xc1, 0x2d,
	0x3c, 0x3e, 0x83, 0xf9, 0x23, 0x0b, 0x0b, 0xdb, 0xe2, 0x5f, 0x58, 0xc5, 0xed, 0x2e, 0x69, 0xe0,
	0x9a, 0x89, 0xbe, 0x29, 0x30, 0x73, 0xdd, 0x2e, 0x74, 0x7f, 0x14, 0xeb, 0xc0, 0xfc, 0xa8, 0x0f,
	0xd2, 0x41, 0xb2, 0xe3, 0x5a, 0xf9, 0xf3, 0xcf, 0x5f, 0xdf, 0x33, 0xeb, 0xa8, 0xc4, 0xef, 0x80,
	0x3a, 0x66, 0xce, 0xa6, 0x71, 0x95, 0xf4, 0xf8, 0x79, 0xbc, 0x08, 0x8d, 0xf5, 0x4f, 0x86, 0xec,
	0xf8, 0x25, 0x4c, 0xc5, 0x9d, 0x44, 0xab, 0x23, 0x28, 0x6e, 0x76, 0x59, 0x4d, 0x31, 0x48, 0x33,
	0x04, 0xf7, 0x23, 0xf4, 0xb0, 0xcf, 0x7d, 0xed, 0x4a, 0x82, 0x58, 0xf2, 0x72, 0x01, 0xe8, 0xab,
	0x02, 0xd0, 0x1f, 0x0b, 0x34, 0xaa, 0xc2, 0xa1, 0xa9, 0x49, 0x55, 0xf0, 0x54, 0x28, 0x28, 0x6b,
	0x63, 0x57, 0xff, 0x4c, 0x34, 0x15, 0x7d, 0xe1, 0x42, 0xfa, 0x73, 0x33, 0x52, 0xc8, 0xd0, 0x58,
	0xa5, 0x0a, 0x79, 0x22, 0x84, 0x18, 0xea, 0xb8, 0x56, 0xc4, 0x3a, 0xae, 0x00, 0xfa, 0xc3, 0x35,
	0x52, 0xc6, 0xd0, 0xec, 0xa9, 0x4b, 0x3d, 0x54, 0xef, 0x1a, 0xd6, 0x2b, 0xd1, 0x1d, 0xdd, 0xeb,
	0xc6, 0xfa, 0xb8, 0x12, 0xb6, 0x4e, 0x61, 0xb1, 0x41, 0xbd, 0x61, 0xce, 0xad, 0xb9, 0x7d, 0xf9,
	0x2d, 0x87, 0xf8, 0x48, 0x39, 0x2d, 0xbb, 0x84, 0xbd, 0xeb, 0xd4, 0x75, 0x0e, 0x37, 0x24, 0x9c,
	0xbf, 0x1e, 0xa1, 0x7c, 0x07, 0x36, 0x1a, 0x2d, 0x82, 0x7d, 0xb6, 0xe1, 0xd2, 0xc4, 0x6b, 0x54,
	0xcf, 0x89, 0xdc, 0xe3, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x6e, 0x9c, 0x64, 0xa9, 0x06,
	0x00, 0x00,
}
