gopls/v0.16.0

```
go install golang.org/x/tools/gopls@v0.16.0
```

## New features

### Integrated documentation viewer

Gopls now offers a "View package documentation" code action that opens
a local web page displaying the generated documentation for the
current Go package in a form similar to https://pkg.go.dev.
The page will be initially scrolled to the documentation for the
declaration containing the cursor.
Use this feature to preview the marked-up documentation as you prepare API
changes, or to read the documentation for locally edited packages,
even ones that have not yet been saved. Reload the page after an edit
to see updated documentation.

TODO: demo in VS Code.

Clicking on the source-code link associated with a declaration will
cause your editor to navigate to the declaration.

TODO: demo of source linking.

Editor support:

- VS Code: use the `Source action > View package documentation` menu item.
  Note: source links navigate the editor but don't yet raise the window yet.
  Please upvote https://github.com/microsoft/vscode/issues/208093 and
  https://github.com/microsoft/vscode/issues/207634 (temporarily closed).

- Emacs: requires eglot v1.17. You may find this `go-doc` function a
  useful shortcut:

```lisp
(eglot--code-action eglot-code-action-doc "source.doc")

(defalias 'go-doc #'eglot-code-action-doc
  "View documentation for the current Go package.")
```

- TODO: test in vim, neovim, sublime, helix.

### `unusedwrite` analyzer

The new
[unusedwrite](https://pkg.go.dev/golang.org/x/tools/go/analysis/passes/unusedwrite)
analyzer reports assignments, often to fields of structs, that have no
effect because, for example, the struct is never used again:

```go
func scheme(host string) string {
	u := &url.URL{
		Host:   host, // "unused write to field Host" (no need to construct a URL)
		Scheme: "https:",
	}
	return u.Scheme
}
```

This is at best an indication that the code is unnecessarily complex
(for instance, some dead code could be removed), but often indicates a
bug, as in this example:

```go
type S struct { x int }

func (s S) set(x int) {
	s.x = x // "unused write to field x" (s should be a *S pointer)
}
```


### Hover shows size/offset info

Hovering over the identifier that declares a type or struct field now
displays the size information for the type, and the offset information
for the field. In addition, it reports the percentage of wasted space
due to suboptimal ordering of struct fields, if this figure is 20% or
higher. This information may be helpful when making space
optimizations to your data structures, or when reading assembly code.

TODO: example hover image.

## Bugs fixed

## Thank you to our contributors!

@guodongli-google for the `unusedwrite` analyzer.
TODO: they're a xoogler; is there a more current GH account?