// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/v1/query.proto

package datastore

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/type/latlng"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies what data the 'entity' field contains.
// A `ResultType` is either implied (for example, in `LookupResponse.missing`
// from `datastore.proto`, it is always `KEY_ONLY`) or specified by context
// (for example, in message `QueryResultBatch`, field `entity_result_type`
// specifies a `ResultType` for all the values in field `entity_results`).
type EntityResult_ResultType int32

const (
	// Unspecified. This value is never used.
	EntityResult_RESULT_TYPE_UNSPECIFIED EntityResult_ResultType = 0
	// The key and properties.
	EntityResult_FULL EntityResult_ResultType = 1
	// A projected subset of properties. The entity may have no key.
	EntityResult_PROJECTION EntityResult_ResultType = 2
	// Only the key.
	EntityResult_KEY_ONLY EntityResult_ResultType = 3
)

var EntityResult_ResultType_name = map[int32]string{
	0: "RESULT_TYPE_UNSPECIFIED",
	1: "FULL",
	2: "PROJECTION",
	3: "KEY_ONLY",
}

var EntityResult_ResultType_value = map[string]int32{
	"RESULT_TYPE_UNSPECIFIED": 0,
	"FULL":                    1,
	"PROJECTION":              2,
	"KEY_ONLY":                3,
}

func (x EntityResult_ResultType) String() string {
	return proto.EnumName(EntityResult_ResultType_name, int32(x))
}

func (EntityResult_ResultType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{0, 0}
}

// The sort direction.
type PropertyOrder_Direction int32

const (
	// Unspecified. This value must not be used.
	PropertyOrder_DIRECTION_UNSPECIFIED PropertyOrder_Direction = 0
	// Ascending.
	PropertyOrder_ASCENDING PropertyOrder_Direction = 1
	// Descending.
	PropertyOrder_DESCENDING PropertyOrder_Direction = 2
)

var PropertyOrder_Direction_name = map[int32]string{
	0: "DIRECTION_UNSPECIFIED",
	1: "ASCENDING",
	2: "DESCENDING",
}

var PropertyOrder_Direction_value = map[string]int32{
	"DIRECTION_UNSPECIFIED": 0,
	"ASCENDING":             1,
	"DESCENDING":            2,
}

func (x PropertyOrder_Direction) String() string {
	return proto.EnumName(PropertyOrder_Direction_name, int32(x))
}

func (PropertyOrder_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{5, 0}
}

// A composite filter operator.
type CompositeFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	CompositeFilter_OPERATOR_UNSPECIFIED CompositeFilter_Operator = 0
	// The results are required to satisfy each of the combined filters.
	CompositeFilter_AND CompositeFilter_Operator = 1
)

var CompositeFilter_Operator_name = map[int32]string{
	0: "OPERATOR_UNSPECIFIED",
	1: "AND",
}

var CompositeFilter_Operator_value = map[string]int32{
	"OPERATOR_UNSPECIFIED": 0,
	"AND":                  1,
}

func (x CompositeFilter_Operator) String() string {
	return proto.EnumName(CompositeFilter_Operator_name, int32(x))
}

func (CompositeFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{7, 0}
}

// A property filter operator.
type PropertyFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	PropertyFilter_OPERATOR_UNSPECIFIED PropertyFilter_Operator = 0
	// Less than.
	PropertyFilter_LESS_THAN PropertyFilter_Operator = 1
	// Less than or equal.
	PropertyFilter_LESS_THAN_OR_EQUAL PropertyFilter_Operator = 2
	// Greater than.
	PropertyFilter_GREATER_THAN PropertyFilter_Operator = 3
	// Greater than or equal.
	PropertyFilter_GREATER_THAN_OR_EQUAL PropertyFilter_Operator = 4
	// Equal.
	PropertyFilter_EQUAL PropertyFilter_Operator = 5
	// Has ancestor.
	PropertyFilter_HAS_ANCESTOR PropertyFilter_Operator = 11
)

var PropertyFilter_Operator_name = map[int32]string{
	0:  "OPERATOR_UNSPECIFIED",
	1:  "LESS_THAN",
	2:  "LESS_THAN_OR_EQUAL",
	3:  "GREATER_THAN",
	4:  "GREATER_THAN_OR_EQUAL",
	5:  "EQUAL",
	11: "HAS_ANCESTOR",
}

var PropertyFilter_Operator_value = map[string]int32{
	"OPERATOR_UNSPECIFIED":  0,
	"LESS_THAN":             1,
	"LESS_THAN_OR_EQUAL":    2,
	"GREATER_THAN":          3,
	"GREATER_THAN_OR_EQUAL": 4,
	"EQUAL":                 5,
	"HAS_ANCESTOR":          11,
}

func (x PropertyFilter_Operator) String() string {
	return proto.EnumName(PropertyFilter_Operator_name, int32(x))
}

func (PropertyFilter_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{8, 0}
}

// The possible values for the `more_results` field.
type QueryResultBatch_MoreResultsType int32

const (
	// Unspecified. This value is never used.
	QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED QueryResultBatch_MoreResultsType = 0
	// There may be additional batches to fetch from this query.
	QueryResultBatch_NOT_FINISHED QueryResultBatch_MoreResultsType = 1
	// The query is finished, but there may be more results after the limit.
	QueryResultBatch_MORE_RESULTS_AFTER_LIMIT QueryResultBatch_MoreResultsType = 2
	// The query is finished, but there may be more results after the end
	// cursor.
	QueryResultBatch_MORE_RESULTS_AFTER_CURSOR QueryResultBatch_MoreResultsType = 4
	// The query is finished, and there are no more results.
	QueryResultBatch_NO_MORE_RESULTS QueryResultBatch_MoreResultsType = 3
)

var QueryResultBatch_MoreResultsType_name = map[int32]string{
	0: "MORE_RESULTS_TYPE_UNSPECIFIED",
	1: "NOT_FINISHED",
	2: "MORE_RESULTS_AFTER_LIMIT",
	4: "MORE_RESULTS_AFTER_CURSOR",
	3: "NO_MORE_RESULTS",
}

var QueryResultBatch_MoreResultsType_value = map[string]int32{
	"MORE_RESULTS_TYPE_UNSPECIFIED": 0,
	"NOT_FINISHED":                  1,
	"MORE_RESULTS_AFTER_LIMIT":      2,
	"MORE_RESULTS_AFTER_CURSOR":     4,
	"NO_MORE_RESULTS":               3,
}

func (x QueryResultBatch_MoreResultsType) String() string {
	return proto.EnumName(QueryResultBatch_MoreResultsType_name, int32(x))
}

func (QueryResultBatch_MoreResultsType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{11, 0}
}

// The result of fetching an entity from Datastore.
type EntityResult struct {
	// The resulting entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The version of the entity, a strictly positive number that monotonically
	// increases with changes to the entity.
	//
	// This field is set for
	// [`FULL`][google.datastore.v1.EntityResult.ResultType.FULL] entity results.
	//
	// For [missing][google.datastore.v1.LookupResponse.missing] entities in
	// `LookupResponse`, this is the version of the snapshot that was used to look
	// up the entity, and it is always set except for eventually consistent reads.
	Version int64 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// A cursor that points to the position after the result entity.
	// Set only when the `EntityResult` is part of a `QueryResultBatch` message.
	Cursor               []byte   `protobuf:"bytes,3,opt,name=cursor,proto3" json:"cursor,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityResult) Reset()         { *m = EntityResult{} }
func (m *EntityResult) String() string { return proto.CompactTextString(m) }
func (*EntityResult) ProtoMessage()    {}
func (*EntityResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{0}
}

func (m *EntityResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityResult.Unmarshal(m, b)
}
func (m *EntityResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityResult.Marshal(b, m, deterministic)
}
func (m *EntityResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityResult.Merge(m, src)
}
func (m *EntityResult) XXX_Size() int {
	return xxx_messageInfo_EntityResult.Size(m)
}
func (m *EntityResult) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityResult.DiscardUnknown(m)
}

var xxx_messageInfo_EntityResult proto.InternalMessageInfo

func (m *EntityResult) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *EntityResult) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *EntityResult) GetCursor() []byte {
	if m != nil {
		return m.Cursor
	}
	return nil
}

// A query for entities.
type Query struct {
	// The projection to return. Defaults to returning all properties.
	Projection []*Projection `protobuf:"bytes,2,rep,name=projection,proto3" json:"projection,omitempty"`
	// The kinds to query (if empty, returns entities of all kinds).
	// Currently at most 1 kind may be specified.
	Kind []*KindExpression `protobuf:"bytes,3,rep,name=kind,proto3" json:"kind,omitempty"`
	// The filter to apply.
	Filter *Filter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// The order to apply to the query results (if empty, order is unspecified).
	Order []*PropertyOrder `protobuf:"bytes,5,rep,name=order,proto3" json:"order,omitempty"`
	// The properties to make distinct. The query results will contain the first
	// result for each distinct combination of values for the given properties
	// (if empty, all results are returned).
	DistinctOn []*PropertyReference `protobuf:"bytes,6,rep,name=distinct_on,json=distinctOn,proto3" json:"distinct_on,omitempty"`
	// A starting point for the query results. Query cursors are
	// returned in query result batches and
	// [can only be used to continue the same
	// query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
	StartCursor []byte `protobuf:"bytes,7,opt,name=start_cursor,json=startCursor,proto3" json:"start_cursor,omitempty"`
	// An ending point for the query results. Query cursors are
	// returned in query result batches and
	// [can only be used to limit the same
	// query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
	EndCursor []byte `protobuf:"bytes,8,opt,name=end_cursor,json=endCursor,proto3" json:"end_cursor,omitempty"`
	// The number of results to skip. Applies before limit, but after all other
	// constraints. Optional. Must be >= 0 if specified.
	Offset int32 `protobuf:"varint,10,opt,name=offset,proto3" json:"offset,omitempty"`
	// The maximum number of results to return. Applies after all other
	// constraints. Optional.
	// Unspecified is interpreted as no limit.
	// Must be >= 0 if specified.
	Limit                *wrappers.Int32Value `protobuf:"bytes,12,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Query) Reset()         { *m = Query{} }
func (m *Query) String() string { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()    {}
func (*Query) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{1}
}

func (m *Query) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Query.Unmarshal(m, b)
}
func (m *Query) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Query.Marshal(b, m, deterministic)
}
func (m *Query) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Query.Merge(m, src)
}
func (m *Query) XXX_Size() int {
	return xxx_messageInfo_Query.Size(m)
}
func (m *Query) XXX_DiscardUnknown() {
	xxx_messageInfo_Query.DiscardUnknown(m)
}

var xxx_messageInfo_Query proto.InternalMessageInfo

func (m *Query) GetProjection() []*Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Query) GetKind() []*KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *Query) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Query) GetOrder() []*PropertyOrder {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Query) GetDistinctOn() []*PropertyReference {
	if m != nil {
		return m.DistinctOn
	}
	return nil
}

func (m *Query) GetStartCursor() []byte {
	if m != nil {
		return m.StartCursor
	}
	return nil
}

func (m *Query) GetEndCursor() []byte {
	if m != nil {
		return m.EndCursor
	}
	return nil
}

func (m *Query) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *Query) GetLimit() *wrappers.Int32Value {
	if m != nil {
		return m.Limit
	}
	return nil
}

// A representation of a kind.
type KindExpression struct {
	// The name of the kind.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KindExpression) Reset()         { *m = KindExpression{} }
func (m *KindExpression) String() string { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()    {}
func (*KindExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{2}
}

func (m *KindExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KindExpression.Unmarshal(m, b)
}
func (m *KindExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KindExpression.Marshal(b, m, deterministic)
}
func (m *KindExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KindExpression.Merge(m, src)
}
func (m *KindExpression) XXX_Size() int {
	return xxx_messageInfo_KindExpression.Size(m)
}
func (m *KindExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_KindExpression.DiscardUnknown(m)
}

var xxx_messageInfo_KindExpression proto.InternalMessageInfo

func (m *KindExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A reference to a property relative to the kind expressions.
type PropertyReference struct {
	// The name of the property.
	// If name includes "."s, it may be interpreted as a property name path.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PropertyReference) Reset()         { *m = PropertyReference{} }
func (m *PropertyReference) String() string { return proto.CompactTextString(m) }
func (*PropertyReference) ProtoMessage()    {}
func (*PropertyReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{3}
}

func (m *PropertyReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PropertyReference.Unmarshal(m, b)
}
func (m *PropertyReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PropertyReference.Marshal(b, m, deterministic)
}
func (m *PropertyReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyReference.Merge(m, src)
}
func (m *PropertyReference) XXX_Size() int {
	return xxx_messageInfo_PropertyReference.Size(m)
}
func (m *PropertyReference) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyReference.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyReference proto.InternalMessageInfo

func (m *PropertyReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A representation of a property in a projection.
type Projection struct {
	// The property to project.
	Property             *PropertyReference `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Projection) Reset()         { *m = Projection{} }
func (m *Projection) String() string { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()    {}
func (*Projection) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{4}
}

func (m *Projection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Projection.Unmarshal(m, b)
}
func (m *Projection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Projection.Marshal(b, m, deterministic)
}
func (m *Projection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Projection.Merge(m, src)
}
func (m *Projection) XXX_Size() int {
	return xxx_messageInfo_Projection.Size(m)
}
func (m *Projection) XXX_DiscardUnknown() {
	xxx_messageInfo_Projection.DiscardUnknown(m)
}

var xxx_messageInfo_Projection proto.InternalMessageInfo

func (m *Projection) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

// The desired order for a specific property.
type PropertyOrder struct {
	// The property to order by.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The direction to order by. Defaults to `ASCENDING`.
	Direction            PropertyOrder_Direction `protobuf:"varint,2,opt,name=direction,proto3,enum=google.datastore.v1.PropertyOrder_Direction" json:"direction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PropertyOrder) Reset()         { *m = PropertyOrder{} }
func (m *PropertyOrder) String() string { return proto.CompactTextString(m) }
func (*PropertyOrder) ProtoMessage()    {}
func (*PropertyOrder) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{5}
}

func (m *PropertyOrder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PropertyOrder.Unmarshal(m, b)
}
func (m *PropertyOrder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PropertyOrder.Marshal(b, m, deterministic)
}
func (m *PropertyOrder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyOrder.Merge(m, src)
}
func (m *PropertyOrder) XXX_Size() int {
	return xxx_messageInfo_PropertyOrder.Size(m)
}
func (m *PropertyOrder) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyOrder.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyOrder proto.InternalMessageInfo

func (m *PropertyOrder) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyOrder) GetDirection() PropertyOrder_Direction {
	if m != nil {
		return m.Direction
	}
	return PropertyOrder_DIRECTION_UNSPECIFIED
}

// A holder for any type of filter.
type Filter struct {
	// The type of filter.
	//
	// Types that are valid to be assigned to FilterType:
	//	*Filter_CompositeFilter
	//	*Filter_PropertyFilter
	FilterType           isFilter_FilterType `protobuf_oneof:"filter_type"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{6}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

type isFilter_FilterType interface {
	isFilter_FilterType()
}

type Filter_CompositeFilter struct {
	CompositeFilter *CompositeFilter `protobuf:"bytes,1,opt,name=composite_filter,json=compositeFilter,proto3,oneof"`
}

type Filter_PropertyFilter struct {
	PropertyFilter *PropertyFilter `protobuf:"bytes,2,opt,name=property_filter,json=propertyFilter,proto3,oneof"`
}

func (*Filter_CompositeFilter) isFilter_FilterType() {}

func (*Filter_PropertyFilter) isFilter_FilterType() {}

func (m *Filter) GetFilterType() isFilter_FilterType {
	if m != nil {
		return m.FilterType
	}
	return nil
}

func (m *Filter) GetCompositeFilter() *CompositeFilter {
	if x, ok := m.GetFilterType().(*Filter_CompositeFilter); ok {
		return x.CompositeFilter
	}
	return nil
}

func (m *Filter) GetPropertyFilter() *PropertyFilter {
	if x, ok := m.GetFilterType().(*Filter_PropertyFilter); ok {
		return x.PropertyFilter
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Filter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Filter_CompositeFilter)(nil),
		(*Filter_PropertyFilter)(nil),
	}
}

// A filter that merges multiple other filters using the given operator.
type CompositeFilter struct {
	// The operator for combining multiple filters.
	Op CompositeFilter_Operator `protobuf:"varint,1,opt,name=op,proto3,enum=google.datastore.v1.CompositeFilter_Operator" json:"op,omitempty"`
	// The list of filters to combine.
	// Must contain at least one filter.
	Filters              []*Filter `protobuf:"bytes,2,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CompositeFilter) Reset()         { *m = CompositeFilter{} }
func (m *CompositeFilter) String() string { return proto.CompactTextString(m) }
func (*CompositeFilter) ProtoMessage()    {}
func (*CompositeFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{7}
}

func (m *CompositeFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompositeFilter.Unmarshal(m, b)
}
func (m *CompositeFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompositeFilter.Marshal(b, m, deterministic)
}
func (m *CompositeFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompositeFilter.Merge(m, src)
}
func (m *CompositeFilter) XXX_Size() int {
	return xxx_messageInfo_CompositeFilter.Size(m)
}
func (m *CompositeFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_CompositeFilter.DiscardUnknown(m)
}

var xxx_messageInfo_CompositeFilter proto.InternalMessageInfo

func (m *CompositeFilter) GetOp() CompositeFilter_Operator {
	if m != nil {
		return m.Op
	}
	return CompositeFilter_OPERATOR_UNSPECIFIED
}

func (m *CompositeFilter) GetFilters() []*Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A filter on a specific property.
type PropertyFilter struct {
	// The property to filter by.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// The operator to filter by.
	Op PropertyFilter_Operator `protobuf:"varint,2,opt,name=op,proto3,enum=google.datastore.v1.PropertyFilter_Operator" json:"op,omitempty"`
	// The value to compare the property to.
	Value                *Value   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PropertyFilter) Reset()         { *m = PropertyFilter{} }
func (m *PropertyFilter) String() string { return proto.CompactTextString(m) }
func (*PropertyFilter) ProtoMessage()    {}
func (*PropertyFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{8}
}

func (m *PropertyFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PropertyFilter.Unmarshal(m, b)
}
func (m *PropertyFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PropertyFilter.Marshal(b, m, deterministic)
}
func (m *PropertyFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyFilter.Merge(m, src)
}
func (m *PropertyFilter) XXX_Size() int {
	return xxx_messageInfo_PropertyFilter.Size(m)
}
func (m *PropertyFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyFilter.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyFilter proto.InternalMessageInfo

func (m *PropertyFilter) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyFilter) GetOp() PropertyFilter_Operator {
	if m != nil {
		return m.Op
	}
	return PropertyFilter_OPERATOR_UNSPECIFIED
}

func (m *PropertyFilter) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// A [GQL
// query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
type GqlQuery struct {
	// A string of the format described
	// [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
	QueryString string `protobuf:"bytes,1,opt,name=query_string,json=queryString,proto3" json:"query_string,omitempty"`
	// When false, the query string must not contain any literals and instead must
	// bind all values. For example,
	// `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
	// `SELECT * FROM Kind WHERE a = @value` is.
	AllowLiterals bool `protobuf:"varint,2,opt,name=allow_literals,json=allowLiterals,proto3" json:"allow_literals,omitempty"`
	// For each non-reserved named binding site in the query string, there must be
	// a named parameter with that name, but not necessarily the inverse.
	//
	// Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
	// `__.*__`, and must not be `""`.
	NamedBindings map[string]*GqlQueryParameter `protobuf:"bytes,5,rep,name=named_bindings,json=namedBindings,proto3" json:"named_bindings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Numbered binding site @1 references the first numbered parameter,
	// effectively using 1-based indexing, rather than the usual 0.
	//
	// For each binding site numbered i in `query_string`, there must be an i-th
	// numbered parameter. The inverse must also be true.
	PositionalBindings   []*GqlQueryParameter `protobuf:"bytes,4,rep,name=positional_bindings,json=positionalBindings,proto3" json:"positional_bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GqlQuery) Reset()         { *m = GqlQuery{} }
func (m *GqlQuery) String() string { return proto.CompactTextString(m) }
func (*GqlQuery) ProtoMessage()    {}
func (*GqlQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{9}
}

func (m *GqlQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GqlQuery.Unmarshal(m, b)
}
func (m *GqlQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GqlQuery.Marshal(b, m, deterministic)
}
func (m *GqlQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GqlQuery.Merge(m, src)
}
func (m *GqlQuery) XXX_Size() int {
	return xxx_messageInfo_GqlQuery.Size(m)
}
func (m *GqlQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_GqlQuery.DiscardUnknown(m)
}

var xxx_messageInfo_GqlQuery proto.InternalMessageInfo

func (m *GqlQuery) GetQueryString() string {
	if m != nil {
		return m.QueryString
	}
	return ""
}

func (m *GqlQuery) GetAllowLiterals() bool {
	if m != nil {
		return m.AllowLiterals
	}
	return false
}

func (m *GqlQuery) GetNamedBindings() map[string]*GqlQueryParameter {
	if m != nil {
		return m.NamedBindings
	}
	return nil
}

func (m *GqlQuery) GetPositionalBindings() []*GqlQueryParameter {
	if m != nil {
		return m.PositionalBindings
	}
	return nil
}

// A binding parameter for a GQL query.
type GqlQueryParameter struct {
	// The type of parameter.
	//
	// Types that are valid to be assigned to ParameterType:
	//	*GqlQueryParameter_Value
	//	*GqlQueryParameter_Cursor
	ParameterType        isGqlQueryParameter_ParameterType `protobuf_oneof:"parameter_type"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *GqlQueryParameter) Reset()         { *m = GqlQueryParameter{} }
func (m *GqlQueryParameter) String() string { return proto.CompactTextString(m) }
func (*GqlQueryParameter) ProtoMessage()    {}
func (*GqlQueryParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{10}
}

func (m *GqlQueryParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GqlQueryParameter.Unmarshal(m, b)
}
func (m *GqlQueryParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GqlQueryParameter.Marshal(b, m, deterministic)
}
func (m *GqlQueryParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GqlQueryParameter.Merge(m, src)
}
func (m *GqlQueryParameter) XXX_Size() int {
	return xxx_messageInfo_GqlQueryParameter.Size(m)
}
func (m *GqlQueryParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_GqlQueryParameter.DiscardUnknown(m)
}

var xxx_messageInfo_GqlQueryParameter proto.InternalMessageInfo

type isGqlQueryParameter_ParameterType interface {
	isGqlQueryParameter_ParameterType()
}

type GqlQueryParameter_Value struct {
	Value *Value `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type GqlQueryParameter_Cursor struct {
	Cursor []byte `protobuf:"bytes,3,opt,name=cursor,proto3,oneof"`
}

func (*GqlQueryParameter_Value) isGqlQueryParameter_ParameterType() {}

func (*GqlQueryParameter_Cursor) isGqlQueryParameter_ParameterType() {}

func (m *GqlQueryParameter) GetParameterType() isGqlQueryParameter_ParameterType {
	if m != nil {
		return m.ParameterType
	}
	return nil
}

func (m *GqlQueryParameter) GetValue() *Value {
	if x, ok := m.GetParameterType().(*GqlQueryParameter_Value); ok {
		return x.Value
	}
	return nil
}

func (m *GqlQueryParameter) GetCursor() []byte {
	if x, ok := m.GetParameterType().(*GqlQueryParameter_Cursor); ok {
		return x.Cursor
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GqlQueryParameter) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GqlQueryParameter_Value)(nil),
		(*GqlQueryParameter_Cursor)(nil),
	}
}

// A batch of results produced by a query.
type QueryResultBatch struct {
	// The number of results skipped, typically because of an offset.
	SkippedResults int32 `protobuf:"varint,6,opt,name=skipped_results,json=skippedResults,proto3" json:"skipped_results,omitempty"`
	// A cursor that points to the position after the last skipped result.
	// Will be set when `skipped_results` != 0.
	SkippedCursor []byte `protobuf:"bytes,3,opt,name=skipped_cursor,json=skippedCursor,proto3" json:"skipped_cursor,omitempty"`
	// The result type for every entity in `entity_results`.
	EntityResultType EntityResult_ResultType `protobuf:"varint,1,opt,name=entity_result_type,json=entityResultType,proto3,enum=google.datastore.v1.EntityResult_ResultType" json:"entity_result_type,omitempty"`
	// The results for this batch.
	EntityResults []*EntityResult `protobuf:"bytes,2,rep,name=entity_results,json=entityResults,proto3" json:"entity_results,omitempty"`
	// A cursor that points to the position after the last result in the batch.
	EndCursor []byte `protobuf:"bytes,4,opt,name=end_cursor,json=endCursor,proto3" json:"end_cursor,omitempty"`
	// The state of the query after the current batch.
	MoreResults QueryResultBatch_MoreResultsType `protobuf:"varint,5,opt,name=more_results,json=moreResults,proto3,enum=google.datastore.v1.QueryResultBatch_MoreResultsType" json:"more_results,omitempty"`
	// The version number of the snapshot this batch was returned from.
	// This applies to the range of results from the query's `start_cursor` (or
	// the beginning of the query if no cursor was given) to this batch's
	// `end_cursor` (not the query's `end_cursor`).
	//
	// In a single transaction, subsequent query result batches for the same query
	// can have a greater snapshot version number. Each batch's snapshot version
	// is valid for all preceding batches.
	// The value will be zero for eventually consistent queries.
	SnapshotVersion      int64    `protobuf:"varint,7,opt,name=snapshot_version,json=snapshotVersion,proto3" json:"snapshot_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryResultBatch) Reset()         { *m = QueryResultBatch{} }
func (m *QueryResultBatch) String() string { return proto.CompactTextString(m) }
func (*QueryResultBatch) ProtoMessage()    {}
func (*QueryResultBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_927b394a72d2bc0d, []int{11}
}

func (m *QueryResultBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResultBatch.Unmarshal(m, b)
}
func (m *QueryResultBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResultBatch.Marshal(b, m, deterministic)
}
func (m *QueryResultBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultBatch.Merge(m, src)
}
func (m *QueryResultBatch) XXX_Size() int {
	return xxx_messageInfo_QueryResultBatch.Size(m)
}
func (m *QueryResultBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultBatch.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultBatch proto.InternalMessageInfo

func (m *QueryResultBatch) GetSkippedResults() int32 {
	if m != nil {
		return m.SkippedResults
	}
	return 0
}

func (m *QueryResultBatch) GetSkippedCursor() []byte {
	if m != nil {
		return m.SkippedCursor
	}
	return nil
}

func (m *QueryResultBatch) GetEntityResultType() EntityResult_ResultType {
	if m != nil {
		return m.EntityResultType
	}
	return EntityResult_RESULT_TYPE_UNSPECIFIED
}

func (m *QueryResultBatch) GetEntityResults() []*EntityResult {
	if m != nil {
		return m.EntityResults
	}
	return nil
}

func (m *QueryResultBatch) GetEndCursor() []byte {
	if m != nil {
		return m.EndCursor
	}
	return nil
}

func (m *QueryResultBatch) GetMoreResults() QueryResultBatch_MoreResultsType {
	if m != nil {
		return m.MoreResults
	}
	return QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED
}

func (m *QueryResultBatch) GetSnapshotVersion() int64 {
	if m != nil {
		return m.SnapshotVersion
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.datastore.v1.EntityResult_ResultType", EntityResult_ResultType_name, EntityResult_ResultType_value)
	proto.RegisterEnum("google.datastore.v1.PropertyOrder_Direction", PropertyOrder_Direction_name, PropertyOrder_Direction_value)
	proto.RegisterEnum("google.datastore.v1.CompositeFilter_Operator", CompositeFilter_Operator_name, CompositeFilter_Operator_value)
	proto.RegisterEnum("google.datastore.v1.PropertyFilter_Operator", PropertyFilter_Operator_name, PropertyFilter_Operator_value)
	proto.RegisterEnum("google.datastore.v1.QueryResultBatch_MoreResultsType", QueryResultBatch_MoreResultsType_name, QueryResultBatch_MoreResultsType_value)
	proto.RegisterType((*EntityResult)(nil), "google.datastore.v1.EntityResult")
	proto.RegisterType((*Query)(nil), "google.datastore.v1.Query")
	proto.RegisterType((*KindExpression)(nil), "google.datastore.v1.KindExpression")
	proto.RegisterType((*PropertyReference)(nil), "google.datastore.v1.PropertyReference")
	proto.RegisterType((*Projection)(nil), "google.datastore.v1.Projection")
	proto.RegisterType((*PropertyOrder)(nil), "google.datastore.v1.PropertyOrder")
	proto.RegisterType((*Filter)(nil), "google.datastore.v1.Filter")
	proto.RegisterType((*CompositeFilter)(nil), "google.datastore.v1.CompositeFilter")
	proto.RegisterType((*PropertyFilter)(nil), "google.datastore.v1.PropertyFilter")
	proto.RegisterType((*GqlQuery)(nil), "google.datastore.v1.GqlQuery")
	proto.RegisterMapType((map[string]*GqlQueryParameter)(nil), "google.datastore.v1.GqlQuery.NamedBindingsEntry")
	proto.RegisterType((*GqlQueryParameter)(nil), "google.datastore.v1.GqlQueryParameter")
	proto.RegisterType((*QueryResultBatch)(nil), "google.datastore.v1.QueryResultBatch")
}

func init() { proto.RegisterFile("google/datastore/v1/query.proto", fileDescriptor_927b394a72d2bc0d) }

var fileDescriptor_927b394a72d2bc0d = []byte{
	// 1313 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdd, 0x72, 0xd3, 0x46,
	0x14, 0x8e, 0x64, 0x3b, 0x89, 0x8f, 0xff, 0xc4, 0xd2, 0x82, 0x08, 0x50, 0x12, 0x41, 0x4b, 0x3a,
	0x03, 0x36, 0x31, 0xc3, 0x94, 0x69, 0xe9, 0x74, 0xfc, 0xa3, 0xc4, 0x06, 0x63, 0x39, 0x6b, 0x27,
	0x14, 0x86, 0x19, 0x8d, 0xb0, 0x37, 0x46, 0x45, 0x96, 0xc4, 0x4a, 0x09, 0xcd, 0x83, 0x74, 0xa6,
	0x37, 0x7d, 0x81, 0x3e, 0x40, 0x2f, 0xfa, 0x00, 0x6d, 0xa7, 0xcf, 0xd0, 0xeb, 0x5e, 0xf7, 0x11,
	0x3a, 0xda, 0x5d, 0xf9, 0x2f, 0xc6, 0xe4, 0x82, 0x3b, 0xed, 0xd9, 0xef, 0xfb, 0xce, 0x9e, 0xb3,
	0x67, 0x8f, 0x0e, 0xdc, 0x18, 0x7a, 0xde, 0xd0, 0x21, 0xa5, 0x81, 0x15, 0x5a, 0x41, 0xe8, 0x51,
	0x52, 0x3a, 0xd9, 0x29, 0xbd, 0x3d, 0x26, 0xf4, 0xb4, 0xe8, 0x53, 0x2f, 0xf4, 0xd0, 0x45, 0x0e,
	0x28, 0x8e, 0x01, 0xc5, 0x93, 0x9d, 0x8d, 0x6b, 0x82, 0x65, 0xf9, 0x76, 0xc9, 0x72, 0x5d, 0x2f,
	0xb4, 0x42, 0xdb, 0x73, 0x03, 0x4e, 0xd9, 0xd8, 0x5c, 0xa4, 0x49, 0xdc, 0xd0, 0x0e, 0x85, 0xe8,
	0xc6, 0x67, 0x02, 0xc1, 0x56, 0xaf, 0x8e, 0x8f, 0x4a, 0xef, 0xa8, 0xe5, 0xfb, 0x84, 0xc6, 0x0a,
	0xaa, 0xd8, 0x0f, 0x4f, 0x7d, 0x52, 0x72, 0xac, 0xd0, 0x71, 0x87, 0x7c, 0x47, 0xfb, 0x4b, 0x82,
	0xac, 0xce, 0xa4, 0x30, 0x09, 0x8e, 0x9d, 0x10, 0xdd, 0x87, 0x55, 0x2e, 0xad, 0x4a, 0x9b, 0xd2,
	0x76, 0xa6, 0x7c, 0xb5, 0xb8, 0xe0, 0xc0, 0x45, 0x41, 0x11, 0x50, 0xa4, 0xc2, 0xda, 0x09, 0xa1,
	0x81, 0xed, 0xb9, 0x6a, 0x72, 0x53, 0xda, 0x4e, 0xe0, 0x78, 0x89, 0x2e, 0xc1, 0x6a, 0xff, 0x98,
	0x06, 0x1e, 0x55, 0x13, 0x9b, 0xd2, 0x76, 0x16, 0x8b, 0x95, 0xb6, 0x0f, 0xc0, 0x1d, 0xf6, 0x4e,
	0x7d, 0x82, 0xae, 0xc2, 0x65, 0xac, 0x77, 0x0f, 0x5a, 0x3d, 0xb3, 0xf7, 0xbc, 0xa3, 0x9b, 0x07,
	0xed, 0x6e, 0x47, 0xaf, 0x35, 0x77, 0x9b, 0x7a, 0x5d, 0x59, 0x41, 0xeb, 0x90, 0xdc, 0x3d, 0x68,
	0xb5, 0x14, 0x09, 0xe5, 0x01, 0x3a, 0xd8, 0x78, 0xac, 0xd7, 0x7a, 0x4d, 0xa3, 0xad, 0xc8, 0x28,
	0x0b, 0xeb, 0x4f, 0xf4, 0xe7, 0xa6, 0xd1, 0x6e, 0x3d, 0x57, 0x12, 0xda, 0x1f, 0x09, 0x48, 0xed,
	0x47, 0x99, 0x46, 0xdf, 0x01, 0xf8, 0xd4, 0xfb, 0x81, 0xf4, 0xa3, 0x2c, 0xaa, 0xf2, 0x66, 0x62,
	0x3b, 0x53, 0xbe, 0xb1, 0x30, 0x8e, 0xce, 0x18, 0x86, 0xa7, 0x28, 0xe8, 0x2b, 0x48, 0xbe, 0xb1,
	0xdd, 0x81, 0x9a, 0x60, 0xd4, 0x9b, 0x0b, 0xa9, 0x4f, 0x6c, 0x77, 0xa0, 0xff, 0xe8, 0x53, 0x12,
	0x44, 0x81, 0x62, 0x46, 0x88, 0xb2, 0x77, 0x64, 0x3b, 0x21, 0xa1, 0x2c, 0x0f, 0xef, 0xcb, 0xde,
	0x2e, 0x83, 0x60, 0x01, 0x45, 0x0f, 0x21, 0xe5, 0xd1, 0x01, 0xa1, 0x6a, 0x8a, 0xb9, 0xd3, 0xde,
	0x77, 0x52, 0x9f, 0xd0, 0xf0, 0xd4, 0x88, 0x90, 0x98, 0x13, 0xd0, 0x1e, 0x64, 0x06, 0x76, 0x10,
	0xda, 0x6e, 0x3f, 0x34, 0x3d, 0x57, 0x5d, 0x65, 0xfc, 0x2f, 0x96, 0xf2, 0x31, 0x39, 0x22, 0x94,
	0xb8, 0x7d, 0x82, 0x21, 0xa6, 0x1a, 0x2e, 0xda, 0x82, 0x6c, 0x10, 0x5a, 0x34, 0x34, 0xc5, 0x65,
	0xad, 0xb1, 0xcb, 0xca, 0x30, 0x5b, 0x8d, 0x99, 0xd0, 0x75, 0x00, 0xe2, 0x0e, 0x62, 0xc0, 0x3a,
	0x03, 0xa4, 0x89, 0x3b, 0x10, 0xdb, 0x97, 0x60, 0xd5, 0x3b, 0x3a, 0x0a, 0x48, 0xa8, 0xc2, 0xa6,
	0xb4, 0x9d, 0xc2, 0x62, 0x85, 0x76, 0x20, 0xe5, 0xd8, 0x23, 0x3b, 0x54, 0xb3, 0xb3, 0x09, 0x89,
	0x4b, 0xb5, 0xd8, 0x74, 0xc3, 0xfb, 0xe5, 0x43, 0xcb, 0x39, 0x26, 0x98, 0x23, 0xb5, 0x5b, 0x90,
	0x9f, 0x4d, 0x2e, 0x42, 0x90, 0x74, 0xad, 0x11, 0x61, 0x25, 0x99, 0xc6, 0xec, 0x5b, 0xbb, 0x0d,
	0x17, 0xce, 0xc4, 0x34, 0x06, 0xca, 0x53, 0xc0, 0x0e, 0xc0, 0xe4, 0x9a, 0x51, 0x15, 0xd6, 0x7d,
	0x41, 0x13, 0x15, 0x7e, 0xde, 0x7c, 0x8d, 0x79, 0xda, 0xbf, 0x12, 0xe4, 0x66, 0xee, 0xe3, 0x63,
	0xa8, 0xa2, 0xc7, 0x90, 0x1e, 0xd8, 0x74, 0x5c, 0xb4, 0xd2, 0x76, 0xbe, 0x7c, 0xe7, 0xc3, 0xa5,
	0x50, 0xac, 0xc7, 0x1c, 0x3c, 0xa1, 0x6b, 0x3a, 0xa4, 0xc7, 0x76, 0x74, 0x05, 0x3e, 0xad, 0x37,
	0x31, 0x7f, 0x35, 0x73, 0x6f, 0x2b, 0x07, 0xe9, 0x4a, 0xb7, 0xa6, 0xb7, 0xeb, 0xcd, 0xf6, 0x1e,
	0x7f, 0x60, 0x75, 0x7d, 0xbc, 0x96, 0xb5, 0xdf, 0x25, 0x58, 0xe5, 0xc5, 0x8a, 0xf6, 0x41, 0xe9,
	0x7b, 0x23, 0xdf, 0x0b, 0xec, 0x90, 0x98, 0xa2, 0xc6, 0x79, 0xa4, 0xb7, 0x16, 0x1e, 0xb2, 0x16,
	0x83, 0x39, 0xbf, 0xb1, 0x82, 0x0b, 0xfd, 0x59, 0x13, 0x6a, 0x43, 0x21, 0x0e, 0x3e, 0x56, 0x94,
	0x99, 0xe2, 0xcd, 0xa5, 0x61, 0x8f, 0x05, 0xf3, 0xfe, 0x8c, 0xa5, 0x9a, 0x83, 0x0c, 0x97, 0x31,
	0xa3, 0x3e, 0xa7, 0xfd, 0x26, 0x41, 0x61, 0xee, 0x14, 0xe8, 0x5b, 0x90, 0x3d, 0x9f, 0x9d, 0x3b,
	0x5f, 0xbe, 0x7b, 0x9e, 0x73, 0x17, 0x0d, 0x9f, 0x50, 0x2b, 0xf4, 0x28, 0x96, 0x3d, 0x1f, 0x3d,
	0x80, 0x35, 0xee, 0x21, 0x10, 0x5d, 0x65, 0xe9, 0xfb, 0x8e, 0xb1, 0xda, 0x5d, 0x58, 0x8f, 0x65,
	0x90, 0x0a, 0x9f, 0x18, 0x1d, 0x1d, 0x57, 0x7a, 0x06, 0x9e, 0xbb, 0x8b, 0x35, 0x48, 0x54, 0xda,
	0x75, 0x45, 0xd2, 0xfe, 0x91, 0x21, 0x3f, 0x1b, 0xec, 0x47, 0xa9, 0xaf, 0x47, 0x2c, 0xf6, 0xf3,
	0x14, 0xd6, 0xa2, 0xd0, 0xef, 0x41, 0xea, 0x24, 0x7a, 0xa4, 0xac, 0x8f, 0x67, 0xca, 0x1b, 0x0b,
	0x05, 0xc4, 0x33, 0x66, 0x40, 0xed, 0x27, 0xe9, 0x5c, 0x61, 0xe7, 0x20, 0xdd, 0xd2, 0xbb, 0x5d,
	0xb3, 0xd7, 0xa8, 0xb4, 0x15, 0x09, 0x5d, 0x02, 0x34, 0x5e, 0x9a, 0x06, 0x36, 0xf5, 0xfd, 0x83,
	0x4a, 0x4b, 0x91, 0x91, 0x02, 0xd9, 0x3d, 0xac, 0x57, 0x7a, 0x3a, 0xe6, 0xc8, 0x44, 0x54, 0xd6,
	0xd3, 0x96, 0x09, 0x38, 0x89, 0xd2, 0x90, 0xe2, 0x9f, 0xa9, 0x88, 0xd7, 0xa8, 0x74, 0xcd, 0x4a,
	0xbb, 0xa6, 0x77, 0x7b, 0x06, 0x56, 0x32, 0xda, 0x7f, 0x32, 0xac, 0xef, 0xbd, 0x75, 0xf8, 0xaf,
	0x62, 0x0b, 0xb2, 0xec, 0xef, 0x6c, 0x06, 0x21, 0xb5, 0xdd, 0xa1, 0xe8, 0x30, 0x19, 0x66, 0xeb,
	0x32, 0x13, 0xfa, 0x1c, 0xf2, 0x96, 0xe3, 0x78, 0xef, 0x4c, 0xc7, 0x0e, 0x09, 0xb5, 0x9c, 0x80,
	0xe5, 0x70, 0x1d, 0xe7, 0x98, 0xb5, 0x25, 0x8c, 0xe8, 0x19, 0xe4, 0xa3, 0x76, 0x33, 0x30, 0x5f,
	0xd9, 0xee, 0xc0, 0x76, 0x87, 0x81, 0x68, 0xe7, 0xf7, 0x16, 0x66, 0x2a, 0x3e, 0x40, 0xb1, 0x1d,
	0x71, 0xaa, 0x82, 0xa2, 0xbb, 0x21, 0x3d, 0xc5, 0x39, 0x77, 0xda, 0x86, 0x9e, 0xc1, 0x45, 0x56,
	0x91, 0xb6, 0xe7, 0x5a, 0xce, 0x44, 0x3d, 0xb9, 0xa4, 0xd9, 0xc7, 0xea, 0x1d, 0x8b, 0x5a, 0x23,
	0x12, 0xd5, 0x22, 0x9a, 0x48, 0xc4, 0xc2, 0x1b, 0xaf, 0x01, 0x9d, 0xf5, 0x8e, 0x14, 0x48, 0xbc,
	0x21, 0xa7, 0x22, 0x11, 0xd1, 0x27, 0x7a, 0x14, 0x5f, 0xbd, 0xbc, 0xa4, 0xf2, 0xce, 0xba, 0xe4,
	0xa4, 0xaf, 0xe5, 0x87, 0x92, 0x16, 0xc0, 0x85, 0x33, 0xfb, 0xa8, 0x3c, 0x2b, 0xbb, 0xa4, 0xa2,
	0x1a, 0x2b, 0x42, 0x0c, 0xa9, 0xb3, 0xe3, 0x44, 0x63, 0x25, 0x1e, 0x28, 0xaa, 0x0a, 0xe4, 0xfd,
	0x58, 0x9a, 0xbf, 0xff, 0x3f, 0x93, 0xa0, 0x30, 0x97, 0x7c, 0xd0, 0xa8, 0x5a, 0x61, 0xff, 0x35,
	0xba, 0x0d, 0x85, 0xe0, 0x8d, 0xed, 0xfb, 0x64, 0x60, 0x52, 0x66, 0x0e, 0xd4, 0x55, 0xf6, 0xbf,
	0xca, 0x0b, 0x33, 0x07, 0x07, 0xd1, 0xad, 0xc7, 0xc0, 0x99, 0x01, 0x26, 0x27, 0xac, 0xe2, 0xb7,
	0xf7, 0x02, 0x10, 0x9f, 0x81, 0x84, 0x1c, 0x73, 0x2d, 0x1a, 0xcc, 0x9d, 0x65, 0xa3, 0x13, 0x43,
	0x17, 0x27, 0x33, 0x10, 0x56, 0xc8, 0xd4, 0x06, 0x9b, 0x8a, 0x1a, 0x90, 0x9f, 0xd1, 0x8e, 0x9b,
	0xce, 0xd6, 0x07, 0x75, 0x71, 0x6e, 0x5a, 0x2c, 0x98, 0xfb, 0x77, 0x27, 0xe7, 0xff, 0xdd, 0xdf,
	0x43, 0x76, 0xe4, 0x51, 0x32, 0x76, 0x93, 0x62, 0xc7, 0x7f, 0xb0, 0xd0, 0xcd, 0x7c, 0x46, 0x8b,
	0x4f, 0x3d, 0x4a, 0x84, 0x1f, 0x16, 0x47, 0x66, 0x34, 0x31, 0xa0, 0x2f, 0x41, 0x09, 0x5c, 0xcb,
	0x0f, 0x5e, 0x7b, 0xa1, 0x19, 0x4f, 0x88, 0x6b, 0x6c, 0x42, 0x2c, 0xc4, 0xf6, 0x43, 0x6e, 0xd6,
	0x7e, 0x96, 0xa0, 0x30, 0xa7, 0x85, 0xb6, 0xe0, 0xfa, 0x53, 0x03, 0xeb, 0x26, 0x1f, 0x0e, 0xbb,
	0x8b, 0xa6, 0x43, 0x05, 0xb2, 0x6d, 0xa3, 0x67, 0xee, 0x36, 0xdb, 0xcd, 0x6e, 0x43, 0xaf, 0x2b,
	0x12, 0xba, 0x06, 0xea, 0x0c, 0xa9, 0xb2, 0x1b, 0xb5, 0x88, 0x56, 0xf3, 0x69, 0xb3, 0xa7, 0xc8,
	0xe8, 0x3a, 0x5c, 0x59, 0xb0, 0x5b, 0x3b, 0xc0, 0x5d, 0x03, 0x2b, 0x49, 0x74, 0x11, 0x0a, 0x6d,
	0xc3, 0x9c, 0x46, 0x28, 0x89, 0xea, 0x2f, 0x12, 0x5c, 0xee, 0x7b, 0xa3, 0x45, 0xf9, 0xa8, 0x02,
	0xaf, 0xea, 0x68, 0x9a, 0xe9, 0x48, 0x2f, 0x1e, 0x09, 0xc8, 0xd0, 0x73, 0x2c, 0x77, 0x58, 0xf4,
	0xe8, 0xb0, 0x34, 0x24, 0x2e, 0x9b, 0x75, 0x4a, 0x7c, 0xcb, 0xf2, 0xed, 0x60, 0x66, 0x92, 0xff,
	0x66, 0xbc, 0xf8, 0x55, 0xbe, 0xb2, 0xc7, 0xe9, 0x35, 0xc7, 0x3b, 0x1e, 0x14, 0xeb, 0x63, 0x3f,
	0x87, 0x3b, 0x7f, 0xc7, 0x7b, 0x2f, 0xd9, 0xde, 0xcb, 0xf1, 0xde, 0xcb, 0xc3, 0x9d, 0x57, 0xab,
	0xcc, 0xc1, 0xfd, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0xcd, 0x38, 0x05, 0xaa, 0x7d, 0x0c, 0x00,
	0x00,
}
