/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */
#ifndef GF_ITEM_IMAGE_H
#define GF_ITEM_IMAGE_H

#include <glib.h>
#include <gdk/gdk.h>

#include <xmlnode.h>

#include "gf_event_info.h"
#include "gf_item.h"

#define GF_ITEM_IMAGE(obj)	((GfItemImage *)(obj))

typedef struct _GfItemImage GfItemImage;

G_BEGIN_DECLS

GfItemImage *gf_item_image_new(GfItem *item);
GfItemImage *gf_item_image_new_from_xmlnode(GfItem *item, xmlnode *node);
GfItemImage *gf_item_image_copy(GfItemImage *image);
xmlnode *gf_item_image_to_xmlnode(GfItemImage *image);
void gf_item_image_destroy(GfItemImage *item_image);

void gf_item_image_set_item(GfItemImage *item_image, GfItem *item);
GfItem *gf_item_image_get_item(GfItemImage *item_image);
void gf_item_image_set_image(GfItemImage *item_image, const gchar *image);
const gchar *gf_item_image_get_image(GfItemImage *item_image);

void gf_item_image_render(GfItemImage *item_image, GdkPixbuf *pixbuf, GfEventInfo *info);

G_END_DECLS

#endif /* GF_ITEM_IMAGE_H */
