////
///  genfisuffix - a Finnish affix table generator for ispell
//   Copyright (C) 2000  Pauli Virtanen <pauli.virtanen@saunalahti.fi>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//   The program's output is also subject to this license, and considered
//   program source code.
//
//////////////////////////////////////////////////////////////////////////////
//
//
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <vector>
#include <string>
#include <algorithm>

#include <ctype.h>
#include <locale.h>

#include "genfisuffix.hh"
#include "finnish_data.hh"

//////////////////////////////////////////////////////////////////////////////
///
/// Common data
///
options_t options;



//////////////////////////////////////////////////////////////////////////////
///
/// Main
///


void usage()
{
        cout << "Usage: genfisuffix [options]" << endl;
        cout << "Options:" << endl;
        cout << "  -s,--suffix-particles     Append also suffix particles"
             << endl;
        cout << "  -p,--possessive-suffixes  Append also possessive suffixes"
             << endl;
        cout << "  -a,--all-suffix-particles Apped suffix particles also to"
             << endl;
        cout << "                            possessive suffixed forms,"
             << endl;
        cout << "  -h,--help                 Show this help." << endl;
}

bool get_options(int argc, const char *const *argv)
{
        options.use_possessive_suffixes = false;
        options.use_suffix_particles = false;
        options.use_all_suffix_particles = false;
        while (argc > 1)
        {
                --argc;
                string arg(argv[argc]);

                if (arg == "-s" || arg == "--suffix-particles")
                        options.use_suffix_particles = true;
                else if (arg == "-p" || arg == "--possessive-suffixes")
                        options.use_possessive_suffixes = true;
                else if (arg == "-a" || arg == "--all-suffix-particles")
                {
                        options.use_suffix_particles = true;
                        options.use_all_suffix_particles = true;
                }
                else
                {
                        cerr << "Not an option: " << arg;
                        usage();
                        return false;
                }
        }
        return true;
}

int main(int argc, const char *const *argv)
{
        setlocale(LC_CTYPE, "");

        // Get options
        if (!get_options(argc, argv))
                return -1;

        // Initialize finnish data
        init_finnish_data();

        cout << endl << endl;
        cout << "# Below this point the file is automatically generated"
             << " by genfisuffix " << VERSION << endl;
        cout << "# Please make changes to the genfisuffix source instead."
             << endl;

        do_suffix_particles();
        do_possessive_suffixes();
        do_adjectives();
        do_nouns();
        do_possessive_and_illative();

        do_verbs_infinitive_stem();
        do_verbs_declination_stem();
        do_verbs_consonant_gradated_declination_stem();
        
        return 0;
}
