## Bool

## Control

## Interaction

### `add_skip_command`

Add a skip function to a source when it does not have one by default.

Type:
```
(source('a)) -> unit
```

Arguments:

- `(unlabeled)` (of type `source('a)`): The source to attach the command to.

### `audioscrobbler.submit.full`

Submit songs using audioscrobbler, respecting the full protocol: First signal song as now playing when starting, and then submit song when it ends.

Type:
```
(user : string, password : string, ?host : string,
 ?port : int, ?source : string, ?length : bool,
 ?delay : float, ?force : bool, source(audio='a,
 video='b, midi='c)) -> source(audio='a, video='b,
midi='c)
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `host` (of type `string`, which defaults to `"post.audioscrobbler.com"`)
- `port` (of type `int`, which defaults to `80`)
- `source` (of type `string`, which defaults to `"broadcast"`): Source for tracks. Should be one of: "broadcast", "user", "recommendation" or "unknown". Since liquidsoap is intented for radio broadcasting, this is the default. Sources other than user don't need duration to be set.
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `delay` (of type `float`, which defaults to `10.`): Submit song when there is only this delay left, in seconds. 
- `force` (of type `bool`, which defaults to `false`): If remaining time is null, the song will be assumed to be skipped or cuted, and not submitted. Set to zero to disable this behaviour.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`)

### `lastfm.nowplaying`

Submit metadata to lastfm.fm using the audioscrobbler protocol (nowplaying mode).

Type:
```
(user : string, password : string, ?length : bool,
 [string * string]) -> unit
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `(unlabeled)` (of type `[string * string]`)

### `lastfm.submit`

Submit metadata to lastfm.fm using the audioscrobbler protocol.

Type:
```
(user : string, password : string, ?source : string,
 ?length : bool, [string * string]) -> unit
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `source` (of type `string`, which defaults to `"broadcast"`): Source for tracks. Should be one of: "broadcast", "user", "recommendation" or "unknown". Since liquidsoap is intented for radio broadcasting, this is the default. Sources other than user don't need duration to be set.
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `(unlabeled)` (of type `[string * string]`)

### `lastfm.submit.full`

Submit songs to lastfm using audioscrobbler, respecting the full protocol: First signal song as now playing when starting, and then submit song when it ends.

Type:
```
(user : string, password : string, ?source : string,
 ?length : bool, ?delay : float, ?force : bool,
 source(audio='a, video='b, midi='c)) -> source(audio='a,
video='b, midi='c)
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `source` (of type `string`, which defaults to `"broadcast"`): Source for tracks. Should be one of: "broadcast", "user", "recommendation" or "unknown". Since liquidsoap is intented for radio broadcasting, this is the default. Sources other than user don't need duration to be set.
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `delay` (of type `float`, which defaults to `10.`): Submit song when there is only this delay left, in seconds. If remaining time is less than this value, the song will be assumed to be skipped or cuted, and not submitted. Set to zero to disable this behaviour.
- `force` (of type `bool`, which defaults to `false`): If remaining time is null, the song will be assumed to be skipped or cuted, and not submitted. Set to zero to disable this behaviour.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`)

### `librefm.nowplaying`

Submit metadata to libre.fm using the audioscrobbler protocol (nowplaying mode).

Type:
```
(user : string, password : string, ?length : bool,
 [string * string]) -> unit
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `(unlabeled)` (of type `[string * string]`)

### `librefm.submit`

Submit metadata to libre.fm using the audioscrobbler protocol.

Type:
```
(user : string, password : string, ?source : string,
 ?length : bool, [string * string]) -> unit
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `source` (of type `string`, which defaults to `"broadcast"`): Source for tracks. Should be one of: "broadcast", "user", "recommendation" or "unknown". Since liquidsoap is intented for radio broadcasting, this is the default. Sources other than user don't need duration to be set.
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `(unlabeled)` (of type `[string * string]`)

### `librefm.submit.full`

Submit songs to librefm using audioscrobbler, respecting the full protocol: First signal song as now playing when starting, and then submit song when it ends.

Type:
```
(user : string, password : string, ?source : string,
 ?length : bool, ?delay : float, ?force : bool,
 source(audio='a, video='b, midi='c)) -> source(audio='a,
video='b, midi='c)
```

Arguments:

- `user` (of type `string`)
- `password` (of type `string`)
- `source` (of type `string`, which defaults to `"broadcast"`): Source for tracks. Should be one of: "broadcast", "user", "recommendation" or "unknown". Since liquidsoap is intented for radio broadcasting, this is the default. Sources other than user don't need duration to be set.
- `length` (of type `bool`, which defaults to `false`): Try to submit length information. This operation can be CPU intensive. Value forced to true when used with the "user" source type.
- `delay` (of type `float`, which defaults to `10.`): Submit song when there is only this delay left, in seconds. If remaining time is less than this value, the song will be assumed to be skipped or cuted, and not submitted. Set to zero to disable this behaviour.
- `force` (of type `bool`, which defaults to `false`): If remaining time is null, the song will be assumed to be skipped or cuted, and not submitted. Set to zero to disable this behaviour.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`)

### `metadata.float_getter`

Create a float getter from a metadata: this is a float, whose value can be changed with a metadata.

Type:
```
(float, string, source(audio='a, video='b, midi='c)) ->
source(audio='a, video='b, midi='c) * (() -> float)
```

Arguments:

- `(unlabeled)` (of type `float`): Initial value.
- `(unlabeled)` (of type `string`): Metadata on which the value should be updated.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`): Source containing the metadata.

### `metadata.string_getter`

Create a string getter from a metadata: this is a string, whose value can be changed with a metadata.

Type:
```
(string, string, source(audio='a, video='b, midi='c)) ->
source(audio='a, video='b, midi='c) * (() -> string)
```

Arguments:

- `(unlabeled)` (of type `string`): Initial value.
- `(unlabeled)` (of type `string`): Metadata on which the value should be updated.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`): Source containing the metadata.

## Liquidsoap

### `predicate.activates`

Detect when a predicate becomes true.

Type:
```
(?init : bool, (() -> bool)) -> () -> bool
```

Arguments:

- `init` (of type `bool`, which defaults to `false`): Detect at begining.
- `(unlabeled)` (of type `() -> bool`): Predicate.

### `predicate.changes`

Detect when a predicate changes.

Type:
```
((() -> 'a)) -> () -> bool where 'a is an orderable type
```

Arguments:

- `(unlabeled)` (of type `() -> 'a where 'a is an orderable type`): Predicate.

### `predicate.once`

First occurrence of a predicate.

Type:
```
((() -> bool)) -> () -> bool
```

Arguments:

- `(unlabeled)` (of type `() -> bool`): Predicate.

## List

## Math

## Other

## Output

### `output.external.ffmpeg`

Output to ffmpeg.

Type:
```
(?id : string, ?show_command : bool, ?flush : bool,
 ?fallible : bool, ?on_start : (() -> unit),
 ?on_stop : (() -> unit), ?reopen_delay : float,
 ?reopen_on_metadata : bool, ?reopen_when : (() -> bool),
 ?start : bool, string, source(audio=pcm(stereo),
 video=yuv420p(height=720,width=1280), midi=none)) ->
active_source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `show_command` (of type `bool`, which defaults to `false`)
- `flush` (of type `bool`, which defaults to `false`): Perform a flush after each write.
- `fallible` (of type `bool`, which defaults to `false`): Allow the child source to fail, in which case the output will be (temporarily) stopped.
- `on_start` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting starts.
- `on_stop` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting stops.
- `reopen_delay` (of type `float`, which defaults to `120.`): Prevent re-opening within that delay, in seconds.
- `reopen_on_metadata` (of type `bool`, which defaults to `false`): Re-open on every new metadata information.
- `reopen_when` (of type `() -> bool`, which defaults to `{false}`): When should the output be re-opened.
- `start` (of type `bool`, which defaults to `true`): Automatically start outputting whenever possible. If true, an infallible (normal) output will start outputting as soon as it is created, and a fallible output will (re)start as soon as its source becomes available for streaming.
- `(unlabeled)` (of type `string`)
- `(unlabeled)` (of type `source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)`)

### `output.file.dash.ffmpeg`

Output an MPEG-DASH playlist using ffmpeg

Type:
```
(?id : string, ?flush : bool, ?fallible : bool,
 ?on_start : (() -> unit), ?on_stop : (() -> unit),
 ?reopen_delay : float, ?reopen_on_metadata : bool,
 ?reopen_when : (() -> bool), ?start : bool,
 ?playlist : string, directory : 'a,
 source(audio=pcm(stereo),
 video=yuv420p(height=720,width=1280), midi=none)) ->
active_source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `flush` (of type `bool`, which defaults to `false`): Perform a flush after each write.
- `fallible` (of type `bool`, which defaults to `false`): Allow the child source to fail, in which case the output will be (temporarily) stopped.
- `on_start` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting starts.
- `on_stop` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting stops.
- `reopen_delay` (of type `float`, which defaults to `120.`): Prevent re-opening within that delay, in seconds.
- `reopen_on_metadata` (of type `bool`, which defaults to `false`): Re-open on every new metadata information.
- `reopen_when` (of type `() -> bool`, which defaults to `{false}`): When should the output be re-opened.
- `start` (of type `bool`, which defaults to `true`): Automatically start outputting whenever possible. If true, an infallible (normal) output will start outputting as soon as it is created, and a fallible output will (re)start as soon as its source becomes available for streaming.
- `playlist` (of type `string`, which defaults to `"stream.mpd"`): Playlist name
- `directory` (of type `'a`): Directory to write to
- `(unlabeled)` (of type `source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)`)

### `output.file.hls.ffmpeg`

Output a HLS playlist using ffmpeg

Type:
```
(?id : string, ?flush : bool, ?fallible : bool,
 ?on_start : (() -> unit), ?on_stop : (() -> unit),
 ?reopen_delay : float, ?reopen_on_metadata : bool,
 ?reopen_when : (() -> bool), ?start : bool,
 ?playlist : string, directory : string,
 source(audio=pcm(stereo),
 video=yuv420p(height=720,width=1280), midi=none)) ->
active_source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `flush` (of type `bool`, which defaults to `false`): Perform a flush after each write.
- `fallible` (of type `bool`, which defaults to `false`): Allow the child source to fail, in which case the output will be (temporarily) stopped.
- `on_start` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting starts.
- `on_stop` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting stops.
- `reopen_delay` (of type `float`, which defaults to `120.`): Prevent re-opening within that delay, in seconds.
- `reopen_on_metadata` (of type `bool`, which defaults to `false`): Re-open on every new metadata information.
- `reopen_when` (of type `() -> bool`, which defaults to `{false}`): When should the output be re-opened.
- `start` (of type `bool`, which defaults to `true`): Automatically start outputting whenever possible. If true, an infallible (normal) output will start outputting as soon as it is created, and a fallible output will (re)start as soon as its source becomes available for streaming.
- `playlist` (of type `string`, which defaults to `"stream.m3u8"`): Playlist name
- `directory` (of type `string`): Directory to write to
- `(unlabeled)` (of type `source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)`)

### `output.youtube.live.ffmpeg`

Stream to youtube.

Type:
```
(?id : string, ?flush : bool, ?fallible : bool,
 ?on_start : (() -> unit), ?on_stop : (() -> unit),
 ?reopen_delay : float, ?reopen_on_metadata : bool,
 ?reopen_when : (() -> bool), ?start : bool,
 ?url : string, ?bitrate : int, ?quality : string,
 key : string, source(audio=pcm(stereo),
 video=yuv420p(height=720,width=1280), midi=none)) ->
active_source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `flush` (of type `bool`, which defaults to `false`): Perform a flush after each write.
- `fallible` (of type `bool`, which defaults to `false`): Allow the child source to fail, in which case the output will be (temporarily) stopped.
- `on_start` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting starts.
- `on_stop` (of type `() -> unit`, which defaults to `<fun>`): Callback executed when outputting stops.
- `reopen_delay` (of type `float`, which defaults to `120.`): Prevent re-opening within that delay, in seconds.
- `reopen_on_metadata` (of type `bool`, which defaults to `false`): Re-open on every new metadata information.
- `reopen_when` (of type `() -> bool`, which defaults to `{false}`): When should the output be re-opened.
- `start` (of type `bool`, which defaults to `true`): Automatically start outputting whenever possible. If true, an infallible (normal) output will start outputting as soon as it is created, and a fallible output will (re)start as soon as its source becomes available for streaming.
- `url` (of type `string`, which defaults to `"rtmp://a.rtmp.youtube.com/live2"`): URL to stream to
- `bitrate` (of type `int`, which defaults to `2500`): Bitrate of the video (in kbps)
- `quality` (of type `string`, which defaults to `"medium"`): Quality of the video (low / medium / high)
- `key` (of type `string`): Your secret youtube key
- `(unlabeled)` (of type `source(audio=pcm(stereo),
video=yuv420p(height=720,width=1280), midi=none)`)

## Pair

## Source / Conversions

## Source / Input

### `gstreamer.single.audio`

Play a single audio file using GStreamer.

Type:
```
(?id : string, ?on_error : (('a) -> float), {string}) ->
source(audio=pcm('c), video='d, midi='e)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `on_error` (of type `('a) -> float`, which defaults to `fun (_) -> 3.`): Callback executed when an error happens.
- `(unlabeled)` (of type `{string}`): URI of the file to be played.

### `input.mplayer`

Stream data from mplayer

Type:
```
(?id : string, ?restart : bool, ?restart_on_error : bool,
 ?buffer : float, ?max : float, string) ->
source(audio=pcm('a), video='b, midi='c)
```

Arguments:

- `id` (of type `string`, which defaults to `"input.mplayer"`)
- `restart` (of type `bool`, which defaults to `true`): restart on exit.
- `restart_on_error` (of type `bool`, which defaults to `false`): restart on exit with error.
- `buffer` (of type `float`, which defaults to `0.2`): Duration of the pre-buffered data.
- `max` (of type `float`, which defaults to `10.`): Maximum duration of the buffered data.
- `(unlabeled)` (of type `string`): data URI.

### `input.v4l2`

Stream from a video4linux 2 input device, such as a webcam.

Type:
```
(?id : string, ?device : string,
 ?on_error : ((string) -> float)) -> source(audio='a,
video=yuv420p('b), midi='c)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `device` (of type `string`, which defaults to `"/dev/video0"`): V4L2 device to use.
- `on_error` (of type `(string) -> float`, which defaults to `fun (_) -> 3.`): Callback executed when an error happens.

### `input.v4l2_with_audio`

Stream from a video4linux 2 input device, such as a webcam.

Type:
```
(?id : string, ?device : string,
 ?on_error : ((string) -> float)) ->
source(audio=pcm(stereo), video=yuv420p('a), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `device` (of type `string`, which defaults to `"/dev/video0"`): V4L2 device to use.
- `on_error` (of type `(string) -> float`, which defaults to `fun (_) -> 3.`): Callback executed when an error happens.

### `output.file.hls.gstreamer`

Play an http live stream.

Type:
```
(?id : string, ?on_error : ((string) -> float), {string}) ->
source(audio=pcm(stereo), video=yuv420p('b), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `on_error` (of type `(string) -> float`, which defaults to `fun (_) -> 3.`): Callback executed when an error happens.
- `(unlabeled)` (of type `{string}`): URI of the HLS stream index.

### `output.file.hls.gstreamer.audio`

Play an audio-only http live stream.

Type:
```
(?id : string, ?on_error : ((string) -> float), {string}) ->
source(audio=pcm('b), video='c, midi='d)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Force the value of the source ID.
- `on_error` (of type `(string) -> float`, which defaults to `fun (_) -> 3.`): Callback executed when an error happens.
- `(unlabeled)` (of type `{string}`): URI of the HLS stream index.

### `video.testsrc.gstreamer`

Test audio-video source using GStreamer.

Type:
```
(?id : string) -> source(audio=pcm(stereo),
video=yuv420p('a), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `""`)

## Source / Liquidsoap

## Source / MIDI Processing

## Source / Output

### `gstreamer.encode_jpeg_avi`

Encode jpeg video file using gstreamer

Type:
```
('a, source(audio=pcm('b), video='c, midi='d)) ->
active_source(audio=pcm('b), video='c, midi='d)
```

Arguments:

- `(unlabeled)` (of type `'a`): Encoded file name
- `(unlabeled)` (of type `source(audio=pcm('b), video='c, midi='d)`): Source

### `gstreamer.encode_mp3`

Encode a mp3 file using gstreamer

Type:
```
('a, source(audio=pcm('b), video='c, midi='d)) ->
active_source(audio=pcm('b), video='c, midi='d)
```

Arguments:

- `(unlabeled)` (of type `'a`): Encoded file name
- `(unlabeled)` (of type `source(audio=pcm('b), video='c, midi='d)`): Source

### `gstreamer.encode_x264_avi`

Encode an x264 video file using gstreamer

Type:
```
('a, source(audio=pcm('b), video='c, midi='d)) ->
active_source(audio=pcm('b), video='c, midi='d)
```

Arguments:

- `(unlabeled)` (of type `'a`): Encoded file name
- `(unlabeled)` (of type `source(audio=pcm('b), video='c, midi='d)`): Source

### `gstreamer.rtp.mpeg4`

Broadcast a video in RTP. In order to play it, save the following in `xxx.sdp` and use `vlc xxx.sdp`:
```
v=0
m=video 5000 RTP/AVP 96
c=IN IP4 127.0.0.1
a=rtpmap:96 MP4V-ES/90000
```


Type:
```
(?host : string, ?port : int, source(audio=pcm('a),
 video='b, midi='c)) -> active_source(audio=pcm('a),
video='b, midi='c)
```

Arguments:

- `host` (of type `string`, which defaults to `"127.0.0.1"`)
- `port` (of type `int`, which defaults to `5000`)
- `(unlabeled)` (of type `source(audio=pcm('a), video='b, midi='c)`)

### `output.youtube.live`

Stream live on youtube. You need the following Gstreamer plugins: flvmux, rtmpsink, x264enc and a suitable AAC encoder (see `audio_encoder` params).

Type:
```
(?id : string, ?video_bitrate : int,
 ?audio_encoder : string, ?audio_bitrate : int,
 ?url : string, key : string, source(audio=pcm('a),
 video=yuv420p('b), midi='c)) ->
active_source(audio=pcm('a), video=yuv420p('b), midi='c)
```

Arguments:

- `id` (of type `string`, which defaults to `""`): Source ID
- `video_bitrate` (of type `int`, which defaults to `2000`): Video bitrate
- `audio_encoder` (of type `string`, which defaults to `"fdkaacenc"`): Audio encoder. Can be one of: "fdkaacenc", "voaacenc"
- `audio_bitrate` (of type `int`, which defaults to `128000`): Audio bitrate
- `url` (of type `string`, which defaults to `"rtmp://a.rtmp.youtube.com/live2"`): Server URL
- `key` (of type `string`): Secret key
- `(unlabeled)` (of type `source(audio=pcm('a), video=yuv420p('b), midi='c)`): Source to stream

## Source / Sound Processing

### `helium`

Increases the pitch, making voices sound like on helium.

Type:
```
(source(audio=pcm('a), video='b, midi='c)) ->
source(audio=pcm('a), video='b, midi='c)
```

Arguments:

- `(unlabeled)` (of type `source(audio=pcm('a), video='b, midi='c)`): The input source.

### `nrj`

Compress and normalize, producing a more uniform and "full" sound.

Type:
```
(source(audio='a, video='b, midi='c)) -> source(audio='a,
video='b, midi='c)
```

Arguments:

- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`): The input source.

### `sky`

Multiband-compression.

Type:
```
(source(audio='a, video='b, midi=none)) ->
source(audio='a, video='b, midi=none)
where
  'a, 'b is an internal media type (none, pcm, yuv420p or midi)
```

Arguments:

- `(unlabeled)` (of type `source(audio='a, video='b, midi=none)
where
  'a, 'b is an internal media type (none, pcm, yuv420p or midi)`): The input source.

## Source / Sound Synthesis

## Source / Track Processing

### `fallback.skip`

Special track insensitive fallback that always skips current song before switching.

Type:
```
(input : source(audio='a, video='b, midi='c),
 source(audio='a, video='b, midi='c)) -> source(audio='a,
video='b, midi='c)
```

Arguments:

- `input` (of type `source(audio='a, video='b, midi='c)`): The input source
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`): The fallback source

### `notify_metadata`

Use notify to display metadata info.

Type:
```
(?urgency : string, ?icon : string, ?time : int,
 ?display : (([string * string]) -> string),
 ?title : string, source(audio='a, video='b, midi='c)) ->
source(audio='a, video='b, midi='c)
```

Arguments:

- `urgency` (of type `string`, which defaults to `"low"`): Urgency (low|normal|critical).
- `icon` (of type `string`, which defaults to `"stock_smiley-22"`): Icon filename or stock icon to display.
- `time` (of type `int`, which defaults to `3000`): Timeout in milliseconds.
- `display` (of type `([string * string]) -> string`, which defaults to `<fun>`): Function used to display a metadata packet.
- `title` (of type `string`, which defaults to `"Liquidsoap: new track"`): Title of the notification message.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`)

### `osd_metadata`

Use X On Screen Display to display metadata info.

Type:
```
(?color : string, ?position : string, ?font : string,
 ?display : (([string * string]) -> string),
 source(audio='a, video='b, midi='c)) -> source(audio='a,
video='b, midi='c)
```

Arguments:

- `color` (of type `string`, which defaults to `"green"`): Color of the text.
- `position` (of type `string`, which defaults to `"top"`): Position of the text (top|middle|bottom).
- `font` (of type `string`, which defaults to `"-*-courier-*-r-*-*-*-240-*-*-*-*-*-*"`): Font used (xfontsel is your friend...)
- `display` (of type `([string * string]) -> string`, which defaults to `<fun>`): Function used to display a metadata packet.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`)

### `smooth_add`

Mixes two streams, with faded transitions between the state when only the normal stream is available and when the special stream gets added on top of it.

Type:
```
(?delay : float, ?p : {float}, normal : source(audio='b,
 video='c, midi=none), special : source(audio='b,
 video='c, midi=none)) -> source(audio='b, video='c,
midi=none)
where
  'b, 'c is an internal media type (none, pcm, yuv420p or midi)
```

Arguments:

- `delay` (of type `float`, which defaults to `0.5`): Delay before starting the special source.
- `p` (of type `{float}`, which defaults to `0.2`): Portion of amplitude of the normal source in the mix.
- `normal` (of type `source(audio='b, video='c, midi=none)
where
  'b, 'c is an internal media type (none, pcm, yuv420p or midi)`): The normal source, which could be called the carrier too.
- `special` (of type `source(audio='b, video='c, midi=none)
where
  'b, 'c is an internal media type (none, pcm, yuv420p or midi)`): The special source.

## Source / Video Processing

### `input.external.ffmpeg`

Input from ffmpeg.

Type:
```
(?id : string, ?show_command : bool, ?restart : bool,
 ?restart_on_error : bool, ?buffer : float, ?max : float,
 string) -> source(audio=pcm(stereo), video=yuv420p('a),
midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `"input.external.ffmpeg"`)
- `show_command` (of type `bool`, which defaults to `false`)
- `restart` (of type `bool`, which defaults to `true`): restart on exit.
- `restart_on_error` (of type `bool`, which defaults to `false`): restart on exit with error.
- `buffer` (of type `float`, which defaults to `0.2`): Duration of the pre-buffered data.
- `max` (of type `float`, which defaults to `10.`): Maximum duration of the buffered data.
- `(unlabeled)` (of type `string`): ffmpeg options specifying the input

### `video.external.testsrc`

ffmpeg's test source video (useful for testing and debugging).

Type:
```
(?id : string, ?restart : bool, ?restart_on_error : bool,
 ?buffer : float, ?max : float, ?framerate : int) ->
source(audio=pcm(stereo), video=yuv420p('a), midi=none)
```

Arguments:

- `id` (of type `string`, which defaults to `"video.external.testsrc"`)
- `restart` (of type `bool`, which defaults to `true`): restart on exit.
- `restart_on_error` (of type `bool`, which defaults to `false`): restart on exit with error.
- `buffer` (of type `float`, which defaults to `0.2`): Duration of the pre-buffered data.
- `max` (of type `float`, which defaults to `10.`): Maximum duration of the buffered data.
- `framerate` (of type `int`, which defaults to `0`)

## Source / Visualization

## String

## System

### `file.cover`

Obtain cover-art for a file. An empty string is returned in case there is no such information.

Type:
```
(?id : string, string) -> string
```

Arguments:

- `id` (of type `string`, which defaults to `"file.cover"`)
- `(unlabeled)` (of type `string`): File from which the cover should be obtained

## Visualization

### `vumeter`

VU meter: display the audio volume (RMS in dB).

Type:
```
(?rms_min : float, ?rms_max : float, ?window : float,
 ?scroll : bool, source(audio='a, video='b, midi='c)) ->
source(audio='a, video='b, midi='c).{rms : (() -> float)}
```

Arguments:

- `rms_min` (of type `float`, which defaults to `-25.`): Minimal volume.
- `rms_max` (of type `float`, which defaults to `-5.`): Maximal volume.
- `window` (of type `float`, which defaults to `0.5`): Duration in seconds of volume computation.
- `scroll` (of type `bool`, which defaults to `false`): Update the display in the same line.
- `(unlabeled)` (of type `source(audio='a, video='b, midi='c)`)

