#if   !defined(__CORELINUXASSOCIATIVEITERATOR_HPP)
#define  __CORELINUXASSOCIATIVEITERATOR_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ASSOCIATIVEITERATOR_HPP)
#include <AssociativeIterator.hpp>
#endif

#if   !defined(__INVALIDITERATOREXCEPTION_HPP)
#include <InvalidIteratorException.hpp>
#endif

#if   !defined(__ITERATORBOUNDSEXCEPTION_HPP)
#include <IteratorBoundsException.hpp>
#endif

namespace   corelinux
{

   /**
   The CoreLinuxAssociativeIterator provides a way to access the elements 
   of any of the associative STL collections, by defining a 
   CoreLinuxAssociativeIterator with a CORELINUX_COLLECTION 
   nameAssociativeIterator definition, the KeyType and the Element Type.
   */

   template< class TraverseType, class KeyType, class ElementType >
      class CoreLinuxAssociativeIterator : 
         public AssociativeIterator<KeyType,ElementType>
      {
      public:

         //
         // Constructors and destructor
         //

                     /**
                     Default constructor
                     @exception InvalidIteratorException - the 
                     CoreLinuxAssociativeIterator requires being constructed 
                     with a valid collection
                     */

                     CoreLinuxAssociativeIterator( void ) 
                        throw(InvalidIteratorException)
                        :
                        AssociativeIterator<KeyType,ElementType>()
                     {
                        throw InvalidIteratorException(LOCATION);
                     }

                     /**
                     Initializing constructor
                     @param TraverseType aBegin first position
                     @param TraverseType aEnd last position
                     */

                     CoreLinuxAssociativeIterator( TraverseType aBegin,
                                        TraverseType aEnd )
                        :
                        AssociativeIterator<KeyType,ElementType>(),
                        theBegin( aBegin ),
                        theEnd( aEnd ),
                        theCurrent( theBegin )
                     {
                        ;  // do nothing
                     }

                     /**
                     Copy constructor
                     @param CoreLinuxAssociativeIterator const reference
                     */

                     CoreLinuxAssociativeIterator
                        ( 
                           const CoreLinuxAssociativeIterator &aRef 
                        )
                        :
                        AssociativeIterator<KeyType,ElementType>( aRef ),
                        theBegin( aRef.theBegin ),
                        theEnd( aRef.theEnd ),
                        theCurrent( aRef.theBegin )
                     {
                        ;  // do nothing
                     }

                     /// Destructor

         virtual     ~CoreLinuxAssociativeIterator( void )
         {
            theBegin = theEnd;  
            theCurrent = theEnd;
         }

         //
         // Operator overloads
         //

                  /**
                  Assignment operator
                  @param CoreLinuxAssociativeIterator const reference
                  @return CoreLinuxAssociativeIterator reference
                  */

                  CoreLinuxAssociativeIterator & operator=
                     ( const CoreLinuxAssociativeIterator & aRef )
                  {
                     theBegin = aRef.theBegin;
                     theEnd = aRef.theEnd;
                     theCurrent = theBegin;
                     return (*this);
                  }

                  /**
                  Equality operator
                  @param CoreLinuxAssociativeIterator const reference
                  @return bool - true if the respective positions
                  are equal.
                  */

                  bool  operator==
                     ( 
                        const CoreLinuxAssociativeIterator & aRef 
                     ) const
                  {
                     return (theBegin == aRef.theBegin &&
                             theEnd == aRef.theEnd);
                  }
                  

         //
         // Accessors
         //
                  /**
                  isValid implementation for determining
                  if the current position points to a valid
                  EntityType instance
                  @return bool true if valid, false otherwise
                  */

         virtual  bool  isValid( void ) const 
         {
            return !(theCurrent == theEnd);
         }

                  /**
                  getElement returns the ElementType instance
                  that is currently managed by the CoreLinuxAssociativeIterator
                  @return ElementType 
                  @exception IteratorBoundsException if the AssociativeIterator
                  is not positioned correctley.
                  */

         virtual  ElementType  getElement( void ) 
                         const throw(IteratorBoundsException) 
                  {
                     if( this->isValid() == false )
                     {
                        throw IteratorBoundsException(LOCATION);
                     }
                     else
                     {
                        ;  // do nothing
                     }
                     return (*theCurrent).second;
                  }

                  /**
                  getKey returns the KeyType instance
                  that is currently pointed to by the AssociativeIterator
                  @return KeyType 
                  @exception IteratorBoundsException if the AssociativeIterator
                  is not positioned correctly.
                  */

         virtual  KeyType  getKey( void ) 
                         const throw(IteratorBoundsException)
                  {
                     if( this->isValid() == false )
                     {
                        throw IteratorBoundsException(LOCATION);
                     }
                     else
                     {
                        ;  // do nothing
                     }
                     return (*theCurrent).first;
                  }

         //
         // Mutators
         //

                  /// Set AssociativeIterator to first element

         virtual  void  setFirst( void ) 
         {
            theCurrent = theBegin;
         }

                  /**
                  Set AssociativeIterator to next element
                  @exception IteratorBoundsException if attempt
                  to position past end of elements
                  */

         virtual  void  setNext( void ) 
                           throw(IteratorBoundsException) 
         {
            if( theCurrent != theEnd )
            {
               ++theCurrent;
            }
            else
            {
               throw IteratorBoundsException(LOCATION);
            }
         }

                  /**
                  Set AssociativeIterator to previous element
                  @exception IteratorBoundsException if attempt
                  to position before begining of elements
                  */

         virtual  void  setPrevious( void ) 
                           throw(IteratorBoundsException)
         {
            if( theCurrent != theBegin &&
                theBegin != theEnd )
            {
               --theCurrent;
            }
            else
            {
               throw IteratorBoundsException(LOCATION);
            }
         }

                  /// Set AssociativeIterator to last element

         virtual  void  setLast( void ) 
                        throw(IteratorBoundsException)
         {
            theCurrent = theEnd;
            setPrevious();
         }

      //
      // Protected methods
      //

      protected:

      //
      // Protected members
      //

      protected:

                  /// The first position

                  TraverseType   theBegin;

                  /// The last position

                  TraverseType   theEnd;

                  /// The current position

                  TraverseType   theCurrent;
   
      };
}

#endif   // if !defined(__CORELINUXASSOCIATIVEITERATOR_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/



