#if   !defined(__Select_HPP)
#define __Select_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__VECTOR_HPP)
#include <corelinux/Vector.hpp>
#endif

#if   !defined(__SUBJECTOBSERVER_HPP)
#include <SubjectObserver.hpp>
#endif

DECLARE_CLASS( Select );

/**
Select provides support for selecting a sentence from a list.
When this occurs, it fires off an event with a SelectionMemento
*/

class Select : public SubjectObserver
{
   CORELINUX_VECTOR(  string ,  ListEntries );

public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        Select( void );   

                        /// Virtual destructor

   virtual              ~Select( void );   

   //
   // Operator overloads
   //

            /// Equality operator

            bool operator==( SelectCref ) const;

   //
   // Accessors
   //

   //
   // Mutators
   //

            /// Returns true if selection was made

            bool  getSelection( void );

            /**
            Called by subject when there is a change and this
            observer is in the interested observer list.
            @param Event pointer to event
            */

   virtual  void  event( CORELINUX( Event<corelinux::Identifier> ) * ) throw ( CORELINUX(NullPointerException) );


protected:

                     /// Copy constructor
                  
                     Select( SelectCref ) throw ( CORELINUX( Assertion ) );

            /// Assignment operator
         
            SelectRef  operator=( SelectCref ) throw ( CORELINUX( Assertion ) );


private:

            /// The list of entries

            ListEntries    theCurrentList;


};

#endif // if !defined(__SELECT_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/



