/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__ENGINEBRIDGE_HPP)
#include <EngineBridge.hpp>
#endif

#if   !defined(__ENGINE_HPP)
#include <Engine.hpp>
#endif 

using namespace corelinux;

//
// Default constructor is protected and
// will except as well
//

EngineBridge::EngineBridge( void ) throw(Assertion)
   :
   Bridge<EnginePtr>()
{
   ;  // do nothing
}

//
// Copy constructor invalid as well
//

EngineBridge::EngineBridge( EngineBridgeCref aRef ) throw(Assertion)
   :
   Bridge<EnginePtr>( aRef )
{
   ;  // do nothing
}

//
// Default constructor requires Engine
//

EngineBridge::EngineBridge( EnginePtr aPtr ) throw(Exception)
   :
   Bridge<EnginePtr>(aPtr)
{
   ;  // do nothing
}

//
// Destructor
//

EngineBridge::~EngineBridge( void )
{
   ;  // do nothing, Bridge handles implementation
}

//
// Assignment invokes Bridge.setImplementation which calls
// our implementation of cloneImplementation
//

EngineBridgeRef   EngineBridge::operator=( EngineBridgeCref aRef ) 
   throw(Exception)
{
   upgradeEngine( aRef.getImplementation() );
   return (*this);
}

//
// Equality operator, here we check if the engine cylinders are
// equal.
//
         
bool     EngineBridge::operator==( EngineBridgeCref aRef ) const
{
   return (this->getCylinders() == aRef.getCylinders());
}

//
// Accessor returns the cylinder count. We use RTTI to
// convert the CoreLinuxObjectPtr to EnginePtr
//

CylindersCref EngineBridge::getCylinders( void ) const
{
   return getImplementation()->getCylinders();
}

//
// Upgrade the engine if not downsizing
//

void  EngineBridge::upgradeEngine( EnginePtr aPtr ) 
                        throw( Exception )
{
   if( aPtr == NULLPTR )
   {
      throw Exception("Invalid Engine.", LOCATION);
   }
   else if( aPtr->getCylinders() < this->getCylinders() )
   {
      throw Exception("Can't upgrade to smaller engine!",LOCATION);
   }
   else
   {
      setImplementation(aPtr);
   }
}


//
// The cloneImplementation call from Bridge<EnginePtr>
//

EnginePtr   EngineBridge::cloneImplementation( EnginePtr aPtr ) 
                  throw( Exception )
{
   if( aPtr == NULLPTR )
   {
      throw Exception("Invalid Engine.", LOCATION);
   }
   else
   {
      ;  // do nothing
   }
   return aPtr->clone();
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.3 $
   $Date: 2000/02/11 03:22:19 $
   $Locker:  $
*/



