#if   !defined(__EQUIPMENT_HPP)
#define  __EQUIPMENT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   


#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__TRANSPARENTCOMPONENT_HPP)
#include <TransparentComponent.hpp>
#endif

#if   !defined(__COMPOSITEEXCEPTION_HPP)
#include <CompositeException.hpp>
#endif

#if   !defined(__INVALIDCOMPOSITEEXCEPTION_HPP)
#include <InvalidCompositeException.hpp>
#endif


#include <string>

DECLARE_CLASS( Equipment );

/// Define domain types

DECLARE_TYPE( CORELINUX(Dword), Watt );
DECLARE_TYPE( std::string, Name );
/**
Equipment defines an interface in the part-whole hierarchy. We use
the transparent component because we don't want to differentiate
types at run time.
*/

class Equipment : public CORELINUX(TransparentComponent<EquipmentPtr>)
{
public:

   //
   // Constructors and Destructors
   //
                  /// Copy constructor

                  Equipment( EquipmentCref );

                  /// Virtual destructor

   virtual        ~Equipment( void );

   //
   // Operators
   //
            /// Equal if theName == theName

            bool        operator==( EquipmentCref ) const;

   //
   // Accessors
   //
            /// Return the components name

            NameCref    getName( void ) const;

            /// Return the power requirement

   virtual  Watt        getPower( void ) = 0;


protected:
                        /// Default constructor not allowed

                        Equipment( void ) 
                           throw(CORELINUX(CompositeException));

                        /// Always requires a name in derivations

                        Equipment( NameCref );

            /// Assignment operator can't overwrite name

            EquipmentRef   operator=( EquipmentCref )
                              throw(CORELINUX(CompositeException));
private:

            /// The equipments name

            Name     theName;
};

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:21 $
   $Locker:  $
*/

