package net.noderunner.amazon.s3;

import static org.junit.Assert.assertEquals;

import java.util.HashMap;
import java.util.Map;

import net.noderunner.amazon.s3.Bucket;
import net.noderunner.amazon.s3.CallingFormat;

import org.apache.commons.httpclient.URI;
import org.junit.Test;

public class CallingFormatTest {

	@Test
	public void testCalling() throws Exception {
		Bucket bucket = new Bucket("bucket");
		String key = "/HI";
		Map<String, String> args = new HashMap<String, String>();
		args.put("one", "1");
		URI uri;
		uri = CallingFormat.PATH.getURI(true, "foo", 444, bucket, key, args);
		assertEquals("https://foo:444/bucket/%2FHI?one=1", uri.toString());
		uri = CallingFormat.SUBDOMAIN.getURI(true, "foo", 444, bucket, key, args);
		assertEquals("https://bucket.foo:444/%2FHI?one=1", uri.toString());
	}
	
}
