/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http.servlet;

import junit.framework.TestCase;

/**
 * @author Elias Ross
 */
public class BasicHttpSessionTest extends TestCase {

	BasicHttpSession s = new BasicHttpSession();
	
	/**
	 * Test this class.
	 */
	public void testThis() {
		assertEquals(null, s.getAttribute("foo"));
		assertEquals(false, s.getAttributeNames().hasMoreElements());
		assertEquals(true, s.getCreationTime() != 0);
		assertNotNull(s.getId());
		assertEquals(null, s.getServletContext());
		assertEquals(null, s.getSessionContext());
		assertEquals(null, s.getValue("foo"));
		assertEquals(0, s.getValueNames().length);
		s.invalidate();
		assertEquals(true, s.isNew());
		s.putValue("foo", "bar");
		s.removeAttribute("foo");
		assertEquals("bar", s.getValue("foo"));
		assertEquals("foo", s.getValueNames()[0]);
		s.removeValue("foo");
		s.setAttribute("foo", "bar");
		assertEquals("bar", s.getAttribute("foo"));
		s.setMaxInactiveInterval(1000);
		assertEquals(1000, s.getMaxInactiveInterval());
	}

}
