/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * This interface defines an Xml-Rpc struct object.  This is being used,
 * since Java does not (for some reason) have a java.util.Pair or somesuch
 * object.
 *
 * @author Elias Ross
 * @version 1.0
 */

public interface StructPair {

	/**
	 * Gets the name, as it appears between the &lt;name&gt; tags.
	 * @return name
	 */
	String getName();

	/**
	 * Gets the value.
	 * @return value, which can be of any valid Xml-Rpc type
	 */
	Object getValue(); 
}
