/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io;

import java.util.Hashtable;

public class DateParser {
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minute;
    protected int second;
    protected int milli;
    protected static int tz_offset;
    private static Hashtable timezones;
    private int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private String[] month_shorts = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static long julianDayOffset;
    private static int millisPerHour;
    private static int millisPerDay;
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final String[] wtb;
    private static final int[] ttb;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;

    DateParser(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 1583 || n2 < 0 || n2 > 11 || n3 < 0 || n3 > this.days_in_month[n2] && (n2 != 1 || n3 != 29 || n % 4 != 0) || n4 < 0 || n4 > 23 || n5 < 0 || n5 > 59 || n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException();
        }
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.milli = 0;
    }

    DateParser(String string) {
        this.internalParse(string);
    }

    static void setTimeZone(String string) {
        if (timezones.get(string) == null) {
            return;
        }
        tz_offset = (Integer)timezones.get(string);
    }

    public static long parse(String string) {
        return new DateParser(string).getTime();
    }

    int getYear() {
        return this.year;
    }

    int getMonth() {
        return this.month;
    }

    int getDay() {
        return this.day;
    }

    int getHour() {
        return this.hour;
    }

    int getMinute() {
        return this.minute;
    }

    int getSecond() {
        return this.second;
    }

    long getTime() {
        long l = this.computeJulianDay(this.year, this.month, this.day);
        long l2 = this.julianDayToMillis(l);
        int n = 0;
        n += this.hour;
        n *= 60;
        n += this.minute;
        n *= 60;
        n += this.second;
        n *= 1000;
        return l2 + (long)(n += this.milli) - (long)tz_offset;
    }

    private final long computeJulianDay(int n, int n2, int n3) {
        boolean bl = n % 4 == 0;
        int n4 = n - 1;
        long l = 365L * (long)n4 + DateParser.floorDivide(n4, 4L) + 1721423L;
        bl = bl && (n % 100 != 0 || n % 400 == 0);
        l += DateParser.floorDivide(n4, 400L) - DateParser.floorDivide(n4, 100L) + 2L;
        l += bl ? (long)LEAP_NUM_DAYS[n2] : (long)NUM_DAYS[n2];
        return l += (long)n3;
    }

    private static final long floorDivide(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    private long julianDayToMillis(long l) {
        return (l - julianDayOffset) * (long)millisPerDay;
    }

    private void internalParse(String string) {
        block40: {
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            int n9 = -1;
            int n10 = -1;
            int n11 = 0;
            if (string != null) {
                int n12 = string.length();
                block0: while (n8 < n12) {
                    int n13;
                    n7 = string.charAt(n8);
                    ++n8;
                    if (n7 <= 32 || n7 == 44) continue;
                    if (n7 == 40) {
                        n13 = 1;
                        while (n8 < n12) {
                            n7 = string.charAt(n8);
                            ++n8;
                            if (n7 == 40) {
                                ++n13;
                                continue;
                            }
                            if (n7 != 41 || --n13 > 0) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (48 <= n7 && n7 <= 57) {
                        n9 = n7 - 48;
                        while (n8 < n12) {
                            char c = string.charAt(n8);
                            n7 = c;
                            if ('0' > c || n7 > 57) break;
                            n9 = n9 * 10 + n7 - 48;
                            ++n8;
                        }
                        if (n11 == 43 || n11 == 45 && n >= 0) {
                            n9 = n9 < 24 ? (n9 *= 60) : n9 % 100 + n9 / 100 * 60;
                            if (n11 == 43) {
                                n9 = -n9;
                            }
                            if (n10 != 0 && n10 != -1) break block40;
                            n10 = n9;
                        } else if (n9 >= 70) {
                            if (n >= 0 || n7 > 32 && n7 != 44 && n7 != 47 && n8 < n12) break block40;
                            n = n9 < 100 ? n9 + 1900 : n9;
                        } else if (n7 == 58) {
                            if (n4 < 0) {
                                n4 = (byte)n9;
                            } else {
                                if (n5 >= 0) break block40;
                                n5 = (byte)n9;
                            }
                        } else if (n7 == 47) {
                            if (n2 < 0) {
                                n2 = (byte)(n9 - 1);
                            } else {
                                if (n3 >= 0) break block40;
                                n3 = (byte)n9;
                            }
                        } else {
                            if (n8 < n12 && n7 != 44 && n7 > 32 && n7 != 45) break block40;
                            if (n4 >= 0 && n5 < 0) {
                                n5 = (byte)n9;
                            } else if (n5 >= 0 && n6 < 0) {
                                n6 = (byte)n9;
                            } else {
                                if (n3 >= 0) break block40;
                                n3 = (byte)n9;
                            }
                        }
                        n11 = 0;
                        continue;
                    }
                    if (n7 == 47 || n7 == 58 || n7 == 43 || n7 == 45) {
                        n11 = n7;
                        continue;
                    }
                    n13 = n8 - 1;
                    while (n8 < n12 && (65 <= (n7 = (int)string.charAt(n8)) && n7 <= 90 || 97 <= n7 && n7 <= 122)) {
                        ++n8;
                    }
                    if (n8 <= n13 + 1) break block40;
                    int n14 = wtb.length;
                    while (--n14 >= 0) {
                        if (!wtb[n14].regionMatches(true, 0, string, n13, n8 - n13)) continue;
                        int n15 = ttb[n14];
                        if (n15 == 0) break;
                        if (n15 == 1) {
                            if (n4 <= 12 && n4 >= 1) {
                                if (n4 >= 12) break;
                                n4 += 12;
                                break;
                            }
                            break block40;
                        }
                        if (n15 == 14) {
                            if (n4 <= 12 && n4 >= 1) {
                                if (n4 != 12) break;
                                n4 = 0;
                                break;
                            }
                            break block40;
                        }
                        if (n15 <= 13) {
                            if (n2 < 0) {
                                n2 = (byte)(n15 - 2);
                                break;
                            }
                            break block40;
                        }
                        n10 = n15 - 10000;
                        break;
                    }
                    if (n14 >= 0) {
                        n11 = 0;
                        continue;
                    }
                    break block40;
                }
                if (n >= 1583 && n2 >= 0 && n3 >= 0) {
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    this.year = n;
                    this.month = n2;
                    this.day = n3;
                    this.hour = n4;
                    this.minute = n5;
                    this.second = n6;
                    this.milli = 0;
                    return;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        julianDayOffset = 2440588L;
        millisPerHour = 3600000;
        millisPerDay = 24 * millisPerHour;
        wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
        NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        timezones = new Hashtable();
        timezones.put("GMT", new Integer(0 * millisPerHour));
        timezones.put("UT", new Integer(0 * millisPerHour));
        timezones.put("UTC", new Integer(0 * millisPerHour));
        timezones.put("PST", new Integer(-8 * millisPerHour));
        timezones.put("PDT", new Integer(-7 * millisPerHour));
        timezones.put("JST", new Integer(9 * millisPerHour));
        tz_offset = (Integer)timezones.get("GMT");
    }
}

