/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me;

import com.sun.cdc.i18n.Helper;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class UniversalOutputStream
extends OutputStream
implements DataOutput {
    private Writer writer;
    private boolean trouble = false;
    private boolean flushing = false;

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c >>> 0 & 0xFF);
        }
    }

    public void writeUTF(String string) throws IOException {
        UniversalOutputStream.writeUTF(string, this);
    }

    static int writeUTF(String string, DataOutput dataOutput) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
        for (int i = 0; i < n; ++i) {
            c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        dataOutput.write(byArray);
        return n2 + 2;
    }

    public void writeBytes(String string) throws IOException {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        this.writer = Helper.getStreamWriter(this, string);
    }

    public void flush() throws IOException {
        if (this.writer != null && !this.flushing) {
            this.flushing = true;
            this.writer.flush();
            this.flushing = false;
        }
    }

    public void close() throws IOException {
        this.flush();
    }

    public synchronized void print(String string) {
        if (this.writer == null) {
            this.writer = Helper.getStreamWriter(this);
        }
        if (string == null) {
            string = "null";
        }
        try {
            this.writer.write(string);
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this.trouble;
    }

    public synchronized void print(char[] cArray) {
        this.print(new String(cArray));
    }

    public void println() {
        this.print("\n");
    }

    public void print(Object object) {
        this.print(String.valueOf(object));
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(int n) {
        this.print(String.valueOf(n));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(boolean bl) {
        this.print(bl ? "true" : "false");
    }

    public synchronized void println(Object object) {
        this.print(object);
        this.println();
    }

    public synchronized void println(String string) {
        this.print(string);
        this.println();
    }

    public synchronized void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public synchronized void println(char c) {
        this.print(c);
        this.println();
    }

    public synchronized void println(int n) {
        this.print(n);
        this.println();
    }

    public synchronized void println(long l) {
        this.print(l);
        this.println();
    }

    public synchronized void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void seek(long l) throws IOException, IllegalAccessException {
        throw new IllegalAccessException();
    }

    public void setTimeout(int n) throws IOException {
    }
}

