/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.file;

import com.sun.cdc.io.j2me.file.ProtocolNative;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;

public class Protocol
extends ProtocolNative {
    private FileInputStream fis;
    private String _directory_;
    private String _selection_;

    private void setDirectory(String string) {
        this._directory_ = string.length() == 0 ? "" : (!string.endsWith("/") ? string + "/" : string);
        this.setProtocolBaseDirectory(this._directory_);
    }

    protected String getDirectory() {
        return this._directory_;
    }

    public String formName(String string) {
        return this.getDirectory() + string;
    }

    public Connection prim_openProtocol(String string, String string2, int n) throws IOException {
        this.setDirectory("");
        if (this.prim_exists(string) && this.prim_isDirectory(string)) {
            this.setDirectory(string);
            this.setSelection(null);
        } else {
            Object object;
            if (!this.prim_exists(string) && !this.writing) {
                throw new ConnectionNotFoundException("No such file " + string);
            }
            int n2 = string.lastIndexOf(47);
            if (n2 == -1) {
                this.setDirectory("");
                this.setSelection(string);
            } else {
                this.setDirectory(string.substring(0, n2 + 1));
                object = string.substring(n2 + 1);
                if (((String)object).length() > 0) {
                    this.setSelection((String)object);
                }
            }
            if (n != 1) {
                this.prim_canWrite();
            } else if ((n == 1 || n == 3) && (object = System.getSecurityManager()) != null && string != null) {
                ((SecurityManager)object).checkRead(string);
            }
        }
        return this;
    }

    public void prim_closeProtocol() throws IOException {
        this.prim_close();
        this._directory_ = null;
        this._selection_ = null;
    }

    public void prim_realOpen() throws IOException {
        String string = this.formName(this.prim_getSelectionName());
        this.fis = new FileInputStream(string);
    }

    void prim_close() throws IOException {
        if (this.fis != null) {
            FileInputStream fileInputStream = this.fis;
            this.fis = null;
            fileInputStream.close();
        }
    }

    private void setSelection(String string) throws IOException {
        this._selection_ = string;
        if (string == null) {
            this.prim_close();
        }
    }

    public void prim_clearSelection() throws IOException {
        this.setSelection(null);
    }

    public boolean prim_isSelected() {
        return this._selection_ != null;
    }

    public String prim_getSelectionName() {
        return this._selection_;
    }

    public int prim_getSelectionNumber() throws IOException {
        try {
            return Integer.parseInt(this.prim_getSelectionName());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("NumberFormatException");
        }
    }

    public void prim_findFirstItemAndSelect() throws IOException {
        this.setSelection(this.prim_findFirstItem());
    }

    public void prim_findItemAndSelect(String string) throws IOException {
        this.setSelection(this.prim_findItem(string));
    }

    public void prim_findItemAndSelectByInt(int n) throws IOException {
        this.setSelection(this.prim_findItem(String.valueOf(n)));
    }

    public void prim_findItemAfterSelectionAndSelect() throws IOException {
        this.setSelection(this.prim_findItemAfter(this.prim_getSelectionName()));
    }

    public void prim_createAndSelect() throws IOException {
        this.setSelection(this.prim_create());
    }

    public void prim_createFileAndSelect(String string) throws IOException {
        this.setSelection(this.prim_createFile(string));
    }

    public void prim_createFileAndSelectByInt(int n) throws IOException {
        this.setSelection(this.prim_createFile(String.valueOf(n)));
    }

    public void prim_createDirectoryAndSelect(String string) throws IOException {
        this.setSelection(this.prim_createDirectory(string));
    }

    public boolean prim_deleteItem() {
        return this.prim_deleteItem(this.prim_getSelectionName());
    }

    public boolean prim_renameFile(String string) {
        return this.prim_renameItem(this.prim_getSelectionName(), string);
    }

    public boolean prim_renameFileByInt(int n) {
        return this.prim_renameItem(this.prim_getSelectionName(), String.valueOf(n));
    }

    public boolean prim_renameDirectory(String string) {
        return this.prim_renameItem(this.prim_getSelectionName(), string);
    }

    public long prim_lengthOf() throws IOException {
        return this.prim_lengthOf(this.prim_getSelectionName());
    }

    public void prim_setLength(long l) throws IOException {
        throw new RuntimeException("prim_setLength not implemented");
    }

    public long prim_timeOf() throws IOException {
        return this.prim_timeOf(this.prim_getSelectionName());
    }

    public boolean prim_exists() {
        return this.prim_exists(this.prim_getSelectionName());
    }

    public boolean prim_isDirectory() {
        return this.prim_isDirectory(this.prim_getSelectionName());
    }

    public boolean prim_canRead() {
        return this.prim_canRead(this.prim_getSelectionName());
    }

    public boolean prim_canWrite() {
        return this.prim_canWrite(this.prim_getSelectionName());
    }

    public boolean prim_setReadable(boolean bl) {
        return this.prim_setReadable(this.prim_getSelectionName(), bl);
    }

    public boolean prim_setWritable(boolean bl) {
        return this.prim_setWritable(this.prim_getSelectionName(), bl);
    }

    String prim_findFirstItem() {
        File file = new File(this.getDirectory());
        if (!file.exists()) {
            return null;
        }
        String[] stringArray = file.list();
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    String prim_findItem(String string) {
        File file = new File(this.formName(string));
        if (!file.exists()) {
            return null;
        }
        return string;
    }

    String prim_findItemAfter(String string) {
        File file = new File(this.getDirectory());
        if (!file.exists()) {
            return null;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length - 2; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[2];
        }
        return null;
    }

    public long prim_availableSpace() {
        return Long.MAX_VALUE;
    }

    public int prim_countItems() {
        File file = new File(this.getDirectory());
        if (!file.exists()) {
            return 0;
        }
        String[] stringArray = file.list();
        return stringArray.length;
    }

    String prim_create() throws IOException {
        File file = new File(this.getDirectory());
        File file2 = File.createTempFile("tmp", null, file);
        return file2.getName();
    }

    String prim_createFile(String string) throws IOException {
        if (this.prim_exists(string)) {
            throw new IOException("prim_createFile - file exists" + string);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.formName(string));
        fileOutputStream.close();
        return string;
    }

    String prim_createDirectory(String string) throws IOException {
        if (new File(this.formName(string)).mkdir()) {
            return string;
        }
        throw new IOException("Could not prim_createDirectory()");
    }

    boolean prim_deleteItem(String string) {
        boolean bl = new File(this.formName(string)).delete();
        if (bl && this.prim_exists(string)) {
            throw new RuntimeException("Internal error - prim_deleteItem did not delete");
        }
        return bl;
    }

    boolean prim_renameItem(String string, String string2) {
        File file = new File(string2);
        return new File(this.formName(string)).renameTo(file);
    }

    long prim_lengthOf(String string) throws IOException {
        if (this.fis != null) {
            throw new IOException();
        }
        return new File(this.formName(string)).length();
    }

    long prim_timeOf(String string) {
        if (this.fis != null) {
            return System.currentTimeMillis();
        }
        return new File(this.formName(string)).lastModified();
    }

    boolean prim_exists(String string) {
        return new File(this.formName(string)).exists();
    }

    boolean prim_isDirectory(String string) {
        return new File(this.formName(string)).isDirectory();
    }

    boolean prim_canRead(String string) {
        return new File(this.formName(string)).canRead();
    }

    boolean prim_canWrite(String string) {
        return new File(this.formName(string)).canWrite();
    }

    boolean prim_setReadable(String string, boolean bl) {
        return false;
    }

    boolean prim_setWritable(String string, boolean bl) {
        return false;
    }

    public void prim_seek(long l) throws IOException {
        throw new IOException();
    }

    public long prim_getPosition() throws IOException {
        throw new IOException();
    }

    public int prim_read() throws IOException {
        return this.fis.read();
    }

    public int prim_readBytes(byte[] byArray, int n, int n2) throws IOException {
        return this.fis.read(byArray, n, n2);
    }

    public void prim_write(int n) throws IOException {
        throw new IOException();
    }

    public void prim_writeBytes(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException();
    }
}

