/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import sun.misc.CVM;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    public synchronized void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
            CVM.copyByteArray(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n3)];
            CVM.copyByteArray(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        CVM.copyByteArray(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public void close() throws IOException {
    }
}

