/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.CVM;
import sun.security.util.SecurityConstants;

public final class Class
implements Serializable {
    private int classBlockPointer;
    private ClassLoader loader;
    private static Map classToSigners;
    private static ProtectionDomain allPermDomain;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static LoadingList loadingList;

    private Class() {
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return Class.forName0(string, true, ClassLoader.getCallerClassLoader());
    }

    public static Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2;
        SecurityManager securityManager;
        if (classLoader == null && (securityManager = System.getSecurityManager()) != null && (classLoader2 = ClassLoader.getCallerClassLoader()) != null) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return Class.forName0(string, bl, classLoader);
    }

    private static native Class forName0(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        }
        int n = 1536;
        if ((this.getModifiers() & n) != 0 || this.isPrimitive()) {
            throw new InstantiationException(this.getName() + " is an interface or abstract");
        }
        try {
            CVM.setContextArtificial();
            Constructor constructor = this.getConstructor0(new Class[0], 1);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InstantiationException(this.getName() + " has no appropriate constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw CVM.throwLocalException(invocationTargetException.getTargetException());
        }
    }

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class var1);

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public native boolean isArray();

    public native boolean isPrimitive();

    public native String getName();

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = this.getClassLoader0();
        if (classLoader2 == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != classLoader2 && !classLoader2.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return classLoader2;
    }

    native ClassLoader getClassLoader0();

    public native Class getSuperclass();

    public Package getPackage() {
        return Package.getPackage(this);
    }

    public native Class[] getInterfaces();

    public native Class getComponentType();

    public native int getModifiers();

    private static void createClassToSignersMap() {
        WeakHashMap weakHashMap = new WeakHashMap(11);
        classToSigners = Collections.synchronizedMap(weakHashMap);
    }

    public Object[] getSigners() {
        Object[] objectArray;
        if (classToSigners == null) {
            Class.createClassToSignersMap();
        }
        if ((objectArray = (Object[])classToSigners.get(this)) == null) {
            return null;
        }
        return (Object[])objectArray.clone();
    }

    void setSigners(Object[] objectArray) {
        if (classToSigners == null) {
            Class.createClassToSignersMap();
        }
        classToSigners.put(this, objectArray);
    }

    public native Class getDeclaringClass();

    public Class[] getClasses() {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        Class[] classArray = (Class[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList arrayList = new ArrayList();
                for (Class clazz = Class.this; clazz != null; clazz = clazz.getSuperclass()) {
                    Class[] classArray = clazz.getDeclaredClasses();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (!Modifier.isPublic(classArray[i].getModifiers())) continue;
                        arrayList.add(classArray[i]);
                    }
                }
                return arrayList.toArray(new Class[0]);
            }
        });
        return classArray;
    }

    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getFields0(0);
    }

    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getMethods0(0);
    }

    public Constructor[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getConstructors0(0);
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getField0(string, 0);
    }

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getMethod0(string, classArray, 0);
    }

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, ClassLoader.getCallerClassLoader());
        return this.getConstructor0(classArray, 0);
    }

    public Class[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getDeclaredClasses0();
    }

    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getFields0(1);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getMethods0(1);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getConstructors0(1);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getField0(string, 1);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getMethod0(string, classArray, 1);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, ClassLoader.getCallerClassLoader());
        return this.getConstructor0(classArray, 1);
    }

    public InputStream getResourceAsStream(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = CVM.callerCLIsMIDCLs() ? ClassLoader.getCallerClassLoader() : this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        string = this.resolveName(string);
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_PD_PERMISSION);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions permissions = new Permissions();
                permissions.add(SecurityConstants.ALL_PERMISSION);
                allPermDomain = new ProtectionDomain(null, permissions);
            }
            protectionDomain = allPermDomain;
        }
        return protectionDomain;
    }

    private native ProtectionDomain getProtectionDomain0();

    static native Class getPrimitiveClass(String var0);

    private void checkMemberAccess(int n, ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string;
            int n2;
            securityManager.checkMemberAccess(this, n);
            ClassLoader classLoader2 = this.getClassLoader0();
            if (!(classLoader == null || classLoader == classLoader2 || classLoader2 != null && classLoader2.isAncestor(classLoader) || (n2 = (string = this.getName()).lastIndexOf(46)) == -1)) {
                securityManager.checkPackageAccess(string.substring(0, n2));
            }
        }
    }

    private String resolveName(String string) {
        if (string == null) {
            return string;
        }
        if (!string.startsWith("/")) {
            Class clazz = this;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            String string2 = clazz.getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string = string2.substring(0, n).replace('.', '/') + "/" + string;
            }
        } else {
            string = string.substring(1);
        }
        return string;
    }

    private native Field[] getFields0(int var1);

    private native Method[] getMethods0(int var1);

    private native Constructor[] getConstructors0(int var1);

    private native Field getField0(String var1, int var2);

    private native Method getMethod0(String var1, Class[] var2, int var3);

    private native Constructor getConstructor0(Class[] var1, int var2) throws NoSuchMethodException;

    private native Class[] getDeclaredClasses0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return Class.desiredAssertionStatus0(this);
        }
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            return classLoader.classAssertionStatus == null ? Class.desiredAssertionStatus0(this) : classLoader.desiredAssertionStatus(this.getName());
        }
    }

    private static native boolean desiredAssertionStatus0(Class var0);

    private native boolean checkInitializedFlag();

    private native boolean checkInitializingFlag(boolean var1);

    private native boolean checkErrorFlag();

    private native void setInitializedFlag();

    private native void setInitializingFlag();

    private native void setErrorFlag();

    private native void clearInitializingFlag();

    private native void clearSuperClassesLoadedFlag();

    native void addToLoaderCache(ClassLoader var1);

    private native int getClassTypeID();

    native boolean superClassesLoaded();

    private native int getSuperClassTypeID();

    private native String getSuperClassName(ClassLoader var1);

    private native int getNumInterfaces();

    private native int getInterfaceTypeID(int var1);

    private native String getInterfaceName(int var1, ClassLoader var2);

    private native void linkSuperClasses();

    private native void notifyClassLoaded();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStaticInitializers() throws Throwable {
        Throwable throwable;
        boolean bl;
        block32: {
            CVM.disableRemoteExceptions();
            bl = !CVM.maskInterrupts();
            Class clazz = this;
            synchronized (clazz) {
                block31: {
                    while (this.checkInitializingFlag(false)) {
                        try {
                            this.wait(0L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.checkInitializingFlag(true) && !this.checkInitializedFlag()) break block31;
                    return;
                }
                if (this.checkErrorFlag()) {
                    throw new NoClassDefFoundError(this.getName());
                }
                this.setInitializingFlag();
            }
            clazz = this.getSuperclass();
            if (clazz != null && !clazz.checkInitializedFlag()) {
                try {
                    clazz.runStaticInitializers();
                }
                catch (Throwable throwable2) {
                    Class clazz2 = this;
                    synchronized (clazz2) {
                        this.clearInitializingFlag();
                        this.setErrorFlag();
                        this.notifyAll();
                    }
                    throw throwable2;
                }
            }
            throwable = null;
            try {
                CVM.executeClinit(this);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
            CVM.freeClinit(this);
            if (throwable == null) {
                Class clazz3 = this;
                synchronized (clazz3) {
                    this.clearInitializingFlag();
                    this.setInitializedFlag();
                    this.notifyAll();
                    return;
                }
            }
            if (throwable instanceof Error) break block32;
            try {
                throwable = new ExceptionInInitializerError(throwable);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
            }
        }
        Class clazz = this;
        synchronized (clazz) {
            this.clearInitializingFlag();
            this.setErrorFlag();
            this.notifyAll();
        }
        throw throwable;
        finally {
            if (bl) {
                CVM.unmaskInterrupts();
            }
            CVM.enableRemoteExceptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onLoadingList(int n) {
        Class clazz = LoadingList.class;
        synchronized (clazz) {
            LoadingList loadingList = Class.loadingList;
            while (loadingList != null) {
                if (loadingList.typeID == n && loadingList.loader == this.loader) {
                    return true;
                }
                loadingList = loadingList.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoadingList() {
        int n = this.getClassTypeID();
        if (this.onLoadingList(n)) {
            throw new ClassCircularityError(this.getName());
        }
        Class clazz = LoadingList.class;
        synchronized (clazz) {
            loadingList = new LoadingList(n, this.loader, loadingList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLoadingList() {
        Class clazz = LoadingList.class;
        synchronized (clazz) {
            int n = this.getClassTypeID();
            LoadingList loadingList = Class.loadingList;
            LoadingList loadingList2 = null;
            while (loadingList != null) {
                if (loadingList.typeID == n && loadingList.loader == this.loader) {
                    if (loadingList2 == null) {
                        Class.loadingList = loadingList.next;
                    } else {
                        loadingList2.next = loadingList.next;
                    }
                    return;
                }
                loadingList2 = loadingList;
                loadingList = loadingList.next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSuperClasses() {
        block16: {
            String string = null;
            int n = -1;
            try {
                int n2;
                this.addToLoadingList();
                string = this.getSuperClassName(this.loader);
                if (string != null) {
                    n = this.getSuperClassTypeID();
                    if (this.loader == null) {
                        ClassLoader.loadBootstrapClass(string);
                    } else {
                        Class clazz = this.loader.loadClass(string);
                        if (clazz.loader != this.loader) {
                            clazz.addToLoaderCache(this.loader);
                        }
                    }
                }
                int n3 = this.getNumInterfaces();
                for (n2 = 0; n2 < n3; ++n2) {
                    string = this.getInterfaceName(n2, this.loader);
                    if (string == null) continue;
                    n = this.getInterfaceTypeID(n2);
                    if (this.loader == null) {
                        ClassLoader.loadBootstrapClass(string);
                        continue;
                    }
                    Class clazz = this.loader.loadClass(string);
                    if (clazz.loader == this.loader) continue;
                    clazz.addToLoaderCache(this.loader);
                }
                this.linkSuperClasses();
                this.addToLoaderCache(this.loader);
                if (this.loader == null) break block16;
                n2 = 0;
                try {
                    this.loader.addClass(this);
                    n2 = 1;
                }
                finally {
                    if (n2 == 0) {
                        this.setErrorFlag();
                        this.clearSuperClassesLoadedFlag();
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.onLoadingList(n)) {
                    throw new ClassCircularityError(string);
                }
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            finally {
                this.removeFromLoadingList();
            }
        }
        this.notifyClassLoaded();
    }

    static {
        serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    }

    private static class LoadingList {
        int typeID;
        ClassLoader loader;
        LoadingList next;

        LoadingList(int n, ClassLoader classLoader, LoadingList loadingList) {
            this.typeID = n;
            this.loader = classLoader;
            this.next = loadingList;
        }
    }
}

