/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.sun.cdc.config.DynamicProperties;
import com.sun.cdc.config.PackageManager;
import com.sun.cdc.config.PropertyProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.CVM;
import sun.misc.Version;
import sun.net.InetAddressCachePolicy;
import sun.security.util.SecurityConstants;

public final class System {
    public static final InputStream in = System.nullInputStream();
    public static final PrintStream out = System.nullPrintStream();
    public static final PrintStream err = System.nullPrintStream();
    private static SecurityManager security = null;
    private static Properties props;
    private static Properties midpProps;

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        System.checkIO();
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        System.checkIO();
        System.setOut0(printStream);
    }

    public static void setErr(PrintStream printStream) {
        System.checkIO();
        System.setErr0(printStream);
    }

    private static void checkIO() {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager securityManager) {
        try {
            securityManager.checkPackageAccess("java.lang");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager0(securityManager);
    }

    private static synchronized void setSecurityManager0(final SecurityManager securityManager) {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (securityManager != null && securityManager.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
            });
        }
        security = securityManager;
        InetAddressCachePolicy.setIfNotSet(-1);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native long currentTimeMillis();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    private static native Properties initCldcMidpProperties(Properties var0);

    public static Properties getProperties() {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        DynamicProperties.addSnapshot(props);
        return props;
    }

    public static void setProperties(Properties properties) {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (properties == null) {
            properties = new Properties();
            System.initProperties(properties);
        }
        props = properties;
    }

    public static String getProperty(String string) {
        String string2;
        PropertyProvider propertyProvider;
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        if ((propertyProvider = DynamicProperties.get(string)) != null) {
            return propertyProvider.getValue(string, false);
        }
        if (CVM.isMIDPContext() && (string2 = midpProps.getProperty(string)) != null) {
            return string2;
        }
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        PropertyProvider propertyProvider;
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        if ((propertyProvider = DynamicProperties.get(string)) != null) {
            String string3 = propertyProvider.getValue(string, false);
            if (string3 == null) {
                return string2;
            }
            return string3;
        }
        return props.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPermission(new PropertyPermission(string, "write"));
        }
        midpProps.setProperty(string, string2);
        return (String)props.setProperty(string, string2);
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void load(String string) {
        Runtime.getRuntime().load0(System.getCallerClass(), string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary0(System.getCallerClass(), string);
    }

    public static native String mapLibraryName(String var0);

    private static InputStream nullInputStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static PrintStream nullPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    private static void initializeSystemClass() throws ClassNotFoundException {
        props = new Properties();
        System.initProperties(props);
        midpProps = new Properties();
        System.initCldcMidpProperties(midpProps);
        Version.init();
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fileInputStream));
        System.setOut0(new PrintStream(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fileOutputStream2, 128), true));
        PackageManager.init();
        Terminator.setup();
    }

    static native Class getCallerClass();
}

