/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.HeapIntBuffer;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    ByteBufferImpl parent;
    int[] array;
    boolean isDirect;
    boolean disposed = false;

    IntBuffer() {
    }

    public static IntBuffer wrap(int[] nArray, int n, int n2) {
        if (n < 0 || n > nArray.length || n2 < 0 || n2 > nArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        HeapIntBuffer heapIntBuffer = new HeapIntBuffer(nArray.length, nArray, 0);
        heapIntBuffer.position(n);
        heapIntBuffer.limit(n + n2);
        return heapIntBuffer;
    }

    public static IntBuffer wrap(int[] nArray) {
        return IntBuffer.wrap(nArray, 0, nArray.length);
    }

    public abstract IntBuffer slice();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public IntBuffer get(int[] nArray, int n, int n2) {
        IntBuffer.checkBounds(n, n2, nArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.copyToArray(nArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyToArray(int[] var1, int var2, int var3);

    public IntBuffer get(int[] nArray) {
        return this.get(nArray, 0, nArray.length);
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = intBuffer.limit - intBuffer.position;
        if (n > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        intBuffer.copyToIntBuffer(n, this);
        intBuffer.position += n;
        this.position += n;
        return this;
    }

    abstract void copyToIntBuffer(int var1, IntBuffer var2);

    abstract void copyFromHeapIntBuffer(IntBuffer var1, int var2);

    abstract void copyFromByteBufferAsIntBuffer(IntBuffer var1, int var2);

    abstract void copyFromDirectIntBuffer(IntBuffer var1, int var2);

    static void vanillaCopy(IntBuffer intBuffer, IntBuffer intBuffer2, int n) {
        for (int i = 0; i < n; ++i) {
            intBuffer2.put(intBuffer2.position + i, intBuffer.get(intBuffer.position + i));
        }
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        IntBuffer.checkBounds(n, n2, nArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.copyFromArray(nArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyFromArray(int[] var1, int var2, int var3);

    public final IntBuffer put(int[] nArray) {
        return this.put(nArray, 0, nArray.length);
    }

    public final boolean hasArray() {
        return this.array != null;
    }

    public final int[] array() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.IntBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntBuffer)) {
            return false;
        }
        IntBuffer intBuffer = (IntBuffer)object;
        if (this.remaining() != intBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = intBuffer.limit() - 1;
        while (n2 >= n) {
            int n4;
            int n5 = this.get(n2);
            if (n5 != (n4 = intBuffer.get(n3)) && (n5 == n5 || n4 == n4)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(Object object) {
        IntBuffer intBuffer = (IntBuffer)object;
        int n = this.position() + Math.min(this.remaining(), intBuffer.remaining());
        int n2 = this.position();
        int n3 = intBuffer.position();
        while (n2 < n) {
            int n4;
            int n5 = this.get(n2);
            if (n5 != (n4 = intBuffer.get(n3)) && (n5 == n5 || n4 == n4)) {
                if (n5 < n4) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - intBuffer.remaining();
    }
}

