/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.sun;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.GccCompatibleCCompiler;
import net.sf.antcontrib.cpptasks.sun.ForteCCLinker;

public abstract class ForteCompiler
extends GccCompatibleCCompiler {
    private String identifier;
    private File[] includePath;

    protected abstract String getForteCompilerName();

    protected abstract boolean isCPlusPlus();

    protected ForteCompiler(String command) {
        super(command, "-V", false, null, false, null);
    }

    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
        if (optimization != null && optimization.isSpeed()) {
            args.addElement("-xO2");
        }
        if (this.isCPlusPlus() && rtti != null) {
            if (rtti.booleanValue()) {
                args.addElement("-features=rtti");
            } else {
                args.addElement("-features=no%rtti");
            }
        }
        if (multithreaded) {
            args.addElement("-mt");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("-KPIC");
        }
    }

    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 1: 
            case 2: {
                args.addElement("+w");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                args.addElement("+w2");
            }
        }
    }

    public File[] getEnvironmentIncludePath() {
        if (this.includePath == null) {
            File compilerIncludeDir;
            File ccLoc = CUtil.getExecutableLocation(this.getForteCompilerName());
            if (ccLoc != null && (compilerIncludeDir = new File(new File(ccLoc, "../include").getAbsolutePath())).exists()) {
                this.includePath = new File[2];
                this.includePath[0] = compilerIncludeDir;
            }
            if (this.includePath == null) {
                this.includePath = new File[1];
            }
            this.includePath[this.includePath.length - 1] = new File("/usr/include");
        }
        return this.includePath;
    }

    public Linker getLinker(LinkType linkType) {
        return ForteCCLinker.getInstance().getLinker(linkType);
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }
}

