/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup PublicAPI libsyncml API
 * @ingroup PublicAPI
 * @brief The public part
 * 
 */
/**
 * @defgroup PublicObjectAPI libsyncml Object API
 * @ingroup PublicAPI
 * @brief The public part
 * 
 */
/**
 * @defgroup PublicLowLevelAPI Low Level API
 * @ingroup PublicAPI
 * @brief The public part
 * 
 */
/*@{*/

#ifndef _SYNCML_H
#define _SYNCML_H

#include <unistd.h>
#include <sys/types.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************
 * Defines
 *************************************************************/
#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/**************************************************************
 * Structs
 *************************************************************/
typedef struct SmlError SmlError;
typedef struct SmlTransport SmlTransport;
typedef struct SmlParser SmlParser;
typedef struct SmlAssembler SmlAssembler;
typedef struct SmlCommand SmlCommand;
typedef struct SmlLocation SmlLocation;
typedef struct SmlStatus SmlStatus;
typedef struct SmlSession SmlSession;
typedef struct SmlAnchor SmlAnchor;
typedef struct SmlPendingStatus SmlPendingStatus;
typedef struct SmlItem SmlItem;
typedef struct SmlDevInf SmlDevInf;
typedef struct SmlDevInfDataStore SmlDevInfDataStore;
typedef struct SmlDevInfContentType SmlDevInfContentType;
typedef struct SmlDevInfCTCap SmlDevInfCTCap;
typedef struct SmlDevInfProperty SmlDevInfProperty;
typedef struct SmlDevInfPropParam SmlDevInfPropParam;
typedef struct SmlNotification SmlNotification;
typedef struct SmlSanAlert SmlSanAlert;
typedef struct SmlMapItem SmlMapItem;
typedef struct SmlCred SmlCred;
typedef struct SmlChal SmlChal;
typedef struct SmlHeader SmlHeader;
typedef struct SmlTransportData SmlTransportData;
typedef struct SmlObject SmlObject;
typedef struct SmlManager SmlManager;
typedef struct SmlLink SmlLink;
typedef int SmlBool;

#include <libsyncml/sml_defines.h>
#include <libsyncml/sml_error.h>
#include <libsyncml/sml_manager.h>
#include <libsyncml/sml_session.h>
#include <libsyncml/sml_transport.h>
#include <libsyncml/sml_elements.h>
#include <libsyncml/sml_command.h>
#include <libsyncml/sml_devinf.h>
#include <libsyncml/sml_notification.h>
#include <libsyncml/sml_base64.h>
#include <libsyncml/sml_md5.h>

const char *smlGetLibraryVersion();
const char *smlGetLibrarySoName();

#ifdef __cplusplus
}
#endif

#endif

/*@}*/

/** @mainpage
 *
 * This library implements the following protocols:
 *
 *   - SyncML 1.0 Data Synchronization Protocol
 *   - SyncML 1.1 Data Synchronization Protocol
 *   - OMA DS 1.1
 *   - OMA DS 1.2
 *
 * The following transports are supported:
 *
 *   - HTTP client
 *   - HTTP server
 *   - OBEX client
 *   - OBEX server
 *
 * SANs for HTTP clients are not supported because HTTP OTA requires
 * direct GSM network access.
 *
 * XML and WBXML are both supported.
 */
