/*
 * Copyright (c) 2001-2003 The XDoclet team
 * All rights reserved.
 */
package xjavadoc;

import java.lang.reflect.Modifier;

/**
 * This implementation of XClass is used for classes that can't be resolved from
 * either source or classpath (binary classes). It's useful for XDocletImpl,
 * especially when classes refer to classes that are going to be generated by
 * XDocletImpl.
 *
 * @author    Ara Abrahamian
 * @author    Aslak Hellesy
 * @created   February 17, 2002
 */
final class UnknownClass extends AbstractClass
{

	public static int  instanceCount = 0;

	/**
	 * @param qualifiedName
	 * @todo                 We're setting super to java.lang.Object, but if an
	 *      instance represents an unknown interface, then the superclass should be
	 *      null. How do we know whether an instance represents a class or an
	 *      interface? (Aslak)
	 */
	public UnknownClass( XJavaDoc xJavaDoc, String qualifiedName )
	{
		super( xJavaDoc, null );
		setQualifiedName( qualifiedName );
		// We don't know what our superclass is, so we'll set it to java.lang.Object to avoid NPE.
		setSuperclass( "java.lang.Object" );

		addModifier( Modifier.PUBLIC );
		instanceCount++;
	}

	/**
	 * whether this class can be saved ( it cannot )
	 *
	 * @return   false since this class can not be saved
	 */
	public boolean isWriteable()
	{
		return false;
	}

	public boolean isPrimitive()
	{
		return false;
	}

	/**
	 * no op for sake of interface implementation
	 */
	public void setDirty()
	{
	}

	/**
	 * this class is not intended to be saved
	 *
	 * @return   always false
	 */
	public boolean saveNeeded()
	{
		return false;
	}

}
