
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file FixedTableModeAttributes.h
    \\brief Definition of FixedTableMode Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "FixedTableModeAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

FixedTableModeAttributes::FixedTableModeAttributes():
	levels_(ParameterManager::getIntArray("image_level_list")),
	indexes_(ParameterManager::getIntArray("image_index_list"))
	
	 
{
} 


FixedTableModeAttributes::~FixedTableModeAttributes()
{
	
}

    
void FixedTableModeAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "image_level_list", levels_, params);
	setAttribute(prefix, "image_index_list", indexes_, params);
	
	
}

void FixedTableModeAttributes::copy(const FixedTableModeAttributes& other)
{
	levels_ = other.levels_;
	indexes_ = other.indexes_;
	
} 


bool FixedTableModeAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void FixedTableModeAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void FixedTableModeAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " levels = " <<  levels_;
	out << " indexes = " <<  indexes_;
	
	out << "]" << "\n";
}

void FixedTableModeAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"image_level_list\":";
	niceprint(out,levels_);
	out << ", \"image_index_list\":";
	niceprint(out,indexes_);
	
}

static MagicsParameter<intarray> image_level_list("image_level_list", intarray(), "");
static MagicsParameter<intarray> image_index_list("image_index_list", intarray(), "");
