/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Evaluate the exponential function.
*
* @module @stdlib/math/base/special/fast/pow-int
*
* @example
* var pow = require( '@stdlib/math/base/special/fast/pow-int' );
*
* var v = pow( 2.0, 3 );
* // returns 8.0
*
* v = pow( 3.14, 0 );
* // returns 1.0
*
* v = pow( 2.0, -2 );
* // returns 0.25
*
* v = pow( 0.0, 0 );
* // returns 1.0
*
* v = pow( -3.14, 1 );
* // returns -3.14
*
* v = pow( NaN, 0 );
* // returns NaN
*/

// MODULES //

var pow = require( './pow.js' );


// EXPORTS //

module.exports = pow;
